# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dmarc_metrics_exporter',
 'dmarc_metrics_exporter.model',
 'dmarc_metrics_exporter.model.tests',
 'dmarc_metrics_exporter.tests']

package_data = \
{'': ['*']}

install_requires = \
['bite-parser>=0.1.1,<0.2.0',
 'dataclasses-serialization>=1.3.1,<2.0.0',
 'prometheus_client>=0.11.0,<0.12.0',
 'typing-extensions>=4.0.1,<5.0.0',
 'uvicorn[standard]>=0.15.0,<0.16.0',
 'xsdata>=21.9,<22.0']

setup_kwargs = {
    'name': 'dmarc-metrics-exporter',
    'version': '0.5.1.dev0',
    'description': 'Export Prometheus metrics from DMARC reports.',
    'long_description': '.. image:: https://github.com/jgosmann/dmarc-metrics-exporter/actions/workflows/ci.yml/badge.svg\n  :target: https://github.com/jgosmann/dmarc-metrics-exporter/actions/workflows/ci.yml\n  :alt: CI and release pipeline\n.. image:: https://codecov.io/gh/jgosmann/dmarc-metrics-exporter/branch/main/graph/badge.svg?token=O4M05YWNQK\n  :target: https://codecov.io/gh/jgosmann/dmarc-metrics-exporter\n  :alt: Codecov coverage\n.. image:: https://img.shields.io/pypi/v/dmarc-metrics-exporter\n  :target: https://pypi.org/project/dmarc-metrics-exporter/\n  :alt: PyPI\n.. image:: https://img.shields.io/pypi/pyversions/dmarc-metrics-exporter\n  :target: https://pypi.org/project/dmarc-metrics-exporter/\n  :alt: PyPI - Python Version\n.. image:: https://img.shields.io/pypi/l/dmarc-metrics-exporter\n  :target: https://pypi.org/project/dmarc-metrics-exporter/\n  :alt: PyPI - License\n\ndmarcs-metrics-exporter\n=======================\n\nExport metrics derived from DMARC aggregate reports to Prometheus.\nThis exporter regularly polls\nfor new aggregate report emails\nvia IMAP.\nThe following metrics will be collected\nand exposed at an HTTP endpoint\nfor Prometheus:\n\n* ``dmarc_total``: Total number of reported messages.\n* ``dmarc_compliant_total``: Total number of DMARC compliant messages.\n* ``dmarc_quarantine_total``: Total number of quarantined messages.\n* ``dmarc_reject_total``: Total number of rejected messages.\n* ``dmarc_spf_aligned_total``: Total number of SPF algined messages.\n* ``dmarc_spf_pass_total``: Total number of messages with raw SPF pass.\n* ``dmarc_dkim_aligned_total``: Total number of DKIM algined messages.\n* ``dmarc_dkim_pass_total``: Total number of messages with raw DKIM pass.\n\nEach of these metrics is subdivided by the following labels:\n\n* ``reporter``: Domain from which a DMARC aggregate report originated.\n* ``from_domain``: Domain from which the evaluated email originated.\n* ``dkim_domain``: Domain the DKIM signature is for.\n* ``spf_domain``: Domain used for the SPF check.\n\n\nInstallation\n------------\n\nThis describes the manual setup fo dmarc-metrics-exporter.\nAn Ansible role for automated deployment is provided in ``roles``.\nFurther instructions for Ansible are given in the readme file\nprovided in that directory.\n\nIt is best to run dmarc-metrics-exporter under a separate system user account.\nCreate one for example with\n\n.. code-block:: bash\n\n    adduser --system --group dmarc-metrics\n\nThen you can install dmarc-metrics-exporter with ``pip`` from PyPI for that\nuser:\n\n.. code-block:: bash\n\n    sudo -u dmarc-metrics pip3 install dmarc-metrics-exporter\n\nYou will need a location to store the ``metrics.db`` that is writable by that\nuser, for example:\n\n.. code-block:: bash\n\n    mkdir /var/lib/dmarc-metrics-exporter\n    chown dmarc-metrics:dmarc-metrics /var/lib/dmarc-metrics-exporter\n\n\nConfiguration\n-------------\n\nTo run dmarc-metrics-exporter a configuration file in JSON format is required.\nThe default location is ``/etc/dmarc-metrics-exporter.json``.\n\nBecause the configuration file will contain the IMAP password,\nmake sure to ensure proper permissions on it,\nfor example:\n\n.. code-block:: bash\n\n    chown root:dmarc-metrics /etc/dmarc-metrics-exporter.json\n    chmod 640 /etc/dmarc-metrics-exporter.json\n\nAn example configuration file is provided in this repository in\n``config/dmarc-metrics-exporter.sample.json``.\n\nThe following configuration options are available:\n\n* ``listen_addr`` (string, default ``"127.0.0.1"``): Listen address for the HTTP endpoint. Use ``"0.0.0.0"`` if running in a dockerized environment.\n* ``port`` (number, default ``9797``): Port to listen on for the HTTP endpoint.\n* ``imap`` (object, required): IMAP configuration to check for aggregate reports.\n\n  * ``host`` (string, default ``"localhost"``): Hostname of IMAP server to connect to.\n  * ``port`` (number, default ``993``): Port of the IMAP server to connect to.\n  * ``username`` (string, required): Login username for the IMAP connection.\n  * ``password``: (string, required): Login password for the IMAP connection.\n  * ``use_ssl``: (boolean, default ``true``): Whether to use SSL encryption for the connection. Disabling this will transmit the password in clear text! Currently, there is no support for STARTTLS.\n  * ``verify_certificate``: (boolean, default ``true``): Whether to verify the server\'s SSL certificate. You might have to set this to ``false`` if you are using a self-signed certificate. If this is disabled, someone else could impersonate the server and obtain the login data.\n\n* ``folders`` (object):\n\n  * ``inbox`` (string, default ``"INBOX"``): IMAP mailbox that is checked for incoming DMARC aggregate reports.\n  * ``done`` (string, default ``"Archive"``): IMAP mailbox that successfully processed reports are moved to.\n  * ``error``: (string, default ``"Invalid"``): IMAP mailbox that emails are moved to that could not be processed.\n\n* ``storage_path`` (string, default ``"/var/lib/dmarc-metrics-exporter"``):\n  Directory to persist data in that has to persisted between restarts.\n* ``poll_interval_seconds`` (number, default ``60``): How often to poll the IMAP server in seconds.\n* ``deduplication_max_seconds`` (number, default ``604800`` which is 7 days): How long individual report IDs will be remembered to avoid counting double delivered reports twice.\n* ``logging`` (object, default ``{ "version": 1, "disable_existing_loggers": false }``): Logging configuration. `See logging.config documentation. <https://docs.python.org/3/library/logging.config.html#configuration-dictionary-schema>`_\n\nUsage\n-----\n\nTo run dmarc-metrics-exporter with the default configuration in\n``/etc/dmarc-metrics-exporter.json``:\n\n.. code-block:: bash\n\n    sudo -u dmarc-metrics python3 -m dmarc_metrics_exporter\n\nTo use a different configuration file:\n\n.. code-block:: bash\n\n    sudo -u dmarc-metrics python3 -m dmarc_metrics_exporter --configuration <path>\n\nYou can enable debug logging with the `--debug`\nif you do not want to provide your own logging configuration:\n\n.. code-block:: bash\n\n    sudo -u dmarc-metrics python3 -m dmarc_metrics_exporter --debug\n\n\nsystemd\n^^^^^^^\n\nInstead of manually starting the dmarc-metrics-exporter,\nyou likely want to have it run as a system service.\nAn example systemd service file is provided in this repository in\n``config/dmarc-metrics-exporter.service``.\nMake sure that the paths and user/group names match your configuration\nand copy it to ``/etc/systemd/system`` to use it.\nTo have systemd pick it up a ``systemctl daemon-reload`` might be necessary.\n\nYou can than start/stop dmarc-metrics-exorter with:\n\n.. code-block:: bash\n\n    systemctl start dmarc-metrics-exporter\n    systemctl stop dmarc-metrics-exporter\n\nTo have dmarc-metrics-exporter start on system boot:\n\n.. code-block:: bash\n\n    systemctl enable dmarc-metrics-exporter\n\nDocker\n^^^^^^\n\nA new docker image is build for each release\nwith GitHub Actions as described in this yaml-file:\n``.github/workflows/docker-publish.yml``.\n\nNote that you should configure the `listen_addr` to `0.0.0.0` to be able to\naccess the metrics exporter from outside the container.\n\nExample docker-compose file:\n\n.. code-block:: yml\n\n    version: "3"\n\n    services:\n\n      dmarc-metrics-exporter:\n        # source: https://github.com/jamborjan/dmarc-metrics-exporter/pkgs/container/dmarc-metrics-exporter\n        container_name: dmarc-metrics-exporter\n        hostname: dmarc-metrics-exporter\n        image: jgosmann/dmarc-metrics-exporter:0.3.0\n        restart: unless-stopped\n        user: 1000:1000 #PUID=1000:PGID=1000\n        expose:\n          - 9797\n        volumes:\n          - \'/host/folder/dmarc-metrics-exporter.json:/etc/dmarc-metrics-exporter.json\'\n          - \'/host/folder/dmarc-metrics-exporter/metrics:/var/lib/dmarc-metrics-exporter:rw\'\n        logging:\n          driver: "json-file"\n          options:\n            tag: "{{.ImageName}}|{{.Name}}|{{.ImageFullID}}|{{.FullID}}"\n        networks:\n          - YourDockerLan\n\n    # $ docker network create -d bridge --attachable YourDockerLan\n    networks:\n      YourDockerLan:\n        external:\n          name: YourDockerLan\n\nPrometheus\n^^^^^^^^^^\n\nExample prometheus config file:\n\n.. code-block:: yml\n\n    global:\n      scrape_interval: 15s\n      evaluation_interval: 15s\n\n    rule_files:\n\n    scrape_configs:\n\n      - job_name: \'dmarc-metrics-exporter\'\n        static_configs:\n          - targets: [\'dmarc-metrics-exporter:9797\']\n\nGrafana\n^^^^^^^\n\nAn example configuration file is provided in this repository in\n``config/dmarc-metrics-exporter.grafana.sample.json``. This example dashboard displays the collected metrics as shown in the screenshot below.\n\n.. figure:: config/dmarc-metrics-exporter.grafana.sample.png\n\n   Example grafana dashboard\n\nHints\n^^^^^\n\nYou should not use your normal email and password credentials for the dmarc-metrics-exporter.\nIf you are not able to create a dedicated service account email account, you should use an app password.\n\nMicrosoft Exchange Online\n"""""""""""""""""""""""""\n\n* App passwords are available when you are using Multi Factor Authentication (MFA).\n  `Manage app passwords for two-step verification <https://account.activedirectory.windowsazure.com/AppPasswords.aspx>`_\n* If you don\'t see the app passwords option or get an error,\n  `check if MFA is enabled <https://account.activedirectory.windowsazure.com/UserManagement/MultifactorVerification.aspx>`_\n  for the user.\n* If you still don\'t see the app passwords option,\n  `check if app passwords are allowed in your organization <https://docs.microsoft.com/en-us/azure/active-directory/authentication/howto-mfa-app-passwords#allow-users-to-create-app-passwords>`_\n* Finally, `ensure that IMAP is enabled for the user <https://docs.microsoft.com/en-us/exchange/clients-and-mobile-in-exchange-online/pop3-and-imap4/enable-or-disable-pop3-or-imap4-access>`_.\n\n\nDevelopment\n-----------\n\nPrerequisites\n^^^^^^^^^^^^^\n\n* `Python <https://www.python.org/>`_\n* `pre-commit <https://pre-commit.com/>`_\n* `Poetry <https://python-poetry.org/>`_\n* `Docker <https://www.docker.com/>`_\n\nSetup development environment\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n    pre-commit install\n    poetry install\n\n\nRun tests\n^^^^^^^^^\n\n.. code-block:: bash\n\n    docker-compose up -d\n    poetry run pytest\n',
    'author': 'Jan Gosmann',
    'author_email': 'jan@hyper-world.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jgosmann/dmarc-metrics-exporter/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<3.10',
}


setup(**setup_kwargs)
