# nomad-cbec-id-cli
This is the API descriptor for the Nomad CBEC, responsible for CBEC customer ID check.
Developed by `Samarkand Global <https://samarkand.global>`_

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.5.0
- Package version: 1.5.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nomad_cbec_id_cli
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nomad_cbec_id_cli
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import nomad_cbec_id_cli
from pprint import pprint
from nomad_cbec_id_cli.api import health_api
# Defining the host is optional and defaults to https://nomad.samarkand-global.cn/cbec
# See configuration.py for a list of all supported configuration parameters.
configuration = nomad_cbec_id_cli.Configuration(
    host = "https://nomad.samarkand-global.cn/cbec"
)



# Enter a context with an instance of the API client
with nomad_cbec_id_cli.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = health_api.HealthApi(api_client)
    
    try:
        # health
        api_response = api_instance.get_health()
        pprint(api_response)
    except nomad_cbec_id_cli.ApiException as e:
        print("Exception when calling HealthApi->get_health: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://nomad.samarkand-global.cn/cbec*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HealthApi* | [**get_health**](docs/HealthApi.md#get_health) | **GET** /health | health
*HealthApi* | [**get_metrics**](docs/HealthApi.md#get_metrics) | **GET** /metrics | metrics
*UserApi* | [**id_check**](docs/UserApi.md#id_check) | **GET** /id | idCheck


## Documentation For Models

 - [ApiResponse](docs/ApiResponse.md)
 - [ApiResponseData](docs/ApiResponseData.md)


## Documentation For Authorization


## ca_key

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: URL query string


## Author

paul@samarkand.global


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in nomad_cbec_id_cli.apis and nomad_cbec_id_cli.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from nomad_cbec_id_cli.api.default_api import DefaultApi`
- `from nomad_cbec_id_cli.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import nomad_cbec_id_cli
from nomad_cbec_id_cli.apis import *
from nomad_cbec_id_cli.models import *
```

