# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['spotify_utils', 'spotify_utils.src']

package_data = \
{'': ['*'], 'spotify_utils': ['templates/playlists.html']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0',
 'dynaconf>=3.1.8,<4.0.0',
 'spotipy>=2.19.0,<3.0.0',
 'tabulate>=0.8.9,<0.9.0',
 'typer>=0.4.1,<0.5.0']

entry_points = \
{'console_scripts': ['spotify-utils = spotify_utils.main:app']}

setup_kwargs = {
    'name': 'spotify-utils',
    'version': '1.0.0',
    'description': 'spotify-utils is a Spotify client for specific utility tasks',
    'long_description': '<div id="top"></div>\n<!-- PROJECT SHIELDS -->\n\n![GitHub issues](https://img.shields.io/github/issues/fabieu/spotify-utils?style=flat-square)\n![PyPI](https://img.shields.io/pypi/v/spotify-utils?style=flat-square)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/spotify-utils?style=flat-square)\n![CircleCI](https://img.shields.io/circleci/build/github/fabieu/spotify-utils?style=flat-square&token=129776381708fd465360ca07ccf7fecec9346def)\n![GitHub](https://img.shields.io/github/license/fabieu/spotify-utils?style=flat-square)\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://github.com/fabieu/spotify-utils">\n    <img src="docs/assets/media_player.svg" alt="Logo" width="200" height="200">\n  </a>\n\n  <h2 align="center">spotify-utils</h2>\n\n  <p align="center">\n    An awesome and easy-to-use CLI for various Spotify&reg; utility tasks!\n    <br />\n    <a href=https://github.com/fabieu/spotify-utils/issues/new/choose">Report Bug</a>\n    ·\n    <a href="https://github.com/fabieu/spotify-utils/issues/new/choose">Request Feature</a>\n  </p>\n</div>\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisites">Prerequisites</a></li>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgments">Acknowledgments</a></li>\n    <li><a href="#disclaimer">Disclaimer</a></li>\n  </ol>\n</details>\n\n<!-- ABOUT THE PROJECT -->\n\n## About The Project\n\nThere are many Spotify&reg; clients out there; however, I didn\'t find one that really suited my needs so I created this one. I want to create a Spotify&reg; CLI which is easy-to-use, packed with useful functionalities and with a sophisticated documentation built-in.\n\nKey features:\n\n- Playlists\n  - List information about playlists of the authenticated user in various output formats (Console, JSON)\n  - Find duplicate tracks across all playlists\n  - Export playlist information in various formats (JSON, HTML template)\n- More coming soon\n\nOf course, this CLI will not serve all needs, especially during development. So I\'ll be adding more features in the near future. You may also suggest changes by forking this repo and creating a pull request or opening an issue. Thanks to all the people have contributed!\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- GETTING STARTED -->\n\n## Getting Started\n\n### Prerequisites\n\n- Python 3.6 or higher\n\n### Installation\n\n```bash\npip install spotify-utils\n```\n\n### Configuration\n\nAll methods require user authorization. You will need to register your app at [My Dashboard](https://developer.spotify.com/dashboard/applications) to get the credentials necessary to make authorized calls (a client id and client secret). [Click here](https://developer.spotify.com/documentation/general/guides/authorization/app-settings/) to go to the step-by-step guide for creating a Spotify&reg; application.\n\nThe CLI uses the Authorization Code flow, which the user logs into once. It provides an access token that can be refreshed.\n\nEnvironment variables are being used for configuration. In order for the CLI to function properly you need to provide the following environment variables (use export instead of SET on Linux):\n\n```powershell\nset SPOTIFY_UTILS_CLIENT_ID=\'your-spotify-client-id\'\nset SPOTIFY_UTILS_CLIENT_SECRET=\'your-spotify-client-secret\'\nset SPOTIFY_UTILS_REDIRECT_URI=\'your-app-redirect-url\'\n```\n\nIn addition the use of an `.env` file is supported:\n\n```\nSPOTIFY_UTILS_CLIENT_ID=\'your-spotify-client-id\'\nSPOTIFY_UTILS_CLIENT_SECRET=\'your-spotify-client-secret\'\nSPOTIFY_UTILS_REDIRECT_URI=\'your-app-redirect-url\'\n```\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- USAGE EXAMPLES -->\n\n## Usage and examples\n\nIn this section you can find usage examples of the CLI\n\n### List all playlists of the current authenticated user in JSON format\n\n```text\nspotify-utils playlists list --json\n```\n\n```json\n[\n   {\n      "collaborative":false,\n      "description":"Car Music Mix 2022 \\ud83d\\udd25 Best Remixes of Popular Songs 2022 EDM, Bass Boosted  by Rise Music",\n      "external_urls":{\n         "spotify":"https://open.spotify.com/playlist/0fM4AkfoGygOHVXjsNB7io"\n      },\n      ... more\n   }\n]\n```\n\n### Find duplicates across all playlists and display additional details:\n\n```text\nspotify-utils playlists duplicates --verbose\n```\n\nFound 43 duplicate tracks across 20 playlists\n| | name | artists | playlists | track_id |\n|---|----------------|-------------------------|------------------------|------------------------|\n| 0 | Piercing Light | League of Legends, Mako | Rock, Sonos Mainstream | 0163ud7I4Vb0ID5K7WBkq9 |\n| 1 |Edge Of The Earth | Thirty Seconds To Mars| Rock, Pop|0g9IOJwdElaCZEvcqGRP4b |\n| ... |... |... |... |... |\n\n### Export playlist as beautiful HTML file\n\n```text\nspotify-utils playlists export --html\n```\n\n![HTML export](docs/assets/examples/html_export.png)\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- ROADMAP -->\n\n## Roadmap\n\n- [ ] Improve help sections of the CLI\n- [ ] Add additional functionality\n\nSee the [open issues](https://github.com/fabieu/spotify-utils/issues) for a full list of proposed features (and known issues).\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- CONTRIBUTING -->\n\n## Contributing\n\nContributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".\nDon\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- LICENSE -->\n\n## License\n\nDistributed under the GPL-3.0 License. See [`LICENSE`](LICENSE) for more information.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- CONTACT -->\n\n## Contact\n\nFabian Eulitz - [@sustineo\\_](https://twitter.com/sustineo_) - dev@sustineo.de\n\nProject Link: [https://github.com/fabieu/spotify-utils](https://github.com/fabieu/spotify-utils)\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- ACKNOWLEDGMENTS -->\n\n## Acknowledgments\n\n- [Typer](https://github.com/tiangolo/typer)\n- [Spotipy](https://github.com/plamere/spotipy)\n- [Vermin](https://github.com/netromdk/vermin)\n- [Shields.io](https://shields.io)\n- [Choose an Open Source License](https://choosealicense.com)\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n## Disclaimer\n\nThis project isn’t endorsed by Spotify AB and doesn’t reflect the views or opinions of Spotify AB or anyone officially involved in producing or managing Spotify&reg;\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n',
    'author': 'Fabian Eulitz',
    'author_email': 'dev@sustineo.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fabieu/spotify-utils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
