import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MediaConnect::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 * @external
 */
export interface CfnFlowProps {
    /**
     * `AWS::MediaConnect::Flow.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::Flow.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source
     * @external
     */
    readonly source: CfnFlow.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::Flow.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::MediaConnect::Flow.SourceFailoverConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig
     * @external
     */
    readonly sourceFailoverConfig?: CfnFlow.FailoverConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 */
export declare class CfnFlow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::Flow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlow;
    /**
     * @external
     * @cloudformationAttribute FlowArn
     */
    readonly attrFlowArn: string;
    /**
     * @external
     * @cloudformationAttribute FlowAvailabilityZone
     */
    readonly attrFlowAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute IngestIp
     */
    readonly attrIngestIp: string;
    /**
     * @external
     * @cloudformationAttribute SourceArn
     */
    readonly attrSourceArn: string;
    /**
     * `AWS::MediaConnect::Flow.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name
     * @external
     */
    name: string;
    /**
     * `AWS::MediaConnect::Flow.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source
     * @external
     */
    source: CfnFlow.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::Flow.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::MediaConnect::Flow.SourceFailoverConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig
     * @external
     */
    sourceFailoverConfig: CfnFlow.FailoverConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaConnect::Flow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html
     * @external
     */
    interface EncryptionProperty {
        /**
         * `CfnFlow.EncryptionProperty.Algorithm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-algorithm
         * @external
         */
        readonly algorithm: string;
        /**
         * `CfnFlow.EncryptionProperty.ConstantInitializationVector`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-constantinitializationvector
         * @external
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnFlow.EncryptionProperty.DeviceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-deviceid
         * @external
         */
        readonly deviceId?: string;
        /**
         * `CfnFlow.EncryptionProperty.KeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-keytype
         * @external
         */
        readonly keyType?: string;
        /**
         * `CfnFlow.EncryptionProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-region
         * @external
         */
        readonly region?: string;
        /**
         * `CfnFlow.EncryptionProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-resourceid
         * @external
         */
        readonly resourceId?: string;
        /**
         * `CfnFlow.EncryptionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnFlow.EncryptionProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-secretarn
         * @external
         */
        readonly secretArn?: string;
        /**
         * `CfnFlow.EncryptionProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html
     * @external
     */
    interface FailoverConfigProperty {
        /**
         * `CfnFlow.FailoverConfigProperty.RecoveryWindow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-recoverywindow
         * @external
         */
        readonly recoveryWindow?: number;
        /**
         * `CfnFlow.FailoverConfigProperty.State`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-state
         * @external
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaConnect::Flow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html
 * @external
 * @cloudformationResource AWS::MediaConnect::Flow
 */
export declare namespace CfnFlow {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html
     * @external
     */
    interface SourceProperty {
        /**
         * `CfnFlow.SourceProperty.Decryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-decryption
         * @external
         */
        readonly decryption?: CfnFlow.EncryptionProperty | cdk.IResolvable;
        /**
         * `CfnFlow.SourceProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnFlow.SourceProperty.EntitlementArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-entitlementarn
         * @external
         */
        readonly entitlementArn?: string;
        /**
         * `CfnFlow.SourceProperty.IngestIp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestip
         * @external
         */
        readonly ingestIp?: string;
        /**
         * `CfnFlow.SourceProperty.IngestPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestport
         * @external
         */
        readonly ingestPort?: number;
        /**
         * `CfnFlow.SourceProperty.MaxBitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxbitrate
         * @external
         */
        readonly maxBitrate?: number;
        /**
         * `CfnFlow.SourceProperty.MaxLatency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxlatency
         * @external
         */
        readonly maxLatency?: number;
        /**
         * `CfnFlow.SourceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnFlow.SourceProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnFlow.SourceProperty.SourceArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcearn
         * @external
         */
        readonly sourceArn?: string;
        /**
         * `CfnFlow.SourceProperty.StreamId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-streamid
         * @external
         */
        readonly streamId?: string;
        /**
         * `CfnFlow.SourceProperty.VpcInterfaceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-vpcinterfacename
         * @external
         */
        readonly vpcInterfaceName?: string;
        /**
         * `CfnFlow.SourceProperty.WhitelistCidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-whitelistcidr
         * @external
         */
        readonly whitelistCidr?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowEntitlement`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html
 * @external
 */
export interface CfnFlowEntitlementProps {
    /**
     * `AWS::MediaConnect::FlowEntitlement.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn
     * @external
     */
    readonly flowArn: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Subscribers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers
     * @external
     */
    readonly subscribers: string[];
    /**
     * `AWS::MediaConnect::FlowEntitlement.DataTransferSubscriberFeePercent`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent
     * @external
     */
    readonly dataTransferSubscriberFeePercent?: number;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Encryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption
     * @external
     */
    readonly encryption?: CfnFlowEntitlement.EncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::FlowEntitlement.EntitlementStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus
     * @external
     */
    readonly entitlementStatus?: string;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowEntitlement`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowEntitlement
 */
export declare class CfnFlowEntitlement extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowEntitlement";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowEntitlement;
    /**
     * @external
     * @cloudformationAttribute EntitlementArn
     */
    readonly attrEntitlementArn: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description
     * @external
     */
    description: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn
     * @external
     */
    flowArn: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name
     * @external
     */
    name: string;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Subscribers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers
     * @external
     */
    subscribers: string[];
    /**
     * `AWS::MediaConnect::FlowEntitlement.DataTransferSubscriberFeePercent`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent
     * @external
     */
    dataTransferSubscriberFeePercent: number | undefined;
    /**
     * `AWS::MediaConnect::FlowEntitlement.Encryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption
     * @external
     */
    encryption: CfnFlowEntitlement.EncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaConnect::FlowEntitlement.EntitlementStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus
     * @external
     */
    entitlementStatus: string | undefined;
    /**
     * Create a new `AWS::MediaConnect::FlowEntitlement`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowEntitlementProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowEntitlement`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowEntitlement
 */
export declare namespace CfnFlowEntitlement {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html
     * @external
     */
    interface EncryptionProperty {
        /**
         * `CfnFlowEntitlement.EncryptionProperty.Algorithm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-algorithm
         * @external
         */
        readonly algorithm: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.ConstantInitializationVector`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-constantinitializationvector
         * @external
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.DeviceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-deviceid
         * @external
         */
        readonly deviceId?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.KeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-keytype
         * @external
         */
        readonly keyType?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-region
         * @external
         */
        readonly region?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-resourceid
         * @external
         */
        readonly resourceId?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-secretarn
         * @external
         */
        readonly secretArn?: string;
        /**
         * `CfnFlowEntitlement.EncryptionProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 * @external
 */
export interface CfnFlowOutputProps {
    /**
     * `AWS::MediaConnect::FlowOutput.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn
     * @external
     */
    readonly flowArn: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol
     * @external
     */
    readonly protocol: string;
    /**
     * `AWS::MediaConnect::FlowOutput.CidrAllowList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist
     * @external
     */
    readonly cidrAllowList?: string[];
    /**
     * `AWS::MediaConnect::FlowOutput.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Destination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination
     * @external
     */
    readonly destination?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Encryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption
     * @external
     */
    readonly encryption?: CfnFlowOutput.EncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::FlowOutput.MaxLatency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency
     * @external
     */
    readonly maxLatency?: number;
    /**
     * `AWS::MediaConnect::FlowOutput.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::MediaConnect::FlowOutput.RemoteId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid
     * @external
     */
    readonly remoteId?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.SmoothingLatency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency
     * @external
     */
    readonly smoothingLatency?: number;
    /**
     * `AWS::MediaConnect::FlowOutput.StreamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid
     * @external
     */
    readonly streamId?: string;
    /**
     * `AWS::MediaConnect::FlowOutput.VpcInterfaceAttachment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment
     * @external
     */
    readonly vpcInterfaceAttachment?: CfnFlowOutput.VpcInterfaceAttachmentProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowOutput
 */
export declare class CfnFlowOutput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowOutput";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowOutput;
    /**
     * @external
     * @cloudformationAttribute OutputArn
     */
    readonly attrOutputArn: string;
    /**
     * `AWS::MediaConnect::FlowOutput.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn
     * @external
     */
    flowArn: string;
    /**
     * `AWS::MediaConnect::FlowOutput.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol
     * @external
     */
    protocol: string;
    /**
     * `AWS::MediaConnect::FlowOutput.CidrAllowList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist
     * @external
     */
    cidrAllowList: string[] | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Destination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination
     * @external
     */
    destination: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Encryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption
     * @external
     */
    encryption: CfnFlowOutput.EncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.MaxLatency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency
     * @external
     */
    maxLatency: number | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.RemoteId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid
     * @external
     */
    remoteId: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.SmoothingLatency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency
     * @external
     */
    smoothingLatency: number | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.StreamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid
     * @external
     */
    streamId: string | undefined;
    /**
     * `AWS::MediaConnect::FlowOutput.VpcInterfaceAttachment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment
     * @external
     */
    vpcInterfaceAttachment: CfnFlowOutput.VpcInterfaceAttachmentProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaConnect::FlowOutput`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowOutputProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowOutput
 */
export declare namespace CfnFlowOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html
     * @external
     */
    interface EncryptionProperty {
        /**
         * `CfnFlowOutput.EncryptionProperty.Algorithm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-algorithm
         * @external
         */
        readonly algorithm: string;
        /**
         * `CfnFlowOutput.EncryptionProperty.KeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-keytype
         * @external
         */
        readonly keyType?: string;
        /**
         * `CfnFlowOutput.EncryptionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnFlowOutput.EncryptionProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html#cfn-mediaconnect-flowoutput-encryption-secretarn
         * @external
         */
        readonly secretArn: string;
    }
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowOutput
 */
export declare namespace CfnFlowOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html
     * @external
     */
    interface VpcInterfaceAttachmentProperty {
        /**
         * `CfnFlowOutput.VpcInterfaceAttachmentProperty.VpcInterfaceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment-vpcinterfacename
         * @external
         */
        readonly vpcInterfaceName?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html
 * @external
 */
export interface CfnFlowSourceProps {
    /**
     * `AWS::MediaConnect::FlowSource.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::MediaConnect::FlowSource.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::FlowSource.Decryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption
     * @external
     */
    readonly decryption?: CfnFlowSource.EncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::MediaConnect::FlowSource.EntitlementArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn
     * @external
     */
    readonly entitlementArn?: string;
    /**
     * `AWS::MediaConnect::FlowSource.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn
     * @external
     */
    readonly flowArn?: string;
    /**
     * `AWS::MediaConnect::FlowSource.IngestPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport
     * @external
     */
    readonly ingestPort?: number;
    /**
     * `AWS::MediaConnect::FlowSource.MaxBitrate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate
     * @external
     */
    readonly maxBitrate?: number;
    /**
     * `AWS::MediaConnect::FlowSource.MaxLatency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency
     * @external
     */
    readonly maxLatency?: number;
    /**
     * `AWS::MediaConnect::FlowSource.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol
     * @external
     */
    readonly protocol?: string;
    /**
     * `AWS::MediaConnect::FlowSource.StreamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid
     * @external
     */
    readonly streamId?: string;
    /**
     * `AWS::MediaConnect::FlowSource.VpcInterfaceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename
     * @external
     */
    readonly vpcInterfaceName?: string;
    /**
     * `AWS::MediaConnect::FlowSource.WhitelistCidr`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr
     * @external
     */
    readonly whitelistCidr?: string;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowSource
 */
export declare class CfnFlowSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowSource;
    /**
     * @external
     * @cloudformationAttribute IngestIp
     */
    readonly attrIngestIp: string;
    /**
     * @external
     * @cloudformationAttribute SourceArn
     */
    readonly attrSourceArn: string;
    /**
     * `AWS::MediaConnect::FlowSource.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description
     * @external
     */
    description: string;
    /**
     * `AWS::MediaConnect::FlowSource.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name
     * @external
     */
    name: string;
    /**
     * `AWS::MediaConnect::FlowSource.Decryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption
     * @external
     */
    decryption: CfnFlowSource.EncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.EntitlementArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn
     * @external
     */
    entitlementArn: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn
     * @external
     */
    flowArn: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.IngestPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport
     * @external
     */
    ingestPort: number | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.MaxBitrate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate
     * @external
     */
    maxBitrate: number | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.MaxLatency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency
     * @external
     */
    maxLatency: number | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol
     * @external
     */
    protocol: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.StreamId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid
     * @external
     */
    streamId: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.VpcInterfaceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename
     * @external
     */
    vpcInterfaceName: string | undefined;
    /**
     * `AWS::MediaConnect::FlowSource.WhitelistCidr`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr
     * @external
     */
    whitelistCidr: string | undefined;
    /**
     * Create a new `AWS::MediaConnect::FlowSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowSourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowSource
 */
export declare namespace CfnFlowSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html
     * @external
     */
    interface EncryptionProperty {
        /**
         * `CfnFlowSource.EncryptionProperty.Algorithm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-algorithm
         * @external
         */
        readonly algorithm: string;
        /**
         * `CfnFlowSource.EncryptionProperty.ConstantInitializationVector`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-constantinitializationvector
         * @external
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.DeviceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-deviceid
         * @external
         */
        readonly deviceId?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.KeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-keytype
         * @external
         */
        readonly keyType?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-region
         * @external
         */
        readonly region?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-resourceid
         * @external
         */
        readonly resourceId?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnFlowSource.EncryptionProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-secretarn
         * @external
         */
        readonly secretArn?: string;
        /**
         * `CfnFlowSource.EncryptionProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-url
         * @external
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaConnect::FlowVpcInterface`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html
 * @external
 */
export interface CfnFlowVpcInterfaceProps {
    /**
     * `AWS::MediaConnect::FlowVpcInterface.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-flowarn
     * @external
     */
    readonly flowArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-securitygroupids
     * @external
     */
    readonly securityGroupIds: string[];
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-subnetid
     * @external
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::MediaConnect::FlowVpcInterface`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html
 * @external
 * @cloudformationResource AWS::MediaConnect::FlowVpcInterface
 */
export declare class CfnFlowVpcInterface extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaConnect::FlowVpcInterface";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowVpcInterface;
    /**
     * @external
     * @cloudformationAttribute NetworkInterfaceIds
     */
    readonly attrNetworkInterfaceIds: string[];
    /**
     * `AWS::MediaConnect::FlowVpcInterface.FlowArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-flowarn
     * @external
     */
    flowArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-name
     * @external
     */
    name: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-securitygroupids
     * @external
     */
    securityGroupIds: string[];
    /**
     * `AWS::MediaConnect::FlowVpcInterface.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html#cfn-mediaconnect-flowvpcinterface-subnetid
     * @external
     */
    subnetId: string;
    /**
     * Create a new `AWS::MediaConnect::FlowVpcInterface`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowVpcInterfaceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
