# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/50_path.ipynb.

# %% auto 0
__all__ = ['DIR', 'LOC', 'SRC', 'BASE', 'DEST', 'FILE', 'PATH', 'ROOT', 'NODE', 'ROOT_DIR', 'PREP_PATH', 'NBS', 'FIG', 'IMG',
           'RES', 'DATA', 'FIGS', 'IMGS', 'FIGURES', 'RESULTS', 'EXAMPLES', 'RB', 'WB', 'NT', 'POSIX', 'WINDOWS',
           'CLIP', 'ECHO', 'HEAD', 'TAIL', 'PBCOPY', 'SYMLINK', 'HARDLINK', 'METADATA', 'CORE', 'FLDR', 'LEAF', 'REST',
           'PathKind', 'EntryType', 'OSType', 'PathLibType']

# %% ../nbs/50_path.ipynb 4
import os
from enum import Enum, StrEnum
from pathlib import (Path, PosixPath, WindowsPath)

# %% ../nbs/50_path.ipynb 5
from .args import PREP

# %% ../nbs/50_path.ipynb 7
DIR = 'dir'
LOC = 'loc'
SRC = 'src'

BASE = 'base'
DEST = 'dest'

FILE = 'file'

PATH = 'path'
ROOT = 'root'

NODE = 'node'

# %% ../nbs/50_path.ipynb 8
ROOT_DIR = f'{ROOT}_{DIR}'

# %% ../nbs/50_path.ipynb 9
PREP_PATH = f'{PREP}_{PATH}'

# %% ../nbs/50_path.ipynb 11
class PathKind(StrEnum):
    DIR  = DIR
    FILE = FILE
    PATH = PATH
    @classmethod
    def kinds(cls) -> set: return set(m.value for m in cls)   

# %% ../nbs/50_path.ipynb 12
class EntryType(StrEnum):
    DIR  = DIR
    FILE = FILE
    PATH = PATH
    @classmethod
    def kinds(cls) -> set: return set(m.value for m in cls)   

# %% ../nbs/50_path.ipynb 14
NBS = 'nbs'

FIG = 'fig'
IMG = 'img'
RES = 'res'

# %% ../nbs/50_path.ipynb 15
DATA = 'data'

FIGS = f'{FIG}s'
IMGS = f'{IMG}s'

FIGURES = f'{FIG}ures'
RESULTS = f'{RES}ults'

EXAMPLES = 'examples'

# %% ../nbs/50_path.ipynb 17
RB = 'rb'
WB = 'wb'

# %% ../nbs/50_path.ipynb 19
NT = 'nt'
POSIX = 'posix'
WINDOWS = 'windows'

# %% ../nbs/50_path.ipynb 21
class OSType(StrEnum):
    NT  = NT
    POSIX = POSIX
    WINDOWS = WINDOWS

    def __str__(self) -> str: return str(self.value).casefold()

    @classmethod
    def osname(cls, obj: 'OSType' = os): 
        return str(getattr(obj, 'name', os.name)).casefold()
    
    @classmethod
    def ostype(cls, obj: 'OSType' = os) -> Path: 
        return PosixPath if cls.osname(obj) == POSIX else WindowsPath
    
    @classmethod
    def oscomp(cls, oshave: 'OSType' = None, oswant: 'OSType' = None) -> bool: 
        return str(oshave) == str(cls.ostype(oswant))
    
    @classmethod
    def is_psx(cls, osn: 'OSType' = None) -> bool: return cls.oscomp(cls.ostype(osn), cls.POSIX)

    @classmethod
    def is_wdx(cls, osn: 'OSType' = None) -> bool: return cls.oscomp(cls.ostype(osn), cls.WINDOWS) 

    @classmethod
    def pathlib_type(cls, osname: 'OSType' = None) -> Path:
        return PosixPath if cls.is_psx(osname) else WindowsPath

    @classmethod
    def addcls(cls, pathclass):
        pathtype = cls.pathlib_type(pathclass)
        for kls in (PosixPath, WindowsPath, ):
            if pathtype in kls.__bases__: continue
            kls.value.__bases__ += (pathtype, )

# %% ../nbs/50_path.ipynb 23
class PathLibType(Enum):
    POSIX = PosixPath
    WINDOWS = WindowsPath
    
    def __str__(self) -> str: return str(self.name).casefold()

    @classmethod
    def addcls(cls, pthcls):
        for member in cls:
            if pthcls in member.value.__bases__: continue
            member.value.__bases__ += (pthcls, )

    @classmethod
    def pthcls(cls, osname: OSType = None) -> Path:
        return PosixPath if OSType.is_psx(osname) else WindowsPath


# %% ../nbs/50_path.ipynb 25
CLIP = 'clip'
ECHO = 'echo'
HEAD = 'head'
TAIL = 'tail'
PBCOPY = 'pbcopy'

# %% ../nbs/50_path.ipynb 27
SYMLINK = 'symlink'
HARDLINK = 'hardlink'
METADATA = 'metadata'

# %% ../nbs/50_path.ipynb 30
CORE = 'core'
FLDR = 'fldr'
LEAF = 'leaf'
REST = 'rest'

# %% ../nbs/50_path.ipynb 31
BDIR = f'b{DIR}' # base
CDIR = f'c{DIR}' # curr
DDIR = f'd{DIR}' # dest
EDIR = f'e{DIR}' # expanded
FDIR = f'f{DIR}' # file
HDIR = f'h{DIR}' # hidden
QDIR = f'q{DIR}' # 
RDIR = f'r{DIR}' # root / relative
PDIR = f'p{DIR}' # path dir
XDIR = f'x{DIR}' # 

# %% ../nbs/50_path.ipynb 33
BLOC = f'b{LOC}'
CLOC = f'c{LOC}'
DLOC = f'd{LOC}'
ELOC = f'e{LOC}'
FLOC = f'f{LOC}'
HLOC = f'h{LOC}'
QLOC = f'q{LOC}'
RLOC = f'r{LOC}'
PLOC = f'p{LOC}'
XLOC = f'x{LOC}'

# %% ../nbs/50_path.ipynb 35
BSRC = f'b{SRC}'
CSRC = f'c{SRC}'
DSRC = f'd{SRC}'
ESRC = f'e{SRC}'
FSRC = f'f{SRC}'
HSRC = f'h{SRC}'
QSRC = f'q{SRC}'
RSRC = f'r{SRC}'
PSRC = f'p{SRC}'
XSRC = f'x{SRC}'
