import os
#from pathlib import Path

import pytest
from IPython import embed  # noqa: F401 For debugging

#from jetto_tools import _my_folder
from jetto_tools.matlab import *  # noqa: F403 Import everything as a test
from numpy.testing import assert_almost_equal


############################################################
# Use stored RAPTOR .mat files for these deep binary tests #
############################################################

raptor_out_dict = {
    'ITERinductive_RAPTORdyn_QLKNN_fromJETTOprofs_01.mat': {
        'struct': 'out',
        'te_10': [32400.4945742004, 32068.4670463355, 31180.7712116234, 29905.6845316628, 28408.5886999242, 26830.0758976941, 25265.7321349027, 23773.2289175039, 22379.8188056548, 21106.3147363675, 19949.9774825718, 18873.8851674196, 17835.3664205538, 16807.1292566635, 15786.6295508175, 14779.6391373050, 13791.8690589464, 12823.1779283681, 11880.1835076920, 10972.3038516703, 10108.5477353571, 9292.27149389004, 8523.46902213613, 7799.61098795286, 7120.10780114609, 6483.59667747100, 5903.44593430793, 5358.14186514627, 4892.40291214675, 2744.44444444444, 200],  # noqa: E501
        'df_dxk_12_5': [0, -4.67467236476809, -690.980193037113, -7625.73446829395, -16582.9643373942, -8523.09319378063, -863.516809834641, -6.31787190349517, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.49171294702816, 9.31958694832417, 20.2364065830035, 26.5801319904715, 26.3520221852362, 18.0345902043338, 5.23621658804429, -7.26920700802299, -16.6940081410327, -20.9581002510293, -19.5784300740412, -15.1745922144467, -10.6694897425670, -7.07076666456725, -4.36144556838677, -2.44379054102317, -1.23156027963750, -0.560420704270624, -0.231552884084527, -0.0872313995063564, -0.0297166856560679, -0.00915131001811774, -0.00255881537497695, -0.000655235918892469, -0.000153895597626226, -3.33524516933773e-05, -6.73630222616212e-06, -1.27847552966718e-06, -2.24770303643279e-07, -3.58432349678244e-08, -6.16001887604307e-09, 0, 8.88858553914970, 21.5293424717263, 41.9961221076003, 48.2042540470022, 40.7686646792498, 22.9237596357619, 1.03835357380971, -18.5818609777773, -31.2348738982498, -35.4308046758326, -32.3115467082601, -25.2500513200108, -17.6495732129927, -11.2618735581944, -6.63452471144602, -3.64202177054424, -1.86365447943273, -0.881666495542447, -0.380930482325192, -0.149444827658277, -0.0527902395973219, -0.0168506359512809, -0.00489623595699839, -0.00130675269784425, -0.000320189092495277, -7.22248032488784e-05, -1.50912828744442e-05, -2.93739264524083e-06, -5.24082993817083e-07, -8.37983172028751e-08, -1.43350900254475e-08, 0],  # noqa: E501
    },
    'RAPTORout_CRONOS_citrin2010ITERhybrid.mat': {
        'struct': 'out_cronos',
        'te_10': [5891.15903444503, 5891.80747671689, 5892.67606753166, 5887.53348634463, 5862.80381153225, 5808.46448926757, 5726.33048835695, 5663.19611392990, 5629.79592638237, 5569.20474852057, 5493.71246437007, 5439.60330116400, 5411.93280314669, 5362.20440416715, 5302.42157991701, 5259.76141050400, 5238.60768896668, 5200.48625212335, 5154.55334440885, 5120.54125879350, 5102.34013595428, 5063.87831104526, 5008.17088351442, 4960.35689647558, 4933.21199025846, 4878.97738073755, 4794.95711917614, 4709.81187669494, 4653.31437436136, 4532.31479793516, 4371.30825793700, 4271.22258778605, 4223.55037329268, 4132.26295420083, 4012.58898700532, 3922.28398817241, 3874.93859668491, 3787.66845090006, 3677.49550474909, 3595.23038241493, 3552.40752189527, 3473.03623040030, 3371.98835884134, 3296.36846113049, 3256.54478217135, 3183.33219917126, 3089.80509676547, 3019.93020587316, 2983.23674952716, 2915.40056486452, 2829.23086236073, 2764.64565851166, 2730.95294541407, 2668.46119738782, 2588.80571189447, 2529.14245232911, 2497.71055606301, 2439.90477558313, 2366.03894112145, 2310.82161168541, 2281.80661464336, 2228.12522477907, 2159.83365144416, 2108.61427320108, 2081.90858849639, 2032.43895771698, 1969.59613552674, 1922.74546842130, 1898.12729525195, 1853.06358500818, 1795.75039720045, 1753.13980853905, 1730.81487181930, 1689.63073556085, 1637.47834085157, 1598.48307106709, 1578.18848621570, 1540.59920128276, 1492.81924702249, 1457.12544878205, 1438.34497145897, 1403.87376429709, 1359.90492370421, 1327.09583135558, 1309.86722752403, 1278.00785872675, 1237.46407088552, 1207.00772249071, 1191.08165132428, 1161.50783473436, 1123.72855168866, 1095.37577134475, 1080.42442699417, 1052.86686152000, 1017.53504069626, 990.966449634976, 976.939670130743, 950.849765272825, 917.244020818433, 891.705180442467, 878.180077401959, 852.855117163137, 819.898273356735, 794.585225862121, 781.062026571875, 755.333802487356, 719.563920564078, 686.369132971783, 664.958375858937, 616.187844335194, 526.233724128184, 448.314676995906, 408.626837956372, 338.187005301258, 258.431908532649, 206.868449354639, 181.674057273212, 139.869193368921, 90.7563971529626, 57.3656448553136],  # noqa: E501
    },
    'out_RAPTORss_QLKNN_citrin2010ITERhybrid.mat': {
        'struct': 'outs',
        'te_10': [45431.2750552232, 45201.2572470385, 44552.5670591661, 43561.3743126539, 42333.5639628990, 41011.7531718618, 39688.6291065575, 38382.7556533011, 36951.3226195854, 35058.0916017229, 32560.5652027556, 29790.2995760179, 27015.8446045113, 24326.2334688778, 21797.7165678658, 19443.1194279127, 17295.8383544138, 15373.7770944004, 13671.9936688380, 12175.4550157879, 10856.5108468790, 9678.85011539203, 8615.15477631946, 7646.98041704024, 6748.94545850698, 5912.33970154311, 5132.01548383212, 4400, 2966.66666666667, 1533.33333333333, 100]},  # noqa: E501
}


@pytest.fixture(scope='session')
def raptor_out_dir(pytestconfig):
    return pytestconfig.rootdir / 'testdata/raptor-out'


def test_read_cell_array_in(raptor_out_dir):
    raptor_out_name = 'ITERinductive_RAPTORdyn_QLKNN_fromJETTOprofs_01.mat'
    raptor_out_data = raptor_out_dict[raptor_out_name]
    raptor_out_raw = loadmat(os.path.join(raptor_out_dir, raptor_out_name))
    var = raptor_out_raw[raptor_out_data['struct']]['df_dxk']
    assert_almost_equal(var[11][:, 4], raptor_out_data['df_dxk_12_5'])


@pytest.mark.parametrize(('raptor_out_name', 'raptor_out_data'),
                         raptor_out_dict.items())
def test_read_in(raptor_out_dir, raptor_out_name, raptor_out_data):
    raptor_out_raw = loadmat(os.path.join(raptor_out_dir, raptor_out_name))
    var = raptor_out_raw[raptor_out_data['struct']]['te']
    # This is raw, so might leave you with squeezed-out 1 dimensions
    if var.ndim == 1:
        val = var
    else:
        val = var[:, 9]
    assert_almost_equal(val, raptor_out_data['te_10'])
