#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['mysql_autoxtrabackup',
 'mysql_autoxtrabackup.api',
 'mysql_autoxtrabackup.api.controller',
 'mysql_autoxtrabackup.backup_backup',
 'mysql_autoxtrabackup.backup_prepare',
 'mysql_autoxtrabackup.general_conf',
 'mysql_autoxtrabackup.process_runner',
 'mysql_autoxtrabackup.utils']

package_data = \
{'': ['*']}

install_requires = \
['click >=3.3', 'pid >=2.0', 'humanfriendly >=2.0']

extras_require = \
{'all': ['click >=3.3',
         'pid >=2.0',
         'humanfriendly >=2.0',
         'sphinx',
         'sphinx_rtd_theme',
         'sphinx-autobuild',
         'jinja2 >=2.11.3'],
 'dev': ['click >=3.3',
         'pid >=2.0',
         'humanfriendly >=2.0',
         'pytest ==5.4.3',
         'pytest-cov ==2.10.0',
         'mypy ==0.812',
         'isort >=5.0.6,<6.0.0',
         'flake8 >=3.8.3,<4.0.0',
         'black ==20.8b1'],
 'doc': ['sphinx', 'sphinx_rtd_theme', 'sphinx-autobuild', 'jinja2 >=2.11.3'],
 'test': ['pytest ==5.4.3',
          'pytest-cov ==2.10.0',
          'mypy ==0.812',
          'isort >=5.0.6,<6.0.0',
          'flake8 >=3.8.3,<4.0.0',
          'black ==20.8b1']}

entry_points = \
{'console_scripts': ['autoxtrabackup = '
                     'mysql_autoxtrabackup.autoxtrabackup:all_procedure']}

setup(name='mysql_autoxtrabackup',
      version='2.0',
      description='MySQL-AutoXtrabackup command-line tool, for automating tedious MySQL physical backups management',
      author='Shahriyar(Shako) Rzayev',
      author_email='rzayev.sehriyar@gmail.com',
      url='https://github.com/ShahriyarR/MySQL-AutoXtraBackup',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
