"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


class PhysicalTargetParamsForRecoverFileAndFolder(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'recover_target': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'restore_to_original_paths': (bool, none_type,),  # noqa: E501
            'overwrite_existing': (bool, none_type,),  # noqa: E501
            'alternate_restore_directory': (str, none_type,),  # noqa: E501
            'preserve_attributes': (bool, none_type,),  # noqa: E501
            'preserve_timestamps': (bool, none_type,),  # noqa: E501
            'preserve_acls': (bool, none_type,),  # noqa: E501
            'continue_on_error': (bool, none_type,),  # noqa: E501
            'vlan_config': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'recover_target': 'recoverTarget',  # noqa: E501
        'restore_to_original_paths': 'restoreToOriginalPaths',  # noqa: E501
        'overwrite_existing': 'overwriteExisting',  # noqa: E501
        'alternate_restore_directory': 'alternateRestoreDirectory',  # noqa: E501
        'preserve_attributes': 'preserveAttributes',  # noqa: E501
        'preserve_timestamps': 'preserveTimestamps',  # noqa: E501
        'preserve_acls': 'preserveAcls',  # noqa: E501
        'continue_on_error': 'continueOnError',  # noqa: E501
        'vlan_config': 'vlanConfig',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, recover_target, *args, **kwargs):  # noqa: E501
        """PhysicalTargetParamsForRecoverFileAndFolder - a model defined in OpenAPI

        Args:
            recover_target ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies the target entity where the volumes are being mounted.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            restore_to_original_paths (bool, none_type): If this is true, then files will be restored to original paths.. [optional]  # noqa: E501
            overwrite_existing (bool, none_type): Specifies whether to overwrite existing file/folder during recovery.. [optional]  # noqa: E501
            alternate_restore_directory (str, none_type): Specifies the directory path where restore should happen if restore_to_original_paths is set to false.. [optional]  # noqa: E501
            preserve_attributes (bool, none_type): Specifies whether to preserve file/folder attributes during recovery.. [optional]  # noqa: E501
            preserve_timestamps (bool, none_type): Whether to preserve the original time stamps.. [optional]  # noqa: E501
            preserve_acls (bool, none_type): Whether to preserve the ACLs of the original file.. [optional]  # noqa: E501
            continue_on_error (bool, none_type): Specifies whether to continue recovering other volumes if one of the volumes fails to recover. Default value is false.. [optional]  # noqa: E501
            vlan_config ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Specifies VLAN Params associated with the recovered. If this is not specified, then the VLAN settings will be automatically selected from one of the below options: a. If VLANs are configured on Cohesity, then the VLAN host/VIP will be automatically based on the client's (e.g. ESXI host) IP address. b. If VLANs are not configured on Cohesity, then the partition hostname or VIPs will be used for Recovery.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        self.recover_target = recover_target
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


