# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['slasher']

package_data = \
{'': ['*']}

install_requires = \
['chat-downloader==0.1.3']

setup_kwargs = {
    'name': 'stream-slasher',
    'version': '2021.7.14',
    'description': 'A commmand-line tool and Python library for autonomous editing of livestreams via live chat activity.',
    'long_description': '# Slasher\nA commmand-line tool and Python library for autonomous editing of livestreams via live chat activity.\n\nThrough *Slasher*, __you__ (the chat member, not the creator) are the editor of the livestream! Through an\nultra-simple algorithm, portions of a livestream where chat is unusually active are kept and concatenated\ntogether. This allows for the speedy (we are just downloading, processing, and creating text afterall)\ncreation of highlights that your audience directly finds enjoying. Personally, I think that the highlights\nthat my tool creates are quite fun to watch, and I at times forgot that they were created via a computer\nprogram!\n\nBecause of the nature of *Slasher*, the algorithm can occasionally cut off speech, take out chunks of \nlong-running moments (singing), leave intervals without context. Luckily, *Slasher* can output project files\ncompatible with video editors so that the editor is fully in control and can quickly integrate the tool\ninto their workflow. *Slasher* will not be appropriate for all livestreams and editors,\nbut it does what it can do really well and attempts to give the end-user as much control as they please!\n\nWith default settings (2x multiplier, 10-second intervals, zero delay), *Slasher*\'s filter mode can turn\nabout one hour of content into seven minutes, making it easy to watch a two-or-three hour live stream during\na lunch break, and quickly consume an 8-hour live stream in under an hour. Can\'t justify watching or editing\na 24-hour livestream? Now you can! Don\'t care about occasionally awkward edits and just want a half-hour\nhighlight half an hour after your livestream ends to get those sweet views? Be my guest!\nThe possibilites with my tool should be quite endless, so go crazy!\n\n## Installation\nAs a developer, clone the project and run `poetry install`. Instructions for normal users coming soon!\n\n## Usage\n\n### Command-Line Interface\n```\nusage: slasher [-h] [--format {ffmpeg,ffsilencer,mlt}] [--output OUTPUT]\n               [--duration DURATION] [--delay DELAY] [--start START]\n               [--end END]\n               {filter,top} ...\n\nLeave the noise of VODs on the cutting room floor.\n\npositional arguments:\n  {filter,top}\n    filter              remove intervals of a stream that don\'t meet a certain\n                        comment threshold\n        positional arguments:\n          url                   a chat-downloader-compatible URL\n\n        optional arguments:\n          --multiplier MULTIPLIER, -m MULTIPLIER\n                                intervals must have a number of messages greater than\n                                the average times this (default: 2)\n\n    top                 pick the top intervals from a stream sorted by\n                        messages\n        positional arguments:\n          url                   a chat-downloader-compatible URL\n\n        optional arguments:\n          --amount AMOUNT, -a AMOUNT\n                                 number of intervals you want to keep\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --format {ffmpeg,ffsilencer,mlt}, -f {ffmpeg,ffsilencer,mlt}\n                        what output you want (default: mlt)\n  --output OUTPUT, -o OUTPUT\n                        where the format will be written to (default: stdout)\n  --duration DURATION   how long an interval should be, uses Python\'s\n                        timedelta syntax (default: ten seconds)\n  --delay DELAY         how far back messages should be pushed back, used to\n                        sync chat with stream, uses Python\'s timedelta syntax\n                        (default: zero seconds)\n  --start START         capture messages from this time, uses Python\'s\n                        timedelta syntax (default: zero seconds)\n  --end END             capture messages to this time, uses Python\'s timedelta\n                        syntax (default: timedelta.max)\n```\n\n### Python Library\nThe entirety of Slasher sans the command line app is less than 150 lines,\nis fully typed, and has docstrings that give you the gist of what each function does,\nso just [read it](./slasher/slasher.py)!\n\n## Examples\nSlasher comes with sensible defaults, so usage is as basic as:\n```bash\npython -m slasher filter https://www.twitch.tv/videos/1080642970\npython -m slasher top https://www.twitch.tv/videos/1080642970\n```\n```python\nfrom slasher import Slasher\ns = Slasher.from_url("https://www.twitch.tv/videos/1080642970")\ns = s.filter()\n```\n\nIf you want to write your results to a file:\n```bash\npython -m slasher --output intervals.mlt filter https://www.twitch.tv/videos/1080642970\n```\n```python\nwith open("intervals.mlt", "w") as f:\n    s.to_mlt(f)\n```\n\nFor more examples of Python lib usage, see [examples/](./examples/)\n\n## Formats\n### [MLT XML](https://www.mltframework.org/docs/mltxml/)\nCLI: `--format mlt`\n\nPython: `Slasher.to_mlt`\n\nThis is an [XML document](https://en.wikipedia.org/wiki/XML) format compatible with the open-source\nmultimedia framework MLT, and can be opened in \n[compatible video editors](https://www.mltframework.org/projects/) such as [Shotcut](https://shotcut.com/).\nI have no plans to support other video editors as most are expensive or are exclusive to macOS. \n\n## [FFsilencer](https://github.com/supersonichub1/ffsilencer)\nCLI: `--format ffsilencer`\n\nPython: `Slasher.to_ffsilencer`\n\nThis is a basic plain-text format with a timesecond in seconds on the left and a duration in seconds on the\nright, like `2550 10`. This is inspired by a Bash script I wrote to remove silence from videos with FFmpeg.\nUntil I add some sort of "custom" option to FFsilencer, advanced users can feel free to download and use\n[a modified version of FFsilencer](./slasher.bash) I made for this project.\n\n## [FFmpeg Filter Complex](https://ffmpeg.org/ffmpeg-filters.html)\n__!FOR ADVANCED USERS!__\n\nCLI: `--format ffmpeg`\n\nPython: `Slasher.to_ffmpeg_filter_complex`\n\nThis is an implementation of FFsilencer\'s filter complex creator in Python. The video and audio streams\nused are `[outv]` and `[outa]` respectively. With FFmpeg, use it like this:\n```bash\nffmpeg -hide_banner -i $IN -filter_complex_script $SCRIPT -map [outv] -map [outa] $OUT\n```\n\n## Resources\nFor info on how `timedelta` works, see [the Python docs](https://docs.python.org/3/library/datetime.html#datetime.timedelta).\nTo see what sites *Slasher* supports, see [Chat Downloader](https://github.com/xenova/chat-downloader/#supported-sites)\n\n## License\nhttps://unlicense.org/\n',
    'author': 'Kyle Williams',
    'author_email': 'kyle.anthony.williams2@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/SuperSonicHub1/Slasher',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
