#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Aug 19 10:41:20 2022 by generateDS.py version 2.29.5.
# Python 3.7.6 (default, Jan  8 2020, 13:42:34)  [Clang 4.0.1 (tags/RELEASE_401/final)]
#
# Command line options:
#   ('--root-element', 'emd')
#   ('-f', '')
#   ('-o', '/Users/sanja/IdeaProjects/emdb_schemas/emdb_schemas/v3/v3_0_2_8/emdb.py')
#   ('--no-warnings', '')
#   ('--external-encoding', 'utf-8')
#
# Command line arguments:
#   /Users/sanja/IdeaProjects/emdb_schemas/emdb_schemas/v3/v3_0_2_8/emdb.xsd
#
# Command line:
#   /Users/sanja/Documents/modified_generateDS-2.29.5/generateDS.py --root-element="emd" -f -o "/Users/sanja/IdeaProjects/emdb_schemas/emdb_schemas/v3/v3_0_2_8/emdb.py" --no-warnings --external-encoding="utf-8" /Users/sanja/IdeaProjects/emdb_schemas/emdb_schemas/v3/v3_0_2_8/emdb.xsd
#
# Current working directory (os.getcwd()):
#   emdb_schemas
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            # changed on 17/10/2019
            #if (str(input_data)).endswith('.0'):
            #    return ('%.1f' % input_data)
            #else:
            #    return ('%.2f' % input_data).rstrip('0')
            fl_input_data = float(input_data)
            ret = '%s' % str(fl_input_data)
            if "e" not in str(input_data) and "E" not in str(input_data):
                decimal_places = 1
                if "." in str(input_data) and not str(input_data).endswith('.0'):
                    stripped_input = str(input_data).rstrip("0")
                    index = stripped_input.index(".")
                    len_stripped = len(stripped_input)
                    decimal_places = len_stripped - (index + 1)
                    fl_input_data = float(stripped_input)
                ret = '%.*f' % (decimal_places, fl_input_data)
            return ret
    
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__
        def __ne__(self, other):
            return not self.__eq__(other)
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class entry_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, emdb_id=None, version='3.0.2.8', admin=None, crossreferences=None, sample=None, structure_determination_list=None, map=None, interpretation=None, validation=None):
        self.original_tagname_ = None
        self.emdb_id = _cast(None, emdb_id)
        self.version = _cast(None, version)
        self.admin = admin
        self.crossreferences = crossreferences
        self.sample = sample
        self.structure_determination_list = structure_determination_list
        self.map = map
        self.interpretation = interpretation
        self.validation = validation
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, entry_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if entry_type.subclass:
            return entry_type.subclass(*args_, **kwargs_)
        else:
            return entry_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_admin(self): return self.admin
    def set_admin(self, admin): self.admin = admin
    def get_crossreferences(self): return self.crossreferences
    def set_crossreferences(self, crossreferences): self.crossreferences = crossreferences
    def get_sample(self): return self.sample
    def set_sample(self, sample): self.sample = sample
    def get_structure_determination_list(self): return self.structure_determination_list
    def set_structure_determination_list(self, structure_determination_list): self.structure_determination_list = structure_determination_list
    def get_map(self): return self.map
    def set_map(self, map): self.map = map
    def get_interpretation(self): return self.interpretation
    def set_interpretation(self, interpretation): self.interpretation = interpretation
    def get_validation(self): return self.validation
    def set_validation(self, validation): self.validation = validation
    def get_emdb_id(self): return self.emdb_id
    def set_emdb_id(self, emdb_id): self.emdb_id = emdb_id
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def validate_emdb_id_type(self, value):
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdb_id_type_patterns_, ))
    validate_emdb_id_type_patterns_ = [['EMD-\\d{4,}']]
    def hasContent_(self):
        if (
            self.admin is not None or
            self.crossreferences is not None or
            self.sample is not None or
            self.structure_determination_list is not None or
            self.map is not None or
            self.interpretation is not None or
            self.validation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='entry_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('entry_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entry_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='entry_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='entry_type'):
        if self.emdb_id is not None and 'emdb_id' not in already_processed:
            already_processed.add('emdb_id')
            outfile.write(' emdb_id=%s' % (quote_attrib(self.emdb_id), ))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='entry_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.admin is not None:
            self.admin.export(outfile, level, namespace_, name_='admin', pretty_print=pretty_print)
        if self.crossreferences is not None:
            self.crossreferences.export(outfile, level, namespace_, name_='crossreferences', pretty_print=pretty_print)
        if self.sample is not None:
            self.sample.export(outfile, level, namespace_, name_='sample', pretty_print=pretty_print)
        if self.structure_determination_list is not None:
            self.structure_determination_list.export(outfile, level, namespace_, name_='structure_determination_list', pretty_print=pretty_print)
        if self.map is not None:
            self.map.export(outfile, level, namespace_, name_='map', pretty_print=pretty_print)
        if self.interpretation is not None:
            self.interpretation.export(outfile, level, namespace_, name_='interpretation', pretty_print=pretty_print)
        if self.validation is not None:
            self.validation.export(outfile, level, namespace_, name_='validation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('emdb_id', node)
        if value is not None and 'emdb_id' not in already_processed:
            already_processed.add('emdb_id')
            self.emdb_id = value
            self.emdb_id = ' '.join(self.emdb_id.split())
            self.validate_emdb_id_type(self.emdb_id)    # validate type emdb_id_type
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
            self.version = ' '.join(self.version.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'admin':
            obj_ = admin_type.factory()
            obj_.build(child_)
            self.admin = obj_
            obj_.original_tagname_ = 'admin'
        elif nodeName_ == 'crossreferences':
            obj_ = crossreferences_type.factory()
            obj_.build(child_)
            self.crossreferences = obj_
            obj_.original_tagname_ = 'crossreferences'
        elif nodeName_ == 'sample':
            obj_ = sample_type.factory()
            obj_.build(child_)
            self.sample = obj_
            obj_.original_tagname_ = 'sample'
        elif nodeName_ == 'structure_determination_list':
            obj_ = structure_determination_listType.factory()
            obj_.build(child_)
            self.structure_determination_list = obj_
            obj_.original_tagname_ = 'structure_determination_list'
        elif nodeName_ == 'map':
            obj_ = map_type.factory()
            obj_.build(child_)
            self.map = obj_
            obj_.original_tagname_ = 'map'
        elif nodeName_ == 'interpretation':
            obj_ = interpretation_type.factory()
            obj_.build(child_)
            self.interpretation = obj_
            obj_.original_tagname_ = 'interpretation'
        elif nodeName_ == 'validation':
            obj_ = validationType.factory()
            obj_.build(child_)
            self.validation = obj_
            obj_.original_tagname_ = 'validation'
# end class entry_type


class admin_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, status_history_list=None, current_status=None, sites=None, key_dates=None, obsolete_list=None, superseded_by_list=None, grant_support=None, microscopy_center=None, contact_author=None, title=None, authors_list=None, details=None, keywords=None, replace_existing_entry=None):
        self.original_tagname_ = None
        self.status_history_list = status_history_list
        self.current_status = current_status
        self.sites = sites
        self.key_dates = key_dates
        self.obsolete_list = obsolete_list
        self.superseded_by_list = superseded_by_list
        self.grant_support = grant_support
        self.microscopy_center = microscopy_center
        if contact_author is None:
            self.contact_author = []
        else:
            self.contact_author = contact_author
        self.title = title
        self.authors_list = authors_list
        self.details = details
        self.keywords = keywords
        self.replace_existing_entry = replace_existing_entry
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, admin_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if admin_type.subclass:
            return admin_type.subclass(*args_, **kwargs_)
        else:
            return admin_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status_history_list(self): return self.status_history_list
    def set_status_history_list(self, status_history_list): self.status_history_list = status_history_list
    def get_current_status(self): return self.current_status
    def set_current_status(self, current_status): self.current_status = current_status
    def get_sites(self): return self.sites
    def set_sites(self, sites): self.sites = sites
    def get_key_dates(self): return self.key_dates
    def set_key_dates(self, key_dates): self.key_dates = key_dates
    def get_obsolete_list(self): return self.obsolete_list
    def set_obsolete_list(self, obsolete_list): self.obsolete_list = obsolete_list
    def get_superseded_by_list(self): return self.superseded_by_list
    def set_superseded_by_list(self, superseded_by_list): self.superseded_by_list = superseded_by_list
    def get_grant_support(self): return self.grant_support
    def set_grant_support(self, grant_support): self.grant_support = grant_support
    def get_microscopy_center(self): return self.microscopy_center
    def set_microscopy_center(self, microscopy_center): self.microscopy_center = microscopy_center
    def get_contact_author(self): return self.contact_author
    def set_contact_author(self, contact_author): self.contact_author = contact_author
    def add_contact_author(self, value): self.contact_author.append(value)
    def insert_contact_author_at(self, index, value): self.contact_author.insert(index, value)
    def replace_contact_author_at(self, index, value): self.contact_author[index] = value
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_authors_list(self): return self.authors_list
    def set_authors_list(self, authors_list): self.authors_list = authors_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_keywords(self): return self.keywords
    def set_keywords(self, keywords): self.keywords = keywords
    def get_replace_existing_entry(self): return self.replace_existing_entry
    def set_replace_existing_entry(self, replace_existing_entry): self.replace_existing_entry = replace_existing_entry
    def hasContent_(self):
        if (
            self.status_history_list is not None or
            self.current_status is not None or
            self.sites is not None or
            self.key_dates is not None or
            self.obsolete_list is not None or
            self.superseded_by_list is not None or
            self.grant_support is not None or
            self.microscopy_center is not None or
            self.contact_author or
            self.title is not None or
            self.authors_list is not None or
            self.details is not None or
            self.keywords is not None or
            self.replace_existing_entry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='admin_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('admin_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='admin_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='admin_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='admin_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='admin_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.status_history_list is not None:
            self.status_history_list.export(outfile, level, namespace_, name_='status_history_list', pretty_print=pretty_print)
        if self.current_status is not None:
            self.current_status.export(outfile, level, namespace_, name_='current_status', pretty_print=pretty_print)
        if self.sites is not None:
            self.sites.export(outfile, level, namespace_, name_='sites', pretty_print=pretty_print)
        if self.key_dates is not None:
            self.key_dates.export(outfile, level, namespace_, name_='key_dates', pretty_print=pretty_print)
        if self.obsolete_list is not None:
            self.obsolete_list.export(outfile, level, namespace_, name_='obsolete_list', pretty_print=pretty_print)
        if self.superseded_by_list is not None:
            self.superseded_by_list.export(outfile, level, namespace_, name_='superseded_by_list', pretty_print=pretty_print)
        if self.grant_support is not None:
            self.grant_support.export(outfile, level, namespace_, name_='grant_support', pretty_print=pretty_print)
        if self.microscopy_center is not None:
            self.microscopy_center.export(outfile, level, namespace_, name_='microscopy_center', pretty_print=pretty_print)
        for contact_author_ in self.contact_author:
            contact_author_.export(outfile, level, namespace_, name_='contact_author', pretty_print=pretty_print)
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.authors_list is not None:
            self.authors_list.export(outfile, level, namespace_, name_='authors_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
        if self.keywords is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<keywords>%s</keywords>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.keywords), input_name='keywords')), eol_))
        if self.replace_existing_entry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<replace_existing_entry>%s</replace_existing_entry>%s' % (self.gds_format_boolean(self.replace_existing_entry, input_name='replace_existing_entry'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'status_history_list':
            obj_ = version_list_type.factory()
            obj_.build(child_)
            self.status_history_list = obj_
            obj_.original_tagname_ = 'status_history_list'
        elif nodeName_ == 'current_status':
            class_obj_ = self.get_class_obj_(child_, version_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.current_status = obj_
            obj_.original_tagname_ = 'current_status'
        elif nodeName_ == 'sites':
            obj_ = sitesType.factory()
            obj_.build(child_)
            self.sites = obj_
            obj_.original_tagname_ = 'sites'
        elif nodeName_ == 'key_dates':
            obj_ = key_datesType.factory()
            obj_.build(child_)
            self.key_dates = obj_
            obj_.original_tagname_ = 'key_dates'
        elif nodeName_ == 'obsolete_list':
            obj_ = obsolete_listType.factory()
            obj_.build(child_)
            self.obsolete_list = obj_
            obj_.original_tagname_ = 'obsolete_list'
        elif nodeName_ == 'superseded_by_list':
            obj_ = superseded_by_listType.factory()
            obj_.build(child_)
            self.superseded_by_list = obj_
            obj_.original_tagname_ = 'superseded_by_list'
        elif nodeName_ == 'grant_support':
            obj_ = grant_supportType.factory()
            obj_.build(child_)
            self.grant_support = obj_
            obj_.original_tagname_ = 'grant_support'
        elif nodeName_ == 'microscopy_center':
            obj_ = microscopy_centerType.factory()
            obj_.build(child_)
            self.microscopy_center = obj_
            obj_.original_tagname_ = 'microscopy_center'
        elif nodeName_ == 'contact_author':
            obj_ = contact_authorType.factory()
            obj_.build(child_)
            self.contact_author.append(obj_)
            obj_.original_tagname_ = 'contact_author'
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'authors_list':
            obj_ = authors_listType.factory()
            obj_.build(child_)
            self.authors_list = obj_
            obj_.original_tagname_ = 'authors_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            if details_:
                details_ = re_.sub(String_cleanup_pat_, " ", details_).strip()
            else:
                details_ = ""
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'keywords':
            keywords_ = child_.text
            keywords_ = self.gds_validate_string(keywords_, node, 'keywords')
            self.keywords = keywords_
        elif nodeName_ == 'replace_existing_entry':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'replace_existing_entry')
            self.replace_existing_entry = ival_
# end class admin_type


class version_list_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, status=None):
        self.original_tagname_ = None
        if status is None:
            self.status = []
        else:
            self.status = status
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, version_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if version_list_type.subclass:
            return version_list_type.subclass(*args_, **kwargs_)
        else:
            return version_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def add_status(self, value): self.status.append(value)
    def insert_status_at(self, index, value): self.status.insert(index, value)
    def replace_status_at(self, index, value): self.status[index] = value
    def hasContent_(self):
        if (
            self.status
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='version_list_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('version_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='version_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='version_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='version_list_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='version_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for status_ in self.status:
            status_.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'status':
            obj_ = statusType.factory()
            obj_.build(child_)
            self.status.append(obj_)
            obj_.original_tagname_ = 'status'
# end class version_list_type


class version_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, date=None, code=None, processing_site=None, annotator=None, details=None, extensiontype_=None):
        self.original_tagname_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.code = code
        self.processing_site = processing_site
        self.validate_processing_siteType(self.processing_site)
        self.annotator = annotator
        self.details = details
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, version_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if version_type.subclass:
            return version_type.subclass(*args_, **kwargs_)
        else:
            return version_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_processing_site(self): return self.processing_site
    def set_processing_site(self, processing_site): self.processing_site = processing_site
    def get_annotator(self): return self.annotator
    def set_annotator(self, annotator): self.annotator = annotator
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_dateType(self, value):
        # Validate type dateType, a restriction on xs:date.
        if value is not None and Validate_simpletypes_:
            if value < self.gds_parse_date('2002-01-01'):
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on dateType' % {"value" : value} )
    def validate_processing_siteType(self, value):
        # Validate type processing_siteType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PDBe', 'RCSB', 'PDBj', 'PDBc']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on processing_siteType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.date is not None or
            self.code is not None or
            self.processing_site is not None or
            self.annotator is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='version_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('version_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='version_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='version_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='version_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='version_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<date>%s</date>%s' % (self.gds_format_date(self.date, input_name='date'), eol_))
        if self.code is not None:
            self.code.export(outfile, level, namespace_, name_='code', pretty_print=pretty_print)
        if self.processing_site is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<processing_site>%s</processing_site>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.processing_site), input_name='processing_site')), eol_))
        if self.annotator is not None:
            self.annotator.export(outfile, level, namespace_, name_='annotator', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
            # validate type dateType
            self.validate_dateType(self.date)
        elif nodeName_ == 'code':
            obj_ = code_type.factory()
            obj_.build(child_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'processing_site':
            processing_site_ = child_.text
            if processing_site_:
                processing_site_ = re_.sub(String_cleanup_pat_, " ", processing_site_).strip()
            else:
                processing_site_ = ""
            processing_site_ = self.gds_validate_string(processing_site_, node, 'processing_site')
            self.processing_site = processing_site_
            # validate type processing_siteType
            self.validate_processing_siteType(self.processing_site)
        elif nodeName_ == 'annotator':
            obj_ = annotatorType.factory()
            obj_.build(child_)
            self.annotator = obj_
            obj_.original_tagname_ = 'annotator'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class version_type


class code_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, superseded=None, supersedes=None, valueOf_=None):
        self.original_tagname_ = None
        self.superseded = _cast(bool, superseded)
        self.supersedes = _cast(bool, supersedes)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, code_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if code_type.subclass:
            return code_type.subclass(*args_, **kwargs_)
        else:
            return code_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_superseded(self): return self.superseded
    def set_superseded(self, superseded): self.superseded = superseded
    def get_supersedes(self): return self.supersedes
    def set_supersedes(self, supersedes): self.supersedes = supersedes
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='code_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('code_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='code_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='code_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='code_type'):
        if self.superseded is not None and 'superseded' not in already_processed:
            already_processed.add('superseded')
            outfile.write(' superseded="%s"' % self.gds_format_boolean(self.superseded, input_name='superseded'))
        if self.supersedes is not None and 'supersedes' not in already_processed:
            already_processed.add('supersedes')
            outfile.write(' supersedes="%s"' % self.gds_format_boolean(self.supersedes, input_name='supersedes'))
    def exportChildren(self, outfile, level, namespace_='', name_='code_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('superseded', node)
        if value is not None and 'superseded' not in already_processed:
            already_processed.add('superseded')
            if value in ('true', '1'):
                self.superseded = True
            elif value in ('false', '0'):
                self.superseded = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('supersedes', node)
        if value is not None and 'supersedes' not in already_processed:
            already_processed.add('supersedes')
            if value in ('true', '1'):
                self.supersedes = True
            elif value in ('false', '0'):
                self.supersedes = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class code_type


class supersedes_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, date=None, entry=None, details=None):
        self.original_tagname_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.entry = entry
        self.validate_emdb_id_type(self.entry)
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, supersedes_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if supersedes_type.subclass:
            return supersedes_type.subclass(*args_, **kwargs_)
        else:
            return supersedes_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_entry(self): return self.entry
    def set_entry(self, entry): self.entry = entry
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_emdb_id_type(self, value):
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdb_id_type_patterns_, ))
    validate_emdb_id_type_patterns_ = [['EMD-\\d{4,}']]
    def hasContent_(self):
        if (
            self.date is not None or
            self.entry is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='supersedes_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('supersedes_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='supersedes_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='supersedes_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='supersedes_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='supersedes_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<date>%s</date>%s' % (self.gds_format_date(self.date, input_name='date'), eol_))
        if self.entry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<entry>%s</entry>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.entry), input_name='entry')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
        elif nodeName_ == 'entry':
            entry_ = child_.text
            if entry_:
                entry_ = re_.sub(String_cleanup_pat_, " ", entry_).strip()
            else:
                entry_ = ""
            entry_ = self.gds_validate_string(entry_, node, 'entry')
            self.entry = entry_
            # validate type emdb_id_type
            self.validate_emdb_id_type(self.entry)
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class supersedes_type


class grant_reference_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, funding_body=None, code=None, country=None):
        self.original_tagname_ = None
        self.funding_body = funding_body
        self.code = code
        self.country = country
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grant_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grant_reference_type.subclass:
            return grant_reference_type.subclass(*args_, **kwargs_)
        else:
            return grant_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_funding_body(self): return self.funding_body
    def set_funding_body(self, funding_body): self.funding_body = funding_body
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def hasContent_(self):
        if (
            self.funding_body is not None or
            self.code is not None or
            self.country is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='grant_reference_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grant_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='grant_reference_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='grant_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='grant_reference_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='grant_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.funding_body is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<funding_body>%s</funding_body>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.funding_body), input_name='funding_body')), eol_))
        if self.code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<code>%s</code>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.code), input_name='code')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'funding_body':
            funding_body_ = child_.text
            if funding_body_:
                funding_body_ = re_.sub(String_cleanup_pat_, " ", funding_body_).strip()
            else:
                funding_body_ = ""
            funding_body_ = self.gds_validate_string(funding_body_, node, 'funding_body')
            self.funding_body = funding_body_
        elif nodeName_ == 'code':
            code_ = child_.text
            if code_:
                code_ = re_.sub(String_cleanup_pat_, " ", code_).strip()
            else:
                code_ = ""
            code_ = self.gds_validate_string(code_, node, 'code')
            self.code = code_
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
# end class grant_reference_type


class contact_details_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, role=None, title=None, first_name=None, middle_name=None, last_name=None, organization=None, street=None, town_or_city=None, state_or_province=None, country=None, post_or_zip_code=None, email=None, telephone=None, fax=None, extensiontype_=None):
        self.original_tagname_ = None
        self.role = role
        self.validate_roleType(self.role)
        self.title = title
        self.validate_titleType(self.title)
        self.first_name = first_name
        self.middle_name = middle_name
        self.validate_middle_nameType(self.middle_name)
        self.last_name = last_name
        self.organization = organization
        self.street = street
        self.town_or_city = town_or_city
        self.state_or_province = state_or_province
        self.country = country
        self.post_or_zip_code = post_or_zip_code
        self.email = email
        self.validate_emailType(self.email)
        self.telephone = telephone
        self.fax = fax
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contact_details_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contact_details_type.subclass:
            return contact_details_type.subclass(*args_, **kwargs_)
        else:
            return contact_details_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_first_name(self): return self.first_name
    def set_first_name(self, first_name): self.first_name = first_name
    def get_middle_name(self): return self.middle_name
    def set_middle_name(self, middle_name): self.middle_name = middle_name
    def get_last_name(self): return self.last_name
    def set_last_name(self, last_name): self.last_name = last_name
    def get_organization(self): return self.organization
    def set_organization(self, organization): self.organization = organization
    def get_street(self): return self.street
    def set_street(self, street): self.street = street
    def get_town_or_city(self): return self.town_or_city
    def set_town_or_city(self, town_or_city): self.town_or_city = town_or_city
    def get_state_or_province(self): return self.state_or_province
    def set_state_or_province(self, state_or_province): self.state_or_province = state_or_province
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_post_or_zip_code(self): return self.post_or_zip_code
    def set_post_or_zip_code(self, post_or_zip_code): self.post_or_zip_code = post_or_zip_code
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_telephone(self): return self.telephone
    def set_telephone(self, telephone): self.telephone = telephone
    def get_fax(self): return self.fax
    def set_fax(self, fax): self.fax = fax
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_roleType(self, value):
        # Validate type roleType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['INVESTIGATOR', 'PRINCIPAL INVESTIGATOR/GROUP LEADER', 'RESPONSIBLE SCIENTIST']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on roleType' % {"value" : value.encode("utf-8")} )
    def validate_titleType(self, value):
        # Validate type titleType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DR.', 'MR.', 'MRS.', 'MS.', 'PROF.']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on titleType' % {"value" : value.encode("utf-8")} )
    def validate_middle_nameType(self, value):
        # Validate type middle_nameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_middle_nameType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_middle_nameType_patterns_, ))
    validate_middle_nameType_patterns_ = [['[A-Z]']]
    def validate_emailType(self, value):
        # Validate type emailType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emailType_patterns_, ))
    validate_emailType_patterns_ = [['[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}']]
    def hasContent_(self):
        if (
            self.role is not None or
            self.title is not None or
            self.first_name is not None or
            self.middle_name is not None or
            self.last_name is not None or
            self.organization is not None or
            self.street is not None or
            self.town_or_city is not None or
            self.state_or_province is not None or
            self.country is not None or
            self.post_or_zip_code is not None or
            self.email is not None or
            self.telephone is not None or
            self.fax is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contact_details_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('contact_details_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contact_details_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contact_details_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contact_details_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='contact_details_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.role is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<role>%s</role>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.role), input_name='role')), eol_))
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.first_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<first_name>%s</first_name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.first_name), input_name='first_name')), eol_))
        if self.middle_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<middle_name>%s</middle_name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.middle_name), input_name='middle_name')), eol_))
        if self.last_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<last_name>%s</last_name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.last_name), input_name='last_name')), eol_))
        if self.organization is not None:
            self.organization.export(outfile, level, namespace_, name_='organization', pretty_print=pretty_print)
        if self.street is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<street>%s</street>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.street), input_name='street')), eol_))
        if self.town_or_city is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<town_or_city>%s</town_or_city>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.town_or_city), input_name='town_or_city')), eol_))
        if self.state_or_province is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<state_or_province>%s</state_or_province>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.state_or_province), input_name='state_or_province')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
        if self.post_or_zip_code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<post_or_zip_code>%s</post_or_zip_code>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.post_or_zip_code), input_name='post_or_zip_code')), eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<email>%s</email>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), eol_))
        if self.telephone is not None:
            self.telephone.export(outfile, level, namespace_, name_='telephone', pretty_print=pretty_print)
        if self.fax is not None:
            self.fax.export(outfile, level, namespace_, name_='fax', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            role_ = child_.text
            if role_:
                role_ = re_.sub(String_cleanup_pat_, " ", role_).strip()
            else:
                role_ = ""
            role_ = self.gds_validate_string(role_, node, 'role')
            self.role = role_
            # validate type roleType
            self.validate_roleType(self.role)
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
            # validate type titleType
            self.validate_titleType(self.title)
        elif nodeName_ == 'first_name':
            first_name_ = child_.text
            if first_name_:
                first_name_ = re_.sub(String_cleanup_pat_, " ", first_name_).strip()
            else:
                first_name_ = ""
            first_name_ = self.gds_validate_string(first_name_, node, 'first_name')
            self.first_name = first_name_
        elif nodeName_ == 'middle_name':
            middle_name_ = child_.text
            if middle_name_:
                middle_name_ = re_.sub(String_cleanup_pat_, " ", middle_name_).strip()
            else:
                middle_name_ = ""
            middle_name_ = self.gds_validate_string(middle_name_, node, 'middle_name')
            self.middle_name = middle_name_
            # validate type middle_nameType
            self.validate_middle_nameType(self.middle_name)
        elif nodeName_ == 'last_name':
            last_name_ = child_.text
            if last_name_:
                last_name_ = re_.sub(String_cleanup_pat_, " ", last_name_).strip()
            else:
                last_name_ = ""
            last_name_ = self.gds_validate_string(last_name_, node, 'last_name')
            self.last_name = last_name_
        elif nodeName_ == 'organization':
            obj_ = organizationType.factory()
            obj_.build(child_)
            self.organization = obj_
            obj_.original_tagname_ = 'organization'
        elif nodeName_ == 'street':
            street_ = child_.text
            street_ = self.gds_validate_string(street_, node, 'street')
            self.street = street_
        elif nodeName_ == 'town_or_city':
            town_or_city_ = child_.text
            if town_or_city_:
                town_or_city_ = re_.sub(String_cleanup_pat_, " ", town_or_city_).strip()
            else:
                town_or_city_ = ""
            town_or_city_ = self.gds_validate_string(town_or_city_, node, 'town_or_city')
            self.town_or_city = town_or_city_
        elif nodeName_ == 'state_or_province':
            state_or_province_ = child_.text
            if state_or_province_:
                state_or_province_ = re_.sub(String_cleanup_pat_, " ", state_or_province_).strip()
            else:
                state_or_province_ = ""
            state_or_province_ = self.gds_validate_string(state_or_province_, node, 'state_or_province')
            self.state_or_province = state_or_province_
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'post_or_zip_code':
            post_or_zip_code_ = child_.text
            if post_or_zip_code_:
                post_or_zip_code_ = re_.sub(String_cleanup_pat_, " ", post_or_zip_code_).strip()
            else:
                post_or_zip_code_ = ""
            post_or_zip_code_ = self.gds_validate_string(post_or_zip_code_, node, 'post_or_zip_code')
            self.post_or_zip_code = post_or_zip_code_
        elif nodeName_ == 'email':
            email_ = child_.text
            if email_:
                email_ = re_.sub(String_cleanup_pat_, " ", email_).strip()
            else:
                email_ = ""
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
            # validate type emailType
            self.validate_emailType(self.email)
        elif nodeName_ == 'telephone':
            obj_ = telephone_number_type.factory()
            obj_.build(child_)
            self.telephone = obj_
            obj_.original_tagname_ = 'telephone'
        elif nodeName_ == 'fax':
            obj_ = telephone_number_type.factory()
            obj_.build(child_)
            self.fax = obj_
            obj_.original_tagname_ = 'fax'
# end class contact_details_type


class telephone_number_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, country=None, area=None, local=None):
        self.original_tagname_ = None
        self.country = country
        self.validate_countryType1(self.country)
        self.area = area
        self.validate_areaType(self.area)
        self.local = local
        self.validate_localType(self.local)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, telephone_number_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if telephone_number_type.subclass:
            return telephone_number_type.subclass(*args_, **kwargs_)
        else:
            return telephone_number_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_area(self): return self.area
    def set_area(self, area): self.area = area
    def get_local(self): return self.local
    def set_local(self, local): self.local = local
    def validate_countryType1(self, value):
        # Validate type countryType1, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_countryType1_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_countryType1_patterns_, ))
    validate_countryType1_patterns_ = [['\\d{1,3}']]
    def validate_areaType(self, value):
        # Validate type areaType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_areaType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_areaType_patterns_, ))
    validate_areaType_patterns_ = [['\\d{2,5}']]
    def validate_localType(self, value):
        # Validate type localType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_localType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_localType_patterns_, ))
    validate_localType_patterns_ = [['\\d+( ext. \\d+)?']]
    def hasContent_(self):
        if (
            self.country is not None or
            self.area is not None or
            self.local is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='telephone_number_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('telephone_number_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='telephone_number_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='telephone_number_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='telephone_number_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='telephone_number_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
        if self.area is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<area>%s</area>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.area), input_name='area')), eol_))
        if self.local is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<local>%s</local>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.local), input_name='local')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
            # validate type countryType1
            self.validate_countryType1(self.country)
        elif nodeName_ == 'area':
            area_ = child_.text
            if area_:
                area_ = re_.sub(String_cleanup_pat_, " ", area_).strip()
            else:
                area_ = ""
            area_ = self.gds_validate_string(area_, node, 'area')
            self.area = area_
            # validate type areaType
            self.validate_areaType(self.area)
        elif nodeName_ == 'local':
            local_ = child_.text
            if local_:
                local_ = re_.sub(String_cleanup_pat_, " ", local_).strip()
            else:
                local_ = ""
            local_ = self.gds_validate_string(local_, node, 'local')
            self.local = local_
            # validate type localType
            self.validate_localType(self.local)
# end class telephone_number_type


class author_ORCID_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ORCID=None, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.ORCID = _cast(None, ORCID)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, author_ORCID_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if author_ORCID_type.subclass:
            return author_ORCID_type.subclass(*args_, **kwargs_)
        else:
            return author_ORCID_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ORCID(self): return self.ORCID
    def set_ORCID(self, ORCID): self.ORCID = ORCID
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_ORCID_type(self, value):
        # Validate type ORCID_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_ORCID_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ORCID_type_patterns_, ))
    validate_ORCID_type_patterns_ = [['[0-9]{4}-[0-9]{4}-[0-9]{4}-([0-9]{3}X|[0-9]{4})']]
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='author_ORCID_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('author_ORCID_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='author_ORCID_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='author_ORCID_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='author_ORCID_type'):
        if self.ORCID is not None and 'ORCID' not in already_processed:
            already_processed.add('ORCID')
            outfile.write(' ORCID=%s' % (quote_attrib(self.ORCID), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='author_ORCID_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ORCID', node)
        if value is not None and 'ORCID' not in already_processed:
            already_processed.add('ORCID')
            self.ORCID = value
            self.ORCID = ' '.join(self.ORCID.split())
            self.validate_ORCID_type(self.ORCID)    # validate type ORCID_type
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class author_ORCID_type


class author_order_type(author_ORCID_type):
    subclass = None
    superclass = author_ORCID_type
    def __init__(self, ORCID=None, order=None, valueOf_=None):
        self.original_tagname_ = None
        super(author_order_type, self).__init__(ORCID, valueOf_, )
        self.order = _cast(int, order)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, author_order_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if author_order_type.subclass:
            return author_order_type.subclass(*args_, **kwargs_)
        else:
            return author_order_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_order(self): return self.order
    def set_order(self, order): self.order = order
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(author_order_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='author_order_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('author_order_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='author_order_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='author_order_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='author_order_type'):
        super(author_order_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='author_order_type')
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
    def exportChildren(self, outfile, level, namespace_='', name_='author_order_type', fromsubclass_=False, pretty_print=True):
        super(author_order_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            try:
                self.order = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.order <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(author_order_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class author_order_type


class crossreferences_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, citation_list=None, emdb_list=None, pdb_list=None, auxiliary_link_list=None):
        self.original_tagname_ = None
        self.citation_list = citation_list
        self.emdb_list = emdb_list
        self.pdb_list = pdb_list
        self.auxiliary_link_list = auxiliary_link_list
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crossreferences_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crossreferences_type.subclass:
            return crossreferences_type.subclass(*args_, **kwargs_)
        else:
            return crossreferences_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_citation_list(self): return self.citation_list
    def set_citation_list(self, citation_list): self.citation_list = citation_list
    def get_emdb_list(self): return self.emdb_list
    def set_emdb_list(self, emdb_list): self.emdb_list = emdb_list
    def get_pdb_list(self): return self.pdb_list
    def set_pdb_list(self, pdb_list): self.pdb_list = pdb_list
    def get_auxiliary_link_list(self): return self.auxiliary_link_list
    def set_auxiliary_link_list(self, auxiliary_link_list): self.auxiliary_link_list = auxiliary_link_list
    def hasContent_(self):
        if (
            self.citation_list is not None or
            self.emdb_list is not None or
            self.pdb_list is not None or
            self.auxiliary_link_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crossreferences_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crossreferences_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crossreferences_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crossreferences_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crossreferences_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='crossreferences_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.citation_list is not None:
            self.citation_list.export(outfile, level, namespace_, name_='citation_list', pretty_print=pretty_print)
        if self.emdb_list is not None:
            self.emdb_list.export(outfile, level, namespace_, name_='emdb_list', pretty_print=pretty_print)
        if self.pdb_list is not None:
            self.pdb_list.export(outfile, level, namespace_, name_='pdb_list', pretty_print=pretty_print)
        if self.auxiliary_link_list is not None:
            self.auxiliary_link_list.export(outfile, level, namespace_, name_='auxiliary_link_list', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'citation_list':
            obj_ = citation_listType.factory()
            obj_.build(child_)
            self.citation_list = obj_
            obj_.original_tagname_ = 'citation_list'
        elif nodeName_ == 'emdb_list':
            obj_ = emdb_cross_reference_list_type.factory()
            obj_.build(child_)
            self.emdb_list = obj_
            obj_.original_tagname_ = 'emdb_list'
        elif nodeName_ == 'pdb_list':
            obj_ = pdb_cross_reference_list_type.factory()
            obj_.build(child_)
            self.pdb_list = obj_
            obj_.original_tagname_ = 'pdb_list'
        elif nodeName_ == 'auxiliary_link_list':
            obj_ = auxiliary_link_listType.factory()
            obj_.build(child_)
            self.auxiliary_link_list = obj_
            obj_.original_tagname_ = 'auxiliary_link_list'
# end class crossreferences_type


class citation_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, citation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if citation_type.subclass:
            return citation_type.subclass(*args_, **kwargs_)
        else:
            return citation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='citation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('citation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='citation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='citation_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='citation_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='citation_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class citation_type


class journal_citation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, published=None, author=None, title=None, journal=None, journal_abbreviation=None, country=None, issue=None, volume=None, first_page=None, last_page=None, year=None, language=None, external_references=None, details=None):
        self.original_tagname_ = None
        self.published = _cast(bool, published)
        if author is None:
            self.author = []
        else:
            self.author = author
        self.title = title
        self.journal = journal
        self.journal_abbreviation = journal_abbreviation
        self.country = country
        self.issue = issue
        self.volume = volume
        self.first_page = first_page
        self.validate_page_type(self.first_page)
        self.last_page = last_page
        self.validate_page_type(self.last_page)
        self.year = year
        self.validate_yearType(self.year)
        self.language = language
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, journal_citation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if journal_citation.subclass:
            return journal_citation.subclass(*args_, **kwargs_)
        else:
            return journal_citation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_journal(self): return self.journal
    def set_journal(self, journal): self.journal = journal
    def get_journal_abbreviation(self): return self.journal_abbreviation
    def set_journal_abbreviation(self, journal_abbreviation): self.journal_abbreviation = journal_abbreviation
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_issue(self): return self.issue
    def set_issue(self, issue): self.issue = issue
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_first_page(self): return self.first_page
    def set_first_page(self, first_page): self.first_page = first_page
    def get_last_page(self): return self.last_page
    def set_last_page(self, last_page): self.last_page = last_page
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_external_references(self): return self.external_references
    def set_external_references(self, external_references): self.external_references = external_references
    def add_external_references(self, value): self.external_references.append(value)
    def insert_external_references_at(self, index, value): self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value): self.external_references[index] = value
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def validate_page_type(self, value):
        # Validate type page_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_yearType(self, value):
        # Validate type yearType, a restriction on xs:gYear.
        if value is not None and Validate_simpletypes_:
            if value < 1900:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on yearType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.author or
            self.title is not None or
            self.journal is not None or
            self.journal_abbreviation is not None or
            self.country is not None or
            self.issue is not None or
            self.volume is not None or
            self.first_page is not None or
            self.last_page is not None or
            self.year is not None or
            self.language is not None or
            self.external_references or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='journal_citation', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('journal_citation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='journal_citation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='journal_citation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='journal_citation'):
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def exportChildren(self, outfile, level, namespace_='', name_='journal_citation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.journal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<journal>%s</journal>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.journal), input_name='journal')), eol_))
        if self.journal_abbreviation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<journal_abbreviation>%s</journal_abbreviation>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.journal_abbreviation), input_name='journal_abbreviation')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
        if self.issue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<issue>%s</issue>%s' % (self.gds_format_integer(self.issue, input_name='issue'), eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<volume>%s</volume>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), eol_))
        if self.first_page is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<first_page>%s</first_page>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.first_page), input_name='first_page')), eol_))
        if self.last_page is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<last_page>%s</last_page>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.last_page), input_name='last_page')), eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<year>%s</year>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), eol_))
        if self.language is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<language>%s</language>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.language), input_name='language')), eol_))
        for external_references_ in self.external_references:
            external_references_.export(outfile, level, namespace_, name_='external_references', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'author':
            obj_ = author_order_type.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'journal':
            journal_ = child_.text
            if journal_:
                journal_ = re_.sub(String_cleanup_pat_, " ", journal_).strip()
            else:
                journal_ = ""
            journal_ = self.gds_validate_string(journal_, node, 'journal')
            self.journal = journal_
        elif nodeName_ == 'journal_abbreviation':
            journal_abbreviation_ = child_.text
            if journal_abbreviation_:
                journal_abbreviation_ = re_.sub(String_cleanup_pat_, " ", journal_abbreviation_).strip()
            else:
                journal_abbreviation_ = ""
            journal_abbreviation_ = self.gds_validate_string(journal_abbreviation_, node, 'journal_abbreviation')
            self.journal_abbreviation = journal_abbreviation_
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'issue':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'issue')
            self.issue = ival_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'first_page':
            first_page_ = child_.text
            first_page_ = self.gds_validate_string(first_page_, node, 'first_page')
            self.first_page = first_page_
            # validate type page_type
            self.validate_page_type(self.first_page)
        elif nodeName_ == 'last_page':
            last_page_ = child_.text
            last_page_ = self.gds_validate_string(last_page_, node, 'last_page')
            self.last_page = last_page_
            # validate type page_type
            self.validate_page_type(self.last_page)
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
            # validate type yearType
            self.validate_yearType(self.year)
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType.factory()
            obj_.build(child_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class journal_citation


class non_journal_citation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, published=None, author=None, editor=None, title=None, thesis_title=None, chapter_title=None, volume=None, publisher=None, publisher_location=None, first_page=None, last_page=None, year=None, language=None, external_references=None, details=None):
        self.original_tagname_ = None
        self.published = _cast(bool, published)
        if author is None:
            self.author = []
        else:
            self.author = author
        if editor is None:
            self.editor = []
        else:
            self.editor = editor
        self.title = title
        self.thesis_title = thesis_title
        self.chapter_title = chapter_title
        self.volume = volume
        self.publisher = publisher
        self.publisher_location = publisher_location
        self.first_page = first_page
        self.validate_page_type(self.first_page)
        self.last_page = last_page
        self.validate_page_type(self.last_page)
        self.year = year
        self.validate_yearType2(self.year)
        self.language = language
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, non_journal_citation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if non_journal_citation.subclass:
            return non_journal_citation.subclass(*args_, **kwargs_)
        else:
            return non_journal_citation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_editor(self): return self.editor
    def set_editor(self, editor): self.editor = editor
    def add_editor(self, value): self.editor.append(value)
    def insert_editor_at(self, index, value): self.editor.insert(index, value)
    def replace_editor_at(self, index, value): self.editor[index] = value
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_thesis_title(self): return self.thesis_title
    def set_thesis_title(self, thesis_title): self.thesis_title = thesis_title
    def get_chapter_title(self): return self.chapter_title
    def set_chapter_title(self, chapter_title): self.chapter_title = chapter_title
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_publisher(self): return self.publisher
    def set_publisher(self, publisher): self.publisher = publisher
    def get_publisher_location(self): return self.publisher_location
    def set_publisher_location(self, publisher_location): self.publisher_location = publisher_location
    def get_first_page(self): return self.first_page
    def set_first_page(self, first_page): self.first_page = first_page
    def get_last_page(self): return self.last_page
    def set_last_page(self, last_page): self.last_page = last_page
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_external_references(self): return self.external_references
    def set_external_references(self, external_references): self.external_references = external_references
    def add_external_references(self, value): self.external_references.append(value)
    def insert_external_references_at(self, index, value): self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value): self.external_references[index] = value
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def validate_page_type(self, value):
        # Validate type page_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_yearType2(self, value):
        # Validate type yearType2, a restriction on xs:gYear.
        if value is not None and Validate_simpletypes_:
            if value < 1900:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on yearType2' % {"value" : value} )
    def hasContent_(self):
        if (
            self.author or
            self.editor or
            self.title is not None or
            self.thesis_title is not None or
            self.chapter_title is not None or
            self.volume is not None or
            self.publisher is not None or
            self.publisher_location is not None or
            self.first_page is not None or
            self.last_page is not None or
            self.year is not None or
            self.language is not None or
            self.external_references or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='non_journal_citation', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('non_journal_citation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='non_journal_citation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='non_journal_citation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='non_journal_citation'):
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def exportChildren(self, outfile, level, namespace_='', name_='non_journal_citation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        for editor_ in self.editor:
            editor_.export(outfile, level, namespace_, name_='editor', pretty_print=pretty_print)
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.thesis_title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<thesis_title>%s</thesis_title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.thesis_title), input_name='thesis_title')), eol_))
        if self.chapter_title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<chapter_title>%s</chapter_title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.chapter_title), input_name='chapter_title')), eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<volume>%s</volume>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), eol_))
        if self.publisher is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<publisher>%s</publisher>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.publisher), input_name='publisher')), eol_))
        if self.publisher_location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<publisher_location>%s</publisher_location>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.publisher_location), input_name='publisher_location')), eol_))
        if self.first_page is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<first_page>%s</first_page>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.first_page), input_name='first_page')), eol_))
        if self.last_page is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<last_page>%s</last_page>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.last_page), input_name='last_page')), eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<year>%s</year>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), eol_))
        if self.language is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<language>%s</language>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.language), input_name='language')), eol_))
        for external_references_ in self.external_references:
            external_references_.export(outfile, level, namespace_, name_='external_references', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'author':
            obj_ = author_order_type.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'editor':
            obj_ = author_order_type.factory()
            obj_.build(child_)
            self.editor.append(obj_)
            obj_.original_tagname_ = 'editor'
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'thesis_title':
            thesis_title_ = child_.text
            if thesis_title_:
                thesis_title_ = re_.sub(String_cleanup_pat_, " ", thesis_title_).strip()
            else:
                thesis_title_ = ""
            thesis_title_ = self.gds_validate_string(thesis_title_, node, 'thesis_title')
            self.thesis_title = thesis_title_
        elif nodeName_ == 'chapter_title':
            chapter_title_ = child_.text
            if chapter_title_:
                chapter_title_ = re_.sub(String_cleanup_pat_, " ", chapter_title_).strip()
            else:
                chapter_title_ = ""
            chapter_title_ = self.gds_validate_string(chapter_title_, node, 'chapter_title')
            self.chapter_title = chapter_title_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'publisher':
            publisher_ = child_.text
            if publisher_:
                publisher_ = re_.sub(String_cleanup_pat_, " ", publisher_).strip()
            else:
                publisher_ = ""
            publisher_ = self.gds_validate_string(publisher_, node, 'publisher')
            self.publisher = publisher_
        elif nodeName_ == 'publisher_location':
            publisher_location_ = child_.text
            if publisher_location_:
                publisher_location_ = re_.sub(String_cleanup_pat_, " ", publisher_location_).strip()
            else:
                publisher_location_ = ""
            publisher_location_ = self.gds_validate_string(publisher_location_, node, 'publisher_location')
            self.publisher_location = publisher_location_
        elif nodeName_ == 'first_page':
            first_page_ = child_.text
            first_page_ = self.gds_validate_string(first_page_, node, 'first_page')
            self.first_page = first_page_
            # validate type page_type
            self.validate_page_type(self.first_page)
        elif nodeName_ == 'last_page':
            last_page_ = child_.text
            last_page_ = self.gds_validate_string(last_page_, node, 'last_page')
            self.last_page = last_page_
            # validate type page_type
            self.validate_page_type(self.last_page)
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
            # validate type yearType2
            self.validate_yearType2(self.year)
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType3.factory()
            obj_.build(child_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class non_journal_citation


class emdb_cross_reference_list_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, emdb_reference=None):
        self.original_tagname_ = None
        if emdb_reference is None:
            self.emdb_reference = []
        else:
            self.emdb_reference = emdb_reference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, emdb_cross_reference_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if emdb_cross_reference_list_type.subclass:
            return emdb_cross_reference_list_type.subclass(*args_, **kwargs_)
        else:
            return emdb_cross_reference_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_emdb_reference(self): return self.emdb_reference
    def set_emdb_reference(self, emdb_reference): self.emdb_reference = emdb_reference
    def add_emdb_reference(self, value): self.emdb_reference.append(value)
    def insert_emdb_reference_at(self, index, value): self.emdb_reference.insert(index, value)
    def replace_emdb_reference_at(self, index, value): self.emdb_reference[index] = value
    def hasContent_(self):
        if (
            self.emdb_reference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='emdb_cross_reference_list_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('emdb_cross_reference_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='emdb_cross_reference_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='emdb_cross_reference_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='emdb_cross_reference_list_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='emdb_cross_reference_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for emdb_reference_ in self.emdb_reference:
            emdb_reference_.export(outfile, level, namespace_, name_='emdb_reference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'emdb_reference':
            obj_ = emdb_cross_reference_type.factory()
            obj_.build(child_)
            self.emdb_reference.append(obj_)
            obj_.original_tagname_ = 'emdb_reference'
# end class emdb_cross_reference_list_type


class emdb_cross_reference_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, emdb_id=None, relationship=None, details=None):
        self.original_tagname_ = None
        self.emdb_id = emdb_id
        self.validate_emdb_id_type(self.emdb_id)
        self.relationship = relationship
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, emdb_cross_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if emdb_cross_reference_type.subclass:
            return emdb_cross_reference_type.subclass(*args_, **kwargs_)
        else:
            return emdb_cross_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_emdb_id(self): return self.emdb_id
    def set_emdb_id(self, emdb_id): self.emdb_id = emdb_id
    def get_relationship(self): return self.relationship
    def set_relationship(self, relationship): self.relationship = relationship
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_emdb_id_type(self, value):
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdb_id_type_patterns_, ))
    validate_emdb_id_type_patterns_ = [['EMD-\\d{4,}']]
    def hasContent_(self):
        if (
            self.emdb_id is not None or
            self.relationship is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='emdb_cross_reference_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('emdb_cross_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='emdb_cross_reference_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='emdb_cross_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='emdb_cross_reference_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='emdb_cross_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.emdb_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<emdb_id>%s</emdb_id>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.emdb_id), input_name='emdb_id')), eol_))
        if self.relationship is not None:
            self.relationship.export(outfile, level, namespace_, name_='relationship', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'emdb_id':
            emdb_id_ = child_.text
            if emdb_id_:
                emdb_id_ = re_.sub(String_cleanup_pat_, " ", emdb_id_).strip()
            else:
                emdb_id_ = ""
            emdb_id_ = self.gds_validate_string(emdb_id_, node, 'emdb_id')
            self.emdb_id = emdb_id_
            # validate type emdb_id_type
            self.validate_emdb_id_type(self.emdb_id)
        elif nodeName_ == 'relationship':
            obj_ = relationshipType.factory()
            obj_.build(child_)
            self.relationship = obj_
            obj_.original_tagname_ = 'relationship'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class emdb_cross_reference_type


class pdb_cross_reference_list_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, pdb_reference=None):
        self.original_tagname_ = None
        if pdb_reference is None:
            self.pdb_reference = []
        else:
            self.pdb_reference = pdb_reference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pdb_cross_reference_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pdb_cross_reference_list_type.subclass:
            return pdb_cross_reference_list_type.subclass(*args_, **kwargs_)
        else:
            return pdb_cross_reference_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pdb_reference(self): return self.pdb_reference
    def set_pdb_reference(self, pdb_reference): self.pdb_reference = pdb_reference
    def add_pdb_reference(self, value): self.pdb_reference.append(value)
    def insert_pdb_reference_at(self, index, value): self.pdb_reference.insert(index, value)
    def replace_pdb_reference_at(self, index, value): self.pdb_reference[index] = value
    def hasContent_(self):
        if (
            self.pdb_reference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pdb_cross_reference_list_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pdb_cross_reference_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pdb_cross_reference_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pdb_cross_reference_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pdb_cross_reference_list_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pdb_cross_reference_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pdb_reference_ in self.pdb_reference:
            pdb_reference_.export(outfile, level, namespace_, name_='pdb_reference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pdb_reference':
            obj_ = pdb_cross_reference_type.factory()
            obj_.build(child_)
            self.pdb_reference.append(obj_)
            obj_.original_tagname_ = 'pdb_reference'
# end class pdb_cross_reference_list_type


class pdb_cross_reference_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, pdb_id=None, relationship=None, details=None):
        self.original_tagname_ = None
        self.pdb_id = pdb_id
        self.validate_pdb_code_type(self.pdb_id)
        self.relationship = relationship
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pdb_cross_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pdb_cross_reference_type.subclass:
            return pdb_cross_reference_type.subclass(*args_, **kwargs_)
        else:
            return pdb_cross_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pdb_id(self): return self.pdb_id
    def set_pdb_id(self, pdb_id): self.pdb_id = pdb_id
    def get_relationship(self): return self.relationship
    def set_relationship(self, relationship): self.relationship = relationship
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_pdb_code_type(self, value):
        # Validate type pdb_code_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pdb_code_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pdb_code_type_patterns_, ))
    validate_pdb_code_type_patterns_ = [['\\d[\\dA-Za-z]{3}']]
    def hasContent_(self):
        if (
            self.pdb_id is not None or
            self.relationship is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pdb_cross_reference_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pdb_cross_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pdb_cross_reference_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pdb_cross_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pdb_cross_reference_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pdb_cross_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pdb_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<pdb_id>%s</pdb_id>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.pdb_id), input_name='pdb_id')), eol_))
        if self.relationship is not None:
            self.relationship.export(outfile, level, namespace_, name_='relationship', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pdb_id':
            pdb_id_ = child_.text
            if pdb_id_:
                pdb_id_ = re_.sub(String_cleanup_pat_, " ", pdb_id_).strip()
            else:
                pdb_id_ = ""
            pdb_id_ = self.gds_validate_string(pdb_id_, node, 'pdb_id')
            self.pdb_id = pdb_id_
            # validate type pdb_code_type
            self.validate_pdb_code_type(self.pdb_id)
        elif nodeName_ == 'relationship':
            obj_ = relationshipType4.factory()
            obj_.build(child_)
            self.relationship = obj_
            obj_.original_tagname_ = 'relationship'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class pdb_cross_reference_type


class auxiliary_link_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, link=None, details=None):
        self.original_tagname_ = None
        self.type_ = type_
        self.validate_typeType(self.type_)
        self.link = link
        self.validate_linkType(self.link)
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, auxiliary_link_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if auxiliary_link_type.subclass:
            return auxiliary_link_type.subclass(*args_, **kwargs_)
        else:
            return auxiliary_link_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_link(self): return self.link
    def set_link(self, link): self.link = link
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_typeType(self, value):
        # Validate type typeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['2D EM DATA', 'CORRELATIVE LIGHT MICROSCOPY']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on typeType' % {"value" : value.encode("utf-8")} )
    def validate_linkType(self, value):
        # Validate type linkType, a restriction on xs:anyURI.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_linkType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_linkType_patterns_, ))
    validate_linkType_patterns_ = [['(https?|ftp)://.*']]
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.link is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='auxiliary_link_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('auxiliary_link_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='auxiliary_link_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='auxiliary_link_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='auxiliary_link_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='auxiliary_link_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<type>%s</type>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), eol_))
        if self.link is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<link>%s</link>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.link), input_name='link')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            if type_:
                type_ = re_.sub(String_cleanup_pat_, " ", type_).strip()
            else:
                type_ = ""
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
            # validate type typeType
            self.validate_typeType(self.type_)
        elif nodeName_ == 'link':
            link_ = child_.text
            link_ = self.gds_validate_string(link_, node, 'link')
            self.link = link_
            # validate type linkType
            self.validate_linkType(self.link)
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class auxiliary_link_type


class sample_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, supramolecule_list=None, macromolecule_list=None):
        self.original_tagname_ = None
        self.name = name
        self.supramolecule_list = supramolecule_list
        self.macromolecule_list = macromolecule_list
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sample_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sample_type.subclass:
            return sample_type.subclass(*args_, **kwargs_)
        else:
            return sample_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_supramolecule_list(self): return self.supramolecule_list
    def set_supramolecule_list(self, supramolecule_list): self.supramolecule_list = supramolecule_list
    def get_macromolecule_list(self): return self.macromolecule_list
    def set_macromolecule_list(self, macromolecule_list): self.macromolecule_list = macromolecule_list
    def hasContent_(self):
        if (
            self.name is not None or
            self.supramolecule_list is not None or
            self.macromolecule_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sample_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sample_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sample_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sample_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sample_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sample_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            self.name.export(outfile, level, namespace_, name_='name', pretty_print=pretty_print)
        if self.supramolecule_list is not None:
            self.supramolecule_list.export(outfile, level, namespace_, name_='supramolecule_list', pretty_print=pretty_print)
        if self.macromolecule_list is not None:
            self.macromolecule_list.export(outfile, level, namespace_, name_='macromolecule_list', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            obj_ = sci_name_type.factory()
            obj_.build(child_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'supramolecule_list':
            obj_ = supramolecule_listType.factory()
            obj_.build(child_)
            self.supramolecule_list = obj_
            obj_.original_tagname_ = 'supramolecule_list'
        elif nodeName_ == 'macromolecule_list':
            obj_ = macromolecule_list_type.factory()
            obj_.build(child_)
            self.macromolecule_list = obj_
            obj_.original_tagname_ = 'macromolecule_list'
# end class sample_type


class sci_name_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, synonym=None, valueOf_=None):
        self.original_tagname_ = None
        self.synonym = _cast(None, synonym)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sci_name_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sci_name_type.subclass:
            return sci_name_type.subclass(*args_, **kwargs_)
        else:
            return sci_name_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_synonym(self): return self.synonym
    def set_synonym(self, synonym): self.synonym = synonym
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sci_name_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sci_name_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sci_name_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sci_name_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sci_name_type'):
        if self.synonym is not None and 'synonym' not in already_processed:
            already_processed.add('synonym')
            outfile.write(' synonym=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.synonym), input_name='synonym')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='sci_name_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('synonym', node)
        if value is not None and 'synonym' not in already_processed:
            already_processed.add('synonym')
            self.synonym = value
            self.synonym = ' '.join(self.synonym.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class sci_name_type


class base_supramolecule_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, extensiontype_=None):
        self.original_tagname_ = None
        self.supramolecule_id = _cast(int, supramolecule_id)
        self.name = name
        self.category = category
        self.parent = parent
        self.macromolecule_list = macromolecule_list
        self.details = details
        self.number_of_copies = number_of_copies
        self.validate_pos_int_or_string_type(self.number_of_copies)
        self.oligomeric_state = oligomeric_state
        self.validate_pos_int_or_string_type(self.oligomeric_state)
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.recombinant_exp_flag = recombinant_exp_flag
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_supramolecule_type.subclass:
            return base_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return base_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_parent(self): return self.parent
    def set_parent(self, parent): self.parent = parent
    def get_macromolecule_list(self): return self.macromolecule_list
    def set_macromolecule_list(self, macromolecule_list): self.macromolecule_list = macromolecule_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_number_of_copies(self): return self.number_of_copies
    def set_number_of_copies(self, number_of_copies): self.number_of_copies = number_of_copies
    def get_oligomeric_state(self): return self.oligomeric_state
    def set_oligomeric_state(self, oligomeric_state): self.oligomeric_state = oligomeric_state
    def get_external_references(self): return self.external_references
    def set_external_references(self, external_references): self.external_references = external_references
    def add_external_references(self, value): self.external_references.append(value)
    def insert_external_references_at(self, index, value): self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value): self.external_references[index] = value
    def get_recombinant_exp_flag(self): return self.recombinant_exp_flag
    def set_recombinant_exp_flag(self, recombinant_exp_flag): self.recombinant_exp_flag = recombinant_exp_flag
    def get_supramolecule_id(self): return self.supramolecule_id
    def set_supramolecule_id(self, supramolecule_id): self.supramolecule_id = supramolecule_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_pos_int_or_string_type(self, value):
        # Validate type pos_int_or_string_type, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.category is not None or
            self.parent is not None or
            self.macromolecule_list is not None or
            self.details is not None or
            self.number_of_copies is not None or
            self.oligomeric_state is not None or
            self.external_references or
            self.recombinant_exp_flag is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_supramolecule_type'):
        if self.supramolecule_id is not None and 'supramolecule_id' not in already_processed:
            already_processed.add('supramolecule_id')
            outfile.write(' supramolecule_id="%s"' % self.gds_format_integer(self.supramolecule_id, input_name='supramolecule_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='base_supramolecule_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            self.name.export(outfile, level, namespace_, name_='name', pretty_print=pretty_print)
        if self.category is not None:
            self.category.export(outfile, level, namespace_, name_='category', pretty_print=pretty_print)
        if self.parent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<parent>%s</parent>%s' % (self.gds_format_integer(self.parent, input_name='parent'), eol_))
        if self.macromolecule_list is not None:
            self.macromolecule_list.export(outfile, level, namespace_, name_='macromolecule_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
        if self.number_of_copies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_of_copies>%s</number_of_copies>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.number_of_copies), input_name='number_of_copies')), eol_))
        if self.oligomeric_state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<oligomeric_state>%s</oligomeric_state>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.oligomeric_state), input_name='oligomeric_state')), eol_))
        for external_references_ in self.external_references:
            external_references_.export(outfile, level, namespace_, name_='external_references', pretty_print=pretty_print)
        if self.recombinant_exp_flag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<recombinant_exp_flag>%s</recombinant_exp_flag>%s' % (self.gds_format_boolean(self.recombinant_exp_flag, input_name='recombinant_exp_flag'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('supramolecule_id', node)
        if value is not None and 'supramolecule_id' not in already_processed:
            already_processed.add('supramolecule_id')
            try:
                self.supramolecule_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.supramolecule_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            obj_ = sci_name_type.factory()
            obj_.build(child_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'category':
            obj_ = categoryType.factory()
            obj_.build(child_)
            self.category = obj_
            obj_.original_tagname_ = 'category'
        elif nodeName_ == 'parent':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'parent')
            self.parent = ival_
        elif nodeName_ == 'macromolecule_list':
            obj_ = macromolecule_listType.factory()
            obj_.build(child_)
            self.macromolecule_list = obj_
            obj_.original_tagname_ = 'macromolecule_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'number_of_copies':
            number_of_copies_ = child_.text
            number_of_copies_ = self.gds_validate_string(number_of_copies_, node, 'number_of_copies')
            self.number_of_copies = number_of_copies_
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.number_of_copies)
        elif nodeName_ == 'oligomeric_state':
            oligomeric_state_ = child_.text
            oligomeric_state_ = self.gds_validate_string(oligomeric_state_, node, 'oligomeric_state')
            self.oligomeric_state = oligomeric_state_
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.oligomeric_state)
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType6.factory()
            obj_.build(child_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'recombinant_exp_flag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinant_exp_flag')
            self.recombinant_exp_flag = ival_
# end class base_supramolecule_type


class cell_supramolecule_type(base_supramolecule_type):
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, synthetic_source=None):
        self.original_tagname_ = None
        super(cell_supramolecule_type, self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag, )
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cell_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cell_supramolecule_type.subclass:
            return cell_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return cell_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_natural_source(self): return self.natural_source
    def set_natural_source(self, natural_source): self.natural_source = natural_source
    def add_natural_source(self, value): self.natural_source.append(value)
    def insert_natural_source_at(self, index, value): self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value): self.natural_source[index] = value
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value): self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value): self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value): self.synthetic_source[index] = value
    def hasContent_(self):
        if (
            self.natural_source or
            self.synthetic_source or
            super(cell_supramolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cell_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cell_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cell_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cell_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cell_supramolecule_type'):
        super(cell_supramolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='cell_supramolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='cell_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(cell_supramolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            natural_source_.export(outfile, level, namespace_, name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            synthetic_source_.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(cell_supramolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'natural_source':
            obj_ = cell_source_type.factory()
            obj_.build(child_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = cell_source_type.factory()
            obj_.build(child_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        super(cell_supramolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class cell_supramolecule_type


class base_source_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None, extensiontype_=None):
        self.original_tagname_ = None
        self.database = _cast(None, database)
        self.organism = organism
        self.strain = strain
        self.synonym_organism = synonym_organism
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_source_type.subclass:
            return base_source_type.subclass(*args_, **kwargs_)
        else:
            return base_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organism(self): return self.organism
    def set_organism(self, organism): self.organism = organism
    def get_strain(self): return self.strain
    def set_strain(self, strain): self.strain = strain
    def get_synonym_organism(self): return self.synonym_organism
    def set_synonym_organism(self, synonym_organism): self.synonym_organism = synonym_organism
    def get_database(self): return self.database
    def set_database(self, database): self.database = database
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.organism is not None or
            self.strain is not None or
            self.synonym_organism is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_source_type'):
        if self.database is not None and 'database' not in already_processed:
            already_processed.add('database')
            outfile.write(' database=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.database), input_name='database')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='base_source_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organism is not None:
            self.organism.export(outfile, level, namespace_, name_='organism', pretty_print=pretty_print)
        if self.strain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<strain>%s</strain>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.strain), input_name='strain')), eol_))
        if self.synonym_organism is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<synonym_organism>%s</synonym_organism>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.synonym_organism), input_name='synonym_organism')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('database', node)
        if value is not None and 'database' not in already_processed:
            already_processed.add('database')
            self.database = value
            self.database = ' '.join(self.database.split())
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organism':
            obj_ = organism_type.factory()
            obj_.build(child_)
            self.organism = obj_
            obj_.original_tagname_ = 'organism'
        elif nodeName_ == 'strain':
            strain_ = child_.text
            if strain_:
                strain_ = re_.sub(String_cleanup_pat_, " ", strain_).strip()
            else:
                strain_ = ""
            strain_ = self.gds_validate_string(strain_, node, 'strain')
            self.strain = strain_
        elif nodeName_ == 'synonym_organism':
            synonym_organism_ = child_.text
            if synonym_organism_:
                synonym_organism_ = re_.sub(String_cleanup_pat_, " ", synonym_organism_).strip()
            else:
                synonym_organism_ = ""
            synonym_organism_ = self.gds_validate_string(synonym_organism_, node, 'synonym_organism')
            self.synonym_organism = synonym_organism_
# end class base_source_type


class organism_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ncbi=None, valueOf_=None):
        self.original_tagname_ = None
        self.ncbi = _cast(int, ncbi)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organism_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organism_type.subclass:
            return organism_type.subclass(*args_, **kwargs_)
        else:
            return organism_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ncbi(self): return self.ncbi
    def set_ncbi(self, ncbi): self.ncbi = ncbi
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='organism_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organism_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='organism_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='organism_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='organism_type'):
        if self.ncbi is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            outfile.write(' ncbi="%s"' % self.gds_format_integer(self.ncbi, input_name='ncbi'))
    def exportChildren(self, outfile, level, namespace_='', name_='organism_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ncbi', node)
        if value is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            try:
                self.ncbi = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.ncbi <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class organism_type


class complex_supramolecule_type(base_supramolecule_type):
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, chimera=None, natural_source=None, synthetic_source=None, recombinant_expression=None, molecular_weight=None, ribosome_details=None):
        self.original_tagname_ = None
        super(complex_supramolecule_type, self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag, )
        self.chimera = _cast(bool, chimera)
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        if recombinant_expression is None:
            self.recombinant_expression = []
        else:
            self.recombinant_expression = recombinant_expression
        self.molecular_weight = molecular_weight
        self.ribosome_details = ribosome_details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complex_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complex_supramolecule_type.subclass:
            return complex_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return complex_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_natural_source(self): return self.natural_source
    def set_natural_source(self, natural_source): self.natural_source = natural_source
    def add_natural_source(self, value): self.natural_source.append(value)
    def insert_natural_source_at(self, index, value): self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value): self.natural_source[index] = value
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value): self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value): self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value): self.synthetic_source[index] = value
    def get_recombinant_expression(self): return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression): self.recombinant_expression = recombinant_expression
    def add_recombinant_expression(self, value): self.recombinant_expression.append(value)
    def insert_recombinant_expression_at(self, index, value): self.recombinant_expression.insert(index, value)
    def replace_recombinant_expression_at(self, index, value): self.recombinant_expression[index] = value
    def get_molecular_weight(self): return self.molecular_weight
    def set_molecular_weight(self, molecular_weight): self.molecular_weight = molecular_weight
    def get_ribosome_details(self): return self.ribosome_details
    def set_ribosome_details(self, ribosome_details): self.ribosome_details = ribosome_details
    def get_chimera(self): return self.chimera
    def set_chimera(self, chimera): self.chimera = chimera
    def hasContent_(self):
        if (
            self.natural_source or
            self.synthetic_source or
            self.recombinant_expression or
            self.molecular_weight is not None or
            self.ribosome_details is not None or
            super(complex_supramolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='complex_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complex_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='complex_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='complex_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='complex_supramolecule_type'):
        super(complex_supramolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='complex_supramolecule_type')
        if self.chimera is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            outfile.write(' chimera="%s"' % self.gds_format_boolean(self.chimera, input_name='chimera'))
    def exportChildren(self, outfile, level, namespace_='', name_='complex_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(complex_supramolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            natural_source_.export(outfile, level, namespace_, name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            synthetic_source_.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
        for recombinant_expression_ in self.recombinant_expression:
            recombinant_expression_.export(outfile, level, namespace_, name_='recombinant_expression', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            self.molecular_weight.export(outfile, level, namespace_, name_='molecular_weight', pretty_print=pretty_print)
        if self.ribosome_details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<ribosome-details>%s</ribosome-details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.ribosome_details), input_name='ribosome-details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('chimera', node)
        if value is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            if value in ('true', '1'):
                self.chimera = True
            elif value in ('false', '0'):
                self.chimera = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(complex_supramolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'natural_source':
            obj_ = complex_source_type.factory()
            obj_.build(child_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = complex_source_type.factory()
            obj_.build(child_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory()
            obj_.build(child_)
            self.recombinant_expression.append(obj_)
            obj_.original_tagname_ = 'recombinant_expression'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory()
            obj_.build(child_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'ribosome-details':
            ribosome_details_ = child_.text
            ribosome_details_ = self.gds_validate_string(ribosome_details_, node, 'ribosome_details')
            self.ribosome_details = ribosome_details_
        super(complex_supramolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class complex_supramolecule_type


class complex_source_type(base_source_type):
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None, organ=None, tissue=None, cell=None, organelle=None, cellular_location=None):
        self.original_tagname_ = None
        super(complex_source_type, self).__init__(database, organism, strain, synonym_organism, )
        self.organ = organ
        self.tissue = tissue
        self.cell = cell
        self.organelle = organelle
        self.cellular_location = cellular_location
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complex_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complex_source_type.subclass:
            return complex_source_type.subclass(*args_, **kwargs_)
        else:
            return complex_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organ(self): return self.organ
    def set_organ(self, organ): self.organ = organ
    def get_tissue(self): return self.tissue
    def set_tissue(self, tissue): self.tissue = tissue
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_organelle(self): return self.organelle
    def set_organelle(self, organelle): self.organelle = organelle
    def get_cellular_location(self): return self.cellular_location
    def set_cellular_location(self, cellular_location): self.cellular_location = cellular_location
    def hasContent_(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            self.organelle is not None or
            self.cellular_location is not None or
            super(complex_source_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='complex_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complex_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='complex_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='complex_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='complex_source_type'):
        super(complex_source_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='complex_source_type')
    def exportChildren(self, outfile, level, namespace_='', name_='complex_source_type', fromsubclass_=False, pretty_print=True):
        super(complex_source_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organ>%s</organ>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), eol_))
        if self.tissue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tissue>%s</tissue>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), eol_))
        if self.cell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cell>%s</cell>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), eol_))
        if self.organelle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organelle>%s</organelle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organelle), input_name='organelle')), eol_))
        if self.cellular_location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cellular_location>%s</cellular_location>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cellular_location), input_name='cellular_location')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(complex_source_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organ':
            organ_ = child_.text
            if organ_:
                organ_ = re_.sub(String_cleanup_pat_, " ", organ_).strip()
            else:
                organ_ = ""
            organ_ = self.gds_validate_string(organ_, node, 'organ')
            self.organ = organ_
        elif nodeName_ == 'tissue':
            tissue_ = child_.text
            if tissue_:
                tissue_ = re_.sub(String_cleanup_pat_, " ", tissue_).strip()
            else:
                tissue_ = ""
            tissue_ = self.gds_validate_string(tissue_, node, 'tissue')
            self.tissue = tissue_
        elif nodeName_ == 'cell':
            cell_ = child_.text
            if cell_:
                cell_ = re_.sub(String_cleanup_pat_, " ", cell_).strip()
            else:
                cell_ = ""
            cell_ = self.gds_validate_string(cell_, node, 'cell')
            self.cell = cell_
        elif nodeName_ == 'organelle':
            organelle_ = child_.text
            if organelle_:
                organelle_ = re_.sub(String_cleanup_pat_, " ", organelle_).strip()
            else:
                organelle_ = ""
            organelle_ = self.gds_validate_string(organelle_, node, 'organelle')
            self.organelle = organelle_
        elif nodeName_ == 'cellular_location':
            cellular_location_ = child_.text
            if cellular_location_:
                cellular_location_ = re_.sub(String_cleanup_pat_, " ", cellular_location_).strip()
            else:
                cellular_location_ = ""
            cellular_location_ = self.gds_validate_string(cellular_location_, node, 'cellular_location')
            self.cellular_location = cellular_location_
        super(complex_source_type, self).buildChildren(child_, node, nodeName_, True)
# end class complex_source_type


class recombinant_source_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, database=None, recombinant_organism=None, recombinant_strain=None, recombinant_cell=None, recombinant_plasmid=None, recombinant_synonym_organism=None):
        self.original_tagname_ = None
        self.database = _cast(None, database)
        self.recombinant_organism = recombinant_organism
        self.recombinant_strain = recombinant_strain
        self.recombinant_cell = recombinant_cell
        self.recombinant_plasmid = recombinant_plasmid
        self.recombinant_synonym_organism = recombinant_synonym_organism
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, recombinant_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if recombinant_source_type.subclass:
            return recombinant_source_type.subclass(*args_, **kwargs_)
        else:
            return recombinant_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_recombinant_organism(self): return self.recombinant_organism
    def set_recombinant_organism(self, recombinant_organism): self.recombinant_organism = recombinant_organism
    def get_recombinant_strain(self): return self.recombinant_strain
    def set_recombinant_strain(self, recombinant_strain): self.recombinant_strain = recombinant_strain
    def get_recombinant_cell(self): return self.recombinant_cell
    def set_recombinant_cell(self, recombinant_cell): self.recombinant_cell = recombinant_cell
    def get_recombinant_plasmid(self): return self.recombinant_plasmid
    def set_recombinant_plasmid(self, recombinant_plasmid): self.recombinant_plasmid = recombinant_plasmid
    def get_recombinant_synonym_organism(self): return self.recombinant_synonym_organism
    def set_recombinant_synonym_organism(self, recombinant_synonym_organism): self.recombinant_synonym_organism = recombinant_synonym_organism
    def get_database(self): return self.database
    def set_database(self, database): self.database = database
    def hasContent_(self):
        if (
            self.recombinant_organism is not None or
            self.recombinant_strain is not None or
            self.recombinant_cell is not None or
            self.recombinant_plasmid is not None or
            self.recombinant_synonym_organism is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='recombinant_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('recombinant_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='recombinant_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='recombinant_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='recombinant_source_type'):
        if self.database is not None and 'database' not in already_processed:
            already_processed.add('database')
            outfile.write(' database=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.database), input_name='database')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='recombinant_source_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.recombinant_organism is not None:
            self.recombinant_organism.export(outfile, level, namespace_, name_='recombinant_organism', pretty_print=pretty_print)
        if self.recombinant_strain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<recombinant_strain>%s</recombinant_strain>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_strain), input_name='recombinant_strain')), eol_))
        if self.recombinant_cell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<recombinant_cell>%s</recombinant_cell>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_cell), input_name='recombinant_cell')), eol_))
        if self.recombinant_plasmid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<recombinant_plasmid>%s</recombinant_plasmid>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_plasmid), input_name='recombinant_plasmid')), eol_))
        if self.recombinant_synonym_organism is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<recombinant_synonym_organism>%s</recombinant_synonym_organism>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_synonym_organism), input_name='recombinant_synonym_organism')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('database', node)
        if value is not None and 'database' not in already_processed:
            already_processed.add('database')
            self.database = value
            self.database = ' '.join(self.database.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'recombinant_organism':
            obj_ = organism_type.factory()
            obj_.build(child_)
            self.recombinant_organism = obj_
            obj_.original_tagname_ = 'recombinant_organism'
        elif nodeName_ == 'recombinant_strain':
            recombinant_strain_ = child_.text
            if recombinant_strain_:
                recombinant_strain_ = re_.sub(String_cleanup_pat_, " ", recombinant_strain_).strip()
            else:
                recombinant_strain_ = ""
            recombinant_strain_ = self.gds_validate_string(recombinant_strain_, node, 'recombinant_strain')
            self.recombinant_strain = recombinant_strain_
        elif nodeName_ == 'recombinant_cell':
            recombinant_cell_ = child_.text
            if recombinant_cell_:
                recombinant_cell_ = re_.sub(String_cleanup_pat_, " ", recombinant_cell_).strip()
            else:
                recombinant_cell_ = ""
            recombinant_cell_ = self.gds_validate_string(recombinant_cell_, node, 'recombinant_cell')
            self.recombinant_cell = recombinant_cell_
        elif nodeName_ == 'recombinant_plasmid':
            recombinant_plasmid_ = child_.text
            if recombinant_plasmid_:
                recombinant_plasmid_ = re_.sub(String_cleanup_pat_, " ", recombinant_plasmid_).strip()
            else:
                recombinant_plasmid_ = ""
            recombinant_plasmid_ = self.gds_validate_string(recombinant_plasmid_, node, 'recombinant_plasmid')
            self.recombinant_plasmid = recombinant_plasmid_
        elif nodeName_ == 'recombinant_synonym_organism':
            recombinant_synonym_organism_ = child_.text
            if recombinant_synonym_organism_:
                recombinant_synonym_organism_ = re_.sub(String_cleanup_pat_, " ", recombinant_synonym_organism_).strip()
            else:
                recombinant_synonym_organism_ = ""
            recombinant_synonym_organism_ = self.gds_validate_string(recombinant_synonym_organism_, node, 'recombinant_synonym_organism')
            self.recombinant_synonym_organism = recombinant_synonym_organism_
# end class recombinant_source_type


class molecular_weight_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, experimental=None, theoretical=None, method=None):
        self.original_tagname_ = None
        self.experimental = experimental
        self.theoretical = theoretical
        self.method = method
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, molecular_weight_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if molecular_weight_type.subclass:
            return molecular_weight_type.subclass(*args_, **kwargs_)
        else:
            return molecular_weight_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_experimental(self): return self.experimental
    def set_experimental(self, experimental): self.experimental = experimental
    def get_theoretical(self): return self.theoretical
    def set_theoretical(self, theoretical): self.theoretical = theoretical
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def hasContent_(self):
        if (
            self.experimental is not None or
            self.theoretical is not None or
            self.method is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='molecular_weight_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('molecular_weight_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='molecular_weight_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='molecular_weight_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='molecular_weight_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='molecular_weight_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.experimental is not None:
            self.experimental.export(outfile, level, namespace_, name_='experimental', pretty_print=pretty_print)
        if self.theoretical is not None:
            self.theoretical.export(outfile, level, namespace_, name_='theoretical', pretty_print=pretty_print)
        if self.method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<method>%s</method>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'experimental':
            obj_ = experimentalType.factory()
            obj_.build(child_)
            self.experimental = obj_
            obj_.original_tagname_ = 'experimental'
        elif nodeName_ == 'theoretical':
            obj_ = theoreticalType.factory()
            obj_.build(child_)
            self.theoretical = obj_
            obj_.original_tagname_ = 'theoretical'
        elif nodeName_ == 'method':
            method_ = child_.text
            if method_:
                method_ = re_.sub(String_cleanup_pat_, " ", method_).strip()
            else:
                method_ = ""
            method_ = self.gds_validate_string(method_, node, 'method')
            self.method = method_
# end class molecular_weight_type


class organelle_or_cellular_component_supramolecule_type(base_supramolecule_type):
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, synthetic_source=None, molecular_weight=None, recombinant_expression=None):
        self.original_tagname_ = None
        super(organelle_or_cellular_component_supramolecule_type, self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag, )
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        self.molecular_weight = molecular_weight
        self.recombinant_expression = recombinant_expression
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organelle_or_cellular_component_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organelle_or_cellular_component_supramolecule_type.subclass:
            return organelle_or_cellular_component_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return organelle_or_cellular_component_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_natural_source(self): return self.natural_source
    def set_natural_source(self, natural_source): self.natural_source = natural_source
    def add_natural_source(self, value): self.natural_source.append(value)
    def insert_natural_source_at(self, index, value): self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value): self.natural_source[index] = value
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value): self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value): self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value): self.synthetic_source[index] = value
    def get_molecular_weight(self): return self.molecular_weight
    def set_molecular_weight(self, molecular_weight): self.molecular_weight = molecular_weight
    def get_recombinant_expression(self): return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression): self.recombinant_expression = recombinant_expression
    def hasContent_(self):
        if (
            self.natural_source or
            self.synthetic_source or
            self.molecular_weight is not None or
            self.recombinant_expression is not None or
            super(organelle_or_cellular_component_supramolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='organelle_or_cellular_component_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organelle_or_cellular_component_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='organelle_or_cellular_component_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='organelle_or_cellular_component_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='organelle_or_cellular_component_supramolecule_type'):
        super(organelle_or_cellular_component_supramolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='organelle_or_cellular_component_supramolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='organelle_or_cellular_component_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(organelle_or_cellular_component_supramolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            natural_source_.export(outfile, level, namespace_, name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            synthetic_source_.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            self.molecular_weight.export(outfile, level, namespace_, name_='molecular_weight', pretty_print=pretty_print)
        if self.recombinant_expression is not None:
            self.recombinant_expression.export(outfile, level, namespace_, name_='recombinant_expression', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(organelle_or_cellular_component_supramolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'natural_source':
            obj_ = organelle_source_type.factory()
            obj_.build(child_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = organelle_source_type.factory()
            obj_.build(child_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory()
            obj_.build(child_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory()
            obj_.build(child_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        super(organelle_or_cellular_component_supramolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class organelle_or_cellular_component_supramolecule_type


class organelle_source_type(base_source_type):
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None, organ=None, tissue=None, cell=None, organelle=None, cellular_location=None):
        self.original_tagname_ = None
        super(organelle_source_type, self).__init__(database, organism, strain, synonym_organism, )
        self.organ = organ
        self.tissue = tissue
        self.cell = cell
        self.organelle = organelle
        self.cellular_location = cellular_location
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organelle_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organelle_source_type.subclass:
            return organelle_source_type.subclass(*args_, **kwargs_)
        else:
            return organelle_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organ(self): return self.organ
    def set_organ(self, organ): self.organ = organ
    def get_tissue(self): return self.tissue
    def set_tissue(self, tissue): self.tissue = tissue
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_organelle(self): return self.organelle
    def set_organelle(self, organelle): self.organelle = organelle
    def get_cellular_location(self): return self.cellular_location
    def set_cellular_location(self, cellular_location): self.cellular_location = cellular_location
    def hasContent_(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            self.organelle is not None or
            self.cellular_location is not None or
            super(organelle_source_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='organelle_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organelle_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='organelle_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='organelle_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='organelle_source_type'):
        super(organelle_source_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='organelle_source_type')
    def exportChildren(self, outfile, level, namespace_='', name_='organelle_source_type', fromsubclass_=False, pretty_print=True):
        super(organelle_source_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organ>%s</organ>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), eol_))
        if self.tissue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tissue>%s</tissue>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), eol_))
        if self.cell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cell>%s</cell>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), eol_))
        if self.organelle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organelle>%s</organelle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organelle), input_name='organelle')), eol_))
        if self.cellular_location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cellular_location>%s</cellular_location>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cellular_location), input_name='cellular_location')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(organelle_source_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organ':
            organ_ = child_.text
            if organ_:
                organ_ = re_.sub(String_cleanup_pat_, " ", organ_).strip()
            else:
                organ_ = ""
            organ_ = self.gds_validate_string(organ_, node, 'organ')
            self.organ = organ_
        elif nodeName_ == 'tissue':
            tissue_ = child_.text
            if tissue_:
                tissue_ = re_.sub(String_cleanup_pat_, " ", tissue_).strip()
            else:
                tissue_ = ""
            tissue_ = self.gds_validate_string(tissue_, node, 'tissue')
            self.tissue = tissue_
        elif nodeName_ == 'cell':
            cell_ = child_.text
            if cell_:
                cell_ = re_.sub(String_cleanup_pat_, " ", cell_).strip()
            else:
                cell_ = ""
            cell_ = self.gds_validate_string(cell_, node, 'cell')
            self.cell = cell_
        elif nodeName_ == 'organelle':
            organelle_ = child_.text
            if organelle_:
                organelle_ = re_.sub(String_cleanup_pat_, " ", organelle_).strip()
            else:
                organelle_ = ""
            organelle_ = self.gds_validate_string(organelle_, node, 'organelle')
            self.organelle = organelle_
        elif nodeName_ == 'cellular_location':
            cellular_location_ = child_.text
            if cellular_location_:
                cellular_location_ = re_.sub(String_cleanup_pat_, " ", cellular_location_).strip()
            else:
                cellular_location_ = ""
            cellular_location_ = self.gds_validate_string(cellular_location_, node, 'cellular_location')
            self.cellular_location = cellular_location_
        super(organelle_source_type, self).buildChildren(child_, node, nodeName_, True)
# end class organelle_source_type


class sample_supramolecule_type(base_supramolecule_type):
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, synthetic_source=None, number_unique_components=None, molecular_weight=None):
        self.original_tagname_ = None
        super(sample_supramolecule_type, self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag, )
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        self.number_unique_components = number_unique_components
        self.molecular_weight = molecular_weight
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sample_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sample_supramolecule_type.subclass:
            return sample_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return sample_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_natural_source(self): return self.natural_source
    def set_natural_source(self, natural_source): self.natural_source = natural_source
    def add_natural_source(self, value): self.natural_source.append(value)
    def insert_natural_source_at(self, index, value): self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value): self.natural_source[index] = value
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value): self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value): self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value): self.synthetic_source[index] = value
    def get_number_unique_components(self): return self.number_unique_components
    def set_number_unique_components(self, number_unique_components): self.number_unique_components = number_unique_components
    def get_molecular_weight(self): return self.molecular_weight
    def set_molecular_weight(self, molecular_weight): self.molecular_weight = molecular_weight
    def hasContent_(self):
        if (
            self.natural_source or
            self.synthetic_source or
            self.number_unique_components is not None or
            self.molecular_weight is not None or
            super(sample_supramolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sample_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sample_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sample_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sample_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sample_supramolecule_type'):
        super(sample_supramolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='sample_supramolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='sample_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(sample_supramolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            natural_source_.export(outfile, level, namespace_, name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            synthetic_source_.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
        if self.number_unique_components is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_unique_components>%s</number_unique_components>%s' % (self.gds_format_integer(self.number_unique_components, input_name='number_unique_components'), eol_))
        if self.molecular_weight is not None:
            self.molecular_weight.export(outfile, level, namespace_, name_='molecular_weight', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(sample_supramolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'natural_source':
            obj_ = sample_source_type.factory()
            obj_.build(child_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = sample_source_type.factory()
            obj_.build(child_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'number_unique_components':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_unique_components')
            self.number_unique_components = ival_
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory()
            obj_.build(child_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        super(sample_supramolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class sample_supramolecule_type


class sample_source_type(base_source_type):
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None, organ=None, tissue=None, cell=None):
        self.original_tagname_ = None
        super(sample_source_type, self).__init__(database, organism, strain, synonym_organism, )
        self.organ = organ
        self.tissue = tissue
        self.cell = cell
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sample_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sample_source_type.subclass:
            return sample_source_type.subclass(*args_, **kwargs_)
        else:
            return sample_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organ(self): return self.organ
    def set_organ(self, organ): self.organ = organ
    def get_tissue(self): return self.tissue
    def set_tissue(self, tissue): self.tissue = tissue
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def hasContent_(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            super(sample_source_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sample_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sample_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sample_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sample_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sample_source_type'):
        super(sample_source_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='sample_source_type')
    def exportChildren(self, outfile, level, namespace_='', name_='sample_source_type', fromsubclass_=False, pretty_print=True):
        super(sample_source_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organ>%s</organ>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), eol_))
        if self.tissue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tissue>%s</tissue>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), eol_))
        if self.cell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cell>%s</cell>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(sample_source_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organ':
            organ_ = child_.text
            if organ_:
                organ_ = re_.sub(String_cleanup_pat_, " ", organ_).strip()
            else:
                organ_ = ""
            organ_ = self.gds_validate_string(organ_, node, 'organ')
            self.organ = organ_
        elif nodeName_ == 'tissue':
            tissue_ = child_.text
            if tissue_:
                tissue_ = re_.sub(String_cleanup_pat_, " ", tissue_).strip()
            else:
                tissue_ = ""
            tissue_ = self.gds_validate_string(tissue_, node, 'tissue')
            self.tissue = tissue_
        elif nodeName_ == 'cell':
            cell_ = child_.text
            if cell_:
                cell_ = re_.sub(String_cleanup_pat_, " ", cell_).strip()
            else:
                cell_ = ""
            cell_ = self.gds_validate_string(cell_, node, 'cell')
            self.cell = cell_
        super(sample_source_type, self).buildChildren(child_, node, nodeName_, True)
# end class sample_source_type


class tissue_supramolecule_type(base_supramolecule_type):
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, sythetic_source=None):
        self.original_tagname_ = None
        super(tissue_supramolecule_type, self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag, )
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        if sythetic_source is None:
            self.sythetic_source = []
        else:
            self.sythetic_source = sythetic_source
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tissue_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tissue_supramolecule_type.subclass:
            return tissue_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return tissue_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_natural_source(self): return self.natural_source
    def set_natural_source(self, natural_source): self.natural_source = natural_source
    def add_natural_source(self, value): self.natural_source.append(value)
    def insert_natural_source_at(self, index, value): self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value): self.natural_source[index] = value
    def get_sythetic_source(self): return self.sythetic_source
    def set_sythetic_source(self, sythetic_source): self.sythetic_source = sythetic_source
    def add_sythetic_source(self, value): self.sythetic_source.append(value)
    def insert_sythetic_source_at(self, index, value): self.sythetic_source.insert(index, value)
    def replace_sythetic_source_at(self, index, value): self.sythetic_source[index] = value
    def hasContent_(self):
        if (
            self.natural_source or
            self.sythetic_source or
            super(tissue_supramolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tissue_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tissue_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tissue_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tissue_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tissue_supramolecule_type'):
        super(tissue_supramolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='tissue_supramolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='tissue_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(tissue_supramolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            natural_source_.export(outfile, level, namespace_, name_='natural_source', pretty_print=pretty_print)
        for sythetic_source_ in self.sythetic_source:
            sythetic_source_.export(outfile, level, namespace_, name_='sythetic_source', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(tissue_supramolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'natural_source':
            obj_ = tissue_source_type.factory()
            obj_.build(child_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'sythetic_source':
            obj_ = tissue_source_type.factory()
            obj_.build(child_)
            self.sythetic_source.append(obj_)
            obj_.original_tagname_ = 'sythetic_source'
        super(tissue_supramolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class tissue_supramolecule_type


class tissue_source_type(base_source_type):
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None, organ=None, tissue=None):
        self.original_tagname_ = None
        super(tissue_source_type, self).__init__(database, organism, strain, synonym_organism, )
        self.organ = organ
        self.tissue = tissue
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tissue_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tissue_source_type.subclass:
            return tissue_source_type.subclass(*args_, **kwargs_)
        else:
            return tissue_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organ(self): return self.organ
    def set_organ(self, organ): self.organ = organ
    def get_tissue(self): return self.tissue
    def set_tissue(self, tissue): self.tissue = tissue
    def hasContent_(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            super(tissue_source_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tissue_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tissue_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tissue_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tissue_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tissue_source_type'):
        super(tissue_source_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='tissue_source_type')
    def exportChildren(self, outfile, level, namespace_='', name_='tissue_source_type', fromsubclass_=False, pretty_print=True):
        super(tissue_source_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organ>%s</organ>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), eol_))
        if self.tissue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tissue>%s</tissue>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(tissue_source_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organ':
            organ_ = child_.text
            if organ_:
                organ_ = re_.sub(String_cleanup_pat_, " ", organ_).strip()
            else:
                organ_ = ""
            organ_ = self.gds_validate_string(organ_, node, 'organ')
            self.organ = organ_
        elif nodeName_ == 'tissue':
            tissue_ = child_.text
            if tissue_:
                tissue_ = re_.sub(String_cleanup_pat_, " ", tissue_).strip()
            else:
                tissue_ = ""
            tissue_ = self.gds_validate_string(tissue_, node, 'tissue')
            self.tissue = tissue_
        super(tissue_source_type, self).buildChildren(child_, node, nodeName_, True)
# end class tissue_source_type


class virus_supramolecule_type(base_supramolecule_type):
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, sci_species_name=None, sci_species_strain=None, natural_host=None, synthetic_host=None, host_system=None, molecular_weight=None, virus_shell=None, virus_type=None, virus_isolate=None, virus_enveloped=None, virus_empty=None, syn_species_name=None, sci_species_serotype=None, sci_species_serocomplex=None, sci_species_subspecies=None):
        self.original_tagname_ = None
        super(virus_supramolecule_type, self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag, )
        self.sci_species_name = sci_species_name
        self.sci_species_strain = sci_species_strain
        if natural_host is None:
            self.natural_host = []
        else:
            self.natural_host = natural_host
        if synthetic_host is None:
            self.synthetic_host = []
        else:
            self.synthetic_host = synthetic_host
        self.host_system = host_system
        self.molecular_weight = molecular_weight
        if virus_shell is None:
            self.virus_shell = []
        else:
            self.virus_shell = virus_shell
        self.virus_type = virus_type
        self.validate_virus_typeType(self.virus_type)
        self.virus_isolate = virus_isolate
        self.validate_virus_isolateType(self.virus_isolate)
        self.virus_enveloped = virus_enveloped
        self.virus_empty = virus_empty
        self.syn_species_name = syn_species_name
        self.sci_species_serotype = sci_species_serotype
        self.sci_species_serocomplex = sci_species_serocomplex
        self.sci_species_subspecies = sci_species_subspecies
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, virus_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if virus_supramolecule_type.subclass:
            return virus_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return virus_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sci_species_name(self): return self.sci_species_name
    def set_sci_species_name(self, sci_species_name): self.sci_species_name = sci_species_name
    def get_sci_species_strain(self): return self.sci_species_strain
    def set_sci_species_strain(self, sci_species_strain): self.sci_species_strain = sci_species_strain
    def get_natural_host(self): return self.natural_host
    def set_natural_host(self, natural_host): self.natural_host = natural_host
    def add_natural_host(self, value): self.natural_host.append(value)
    def insert_natural_host_at(self, index, value): self.natural_host.insert(index, value)
    def replace_natural_host_at(self, index, value): self.natural_host[index] = value
    def get_synthetic_host(self): return self.synthetic_host
    def set_synthetic_host(self, synthetic_host): self.synthetic_host = synthetic_host
    def add_synthetic_host(self, value): self.synthetic_host.append(value)
    def insert_synthetic_host_at(self, index, value): self.synthetic_host.insert(index, value)
    def replace_synthetic_host_at(self, index, value): self.synthetic_host[index] = value
    def get_host_system(self): return self.host_system
    def set_host_system(self, host_system): self.host_system = host_system
    def get_molecular_weight(self): return self.molecular_weight
    def set_molecular_weight(self, molecular_weight): self.molecular_weight = molecular_weight
    def get_virus_shell(self): return self.virus_shell
    def set_virus_shell(self, virus_shell): self.virus_shell = virus_shell
    def add_virus_shell(self, value): self.virus_shell.append(value)
    def insert_virus_shell_at(self, index, value): self.virus_shell.insert(index, value)
    def replace_virus_shell_at(self, index, value): self.virus_shell[index] = value
    def get_virus_type(self): return self.virus_type
    def set_virus_type(self, virus_type): self.virus_type = virus_type
    def get_virus_isolate(self): return self.virus_isolate
    def set_virus_isolate(self, virus_isolate): self.virus_isolate = virus_isolate
    def get_virus_enveloped(self): return self.virus_enveloped
    def set_virus_enveloped(self, virus_enveloped): self.virus_enveloped = virus_enveloped
    def get_virus_empty(self): return self.virus_empty
    def set_virus_empty(self, virus_empty): self.virus_empty = virus_empty
    def get_syn_species_name(self): return self.syn_species_name
    def set_syn_species_name(self, syn_species_name): self.syn_species_name = syn_species_name
    def get_sci_species_serotype(self): return self.sci_species_serotype
    def set_sci_species_serotype(self, sci_species_serotype): self.sci_species_serotype = sci_species_serotype
    def get_sci_species_serocomplex(self): return self.sci_species_serocomplex
    def set_sci_species_serocomplex(self, sci_species_serocomplex): self.sci_species_serocomplex = sci_species_serocomplex
    def get_sci_species_subspecies(self): return self.sci_species_subspecies
    def set_sci_species_subspecies(self, sci_species_subspecies): self.sci_species_subspecies = sci_species_subspecies
    def validate_virus_typeType(self, value):
        # Validate type virus_typeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PRION', 'SATELLITE', 'VIRION', 'VIROID', 'VIRUS-LIKE PARTICLE']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on virus_typeType' % {"value" : value.encode("utf-8")} )
    def validate_virus_isolateType(self, value):
        # Validate type virus_isolateType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['OTHER', 'SEROCOMPLEX', 'SEROTYPE', 'SPECIES', 'STRAIN', 'SUBSPECIES']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on virus_isolateType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.sci_species_name is not None or
            self.sci_species_strain is not None or
            self.natural_host or
            self.synthetic_host or
            self.host_system is not None or
            self.molecular_weight is not None or
            self.virus_shell or
            self.virus_type is not None or
            self.virus_isolate is not None or
            self.virus_enveloped is not None or
            self.virus_empty is not None or
            self.syn_species_name is not None or
            self.sci_species_serotype is not None or
            self.sci_species_serocomplex is not None or
            self.sci_species_subspecies is not None or
            super(virus_supramolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='virus_supramolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('virus_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='virus_supramolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='virus_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='virus_supramolecule_type'):
        super(virus_supramolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='virus_supramolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='virus_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(virus_supramolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sci_species_name is not None:
            self.sci_species_name.export(outfile, level, namespace_, name_='sci_species_name', pretty_print=pretty_print)
        if self.sci_species_strain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<sci_species_strain>%s</sci_species_strain>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_strain), input_name='sci_species_strain')), eol_))
        for natural_host_ in self.natural_host:
            natural_host_.export(outfile, level, namespace_, name_='natural_host', pretty_print=pretty_print)
        for synthetic_host_ in self.synthetic_host:
            synthetic_host_.export(outfile, level, namespace_, name_='synthetic_host', pretty_print=pretty_print)
        if self.host_system is not None:
            self.host_system.export(outfile, level, namespace_, name_='host_system', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            self.molecular_weight.export(outfile, level, namespace_, name_='molecular_weight', pretty_print=pretty_print)
        for virus_shell_ in self.virus_shell:
            virus_shell_.export(outfile, level, namespace_, name_='virus_shell', pretty_print=pretty_print)
        if self.virus_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<virus_type>%s</virus_type>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.virus_type), input_name='virus_type')), eol_))
        if self.virus_isolate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<virus_isolate>%s</virus_isolate>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.virus_isolate), input_name='virus_isolate')), eol_))
        if self.virus_enveloped is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<virus_enveloped>%s</virus_enveloped>%s' % (self.gds_format_boolean(self.virus_enveloped, input_name='virus_enveloped'), eol_))
        if self.virus_empty is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<virus_empty>%s</virus_empty>%s' % (self.gds_format_boolean(self.virus_empty, input_name='virus_empty'), eol_))
        if self.syn_species_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<syn_species_name>%s</syn_species_name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.syn_species_name), input_name='syn_species_name')), eol_))
        if self.sci_species_serotype is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<sci_species_serotype>%s</sci_species_serotype>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_serotype), input_name='sci_species_serotype')), eol_))
        if self.sci_species_serocomplex is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<sci_species_serocomplex>%s</sci_species_serocomplex>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_serocomplex), input_name='sci_species_serocomplex')), eol_))
        if self.sci_species_subspecies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<sci_species_subspecies>%s</sci_species_subspecies>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_subspecies), input_name='sci_species_subspecies')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(virus_supramolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sci_species_name':
            obj_ = virus_species_name_type.factory()
            obj_.build(child_)
            self.sci_species_name = obj_
            obj_.original_tagname_ = 'sci_species_name'
        elif nodeName_ == 'sci_species_strain':
            sci_species_strain_ = child_.text
            sci_species_strain_ = self.gds_validate_string(sci_species_strain_, node, 'sci_species_strain')
            self.sci_species_strain = sci_species_strain_
        elif nodeName_ == 'natural_host':
            obj_ = virus_host_type.factory()
            obj_.build(child_)
            self.natural_host.append(obj_)
            obj_.original_tagname_ = 'natural_host'
        elif nodeName_ == 'synthetic_host':
            obj_ = virus_host_type.factory()
            obj_.build(child_)
            self.synthetic_host.append(obj_)
            obj_.original_tagname_ = 'synthetic_host'
        elif nodeName_ == 'host_system':
            obj_ = recombinant_source_type.factory()
            obj_.build(child_)
            self.host_system = obj_
            obj_.original_tagname_ = 'host_system'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory()
            obj_.build(child_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'virus_shell':
            obj_ = virus_shellType.factory()
            obj_.build(child_)
            self.virus_shell.append(obj_)
            obj_.original_tagname_ = 'virus_shell'
        elif nodeName_ == 'virus_type':
            virus_type_ = child_.text
            if virus_type_:
                virus_type_ = re_.sub(String_cleanup_pat_, " ", virus_type_).strip()
            else:
                virus_type_ = ""
            virus_type_ = self.gds_validate_string(virus_type_, node, 'virus_type')
            self.virus_type = virus_type_
            # validate type virus_typeType
            self.validate_virus_typeType(self.virus_type)
        elif nodeName_ == 'virus_isolate':
            virus_isolate_ = child_.text
            if virus_isolate_:
                virus_isolate_ = re_.sub(String_cleanup_pat_, " ", virus_isolate_).strip()
            else:
                virus_isolate_ = ""
            virus_isolate_ = self.gds_validate_string(virus_isolate_, node, 'virus_isolate')
            self.virus_isolate = virus_isolate_
            # validate type virus_isolateType
            self.validate_virus_isolateType(self.virus_isolate)
        elif nodeName_ == 'virus_enveloped':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'virus_enveloped')
            self.virus_enveloped = ival_
        elif nodeName_ == 'virus_empty':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'virus_empty')
            self.virus_empty = ival_
        elif nodeName_ == 'syn_species_name':
            syn_species_name_ = child_.text
            syn_species_name_ = self.gds_validate_string(syn_species_name_, node, 'syn_species_name')
            self.syn_species_name = syn_species_name_
        elif nodeName_ == 'sci_species_serotype':
            sci_species_serotype_ = child_.text
            sci_species_serotype_ = self.gds_validate_string(sci_species_serotype_, node, 'sci_species_serotype')
            self.sci_species_serotype = sci_species_serotype_
        elif nodeName_ == 'sci_species_serocomplex':
            sci_species_serocomplex_ = child_.text
            sci_species_serocomplex_ = self.gds_validate_string(sci_species_serocomplex_, node, 'sci_species_serocomplex')
            self.sci_species_serocomplex = sci_species_serocomplex_
        elif nodeName_ == 'sci_species_subspecies':
            sci_species_subspecies_ = child_.text
            sci_species_subspecies_ = self.gds_validate_string(sci_species_subspecies_, node, 'sci_species_subspecies')
            self.sci_species_subspecies = sci_species_subspecies_
        super(virus_supramolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class virus_supramolecule_type


class virus_species_name_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ncbi=None, valueOf_=None):
        self.original_tagname_ = None
        self.ncbi = _cast(int, ncbi)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, virus_species_name_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if virus_species_name_type.subclass:
            return virus_species_name_type.subclass(*args_, **kwargs_)
        else:
            return virus_species_name_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ncbi(self): return self.ncbi
    def set_ncbi(self, ncbi): self.ncbi = ncbi
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='virus_species_name_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('virus_species_name_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='virus_species_name_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='virus_species_name_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='virus_species_name_type'):
        if self.ncbi is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            outfile.write(' ncbi="%s"' % self.gds_format_integer(self.ncbi, input_name='ncbi'))
    def exportChildren(self, outfile, level, namespace_='', name_='virus_species_name_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ncbi', node)
        if value is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            try:
                self.ncbi = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.ncbi <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class virus_species_name_type


class virus_host_type(base_source_type):
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None):
        self.original_tagname_ = None
        super(virus_host_type, self).__init__(database, organism, strain, synonym_organism, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, virus_host_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if virus_host_type.subclass:
            return virus_host_type.subclass(*args_, **kwargs_)
        else:
            return virus_host_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(virus_host_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='virus_host_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('virus_host_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='virus_host_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='virus_host_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='virus_host_type'):
        super(virus_host_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='virus_host_type')
    def exportChildren(self, outfile, level, namespace_='', name_='virus_host_type', fromsubclass_=False, pretty_print=True):
        super(virus_host_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(virus_host_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(virus_host_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class virus_host_type


class macromolecule_list_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, macromolecule=None):
        self.original_tagname_ = None
        if macromolecule is None:
            self.macromolecule = []
        else:
            self.macromolecule = macromolecule
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecule_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecule_list_type.subclass:
            return macromolecule_list_type.subclass(*args_, **kwargs_)
        else:
            return macromolecule_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_macromolecule(self): return self.macromolecule
    def set_macromolecule(self, macromolecule): self.macromolecule = macromolecule
    def add_macromolecule(self, value): self.macromolecule.append(value)
    def insert_macromolecule_at(self, index, value): self.macromolecule.insert(index, value)
    def replace_macromolecule_at(self, index, value): self.macromolecule[index] = value
    def hasContent_(self):
        if (
            self.macromolecule
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromolecule_list_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecule_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromolecule_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromolecule_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromolecule_list_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='macromolecule_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for macromolecule_ in self.macromolecule:
            macromolecule_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'macromolecule':
            class_obj_ = self.get_class_obj_(child_, base_macromolecule_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'macromolecule'
        elif nodeName_ == 'dna':
            obj_ = dna_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'dna'
        elif nodeName_ == 'em_label':
            obj_ = em_label_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'em_label'
        elif nodeName_ == 'ligand':
            obj_ = ligand_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'ligand'
        elif nodeName_ == 'other_macromolecule':
            obj_ = other_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'other_macromolecule'
        elif nodeName_ == 'protein_or_peptide':
            obj_ = protein_or_peptide_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'protein_or_peptide'
        elif nodeName_ == 'rna':
            obj_ = rna_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'rna'
        elif nodeName_ == 'saccharide':
            obj_ = saccharide_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'saccharide'
# end class macromolecule_list_type


class base_macromolecule_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, extensiontype_=None):
        self.original_tagname_ = None
        self.macromolecule_id = _cast(int, macromolecule_id)
        self.mutant = _cast(bool, mutant)
        self.chimera = _cast(bool, chimera)
        self.name = name
        self.natural_source = natural_source
        self.molecular_weight = molecular_weight
        self.details = details
        self.number_of_copies = number_of_copies
        self.validate_pos_int_or_string_type(self.number_of_copies)
        self.oligomeric_state = oligomeric_state
        self.validate_pos_int_or_string_type(self.oligomeric_state)
        self.recombinant_exp_flag = recombinant_exp_flag
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_macromolecule_type.subclass:
            return base_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return base_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_natural_source(self): return self.natural_source
    def set_natural_source(self, natural_source): self.natural_source = natural_source
    def get_molecular_weight(self): return self.molecular_weight
    def set_molecular_weight(self, molecular_weight): self.molecular_weight = molecular_weight
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_number_of_copies(self): return self.number_of_copies
    def set_number_of_copies(self, number_of_copies): self.number_of_copies = number_of_copies
    def get_oligomeric_state(self): return self.oligomeric_state
    def set_oligomeric_state(self, oligomeric_state): self.oligomeric_state = oligomeric_state
    def get_recombinant_exp_flag(self): return self.recombinant_exp_flag
    def set_recombinant_exp_flag(self, recombinant_exp_flag): self.recombinant_exp_flag = recombinant_exp_flag
    def get_macromolecule_id(self): return self.macromolecule_id
    def set_macromolecule_id(self, macromolecule_id): self.macromolecule_id = macromolecule_id
    def get_mutant(self): return self.mutant
    def set_mutant(self, mutant): self.mutant = mutant
    def get_chimera(self): return self.chimera
    def set_chimera(self, chimera): self.chimera = chimera
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_pos_int_or_string_type(self, value):
        # Validate type pos_int_or_string_type, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.natural_source is not None or
            self.molecular_weight is not None or
            self.details is not None or
            self.number_of_copies is not None or
            self.oligomeric_state is not None or
            self.recombinant_exp_flag is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_macromolecule_type'):
        if self.macromolecule_id is not None and 'macromolecule_id' not in already_processed:
            already_processed.add('macromolecule_id')
            outfile.write(' macromolecule_id="%s"' % self.gds_format_integer(self.macromolecule_id, input_name='macromolecule_id'))
        if self.mutant is not None and 'mutant' not in already_processed:
            already_processed.add('mutant')
            outfile.write(' mutant="%s"' % self.gds_format_boolean(self.mutant, input_name='mutant'))
        if self.chimera is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            outfile.write(' chimera="%s"' % self.gds_format_boolean(self.chimera, input_name='chimera'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='base_macromolecule_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            self.name.export(outfile, level, namespace_, name_='name', pretty_print=pretty_print)
        if self.natural_source is not None:
            self.natural_source.export(outfile, level, namespace_, name_='natural_source', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            self.molecular_weight.export(outfile, level, namespace_, name_='molecular_weight', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
        if self.number_of_copies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_of_copies>%s</number_of_copies>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.number_of_copies), input_name='number_of_copies')), eol_))
        if self.oligomeric_state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<oligomeric_state>%s</oligomeric_state>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.oligomeric_state), input_name='oligomeric_state')), eol_))
        if self.recombinant_exp_flag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<recombinant_exp_flag>%s</recombinant_exp_flag>%s' % (self.gds_format_boolean(self.recombinant_exp_flag, input_name='recombinant_exp_flag'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('macromolecule_id', node)
        if value is not None and 'macromolecule_id' not in already_processed:
            already_processed.add('macromolecule_id')
            try:
                self.macromolecule_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.macromolecule_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('mutant', node)
        if value is not None and 'mutant' not in already_processed:
            already_processed.add('mutant')
            if value in ('true', '1'):
                self.mutant = True
            elif value in ('false', '0'):
                self.mutant = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('chimera', node)
        if value is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            if value in ('true', '1'):
                self.chimera = True
            elif value in ('false', '0'):
                self.chimera = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            obj_ = sci_name_type.factory()
            obj_.build(child_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'natural_source':
            obj_ = macromolecule_source_type.factory()
            obj_.build(child_)
            self.natural_source = obj_
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory()
            obj_.build(child_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'number_of_copies':
            number_of_copies_ = child_.text
            number_of_copies_ = self.gds_validate_string(number_of_copies_, node, 'number_of_copies')
            self.number_of_copies = number_of_copies_
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.number_of_copies)
        elif nodeName_ == 'oligomeric_state':
            oligomeric_state_ = child_.text
            oligomeric_state_ = self.gds_validate_string(oligomeric_state_, node, 'oligomeric_state')
            self.oligomeric_state = oligomeric_state_
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.oligomeric_state)
        elif nodeName_ == 'recombinant_exp_flag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinant_exp_flag')
            self.recombinant_exp_flag = ival_
# end class base_macromolecule_type


class macromolecule_source_type(base_source_type):
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, organism=None, strain=None, synonym_organism=None, organ=None, tissue=None, cell=None, organelle=None, cellular_location=None):
        self.original_tagname_ = None
        super(macromolecule_source_type, self).__init__(database, organism, strain, synonym_organism, )
        self.organ = organ
        self.tissue = tissue
        self.cell = cell
        self.organelle = organelle
        self.cellular_location = cellular_location
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecule_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecule_source_type.subclass:
            return macromolecule_source_type.subclass(*args_, **kwargs_)
        else:
            return macromolecule_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_organ(self): return self.organ
    def set_organ(self, organ): self.organ = organ
    def get_tissue(self): return self.tissue
    def set_tissue(self, tissue): self.tissue = tissue
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_organelle(self): return self.organelle
    def set_organelle(self, organelle): self.organelle = organelle
    def get_cellular_location(self): return self.cellular_location
    def set_cellular_location(self, cellular_location): self.cellular_location = cellular_location
    def hasContent_(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            self.organelle is not None or
            self.cellular_location is not None or
            super(macromolecule_source_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromolecule_source_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecule_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromolecule_source_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromolecule_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromolecule_source_type'):
        super(macromolecule_source_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='macromolecule_source_type')
    def exportChildren(self, outfile, level, namespace_='', name_='macromolecule_source_type', fromsubclass_=False, pretty_print=True):
        super(macromolecule_source_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organ>%s</organ>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), eol_))
        if self.tissue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tissue>%s</tissue>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), eol_))
        if self.cell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cell>%s</cell>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), eol_))
        if self.organelle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<organelle>%s</organelle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.organelle), input_name='organelle')), eol_))
        if self.cellular_location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cellular_location>%s</cellular_location>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cellular_location), input_name='cellular_location')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(macromolecule_source_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'organ':
            organ_ = child_.text
            if organ_:
                organ_ = re_.sub(String_cleanup_pat_, " ", organ_).strip()
            else:
                organ_ = ""
            organ_ = self.gds_validate_string(organ_, node, 'organ')
            self.organ = organ_
        elif nodeName_ == 'tissue':
            tissue_ = child_.text
            if tissue_:
                tissue_ = re_.sub(String_cleanup_pat_, " ", tissue_).strip()
            else:
                tissue_ = ""
            tissue_ = self.gds_validate_string(tissue_, node, 'tissue')
            self.tissue = tissue_
        elif nodeName_ == 'cell':
            cell_ = child_.text
            if cell_:
                cell_ = re_.sub(String_cleanup_pat_, " ", cell_).strip()
            else:
                cell_ = ""
            cell_ = self.gds_validate_string(cell_, node, 'cell')
            self.cell = cell_
        elif nodeName_ == 'organelle':
            organelle_ = child_.text
            if organelle_:
                organelle_ = re_.sub(String_cleanup_pat_, " ", organelle_).strip()
            else:
                organelle_ = ""
            organelle_ = self.gds_validate_string(organelle_, node, 'organelle')
            self.organelle = organelle_
        elif nodeName_ == 'cellular_location':
            cellular_location_ = child_.text
            if cellular_location_:
                cellular_location_ = re_.sub(String_cleanup_pat_, " ", cellular_location_).strip()
            else:
                cellular_location_ = ""
            cellular_location_ = self.gds_validate_string(cellular_location_, node, 'cellular_location')
            self.cellular_location = cellular_location_
        super(macromolecule_source_type, self).buildChildren(child_, node, nodeName_, True)
# end class macromolecule_source_type


class dna_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, sequence=None, classification=None, structure=None, synthetic_flag=None, synthetic_source=None):
        self.original_tagname_ = None
        super(dna_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.sequence = sequence
        self.classification = classification
        self.validate_classificationType(self.classification)
        self.structure = structure
        self.synthetic_flag = synthetic_flag
        self.synthetic_source = synthetic_source
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, dna_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dna_macromolecule_type.subclass:
            return dna_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return dna_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sequence(self): return self.sequence
    def set_sequence(self, sequence): self.sequence = sequence
    def get_classification(self): return self.classification
    def set_classification(self, classification): self.classification = classification
    def get_structure(self): return self.structure
    def set_structure(self, structure): self.structure = structure
    def get_synthetic_flag(self): return self.synthetic_flag
    def set_synthetic_flag(self, synthetic_flag): self.synthetic_flag = synthetic_flag
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def validate_classificationType(self, value):
        # Validate type classificationType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DNA']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on classificationType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.sequence is not None or
            self.classification is not None or
            self.structure is not None or
            self.synthetic_flag is not None or
            self.synthetic_source is not None or
            super(dna_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='dna_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('dna_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='dna_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='dna_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='dna_macromolecule_type'):
        super(dna_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='dna_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='dna_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(dna_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sequence is not None:
            self.sequence.export(outfile, level, namespace_, name_='sequence', pretty_print=pretty_print)
        if self.classification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<classification>%s</classification>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.classification), input_name='classification')), eol_))
        if self.structure is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<structure>%s</structure>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.structure), input_name='structure')), eol_))
        if self.synthetic_flag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<synthetic_flag>%s</synthetic_flag>%s' % (self.gds_format_boolean(self.synthetic_flag, input_name='synthetic_flag'), eol_))
        if self.synthetic_source is not None:
            self.synthetic_source.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(dna_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sequence':
            obj_ = sequenceType.factory()
            obj_.build(child_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'classification':
            classification_ = child_.text
            if classification_:
                classification_ = re_.sub(String_cleanup_pat_, " ", classification_).strip()
            else:
                classification_ = ""
            classification_ = self.gds_validate_string(classification_, node, 'classification')
            self.classification = classification_
            # validate type classificationType
            self.validate_classificationType(self.classification)
        elif nodeName_ == 'structure':
            structure_ = child_.text
            if structure_:
                structure_ = re_.sub(String_cleanup_pat_, " ", structure_).strip()
            else:
                structure_ = ""
            structure_ = self.gds_validate_string(structure_, node, 'structure')
            self.structure = structure_
        elif nodeName_ == 'synthetic_flag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'synthetic_flag')
            self.synthetic_flag = ival_
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory()
            obj_.build(child_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        super(dna_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class dna_macromolecule_type


class em_label_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, formula=None, synthetic_source=None):
        self.original_tagname_ = None
        super(em_label_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.formula = formula
        self.validate_formula_type(self.formula)
        self.synthetic_source = synthetic_source
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, em_label_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if em_label_macromolecule_type.subclass:
            return em_label_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return em_label_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_formula(self): return self.formula
    def set_formula(self, formula): self.formula = formula
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def validate_formula_type(self, value):
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.formula is not None or
            self.synthetic_source is not None or
            super(em_label_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='em_label_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('em_label_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='em_label_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='em_label_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='em_label_macromolecule_type'):
        super(em_label_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='em_label_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='em_label_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(em_label_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.formula is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<formula>%s</formula>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), eol_))
        if self.synthetic_source is not None:
            self.synthetic_source.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(em_label_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'formula':
            formula_ = child_.text
            if formula_:
                formula_ = re_.sub(String_cleanup_pat_, " ", formula_).strip()
            else:
                formula_ = ""
            formula_ = self.gds_validate_string(formula_, node, 'formula')
            self.formula = formula_
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory()
            obj_.build(child_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        super(em_label_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class em_label_macromolecule_type


class ligand_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, formula=None, external_references=None, recombinant_expression=None):
        self.original_tagname_ = None
        super(ligand_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.formula = formula
        self.validate_formula_type(self.formula)
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.recombinant_expression = recombinant_expression
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ligand_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ligand_macromolecule_type.subclass:
            return ligand_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return ligand_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_formula(self): return self.formula
    def set_formula(self, formula): self.formula = formula
    def get_external_references(self): return self.external_references
    def set_external_references(self, external_references): self.external_references = external_references
    def add_external_references(self, value): self.external_references.append(value)
    def insert_external_references_at(self, index, value): self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value): self.external_references[index] = value
    def get_recombinant_expression(self): return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression): self.recombinant_expression = recombinant_expression
    def validate_formula_type(self, value):
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.formula is not None or
            self.external_references or
            self.recombinant_expression is not None or
            super(ligand_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ligand_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ligand_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ligand_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ligand_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ligand_macromolecule_type'):
        super(ligand_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ligand_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='ligand_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(ligand_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.formula is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<formula>%s</formula>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), eol_))
        for external_references_ in self.external_references:
            external_references_.export(outfile, level, namespace_, name_='external_references', pretty_print=pretty_print)
        if self.recombinant_expression is not None:
            self.recombinant_expression.export(outfile, level, namespace_, name_='recombinant_expression', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ligand_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'formula':
            formula_ = child_.text
            if formula_:
                formula_ = re_.sub(String_cleanup_pat_, " ", formula_).strip()
            else:
                formula_ = ""
            formula_ = self.gds_validate_string(formula_, node, 'formula')
            self.formula = formula_
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType8.factory()
            obj_.build(child_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory()
            obj_.build(child_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        super(ligand_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class ligand_macromolecule_type


class other_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, sequence=None, classification=None, recombinant_expression=None, structure=None, synthetic_flag=None, synthetic_source=None):
        self.original_tagname_ = None
        super(other_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.sequence = sequence
        self.classification = classification
        self.recombinant_expression = recombinant_expression
        self.structure = structure
        self.synthetic_flag = synthetic_flag
        self.synthetic_source = synthetic_source
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, other_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if other_macromolecule_type.subclass:
            return other_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return other_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sequence(self): return self.sequence
    def set_sequence(self, sequence): self.sequence = sequence
    def get_classification(self): return self.classification
    def set_classification(self, classification): self.classification = classification
    def get_recombinant_expression(self): return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression): self.recombinant_expression = recombinant_expression
    def get_structure(self): return self.structure
    def set_structure(self, structure): self.structure = structure
    def get_synthetic_flag(self): return self.synthetic_flag
    def set_synthetic_flag(self, synthetic_flag): self.synthetic_flag = synthetic_flag
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def hasContent_(self):
        if (
            self.sequence is not None or
            self.classification is not None or
            self.recombinant_expression is not None or
            self.structure is not None or
            self.synthetic_flag is not None or
            self.synthetic_source is not None or
            super(other_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='other_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('other_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='other_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='other_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='other_macromolecule_type'):
        super(other_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='other_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='other_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(other_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sequence is not None:
            self.sequence.export(outfile, level, namespace_, name_='sequence', pretty_print=pretty_print)
        if self.classification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<classification>%s</classification>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.classification), input_name='classification')), eol_))
        if self.recombinant_expression is not None:
            self.recombinant_expression.export(outfile, level, namespace_, name_='recombinant_expression', pretty_print=pretty_print)
        if self.structure is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<structure>%s</structure>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.structure), input_name='structure')), eol_))
        if self.synthetic_flag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<synthetic_flag>%s</synthetic_flag>%s' % (self.gds_format_boolean(self.synthetic_flag, input_name='synthetic_flag'), eol_))
        if self.synthetic_source is not None:
            self.synthetic_source.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(other_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sequence':
            obj_ = sequenceType9.factory()
            obj_.build(child_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'classification':
            classification_ = child_.text
            if classification_:
                classification_ = re_.sub(String_cleanup_pat_, " ", classification_).strip()
            else:
                classification_ = ""
            classification_ = self.gds_validate_string(classification_, node, 'classification')
            self.classification = classification_
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory()
            obj_.build(child_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        elif nodeName_ == 'structure':
            structure_ = child_.text
            if structure_:
                structure_ = re_.sub(String_cleanup_pat_, " ", structure_).strip()
            else:
                structure_ = ""
            structure_ = self.gds_validate_string(structure_, node, 'structure')
            self.structure = structure_
        elif nodeName_ == 'synthetic_flag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'synthetic_flag')
            self.synthetic_flag = ival_
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory()
            obj_.build(child_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        super(other_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class other_macromolecule_type


class protein_or_peptide_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, recombinant_expression=None, synthetic_source=None, enantiomer=None, sequence=None, ec_number=None):
        self.original_tagname_ = None
        super(protein_or_peptide_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.recombinant_expression = recombinant_expression
        self.synthetic_source = synthetic_source
        self.enantiomer = enantiomer
        self.validate_enantiomerType(self.enantiomer)
        self.sequence = sequence
        if ec_number is None:
            self.ec_number = []
        else:
            self.ec_number = ec_number
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, protein_or_peptide_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if protein_or_peptide_macromolecule_type.subclass:
            return protein_or_peptide_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return protein_or_peptide_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_recombinant_expression(self): return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression): self.recombinant_expression = recombinant_expression
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def get_enantiomer(self): return self.enantiomer
    def set_enantiomer(self, enantiomer): self.enantiomer = enantiomer
    def get_sequence(self): return self.sequence
    def set_sequence(self, sequence): self.sequence = sequence
    def get_ec_number(self): return self.ec_number
    def set_ec_number(self, ec_number): self.ec_number = ec_number
    def add_ec_number(self, value): self.ec_number.append(value)
    def insert_ec_number_at(self, index, value): self.ec_number.insert(index, value)
    def replace_ec_number_at(self, index, value): self.ec_number[index] = value
    def validate_enantiomerType(self, value):
        # Validate type enantiomerType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['LEVO', 'DEXTRO']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on enantiomerType' % {"value" : value.encode("utf-8")} )
    def validate_ec_numberType(self, value):
        # Validate type ec_numberType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_ec_numberType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ec_numberType_patterns_, ))
    validate_ec_numberType_patterns_ = [['([1-7]((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?[0-9]?)|(.-)))(([ ]*,[ ]*)([1-6]((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?[0-9]?)|(.-))))*']]
    def hasContent_(self):
        if (
            self.recombinant_expression is not None or
            self.synthetic_source is not None or
            self.enantiomer is not None or
            self.sequence is not None or
            self.ec_number or
            super(protein_or_peptide_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='protein_or_peptide_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('protein_or_peptide_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='protein_or_peptide_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='protein_or_peptide_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='protein_or_peptide_macromolecule_type'):
        super(protein_or_peptide_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='protein_or_peptide_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='protein_or_peptide_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(protein_or_peptide_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.recombinant_expression is not None:
            self.recombinant_expression.export(outfile, level, namespace_, name_='recombinant_expression', pretty_print=pretty_print)
        if self.synthetic_source is not None:
            self.synthetic_source.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
        if self.enantiomer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<enantiomer>%s</enantiomer>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.enantiomer), input_name='enantiomer')), eol_))
        if self.sequence is not None:
            self.sequence.export(outfile, level, namespace_, name_='sequence', pretty_print=pretty_print)
        for ec_number_ in self.ec_number:
            showIndent(outfile, level, pretty_print)
            outfile.write('<ec_number>%s</ec_number>%s' % (self.gds_encode(self.gds_format_string(quote_xml(ec_number_), input_name='ec_number')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(protein_or_peptide_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory()
            obj_.build(child_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory()
            obj_.build(child_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'enantiomer':
            enantiomer_ = child_.text
            if enantiomer_:
                enantiomer_ = re_.sub(String_cleanup_pat_, " ", enantiomer_).strip()
            else:
                enantiomer_ = ""
            enantiomer_ = self.gds_validate_string(enantiomer_, node, 'enantiomer')
            self.enantiomer = enantiomer_
            # validate type enantiomerType
            self.validate_enantiomerType(self.enantiomer)
        elif nodeName_ == 'sequence':
            obj_ = sequenceType13.factory()
            obj_.build(child_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'ec_number':
            ec_number_ = child_.text
            if ec_number_:
                ec_number_ = re_.sub(String_cleanup_pat_, " ", ec_number_).strip()
            else:
                ec_number_ = ""
            ec_number_ = self.gds_validate_string(ec_number_, node, 'ec_number')
            self.ec_number.append(ec_number_)
            # validate type ec_numberType
            self.validate_ec_numberType(self.ec_number[-1])
        super(protein_or_peptide_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class protein_or_peptide_macromolecule_type


class rna_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, sequence=None, classification=None, structure=None, synthetic_flag=None, synthetic_source=None, ec_number=None):
        self.original_tagname_ = None
        super(rna_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.sequence = sequence
        self.classification = classification
        self.validate_classificationType21(self.classification)
        self.structure = structure
        self.synthetic_flag = synthetic_flag
        self.synthetic_source = synthetic_source
        if ec_number is None:
            self.ec_number = []
        else:
            self.ec_number = ec_number
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, rna_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if rna_macromolecule_type.subclass:
            return rna_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return rna_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sequence(self): return self.sequence
    def set_sequence(self, sequence): self.sequence = sequence
    def get_classification(self): return self.classification
    def set_classification(self, classification): self.classification = classification
    def get_structure(self): return self.structure
    def set_structure(self, structure): self.structure = structure
    def get_synthetic_flag(self): return self.synthetic_flag
    def set_synthetic_flag(self, synthetic_flag): self.synthetic_flag = synthetic_flag
    def get_synthetic_source(self): return self.synthetic_source
    def set_synthetic_source(self, synthetic_source): self.synthetic_source = synthetic_source
    def get_ec_number(self): return self.ec_number
    def set_ec_number(self, ec_number): self.ec_number = ec_number
    def add_ec_number(self, value): self.ec_number.append(value)
    def insert_ec_number_at(self, index, value): self.ec_number.insert(index, value)
    def replace_ec_number_at(self, index, value): self.ec_number[index] = value
    def validate_classificationType21(self, value):
        # Validate type classificationType21, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['MESSENGER', 'TRANSFER', 'RIBOSOMAL', 'NON-CODING', 'INTERFERENCE', 'SMALL INTERFERENCE', 'GENOMIC', 'PRE-MESSENGER', 'SMALL NUCLEOLAR', 'TRANSFER-MESSENGER', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on classificationType21' % {"value" : value.encode("utf-8")} )
    def validate_ec_numberType22(self, value):
        # Validate type ec_numberType22, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_ec_numberType22_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_ec_numberType22_patterns_, ))
    validate_ec_numberType22_patterns_ = [['\\d+(\\.(\\d+|\\-)){3}']]
    def hasContent_(self):
        if (
            self.sequence is not None or
            self.classification is not None or
            self.structure is not None or
            self.synthetic_flag is not None or
            self.synthetic_source is not None or
            self.ec_number or
            super(rna_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='rna_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('rna_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rna_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='rna_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='rna_macromolecule_type'):
        super(rna_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='rna_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='rna_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(rna_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sequence is not None:
            self.sequence.export(outfile, level, namespace_, name_='sequence', pretty_print=pretty_print)
        if self.classification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<classification>%s</classification>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.classification), input_name='classification')), eol_))
        if self.structure is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<structure>%s</structure>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.structure), input_name='structure')), eol_))
        if self.synthetic_flag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<synthetic_flag>%s</synthetic_flag>%s' % (self.gds_format_boolean(self.synthetic_flag, input_name='synthetic_flag'), eol_))
        if self.synthetic_source is not None:
            self.synthetic_source.export(outfile, level, namespace_, name_='synthetic_source', pretty_print=pretty_print)
        for ec_number_ in self.ec_number:
            showIndent(outfile, level, pretty_print)
            outfile.write('<ec_number>%s</ec_number>%s' % (self.gds_encode(self.gds_format_string(quote_xml(ec_number_), input_name='ec_number')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(rna_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sequence':
            obj_ = sequenceType17.factory()
            obj_.build(child_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'classification':
            classification_ = child_.text
            if classification_:
                classification_ = re_.sub(String_cleanup_pat_, " ", classification_).strip()
            else:
                classification_ = ""
            classification_ = self.gds_validate_string(classification_, node, 'classification')
            self.classification = classification_
            # validate type classificationType21
            self.validate_classificationType21(self.classification)
        elif nodeName_ == 'structure':
            structure_ = child_.text
            if structure_:
                structure_ = re_.sub(String_cleanup_pat_, " ", structure_).strip()
            else:
                structure_ = ""
            structure_ = self.gds_validate_string(structure_, node, 'structure')
            self.structure = structure_
        elif nodeName_ == 'synthetic_flag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'synthetic_flag')
            self.synthetic_flag = ival_
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory()
            obj_.build(child_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'ec_number':
            ec_number_ = child_.text
            if ec_number_:
                ec_number_ = re_.sub(String_cleanup_pat_, " ", ec_number_).strip()
            else:
                ec_number_ = ""
            ec_number_ = self.gds_validate_string(ec_number_, node, 'ec_number')
            self.ec_number.append(ec_number_)
            # validate type ec_numberType22
            self.validate_ec_numberType22(self.ec_number[-1])
        super(rna_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class rna_macromolecule_type


class saccharide_macromolecule_type(base_macromolecule_type):
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, enantiomer=None, formula=None, external_references=None):
        self.original_tagname_ = None
        super(saccharide_macromolecule_type, self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag, )
        self.enantiomer = enantiomer
        self.validate_enantiomerType23(self.enantiomer)
        self.formula = formula
        self.validate_formula_type(self.formula)
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saccharide_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saccharide_macromolecule_type.subclass:
            return saccharide_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return saccharide_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enantiomer(self): return self.enantiomer
    def set_enantiomer(self, enantiomer): self.enantiomer = enantiomer
    def get_formula(self): return self.formula
    def set_formula(self, formula): self.formula = formula
    def get_external_references(self): return self.external_references
    def set_external_references(self, external_references): self.external_references = external_references
    def add_external_references(self, value): self.external_references.append(value)
    def insert_external_references_at(self, index, value): self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value): self.external_references[index] = value
    def validate_enantiomerType23(self, value):
        # Validate type enantiomerType23, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['LEVO', 'DEXTRO']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on enantiomerType23' % {"value" : value.encode("utf-8")} )
    def validate_formula_type(self, value):
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.enantiomer is not None or
            self.formula is not None or
            self.external_references or
            super(saccharide_macromolecule_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='saccharide_macromolecule_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saccharide_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='saccharide_macromolecule_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='saccharide_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='saccharide_macromolecule_type'):
        super(saccharide_macromolecule_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='saccharide_macromolecule_type')
    def exportChildren(self, outfile, level, namespace_='', name_='saccharide_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(saccharide_macromolecule_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enantiomer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<enantiomer>%s</enantiomer>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.enantiomer), input_name='enantiomer')), eol_))
        if self.formula is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<formula>%s</formula>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), eol_))
        for external_references_ in self.external_references:
            external_references_.export(outfile, level, namespace_, name_='external_references', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(saccharide_macromolecule_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enantiomer':
            enantiomer_ = child_.text
            if enantiomer_:
                enantiomer_ = re_.sub(String_cleanup_pat_, " ", enantiomer_).strip()
            else:
                enantiomer_ = ""
            enantiomer_ = self.gds_validate_string(enantiomer_, node, 'enantiomer')
            self.enantiomer = enantiomer_
            # validate type enantiomerType23
            self.validate_enantiomerType23(self.enantiomer)
        elif nodeName_ == 'formula':
            formula_ = child_.text
            if formula_:
                formula_ = re_.sub(String_cleanup_pat_, " ", formula_).strip()
            else:
                formula_ = ""
            formula_ = self.gds_validate_string(formula_, node, 'formula')
            self.formula = formula_
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType24.factory()
            obj_.build(child_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        super(saccharide_macromolecule_type, self).buildChildren(child_, node, nodeName_, True)
# end class saccharide_macromolecule_type


class structure_determination_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, structure_determination_id=None, method=None, aggregation_state=None, macromolecules_and_complexes=None, specimen_preparation_list=None, microscopy_list=None, image_processing=None):
        self.original_tagname_ = None
        self.structure_determination_id = _cast(int, structure_determination_id)
        self.method = method
        self.validate_methodType(self.method)
        self.aggregation_state = aggregation_state
        self.validate_aggregation_stateType(self.aggregation_state)
        self.macromolecules_and_complexes = macromolecules_and_complexes
        self.specimen_preparation_list = specimen_preparation_list
        self.microscopy_list = microscopy_list
        if image_processing is None:
            self.image_processing = []
        else:
            self.image_processing = image_processing
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, structure_determination_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if structure_determination_type.subclass:
            return structure_determination_type.subclass(*args_, **kwargs_)
        else:
            return structure_determination_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def get_aggregation_state(self): return self.aggregation_state
    def set_aggregation_state(self, aggregation_state): self.aggregation_state = aggregation_state
    def get_macromolecules_and_complexes(self): return self.macromolecules_and_complexes
    def set_macromolecules_and_complexes(self, macromolecules_and_complexes): self.macromolecules_and_complexes = macromolecules_and_complexes
    def get_specimen_preparation_list(self): return self.specimen_preparation_list
    def set_specimen_preparation_list(self, specimen_preparation_list): self.specimen_preparation_list = specimen_preparation_list
    def get_microscopy_list(self): return self.microscopy_list
    def set_microscopy_list(self, microscopy_list): self.microscopy_list = microscopy_list
    def get_image_processing(self): return self.image_processing
    def set_image_processing(self, image_processing): self.image_processing = image_processing
    def add_image_processing(self, value): self.image_processing.append(value)
    def insert_image_processing_at(self, index, value): self.image_processing.insert(index, value)
    def replace_image_processing_at(self, index, value): self.image_processing[index] = value
    def get_structure_determination_id(self): return self.structure_determination_id
    def set_structure_determination_id(self, structure_determination_id): self.structure_determination_id = structure_determination_id
    def validate_methodType(self, value):
        # Validate type methodType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['singleParticle', 'subtomogramAveraging', 'tomography', 'electronCrystallography', 'helical']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on methodType' % {"value" : value.encode("utf-8")} )
    def validate_aggregation_stateType(self, value):
        # Validate type aggregation_stateType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['particle', 'filament', 'twoDArray', 'threeDArray', 'helicalArray', 'cell', 'tissue']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on aggregation_stateType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.method is not None or
            self.aggregation_state is not None or
            self.macromolecules_and_complexes is not None or
            self.specimen_preparation_list is not None or
            self.microscopy_list is not None or
            self.image_processing
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='structure_determination_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('structure_determination_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='structure_determination_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='structure_determination_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='structure_determination_type'):
        if self.structure_determination_id is not None and 'structure_determination_id' not in already_processed:
            already_processed.add('structure_determination_id')
            outfile.write(' structure_determination_id="%s"' % self.gds_format_integer(self.structure_determination_id, input_name='structure_determination_id'))
    def exportChildren(self, outfile, level, namespace_='', name_='structure_determination_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<method>%s</method>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), eol_))
        if self.aggregation_state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<aggregation_state>%s</aggregation_state>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.aggregation_state), input_name='aggregation_state')), eol_))
        if self.macromolecules_and_complexes is not None:
            self.macromolecules_and_complexes.export(outfile, level, namespace_, name_='macromolecules_and_complexes', pretty_print=pretty_print)
        if self.specimen_preparation_list is not None:
            self.specimen_preparation_list.export(outfile, level, namespace_, name_='specimen_preparation_list', pretty_print=pretty_print)
        if self.microscopy_list is not None:
            self.microscopy_list.export(outfile, level, namespace_, name_='microscopy_list', pretty_print=pretty_print)
        for image_processing_ in self.image_processing:
            image_processing_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('structure_determination_id', node)
        if value is not None and 'structure_determination_id' not in already_processed:
            already_processed.add('structure_determination_id')
            try:
                self.structure_determination_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.structure_determination_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'method':
            method_ = child_.text
            if method_:
                method_ = re_.sub(String_cleanup_pat_, " ", method_).strip()
            else:
                method_ = ""
            method_ = self.gds_validate_string(method_, node, 'method')
            self.method = method_
            # validate type methodType
            self.validate_methodType(self.method)
        elif nodeName_ == 'aggregation_state':
            aggregation_state_ = child_.text
            if aggregation_state_:
                aggregation_state_ = re_.sub(String_cleanup_pat_, " ", aggregation_state_).strip()
            else:
                aggregation_state_ = ""
            aggregation_state_ = self.gds_validate_string(aggregation_state_, node, 'aggregation_state')
            self.aggregation_state = aggregation_state_
            # validate type aggregation_stateType
            self.validate_aggregation_stateType(self.aggregation_state)
        elif nodeName_ == 'macromolecules_and_complexes':
            obj_ = macromolecules_and_complexes_type.factory()
            obj_.build(child_)
            self.macromolecules_and_complexes = obj_
            obj_.original_tagname_ = 'macromolecules_and_complexes'
        elif nodeName_ == 'specimen_preparation_list':
            obj_ = specimen_preparation_listType.factory()
            obj_.build(child_)
            self.specimen_preparation_list = obj_
            obj_.original_tagname_ = 'specimen_preparation_list'
        elif nodeName_ == 'microscopy_list':
            obj_ = microscopy_listType.factory()
            obj_.build(child_)
            self.microscopy_list = obj_
            obj_.original_tagname_ = 'microscopy_list'
        elif nodeName_ == 'image_processing':
            class_obj_ = self.get_class_obj_(child_, base_image_processing_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'image_processing'
        elif nodeName_ == 'crystallography_processing':
            obj_ = crystallography_processing_type.factory()
            obj_.build(child_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'crystallography_processing'
        elif nodeName_ == 'helical_processing':
            obj_ = helical_processing_type.factory()
            obj_.build(child_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'helical_processing'
        elif nodeName_ == 'singleparticle_processing':
            obj_ = singleparticle_processing_type.factory()
            obj_.build(child_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'singleparticle_processing'
        elif nodeName_ == 'subtomogram_averaging_processing':
            obj_ = subtomogram_averaging_processing_type.factory()
            obj_.build(child_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'subtomogram_averaging_processing'
        elif nodeName_ == 'tomography_processing':
            obj_ = tomography_processing_type.factory()
            obj_.build(child_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'tomography_processing'
# end class structure_determination_type


class macromolecules_and_complexes_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, macromolecule_id=None, complex_id=None):
        self.original_tagname_ = None
        if macromolecule_id is None:
            self.macromolecule_id = []
        else:
            self.macromolecule_id = macromolecule_id
        if complex_id is None:
            self.complex_id = []
        else:
            self.complex_id = complex_id
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecules_and_complexes_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecules_and_complexes_type.subclass:
            return macromolecules_and_complexes_type.subclass(*args_, **kwargs_)
        else:
            return macromolecules_and_complexes_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_macromolecule_id(self): return self.macromolecule_id
    def set_macromolecule_id(self, macromolecule_id): self.macromolecule_id = macromolecule_id
    def add_macromolecule_id(self, value): self.macromolecule_id.append(value)
    def insert_macromolecule_id_at(self, index, value): self.macromolecule_id.insert(index, value)
    def replace_macromolecule_id_at(self, index, value): self.macromolecule_id[index] = value
    def get_complex_id(self): return self.complex_id
    def set_complex_id(self, complex_id): self.complex_id = complex_id
    def add_complex_id(self, value): self.complex_id.append(value)
    def insert_complex_id_at(self, index, value): self.complex_id.insert(index, value)
    def replace_complex_id_at(self, index, value): self.complex_id[index] = value
    def hasContent_(self):
        if (
            self.macromolecule_id or
            self.complex_id
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromolecules_and_complexes_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecules_and_complexes_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromolecules_and_complexes_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromolecules_and_complexes_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromolecules_and_complexes_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='macromolecules_and_complexes_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for macromolecule_id_ in self.macromolecule_id:
            showIndent(outfile, level, pretty_print)
            outfile.write('<macromolecule_id>%s</macromolecule_id>%s' % (self.gds_format_integer(macromolecule_id_, input_name='macromolecule_id'), eol_))
        for complex_id_ in self.complex_id:
            showIndent(outfile, level, pretty_print)
            outfile.write('<complex_id>%s</complex_id>%s' % (self.gds_format_integer(complex_id_, input_name='complex_id'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'macromolecule_id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'macromolecule_id')
            self.macromolecule_id.append(ival_)
        elif nodeName_ == 'complex_id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'complex_id')
            self.complex_id.append(ival_)
# end class macromolecules_and_complexes_type


class base_preparation_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, extensiontype_=None):
        self.original_tagname_ = None
        self.preparation_id = _cast(int, preparation_id)
        self.concentration = concentration
        self.buffer = buffer
        self.staining = staining
        self.sugar_embedding = sugar_embedding
        self.shadowing = shadowing
        self.grid = grid
        self.vitrification = vitrification
        self.details = details
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_preparation_type.subclass:
            return base_preparation_type.subclass(*args_, **kwargs_)
        else:
            return base_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_concentration(self): return self.concentration
    def set_concentration(self, concentration): self.concentration = concentration
    def get_buffer(self): return self.buffer
    def set_buffer(self, buffer): self.buffer = buffer
    def get_staining(self): return self.staining
    def set_staining(self, staining): self.staining = staining
    def get_sugar_embedding(self): return self.sugar_embedding
    def set_sugar_embedding(self, sugar_embedding): self.sugar_embedding = sugar_embedding
    def get_shadowing(self): return self.shadowing
    def set_shadowing(self, shadowing): self.shadowing = shadowing
    def get_grid(self): return self.grid
    def set_grid(self, grid): self.grid = grid
    def get_vitrification(self): return self.vitrification
    def set_vitrification(self, vitrification): self.vitrification = vitrification
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_preparation_id(self): return self.preparation_id
    def set_preparation_id(self, preparation_id): self.preparation_id = preparation_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.concentration is not None or
            self.buffer is not None or
            self.staining is not None or
            self.sugar_embedding is not None or
            self.shadowing is not None or
            self.grid is not None or
            self.vitrification is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_preparation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_preparation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_preparation_type'):
        if self.preparation_id is not None and 'preparation_id' not in already_processed:
            already_processed.add('preparation_id')
            outfile.write(' preparation_id="%s"' % self.gds_format_integer(self.preparation_id, input_name='preparation_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='base_preparation_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.concentration is not None:
            self.concentration.export(outfile, level, namespace_, name_='concentration', pretty_print=pretty_print)
        if self.buffer is not None:
            self.buffer.export(outfile, level, namespace_, name_='buffer', pretty_print=pretty_print)
        if self.staining is not None:
            self.staining.export(outfile, level, namespace_, name_='staining', pretty_print=pretty_print)
        if self.sugar_embedding is not None:
            self.sugar_embedding.export(outfile, level, namespace_, name_='sugar_embedding', pretty_print=pretty_print)
        if self.shadowing is not None:
            self.shadowing.export(outfile, level, namespace_, name_='shadowing', pretty_print=pretty_print)
        if self.grid is not None:
            self.grid.export(outfile, level, namespace_, name_='grid', pretty_print=pretty_print)
        if self.vitrification is not None:
            self.vitrification.export(outfile, level, namespace_, name_='vitrification', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('preparation_id', node)
        if value is not None and 'preparation_id' not in already_processed:
            already_processed.add('preparation_id')
            try:
                self.preparation_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.preparation_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'concentration':
            obj_ = concentrationType.factory()
            obj_.build(child_)
            self.concentration = obj_
            obj_.original_tagname_ = 'concentration'
        elif nodeName_ == 'buffer':
            obj_ = buffer_type.factory()
            obj_.build(child_)
            self.buffer = obj_
            obj_.original_tagname_ = 'buffer'
        elif nodeName_ == 'staining':
            obj_ = stainingType.factory()
            obj_.build(child_)
            self.staining = obj_
            obj_.original_tagname_ = 'staining'
        elif nodeName_ == 'sugar_embedding':
            obj_ = sugar_embeddingType.factory()
            obj_.build(child_)
            self.sugar_embedding = obj_
            obj_.original_tagname_ = 'sugar_embedding'
        elif nodeName_ == 'shadowing':
            obj_ = shadowingType.factory()
            obj_.build(child_)
            self.shadowing = obj_
            obj_.original_tagname_ = 'shadowing'
        elif nodeName_ == 'grid':
            obj_ = grid_type.factory()
            obj_.build(child_)
            self.grid = obj_
            obj_.original_tagname_ = 'grid'
        elif nodeName_ == 'vitrification':
            obj_ = vitrification_type.factory()
            obj_.build(child_)
            self.vitrification = obj_
            obj_.original_tagname_ = 'vitrification'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class base_preparation_type


class buffer_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ph=None, component=None, details=None):
        self.original_tagname_ = None
        self.ph = ph
        self.validate_phType(self.ph)
        if component is None:
            self.component = []
        else:
            self.component = component
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, buffer_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if buffer_type.subclass:
            return buffer_type.subclass(*args_, **kwargs_)
        else:
            return buffer_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ph(self): return self.ph
    def set_ph(self, ph): self.ph = ph
    def get_component(self): return self.component
    def set_component(self, component): self.component = component
    def add_component(self, value): self.component.append(value)
    def insert_component_at(self, index, value): self.component.insert(index, value)
    def replace_component_at(self, index, value): self.component[index] = value
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_phType(self, value):
        # Validate type phType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on phType' % {"value" : value} )
            if value > 14:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on phType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.ph is not None or
            self.component or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='buffer_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('buffer_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='buffer_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='buffer_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='buffer_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='buffer_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ph is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<ph>%s</ph>%s' % (self.gds_format_float(self.ph, input_name='ph'), eol_))
        for component_ in self.component:
            component_.export(outfile, level, namespace_, name_='component', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ph':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'ph')
            self.ph = fval_
            # validate type phType
            self.validate_phType(self.ph)
        elif nodeName_ == 'component':
            obj_ = buffer_component_type.factory()
            obj_.build(child_)
            self.component.append(obj_)
            obj_.original_tagname_ = 'component'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class buffer_type


class buffer_component_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, concentration=None, formula=None, name=None):
        self.original_tagname_ = None
        self.concentration = concentration
        self.formula = formula
        self.validate_formula_type(self.formula)
        self.name = name
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, buffer_component_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if buffer_component_type.subclass:
            return buffer_component_type.subclass(*args_, **kwargs_)
        else:
            return buffer_component_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_concentration(self): return self.concentration
    def set_concentration(self, concentration): self.concentration = concentration
    def get_formula(self): return self.formula
    def set_formula(self, formula): self.formula = formula
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def validate_formula_type(self, value):
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.concentration is not None or
            self.formula is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='buffer_component_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('buffer_component_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='buffer_component_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='buffer_component_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='buffer_component_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='buffer_component_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.concentration is not None:
            self.concentration.export(outfile, level, namespace_, name_='concentration', pretty_print=pretty_print)
        if self.formula is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<formula>%s</formula>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<name>%s</name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'concentration':
            obj_ = concentrationType26.factory()
            obj_.build(child_)
            self.concentration = obj_
            obj_.original_tagname_ = 'concentration'
        elif nodeName_ == 'formula':
            formula_ = child_.text
            if formula_:
                formula_ = re_.sub(String_cleanup_pat_, " ", formula_).strip()
            else:
                formula_ = ""
            formula_ = self.gds_validate_string(formula_, node, 'formula')
            self.formula = formula_
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'name':
            name_ = child_.text
            if name_:
                name_ = re_.sub(String_cleanup_pat_, " ", name_).strip()
            else:
                name_ = ""
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
# end class buffer_component_type


class grid_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, model=None, material=None, mesh=None, support_film=None, pretreatment=None, details=None):
        self.original_tagname_ = None
        self.model = model
        self.material = material
        self.validate_materialType(self.material)
        self.mesh = mesh
        if support_film is None:
            self.support_film = []
        else:
            self.support_film = support_film
        self.pretreatment = pretreatment
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grid_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grid_type.subclass:
            return grid_type.subclass(*args_, **kwargs_)
        else:
            return grid_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_model(self): return self.model
    def set_model(self, model): self.model = model
    def get_material(self): return self.material
    def set_material(self, material): self.material = material
    def get_mesh(self): return self.mesh
    def set_mesh(self, mesh): self.mesh = mesh
    def get_support_film(self): return self.support_film
    def set_support_film(self, support_film): self.support_film = support_film
    def add_support_film(self, value): self.support_film.append(value)
    def insert_support_film_at(self, index, value): self.support_film.insert(index, value)
    def replace_support_film_at(self, index, value): self.support_film[index] = value
    def get_pretreatment(self): return self.pretreatment
    def set_pretreatment(self, pretreatment): self.pretreatment = pretreatment
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_materialType(self, value):
        # Validate type materialType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['COPPER', 'COPPER/PALLADIUM', 'COPPER/RHODIUM', 'GOLD', 'GRAPHENE OXIDE', 'MOLYBDENUM', 'NICKEL', 'NICKEL/TITANIUM', 'PLATINUM', 'SILICON NITRIDE', 'TITANIUM', 'TUNGSTEN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on materialType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.model is not None or
            self.material is not None or
            self.mesh is not None or
            self.support_film or
            self.pretreatment is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='grid_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grid_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='grid_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='grid_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='grid_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='grid_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<model>%s</model>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.model), input_name='model')), eol_))
        if self.material is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<material>%s</material>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.material), input_name='material')), eol_))
        if self.mesh is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<mesh>%s</mesh>%s' % (self.gds_format_integer(self.mesh, input_name='mesh'), eol_))
        for support_film_ in self.support_film:
            support_film_.export(outfile, level, namespace_, name_='support_film', pretty_print=pretty_print)
        if self.pretreatment is not None:
            self.pretreatment.export(outfile, level, namespace_, name_='pretreatment', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'model':
            model_ = child_.text
            if model_:
                model_ = re_.sub(String_cleanup_pat_, " ", model_).strip()
            else:
                model_ = ""
            model_ = self.gds_validate_string(model_, node, 'model')
            self.model = model_
        elif nodeName_ == 'material':
            material_ = child_.text
            if material_:
                material_ = re_.sub(String_cleanup_pat_, " ", material_).strip()
            else:
                material_ = ""
            material_ = self.gds_validate_string(material_, node, 'material')
            self.material = material_
            # validate type materialType
            self.validate_materialType(self.material)
        elif nodeName_ == 'mesh':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'mesh')
            self.mesh = ival_
        elif nodeName_ == 'support_film':
            obj_ = film_type.factory()
            obj_.build(child_)
            self.support_film.append(obj_)
            obj_.original_tagname_ = 'support_film'
        elif nodeName_ == 'pretreatment':
            obj_ = grid_pretreatment_type.factory()
            obj_.build(child_)
            self.pretreatment = obj_
            obj_.original_tagname_ = 'pretreatment'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class grid_type


class film_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, film_type_id=None, film_material=None, film_topology=None, film_thickness=None):
        self.original_tagname_ = None
        self.film_type_id = _cast(int, film_type_id)
        self.film_material = film_material
        self.validate_film_materialType(self.film_material)
        self.film_topology = film_topology
        self.validate_film_topologyType(self.film_topology)
        self.film_thickness = film_thickness
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, film_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if film_type.subclass:
            return film_type.subclass(*args_, **kwargs_)
        else:
            return film_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_film_material(self): return self.film_material
    def set_film_material(self, film_material): self.film_material = film_material
    def get_film_topology(self): return self.film_topology
    def set_film_topology(self, film_topology): self.film_topology = film_topology
    def get_film_thickness(self): return self.film_thickness
    def set_film_thickness(self, film_thickness): self.film_thickness = film_thickness
    def get_film_type_id(self): return self.film_type_id
    def set_film_type_id(self, film_type_id): self.film_type_id = film_type_id
    def validate_film_materialType(self, value):
        # Validate type film_materialType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['CARBON', 'CELLULOSE ACETATE', 'FORMVAR', 'GOLD', 'GRAPHENE', 'GRAPHENE OXIDE', 'PARLODION']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on film_materialType' % {"value" : value.encode("utf-8")} )
    def validate_film_topologyType(self, value):
        # Validate type film_topologyType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['CONTINUOUS', 'HOLEY', 'HOLEY ARRAY', 'LACEY']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on film_topologyType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.film_material is not None or
            self.film_topology is not None or
            self.film_thickness is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='film_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('film_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='film_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='film_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='film_type'):
        if self.film_type_id is not None and 'film_type_id' not in already_processed:
            already_processed.add('film_type_id')
            outfile.write(' film_type_id="%s"' % self.gds_format_integer(self.film_type_id, input_name='film_type_id'))
    def exportChildren(self, outfile, level, namespace_='', name_='film_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.film_material is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<film_material>%s</film_material>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.film_material), input_name='film_material')), eol_))
        if self.film_topology is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<film_topology>%s</film_topology>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.film_topology), input_name='film_topology')), eol_))
        if self.film_thickness is not None:
            self.film_thickness.export(outfile, level, namespace_, name_='film_thickness', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('film_type_id', node)
        if value is not None and 'film_type_id' not in already_processed:
            already_processed.add('film_type_id')
            try:
                self.film_type_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.film_type_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'film_material':
            film_material_ = child_.text
            if film_material_:
                film_material_ = re_.sub(String_cleanup_pat_, " ", film_material_).strip()
            else:
                film_material_ = ""
            film_material_ = self.gds_validate_string(film_material_, node, 'film_material')
            self.film_material = film_material_
            # validate type film_materialType
            self.validate_film_materialType(self.film_material)
        elif nodeName_ == 'film_topology':
            film_topology_ = child_.text
            if film_topology_:
                film_topology_ = re_.sub(String_cleanup_pat_, " ", film_topology_).strip()
            else:
                film_topology_ = ""
            film_topology_ = self.gds_validate_string(film_topology_, node, 'film_topology')
            self.film_topology = film_topology_
            # validate type film_topologyType
            self.validate_film_topologyType(self.film_topology)
        elif nodeName_ == 'film_thickness':
            obj_ = film_thicknessType.factory()
            obj_.build(child_)
            self.film_thickness = obj_
            obj_.original_tagname_ = 'film_thickness'
# end class film_type


class grid_pretreatment_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, time=None, atmosphere=None, pressure=None):
        self.original_tagname_ = None
        self.type_ = type_
        self.time = time
        self.atmosphere = atmosphere
        self.validate_atmosphereType(self.atmosphere)
        self.pressure = pressure
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grid_pretreatment_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grid_pretreatment_type.subclass:
            return grid_pretreatment_type.subclass(*args_, **kwargs_)
        else:
            return grid_pretreatment_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_time(self): return self.time
    def set_time(self, time): self.time = time
    def get_atmosphere(self): return self.atmosphere
    def set_atmosphere(self, atmosphere): self.atmosphere = atmosphere
    def get_pressure(self): return self.pressure
    def set_pressure(self, pressure): self.pressure = pressure
    def validate_atmosphereType(self, value):
        # Validate type atmosphereType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['AIR', 'AMYLAMINE', 'NITROGEN', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on atmosphereType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.time is not None or
            self.atmosphere is not None or
            self.pressure is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='grid_pretreatment_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grid_pretreatment_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='grid_pretreatment_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='grid_pretreatment_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='grid_pretreatment_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='grid_pretreatment_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<type>%s</type>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), eol_))
        if self.time is not None:
            self.time.export(outfile, level, namespace_, name_='time', pretty_print=pretty_print)
        if self.atmosphere is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<atmosphere>%s</atmosphere>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.atmosphere), input_name='atmosphere')), eol_))
        if self.pressure is not None:
            self.pressure.export(outfile, level, namespace_, name_='pressure', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            if type_:
                type_ = re_.sub(String_cleanup_pat_, " ", type_).strip()
            else:
                type_ = ""
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'time':
            obj_ = timeType.factory()
            obj_.build(child_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'atmosphere':
            atmosphere_ = child_.text
            if atmosphere_:
                atmosphere_ = re_.sub(String_cleanup_pat_, " ", atmosphere_).strip()
            else:
                atmosphere_ = ""
            atmosphere_ = self.gds_validate_string(atmosphere_, node, 'atmosphere')
            self.atmosphere = atmosphere_
            # validate type atmosphereType
            self.validate_atmosphereType(self.atmosphere)
        elif nodeName_ == 'pressure':
            obj_ = pressureType.factory()
            obj_.build(child_)
            self.pressure = obj_
            obj_.original_tagname_ = 'pressure'
# end class grid_pretreatment_type


class vitrification_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, cryogen_name=None, chamber_humidity=None, chamber_temperature=None, instrument=None, details=None, timed_resolved_state=None, method=None):
        self.original_tagname_ = None
        self.cryogen_name = cryogen_name
        self.validate_cryogen_nameType(self.cryogen_name)
        self.chamber_humidity = chamber_humidity
        self.chamber_temperature = chamber_temperature
        self.instrument = instrument
        self.validate_instrumentType(self.instrument)
        self.details = details
        self.timed_resolved_state = timed_resolved_state
        self.method = method
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vitrification_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vitrification_type.subclass:
            return vitrification_type.subclass(*args_, **kwargs_)
        else:
            return vitrification_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cryogen_name(self): return self.cryogen_name
    def set_cryogen_name(self, cryogen_name): self.cryogen_name = cryogen_name
    def get_chamber_humidity(self): return self.chamber_humidity
    def set_chamber_humidity(self, chamber_humidity): self.chamber_humidity = chamber_humidity
    def get_chamber_temperature(self): return self.chamber_temperature
    def set_chamber_temperature(self, chamber_temperature): self.chamber_temperature = chamber_temperature
    def get_instrument(self): return self.instrument
    def set_instrument(self, instrument): self.instrument = instrument
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_timed_resolved_state(self): return self.timed_resolved_state
    def set_timed_resolved_state(self, timed_resolved_state): self.timed_resolved_state = timed_resolved_state
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def validate_cryogen_nameType(self, value):
        # Validate type cryogen_nameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ETHANE', 'ETHANE-PROPANE', 'FREON 12', 'FREON 22', 'HELIUM', 'METHANE', 'NITROGEN', 'OTHER', 'PROPANE']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on cryogen_nameType' % {"value" : value.encode("utf-8")} )
    def validate_instrumentType(self, value):
        # Validate type instrumentType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EMS-002 RAPID IMMERSION FREEZER', 'FEI VITROBOT MARK I', 'FEI VITROBOT MARK II', 'FEI VITROBOT MARK III', 'FEI VITROBOT MARK IV', 'GATAN CRYOPLUNGE 3', 'HOMEMADE PLUNGER', 'LEICA EM CPC', 'LEICA EM GP', 'LEICA KF80', 'LEICA PLUNGER', 'REICHERT-JUNG PLUNGER', 'SPOTITON', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on instrumentType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.cryogen_name is not None or
            self.chamber_humidity is not None or
            self.chamber_temperature is not None or
            self.instrument is not None or
            self.details is not None or
            self.timed_resolved_state is not None or
            self.method is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vitrification_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vitrification_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vitrification_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vitrification_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vitrification_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='vitrification_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cryogen_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cryogen_name>%s</cryogen_name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cryogen_name), input_name='cryogen_name')), eol_))
        if self.chamber_humidity is not None:
            self.chamber_humidity.export(outfile, level, namespace_, name_='chamber_humidity', pretty_print=pretty_print)
        if self.chamber_temperature is not None:
            self.chamber_temperature.export(outfile, level, namespace_, name_='chamber_temperature', pretty_print=pretty_print)
        if self.instrument is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<instrument>%s</instrument>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.instrument), input_name='instrument')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
        if self.timed_resolved_state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<timed_resolved_state>%s</timed_resolved_state>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.timed_resolved_state), input_name='timed_resolved_state')), eol_))
        if self.method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<method>%s</method>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cryogen_name':
            cryogen_name_ = child_.text
            if cryogen_name_:
                cryogen_name_ = re_.sub(String_cleanup_pat_, " ", cryogen_name_).strip()
            else:
                cryogen_name_ = ""
            cryogen_name_ = self.gds_validate_string(cryogen_name_, node, 'cryogen_name')
            self.cryogen_name = cryogen_name_
            # validate type cryogen_nameType
            self.validate_cryogen_nameType(self.cryogen_name)
        elif nodeName_ == 'chamber_humidity':
            obj_ = chamber_humidityType.factory()
            obj_.build(child_)
            self.chamber_humidity = obj_
            obj_.original_tagname_ = 'chamber_humidity'
        elif nodeName_ == 'chamber_temperature':
            obj_ = chamber_temperatureType.factory()
            obj_.build(child_)
            self.chamber_temperature = obj_
            obj_.original_tagname_ = 'chamber_temperature'
        elif nodeName_ == 'instrument':
            instrument_ = child_.text
            if instrument_:
                instrument_ = re_.sub(String_cleanup_pat_, " ", instrument_).strip()
            else:
                instrument_ = ""
            instrument_ = self.gds_validate_string(instrument_, node, 'instrument')
            self.instrument = instrument_
            # validate type instrumentType
            self.validate_instrumentType(self.instrument)
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'timed_resolved_state':
            timed_resolved_state_ = child_.text
            if timed_resolved_state_:
                timed_resolved_state_ = re_.sub(String_cleanup_pat_, " ", timed_resolved_state_).strip()
            else:
                timed_resolved_state_ = ""
            timed_resolved_state_ = self.gds_validate_string(timed_resolved_state_, node, 'timed_resolved_state')
            self.timed_resolved_state = timed_resolved_state_
        elif nodeName_ == 'method':
            method_ = child_.text
            method_ = self.gds_validate_string(method_, node, 'method')
            self.method = method_
# end class vitrification_type


class crystallography_preparation_type(base_preparation_type):
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, crystal_formation=None):
        self.original_tagname_ = None
        super(crystallography_preparation_type, self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details, )
        self.crystal_formation = crystal_formation
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_preparation_type.subclass:
            return crystallography_preparation_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_crystal_formation(self): return self.crystal_formation
    def set_crystal_formation(self, crystal_formation): self.crystal_formation = crystal_formation
    def hasContent_(self):
        if (
            self.crystal_formation is not None or
            super(crystallography_preparation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystallography_preparation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_preparation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystallography_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystallography_preparation_type'):
        super(crystallography_preparation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_preparation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='crystallography_preparation_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_preparation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.crystal_formation is not None:
            self.crystal_formation.export(outfile, level, namespace_, name_='crystal_formation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(crystallography_preparation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'crystal_formation':
            obj_ = crystal_formationType.factory()
            obj_.build(child_)
            self.crystal_formation = obj_
            obj_.original_tagname_ = 'crystal_formation'
        super(crystallography_preparation_type, self).buildChildren(child_, node, nodeName_, True)
# end class crystallography_preparation_type


class crystal_formation_temperature_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystal_formation_temperature_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystal_formation_temperature_type.subclass:
            return crystal_formation_temperature_type.subclass(*args_, **kwargs_)
        else:
            return crystal_formation_temperature_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystal_formation_temperature_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystal_formation_temperature_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystal_formation_temperature_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystal_formation_temperature_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystal_formation_temperature_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='crystal_formation_temperature_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class crystal_formation_temperature_type


class crystal_formation_time_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystal_formation_time_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystal_formation_time_type.subclass:
            return crystal_formation_time_type.subclass(*args_, **kwargs_)
        else:
            return crystal_formation_time_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystal_formation_time_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystal_formation_time_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystal_formation_time_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystal_formation_time_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystal_formation_time_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='crystal_formation_time_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class crystal_formation_time_type


class helical_preparation_type(base_preparation_type):
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None):
        self.original_tagname_ = None
        super(helical_preparation_type, self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_preparation_type.subclass:
            return helical_preparation_type.subclass(*args_, **kwargs_)
        else:
            return helical_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(helical_preparation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='helical_preparation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='helical_preparation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='helical_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='helical_preparation_type'):
        super(helical_preparation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='helical_preparation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='helical_preparation_type', fromsubclass_=False, pretty_print=True):
        super(helical_preparation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(helical_preparation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(helical_preparation_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class helical_preparation_type


class single_particle_preparation_type(base_preparation_type):
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None):
        self.original_tagname_ = None
        super(single_particle_preparation_type, self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, single_particle_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if single_particle_preparation_type.subclass:
            return single_particle_preparation_type.subclass(*args_, **kwargs_)
        else:
            return single_particle_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(single_particle_preparation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='single_particle_preparation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('single_particle_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='single_particle_preparation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='single_particle_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='single_particle_preparation_type'):
        super(single_particle_preparation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='single_particle_preparation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='single_particle_preparation_type', fromsubclass_=False, pretty_print=True):
        super(single_particle_preparation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(single_particle_preparation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(single_particle_preparation_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class single_particle_preparation_type


class subtomogram_averaging_preparation_type(base_preparation_type):
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None):
        self.original_tagname_ = None
        super(subtomogram_averaging_preparation_type, self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, subtomogram_averaging_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if subtomogram_averaging_preparation_type.subclass:
            return subtomogram_averaging_preparation_type.subclass(*args_, **kwargs_)
        else:
            return subtomogram_averaging_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(subtomogram_averaging_preparation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='subtomogram_averaging_preparation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('subtomogram_averaging_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='subtomogram_averaging_preparation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='subtomogram_averaging_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='subtomogram_averaging_preparation_type'):
        super(subtomogram_averaging_preparation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='subtomogram_averaging_preparation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='subtomogram_averaging_preparation_type', fromsubclass_=False, pretty_print=True):
        super(subtomogram_averaging_preparation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(subtomogram_averaging_preparation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(subtomogram_averaging_preparation_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class subtomogram_averaging_preparation_type


class tomography_preparation_type(base_preparation_type):
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, fiducial_markers_list=None, high_pressure_freezing=None, embedding_material=None, cryo_protectant=None, sectioning=None):
        self.original_tagname_ = None
        super(tomography_preparation_type, self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details, )
        self.fiducial_markers_list = fiducial_markers_list
        self.high_pressure_freezing = high_pressure_freezing
        self.embedding_material = embedding_material
        self.cryo_protectant = cryo_protectant
        self.sectioning = sectioning
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tomography_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tomography_preparation_type.subclass:
            return tomography_preparation_type.subclass(*args_, **kwargs_)
        else:
            return tomography_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fiducial_markers_list(self): return self.fiducial_markers_list
    def set_fiducial_markers_list(self, fiducial_markers_list): self.fiducial_markers_list = fiducial_markers_list
    def get_high_pressure_freezing(self): return self.high_pressure_freezing
    def set_high_pressure_freezing(self, high_pressure_freezing): self.high_pressure_freezing = high_pressure_freezing
    def get_embedding_material(self): return self.embedding_material
    def set_embedding_material(self, embedding_material): self.embedding_material = embedding_material
    def get_cryo_protectant(self): return self.cryo_protectant
    def set_cryo_protectant(self, cryo_protectant): self.cryo_protectant = cryo_protectant
    def get_sectioning(self): return self.sectioning
    def set_sectioning(self, sectioning): self.sectioning = sectioning
    def hasContent_(self):
        if (
            self.fiducial_markers_list is not None or
            self.high_pressure_freezing is not None or
            self.embedding_material is not None or
            self.cryo_protectant is not None or
            self.sectioning is not None or
            super(tomography_preparation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tomography_preparation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tomography_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tomography_preparation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tomography_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tomography_preparation_type'):
        super(tomography_preparation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='tomography_preparation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='tomography_preparation_type', fromsubclass_=False, pretty_print=True):
        super(tomography_preparation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fiducial_markers_list is not None:
            self.fiducial_markers_list.export(outfile, level, namespace_, name_='fiducial_markers_list', pretty_print=pretty_print)
        if self.high_pressure_freezing is not None:
            self.high_pressure_freezing.export(outfile, level, namespace_, name_='high_pressure_freezing', pretty_print=pretty_print)
        if self.embedding_material is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<embedding_material>%s</embedding_material>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.embedding_material), input_name='embedding_material')), eol_))
        if self.cryo_protectant is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cryo_protectant>%s</cryo_protectant>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cryo_protectant), input_name='cryo_protectant')), eol_))
        if self.sectioning is not None:
            self.sectioning.export(outfile, level, namespace_, name_='sectioning', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(tomography_preparation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fiducial_markers_list':
            obj_ = fiducial_markers_listType.factory()
            obj_.build(child_)
            self.fiducial_markers_list = obj_
            obj_.original_tagname_ = 'fiducial_markers_list'
        elif nodeName_ == 'high_pressure_freezing':
            obj_ = high_pressure_freezingType.factory()
            obj_.build(child_)
            self.high_pressure_freezing = obj_
            obj_.original_tagname_ = 'high_pressure_freezing'
        elif nodeName_ == 'embedding_material':
            embedding_material_ = child_.text
            if embedding_material_:
                embedding_material_ = re_.sub(String_cleanup_pat_, " ", embedding_material_).strip()
            else:
                embedding_material_ = ""
            embedding_material_ = self.gds_validate_string(embedding_material_, node, 'embedding_material')
            self.embedding_material = embedding_material_
        elif nodeName_ == 'cryo_protectant':
            cryo_protectant_ = child_.text
            if cryo_protectant_:
                cryo_protectant_ = re_.sub(String_cleanup_pat_, " ", cryo_protectant_).strip()
            else:
                cryo_protectant_ = ""
            cryo_protectant_ = self.gds_validate_string(cryo_protectant_, node, 'cryo_protectant')
            self.cryo_protectant = cryo_protectant_
        elif nodeName_ == 'sectioning':
            obj_ = sectioningType.factory()
            obj_.build(child_)
            self.sectioning = obj_
            obj_.original_tagname_ = 'sectioning'
        super(tomography_preparation_type, self).buildChildren(child_, node, nodeName_, True)
# end class tomography_preparation_type


class fiducial_marker_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, fiducial_type=None, manufacturer=None, diameter=None):
        self.original_tagname_ = None
        self.fiducial_type = fiducial_type
        self.manufacturer = manufacturer
        self.diameter = diameter
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fiducial_marker_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fiducial_marker_type.subclass:
            return fiducial_marker_type.subclass(*args_, **kwargs_)
        else:
            return fiducial_marker_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fiducial_type(self): return self.fiducial_type
    def set_fiducial_type(self, fiducial_type): self.fiducial_type = fiducial_type
    def get_manufacturer(self): return self.manufacturer
    def set_manufacturer(self, manufacturer): self.manufacturer = manufacturer
    def get_diameter(self): return self.diameter
    def set_diameter(self, diameter): self.diameter = diameter
    def hasContent_(self):
        if (
            self.fiducial_type is not None or
            self.manufacturer is not None or
            self.diameter is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fiducial_marker_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fiducial_marker_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fiducial_marker_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fiducial_marker_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fiducial_marker_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='fiducial_marker_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fiducial_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<fiducial_type>%s</fiducial_type>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.fiducial_type), input_name='fiducial_type')), eol_))
        if self.manufacturer is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<manufacturer>%s</manufacturer>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.manufacturer), input_name='manufacturer')), eol_))
        if self.diameter is not None:
            self.diameter.export(outfile, level, namespace_, name_='diameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fiducial_type':
            fiducial_type_ = child_.text
            if fiducial_type_:
                fiducial_type_ = re_.sub(String_cleanup_pat_, " ", fiducial_type_).strip()
            else:
                fiducial_type_ = ""
            fiducial_type_ = self.gds_validate_string(fiducial_type_, node, 'fiducial_type')
            self.fiducial_type = fiducial_type_
        elif nodeName_ == 'manufacturer':
            manufacturer_ = child_.text
            if manufacturer_:
                manufacturer_ = re_.sub(String_cleanup_pat_, " ", manufacturer_).strip()
            else:
                manufacturer_ = ""
            manufacturer_ = self.gds_validate_string(manufacturer_, node, 'manufacturer')
            self.manufacturer = manufacturer_
        elif nodeName_ == 'diameter':
            obj_ = fiducial_marker_diameter_type.factory()
            obj_.build(child_)
            self.diameter = obj_
            obj_.original_tagname_ = 'diameter'
# end class fiducial_marker_type


class fiducial_marker_diameter_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fiducial_marker_diameter_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fiducial_marker_diameter_type.subclass:
            return fiducial_marker_diameter_type.subclass(*args_, **kwargs_)
        else:
            return fiducial_marker_diameter_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fiducial_marker_diameter_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fiducial_marker_diameter_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fiducial_marker_diameter_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fiducial_marker_diameter_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fiducial_marker_diameter_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fiducial_marker_diameter_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fiducial_marker_diameter_type


class temperature_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, temperature_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if temperature_type.subclass:
            return temperature_type.subclass(*args_, **kwargs_)
        else:
            return temperature_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='temperature_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('temperature_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='temperature_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='temperature_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='temperature_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='temperature_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class temperature_type


class ultramicrotomy_final_thickness_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units='nm', valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ultramicrotomy_final_thickness_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ultramicrotomy_final_thickness_type.subclass:
            return ultramicrotomy_final_thickness_type.subclass(*args_, **kwargs_)
        else:
            return ultramicrotomy_final_thickness_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ultramicrotomy_final_thickness_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ultramicrotomy_final_thickness_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ultramicrotomy_final_thickness_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ultramicrotomy_final_thickness_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ultramicrotomy_final_thickness_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ultramicrotomy_final_thickness_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ultramicrotomy_final_thickness_type


class fib_voltage_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_voltage_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_voltage_type.subclass:
            return fib_voltage_type.subclass(*args_, **kwargs_)
        else:
            return fib_voltage_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fib_voltage_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_voltage_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fib_voltage_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fib_voltage_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fib_voltage_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fib_voltage_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fib_voltage_type


class fib_current_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_current_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_current_type.subclass:
            return fib_current_type.subclass(*args_, **kwargs_)
        else:
            return fib_current_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fib_current_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_current_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fib_current_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fib_current_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fib_current_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fib_current_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fib_current_type


class fib_dose_rate_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units='ions/(cm^2*s)', valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_dose_rate_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_dose_rate_type.subclass:
            return fib_dose_rate_type.subclass(*args_, **kwargs_)
        else:
            return fib_dose_rate_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fib_dose_rate_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_dose_rate_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fib_dose_rate_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fib_dose_rate_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fib_dose_rate_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fib_dose_rate_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fib_dose_rate_type


class fib_duration_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_duration_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_duration_type.subclass:
            return fib_duration_type.subclass(*args_, **kwargs_)
        else:
            return fib_duration_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fib_duration_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_duration_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fib_duration_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fib_duration_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fib_duration_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fib_duration_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fib_duration_type


class fib_initial_thickness_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units='nm', valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_initial_thickness_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_initial_thickness_type.subclass:
            return fib_initial_thickness_type.subclass(*args_, **kwargs_)
        else:
            return fib_initial_thickness_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fib_initial_thickness_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_initial_thickness_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fib_initial_thickness_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fib_initial_thickness_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fib_initial_thickness_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fib_initial_thickness_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fib_initial_thickness_type


class fib_final_thickness_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units='nm', valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_final_thickness_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_final_thickness_type.subclass:
            return fib_final_thickness_type.subclass(*args_, **kwargs_)
        else:
            return fib_final_thickness_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fib_final_thickness_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_final_thickness_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fib_final_thickness_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fib_final_thickness_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fib_final_thickness_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fib_final_thickness_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fib_final_thickness_type


class base_microscopy_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, extensiontype_=None):
        self.original_tagname_ = None
        self.microscopy_id = _cast(int, microscopy_id)
        self.specimen_preparations = specimen_preparations
        self.microscope = microscope
        self.validate_microscopeType(self.microscope)
        self.illumination_mode = illumination_mode
        self.validate_illumination_modeType(self.illumination_mode)
        self.imaging_mode = imaging_mode
        self.validate_imaging_modeType(self.imaging_mode)
        self.electron_source = electron_source
        self.validate_electron_sourceType(self.electron_source)
        self.acceleration_voltage = acceleration_voltage
        self.c2_aperture_diameter = c2_aperture_diameter
        self.nominal_cs = nominal_cs
        self.nominal_defocus_min = nominal_defocus_min
        self.calibrated_defocus_min = calibrated_defocus_min
        self.nominal_defocus_max = nominal_defocus_max
        self.calibrated_defocus_max = calibrated_defocus_max
        self.nominal_magnification = nominal_magnification
        self.validate_allowed_magnification(self.nominal_magnification)
        self.calibrated_magnification = calibrated_magnification
        self.validate_allowed_magnification(self.calibrated_magnification)
        self.specimen_holder_model = specimen_holder_model
        self.validate_specimen_holder_modelType(self.specimen_holder_model)
        self.cooling_holder_cryogen = cooling_holder_cryogen
        self.validate_cooling_holder_cryogenType(self.cooling_holder_cryogen)
        self.temperature = temperature
        self.alignment_procedure = alignment_procedure
        self.specialist_optics = specialist_optics
        self.software_list = software_list
        self.details = details
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.image_recording_list = image_recording_list
        self.specimen_holder = specimen_holder
        self.tilt_angle_min = tilt_angle_min
        self.tilt_angle_max = tilt_angle_max
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_microscopy_type.subclass:
            return base_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return base_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_specimen_preparations(self): return self.specimen_preparations
    def set_specimen_preparations(self, specimen_preparations): self.specimen_preparations = specimen_preparations
    def get_microscope(self): return self.microscope
    def set_microscope(self, microscope): self.microscope = microscope
    def get_illumination_mode(self): return self.illumination_mode
    def set_illumination_mode(self, illumination_mode): self.illumination_mode = illumination_mode
    def get_imaging_mode(self): return self.imaging_mode
    def set_imaging_mode(self, imaging_mode): self.imaging_mode = imaging_mode
    def get_electron_source(self): return self.electron_source
    def set_electron_source(self, electron_source): self.electron_source = electron_source
    def get_acceleration_voltage(self): return self.acceleration_voltage
    def set_acceleration_voltage(self, acceleration_voltage): self.acceleration_voltage = acceleration_voltage
    def get_c2_aperture_diameter(self): return self.c2_aperture_diameter
    def set_c2_aperture_diameter(self, c2_aperture_diameter): self.c2_aperture_diameter = c2_aperture_diameter
    def get_nominal_cs(self): return self.nominal_cs
    def set_nominal_cs(self, nominal_cs): self.nominal_cs = nominal_cs
    def get_nominal_defocus_min(self): return self.nominal_defocus_min
    def set_nominal_defocus_min(self, nominal_defocus_min): self.nominal_defocus_min = nominal_defocus_min
    def get_calibrated_defocus_min(self): return self.calibrated_defocus_min
    def set_calibrated_defocus_min(self, calibrated_defocus_min): self.calibrated_defocus_min = calibrated_defocus_min
    def get_nominal_defocus_max(self): return self.nominal_defocus_max
    def set_nominal_defocus_max(self, nominal_defocus_max): self.nominal_defocus_max = nominal_defocus_max
    def get_calibrated_defocus_max(self): return self.calibrated_defocus_max
    def set_calibrated_defocus_max(self, calibrated_defocus_max): self.calibrated_defocus_max = calibrated_defocus_max
    def get_nominal_magnification(self): return self.nominal_magnification
    def set_nominal_magnification(self, nominal_magnification): self.nominal_magnification = nominal_magnification
    def get_calibrated_magnification(self): return self.calibrated_magnification
    def set_calibrated_magnification(self, calibrated_magnification): self.calibrated_magnification = calibrated_magnification
    def get_specimen_holder_model(self): return self.specimen_holder_model
    def set_specimen_holder_model(self, specimen_holder_model): self.specimen_holder_model = specimen_holder_model
    def get_cooling_holder_cryogen(self): return self.cooling_holder_cryogen
    def set_cooling_holder_cryogen(self, cooling_holder_cryogen): self.cooling_holder_cryogen = cooling_holder_cryogen
    def get_temperature(self): return self.temperature
    def set_temperature(self, temperature): self.temperature = temperature
    def get_alignment_procedure(self): return self.alignment_procedure
    def set_alignment_procedure(self, alignment_procedure): self.alignment_procedure = alignment_procedure
    def get_specialist_optics(self): return self.specialist_optics
    def set_specialist_optics(self, specialist_optics): self.specialist_optics = specialist_optics
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_image_recording_list(self): return self.image_recording_list
    def set_image_recording_list(self, image_recording_list): self.image_recording_list = image_recording_list
    def get_specimen_holder(self): return self.specimen_holder
    def set_specimen_holder(self, specimen_holder): self.specimen_holder = specimen_holder
    def get_tilt_angle_min(self): return self.tilt_angle_min
    def set_tilt_angle_min(self, tilt_angle_min): self.tilt_angle_min = tilt_angle_min
    def get_tilt_angle_max(self): return self.tilt_angle_max
    def set_tilt_angle_max(self, tilt_angle_max): self.tilt_angle_max = tilt_angle_max
    def get_microscopy_id(self): return self.microscopy_id
    def set_microscopy_id(self, microscopy_id): self.microscopy_id = microscopy_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_microscopeType(self, value):
        # Validate type microscopeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['FEI MORGAGNI', 'FEI POLARA 300', 'FEI TALOS ARCTICA', 'FEI TECNAI 10', 'FEI TECNAI 12', 'FEI TECNAI 20', 'FEI TECNAI ARCTICA', 'FEI TECNAI F20', 'FEI TECNAI F30', 'FEI TECNAI SPHERA', 'FEI TECNAI SPIRIT', 'FEI TITAN', 'FEI TITAN KRIOS', 'FEI/PHILIPS CM10', 'FEI/PHILIPS CM12', 'FEI/PHILIPS CM120T', 'FEI/PHILIPS CM200FEG', 'FEI/PHILIPS CM200FEG/SOPHIE', 'FEI/PHILIPS CM200FEG/ST', 'FEI/PHILIPS CM200FEG/UT', 'FEI/PHILIPS CM200T', 'FEI/PHILIPS CM300FEG/HE', 'FEI/PHILIPS CM300FEG/ST', 'FEI/PHILIPS CM300FEG/T', 'FEI/PHILIPS EM400', 'FEI/PHILIPS EM420', 'HITACHI EF2000', 'HITACHI H-9500SD', 'HITACHI H3000 UHVEM', 'HITACHI H7600', 'HITACHI HF2000', 'HITACHI HF3000', 'JEOL 100CX', 'JEOL 1000EES', 'JEOL 1010', 'JEOL 1200', 'JEOL 1200EX', 'JEOL 1200EXII', 'JEOL 1230', 'JEOL 1400', 'JEOL 2000EX', 'JEOL 2000EXII', 'JEOL 2010', 'JEOL 2010F', 'JEOL 2010HC', 'JEOL 2010HT', 'JEOL 2010UHR', 'JEOL 2011', 'JEOL 2100', 'JEOL 2100F', 'JEOL 2200FS', 'JEOL 2200FSC', 'JEOL 3000SFF', 'JEOL 3100FEF', 'JEOL 3100FFC', 'JEOL 3200FS', 'JEOL 3200FSC', 'JEOL 4000', 'JEOL 4000EX', 'JEOL CRYO ARM 200', 'JEOL CRYO ARM 300', 'JEOL KYOTO-3000SFF', 'TFS GLACIOS', 'TFS KRIOS', 'TFS TALOS', 'TFS TALOS L120C', 'TFS TALOS F200C', 'TFS TUNDRA', 'ZEISS LEO912', 'ZEISS LIBRA120PLUS']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on microscopeType' % {"value" : value.encode("utf-8")} )
    def validate_illumination_modeType(self, value):
        # Validate type illumination_modeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['FLOOD BEAM', 'SPOT SCAN', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on illumination_modeType' % {"value" : value.encode("utf-8")} )
    def validate_imaging_modeType(self, value):
        # Validate type imaging_modeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['BRIGHT FIELD', 'DARK FIELD', 'DIFFRACTION', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on imaging_modeType' % {"value" : value.encode("utf-8")} )
    def validate_electron_sourceType(self, value):
        # Validate type electron_sourceType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['TUNGSTEN HAIRPIN', 'LAB6', 'OTHER', 'FIELD EMISSION GUN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on electron_sourceType' % {"value" : value.encode("utf-8")} )
    def validate_allowed_magnification(self, value):
        # Validate type allowed_magnification, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 1000:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on allowed_magnification' % {"value" : value} )
            if value > 500000:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on allowed_magnification' % {"value" : value} )
    def validate_specimen_holder_modelType(self, value):
        # Validate type specimen_holder_modelType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['FISCHIONE 2550', 'FISCHIONE INSTRUMENTS DUAL AXIS TOMOGRAPHY HOLDER', 'FEI TITAN KRIOS AUTOGRID HOLDER', 'GATAN 626 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN 910 MULTI-SPECIMEN SINGLE TILT CRYO TRANSFER HOLDER', 'GATAN 914 HIGH TILT LIQUID NITROGEN CRYO TRANSFER TOMOGRAPHY HOLDER', 'GATAN 915 DOUBLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN CHDT 3504 DOUBLE TILT HIGH RESOLUTION NITROGEN COOLING HOLDER', 'GATAN CT3500 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN CT3500TR SINGLE TILT ROTATION LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN ELSA 698 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN HC 3500 SINGLE TILT HEATING/NITROGEN COOLING HOLDER', 'GATAN HCHDT 3010 DOUBLE TILT HIGH RESOLUTION HELIUM COOLING HOLDER', 'GATAN HCHST 3008 SINGLE TILT HIGH RESOLUTION HELIUM COOLING HOLDER', 'GATAN HELIUM', 'GATAN LIQUID NITROGEN', 'GATAN UHRST 3500 SINGLE TILT ULTRA HIGH RESOLUTION NITROGEN COOLING HOLDER', 'GATAN ULTDT ULTRA LOW TEMPERATURE DOUBLE TILT HELIUM COOLING HOLDER', 'GATAN ULTST ULTRA LOW TEMPERATURE SINGLE TILT HELIUM COOLING HOLDER', 'HOME BUILD', 'JEOL', 'JEOL 3200FSC CRYOHOLDER', 'OTHER', 'PHILIPS ROTATION HOLDER', 'SIDE ENTRY, EUCENTRIC', 'JEOL CRYOSPECPORTER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on specimen_holder_modelType' % {"value" : value.encode("utf-8")} )
    def validate_cooling_holder_cryogenType(self, value):
        # Validate type cooling_holder_cryogenType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['HELIUM', 'NITROGEN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on cooling_holder_cryogenType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.specimen_preparations is not None or
            self.microscope is not None or
            self.illumination_mode is not None or
            self.imaging_mode is not None or
            self.electron_source is not None or
            self.acceleration_voltage is not None or
            self.c2_aperture_diameter is not None or
            self.nominal_cs is not None or
            self.nominal_defocus_min is not None or
            self.calibrated_defocus_min is not None or
            self.nominal_defocus_max is not None or
            self.calibrated_defocus_max is not None or
            self.nominal_magnification is not None or
            self.calibrated_magnification is not None or
            self.specimen_holder_model is not None or
            self.cooling_holder_cryogen is not None or
            self.temperature is not None or
            self.alignment_procedure is not None or
            self.specialist_optics is not None or
            self.software_list is not None or
            self.details is not None or
            self.date is not None or
            self.image_recording_list is not None or
            self.specimen_holder is not None or
            self.tilt_angle_min is not None or
            self.tilt_angle_max is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_microscopy_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_microscopy_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_microscopy_type'):
        if self.microscopy_id is not None and 'microscopy_id' not in already_processed:
            already_processed.add('microscopy_id')
            outfile.write(' microscopy_id="%s"' % self.gds_format_integer(self.microscopy_id, input_name='microscopy_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='base_microscopy_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.specimen_preparations is not None:
            self.specimen_preparations.export(outfile, level, namespace_, name_='specimen_preparations', pretty_print=pretty_print)
        if self.microscope is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<microscope>%s</microscope>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.microscope), input_name='microscope')), eol_))
        if self.illumination_mode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<illumination_mode>%s</illumination_mode>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.illumination_mode), input_name='illumination_mode')), eol_))
        if self.imaging_mode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<imaging_mode>%s</imaging_mode>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.imaging_mode), input_name='imaging_mode')), eol_))
        if self.electron_source is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<electron_source>%s</electron_source>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.electron_source), input_name='electron_source')), eol_))
        if self.acceleration_voltage is not None:
            self.acceleration_voltage.export(outfile, level, namespace_, name_='acceleration_voltage', pretty_print=pretty_print)
        if self.c2_aperture_diameter is not None:
            self.c2_aperture_diameter.export(outfile, level, namespace_, name_='c2_aperture_diameter', pretty_print=pretty_print)
        if self.nominal_cs is not None:
            self.nominal_cs.export(outfile, level, namespace_, name_='nominal_cs', pretty_print=pretty_print)
        if self.nominal_defocus_min is not None:
            self.nominal_defocus_min.export(outfile, level, namespace_, name_='nominal_defocus_min', pretty_print=pretty_print)
        if self.calibrated_defocus_min is not None:
            self.calibrated_defocus_min.export(outfile, level, namespace_, name_='calibrated_defocus_min', pretty_print=pretty_print)
        if self.nominal_defocus_max is not None:
            self.nominal_defocus_max.export(outfile, level, namespace_, name_='nominal_defocus_max', pretty_print=pretty_print)
        if self.calibrated_defocus_max is not None:
            self.calibrated_defocus_max.export(outfile, level, namespace_, name_='calibrated_defocus_max', pretty_print=pretty_print)
        if self.nominal_magnification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<nominal_magnification>%s</nominal_magnification>%s' % (self.gds_format_float(self.nominal_magnification, input_name='nominal_magnification'), eol_))
        if self.calibrated_magnification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<calibrated_magnification>%s</calibrated_magnification>%s' % (self.gds_format_float(self.calibrated_magnification, input_name='calibrated_magnification'), eol_))
        if self.specimen_holder_model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<specimen_holder_model>%s</specimen_holder_model>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.specimen_holder_model), input_name='specimen_holder_model')), eol_))
        if self.cooling_holder_cryogen is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<cooling_holder_cryogen>%s</cooling_holder_cryogen>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.cooling_holder_cryogen), input_name='cooling_holder_cryogen')), eol_))
        if self.temperature is not None:
            self.temperature.export(outfile, level, namespace_, name_='temperature', pretty_print=pretty_print)
        if self.alignment_procedure is not None:
            self.alignment_procedure.export(outfile, level, namespace_, name_='alignment_procedure', pretty_print=pretty_print)
        if self.specialist_optics is not None:
            self.specialist_optics.export(outfile, level, namespace_, name_='specialist_optics', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<date>%s</date>%s' % (self.gds_format_date(self.date, input_name='date'), eol_))
        if self.image_recording_list is not None:
            self.image_recording_list.export(outfile, level, namespace_, name_='image_recording_list', pretty_print=pretty_print)
        if self.specimen_holder is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<specimen_holder>%s</specimen_holder>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.specimen_holder), input_name='specimen_holder')), eol_))
        if self.tilt_angle_min is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tilt_angle_min>%s</tilt_angle_min>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tilt_angle_min), input_name='tilt_angle_min')), eol_))
        if self.tilt_angle_max is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<tilt_angle_max>%s</tilt_angle_max>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.tilt_angle_max), input_name='tilt_angle_max')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('microscopy_id', node)
        if value is not None and 'microscopy_id' not in already_processed:
            already_processed.add('microscopy_id')
            try:
                self.microscopy_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.microscopy_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'specimen_preparations':
            obj_ = specimen_preparationsType.factory()
            obj_.build(child_)
            self.specimen_preparations = obj_
            obj_.original_tagname_ = 'specimen_preparations'
        elif nodeName_ == 'microscope':
            microscope_ = child_.text
            if microscope_:
                microscope_ = re_.sub(String_cleanup_pat_, " ", microscope_).strip()
            else:
                microscope_ = ""
            microscope_ = self.gds_validate_string(microscope_, node, 'microscope')
            self.microscope = microscope_
            # validate type microscopeType
            self.validate_microscopeType(self.microscope)
        elif nodeName_ == 'illumination_mode':
            illumination_mode_ = child_.text
            if illumination_mode_:
                illumination_mode_ = re_.sub(String_cleanup_pat_, " ", illumination_mode_).strip()
            else:
                illumination_mode_ = ""
            illumination_mode_ = self.gds_validate_string(illumination_mode_, node, 'illumination_mode')
            self.illumination_mode = illumination_mode_
            # validate type illumination_modeType
            self.validate_illumination_modeType(self.illumination_mode)
        elif nodeName_ == 'imaging_mode':
            imaging_mode_ = child_.text
            if imaging_mode_:
                imaging_mode_ = re_.sub(String_cleanup_pat_, " ", imaging_mode_).strip()
            else:
                imaging_mode_ = ""
            imaging_mode_ = self.gds_validate_string(imaging_mode_, node, 'imaging_mode')
            self.imaging_mode = imaging_mode_
            # validate type imaging_modeType
            self.validate_imaging_modeType(self.imaging_mode)
        elif nodeName_ == 'electron_source':
            electron_source_ = child_.text
            if electron_source_:
                electron_source_ = re_.sub(String_cleanup_pat_, " ", electron_source_).strip()
            else:
                electron_source_ = ""
            electron_source_ = self.gds_validate_string(electron_source_, node, 'electron_source')
            self.electron_source = electron_source_
            # validate type electron_sourceType
            self.validate_electron_sourceType(self.electron_source)
        elif nodeName_ == 'acceleration_voltage':
            obj_ = acceleration_voltageType.factory()
            obj_.build(child_)
            self.acceleration_voltage = obj_
            obj_.original_tagname_ = 'acceleration_voltage'
        elif nodeName_ == 'c2_aperture_diameter':
            obj_ = c2_aperture_diameterType.factory()
            obj_.build(child_)
            self.c2_aperture_diameter = obj_
            obj_.original_tagname_ = 'c2_aperture_diameter'
        elif nodeName_ == 'nominal_cs':
            obj_ = nominal_csType.factory()
            obj_.build(child_)
            self.nominal_cs = obj_
            obj_.original_tagname_ = 'nominal_cs'
        elif nodeName_ == 'nominal_defocus_min':
            obj_ = nominal_defocus_minType.factory()
            obj_.build(child_)
            self.nominal_defocus_min = obj_
            obj_.original_tagname_ = 'nominal_defocus_min'
        elif nodeName_ == 'calibrated_defocus_min':
            obj_ = calibrated_defocus_minType.factory()
            obj_.build(child_)
            self.calibrated_defocus_min = obj_
            obj_.original_tagname_ = 'calibrated_defocus_min'
        elif nodeName_ == 'nominal_defocus_max':
            obj_ = nominal_defocus_maxType.factory()
            obj_.build(child_)
            self.nominal_defocus_max = obj_
            obj_.original_tagname_ = 'nominal_defocus_max'
        elif nodeName_ == 'calibrated_defocus_max':
            obj_ = calibrated_defocus_maxType.factory()
            obj_.build(child_)
            self.calibrated_defocus_max = obj_
            obj_.original_tagname_ = 'calibrated_defocus_max'
        elif nodeName_ == 'nominal_magnification':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'nominal_magnification')
            self.nominal_magnification = fval_
            # validate type allowed_magnification
            self.validate_allowed_magnification(self.nominal_magnification)
        elif nodeName_ == 'calibrated_magnification':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'calibrated_magnification')
            self.calibrated_magnification = fval_
            # validate type allowed_magnification
            self.validate_allowed_magnification(self.calibrated_magnification)
        elif nodeName_ == 'specimen_holder_model':
            specimen_holder_model_ = child_.text
            if specimen_holder_model_:
                specimen_holder_model_ = re_.sub(String_cleanup_pat_, " ", specimen_holder_model_).strip()
            else:
                specimen_holder_model_ = ""
            specimen_holder_model_ = self.gds_validate_string(specimen_holder_model_, node, 'specimen_holder_model')
            self.specimen_holder_model = specimen_holder_model_
            # validate type specimen_holder_modelType
            self.validate_specimen_holder_modelType(self.specimen_holder_model)
        elif nodeName_ == 'cooling_holder_cryogen':
            cooling_holder_cryogen_ = child_.text
            if cooling_holder_cryogen_:
                cooling_holder_cryogen_ = re_.sub(String_cleanup_pat_, " ", cooling_holder_cryogen_).strip()
            else:
                cooling_holder_cryogen_ = ""
            cooling_holder_cryogen_ = self.gds_validate_string(cooling_holder_cryogen_, node, 'cooling_holder_cryogen')
            self.cooling_holder_cryogen = cooling_holder_cryogen_
            # validate type cooling_holder_cryogenType
            self.validate_cooling_holder_cryogenType(self.cooling_holder_cryogen)
        elif nodeName_ == 'temperature':
            obj_ = temperatureType.factory()
            obj_.build(child_)
            self.temperature = obj_
            obj_.original_tagname_ = 'temperature'
        elif nodeName_ == 'alignment_procedure':
            obj_ = alignment_procedureType.factory()
            obj_.build(child_)
            self.alignment_procedure = obj_
            obj_.original_tagname_ = 'alignment_procedure'
        elif nodeName_ == 'specialist_optics':
            obj_ = specialist_optics_type.factory()
            obj_.build(child_)
            self.specialist_optics = obj_
            obj_.original_tagname_ = 'specialist_optics'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
        elif nodeName_ == 'image_recording_list':
            obj_ = image_recording_listType.factory()
            obj_.build(child_)
            self.image_recording_list = obj_
            obj_.original_tagname_ = 'image_recording_list'
        elif nodeName_ == 'specimen_holder':
            specimen_holder_ = child_.text
            specimen_holder_ = self.gds_validate_string(specimen_holder_, node, 'specimen_holder')
            self.specimen_holder = specimen_holder_
        elif nodeName_ == 'tilt_angle_min':
            tilt_angle_min_ = child_.text
            tilt_angle_min_ = self.gds_validate_string(tilt_angle_min_, node, 'tilt_angle_min')
            self.tilt_angle_min = tilt_angle_min_
        elif nodeName_ == 'tilt_angle_max':
            tilt_angle_max_ = child_.text
            tilt_angle_max_ = self.gds_validate_string(tilt_angle_max_, node, 'tilt_angle_max')
            self.tilt_angle_max = tilt_angle_max_
# end class base_microscopy_type


class residual_tilt_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, residual_tilt_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if residual_tilt_type.subclass:
            return residual_tilt_type.subclass(*args_, **kwargs_)
        else:
            return residual_tilt_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='residual_tilt_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('residual_tilt_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='residual_tilt_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='residual_tilt_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='residual_tilt_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='residual_tilt_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class residual_tilt_type


class specialist_optics_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, phase_plate=None, sph_aberration_corrector=None, chr_aberration_corrector=None, energy_filter=None, details=None):
        self.original_tagname_ = None
        self.phase_plate = phase_plate
        self.validate_phase_plateType(self.phase_plate)
        self.sph_aberration_corrector = sph_aberration_corrector
        self.chr_aberration_corrector = chr_aberration_corrector
        self.energy_filter = energy_filter
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, specialist_optics_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if specialist_optics_type.subclass:
            return specialist_optics_type.subclass(*args_, **kwargs_)
        else:
            return specialist_optics_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phase_plate(self): return self.phase_plate
    def set_phase_plate(self, phase_plate): self.phase_plate = phase_plate
    def get_sph_aberration_corrector(self): return self.sph_aberration_corrector
    def set_sph_aberration_corrector(self, sph_aberration_corrector): self.sph_aberration_corrector = sph_aberration_corrector
    def get_chr_aberration_corrector(self): return self.chr_aberration_corrector
    def set_chr_aberration_corrector(self, chr_aberration_corrector): self.chr_aberration_corrector = chr_aberration_corrector
    def get_energy_filter(self): return self.energy_filter
    def set_energy_filter(self, energy_filter): self.energy_filter = energy_filter
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_phase_plateType(self, value):
        # Validate type phase_plateType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ZERNIKE PHASE PLATE', 'VOLTA PHASE PLATE', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on phase_plateType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.phase_plate is not None or
            self.sph_aberration_corrector is not None or
            self.chr_aberration_corrector is not None or
            self.energy_filter is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='specialist_optics_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('specialist_optics_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='specialist_optics_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='specialist_optics_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='specialist_optics_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='specialist_optics_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phase_plate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<phase_plate>%s</phase_plate>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.phase_plate), input_name='phase_plate')), eol_))
        if self.sph_aberration_corrector is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<sph_aberration_corrector>%s</sph_aberration_corrector>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.sph_aberration_corrector), input_name='sph_aberration_corrector')), eol_))
        if self.chr_aberration_corrector is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<chr_aberration_corrector>%s</chr_aberration_corrector>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.chr_aberration_corrector), input_name='chr_aberration_corrector')), eol_))
        if self.energy_filter is not None:
            self.energy_filter.export(outfile, level, namespace_, name_='energy_filter', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'phase_plate':
            phase_plate_ = child_.text
            if phase_plate_:
                phase_plate_ = re_.sub(String_cleanup_pat_, " ", phase_plate_).strip()
            else:
                phase_plate_ = ""
            phase_plate_ = self.gds_validate_string(phase_plate_, node, 'phase_plate')
            self.phase_plate = phase_plate_
            # validate type phase_plateType
            self.validate_phase_plateType(self.phase_plate)
        elif nodeName_ == 'sph_aberration_corrector':
            sph_aberration_corrector_ = child_.text
            if sph_aberration_corrector_:
                sph_aberration_corrector_ = re_.sub(String_cleanup_pat_, " ", sph_aberration_corrector_).strip()
            else:
                sph_aberration_corrector_ = ""
            sph_aberration_corrector_ = self.gds_validate_string(sph_aberration_corrector_, node, 'sph_aberration_corrector')
            self.sph_aberration_corrector = sph_aberration_corrector_
        elif nodeName_ == 'chr_aberration_corrector':
            chr_aberration_corrector_ = child_.text
            if chr_aberration_corrector_:
                chr_aberration_corrector_ = re_.sub(String_cleanup_pat_, " ", chr_aberration_corrector_).strip()
            else:
                chr_aberration_corrector_ = ""
            chr_aberration_corrector_ = self.gds_validate_string(chr_aberration_corrector_, node, 'chr_aberration_corrector')
            self.chr_aberration_corrector = chr_aberration_corrector_
        elif nodeName_ == 'energy_filter':
            obj_ = energy_filterType.factory()
            obj_.build(child_)
            self.energy_filter = obj_
            obj_.original_tagname_ = 'energy_filter'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class specialist_optics_type


class software_list_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, software=None):
        self.original_tagname_ = None
        if software is None:
            self.software = []
        else:
            self.software = software
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, software_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if software_list_type.subclass:
            return software_list_type.subclass(*args_, **kwargs_)
        else:
            return software_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_software(self): return self.software
    def set_software(self, software): self.software = software
    def add_software(self, value): self.software.append(value)
    def insert_software_at(self, index, value): self.software.insert(index, value)
    def replace_software_at(self, index, value): self.software[index] = value
    def hasContent_(self):
        if (
            self.software
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='software_list_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('software_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='software_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='software_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='software_list_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='software_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for software_ in self.software:
            software_.export(outfile, level, namespace_, name_='software', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'software':
            obj_ = software_type.factory()
            obj_.build(child_)
            self.software.append(obj_)
            obj_.original_tagname_ = 'software'
# end class software_list_type


class software_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, version=None, processing_details=None):
        self.original_tagname_ = None
        self.name = name
        self.version = version
        self.processing_details = processing_details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, software_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if software_type.subclass:
            return software_type.subclass(*args_, **kwargs_)
        else:
            return software_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_processing_details(self): return self.processing_details
    def set_processing_details(self, processing_details): self.processing_details = processing_details
    def hasContent_(self):
        if (
            self.name is not None or
            self.version is not None or
            self.processing_details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='software_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('software_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='software_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='software_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='software_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='software_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<name>%s</name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<version>%s</version>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), eol_))
        if self.processing_details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<processing_details>%s</processing_details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.processing_details), input_name='processing_details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            if name_:
                name_ = re_.sub(String_cleanup_pat_, " ", name_).strip()
            else:
                name_ = ""
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'version':
            version_ = child_.text
            if version_:
                version_ = re_.sub(String_cleanup_pat_, " ", version_).strip()
            else:
                version_ = ""
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'processing_details':
            processing_details_ = child_.text
            processing_details_ = self.gds_validate_string(processing_details_, node, 'processing_details')
            self.processing_details = processing_details_
# end class software_type


class crystallography_microscopy_type(base_microscopy_type):
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, camera_length=None, tilt_list=None, tilt_series=None):
        self.original_tagname_ = None
        super(crystallography_microscopy_type, self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max, )
        self.camera_length = camera_length
        self.tilt_list = tilt_list
        if tilt_series is None:
            self.tilt_series = []
        else:
            self.tilt_series = tilt_series
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_microscopy_type.subclass:
            return crystallography_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_camera_length(self): return self.camera_length
    def set_camera_length(self, camera_length): self.camera_length = camera_length
    def get_tilt_list(self): return self.tilt_list
    def set_tilt_list(self, tilt_list): self.tilt_list = tilt_list
    def get_tilt_series(self): return self.tilt_series
    def set_tilt_series(self, tilt_series): self.tilt_series = tilt_series
    def add_tilt_series(self, value): self.tilt_series.append(value)
    def insert_tilt_series_at(self, index, value): self.tilt_series.insert(index, value)
    def replace_tilt_series_at(self, index, value): self.tilt_series[index] = value
    def hasContent_(self):
        if (
            self.camera_length is not None or
            self.tilt_list is not None or
            self.tilt_series or
            super(crystallography_microscopy_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystallography_microscopy_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_microscopy_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystallography_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystallography_microscopy_type'):
        super(crystallography_microscopy_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_microscopy_type')
    def exportChildren(self, outfile, level, namespace_='', name_='crystallography_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_microscopy_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.camera_length is not None:
            self.camera_length.export(outfile, level, namespace_, name_='camera_length', pretty_print=pretty_print)
        if self.tilt_list is not None:
            self.tilt_list.export(outfile, level, namespace_, name_='tilt_list', pretty_print=pretty_print)
        for tilt_series_ in self.tilt_series:
            tilt_series_.export(outfile, level, namespace_, name_='tilt_series', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(crystallography_microscopy_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'camera_length':
            obj_ = camera_lengthType.factory()
            obj_.build(child_)
            self.camera_length = obj_
            obj_.original_tagname_ = 'camera_length'
        elif nodeName_ == 'tilt_list':
            obj_ = tilt_listType.factory()
            obj_.build(child_)
            self.tilt_list = obj_
            obj_.original_tagname_ = 'tilt_list'
        elif nodeName_ == 'tilt_series':
            obj_ = tilt_series_type.factory()
            obj_.build(child_)
            self.tilt_series.append(obj_)
            obj_.original_tagname_ = 'tilt_series'
        super(crystallography_microscopy_type, self).buildChildren(child_, node, nodeName_, True)
# end class crystallography_microscopy_type


class tilt_series_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, axis1=None, axis2=None, axis_rotation=None):
        self.original_tagname_ = None
        self.axis1 = axis1
        self.axis2 = axis2
        self.axis_rotation = axis_rotation
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tilt_series_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tilt_series_type.subclass:
            return tilt_series_type.subclass(*args_, **kwargs_)
        else:
            return tilt_series_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_axis1(self): return self.axis1
    def set_axis1(self, axis1): self.axis1 = axis1
    def get_axis2(self): return self.axis2
    def set_axis2(self, axis2): self.axis2 = axis2
    def get_axis_rotation(self): return self.axis_rotation
    def set_axis_rotation(self, axis_rotation): self.axis_rotation = axis_rotation
    def hasContent_(self):
        if (
            self.axis1 is not None or
            self.axis2 is not None or
            self.axis_rotation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tilt_series_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tilt_series_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tilt_series_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tilt_series_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tilt_series_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='tilt_series_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.axis1 is not None:
            self.axis1.export(outfile, level, namespace_, name_='axis1', pretty_print=pretty_print)
        if self.axis2 is not None:
            self.axis2.export(outfile, level, namespace_, name_='axis2', pretty_print=pretty_print)
        if self.axis_rotation is not None:
            self.axis_rotation.export(outfile, level, namespace_, name_='axis_rotation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'axis1':
            class_obj_ = self.get_class_obj_(child_, axis_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.axis1 = obj_
            obj_.original_tagname_ = 'axis1'
        elif nodeName_ == 'axis2':
            obj_ = axis2Type.factory()
            obj_.build(child_)
            self.axis2 = obj_
            obj_.original_tagname_ = 'axis2'
        elif nodeName_ == 'axis_rotation':
            obj_ = axis_rotationType.factory()
            obj_.build(child_)
            self.axis_rotation = obj_
            obj_.original_tagname_ = 'axis_rotation'
# end class tilt_series_type


class axis_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, min_angle=None, max_angle=None, angle_increment=None, extensiontype_=None):
        self.original_tagname_ = None
        self.min_angle = min_angle
        self.max_angle = max_angle
        self.angle_increment = angle_increment
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, axis_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if axis_type.subclass:
            return axis_type.subclass(*args_, **kwargs_)
        else:
            return axis_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_min_angle(self): return self.min_angle
    def set_min_angle(self, min_angle): self.min_angle = min_angle
    def get_max_angle(self): return self.max_angle
    def set_max_angle(self, max_angle): self.max_angle = max_angle
    def get_angle_increment(self): return self.angle_increment
    def set_angle_increment(self, angle_increment): self.angle_increment = angle_increment
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.min_angle is not None or
            self.max_angle is not None or
            self.angle_increment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='axis_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('axis_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='axis_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='axis_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='axis_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='axis_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.min_angle is not None:
            self.min_angle.export(outfile, level, namespace_, name_='min_angle', pretty_print=pretty_print)
        if self.max_angle is not None:
            self.max_angle.export(outfile, level, namespace_, name_='max_angle', pretty_print=pretty_print)
        if self.angle_increment is not None:
            self.angle_increment.export(outfile, level, namespace_, name_='angle_increment', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'min_angle':
            obj_ = min_angleType.factory()
            obj_.build(child_)
            self.min_angle = obj_
            obj_.original_tagname_ = 'min_angle'
        elif nodeName_ == 'max_angle':
            obj_ = max_angleType.factory()
            obj_.build(child_)
            self.max_angle = obj_
            obj_.original_tagname_ = 'max_angle'
        elif nodeName_ == 'angle_increment':
            obj_ = angle_incrementType.factory()
            obj_.build(child_)
            self.angle_increment = obj_
            obj_.original_tagname_ = 'angle_increment'
# end class axis_type


class helical_microscopy_type(base_microscopy_type):
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None):
        self.original_tagname_ = None
        super(helical_microscopy_type, self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_microscopy_type.subclass:
            return helical_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return helical_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(helical_microscopy_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='helical_microscopy_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='helical_microscopy_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='helical_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='helical_microscopy_type'):
        super(helical_microscopy_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='helical_microscopy_type')
    def exportChildren(self, outfile, level, namespace_='', name_='helical_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(helical_microscopy_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(helical_microscopy_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(helical_microscopy_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class helical_microscopy_type


class single_particle_microscopy_type(base_microscopy_type):
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None):
        self.original_tagname_ = None
        super(single_particle_microscopy_type, self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, single_particle_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if single_particle_microscopy_type.subclass:
            return single_particle_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return single_particle_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(single_particle_microscopy_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='single_particle_microscopy_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('single_particle_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='single_particle_microscopy_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='single_particle_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='single_particle_microscopy_type'):
        super(single_particle_microscopy_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='single_particle_microscopy_type')
    def exportChildren(self, outfile, level, namespace_='', name_='single_particle_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(single_particle_microscopy_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(single_particle_microscopy_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(single_particle_microscopy_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class single_particle_microscopy_type


class tomography_microscopy_type(base_microscopy_type):
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, tilt_series=None):
        self.original_tagname_ = None
        super(tomography_microscopy_type, self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max, )
        if tilt_series is None:
            self.tilt_series = []
        else:
            self.tilt_series = tilt_series
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tomography_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tomography_microscopy_type.subclass:
            return tomography_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return tomography_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tilt_series(self): return self.tilt_series
    def set_tilt_series(self, tilt_series): self.tilt_series = tilt_series
    def add_tilt_series(self, value): self.tilt_series.append(value)
    def insert_tilt_series_at(self, index, value): self.tilt_series.insert(index, value)
    def replace_tilt_series_at(self, index, value): self.tilt_series[index] = value
    def hasContent_(self):
        if (
            self.tilt_series or
            super(tomography_microscopy_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tomography_microscopy_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tomography_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tomography_microscopy_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tomography_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tomography_microscopy_type'):
        super(tomography_microscopy_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='tomography_microscopy_type')
    def exportChildren(self, outfile, level, namespace_='', name_='tomography_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(tomography_microscopy_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for tilt_series_ in self.tilt_series:
            tilt_series_.export(outfile, level, namespace_, name_='tilt_series', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(tomography_microscopy_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tilt_series':
            obj_ = tilt_series_type.factory()
            obj_.build(child_)
            self.tilt_series.append(obj_)
            obj_.original_tagname_ = 'tilt_series'
        super(tomography_microscopy_type, self).buildChildren(child_, node, nodeName_, True)
# end class tomography_microscopy_type


class base_image_processing_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, extensiontype_=None):
        self.original_tagname_ = None
        self.image_processing_id = _cast(int, image_processing_id)
        self.image_recording_id = image_recording_id
        self.details = details
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_image_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_image_processing_type.subclass:
            return base_image_processing_type.subclass(*args_, **kwargs_)
        else:
            return base_image_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_image_recording_id(self): return self.image_recording_id
    def set_image_recording_id(self, image_recording_id): self.image_recording_id = image_recording_id
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_image_processing_id(self): return self.image_processing_id
    def set_image_processing_id(self, image_processing_id): self.image_processing_id = image_processing_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.image_recording_id is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_image_processing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_image_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_image_processing_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_image_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_image_processing_type'):
        if self.image_processing_id is not None and 'image_processing_id' not in already_processed:
            already_processed.add('image_processing_id')
            outfile.write(' image_processing_id="%s"' % self.gds_format_integer(self.image_processing_id, input_name='image_processing_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='base_image_processing_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.image_recording_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<image_recording_id>%s</image_recording_id>%s' % (self.gds_format_integer(self.image_recording_id, input_name='image_recording_id'), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('image_processing_id', node)
        if value is not None and 'image_processing_id' not in already_processed:
            already_processed.add('image_processing_id')
            try:
                self.image_processing_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.image_processing_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'image_recording_id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'image_recording_id')
            self.image_recording_id = ival_
        elif nodeName_ == 'details':
            details_ = child_.text
            if details_:
                details_ = re_.sub(String_cleanup_pat_, " ", details_).strip()
            else:
                details_ = ""
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class base_image_processing_type


class crystallography_processing_type(base_image_processing_type):
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, final_reconstruction=None, crystal_parameters=None, startup_model=None, ctf_correction=None, molecular_replacement=None, lattice_distortion_correction_software_list=None, symmetry_determination_software_list=None, merging_software_list=None, crystallography_statistics=None):
        self.original_tagname_ = None
        super(crystallography_processing_type, self).__init__(image_processing_id, image_recording_id, details, )
        self.final_reconstruction = final_reconstruction
        self.crystal_parameters = crystal_parameters
        if startup_model is None:
            self.startup_model = []
        else:
            self.startup_model = startup_model
        self.ctf_correction = ctf_correction
        self.molecular_replacement = molecular_replacement
        self.lattice_distortion_correction_software_list = lattice_distortion_correction_software_list
        self.symmetry_determination_software_list = symmetry_determination_software_list
        self.merging_software_list = merging_software_list
        self.crystallography_statistics = crystallography_statistics
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_processing_type.subclass:
            return crystallography_processing_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_final_reconstruction(self): return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction): self.final_reconstruction = final_reconstruction
    def get_crystal_parameters(self): return self.crystal_parameters
    def set_crystal_parameters(self, crystal_parameters): self.crystal_parameters = crystal_parameters
    def get_startup_model(self): return self.startup_model
    def set_startup_model(self, startup_model): self.startup_model = startup_model
    def add_startup_model(self, value): self.startup_model.append(value)
    def insert_startup_model_at(self, index, value): self.startup_model.insert(index, value)
    def replace_startup_model_at(self, index, value): self.startup_model[index] = value
    def get_ctf_correction(self): return self.ctf_correction
    def set_ctf_correction(self, ctf_correction): self.ctf_correction = ctf_correction
    def get_molecular_replacement(self): return self.molecular_replacement
    def set_molecular_replacement(self, molecular_replacement): self.molecular_replacement = molecular_replacement
    def get_lattice_distortion_correction_software_list(self): return self.lattice_distortion_correction_software_list
    def set_lattice_distortion_correction_software_list(self, lattice_distortion_correction_software_list): self.lattice_distortion_correction_software_list = lattice_distortion_correction_software_list
    def get_symmetry_determination_software_list(self): return self.symmetry_determination_software_list
    def set_symmetry_determination_software_list(self, symmetry_determination_software_list): self.symmetry_determination_software_list = symmetry_determination_software_list
    def get_merging_software_list(self): return self.merging_software_list
    def set_merging_software_list(self, merging_software_list): self.merging_software_list = merging_software_list
    def get_crystallography_statistics(self): return self.crystallography_statistics
    def set_crystallography_statistics(self, crystallography_statistics): self.crystallography_statistics = crystallography_statistics
    def hasContent_(self):
        if (
            self.final_reconstruction is not None or
            self.crystal_parameters is not None or
            self.startup_model or
            self.ctf_correction is not None or
            self.molecular_replacement is not None or
            self.lattice_distortion_correction_software_list is not None or
            self.symmetry_determination_software_list is not None or
            self.merging_software_list is not None or
            self.crystallography_statistics is not None or
            super(crystallography_processing_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystallography_processing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_processing_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystallography_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystallography_processing_type'):
        super(crystallography_processing_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_processing_type')
    def exportChildren(self, outfile, level, namespace_='', name_='crystallography_processing_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_processing_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.final_reconstruction is not None:
            self.final_reconstruction.export(outfile, level, namespace_, name_='final_reconstruction', pretty_print=pretty_print)
        if self.crystal_parameters is not None:
            self.crystal_parameters.export(outfile, level, namespace_, name_='crystal_parameters', pretty_print=pretty_print)
        for startup_model_ in self.startup_model:
            startup_model_.export(outfile, level, namespace_, name_='startup_model', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            self.ctf_correction.export(outfile, level, namespace_, name_='ctf_correction', pretty_print=pretty_print)
        if self.molecular_replacement is not None:
            self.molecular_replacement.export(outfile, level, namespace_, name_='molecular_replacement', pretty_print=pretty_print)
        if self.lattice_distortion_correction_software_list is not None:
            self.lattice_distortion_correction_software_list.export(outfile, level, namespace_, name_='lattice_distortion_correction_software_list', pretty_print=pretty_print)
        if self.symmetry_determination_software_list is not None:
            self.symmetry_determination_software_list.export(outfile, level, namespace_, name_='symmetry_determination_software_list', pretty_print=pretty_print)
        if self.merging_software_list is not None:
            self.merging_software_list.export(outfile, level, namespace_, name_='merging_software_list', pretty_print=pretty_print)
        if self.crystallography_statistics is not None:
            self.crystallography_statistics.export(outfile, level, namespace_, name_='crystallography_statistics', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(crystallography_processing_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'final_reconstruction':
            obj_ = non_subtom_final_reconstruction_type.factory()
            obj_.build(child_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'crystal_parameters':
            obj_ = crystal_parameters_type.factory()
            obj_.build(child_)
            self.crystal_parameters = obj_
            obj_.original_tagname_ = 'crystal_parameters'
        elif nodeName_ == 'startup_model':
            obj_ = starting_map_type.factory()
            obj_.build(child_)
            self.startup_model.append(obj_)
            obj_.original_tagname_ = 'startup_model'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory()
            obj_.build(child_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'molecular_replacement':
            obj_ = molecular_replacement_type.factory()
            obj_.build(child_)
            self.molecular_replacement = obj_
            obj_.original_tagname_ = 'molecular_replacement'
        elif nodeName_ == 'lattice_distortion_correction_software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.lattice_distortion_correction_software_list = obj_
            obj_.original_tagname_ = 'lattice_distortion_correction_software_list'
        elif nodeName_ == 'symmetry_determination_software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.symmetry_determination_software_list = obj_
            obj_.original_tagname_ = 'symmetry_determination_software_list'
        elif nodeName_ == 'merging_software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.merging_software_list = obj_
            obj_.original_tagname_ = 'merging_software_list'
        elif nodeName_ == 'crystallography_statistics':
            obj_ = crystallography_statistics_type.factory()
            obj_.build(child_)
            self.crystallography_statistics = obj_
            obj_.original_tagname_ = 'crystallography_statistics'
        super(crystallography_processing_type, self).buildChildren(child_, node, nodeName_, True)
# end class crystallography_processing_type


class applied_symmetry_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, space_group=None, point_group=None, helical_parameters=None):
        self.original_tagname_ = None
        self.space_group = space_group
        self.point_group = point_group
        self.validate_point_groupType(self.point_group)
        self.helical_parameters = helical_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, applied_symmetry_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if applied_symmetry_type.subclass:
            return applied_symmetry_type.subclass(*args_, **kwargs_)
        else:
            return applied_symmetry_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_space_group(self): return self.space_group
    def set_space_group(self, space_group): self.space_group = space_group
    def get_point_group(self): return self.point_group
    def set_point_group(self, point_group): self.point_group = point_group
    def get_helical_parameters(self): return self.helical_parameters
    def set_helical_parameters(self, helical_parameters): self.helical_parameters = helical_parameters
    def validate_point_groupType(self, value):
        # Validate type point_groupType, a restriction on point_group_symmetry_type.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_point_groupType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_point_groupType_patterns_, ))
    validate_point_groupType_patterns_ = [['C\\d+|D\\d+|O|T|I'], ['C\\d+|D\\d+|O|T|I']]
    def hasContent_(self):
        if (
            self.space_group is not None or
            self.point_group is not None or
            self.helical_parameters is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='applied_symmetry_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('applied_symmetry_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='applied_symmetry_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='applied_symmetry_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='applied_symmetry_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='applied_symmetry_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.space_group is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<space_group>%s</space_group>%s' % (self.gds_format_integer(self.space_group, input_name='space_group'), eol_))
        if self.point_group is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<point_group>%s</point_group>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.point_group), input_name='point_group')), eol_))
        if self.helical_parameters is not None:
            self.helical_parameters.export(outfile, level, namespace_, name_='helical_parameters', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'space_group':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'space_group')
            self.space_group = ival_
        elif nodeName_ == 'point_group':
            point_group_ = child_.text
            if point_group_:
                point_group_ = re_.sub(String_cleanup_pat_, " ", point_group_).strip()
            else:
                point_group_ = ""
            point_group_ = self.gds_validate_string(point_group_, node, 'point_group')
            self.point_group = point_group_
            # validate type point_groupType
            self.validate_point_groupType(self.point_group)
        elif nodeName_ == 'helical_parameters':
            obj_ = helical_parameters_type.factory()
            obj_.build(child_)
            self.helical_parameters = obj_
            obj_.original_tagname_ = 'helical_parameters'
# end class applied_symmetry_type


class helical_parameters_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, delta_z=None, delta_phi=None, axial_symmetry=None):
        self.original_tagname_ = None
        self.delta_z = delta_z
        self.delta_phi = delta_phi
        self.axial_symmetry = axial_symmetry
        self.validate_axial_symmetryType(self.axial_symmetry)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_parameters_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_parameters_type.subclass:
            return helical_parameters_type.subclass(*args_, **kwargs_)
        else:
            return helical_parameters_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_delta_z(self): return self.delta_z
    def set_delta_z(self, delta_z): self.delta_z = delta_z
    def get_delta_phi(self): return self.delta_phi
    def set_delta_phi(self, delta_phi): self.delta_phi = delta_phi
    def get_axial_symmetry(self): return self.axial_symmetry
    def set_axial_symmetry(self, axial_symmetry): self.axial_symmetry = axial_symmetry
    def validate_axial_symmetryType(self, value):
        # Validate type axial_symmetryType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_axial_symmetryType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_axial_symmetryType_patterns_, ))
    validate_axial_symmetryType_patterns_ = [['[C|D][1-9][0-9]*']]
    def hasContent_(self):
        if (
            self.delta_z is not None or
            self.delta_phi is not None or
            self.axial_symmetry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='helical_parameters_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_parameters_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='helical_parameters_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='helical_parameters_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='helical_parameters_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='helical_parameters_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.delta_z is not None:
            self.delta_z.export(outfile, level, namespace_, name_='delta_z', pretty_print=pretty_print)
        if self.delta_phi is not None:
            self.delta_phi.export(outfile, level, namespace_, name_='delta_phi', pretty_print=pretty_print)
        if self.axial_symmetry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<axial_symmetry>%s</axial_symmetry>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.axial_symmetry), input_name='axial_symmetry')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'delta_z':
            obj_ = delta_zType.factory()
            obj_.build(child_)
            self.delta_z = obj_
            obj_.original_tagname_ = 'delta_z'
        elif nodeName_ == 'delta_phi':
            obj_ = delta_phiType.factory()
            obj_.build(child_)
            self.delta_phi = obj_
            obj_.original_tagname_ = 'delta_phi'
        elif nodeName_ == 'axial_symmetry':
            axial_symmetry_ = child_.text
            if axial_symmetry_:
                axial_symmetry_ = re_.sub(String_cleanup_pat_, " ", axial_symmetry_).strip()
            else:
                axial_symmetry_ = ""
            axial_symmetry_ = self.gds_validate_string(axial_symmetry_, node, 'axial_symmetry')
            self.axial_symmetry = axial_symmetry_
            # validate type axial_symmetryType
            self.validate_axial_symmetryType(self.axial_symmetry)
# end class helical_parameters_type


class reconstruction_filtering_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, background_masked=None, spatial_filtering=None, sharpening=None, b_factorSharpening=None, other=None):
        self.original_tagname_ = None
        self.background_masked = background_masked
        self.spatial_filtering = spatial_filtering
        self.sharpening = sharpening
        self.b_factorSharpening = b_factorSharpening
        self.other = other
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, reconstruction_filtering_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if reconstruction_filtering_type.subclass:
            return reconstruction_filtering_type.subclass(*args_, **kwargs_)
        else:
            return reconstruction_filtering_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_background_masked(self): return self.background_masked
    def set_background_masked(self, background_masked): self.background_masked = background_masked
    def get_spatial_filtering(self): return self.spatial_filtering
    def set_spatial_filtering(self, spatial_filtering): self.spatial_filtering = spatial_filtering
    def get_sharpening(self): return self.sharpening
    def set_sharpening(self, sharpening): self.sharpening = sharpening
    def get_b_factorSharpening(self): return self.b_factorSharpening
    def set_b_factorSharpening(self, b_factorSharpening): self.b_factorSharpening = b_factorSharpening
    def get_other(self): return self.other
    def set_other(self, other): self.other = other
    def hasContent_(self):
        if (
            self.background_masked is not None or
            self.spatial_filtering is not None or
            self.sharpening is not None or
            self.b_factorSharpening is not None or
            self.other is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='reconstruction_filtering_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('reconstruction_filtering_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='reconstruction_filtering_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='reconstruction_filtering_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='reconstruction_filtering_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='reconstruction_filtering_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.background_masked is not None:
            self.background_masked.export(outfile, level, namespace_, name_='background_masked', pretty_print=pretty_print)
        if self.spatial_filtering is not None:
            self.spatial_filtering.export(outfile, level, namespace_, name_='spatial_filtering', pretty_print=pretty_print)
        if self.sharpening is not None:
            self.sharpening.export(outfile, level, namespace_, name_='sharpening', pretty_print=pretty_print)
        if self.b_factorSharpening is not None:
            self.b_factorSharpening.export(outfile, level, namespace_, name_='b-factorSharpening', pretty_print=pretty_print)
        if self.other is not None:
            self.other.export(outfile, level, namespace_, name_='other', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'background_masked':
            obj_ = background_masked_type.factory()
            obj_.build(child_)
            self.background_masked = obj_
            obj_.original_tagname_ = 'background_masked'
        elif nodeName_ == 'spatial_filtering':
            obj_ = spatial_filteringType.factory()
            obj_.build(child_)
            self.spatial_filtering = obj_
            obj_.original_tagname_ = 'spatial_filtering'
        elif nodeName_ == 'sharpening':
            obj_ = sharpeningType.factory()
            obj_.build(child_)
            self.sharpening = obj_
            obj_.original_tagname_ = 'sharpening'
        elif nodeName_ == 'b-factorSharpening':
            obj_ = b_factorSharpeningType.factory()
            obj_.build(child_)
            self.b_factorSharpening = obj_
            obj_.original_tagname_ = 'b-factorSharpening'
        elif nodeName_ == 'other':
            obj_ = otherType30.factory()
            obj_.build(child_)
            self.other = obj_
            obj_.original_tagname_ = 'other'
# end class reconstruction_filtering_type


class background_masked_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, geometrical_shape=None, dimensions=None, software_list=None, details=None):
        self.original_tagname_ = None
        self.geometrical_shape = geometrical_shape
        self.validate_geometrical_shapeType(self.geometrical_shape)
        self.dimensions = dimensions
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, background_masked_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if background_masked_type.subclass:
            return background_masked_type.subclass(*args_, **kwargs_)
        else:
            return background_masked_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_geometrical_shape(self): return self.geometrical_shape
    def set_geometrical_shape(self, geometrical_shape): self.geometrical_shape = geometrical_shape
    def get_dimensions(self): return self.dimensions
    def set_dimensions(self, dimensions): self.dimensions = dimensions
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_geometrical_shapeType(self, value):
        # Validate type geometrical_shapeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SPHERE', 'SOFT SPHERE', 'GAUSSIAN', 'CIRCLE', 'RECTANGLE', 'CYLINDER', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on geometrical_shapeType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.geometrical_shape is not None or
            self.dimensions is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='background_masked_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('background_masked_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='background_masked_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='background_masked_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='background_masked_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='background_masked_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.geometrical_shape is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<geometrical_shape>%s</geometrical_shape>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.geometrical_shape), input_name='geometrical_shape')), eol_))
        if self.dimensions is not None:
            self.dimensions.export(outfile, level, namespace_, name_='dimensions', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'geometrical_shape':
            geometrical_shape_ = child_.text
            if geometrical_shape_:
                geometrical_shape_ = re_.sub(String_cleanup_pat_, " ", geometrical_shape_).strip()
            else:
                geometrical_shape_ = ""
            geometrical_shape_ = self.gds_validate_string(geometrical_shape_, node, 'geometrical_shape')
            self.geometrical_shape = geometrical_shape_
            # validate type geometrical_shapeType
            self.validate_geometrical_shapeType(self.geometrical_shape)
        elif nodeName_ == 'dimensions':
            obj_ = dimensionsType31.factory()
            obj_.build(child_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class background_masked_type


class crystal_parameters_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, unit_cell=None, plane_group=None, space_group=None):
        self.original_tagname_ = None
        self.unit_cell = unit_cell
        self.plane_group = plane_group
        self.validate_plane_groupType(self.plane_group)
        self.space_group = space_group
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystal_parameters_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystal_parameters_type.subclass:
            return crystal_parameters_type.subclass(*args_, **kwargs_)
        else:
            return crystal_parameters_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_unit_cell(self): return self.unit_cell
    def set_unit_cell(self, unit_cell): self.unit_cell = unit_cell
    def get_plane_group(self): return self.plane_group
    def set_plane_group(self, plane_group): self.plane_group = plane_group
    def get_space_group(self): return self.space_group
    def set_space_group(self, space_group): self.space_group = space_group
    def validate_plane_groupType(self, value):
        # Validate type plane_groupType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['C 1 2', 'C 2 2 2', 'P 1', 'P 1 2', 'P 1 21', 'P 2', 'P 2 2 2', 'P 2 2 21', 'P 2 21 21', 'P 3', 'P 3 1 2', 'P 3 2 1', 'P 4', 'P 4 2 2', 'P 4 21 2', 'P 6', 'P 6 2 2']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on plane_groupType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.unit_cell is not None or
            self.plane_group is not None or
            self.space_group is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystal_parameters_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystal_parameters_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystal_parameters_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystal_parameters_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystal_parameters_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='crystal_parameters_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.unit_cell is not None:
            self.unit_cell.export(outfile, level, namespace_, name_='unit_cell', pretty_print=pretty_print)
        if self.plane_group is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<plane_group>%s</plane_group>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.plane_group), input_name='plane_group')), eol_))
        if self.space_group is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<space_group>%s</space_group>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.space_group), input_name='space_group')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'unit_cell':
            obj_ = unit_cell_type.factory()
            obj_.build(child_)
            self.unit_cell = obj_
            obj_.original_tagname_ = 'unit_cell'
        elif nodeName_ == 'plane_group':
            plane_group_ = child_.text
            if plane_group_:
                plane_group_ = re_.sub(String_cleanup_pat_, " ", plane_group_).strip()
            else:
                plane_group_ = ""
            plane_group_ = self.gds_validate_string(plane_group_, node, 'plane_group')
            self.plane_group = plane_group_
            # validate type plane_groupType
            self.validate_plane_groupType(self.plane_group)
        elif nodeName_ == 'space_group':
            space_group_ = child_.text
            if space_group_:
                space_group_ = re_.sub(String_cleanup_pat_, " ", space_group_).strip()
            else:
                space_group_ = ""
            space_group_ = self.gds_validate_string(space_group_, node, 'space_group')
            self.space_group = space_group_
# end class crystal_parameters_type


class unit_cell_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, a=None, b=None, c=None, c_sampling_length=None, gamma=None, alpha=None, beta=None):
        self.original_tagname_ = None
        self.a = a
        self.b = b
        self.c = c
        self.c_sampling_length = c_sampling_length
        self.gamma = gamma
        self.alpha = alpha
        self.beta = beta
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, unit_cell_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if unit_cell_type.subclass:
            return unit_cell_type.subclass(*args_, **kwargs_)
        else:
            return unit_cell_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_a(self): return self.a
    def set_a(self, a): self.a = a
    def get_b(self): return self.b
    def set_b(self, b): self.b = b
    def get_c(self): return self.c
    def set_c(self, c): self.c = c
    def get_c_sampling_length(self): return self.c_sampling_length
    def set_c_sampling_length(self, c_sampling_length): self.c_sampling_length = c_sampling_length
    def get_gamma(self): return self.gamma
    def set_gamma(self, gamma): self.gamma = gamma
    def get_alpha(self): return self.alpha
    def set_alpha(self, alpha): self.alpha = alpha
    def get_beta(self): return self.beta
    def set_beta(self, beta): self.beta = beta
    def hasContent_(self):
        if (
            self.a is not None or
            self.b is not None or
            self.c is not None or
            self.c_sampling_length is not None or
            self.gamma is not None or
            self.alpha is not None or
            self.beta is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='unit_cell_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('unit_cell_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='unit_cell_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='unit_cell_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='unit_cell_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='unit_cell_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.a is not None:
            self.a.export(outfile, level, namespace_, name_='a', pretty_print=pretty_print)
        if self.b is not None:
            self.b.export(outfile, level, namespace_, name_='b', pretty_print=pretty_print)
        if self.c is not None:
            self.c.export(outfile, level, namespace_, name_='c', pretty_print=pretty_print)
        if self.c_sampling_length is not None:
            self.c_sampling_length.export(outfile, level, namespace_, name_='c_sampling_length', pretty_print=pretty_print)
        if self.gamma is not None:
            self.gamma.export(outfile, level, namespace_, name_='gamma', pretty_print=pretty_print)
        if self.alpha is not None:
            self.alpha.export(outfile, level, namespace_, name_='alpha', pretty_print=pretty_print)
        if self.beta is not None:
            self.beta.export(outfile, level, namespace_, name_='beta', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'a':
            obj_ = cell_type.factory()
            obj_.build(child_)
            self.a = obj_
            obj_.original_tagname_ = 'a'
        elif nodeName_ == 'b':
            obj_ = cell_type.factory()
            obj_.build(child_)
            self.b = obj_
            obj_.original_tagname_ = 'b'
        elif nodeName_ == 'c':
            obj_ = cell_type.factory()
            obj_.build(child_)
            self.c = obj_
            obj_.original_tagname_ = 'c'
        elif nodeName_ == 'c_sampling_length':
            obj_ = cell_type.factory()
            obj_.build(child_)
            self.c_sampling_length = obj_
            obj_.original_tagname_ = 'c_sampling_length'
        elif nodeName_ == 'gamma':
            obj_ = cell_angle_type.factory()
            obj_.build(child_)
            self.gamma = obj_
            obj_.original_tagname_ = 'gamma'
        elif nodeName_ == 'alpha':
            obj_ = cell_angle_type.factory()
            obj_.build(child_)
            self.alpha = obj_
            obj_.original_tagname_ = 'alpha'
        elif nodeName_ == 'beta':
            obj_ = cell_angle_type.factory()
            obj_.build(child_)
            self.beta = obj_
            obj_.original_tagname_ = 'beta'
# end class unit_cell_type


class cell_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cell_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cell_type.subclass:
            return cell_type.subclass(*args_, **kwargs_)
        else:
            return cell_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cell_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cell_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cell_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cell_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cell_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='cell_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cell_type


class cell_angle_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cell_angle_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cell_angle_type.subclass:
            return cell_angle_type.subclass(*args_, **kwargs_)
        else:
            return cell_angle_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cell_angle_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cell_angle_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cell_angle_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cell_angle_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cell_angle_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='cell_angle_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cell_angle_type


class starting_map_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_of_model=None, random_conical_tilt=None, orthogonal_tilt=None, emdb_id=None, pdb_model=None, insilico_model=None, other=None, details=None):
        self.original_tagname_ = None
        self.type_of_model = _cast(None, type_of_model)
        self.random_conical_tilt = random_conical_tilt
        self.orthogonal_tilt = orthogonal_tilt
        self.emdb_id = emdb_id
        self.validate_emdb_id_type(self.emdb_id)
        self.pdb_model = pdb_model
        self.insilico_model = insilico_model
        self.other = other
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, starting_map_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if starting_map_type.subclass:
            return starting_map_type.subclass(*args_, **kwargs_)
        else:
            return starting_map_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_random_conical_tilt(self): return self.random_conical_tilt
    def set_random_conical_tilt(self, random_conical_tilt): self.random_conical_tilt = random_conical_tilt
    def get_orthogonal_tilt(self): return self.orthogonal_tilt
    def set_orthogonal_tilt(self, orthogonal_tilt): self.orthogonal_tilt = orthogonal_tilt
    def get_emdb_id(self): return self.emdb_id
    def set_emdb_id(self, emdb_id): self.emdb_id = emdb_id
    def get_pdb_model(self): return self.pdb_model
    def set_pdb_model(self, pdb_model): self.pdb_model = pdb_model
    def get_insilico_model(self): return self.insilico_model
    def set_insilico_model(self, insilico_model): self.insilico_model = insilico_model
    def get_other(self): return self.other
    def set_other(self, other): self.other = other
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_type_of_model(self): return self.type_of_model
    def set_type_of_model(self, type_of_model): self.type_of_model = type_of_model
    def validate_emdb_id_type(self, value):
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdb_id_type_patterns_, ))
    validate_emdb_id_type_patterns_ = [['EMD-\\d{4,}']]
    def hasContent_(self):
        if (
            self.random_conical_tilt is not None or
            self.orthogonal_tilt is not None or
            self.emdb_id is not None or
            self.pdb_model is not None or
            self.insilico_model is not None or
            self.other is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='starting_map_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('starting_map_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='starting_map_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='starting_map_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='starting_map_type'):
        if self.type_of_model is not None and 'type_of_model' not in already_processed:
            already_processed.add('type_of_model')
            outfile.write(' type_of_model=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_of_model), input_name='type_of_model')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='starting_map_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.random_conical_tilt is not None:
            self.random_conical_tilt.export(outfile, level, namespace_, name_='random_conical_tilt', pretty_print=pretty_print)
        if self.orthogonal_tilt is not None:
            self.orthogonal_tilt.export(outfile, level, namespace_, name_='orthogonal_tilt', pretty_print=pretty_print)
        if self.emdb_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<emdb_id>%s</emdb_id>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.emdb_id), input_name='emdb_id')), eol_))
        if self.pdb_model is not None:
            self.pdb_model.export(outfile, level, namespace_, name_='pdb_model', pretty_print=pretty_print)
        if self.insilico_model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<insilico_model>%s</insilico_model>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.insilico_model), input_name='insilico_model')), eol_))
        if self.other is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<other>%s</other>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.other), input_name='other')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type_of_model', node)
        if value is not None and 'type_of_model' not in already_processed:
            already_processed.add('type_of_model')
            self.type_of_model = value
            self.type_of_model = ' '.join(self.type_of_model.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'random_conical_tilt':
            obj_ = random_conical_tiltType.factory()
            obj_.build(child_)
            self.random_conical_tilt = obj_
            obj_.original_tagname_ = 'random_conical_tilt'
        elif nodeName_ == 'orthogonal_tilt':
            obj_ = orthogonal_tiltType.factory()
            obj_.build(child_)
            self.orthogonal_tilt = obj_
            obj_.original_tagname_ = 'orthogonal_tilt'
        elif nodeName_ == 'emdb_id':
            emdb_id_ = child_.text
            if emdb_id_:
                emdb_id_ = re_.sub(String_cleanup_pat_, " ", emdb_id_).strip()
            else:
                emdb_id_ = ""
            emdb_id_ = self.gds_validate_string(emdb_id_, node, 'emdb_id')
            self.emdb_id = emdb_id_
            # validate type emdb_id_type
            self.validate_emdb_id_type(self.emdb_id)
        elif nodeName_ == 'pdb_model':
            obj_ = pdb_model_type.factory()
            obj_.build(child_)
            self.pdb_model = obj_
            obj_.original_tagname_ = 'pdb_model'
        elif nodeName_ == 'insilico_model':
            insilico_model_ = child_.text
            if insilico_model_:
                insilico_model_ = re_.sub(String_cleanup_pat_, " ", insilico_model_).strip()
            else:
                insilico_model_ = ""
            insilico_model_ = self.gds_validate_string(insilico_model_, node, 'insilico_model')
            self.insilico_model = insilico_model_
        elif nodeName_ == 'other':
            other_ = child_.text
            other_ = self.gds_validate_string(other_, node, 'other')
            self.other = other_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class starting_map_type


class pdb_model_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, pdb_id=None, chain_id_list=None):
        self.original_tagname_ = None
        self.pdb_id = pdb_id
        self.validate_pdb_code_type(self.pdb_id)
        self.chain_id_list = chain_id_list
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pdb_model_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pdb_model_type.subclass:
            return pdb_model_type.subclass(*args_, **kwargs_)
        else:
            return pdb_model_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pdb_id(self): return self.pdb_id
    def set_pdb_id(self, pdb_id): self.pdb_id = pdb_id
    def get_chain_id_list(self): return self.chain_id_list
    def set_chain_id_list(self, chain_id_list): self.chain_id_list = chain_id_list
    def validate_pdb_code_type(self, value):
        # Validate type pdb_code_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pdb_code_type_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pdb_code_type_patterns_, ))
    validate_pdb_code_type_patterns_ = [['\\d[\\dA-Za-z]{3}']]
    def hasContent_(self):
        if (
            self.pdb_id is not None or
            self.chain_id_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pdb_model_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pdb_model_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pdb_model_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pdb_model_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pdb_model_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pdb_model_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pdb_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<pdb_id>%s</pdb_id>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.pdb_id), input_name='pdb_id')), eol_))
        if self.chain_id_list is not None:
            self.chain_id_list.export(outfile, level, namespace_, name_='chain_id_list', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pdb_id':
            pdb_id_ = child_.text
            if pdb_id_:
                pdb_id_ = re_.sub(String_cleanup_pat_, " ", pdb_id_).strip()
            else:
                pdb_id_ = ""
            pdb_id_ = self.gds_validate_string(pdb_id_, node, 'pdb_id')
            self.pdb_id = pdb_id_
            # validate type pdb_code_type
            self.validate_pdb_code_type(self.pdb_id)
        elif nodeName_ == 'chain_id_list':
            class_obj_ = self.get_class_obj_(child_, chain_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.chain_id_list = obj_
            obj_.original_tagname_ = 'chain_id_list'
# end class pdb_model_type


class chain_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, chain_id=None, residue_range=None, extensiontype_=None):
        self.original_tagname_ = None
        if chain_id is None:
            self.chain_id = []
        else:
            self.chain_id = chain_id
        self.residue_range = residue_range
        self.validate_residue_rangeType(self.residue_range)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, chain_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if chain_type.subclass:
            return chain_type.subclass(*args_, **kwargs_)
        else:
            return chain_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_chain_id(self): return self.chain_id
    def set_chain_id(self, chain_id): self.chain_id = chain_id
    def add_chain_id(self, value): self.chain_id.append(value)
    def insert_chain_id_at(self, index, value): self.chain_id.insert(index, value)
    def replace_chain_id_at(self, index, value): self.chain_id[index] = value
    def get_residue_range(self): return self.residue_range
    def set_residue_range(self, residue_range): self.residue_range = residue_range
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_chain_pdb_id(self, value):
        # Validate type chain_pdb_id, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_chain_pdb_id_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_chain_pdb_id_patterns_, ))
    validate_chain_pdb_id_patterns_ = [['\\d|[A-Za-z]{1,2}']]
    def validate_residue_rangeType(self, value):
        # Validate type residue_rangeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_residue_rangeType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_residue_rangeType_patterns_, ))
    validate_residue_rangeType_patterns_ = [['\\d+-\\d+']]
    def hasContent_(self):
        if (
            self.chain_id or
            self.residue_range is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='chain_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('chain_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='chain_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='chain_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='chain_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='chain_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for chain_id_ in self.chain_id:
            showIndent(outfile, level, pretty_print)
            outfile.write('<chain_id>%s</chain_id>%s' % (self.gds_encode(self.gds_format_string(quote_xml(chain_id_), input_name='chain_id')), eol_))
        if self.residue_range is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<residue_range>%s</residue_range>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.residue_range), input_name='residue_range')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'chain_id':
            chain_id_ = child_.text
            if chain_id_:
                chain_id_ = re_.sub(String_cleanup_pat_, " ", chain_id_).strip()
            else:
                chain_id_ = ""
            chain_id_ = self.gds_validate_string(chain_id_, node, 'chain_id')
            self.chain_id.append(chain_id_)
            # validate type chain_pdb_id
            self.validate_chain_pdb_id(self.chain_id[-1])
        elif nodeName_ == 'residue_range':
            residue_range_ = child_.text
            if residue_range_:
                residue_range_ = re_.sub(String_cleanup_pat_, " ", residue_range_).strip()
            else:
                residue_range_ = ""
            residue_range_ = self.gds_validate_string(residue_range_, node, 'residue_range')
            self.residue_range = residue_range_
            # validate type residue_rangeType
            self.validate_residue_rangeType(self.residue_range)
# end class chain_type


class ctf_correction_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, phase_reversal=None, amplitude_correction=None, correction_operation=None, software_list=None, details=None):
        self.original_tagname_ = None
        self.phase_reversal = phase_reversal
        self.amplitude_correction = amplitude_correction
        self.correction_operation = correction_operation
        self.validate_correction_operationType(self.correction_operation)
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ctf_correction_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ctf_correction_type.subclass:
            return ctf_correction_type.subclass(*args_, **kwargs_)
        else:
            return ctf_correction_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phase_reversal(self): return self.phase_reversal
    def set_phase_reversal(self, phase_reversal): self.phase_reversal = phase_reversal
    def get_amplitude_correction(self): return self.amplitude_correction
    def set_amplitude_correction(self, amplitude_correction): self.amplitude_correction = amplitude_correction
    def get_correction_operation(self): return self.correction_operation
    def set_correction_operation(self, correction_operation): self.correction_operation = correction_operation
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_correction_operationType(self, value):
        # Validate type correction_operationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['MULTIPLICATION', 'DIVISION']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on correction_operationType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.phase_reversal is not None or
            self.amplitude_correction is not None or
            self.correction_operation is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ctf_correction_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ctf_correction_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ctf_correction_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ctf_correction_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ctf_correction_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ctf_correction_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phase_reversal is not None:
            self.phase_reversal.export(outfile, level, namespace_, name_='phase_reversal', pretty_print=pretty_print)
        if self.amplitude_correction is not None:
            self.amplitude_correction.export(outfile, level, namespace_, name_='amplitude_correction', pretty_print=pretty_print)
        if self.correction_operation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<correction_operation>%s</correction_operation>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.correction_operation), input_name='correction_operation')), eol_))
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'phase_reversal':
            obj_ = phase_reversalType.factory()
            obj_.build(child_)
            self.phase_reversal = obj_
            obj_.original_tagname_ = 'phase_reversal'
        elif nodeName_ == 'amplitude_correction':
            obj_ = amplitude_correctionType.factory()
            obj_.build(child_)
            self.amplitude_correction = obj_
            obj_.original_tagname_ = 'amplitude_correction'
        elif nodeName_ == 'correction_operation':
            correction_operation_ = child_.text
            correction_operation_ = self.gds_validate_string(correction_operation_, node, 'correction_operation')
            self.correction_operation = correction_operation_
            # validate type correction_operationType
            self.validate_correction_operationType(self.correction_operation)
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class ctf_correction_type


class molecular_replacement_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, starting_model=None, resolution_range=None, software_list=None):
        self.original_tagname_ = None
        if starting_model is None:
            self.starting_model = []
        else:
            self.starting_model = starting_model
        self.resolution_range = resolution_range
        self.software_list = software_list
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, molecular_replacement_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if molecular_replacement_type.subclass:
            return molecular_replacement_type.subclass(*args_, **kwargs_)
        else:
            return molecular_replacement_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_starting_model(self): return self.starting_model
    def set_starting_model(self, starting_model): self.starting_model = starting_model
    def add_starting_model(self, value): self.starting_model.append(value)
    def insert_starting_model_at(self, index, value): self.starting_model.insert(index, value)
    def replace_starting_model_at(self, index, value): self.starting_model[index] = value
    def get_resolution_range(self): return self.resolution_range
    def set_resolution_range(self, resolution_range): self.resolution_range = resolution_range
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def hasContent_(self):
        if (
            self.starting_model or
            self.resolution_range is not None or
            self.software_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='molecular_replacement_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('molecular_replacement_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='molecular_replacement_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='molecular_replacement_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='molecular_replacement_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='molecular_replacement_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for starting_model_ in self.starting_model:
            starting_model_.export(outfile, level, namespace_, name_='starting_model', pretty_print=pretty_print)
        if self.resolution_range is not None:
            self.resolution_range.export(outfile, level, namespace_, name_='resolution_range', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'starting_model':
            obj_ = starting_modelType.factory()
            obj_.build(child_)
            self.starting_model.append(obj_)
            obj_.original_tagname_ = 'starting_model'
        elif nodeName_ == 'resolution_range':
            obj_ = resolution_rangeType.factory()
            obj_.build(child_)
            self.resolution_range = obj_
            obj_.original_tagname_ = 'resolution_range'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
# end class molecular_replacement_type


class crystallography_statistics_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number_intensities_measured=None, number_structure_factors=None, fourier_space_coverage=None, r_sym=None, r_merge=None, overall_phase_error=None, overall_phase_residual=None, phase_error_rejection_criteria=None, high_resolution=None, shell_list=None, details=None):
        self.original_tagname_ = None
        self.number_intensities_measured = number_intensities_measured
        self.number_structure_factors = number_structure_factors
        self.fourier_space_coverage = fourier_space_coverage
        self.r_sym = r_sym
        self.r_merge = r_merge
        self.overall_phase_error = overall_phase_error
        self.overall_phase_residual = overall_phase_residual
        self.phase_error_rejection_criteria = phase_error_rejection_criteria
        self.high_resolution = high_resolution
        self.shell_list = shell_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_statistics_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_statistics_type.subclass:
            return crystallography_statistics_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_statistics_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number_intensities_measured(self): return self.number_intensities_measured
    def set_number_intensities_measured(self, number_intensities_measured): self.number_intensities_measured = number_intensities_measured
    def get_number_structure_factors(self): return self.number_structure_factors
    def set_number_structure_factors(self, number_structure_factors): self.number_structure_factors = number_structure_factors
    def get_fourier_space_coverage(self): return self.fourier_space_coverage
    def set_fourier_space_coverage(self, fourier_space_coverage): self.fourier_space_coverage = fourier_space_coverage
    def get_r_sym(self): return self.r_sym
    def set_r_sym(self, r_sym): self.r_sym = r_sym
    def get_r_merge(self): return self.r_merge
    def set_r_merge(self, r_merge): self.r_merge = r_merge
    def get_overall_phase_error(self): return self.overall_phase_error
    def set_overall_phase_error(self, overall_phase_error): self.overall_phase_error = overall_phase_error
    def get_overall_phase_residual(self): return self.overall_phase_residual
    def set_overall_phase_residual(self, overall_phase_residual): self.overall_phase_residual = overall_phase_residual
    def get_phase_error_rejection_criteria(self): return self.phase_error_rejection_criteria
    def set_phase_error_rejection_criteria(self, phase_error_rejection_criteria): self.phase_error_rejection_criteria = phase_error_rejection_criteria
    def get_high_resolution(self): return self.high_resolution
    def set_high_resolution(self, high_resolution): self.high_resolution = high_resolution
    def get_shell_list(self): return self.shell_list
    def set_shell_list(self, shell_list): self.shell_list = shell_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.number_intensities_measured is not None or
            self.number_structure_factors is not None or
            self.fourier_space_coverage is not None or
            self.r_sym is not None or
            self.r_merge is not None or
            self.overall_phase_error is not None or
            self.overall_phase_residual is not None or
            self.phase_error_rejection_criteria is not None or
            self.high_resolution is not None or
            self.shell_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystallography_statistics_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_statistics_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_statistics_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystallography_statistics_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystallography_statistics_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='crystallography_statistics_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_intensities_measured is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_intensities_measured>%s</number_intensities_measured>%s' % (self.gds_format_integer(self.number_intensities_measured, input_name='number_intensities_measured'), eol_))
        if self.number_structure_factors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_structure_factors>%s</number_structure_factors>%s' % (self.gds_format_integer(self.number_structure_factors, input_name='number_structure_factors'), eol_))
        if self.fourier_space_coverage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<fourier_space_coverage>%s</fourier_space_coverage>%s' % (self.gds_format_float(self.fourier_space_coverage, input_name='fourier_space_coverage'), eol_))
        if self.r_sym is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<r_sym>%s</r_sym>%s' % (self.gds_format_float(self.r_sym, input_name='r_sym'), eol_))
        if self.r_merge is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<r_merge>%s</r_merge>%s' % (self.gds_format_float(self.r_merge, input_name='r_merge'), eol_))
        if self.overall_phase_error is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<overall_phase_error>%s</overall_phase_error>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.overall_phase_error), input_name='overall_phase_error')), eol_))
        if self.overall_phase_residual is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<overall_phase_residual>%s</overall_phase_residual>%s' % (self.gds_format_float(self.overall_phase_residual, input_name='overall_phase_residual'), eol_))
        if self.phase_error_rejection_criteria is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<phase_error_rejection_criteria>%s</phase_error_rejection_criteria>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.phase_error_rejection_criteria), input_name='phase_error_rejection_criteria')), eol_))
        if self.high_resolution is not None:
            self.high_resolution.export(outfile, level, namespace_, name_='high_resolution', pretty_print=pretty_print)
        if self.shell_list is not None:
            self.shell_list.export(outfile, level, namespace_, name_='shell_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number_intensities_measured':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_intensities_measured')
            self.number_intensities_measured = ival_
        elif nodeName_ == 'number_structure_factors':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_structure_factors')
            self.number_structure_factors = ival_
        elif nodeName_ == 'fourier_space_coverage':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'fourier_space_coverage')
            self.fourier_space_coverage = fval_
        elif nodeName_ == 'r_sym':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'r_sym')
            self.r_sym = fval_
        elif nodeName_ == 'r_merge':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'r_merge')
            self.r_merge = fval_
        elif nodeName_ == 'overall_phase_error':
            overall_phase_error_ = child_.text
            if overall_phase_error_:
                overall_phase_error_ = re_.sub(String_cleanup_pat_, " ", overall_phase_error_).strip()
            else:
                overall_phase_error_ = ""
            overall_phase_error_ = self.gds_validate_string(overall_phase_error_, node, 'overall_phase_error')
            self.overall_phase_error = overall_phase_error_
        elif nodeName_ == 'overall_phase_residual':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'overall_phase_residual')
            self.overall_phase_residual = fval_
        elif nodeName_ == 'phase_error_rejection_criteria':
            phase_error_rejection_criteria_ = child_.text
            if phase_error_rejection_criteria_:
                phase_error_rejection_criteria_ = re_.sub(String_cleanup_pat_, " ", phase_error_rejection_criteria_).strip()
            else:
                phase_error_rejection_criteria_ = ""
            phase_error_rejection_criteria_ = self.gds_validate_string(phase_error_rejection_criteria_, node, 'phase_error_rejection_criteria')
            self.phase_error_rejection_criteria = phase_error_rejection_criteria_
        elif nodeName_ == 'high_resolution':
            obj_ = high_resolutionType34.factory()
            obj_.build(child_)
            self.high_resolution = obj_
            obj_.original_tagname_ = 'high_resolution'
        elif nodeName_ == 'shell_list':
            obj_ = shell_listType.factory()
            obj_.build(child_)
            self.shell_list = obj_
            obj_.original_tagname_ = 'shell_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class crystallography_statistics_type


class helical_processing_type(base_image_processing_type):
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, final_reconstruction=None, ctf_correction=None, segment_selection=None, refinement=None, startup_model=None, helical_layer_lines=None, initial_angle_assignment=None, final_angle_assignment=None, crystal_parameters=None):
        self.original_tagname_ = None
        super(helical_processing_type, self).__init__(image_processing_id, image_recording_id, details, )
        self.final_reconstruction = final_reconstruction
        self.ctf_correction = ctf_correction
        if segment_selection is None:
            self.segment_selection = []
        else:
            self.segment_selection = segment_selection
        self.refinement = refinement
        if startup_model is None:
            self.startup_model = []
        else:
            self.startup_model = startup_model
        self.helical_layer_lines = helical_layer_lines
        self.initial_angle_assignment = initial_angle_assignment
        self.final_angle_assignment = final_angle_assignment
        self.crystal_parameters = crystal_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_processing_type.subclass:
            return helical_processing_type.subclass(*args_, **kwargs_)
        else:
            return helical_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_final_reconstruction(self): return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction): self.final_reconstruction = final_reconstruction
    def get_ctf_correction(self): return self.ctf_correction
    def set_ctf_correction(self, ctf_correction): self.ctf_correction = ctf_correction
    def get_segment_selection(self): return self.segment_selection
    def set_segment_selection(self, segment_selection): self.segment_selection = segment_selection
    def add_segment_selection(self, value): self.segment_selection.append(value)
    def insert_segment_selection_at(self, index, value): self.segment_selection.insert(index, value)
    def replace_segment_selection_at(self, index, value): self.segment_selection[index] = value
    def get_refinement(self): return self.refinement
    def set_refinement(self, refinement): self.refinement = refinement
    def get_startup_model(self): return self.startup_model
    def set_startup_model(self, startup_model): self.startup_model = startup_model
    def add_startup_model(self, value): self.startup_model.append(value)
    def insert_startup_model_at(self, index, value): self.startup_model.insert(index, value)
    def replace_startup_model_at(self, index, value): self.startup_model[index] = value
    def get_helical_layer_lines(self): return self.helical_layer_lines
    def set_helical_layer_lines(self, helical_layer_lines): self.helical_layer_lines = helical_layer_lines
    def get_initial_angle_assignment(self): return self.initial_angle_assignment
    def set_initial_angle_assignment(self, initial_angle_assignment): self.initial_angle_assignment = initial_angle_assignment
    def get_final_angle_assignment(self): return self.final_angle_assignment
    def set_final_angle_assignment(self, final_angle_assignment): self.final_angle_assignment = final_angle_assignment
    def get_crystal_parameters(self): return self.crystal_parameters
    def set_crystal_parameters(self, crystal_parameters): self.crystal_parameters = crystal_parameters
    def hasContent_(self):
        if (
            self.final_reconstruction is not None or
            self.ctf_correction is not None or
            self.segment_selection or
            self.refinement is not None or
            self.startup_model or
            self.helical_layer_lines is not None or
            self.initial_angle_assignment is not None or
            self.final_angle_assignment is not None or
            self.crystal_parameters is not None or
            super(helical_processing_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='helical_processing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='helical_processing_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='helical_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='helical_processing_type'):
        super(helical_processing_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='helical_processing_type')
    def exportChildren(self, outfile, level, namespace_='', name_='helical_processing_type', fromsubclass_=False, pretty_print=True):
        super(helical_processing_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.final_reconstruction is not None:
            self.final_reconstruction.export(outfile, level, namespace_, name_='final_reconstruction', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            self.ctf_correction.export(outfile, level, namespace_, name_='ctf_correction', pretty_print=pretty_print)
        for segment_selection_ in self.segment_selection:
            segment_selection_.export(outfile, level, namespace_, name_='segment_selection', pretty_print=pretty_print)
        if self.refinement is not None:
            self.refinement.export(outfile, level, namespace_, name_='refinement', pretty_print=pretty_print)
        for startup_model_ in self.startup_model:
            startup_model_.export(outfile, level, namespace_, name_='startup_model', pretty_print=pretty_print)
        if self.helical_layer_lines is not None:
            self.helical_layer_lines.export(outfile, level, namespace_, name_='helical_layer_lines', pretty_print=pretty_print)
        if self.initial_angle_assignment is not None:
            self.initial_angle_assignment.export(outfile, level, namespace_, name_='initial_angle_assignment', pretty_print=pretty_print)
        if self.final_angle_assignment is not None:
            self.final_angle_assignment.export(outfile, level, namespace_, name_='final_angle_assignment', pretty_print=pretty_print)
        if self.crystal_parameters is not None:
            self.crystal_parameters.export(outfile, level, namespace_, name_='crystal_parameters', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(helical_processing_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'final_reconstruction':
            obj_ = non_subtom_final_reconstruction_type.factory()
            obj_.build(child_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory()
            obj_.build(child_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'segment_selection':
            obj_ = segment_selection_type.factory()
            obj_.build(child_)
            self.segment_selection.append(obj_)
            obj_.original_tagname_ = 'segment_selection'
        elif nodeName_ == 'refinement':
            obj_ = refinement_type.factory()
            obj_.build(child_)
            self.refinement = obj_
            obj_.original_tagname_ = 'refinement'
        elif nodeName_ == 'startup_model':
            obj_ = starting_map_type.factory()
            obj_.build(child_)
            self.startup_model.append(obj_)
            obj_.original_tagname_ = 'startup_model'
        elif nodeName_ == 'helical_layer_lines':
            obj_ = layer_lines_type.factory()
            obj_.build(child_)
            self.helical_layer_lines = obj_
            obj_.original_tagname_ = 'helical_layer_lines'
        elif nodeName_ == 'initial_angle_assignment':
            obj_ = angle_assignment_type.factory()
            obj_.build(child_)
            self.initial_angle_assignment = obj_
            obj_.original_tagname_ = 'initial_angle_assignment'
        elif nodeName_ == 'final_angle_assignment':
            obj_ = angle_assignment_type.factory()
            obj_.build(child_)
            self.final_angle_assignment = obj_
            obj_.original_tagname_ = 'final_angle_assignment'
        elif nodeName_ == 'crystal_parameters':
            obj_ = crystal_parameters_type.factory()
            obj_.build(child_)
            self.crystal_parameters = obj_
            obj_.original_tagname_ = 'crystal_parameters'
        super(helical_processing_type, self).buildChildren(child_, node, nodeName_, True)
# end class helical_processing_type


class segment_selection_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number_selected=None, segment_length=None, segment_overlap=None, total_filament_length=None, software_list=None, details=None):
        self.original_tagname_ = None
        self.number_selected = number_selected
        self.segment_length = segment_length
        self.segment_overlap = segment_overlap
        self.total_filament_length = total_filament_length
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segment_selection_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segment_selection_type.subclass:
            return segment_selection_type.subclass(*args_, **kwargs_)
        else:
            return segment_selection_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number_selected(self): return self.number_selected
    def set_number_selected(self, number_selected): self.number_selected = number_selected
    def get_segment_length(self): return self.segment_length
    def set_segment_length(self, segment_length): self.segment_length = segment_length
    def get_segment_overlap(self): return self.segment_overlap
    def set_segment_overlap(self, segment_overlap): self.segment_overlap = segment_overlap
    def get_total_filament_length(self): return self.total_filament_length
    def set_total_filament_length(self, total_filament_length): self.total_filament_length = total_filament_length
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.number_selected is not None or
            self.segment_length is not None or
            self.segment_overlap is not None or
            self.total_filament_length is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='segment_selection_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('segment_selection_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='segment_selection_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='segment_selection_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='segment_selection_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='segment_selection_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_selected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_selected>%s</number_selected>%s' % (self.gds_format_integer(self.number_selected, input_name='number_selected'), eol_))
        if self.segment_length is not None:
            self.segment_length.export(outfile, level, namespace_, name_='segment_length', pretty_print=pretty_print)
        if self.segment_overlap is not None:
            self.segment_overlap.export(outfile, level, namespace_, name_='segment_overlap', pretty_print=pretty_print)
        if self.total_filament_length is not None:
            self.total_filament_length.export(outfile, level, namespace_, name_='total_filament_length', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number_selected':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_selected')
            self.number_selected = ival_
        elif nodeName_ == 'segment_length':
            obj_ = segment_lengthType.factory()
            obj_.build(child_)
            self.segment_length = obj_
            obj_.original_tagname_ = 'segment_length'
        elif nodeName_ == 'segment_overlap':
            obj_ = segment_overlapType.factory()
            obj_.build(child_)
            self.segment_overlap = obj_
            obj_.original_tagname_ = 'segment_overlap'
        elif nodeName_ == 'total_filament_length':
            obj_ = total_filament_lengthType.factory()
            obj_.build(child_)
            self.total_filament_length = obj_
            obj_.original_tagname_ = 'total_filament_length'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class segment_selection_type


class refinement_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, startup_model=None, starting_symmetry=None, software_list=None, details=None):
        self.original_tagname_ = None
        if startup_model is None:
            self.startup_model = []
        else:
            self.startup_model = startup_model
        if starting_symmetry is None:
            self.starting_symmetry = []
        else:
            self.starting_symmetry = starting_symmetry
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refinement_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refinement_type.subclass:
            return refinement_type.subclass(*args_, **kwargs_)
        else:
            return refinement_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_startup_model(self): return self.startup_model
    def set_startup_model(self, startup_model): self.startup_model = startup_model
    def add_startup_model(self, value): self.startup_model.append(value)
    def insert_startup_model_at(self, index, value): self.startup_model.insert(index, value)
    def replace_startup_model_at(self, index, value): self.startup_model[index] = value
    def get_starting_symmetry(self): return self.starting_symmetry
    def set_starting_symmetry(self, starting_symmetry): self.starting_symmetry = starting_symmetry
    def add_starting_symmetry(self, value): self.starting_symmetry.append(value)
    def insert_starting_symmetry_at(self, index, value): self.starting_symmetry.insert(index, value)
    def replace_starting_symmetry_at(self, index, value): self.starting_symmetry[index] = value
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.startup_model or
            self.starting_symmetry or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='refinement_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refinement_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='refinement_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='refinement_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='refinement_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='refinement_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for startup_model_ in self.startup_model:
            startup_model_.export(outfile, level, namespace_, name_='startup_model', pretty_print=pretty_print)
        for starting_symmetry_ in self.starting_symmetry:
            starting_symmetry_.export(outfile, level, namespace_, name_='starting_symmetry', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'startup_model':
            obj_ = starting_map_type.factory()
            obj_.build(child_)
            self.startup_model.append(obj_)
            obj_.original_tagname_ = 'startup_model'
        elif nodeName_ == 'starting_symmetry':
            obj_ = starting_symmetryType.factory()
            obj_.build(child_)
            self.starting_symmetry.append(obj_)
            obj_.original_tagname_ = 'starting_symmetry'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class refinement_type


class layer_lines_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number_helices=None, helix_length=None, straightening=None, indexing=None):
        self.original_tagname_ = None
        self.number_helices = number_helices
        self.helix_length = helix_length
        self.straightening = straightening
        self.indexing = indexing
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, layer_lines_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if layer_lines_type.subclass:
            return layer_lines_type.subclass(*args_, **kwargs_)
        else:
            return layer_lines_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number_helices(self): return self.number_helices
    def set_number_helices(self, number_helices): self.number_helices = number_helices
    def get_helix_length(self): return self.helix_length
    def set_helix_length(self, helix_length): self.helix_length = helix_length
    def get_straightening(self): return self.straightening
    def set_straightening(self, straightening): self.straightening = straightening
    def get_indexing(self): return self.indexing
    def set_indexing(self, indexing): self.indexing = indexing
    def hasContent_(self):
        if (
            self.number_helices is not None or
            self.helix_length is not None or
            self.straightening is not None or
            self.indexing is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='layer_lines_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('layer_lines_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='layer_lines_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='layer_lines_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='layer_lines_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='layer_lines_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_helices is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_helices>%s</number_helices>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.number_helices), input_name='number_helices')), eol_))
        if self.helix_length is not None:
            self.helix_length.export(outfile, level, namespace_, name_='helix_length', pretty_print=pretty_print)
        if self.straightening is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<straightening>%s</straightening>%s' % (self.gds_format_boolean(self.straightening, input_name='straightening'), eol_))
        if self.indexing is not None:
            self.indexing.export(outfile, level, namespace_, name_='indexing', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number_helices':
            number_helices_ = child_.text
            number_helices_ = self.gds_validate_string(number_helices_, node, 'number_helices')
            self.number_helices = number_helices_
        elif nodeName_ == 'helix_length':
            obj_ = helix_lengthType.factory()
            obj_.build(child_)
            self.helix_length = obj_
            obj_.original_tagname_ = 'helix_length'
        elif nodeName_ == 'straightening':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'straightening')
            self.straightening = ival_
        elif nodeName_ == 'indexing':
            obj_ = indexingType.factory()
            obj_.build(child_)
            self.indexing = obj_
            obj_.original_tagname_ = 'indexing'
# end class layer_lines_type


class number_helices(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, number_helices)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if number_helices.subclass:
            return number_helices.subclass(*args_, **kwargs_)
        else:
            return number_helices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='number_helices', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('number_helices')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='number_helices')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='number_helices', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='number_helices'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='number_helices', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class number_helices


class angle_assignment_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, projection_matching_processing=None, software_list=None, details=None):
        self.original_tagname_ = None
        self.type_ = type_
        self.validate_typeType37(self.type_)
        self.projection_matching_processing = projection_matching_processing
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, angle_assignment_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if angle_assignment_type.subclass:
            return angle_assignment_type.subclass(*args_, **kwargs_)
        else:
            return angle_assignment_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_projection_matching_processing(self): return self.projection_matching_processing
    def set_projection_matching_processing(self, projection_matching_processing): self.projection_matching_processing = projection_matching_processing
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_typeType37(self, value):
        # Validate type typeType37, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ANGULAR RECONSTITUTION', 'COMMON LINE', 'NOT APPLICABLE', 'OTHER', 'PROJECTION MATCHING', 'RANDOM ASSIGNMENT', 'MAXIMUM LIKELIHOOD']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on typeType37' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.projection_matching_processing is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='angle_assignment_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('angle_assignment_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='angle_assignment_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='angle_assignment_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='angle_assignment_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='angle_assignment_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<type>%s</type>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), eol_))
        if self.projection_matching_processing is not None:
            self.projection_matching_processing.export(outfile, level, namespace_, name_='projection_matching_processing', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            if type_:
                type_ = re_.sub(String_cleanup_pat_, " ", type_).strip()
            else:
                type_ = ""
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
            # validate type typeType37
            self.validate_typeType37(self.type_)
        elif nodeName_ == 'projection_matching_processing':
            obj_ = projection_matching_processingType.factory()
            obj_.build(child_)
            self.projection_matching_processing = obj_
            obj_.original_tagname_ = 'projection_matching_processing'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class angle_assignment_type


class singleparticle_processing_type(base_image_processing_type):
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, particle_selection=None, ctf_correction=None, startup_model=None, final_reconstruction=None, initial_angle_assignment=None, final_angle_assignment=None, final_multi_reference_alignment=None, final_two_d_classification=None, final_three_d_classification=None):
        self.original_tagname_ = None
        super(singleparticle_processing_type, self).__init__(image_processing_id, image_recording_id, details, )
        if particle_selection is None:
            self.particle_selection = []
        else:
            self.particle_selection = particle_selection
        self.ctf_correction = ctf_correction
        if startup_model is None:
            self.startup_model = []
        else:
            self.startup_model = startup_model
        self.final_reconstruction = final_reconstruction
        self.initial_angle_assignment = initial_angle_assignment
        self.final_angle_assignment = final_angle_assignment
        self.final_multi_reference_alignment = final_multi_reference_alignment
        self.final_two_d_classification = final_two_d_classification
        self.final_three_d_classification = final_three_d_classification
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, singleparticle_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if singleparticle_processing_type.subclass:
            return singleparticle_processing_type.subclass(*args_, **kwargs_)
        else:
            return singleparticle_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_particle_selection(self): return self.particle_selection
    def set_particle_selection(self, particle_selection): self.particle_selection = particle_selection
    def add_particle_selection(self, value): self.particle_selection.append(value)
    def insert_particle_selection_at(self, index, value): self.particle_selection.insert(index, value)
    def replace_particle_selection_at(self, index, value): self.particle_selection[index] = value
    def get_ctf_correction(self): return self.ctf_correction
    def set_ctf_correction(self, ctf_correction): self.ctf_correction = ctf_correction
    def get_startup_model(self): return self.startup_model
    def set_startup_model(self, startup_model): self.startup_model = startup_model
    def add_startup_model(self, value): self.startup_model.append(value)
    def insert_startup_model_at(self, index, value): self.startup_model.insert(index, value)
    def replace_startup_model_at(self, index, value): self.startup_model[index] = value
    def get_final_reconstruction(self): return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction): self.final_reconstruction = final_reconstruction
    def get_initial_angle_assignment(self): return self.initial_angle_assignment
    def set_initial_angle_assignment(self, initial_angle_assignment): self.initial_angle_assignment = initial_angle_assignment
    def get_final_angle_assignment(self): return self.final_angle_assignment
    def set_final_angle_assignment(self, final_angle_assignment): self.final_angle_assignment = final_angle_assignment
    def get_final_multi_reference_alignment(self): return self.final_multi_reference_alignment
    def set_final_multi_reference_alignment(self, final_multi_reference_alignment): self.final_multi_reference_alignment = final_multi_reference_alignment
    def get_final_two_d_classification(self): return self.final_two_d_classification
    def set_final_two_d_classification(self, final_two_d_classification): self.final_two_d_classification = final_two_d_classification
    def get_final_three_d_classification(self): return self.final_three_d_classification
    def set_final_three_d_classification(self, final_three_d_classification): self.final_three_d_classification = final_three_d_classification
    def hasContent_(self):
        if (
            self.particle_selection or
            self.ctf_correction is not None or
            self.startup_model or
            self.final_reconstruction is not None or
            self.initial_angle_assignment is not None or
            self.final_angle_assignment is not None or
            self.final_multi_reference_alignment is not None or
            self.final_two_d_classification is not None or
            self.final_three_d_classification is not None or
            super(singleparticle_processing_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='singleparticle_processing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('singleparticle_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='singleparticle_processing_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='singleparticle_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='singleparticle_processing_type'):
        super(singleparticle_processing_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='singleparticle_processing_type')
    def exportChildren(self, outfile, level, namespace_='', name_='singleparticle_processing_type', fromsubclass_=False, pretty_print=True):
        super(singleparticle_processing_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for particle_selection_ in self.particle_selection:
            particle_selection_.export(outfile, level, namespace_, name_='particle_selection', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            self.ctf_correction.export(outfile, level, namespace_, name_='ctf_correction', pretty_print=pretty_print)
        for startup_model_ in self.startup_model:
            startup_model_.export(outfile, level, namespace_, name_='startup_model', pretty_print=pretty_print)
        if self.final_reconstruction is not None:
            self.final_reconstruction.export(outfile, level, namespace_, name_='final_reconstruction', pretty_print=pretty_print)
        if self.initial_angle_assignment is not None:
            self.initial_angle_assignment.export(outfile, level, namespace_, name_='initial_angle_assignment', pretty_print=pretty_print)
        if self.final_angle_assignment is not None:
            self.final_angle_assignment.export(outfile, level, namespace_, name_='final_angle_assignment', pretty_print=pretty_print)
        if self.final_multi_reference_alignment is not None:
            self.final_multi_reference_alignment.export(outfile, level, namespace_, name_='final_multi_reference_alignment', pretty_print=pretty_print)
        if self.final_two_d_classification is not None:
            self.final_two_d_classification.export(outfile, level, namespace_, name_='final_two_d_classification', pretty_print=pretty_print)
        if self.final_three_d_classification is not None:
            self.final_three_d_classification.export(outfile, level, namespace_, name_='final_three_d_classification', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(singleparticle_processing_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'particle_selection':
            obj_ = particle_selection_type.factory()
            obj_.build(child_)
            self.particle_selection.append(obj_)
            obj_.original_tagname_ = 'particle_selection'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory()
            obj_.build(child_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'startup_model':
            obj_ = starting_map_type.factory()
            obj_.build(child_)
            self.startup_model.append(obj_)
            obj_.original_tagname_ = 'startup_model'
        elif nodeName_ == 'final_reconstruction':
            obj_ = non_subtom_final_reconstruction_type.factory()
            obj_.build(child_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'initial_angle_assignment':
            obj_ = angle_assignment_type.factory()
            obj_.build(child_)
            self.initial_angle_assignment = obj_
            obj_.original_tagname_ = 'initial_angle_assignment'
        elif nodeName_ == 'final_angle_assignment':
            obj_ = angle_assignment_type.factory()
            obj_.build(child_)
            self.final_angle_assignment = obj_
            obj_.original_tagname_ = 'final_angle_assignment'
        elif nodeName_ == 'final_multi_reference_alignment':
            obj_ = final_multi_reference_alignmentType.factory()
            obj_.build(child_)
            self.final_multi_reference_alignment = obj_
            obj_.original_tagname_ = 'final_multi_reference_alignment'
        elif nodeName_ == 'final_two_d_classification':
            obj_ = classification_type.factory()
            obj_.build(child_)
            self.final_two_d_classification = obj_
            obj_.original_tagname_ = 'final_two_d_classification'
        elif nodeName_ == 'final_three_d_classification':
            obj_ = classification_type.factory()
            obj_.build(child_)
            self.final_three_d_classification = obj_
            obj_.original_tagname_ = 'final_three_d_classification'
        super(singleparticle_processing_type, self).buildChildren(child_, node, nodeName_, True)
# end class singleparticle_processing_type


class particle_selection_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number_selected=None, reference_model=None, method=None, software_list=None, details=None):
        self.original_tagname_ = None
        self.number_selected = number_selected
        self.reference_model = reference_model
        self.method = method
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, particle_selection_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if particle_selection_type.subclass:
            return particle_selection_type.subclass(*args_, **kwargs_)
        else:
            return particle_selection_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number_selected(self): return self.number_selected
    def set_number_selected(self, number_selected): self.number_selected = number_selected
    def get_reference_model(self): return self.reference_model
    def set_reference_model(self, reference_model): self.reference_model = reference_model
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.number_selected is not None or
            self.reference_model is not None or
            self.method is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='particle_selection_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('particle_selection_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='particle_selection_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='particle_selection_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='particle_selection_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='particle_selection_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_selected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_selected>%s</number_selected>%s' % (self.gds_format_integer(self.number_selected, input_name='number_selected'), eol_))
        if self.reference_model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<reference_model>%s</reference_model>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.reference_model), input_name='reference_model')), eol_))
        if self.method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<method>%s</method>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), eol_))
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number_selected':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_selected')
            self.number_selected = ival_
        elif nodeName_ == 'reference_model':
            reference_model_ = child_.text
            if reference_model_:
                reference_model_ = re_.sub(String_cleanup_pat_, " ", reference_model_).strip()
            else:
                reference_model_ = ""
            reference_model_ = self.gds_validate_string(reference_model_, node, 'reference_model')
            self.reference_model = reference_model_
        elif nodeName_ == 'method':
            method_ = child_.text
            method_ = self.gds_validate_string(method_, node, 'method')
            self.method = method_
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class particle_selection_type


class classification_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number_classes=None, average_number_members_per_class=None, software_list=None, details=None):
        self.original_tagname_ = None
        self.number_classes = number_classes
        self.average_number_members_per_class = average_number_members_per_class
        self.validate_average_number_members_per_classType(self.average_number_members_per_class)
        self.software_list = software_list
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, classification_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if classification_type.subclass:
            return classification_type.subclass(*args_, **kwargs_)
        else:
            return classification_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number_classes(self): return self.number_classes
    def set_number_classes(self, number_classes): self.number_classes = number_classes
    def get_average_number_members_per_class(self): return self.average_number_members_per_class
    def set_average_number_members_per_class(self, average_number_members_per_class): self.average_number_members_per_class = average_number_members_per_class
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_average_number_members_per_classType(self, value):
        # Validate type average_number_members_per_classType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value <= 0:
                warnings_.warn('Value "%(value)s" does not match xsd minExclusive restriction on average_number_members_per_classType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.number_classes is not None or
            self.average_number_members_per_class is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='classification_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('classification_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='classification_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='classification_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='classification_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='classification_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_classes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_classes>%s</number_classes>%s' % (self.gds_format_integer(self.number_classes, input_name='number_classes'), eol_))
        if self.average_number_members_per_class is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<average_number_members_per_class>%s</average_number_members_per_class>%s' % (self.gds_format_float(self.average_number_members_per_class, input_name='average_number_members_per_class'), eol_))
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number_classes':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_classes')
            self.number_classes = ival_
        elif nodeName_ == 'average_number_members_per_class':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'average_number_members_per_class')
            self.average_number_members_per_class = fval_
            # validate type average_number_members_per_classType
            self.validate_average_number_members_per_classType(self.average_number_members_per_class)
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class classification_type


class subtomogram_averaging_processing_type(base_image_processing_type):
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, final_reconstruction=None, extraction=None, ctf_correction=None, final_multi_reference_alignment=None, final_three_d_classification=None, final_angle_assignment=None, crystal_parameters=None):
        self.original_tagname_ = None
        super(subtomogram_averaging_processing_type, self).__init__(image_processing_id, image_recording_id, details, )
        self.final_reconstruction = final_reconstruction
        self.extraction = extraction
        self.ctf_correction = ctf_correction
        self.final_multi_reference_alignment = final_multi_reference_alignment
        self.final_three_d_classification = final_three_d_classification
        self.final_angle_assignment = final_angle_assignment
        self.crystal_parameters = crystal_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, subtomogram_averaging_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if subtomogram_averaging_processing_type.subclass:
            return subtomogram_averaging_processing_type.subclass(*args_, **kwargs_)
        else:
            return subtomogram_averaging_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_final_reconstruction(self): return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction): self.final_reconstruction = final_reconstruction
    def get_extraction(self): return self.extraction
    def set_extraction(self, extraction): self.extraction = extraction
    def get_ctf_correction(self): return self.ctf_correction
    def set_ctf_correction(self, ctf_correction): self.ctf_correction = ctf_correction
    def get_final_multi_reference_alignment(self): return self.final_multi_reference_alignment
    def set_final_multi_reference_alignment(self, final_multi_reference_alignment): self.final_multi_reference_alignment = final_multi_reference_alignment
    def get_final_three_d_classification(self): return self.final_three_d_classification
    def set_final_three_d_classification(self, final_three_d_classification): self.final_three_d_classification = final_three_d_classification
    def get_final_angle_assignment(self): return self.final_angle_assignment
    def set_final_angle_assignment(self, final_angle_assignment): self.final_angle_assignment = final_angle_assignment
    def get_crystal_parameters(self): return self.crystal_parameters
    def set_crystal_parameters(self, crystal_parameters): self.crystal_parameters = crystal_parameters
    def hasContent_(self):
        if (
            self.final_reconstruction is not None or
            self.extraction is not None or
            self.ctf_correction is not None or
            self.final_multi_reference_alignment is not None or
            self.final_three_d_classification is not None or
            self.final_angle_assignment is not None or
            self.crystal_parameters is not None or
            super(subtomogram_averaging_processing_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='subtomogram_averaging_processing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('subtomogram_averaging_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='subtomogram_averaging_processing_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='subtomogram_averaging_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='subtomogram_averaging_processing_type'):
        super(subtomogram_averaging_processing_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='subtomogram_averaging_processing_type')
    def exportChildren(self, outfile, level, namespace_='', name_='subtomogram_averaging_processing_type', fromsubclass_=False, pretty_print=True):
        super(subtomogram_averaging_processing_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.final_reconstruction is not None:
            self.final_reconstruction.export(outfile, level, namespace_, name_='final_reconstruction', pretty_print=pretty_print)
        if self.extraction is not None:
            self.extraction.export(outfile, level, namespace_, name_='extraction', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            self.ctf_correction.export(outfile, level, namespace_, name_='ctf_correction', pretty_print=pretty_print)
        if self.final_multi_reference_alignment is not None:
            self.final_multi_reference_alignment.export(outfile, level, namespace_, name_='final_multi_reference_alignment', pretty_print=pretty_print)
        if self.final_three_d_classification is not None:
            self.final_three_d_classification.export(outfile, level, namespace_, name_='final_three_d_classification', pretty_print=pretty_print)
        if self.final_angle_assignment is not None:
            self.final_angle_assignment.export(outfile, level, namespace_, name_='final_angle_assignment', pretty_print=pretty_print)
        if self.crystal_parameters is not None:
            self.crystal_parameters.export(outfile, level, namespace_, name_='crystal_parameters', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(subtomogram_averaging_processing_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'final_reconstruction':
            obj_ = subtomogram_final_reconstruction_type.factory()
            obj_.build(child_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'extraction':
            obj_ = extractionType.factory()
            obj_.build(child_)
            self.extraction = obj_
            obj_.original_tagname_ = 'extraction'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory()
            obj_.build(child_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'final_multi_reference_alignment':
            obj_ = final_multi_reference_alignmentType41.factory()
            obj_.build(child_)
            self.final_multi_reference_alignment = obj_
            obj_.original_tagname_ = 'final_multi_reference_alignment'
        elif nodeName_ == 'final_three_d_classification':
            obj_ = classification_type.factory()
            obj_.build(child_)
            self.final_three_d_classification = obj_
            obj_.original_tagname_ = 'final_three_d_classification'
        elif nodeName_ == 'final_angle_assignment':
            obj_ = angle_assignment_type.factory()
            obj_.build(child_)
            self.final_angle_assignment = obj_
            obj_.original_tagname_ = 'final_angle_assignment'
        elif nodeName_ == 'crystal_parameters':
            obj_ = crystal_parameters_type.factory()
            obj_.build(child_)
            self.crystal_parameters = obj_
            obj_.original_tagname_ = 'crystal_parameters'
        super(subtomogram_averaging_processing_type, self).buildChildren(child_, node, nodeName_, True)
# end class subtomogram_averaging_processing_type


class final_reconstruction_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number_classes_used=None, applied_symmetry=None, algorithm=None, resolution=None, resolution_method=None, reconstruction_filtering=None, software_list=None, details=None, extensiontype_=None):
        self.original_tagname_ = None
        self.number_classes_used = number_classes_used
        self.applied_symmetry = applied_symmetry
        self.algorithm = algorithm
        self.validate_reconstruction_algorithm_type(self.algorithm)
        self.resolution = resolution
        self.resolution_method = resolution_method
        self.validate_resolution_methodType(self.resolution_method)
        self.reconstruction_filtering = reconstruction_filtering
        self.software_list = software_list
        self.details = details
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, final_reconstruction_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if final_reconstruction_type.subclass:
            return final_reconstruction_type.subclass(*args_, **kwargs_)
        else:
            return final_reconstruction_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_number_classes_used(self): return self.number_classes_used
    def set_number_classes_used(self, number_classes_used): self.number_classes_used = number_classes_used
    def get_applied_symmetry(self): return self.applied_symmetry
    def set_applied_symmetry(self, applied_symmetry): self.applied_symmetry = applied_symmetry
    def get_algorithm(self): return self.algorithm
    def set_algorithm(self, algorithm): self.algorithm = algorithm
    def get_resolution(self): return self.resolution
    def set_resolution(self, resolution): self.resolution = resolution
    def get_resolution_method(self): return self.resolution_method
    def set_resolution_method(self, resolution_method): self.resolution_method = resolution_method
    def get_reconstruction_filtering(self): return self.reconstruction_filtering
    def set_reconstruction_filtering(self, reconstruction_filtering): self.reconstruction_filtering = reconstruction_filtering
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_reconstruction_algorithm_type(self, value):
        # Validate type reconstruction_algorithm_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ALGEBRAIC (ARTS)', 'BACK PROJECTION', 'EXACT BACK PROJECTION', 'FOURIER SPACE', 'SIMULTANEOUS ITERATIVE (SIRT)']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on reconstruction_algorithm_type' % {"value" : value.encode("utf-8")} )
    def validate_resolution_methodType(self, value):
        # Validate type resolution_methodType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DIFFRACTION PATTERN/LAYERLINES', 'FSC 0.143 CUT-OFF', 'FSC 0.33 CUT-OFF', 'FSC 0.5 CUT-OFF', 'FSC 1/2 BIT CUT-OFF', 'FSC 3 SIGMA CUT-OFF', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on resolution_methodType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.number_classes_used is not None or
            self.applied_symmetry is not None or
            self.algorithm is not None or
            self.resolution is not None or
            self.resolution_method is not None or
            self.reconstruction_filtering is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='final_reconstruction_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('final_reconstruction_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='final_reconstruction_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='final_reconstruction_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='final_reconstruction_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='final_reconstruction_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_classes_used is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_classes_used>%s</number_classes_used>%s' % (self.gds_format_integer(self.number_classes_used, input_name='number_classes_used'), eol_))
        if self.applied_symmetry is not None:
            self.applied_symmetry.export(outfile, level, namespace_, name_='applied_symmetry', pretty_print=pretty_print)
        if self.algorithm is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<algorithm>%s</algorithm>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.algorithm), input_name='algorithm')), eol_))
        if self.resolution is not None:
            self.resolution.export(outfile, level, namespace_, name_='resolution', pretty_print=pretty_print)
        if self.resolution_method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<resolution_method>%s</resolution_method>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.resolution_method), input_name='resolution_method')), eol_))
        if self.reconstruction_filtering is not None:
            self.reconstruction_filtering.export(outfile, level, namespace_, name_='reconstruction_filtering', pretty_print=pretty_print)
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'number_classes_used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_classes_used')
            self.number_classes_used = ival_
        elif nodeName_ == 'applied_symmetry':
            obj_ = applied_symmetry_type.factory()
            obj_.build(child_)
            self.applied_symmetry = obj_
            obj_.original_tagname_ = 'applied_symmetry'
        elif nodeName_ == 'algorithm':
            algorithm_ = child_.text
            if algorithm_:
                algorithm_ = re_.sub(String_cleanup_pat_, " ", algorithm_).strip()
            else:
                algorithm_ = ""
            algorithm_ = self.gds_validate_string(algorithm_, node, 'algorithm')
            self.algorithm = algorithm_
            # validate type reconstruction_algorithm_type
            self.validate_reconstruction_algorithm_type(self.algorithm)
        elif nodeName_ == 'resolution':
            obj_ = resolutionType.factory()
            obj_.build(child_)
            self.resolution = obj_
            obj_.original_tagname_ = 'resolution'
        elif nodeName_ == 'resolution_method':
            resolution_method_ = child_.text
            if resolution_method_:
                resolution_method_ = re_.sub(String_cleanup_pat_, " ", resolution_method_).strip()
            else:
                resolution_method_ = ""
            resolution_method_ = self.gds_validate_string(resolution_method_, node, 'resolution_method')
            self.resolution_method = resolution_method_
            # validate type resolution_methodType
            self.validate_resolution_methodType(self.resolution_method)
        elif nodeName_ == 'reconstruction_filtering':
            obj_ = reconstruction_filtering_type.factory()
            obj_.build(child_)
            self.reconstruction_filtering = obj_
            obj_.original_tagname_ = 'reconstruction_filtering'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class final_reconstruction_type


class tomography_processing_type(base_image_processing_type):
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, final_reconstruction=None, series_aligment_software_list=None, ctf_correction=None, crystal_parameters=None):
        self.original_tagname_ = None
        super(tomography_processing_type, self).__init__(image_processing_id, image_recording_id, details, )
        self.final_reconstruction = final_reconstruction
        self.series_aligment_software_list = series_aligment_software_list
        self.ctf_correction = ctf_correction
        self.crystal_parameters = crystal_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tomography_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tomography_processing_type.subclass:
            return tomography_processing_type.subclass(*args_, **kwargs_)
        else:
            return tomography_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_final_reconstruction(self): return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction): self.final_reconstruction = final_reconstruction
    def get_series_aligment_software_list(self): return self.series_aligment_software_list
    def set_series_aligment_software_list(self, series_aligment_software_list): self.series_aligment_software_list = series_aligment_software_list
    def get_ctf_correction(self): return self.ctf_correction
    def set_ctf_correction(self, ctf_correction): self.ctf_correction = ctf_correction
    def get_crystal_parameters(self): return self.crystal_parameters
    def set_crystal_parameters(self, crystal_parameters): self.crystal_parameters = crystal_parameters
    def hasContent_(self):
        if (
            self.final_reconstruction is not None or
            self.series_aligment_software_list is not None or
            self.ctf_correction is not None or
            self.crystal_parameters is not None or
            super(tomography_processing_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tomography_processing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tomography_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tomography_processing_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tomography_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tomography_processing_type'):
        super(tomography_processing_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='tomography_processing_type')
    def exportChildren(self, outfile, level, namespace_='', name_='tomography_processing_type', fromsubclass_=False, pretty_print=True):
        super(tomography_processing_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.final_reconstruction is not None:
            self.final_reconstruction.export(outfile, level, namespace_, name_='final_reconstruction', pretty_print=pretty_print)
        if self.series_aligment_software_list is not None:
            self.series_aligment_software_list.export(outfile, level, namespace_, name_='series_aligment_software_list', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            self.ctf_correction.export(outfile, level, namespace_, name_='ctf_correction', pretty_print=pretty_print)
        if self.crystal_parameters is not None:
            self.crystal_parameters.export(outfile, level, namespace_, name_='crystal_parameters', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(tomography_processing_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'final_reconstruction':
            obj_ = non_subtom_final_reconstruction_type.factory()
            obj_.build(child_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'series_aligment_software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.series_aligment_software_list = obj_
            obj_.original_tagname_ = 'series_aligment_software_list'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory()
            obj_.build(child_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'crystal_parameters':
            obj_ = crystal_parameters_type.factory()
            obj_.build(child_)
            self.crystal_parameters = obj_
            obj_.original_tagname_ = 'crystal_parameters'
        super(tomography_processing_type, self).buildChildren(child_, node, nodeName_, True)
# end class tomography_processing_type


class map_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, format=None, size_kbytes=None, file=None, symmetry=None, data_type=None, dimensions=None, origin=None, spacing=None, cell=None, axis_order=None, statistics=None, pixel_spacing=None, contour_list=None, label=None, annotation_details=None, details=None):
        self.original_tagname_ = None
        self.format = _cast(None, format)
        self.size_kbytes = _cast(int, size_kbytes)
        self.file = file
        self.validate_fileType(self.file)
        self.symmetry = symmetry
        self.data_type = data_type
        self.validate_map_data_type(self.data_type)
        self.dimensions = dimensions
        self.origin = origin
        self.spacing = spacing
        self.cell = cell
        self.axis_order = axis_order
        self.statistics = statistics
        self.pixel_spacing = pixel_spacing
        self.contour_list = contour_list
        self.label = label
        self.annotation_details = annotation_details
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, map_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if map_type.subclass:
            return map_type.subclass(*args_, **kwargs_)
        else:
            return map_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_symmetry(self): return self.symmetry
    def set_symmetry(self, symmetry): self.symmetry = symmetry
    def get_data_type(self): return self.data_type
    def set_data_type(self, data_type): self.data_type = data_type
    def get_dimensions(self): return self.dimensions
    def set_dimensions(self, dimensions): self.dimensions = dimensions
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_spacing(self): return self.spacing
    def set_spacing(self, spacing): self.spacing = spacing
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_axis_order(self): return self.axis_order
    def set_axis_order(self, axis_order): self.axis_order = axis_order
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_pixel_spacing(self): return self.pixel_spacing
    def set_pixel_spacing(self, pixel_spacing): self.pixel_spacing = pixel_spacing
    def get_contour_list(self): return self.contour_list
    def set_contour_list(self, contour_list): self.contour_list = contour_list
    def get_label(self): return self.label
    def set_label(self, label): self.label = label
    def get_annotation_details(self): return self.annotation_details
    def set_annotation_details(self, annotation_details): self.annotation_details = annotation_details
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_size_kbytes(self): return self.size_kbytes
    def set_size_kbytes(self, size_kbytes): self.size_kbytes = size_kbytes
    def validate_fileType(self, value):
        # Validate type fileType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_fileType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_fileType_patterns_, ))
    validate_fileType_patterns_ = [['emd_\\d{4,}([A-Za-z0-9_]*)\\.map(\\.gz|)']]
    def validate_map_data_type(self, value):
        # Validate type map_data_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['IMAGE STORED AS SIGNED BYTE', 'IMAGE STORED AS SIGNED INTEGER (2 BYTES)', 'IMAGE STORED AS FLOATING POINT NUMBER (4 BYTES)']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on map_data_type' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.file is not None or
            self.symmetry is not None or
            self.data_type is not None or
            self.dimensions is not None or
            self.origin is not None or
            self.spacing is not None or
            self.cell is not None or
            self.axis_order is not None or
            self.statistics is not None or
            self.pixel_spacing is not None or
            self.contour_list is not None or
            self.label is not None or
            self.annotation_details is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='map_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('map_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='map_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='map_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='map_type'):
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.format), input_name='format')), ))
        if self.size_kbytes is not None and 'size_kbytes' not in already_processed:
            already_processed.add('size_kbytes')
            outfile.write(' size_kbytes="%s"' % self.gds_format_integer(self.size_kbytes, input_name='size_kbytes'))
    def exportChildren(self, outfile, level, namespace_='', name_='map_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<file>%s</file>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.file), input_name='file')), eol_))
        if self.symmetry is not None:
            self.symmetry.export(outfile, level, namespace_, name_='symmetry', pretty_print=pretty_print)
        if self.data_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<data_type>%s</data_type>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.data_type), input_name='data_type')), eol_))
        if self.dimensions is not None:
            self.dimensions.export(outfile, level, namespace_, name_='dimensions', pretty_print=pretty_print)
        if self.origin is not None:
            self.origin.export(outfile, level, namespace_, name_='origin', pretty_print=pretty_print)
        if self.spacing is not None:
            self.spacing.export(outfile, level, namespace_, name_='spacing', pretty_print=pretty_print)
        if self.cell is not None:
            self.cell.export(outfile, level, namespace_, name_='cell', pretty_print=pretty_print)
        if self.axis_order is not None:
            self.axis_order.export(outfile, level, namespace_, name_='axis_order', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.pixel_spacing is not None:
            self.pixel_spacing.export(outfile, level, namespace_, name_='pixel_spacing', pretty_print=pretty_print)
        if self.contour_list is not None:
            self.contour_list.export(outfile, level, namespace_, name_='contour_list', pretty_print=pretty_print)
        if self.label is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<label>%s</label>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.label), input_name='label')), eol_))
        if self.annotation_details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<annotation_details>%s</annotation_details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.annotation_details), input_name='annotation_details')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
        value = find_attr_value_('size_kbytes', node)
        if value is not None and 'size_kbytes' not in already_processed:
            already_processed.add('size_kbytes')
            try:
                self.size_kbytes = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.size_kbytes <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            if file_:
                file_ = re_.sub(String_cleanup_pat_, " ", file_).strip()
            else:
                file_ = ""
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
            # validate type fileType
            self.validate_fileType(self.file)
        elif nodeName_ == 'symmetry':
            obj_ = applied_symmetry_type.factory()
            obj_.build(child_)
            self.symmetry = obj_
            obj_.original_tagname_ = 'symmetry'
        elif nodeName_ == 'data_type':
            data_type_ = child_.text
            data_type_ = self.gds_validate_string(data_type_, node, 'data_type')
            self.data_type = data_type_
            # validate type map_data_type
            self.validate_map_data_type(self.data_type)
        elif nodeName_ == 'dimensions':
            obj_ = integer_vector_map_type.factory()
            obj_.build(child_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'origin':
            obj_ = originType.factory()
            obj_.build(child_)
            self.origin = obj_
            obj_.original_tagname_ = 'origin'
        elif nodeName_ == 'spacing':
            obj_ = spacingType.factory()
            obj_.build(child_)
            self.spacing = obj_
            obj_.original_tagname_ = 'spacing'
        elif nodeName_ == 'cell':
            obj_ = cellType.factory()
            obj_.build(child_)
            self.cell = obj_
            obj_.original_tagname_ = 'cell'
        elif nodeName_ == 'axis_order':
            obj_ = axis_orderType.factory()
            obj_.build(child_)
            self.axis_order = obj_
            obj_.original_tagname_ = 'axis_order'
        elif nodeName_ == 'statistics':
            obj_ = map_statistics_type.factory()
            obj_.build(child_)
            self.statistics = obj_
            obj_.original_tagname_ = 'statistics'
        elif nodeName_ == 'pixel_spacing':
            obj_ = pixel_spacingType.factory()
            obj_.build(child_)
            self.pixel_spacing = obj_
            obj_.original_tagname_ = 'pixel_spacing'
        elif nodeName_ == 'contour_list':
            obj_ = contour_listType.factory()
            obj_.build(child_)
            self.contour_list = obj_
            obj_.original_tagname_ = 'contour_list'
        elif nodeName_ == 'label':
            label_ = child_.text
            if label_:
                label_ = re_.sub(String_cleanup_pat_, " ", label_).strip()
            else:
                label_ = ""
            label_ = self.gds_validate_string(label_, node, 'label')
            self.label = label_
        elif nodeName_ == 'annotation_details':
            annotation_details_ = child_.text
            annotation_details_ = self.gds_validate_string(annotation_details_, node, 'annotation_details')
            self.annotation_details = annotation_details_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class map_type


class integer_vector_map_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, col=None, row=None, sec=None):
        self.original_tagname_ = None
        self.col = col
        self.row = row
        self.sec = sec
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, integer_vector_map_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if integer_vector_map_type.subclass:
            return integer_vector_map_type.subclass(*args_, **kwargs_)
        else:
            return integer_vector_map_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_col(self): return self.col
    def set_col(self, col): self.col = col
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def get_sec(self): return self.sec
    def set_sec(self, sec): self.sec = sec
    def hasContent_(self):
        if (
            self.col is not None or
            self.row is not None or
            self.sec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='integer_vector_map_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('integer_vector_map_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='integer_vector_map_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='integer_vector_map_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='integer_vector_map_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='integer_vector_map_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.col is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<col>%s</col>%s' % (self.gds_format_integer(self.col, input_name='col'), eol_))
        if self.row is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<row>%s</row>%s' % (self.gds_format_integer(self.row, input_name='row'), eol_))
        if self.sec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<sec>%s</sec>%s' % (self.gds_format_integer(self.sec, input_name='sec'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'col':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'col')
            self.col = ival_
        elif nodeName_ == 'row':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'row')
            self.row = ival_
        elif nodeName_ == 'sec':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'sec')
            self.sec = ival_
# end class integer_vector_map_type


class map_statistics_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, minimum=None, maximum=None, average=None, std=None):
        self.original_tagname_ = None
        self.minimum = minimum
        self.maximum = maximum
        self.average = average
        self.std = std
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, map_statistics_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if map_statistics_type.subclass:
            return map_statistics_type.subclass(*args_, **kwargs_)
        else:
            return map_statistics_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_minimum(self): return self.minimum
    def set_minimum(self, minimum): self.minimum = minimum
    def get_maximum(self): return self.maximum
    def set_maximum(self, maximum): self.maximum = maximum
    def get_average(self): return self.average
    def set_average(self, average): self.average = average
    def get_std(self): return self.std
    def set_std(self, std): self.std = std
    def hasContent_(self):
        if (
            self.minimum is not None or
            self.maximum is not None or
            self.average is not None or
            self.std is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='map_statistics_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('map_statistics_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='map_statistics_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='map_statistics_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='map_statistics_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='map_statistics_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.minimum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<minimum>%s</minimum>%s' % (self.gds_format_float(self.minimum, input_name='minimum'), eol_))
        if self.maximum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<maximum>%s</maximum>%s' % (self.gds_format_float(self.maximum, input_name='maximum'), eol_))
        if self.average is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<average>%s</average>%s' % (self.gds_format_float(self.average, input_name='average'), eol_))
        if self.std is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<std>%s</std>%s' % (self.gds_format_float(self.std, input_name='std'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'minimum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'minimum')
            self.minimum = fval_
        elif nodeName_ == 'maximum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'maximum')
            self.maximum = fval_
        elif nodeName_ == 'average':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'average')
            self.average = fval_
        elif nodeName_ == 'std':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'std')
            self.std = fval_
# end class map_statistics_type


class pixel_spacing_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pixel_spacing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pixel_spacing_type.subclass:
            return pixel_spacing_type.subclass(*args_, **kwargs_)
        else:
            return pixel_spacing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pixel_spacing_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pixel_spacing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pixel_spacing_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pixel_spacing_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pixel_spacing_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='pixel_spacing_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class pixel_spacing_type


class interpretation_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, modelling_list=None, figure_list=None, segmentation_list=None, slices_list=None, additional_map_list=None, half_map_list=None):
        self.original_tagname_ = None
        self.modelling_list = modelling_list
        self.figure_list = figure_list
        self.segmentation_list = segmentation_list
        self.slices_list = slices_list
        self.additional_map_list = additional_map_list
        self.half_map_list = half_map_list
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, interpretation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if interpretation_type.subclass:
            return interpretation_type.subclass(*args_, **kwargs_)
        else:
            return interpretation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_modelling_list(self): return self.modelling_list
    def set_modelling_list(self, modelling_list): self.modelling_list = modelling_list
    def get_figure_list(self): return self.figure_list
    def set_figure_list(self, figure_list): self.figure_list = figure_list
    def get_segmentation_list(self): return self.segmentation_list
    def set_segmentation_list(self, segmentation_list): self.segmentation_list = segmentation_list
    def get_slices_list(self): return self.slices_list
    def set_slices_list(self, slices_list): self.slices_list = slices_list
    def get_additional_map_list(self): return self.additional_map_list
    def set_additional_map_list(self, additional_map_list): self.additional_map_list = additional_map_list
    def get_half_map_list(self): return self.half_map_list
    def set_half_map_list(self, half_map_list): self.half_map_list = half_map_list
    def hasContent_(self):
        if (
            self.modelling_list is not None or
            self.figure_list is not None or
            self.segmentation_list is not None or
            self.slices_list is not None or
            self.additional_map_list is not None or
            self.half_map_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='interpretation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('interpretation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='interpretation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='interpretation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='interpretation_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='interpretation_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.modelling_list is not None:
            self.modelling_list.export(outfile, level, namespace_, name_='modelling_list', pretty_print=pretty_print)
        if self.figure_list is not None:
            self.figure_list.export(outfile, level, namespace_, name_='figure_list', pretty_print=pretty_print)
        if self.segmentation_list is not None:
            self.segmentation_list.export(outfile, level, namespace_, name_='segmentation_list', pretty_print=pretty_print)
        if self.slices_list is not None:
            self.slices_list.export(outfile, level, namespace_, name_='slices_list', pretty_print=pretty_print)
        if self.additional_map_list is not None:
            self.additional_map_list.export(outfile, level, namespace_, name_='additional_map_list', pretty_print=pretty_print)
        if self.half_map_list is not None:
            self.half_map_list.export(outfile, level, namespace_, name_='half_map_list', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'modelling_list':
            obj_ = modelling_listType.factory()
            obj_.build(child_)
            self.modelling_list = obj_
            obj_.original_tagname_ = 'modelling_list'
        elif nodeName_ == 'figure_list':
            obj_ = figure_listType.factory()
            obj_.build(child_)
            self.figure_list = obj_
            obj_.original_tagname_ = 'figure_list'
        elif nodeName_ == 'segmentation_list':
            obj_ = segmentation_listType.factory()
            obj_.build(child_)
            self.segmentation_list = obj_
            obj_.original_tagname_ = 'segmentation_list'
        elif nodeName_ == 'slices_list':
            obj_ = slices_listType.factory()
            obj_.build(child_)
            self.slices_list = obj_
            obj_.original_tagname_ = 'slices_list'
        elif nodeName_ == 'additional_map_list':
            obj_ = additional_map_listType.factory()
            obj_.build(child_)
            self.additional_map_list = obj_
            obj_.original_tagname_ = 'additional_map_list'
        elif nodeName_ == 'half_map_list':
            obj_ = half_map_listType.factory()
            obj_.build(child_)
            self.half_map_list = obj_
            obj_.original_tagname_ = 'half_map_list'
# end class interpretation_type


class modelling_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, initial_model=None, final_model=None, refinement_protocol=None, software_list=None, details=None, target_criteria=None, refinement_space=None, overall_bvalue=None):
        self.original_tagname_ = None
        if initial_model is None:
            self.initial_model = []
        else:
            self.initial_model = initial_model
        self.final_model = final_model
        self.refinement_protocol = refinement_protocol
        self.validate_refinement_protocolType(self.refinement_protocol)
        self.software_list = software_list
        self.details = details
        self.target_criteria = target_criteria
        self.refinement_space = refinement_space
        self.overall_bvalue = overall_bvalue
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, modelling_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if modelling_type.subclass:
            return modelling_type.subclass(*args_, **kwargs_)
        else:
            return modelling_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_initial_model(self): return self.initial_model
    def set_initial_model(self, initial_model): self.initial_model = initial_model
    def add_initial_model(self, value): self.initial_model.append(value)
    def insert_initial_model_at(self, index, value): self.initial_model.insert(index, value)
    def replace_initial_model_at(self, index, value): self.initial_model[index] = value
    def get_final_model(self): return self.final_model
    def set_final_model(self, final_model): self.final_model = final_model
    def get_refinement_protocol(self): return self.refinement_protocol
    def set_refinement_protocol(self, refinement_protocol): self.refinement_protocol = refinement_protocol
    def get_software_list(self): return self.software_list
    def set_software_list(self, software_list): self.software_list = software_list
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_target_criteria(self): return self.target_criteria
    def set_target_criteria(self, target_criteria): self.target_criteria = target_criteria
    def get_refinement_space(self): return self.refinement_space
    def set_refinement_space(self, refinement_space): self.refinement_space = refinement_space
    def get_overall_bvalue(self): return self.overall_bvalue
    def set_overall_bvalue(self, overall_bvalue): self.overall_bvalue = overall_bvalue
    def validate_refinement_protocolType(self, value):
        # Validate type refinement_protocolType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['AB INITIO MODEL', 'BACKBONE TRACE', 'FLEXIBLE FIT', 'OTHER', 'RIGID BODY FIT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on refinement_protocolType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.initial_model or
            self.final_model is not None or
            self.refinement_protocol is not None or
            self.software_list is not None or
            self.details is not None or
            self.target_criteria is not None or
            self.refinement_space is not None or
            self.overall_bvalue is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='modelling_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('modelling_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='modelling_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='modelling_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='modelling_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='modelling_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for initial_model_ in self.initial_model:
            initial_model_.export(outfile, level, namespace_, name_='initial_model', pretty_print=pretty_print)
        if self.final_model is not None:
            self.final_model.export(outfile, level, namespace_, name_='final_model', pretty_print=pretty_print)
        if self.refinement_protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<refinement_protocol>%s</refinement_protocol>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.refinement_protocol), input_name='refinement_protocol')), eol_))
        if self.software_list is not None:
            self.software_list.export(outfile, level, namespace_, name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
        if self.target_criteria is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<target_criteria>%s</target_criteria>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.target_criteria), input_name='target_criteria')), eol_))
        if self.refinement_space is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<refinement_space>%s</refinement_space>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.refinement_space), input_name='refinement_space')), eol_))
        if self.overall_bvalue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<overall_bvalue>%s</overall_bvalue>%s' % (self.gds_format_float(self.overall_bvalue, input_name='overall_bvalue'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'initial_model':
            obj_ = initial_modelType.factory()
            obj_.build(child_)
            self.initial_model.append(obj_)
            obj_.original_tagname_ = 'initial_model'
        elif nodeName_ == 'final_model':
            obj_ = final_modelType.factory()
            obj_.build(child_)
            self.final_model = obj_
            obj_.original_tagname_ = 'final_model'
        elif nodeName_ == 'refinement_protocol':
            refinement_protocol_ = child_.text
            refinement_protocol_ = self.gds_validate_string(refinement_protocol_, node, 'refinement_protocol')
            self.refinement_protocol = refinement_protocol_
            # validate type refinement_protocolType
            self.validate_refinement_protocolType(self.refinement_protocol)
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory()
            obj_.build(child_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'target_criteria':
            target_criteria_ = child_.text
            if target_criteria_:
                target_criteria_ = re_.sub(String_cleanup_pat_, " ", target_criteria_).strip()
            else:
                target_criteria_ = ""
            target_criteria_ = self.gds_validate_string(target_criteria_, node, 'target_criteria')
            self.target_criteria = target_criteria_
        elif nodeName_ == 'refinement_space':
            refinement_space_ = child_.text
            if refinement_space_:
                refinement_space_ = re_.sub(String_cleanup_pat_, " ", refinement_space_).strip()
            else:
                refinement_space_ = ""
            refinement_space_ = self.gds_validate_string(refinement_space_, node, 'refinement_space')
            self.refinement_space = refinement_space_
        elif nodeName_ == 'overall_bvalue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'overall_bvalue')
            self.overall_bvalue = fval_
# end class modelling_type


class figure_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        self.file = file
        self.validate_fileType45(self.file)
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, figure_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if figure_type.subclass:
            return figure_type.subclass(*args_, **kwargs_)
        else:
            return figure_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_fileType45(self, value):
        # Validate type fileType45, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_fileType45_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_fileType45_patterns_, ))
    validate_fileType45_patterns_ = [['emd_\\d{4,}.+']]
    def hasContent_(self):
        if (
            self.file is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='figure_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('figure_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='figure_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='figure_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='figure_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='figure_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<file>%s</file>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.file), input_name='file')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            if file_:
                file_ = re_.sub(String_cleanup_pat_, " ", file_).strip()
            else:
                file_ = ""
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
            # validate type fileType45
            self.validate_fileType45(self.file)
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class figure_type


class validation_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, file=None, details=None, extensiontype_=None):
        self.original_tagname_ = None
        self.file = file
        self.validate_fileType46(self.file)
        self.details = details
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, validation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if validation_type.subclass:
            return validation_type.subclass(*args_, **kwargs_)
        else:
            return validation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_fileType46(self, value):
        # Validate type fileType46, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_fileType46_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_fileType46_patterns_, ))
    validate_fileType46_patterns_ = [['emd_\\d{4,}_fsc(_[1-9]{1,})*.xml']]
    def hasContent_(self):
        if (
            self.file is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='validation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('validation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='validation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='validation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='validation_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='validation_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<file>%s</file>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.file), input_name='file')), eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            if file_:
                file_ = re_.sub(String_cleanup_pat_, " ", file_).strip()
            else:
                file_ = ""
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
            # validate type fileType46
            self.validate_fileType46(self.file)
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class validation_type


class crystallography_validation_type(validation_type):
    subclass = None
    superclass = validation_type
    def __init__(self, file=None, details=None, parallel_resolution=None, perpendicular_resolution=None, number_observed_reflections=None, number_unique_reflections=None, weighted_phase_residual=None, weighted_r_factor=None, data_completeness=None):
        self.original_tagname_ = None
        super(crystallography_validation_type, self).__init__(file, details, )
        self.parallel_resolution = parallel_resolution
        self.perpendicular_resolution = perpendicular_resolution
        self.number_observed_reflections = number_observed_reflections
        self.number_unique_reflections = number_unique_reflections
        self.weighted_phase_residual = weighted_phase_residual
        self.weighted_r_factor = weighted_r_factor
        self.data_completeness = data_completeness
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_validation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_validation_type.subclass:
            return crystallography_validation_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_validation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parallel_resolution(self): return self.parallel_resolution
    def set_parallel_resolution(self, parallel_resolution): self.parallel_resolution = parallel_resolution
    def get_perpendicular_resolution(self): return self.perpendicular_resolution
    def set_perpendicular_resolution(self, perpendicular_resolution): self.perpendicular_resolution = perpendicular_resolution
    def get_number_observed_reflections(self): return self.number_observed_reflections
    def set_number_observed_reflections(self, number_observed_reflections): self.number_observed_reflections = number_observed_reflections
    def get_number_unique_reflections(self): return self.number_unique_reflections
    def set_number_unique_reflections(self, number_unique_reflections): self.number_unique_reflections = number_unique_reflections
    def get_weighted_phase_residual(self): return self.weighted_phase_residual
    def set_weighted_phase_residual(self, weighted_phase_residual): self.weighted_phase_residual = weighted_phase_residual
    def get_weighted_r_factor(self): return self.weighted_r_factor
    def set_weighted_r_factor(self, weighted_r_factor): self.weighted_r_factor = weighted_r_factor
    def get_data_completeness(self): return self.data_completeness
    def set_data_completeness(self, data_completeness): self.data_completeness = data_completeness
    def hasContent_(self):
        if (
            self.parallel_resolution is not None or
            self.perpendicular_resolution is not None or
            self.number_observed_reflections is not None or
            self.number_unique_reflections is not None or
            self.weighted_phase_residual is not None or
            self.weighted_r_factor is not None or
            self.data_completeness is not None or
            super(crystallography_validation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystallography_validation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_validation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_validation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystallography_validation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystallography_validation_type'):
        super(crystallography_validation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='crystallography_validation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='crystallography_validation_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_validation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.parallel_resolution is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<parallel_resolution>%s</parallel_resolution>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.parallel_resolution), input_name='parallel_resolution')), eol_))
        if self.perpendicular_resolution is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<perpendicular_resolution>%s</perpendicular_resolution>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.perpendicular_resolution), input_name='perpendicular_resolution')), eol_))
        if self.number_observed_reflections is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_observed_reflections>%s</number_observed_reflections>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.number_observed_reflections), input_name='number_observed_reflections')), eol_))
        if self.number_unique_reflections is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_unique_reflections>%s</number_unique_reflections>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.number_unique_reflections), input_name='number_unique_reflections')), eol_))
        if self.weighted_phase_residual is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<weighted_phase_residual>%s</weighted_phase_residual>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.weighted_phase_residual), input_name='weighted_phase_residual')), eol_))
        if self.weighted_r_factor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<weighted_r_factor>%s</weighted_r_factor>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.weighted_r_factor), input_name='weighted_r_factor')), eol_))
        if self.data_completeness is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<data_completeness>%s</data_completeness>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.data_completeness), input_name='data_completeness')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(crystallography_validation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parallel_resolution':
            parallel_resolution_ = child_.text
            parallel_resolution_ = self.gds_validate_string(parallel_resolution_, node, 'parallel_resolution')
            self.parallel_resolution = parallel_resolution_
        elif nodeName_ == 'perpendicular_resolution':
            perpendicular_resolution_ = child_.text
            perpendicular_resolution_ = self.gds_validate_string(perpendicular_resolution_, node, 'perpendicular_resolution')
            self.perpendicular_resolution = perpendicular_resolution_
        elif nodeName_ == 'number_observed_reflections':
            number_observed_reflections_ = child_.text
            number_observed_reflections_ = self.gds_validate_string(number_observed_reflections_, node, 'number_observed_reflections')
            self.number_observed_reflections = number_observed_reflections_
        elif nodeName_ == 'number_unique_reflections':
            number_unique_reflections_ = child_.text
            number_unique_reflections_ = self.gds_validate_string(number_unique_reflections_, node, 'number_unique_reflections')
            self.number_unique_reflections = number_unique_reflections_
        elif nodeName_ == 'weighted_phase_residual':
            weighted_phase_residual_ = child_.text
            weighted_phase_residual_ = self.gds_validate_string(weighted_phase_residual_, node, 'weighted_phase_residual')
            self.weighted_phase_residual = weighted_phase_residual_
        elif nodeName_ == 'weighted_r_factor':
            weighted_r_factor_ = child_.text
            weighted_r_factor_ = self.gds_validate_string(weighted_r_factor_, node, 'weighted_r_factor')
            self.weighted_r_factor = weighted_r_factor_
        elif nodeName_ == 'data_completeness':
            data_completeness_ = child_.text
            data_completeness_ = self.gds_validate_string(data_completeness_, node, 'data_completeness')
            self.data_completeness = data_completeness_
        super(crystallography_validation_type, self).buildChildren(child_, node, nodeName_, True)
# end class crystallography_validation_type


class parallel_resolution(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, parallel_resolution)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if parallel_resolution.subclass:
            return parallel_resolution.subclass(*args_, **kwargs_)
        else:
            return parallel_resolution(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='parallel_resolution', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('parallel_resolution')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parallel_resolution')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='parallel_resolution', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='parallel_resolution'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='parallel_resolution', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class parallel_resolution


class perpendicular_resolution(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, perpendicular_resolution)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if perpendicular_resolution.subclass:
            return perpendicular_resolution.subclass(*args_, **kwargs_)
        else:
            return perpendicular_resolution(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='perpendicular_resolution', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('perpendicular_resolution')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='perpendicular_resolution')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='perpendicular_resolution', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='perpendicular_resolution'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='perpendicular_resolution', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class perpendicular_resolution


class number_observed_reflections(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, number_observed_reflections)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if number_observed_reflections.subclass:
            return number_observed_reflections.subclass(*args_, **kwargs_)
        else:
            return number_observed_reflections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='number_observed_reflections', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('number_observed_reflections')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='number_observed_reflections')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='number_observed_reflections', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='number_observed_reflections'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='number_observed_reflections', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class number_observed_reflections


class number_unique_reflections(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, number_unique_reflections)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if number_unique_reflections.subclass:
            return number_unique_reflections.subclass(*args_, **kwargs_)
        else:
            return number_unique_reflections(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='number_unique_reflections', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('number_unique_reflections')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='number_unique_reflections')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='number_unique_reflections', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='number_unique_reflections'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='number_unique_reflections', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class number_unique_reflections


class weighted_phase_residual(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, weighted_phase_residual)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if weighted_phase_residual.subclass:
            return weighted_phase_residual.subclass(*args_, **kwargs_)
        else:
            return weighted_phase_residual(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='weighted_phase_residual', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('weighted_phase_residual')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='weighted_phase_residual')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='weighted_phase_residual', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='weighted_phase_residual'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='weighted_phase_residual', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class weighted_phase_residual


class weighted_r_factor(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, weighted_r_factor)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if weighted_r_factor.subclass:
            return weighted_r_factor.subclass(*args_, **kwargs_)
        else:
            return weighted_r_factor(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='weighted_r_factor', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('weighted_r_factor')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='weighted_r_factor')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='weighted_r_factor', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='weighted_r_factor'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='weighted_r_factor', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class weighted_r_factor


class data_completeness(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, data_completeness)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if data_completeness.subclass:
            return data_completeness.subclass(*args_, **kwargs_)
        else:
            return data_completeness(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='data_completeness', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('data_completeness')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='data_completeness')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='data_completeness', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='data_completeness'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='data_completeness', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class data_completeness


class fsc_curve_validation_type(validation_type):
    subclass = None
    superclass = validation_type
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        super(fsc_curve_validation_type, self).__init__(file, details, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fsc_curve_validation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fsc_curve_validation_type.subclass:
            return fsc_curve_validation_type.subclass(*args_, **kwargs_)
        else:
            return fsc_curve_validation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(fsc_curve_validation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fsc_curve_validation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fsc_curve_validation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fsc_curve_validation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fsc_curve_validation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fsc_curve_validation_type'):
        super(fsc_curve_validation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='fsc_curve_validation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='fsc_curve_validation_type', fromsubclass_=False, pretty_print=True):
        super(fsc_curve_validation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(fsc_curve_validation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(fsc_curve_validation_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class fsc_curve_validation_type


class layer_lines_validation_type(validation_type):
    subclass = None
    superclass = validation_type
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        super(layer_lines_validation_type, self).__init__(file, details, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, layer_lines_validation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if layer_lines_validation_type.subclass:
            return layer_lines_validation_type.subclass(*args_, **kwargs_)
        else:
            return layer_lines_validation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(layer_lines_validation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='layer_lines_validation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('layer_lines_validation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='layer_lines_validation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='layer_lines_validation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='layer_lines_validation_type'):
        super(layer_lines_validation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='layer_lines_validation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='layer_lines_validation_type', fromsubclass_=False, pretty_print=True):
        super(layer_lines_validation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(layer_lines_validation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(layer_lines_validation_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class layer_lines_validation_type


class structure_factors_validation_type(validation_type):
    subclass = None
    superclass = validation_type
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        super(structure_factors_validation_type, self).__init__(file, details, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, structure_factors_validation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if structure_factors_validation_type.subclass:
            return structure_factors_validation_type.subclass(*args_, **kwargs_)
        else:
            return structure_factors_validation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(structure_factors_validation_type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='structure_factors_validation_type', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('structure_factors_validation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='structure_factors_validation_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='structure_factors_validation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='structure_factors_validation_type'):
        super(structure_factors_validation_type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='structure_factors_validation_type')
    def exportChildren(self, outfile, level, namespace_='', name_='structure_factors_validation_type', fromsubclass_=False, pretty_print=True):
        super(structure_factors_validation_type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(structure_factors_validation_type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(structure_factors_validation_type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class structure_factors_validation_type


class structure_determination_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, structure_determination=None):
        self.original_tagname_ = None
        if structure_determination is None:
            self.structure_determination = []
        else:
            self.structure_determination = structure_determination
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, structure_determination_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if structure_determination_listType.subclass:
            return structure_determination_listType.subclass(*args_, **kwargs_)
        else:
            return structure_determination_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_structure_determination(self): return self.structure_determination
    def set_structure_determination(self, structure_determination): self.structure_determination = structure_determination
    def add_structure_determination(self, value): self.structure_determination.append(value)
    def insert_structure_determination_at(self, index, value): self.structure_determination.insert(index, value)
    def replace_structure_determination_at(self, index, value): self.structure_determination[index] = value
    def hasContent_(self):
        if (
            self.structure_determination
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='structure_determination_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('structure_determination_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='structure_determination_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='structure_determination_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='structure_determination_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='structure_determination_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for structure_determination_ in self.structure_determination:
            structure_determination_.export(outfile, level, namespace_, name_='structure_determination', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'structure_determination':
            obj_ = structure_determination_type.factory()
            obj_.build(child_)
            self.structure_determination.append(obj_)
            obj_.original_tagname_ = 'structure_determination'
# end class structure_determination_listType


class validationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, validation_method=None):
        self.original_tagname_ = None
        if validation_method is None:
            self.validation_method = []
        else:
            self.validation_method = validation_method
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, validationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if validationType.subclass:
            return validationType.subclass(*args_, **kwargs_)
        else:
            return validationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_validation_method(self): return self.validation_method
    def set_validation_method(self, validation_method): self.validation_method = validation_method
    def add_validation_method(self, value): self.validation_method.append(value)
    def insert_validation_method_at(self, index, value): self.validation_method.insert(index, value)
    def replace_validation_method_at(self, index, value): self.validation_method[index] = value
    def hasContent_(self):
        if (
            self.validation_method
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='validationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('validationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='validationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='validationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='validationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='validationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for validation_method_ in self.validation_method:
            validation_method_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'validation_method':
            class_obj_ = self.get_class_obj_(child_, validation_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.validation_method.append(obj_)
            obj_.original_tagname_ = 'validation_method'
        elif nodeName_ == 'crystallography_validation':
            obj_ = crystallography_validation_type.factory()
            obj_.build(child_)
            self.validation_method.append(obj_)
            obj_.original_tagname_ = 'crystallography_validation'
        elif nodeName_ == 'fsc_curve':
            obj_ = fsc_curve_validation_type.factory()
            obj_.build(child_)
            self.validation_method.append(obj_)
            obj_.original_tagname_ = 'fsc_curve'
        elif nodeName_ == 'layer_lines':
            obj_ = layer_lines_validation_type.factory()
            obj_.build(child_)
            self.validation_method.append(obj_)
            obj_.original_tagname_ = 'layer_lines'
        elif nodeName_ == 'structure_factors':
            obj_ = structure_factors_validation_type.factory()
            obj_.build(child_)
            self.validation_method.append(obj_)
            obj_.original_tagname_ = 'structure_factors'
# end class validationType


class sitesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, deposition=None, last_processing=None):
        self.original_tagname_ = None
        self.deposition = deposition
        self.validate_depositionType(self.deposition)
        self.last_processing = last_processing
        self.validate_last_processingType(self.last_processing)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sitesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sitesType.subclass:
            return sitesType.subclass(*args_, **kwargs_)
        else:
            return sitesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_deposition(self): return self.deposition
    def set_deposition(self, deposition): self.deposition = deposition
    def get_last_processing(self): return self.last_processing
    def set_last_processing(self, last_processing): self.last_processing = last_processing
    def validate_depositionType(self, value):
        # Validate type depositionType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PDBe', 'PDBj', 'RCSB', 'PDBc']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on depositionType' % {"value" : value.encode("utf-8")} )
    def validate_last_processingType(self, value):
        # Validate type last_processingType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PDBe', 'PDBj', 'RCSB', 'PDBc']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on last_processingType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.deposition is not None or
            self.last_processing is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sitesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sitesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sitesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sitesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sitesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sitesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.deposition is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<deposition>%s</deposition>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.deposition), input_name='deposition')), eol_))
        if self.last_processing is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<last_processing>%s</last_processing>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.last_processing), input_name='last_processing')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'deposition':
            deposition_ = child_.text
            if deposition_:
                deposition_ = re_.sub(String_cleanup_pat_, " ", deposition_).strip()
            else:
                deposition_ = ""
            deposition_ = self.gds_validate_string(deposition_, node, 'deposition')
            self.deposition = deposition_
            # validate type depositionType
            self.validate_depositionType(self.deposition)
        elif nodeName_ == 'last_processing':
            last_processing_ = child_.text
            if last_processing_:
                last_processing_ = re_.sub(String_cleanup_pat_, " ", last_processing_).strip()
            else:
                last_processing_ = ""
            last_processing_ = self.gds_validate_string(last_processing_, node, 'last_processing')
            self.last_processing = last_processing_
            # validate type last_processingType
            self.validate_last_processingType(self.last_processing)
# end class sitesType


class key_datesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, deposition=None, header_release=None, map_release=None, obsolete=None, update=None):
        self.original_tagname_ = None
        if isinstance(deposition, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(deposition, '%Y-%m-%d').date()
        else:
            initvalue_ = deposition
        self.deposition = initvalue_
        if isinstance(header_release, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(header_release, '%Y-%m-%d').date()
        else:
            initvalue_ = header_release
        self.header_release = initvalue_
        if isinstance(map_release, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(map_release, '%Y-%m-%d').date()
        else:
            initvalue_ = map_release
        self.map_release = initvalue_
        if isinstance(obsolete, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(obsolete, '%Y-%m-%d').date()
        else:
            initvalue_ = obsolete
        self.obsolete = initvalue_
        if isinstance(update, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(update, '%Y-%m-%d').date()
        else:
            initvalue_ = update
        self.update = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, key_datesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if key_datesType.subclass:
            return key_datesType.subclass(*args_, **kwargs_)
        else:
            return key_datesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_deposition(self): return self.deposition
    def set_deposition(self, deposition): self.deposition = deposition
    def get_header_release(self): return self.header_release
    def set_header_release(self, header_release): self.header_release = header_release
    def get_map_release(self): return self.map_release
    def set_map_release(self, map_release): self.map_release = map_release
    def get_obsolete(self): return self.obsolete
    def set_obsolete(self, obsolete): self.obsolete = obsolete
    def get_update(self): return self.update
    def set_update(self, update): self.update = update
    def hasContent_(self):
        if (
            self.deposition is not None or
            self.header_release is not None or
            self.map_release is not None or
            self.obsolete is not None or
            self.update is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='key_datesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('key_datesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='key_datesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='key_datesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='key_datesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='key_datesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.deposition is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<deposition>%s</deposition>%s' % (self.gds_format_date(self.deposition, input_name='deposition'), eol_))
        if self.header_release is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<header_release>%s</header_release>%s' % (self.gds_format_date(self.header_release, input_name='header_release'), eol_))
        if self.map_release is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<map_release>%s</map_release>%s' % (self.gds_format_date(self.map_release, input_name='map_release'), eol_))
        if self.obsolete is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<obsolete>%s</obsolete>%s' % (self.gds_format_date(self.obsolete, input_name='obsolete'), eol_))
        if self.update is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<update>%s</update>%s' % (self.gds_format_date(self.update, input_name='update'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'deposition':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.deposition = dval_
        elif nodeName_ == 'header_release':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.header_release = dval_
        elif nodeName_ == 'map_release':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.map_release = dval_
        elif nodeName_ == 'obsolete':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.obsolete = dval_
        elif nodeName_ == 'update':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.update = dval_
# end class key_datesType


class obsolete_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, entry=None):
        self.original_tagname_ = None
        if entry is None:
            self.entry = []
        else:
            self.entry = entry
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, obsolete_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if obsolete_listType.subclass:
            return obsolete_listType.subclass(*args_, **kwargs_)
        else:
            return obsolete_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_entry(self): return self.entry
    def set_entry(self, entry): self.entry = entry
    def add_entry(self, value): self.entry.append(value)
    def insert_entry_at(self, index, value): self.entry.insert(index, value)
    def replace_entry_at(self, index, value): self.entry[index] = value
    def hasContent_(self):
        if (
            self.entry
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='obsolete_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('obsolete_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='obsolete_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='obsolete_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='obsolete_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='obsolete_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for entry_ in self.entry:
            entry_.export(outfile, level, namespace_, name_='entry', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'entry':
            obj_ = supersedes_type.factory()
            obj_.build(child_)
            self.entry.append(obj_)
            obj_.original_tagname_ = 'entry'
# end class obsolete_listType


class superseded_by_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, entry=None):
        self.original_tagname_ = None
        if entry is None:
            self.entry = []
        else:
            self.entry = entry
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, superseded_by_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if superseded_by_listType.subclass:
            return superseded_by_listType.subclass(*args_, **kwargs_)
        else:
            return superseded_by_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_entry(self): return self.entry
    def set_entry(self, entry): self.entry = entry
    def add_entry(self, value): self.entry.append(value)
    def insert_entry_at(self, index, value): self.entry.insert(index, value)
    def replace_entry_at(self, index, value): self.entry[index] = value
    def hasContent_(self):
        if (
            self.entry
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='superseded_by_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('superseded_by_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='superseded_by_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='superseded_by_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='superseded_by_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='superseded_by_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for entry_ in self.entry:
            entry_.export(outfile, level, namespace_, name_='entry', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'entry':
            obj_ = supersedes_type.factory()
            obj_.build(child_)
            self.entry.append(obj_)
            obj_.original_tagname_ = 'entry'
# end class superseded_by_listType


class grant_supportType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, grant_reference=None):
        self.original_tagname_ = None
        if grant_reference is None:
            self.grant_reference = []
        else:
            self.grant_reference = grant_reference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grant_supportType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grant_supportType.subclass:
            return grant_supportType.subclass(*args_, **kwargs_)
        else:
            return grant_supportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_grant_reference(self): return self.grant_reference
    def set_grant_reference(self, grant_reference): self.grant_reference = grant_reference
    def add_grant_reference(self, value): self.grant_reference.append(value)
    def insert_grant_reference_at(self, index, value): self.grant_reference.insert(index, value)
    def replace_grant_reference_at(self, index, value): self.grant_reference[index] = value
    def hasContent_(self):
        if (
            self.grant_reference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='grant_supportType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grant_supportType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='grant_supportType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='grant_supportType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='grant_supportType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='grant_supportType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for grant_reference_ in self.grant_reference:
            grant_reference_.export(outfile, level, namespace_, name_='grant_reference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'grant_reference':
            obj_ = grant_reference_type.factory()
            obj_.build(child_)
            self.grant_reference.append(obj_)
            obj_.original_tagname_ = 'grant_reference'
# end class grant_supportType


class microscopy_centerType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, country=None):
        self.original_tagname_ = None
        self.name = name
        self.validate_nameType(self.name)
        self.country = country
        self.validate_countryType(self.country)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, microscopy_centerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if microscopy_centerType.subclass:
            return microscopy_centerType.subclass(*args_, **kwargs_)
        else:
            return microscopy_centerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['MICRO_CENTER_1', 'MICRO_CENTER_2', 'MICRO_CENTER_3']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on nameType' % {"value" : value.encode("utf-8")} )
    def validate_countryType(self, value):
        # Validate type countryType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['UK', 'USA', 'Japan']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on countryType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.name is not None or
            self.country is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='microscopy_centerType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('microscopy_centerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='microscopy_centerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='microscopy_centerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='microscopy_centerType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='microscopy_centerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<name>%s</name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            if name_:
                name_ = re_.sub(String_cleanup_pat_, " ", name_).strip()
            else:
                name_ = ""
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
            # validate type nameType
            self.validate_nameType(self.name)
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
            # validate type countryType
            self.validate_countryType(self.country)
# end class microscopy_centerType


class contact_authorType(contact_details_type):
    subclass = None
    superclass = contact_details_type
    def __init__(self, role=None, title=None, first_name=None, middle_name=None, last_name=None, organization=None, street=None, town_or_city=None, state_or_province=None, country=None, post_or_zip_code=None, email=None, telephone=None, fax=None, private=None):
        self.original_tagname_ = None
        super(contact_authorType, self).__init__(role, title, first_name, middle_name, last_name, organization, street, town_or_city, state_or_province, country, post_or_zip_code, email, telephone, fax, )
        self.private = _cast(None, private)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contact_authorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contact_authorType.subclass:
            return contact_authorType.subclass(*args_, **kwargs_)
        else:
            return contact_authorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_private(self): return self.private
    def set_private(self, private): self.private = private
    def hasContent_(self):
        if (
            super(contact_authorType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contact_authorType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('contact_authorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contact_authorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contact_authorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contact_authorType'):
        super(contact_authorType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='contact_authorType')
        if self.private is not None and 'private' not in already_processed:
            already_processed.add('private')
            outfile.write(' private=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.private), input_name='private')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='contact_authorType', fromsubclass_=False, pretty_print=True):
        super(contact_authorType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('private', node)
        if value is not None and 'private' not in already_processed:
            already_processed.add('private')
            self.private = value
        super(contact_authorType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(contact_authorType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class contact_authorType


class authors_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, author=None):
        self.original_tagname_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, authors_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if authors_listType.subclass:
            return authors_listType.subclass(*args_, **kwargs_)
        else:
            return authors_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def hasContent_(self):
        if (
            self.author
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='authors_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('authors_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='authors_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='authors_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='authors_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='authors_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'author':
            class_obj_ = self.get_class_obj_(child_, author_ORCID_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
# end class authors_listType


class statusType(version_type):
    subclass = None
    superclass = version_type
    def __init__(self, date=None, code=None, processing_site=None, annotator=None, details=None, status_id=None):
        self.original_tagname_ = None
        super(statusType, self).__init__(date, code, processing_site, annotator, details, )
        self.status_id = _cast(int, status_id)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, statusType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if statusType.subclass:
            return statusType.subclass(*args_, **kwargs_)
        else:
            return statusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status_id(self): return self.status_id
    def set_status_id(self, status_id): self.status_id = status_id
    def hasContent_(self):
        if (
            super(statusType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='statusType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('statusType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='statusType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='statusType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='statusType'):
        super(statusType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='statusType')
        if self.status_id is not None and 'status_id' not in already_processed:
            already_processed.add('status_id')
            outfile.write(' status_id="%s"' % self.gds_format_integer(self.status_id, input_name='status_id'))
    def exportChildren(self, outfile, level, namespace_='', name_='statusType', fromsubclass_=False, pretty_print=True):
        super(statusType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status_id', node)
        if value is not None and 'status_id' not in already_processed:
            already_processed.add('status_id')
            try:
                self.status_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.status_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(statusType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(statusType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class statusType


class annotatorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, private=None, valueOf_=None):
        self.original_tagname_ = None
        self.private = _cast(None, private)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, annotatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if annotatorType.subclass:
            return annotatorType.subclass(*args_, **kwargs_)
        else:
            return annotatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_private(self): return self.private
    def set_private(self, private): self.private = private
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='annotatorType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('annotatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='annotatorType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='annotatorType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='annotatorType'):
        if self.private is not None and 'private' not in already_processed:
            already_processed.add('private')
            outfile.write(' private=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.private), input_name='private')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='annotatorType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('private', node)
        if value is not None and 'private' not in already_processed:
            already_processed.add('private')
            self.private = value
            self.private = ' '.join(self.private.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class annotatorType


class organizationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organizationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organizationType.subclass:
            return organizationType.subclass(*args_, **kwargs_)
        else:
            return organizationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='organizationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organizationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='organizationType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='organizationType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='organizationType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='organizationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class organizationType


class citation_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, primary_citation=None, secondary_citation=None):
        self.original_tagname_ = None
        self.primary_citation = primary_citation
        if secondary_citation is None:
            self.secondary_citation = []
        else:
            self.secondary_citation = secondary_citation
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, citation_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if citation_listType.subclass:
            return citation_listType.subclass(*args_, **kwargs_)
        else:
            return citation_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_primary_citation(self): return self.primary_citation
    def set_primary_citation(self, primary_citation): self.primary_citation = primary_citation
    def get_secondary_citation(self): return self.secondary_citation
    def set_secondary_citation(self, secondary_citation): self.secondary_citation = secondary_citation
    def add_secondary_citation(self, value): self.secondary_citation.append(value)
    def insert_secondary_citation_at(self, index, value): self.secondary_citation.insert(index, value)
    def replace_secondary_citation_at(self, index, value): self.secondary_citation[index] = value
    def hasContent_(self):
        if (
            self.primary_citation is not None or
            self.secondary_citation
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='citation_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('citation_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='citation_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='citation_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='citation_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='citation_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.primary_citation is not None:
            self.primary_citation.export(outfile, level, namespace_, name_='primary_citation', pretty_print=pretty_print)
        for secondary_citation_ in self.secondary_citation:
            secondary_citation_.export(outfile, level, namespace_, name_='secondary_citation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'primary_citation':
            obj_ = primary_citationType.factory()
            obj_.build(child_)
            self.primary_citation = obj_
            obj_.original_tagname_ = 'primary_citation'
        elif nodeName_ == 'secondary_citation':
            obj_ = secondary_citationType.factory()
            obj_.build(child_)
            self.secondary_citation.append(obj_)
            obj_.original_tagname_ = 'secondary_citation'
# end class citation_listType


class primary_citationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, citation_type=None):
        self.original_tagname_ = None
        self.citation_type = citation_type
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, primary_citationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if primary_citationType.subclass:
            return primary_citationType.subclass(*args_, **kwargs_)
        else:
            return primary_citationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_citation_type(self): return self.citation_type
    def set_citation_type(self, citation_type): self.citation_type = citation_type
    def hasContent_(self):
        if (
            self.citation_type is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='primary_citationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('primary_citationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='primary_citationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='primary_citationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='primary_citationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='primary_citationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.citation_type is not None:
            self.citation_type.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'citation_type':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <citation_type> element')
            self.citation_type = obj_
            obj_.original_tagname_ = 'citation_type'
        elif nodeName_ == 'journal_citation':
            obj_ = journal_citation.factory()
            obj_.build(child_)
            self.citation_type = obj_
            obj_.original_tagname_ = 'journal_citation'
        elif nodeName_ == 'non_journal_citation':
            obj_ = non_journal_citation.factory()
            obj_.build(child_)
            self.citation_type = obj_
            obj_.original_tagname_ = 'non_journal_citation'
# end class primary_citationType


class secondary_citationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, citation_type=None):
        self.original_tagname_ = None
        self.citation_type = citation_type
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, secondary_citationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if secondary_citationType.subclass:
            return secondary_citationType.subclass(*args_, **kwargs_)
        else:
            return secondary_citationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_citation_type(self): return self.citation_type
    def set_citation_type(self, citation_type): self.citation_type = citation_type
    def hasContent_(self):
        if (
            self.citation_type is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='secondary_citationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('secondary_citationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='secondary_citationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='secondary_citationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='secondary_citationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='secondary_citationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.citation_type is not None:
            self.citation_type.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'citation_type':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <citation_type> element')
            self.citation_type = obj_
            obj_.original_tagname_ = 'citation_type'
        elif nodeName_ == 'journal_citation':
            obj_ = journal_citation.factory()
            obj_.build(child_)
            self.citation_type = obj_
            obj_.original_tagname_ = 'journal_citation'
        elif nodeName_ == 'non_journal_citation':
            obj_ = non_journal_citation.factory()
            obj_.build(child_)
            self.citation_type = obj_
            obj_.original_tagname_ = 'non_journal_citation'
# end class secondary_citationType


class auxiliary_link_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, auxiliary_link=None):
        self.original_tagname_ = None
        if auxiliary_link is None:
            self.auxiliary_link = []
        else:
            self.auxiliary_link = auxiliary_link
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, auxiliary_link_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if auxiliary_link_listType.subclass:
            return auxiliary_link_listType.subclass(*args_, **kwargs_)
        else:
            return auxiliary_link_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_auxiliary_link(self): return self.auxiliary_link
    def set_auxiliary_link(self, auxiliary_link): self.auxiliary_link = auxiliary_link
    def add_auxiliary_link(self, value): self.auxiliary_link.append(value)
    def insert_auxiliary_link_at(self, index, value): self.auxiliary_link.insert(index, value)
    def replace_auxiliary_link_at(self, index, value): self.auxiliary_link[index] = value
    def hasContent_(self):
        if (
            self.auxiliary_link
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='auxiliary_link_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('auxiliary_link_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='auxiliary_link_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='auxiliary_link_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='auxiliary_link_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='auxiliary_link_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for auxiliary_link_ in self.auxiliary_link:
            auxiliary_link_.export(outfile, level, namespace_, name_='auxiliary_link', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'auxiliary_link':
            obj_ = auxiliary_link_type.factory()
            obj_.build(child_)
            self.auxiliary_link.append(obj_)
            obj_.original_tagname_ = 'auxiliary_link'
# end class auxiliary_link_listType


class external_referencesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, external_referencesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if external_referencesType.subclass:
            return external_referencesType.subclass(*args_, **kwargs_)
        else:
            return external_referencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='external_referencesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('external_referencesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='external_referencesType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='external_referencesType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='external_referencesType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='external_referencesType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class external_referencesType


class external_referencesType3(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, external_referencesType3)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if external_referencesType3.subclass:
            return external_referencesType3.subclass(*args_, **kwargs_)
        else:
            return external_referencesType3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='external_referencesType3', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('external_referencesType3')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='external_referencesType3')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='external_referencesType3', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='external_referencesType3'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='external_referencesType3', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class external_referencesType3


class relationshipType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, in_frame=None, other=None):
        self.original_tagname_ = None
        self.in_frame = in_frame
        self.validate_in_frameType(self.in_frame)
        self.other = other
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, relationshipType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if relationshipType.subclass:
            return relationshipType.subclass(*args_, **kwargs_)
        else:
            return relationshipType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_in_frame(self): return self.in_frame
    def set_in_frame(self, in_frame): self.in_frame = in_frame
    def get_other(self): return self.other
    def set_other(self, other): self.other = other
    def validate_in_frameType(self, value):
        # Validate type in_frameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['NOOVERLAP', 'PARTIALOVERLAP', 'FULLOVERLAP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on in_frameType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.in_frame is not None or
            self.other is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='relationshipType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('relationshipType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relationshipType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='relationshipType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='relationshipType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='relationshipType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.in_frame is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<in_frame>%s</in_frame>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.in_frame), input_name='in_frame')), eol_))
        if self.other is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<other>%s</other>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.other), input_name='other')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'in_frame':
            in_frame_ = child_.text
            if in_frame_:
                in_frame_ = re_.sub(String_cleanup_pat_, " ", in_frame_).strip()
            else:
                in_frame_ = ""
            in_frame_ = self.gds_validate_string(in_frame_, node, 'in_frame')
            self.in_frame = in_frame_
            # validate type in_frameType
            self.validate_in_frameType(self.in_frame)
        elif nodeName_ == 'other':
            other_ = child_.text
            other_ = self.gds_validate_string(other_, node, 'other')
            self.other = other_
# end class relationshipType


class relationshipType4(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, in_frame=None, other=None):
        self.original_tagname_ = None
        self.in_frame = in_frame
        self.validate_in_frameType5(self.in_frame)
        self.other = other
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, relationshipType4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if relationshipType4.subclass:
            return relationshipType4.subclass(*args_, **kwargs_)
        else:
            return relationshipType4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_in_frame(self): return self.in_frame
    def set_in_frame(self, in_frame): self.in_frame = in_frame
    def get_other(self): return self.other
    def set_other(self, other): self.other = other
    def validate_in_frameType5(self, value):
        # Validate type in_frameType5, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['NOOVERLAP', 'PARTIALOVERLAP', 'FULLOVERLAP']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on in_frameType5' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.in_frame is not None or
            self.other is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='relationshipType4', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('relationshipType4')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relationshipType4')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='relationshipType4', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='relationshipType4'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='relationshipType4', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.in_frame is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<in_frame>%s</in_frame>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.in_frame), input_name='in_frame')), eol_))
        if self.other is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<other>%s</other>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.other), input_name='other')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'in_frame':
            in_frame_ = child_.text
            if in_frame_:
                in_frame_ = re_.sub(String_cleanup_pat_, " ", in_frame_).strip()
            else:
                in_frame_ = ""
            in_frame_ = self.gds_validate_string(in_frame_, node, 'in_frame')
            self.in_frame = in_frame_
            # validate type in_frameType5
            self.validate_in_frameType5(self.in_frame)
        elif nodeName_ == 'other':
            other_ = child_.text
            other_ = self.gds_validate_string(other_, node, 'other')
            self.other = other_
# end class relationshipType4


class supramolecule_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, supramolecule=None):
        self.original_tagname_ = None
        if supramolecule is None:
            self.supramolecule = []
        else:
            self.supramolecule = supramolecule
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, supramolecule_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if supramolecule_listType.subclass:
            return supramolecule_listType.subclass(*args_, **kwargs_)
        else:
            return supramolecule_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_supramolecule(self): return self.supramolecule
    def set_supramolecule(self, supramolecule): self.supramolecule = supramolecule
    def add_supramolecule(self, value): self.supramolecule.append(value)
    def insert_supramolecule_at(self, index, value): self.supramolecule.insert(index, value)
    def replace_supramolecule_at(self, index, value): self.supramolecule[index] = value
    def hasContent_(self):
        if (
            self.supramolecule
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='supramolecule_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('supramolecule_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='supramolecule_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='supramolecule_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='supramolecule_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='supramolecule_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for supramolecule_ in self.supramolecule:
            supramolecule_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'supramolecule':
            class_obj_ = self.get_class_obj_(child_, base_supramolecule_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'supramolecule'
        elif nodeName_ == 'cell_supramolecule':
            obj_ = cell_supramolecule_type.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'cell_supramolecule'
        elif nodeName_ == 'complex_supramolecule':
            obj_ = complex_supramolecule_type.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'complex_supramolecule'
        elif nodeName_ == 'organelle_or_cellular_component_supramolecule':
            obj_ = organelle_or_cellular_component_supramolecule_type.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'organelle_or_cellular_component_supramolecule'
        elif nodeName_ == 'sample_supramolecule':
            obj_ = sample_supramolecule_type.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'sample_supramolecule'
        elif nodeName_ == 'tissue_supramolecule':
            obj_ = tissue_supramolecule_type.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'tissue_supramolecule'
        elif nodeName_ == 'virus_supramolecule':
            obj_ = virus_supramolecule_type.factory()
            obj_.build(child_)
            self.supramolecule.append(obj_)
            obj_.original_tagname_ = 'virus_supramolecule'
# end class supramolecule_listType


class categoryType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, categoryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if categoryType.subclass:
            return categoryType.subclass(*args_, **kwargs_)
        else:
            return categoryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='categoryType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('categoryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='categoryType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='categoryType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='categoryType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='categoryType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class categoryType


class macromolecule_listType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, macromolecule=None):
        self.original_tagname_ = None
        if macromolecule is None:
            self.macromolecule = []
        else:
            self.macromolecule = macromolecule
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecule_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecule_listType.subclass:
            return macromolecule_listType.subclass(*args_, **kwargs_)
        else:
            return macromolecule_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_macromolecule(self): return self.macromolecule
    def set_macromolecule(self, macromolecule): self.macromolecule = macromolecule
    def add_macromolecule(self, value): self.macromolecule.append(value)
    def insert_macromolecule_at(self, index, value): self.macromolecule.insert(index, value)
    def replace_macromolecule_at(self, index, value): self.macromolecule[index] = value
    def hasContent_(self):
        if (
            self.macromolecule
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromolecule_listType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecule_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromolecule_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromolecule_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromolecule_listType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='macromolecule_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for macromolecule_ in self.macromolecule:
            macromolecule_.export(outfile, level, namespace_, name_='macromolecule', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'macromolecule':
            class_obj_ = self.get_class_obj_(child_, base_macromolecule_type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'macromolecule'
        elif nodeName_ == 'dna':
            obj_ = dna_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'dna'
        elif nodeName_ == 'em_label':
            obj_ = em_label_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'em_label'
        elif nodeName_ == 'ligand':
            obj_ = ligand_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'ligand'
        elif nodeName_ == 'other_macromolecule':
            obj_ = other_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'other_macromolecule'
        elif nodeName_ == 'protein_or_peptide':
            obj_ = protein_or_peptide_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'protein_or_peptide'
        elif nodeName_ == 'rna':
            obj_ = rna_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'rna'
        elif nodeName_ == 'saccharide':
            obj_ = saccharide_macromolecule_type.factory()
            obj_.build(child_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'saccharide'
# end class macromolecule_listType


class macromoleculeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, macromolecule_id=None, number_of_copies=None):
        self.original_tagname_ = None
        self.macromolecule_id = macromolecule_id
        self.number_of_copies = number_of_copies
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromoleculeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromoleculeType.subclass:
            return macromoleculeType.subclass(*args_, **kwargs_)
        else:
            return macromoleculeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_macromolecule_id(self): return self.macromolecule_id
    def set_macromolecule_id(self, macromolecule_id): self.macromolecule_id = macromolecule_id
    def get_number_of_copies(self): return self.number_of_copies
    def set_number_of_copies(self, number_of_copies): self.number_of_copies = number_of_copies
    def hasContent_(self):
        if (
            self.macromolecule_id is not None or
            self.number_of_copies is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromoleculeType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromoleculeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromoleculeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromoleculeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromoleculeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='macromoleculeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.macromolecule_id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<macromolecule_id>%s</macromolecule_id>%s' % (self.gds_format_integer(self.macromolecule_id, input_name='macromolecule_id'), eol_))
        if self.number_of_copies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<number_of_copies>%s</number_of_copies>%s' % (self.gds_format_integer(self.number_of_copies, input_name='number_of_copies'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'macromolecule_id':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'macromolecule_id')
            self.macromolecule_id = ival_
        elif nodeName_ == 'number_of_copies':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_of_copies')
            self.number_of_copies = ival_
# end class macromoleculeType


class external_referencesType6(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, external_referencesType6)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if external_referencesType6.subclass:
            return external_referencesType6.subclass(*args_, **kwargs_)
        else:
            return external_referencesType6(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='external_referencesType6', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('external_referencesType6')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='external_referencesType6')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='external_referencesType6', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='external_referencesType6'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='external_referencesType6', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_