# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-06-01 14:35
from __future__ import unicode_literals

import django.db.models.deletion
import django_extensions.db.fields.json
from django.conf import settings
from django.db import migrations, models

USER_MODEL = getattr(settings, "STRIPE_USER_MODEL", settings.AUTH_USER_MODEL)


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='StripeCharge',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('amount', models.IntegerField(help_text='in cents', null=True)),
                ('is_charged', models.BooleanField(default=False)),
                ('stripe_charge_id', models.CharField(blank=True, max_length=255)),
                ('description', models.CharField(help_text='Description sent to Stripe', max_length=255)),
                ('comment', models.CharField(help_text='Comment for internal information', max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='StripeToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('content', django_extensions.db.fields.json.JSONField(default=dict)),
                ('customer_id', models.CharField(max_length=255)),
                ('is_active', models.BooleanField(default=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=USER_MODEL)),
            ],
            options={
                'ordering': ['id'],
            },
        ),
        migrations.AddField(
            model_name='stripecharge',
            name='token',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='aa_stripe.StripeToken'),
        ),
        migrations.AddField(
            model_name='stripecharge',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=USER_MODEL),
        ),
    ]
