PEP: 3139 Title: Cleaning out sys and the "interpreter" module Version:
$Revision$ Last-Modified: $Date$ Author: Benjamin Peterson
<benjamin@python.org> Status: Rejected Type: Standards Track
Content-Type: text/x-rst Created: 4-April-2008 Python-Version: 3.0

Rejection Notice
================

Guido's -0.5 put an end to this PEP. See
https://mail.python.org/pipermail/python-3000/2008-April/012977.html.

Abstract
========

This PEP proposes a new low-level module for CPython-specific
interpreter functions in order to clean out the sys module and separate
general Python functionality from implementation details.

Rationale
=========

The sys module currently contains functions and data that can be put
into two major groups:

1.  Data and functions that are available in all Python implementations
    and deal with the general running of a Python virtual machine.

    -   argv
    -   byteorder
    -   path, path\_hooks, meta\_path, path\_importer\_cache, and
        modules
    -   copyright, hexversion, version, and version\_info
    -   displayhook, **displayhook**
    -   excepthook, **excepthook**, exc\_info, and exc\_clear
    -   exec\_prefix and prefix
    -   executable
    -   exit
    -   flags, py3kwarning, dont\_write\_bytecode, and warn\_options
    -   getfilesystemencoding
    -   get/setprofile
    -   get/settrace, call\_tracing
    -   getwindowsversion
    -   maxint and maxunicode
    -   platform
    -   ps1 and ps2
    -   stdin, stderr, stdout, **stdin**, **stderr**, **stdout**
    -   tracebacklimit

2.  Data and functions that affect the CPython interpreter.

    -   get/setrecursionlimit
    -   get/setcheckinterval
    -   \_getframe and \_current\_frame
    -   getrefcount
    -   get/setdlopenflags
    -   settscdumps
    -   api\_version
    -   winver
    -   dllhandle
    -   float\_info
    -   \_compact\_freelists
    -   \_clear\_type\_cache
    -   subversion
    -   builtin\_module\_names
    -   callstats
    -   intern

The second collections of items has been steadily increasing over the
years causing clutter in sys. Guido has even said he doesn't recognize
some of things in it \[\#bug-1522\]\_!

Moving these items off to another module would send a clear message to
other Python implementations about what functions need and need not be
implemented.

It has also been proposed that the contents of types module be
distributed across the standard library \[\#types-removal\]\_; the
interpreter module would provide an excellent resting place for internal
types like frames and code objects.

Specification
=============

A new builtin module named "interpreter" (see `Naming`\_) will be added.

The second list of items above will be split into the stdlib as follows:

The interpreter module - get/setrecursionlimit - get/setcheckinterval -
\_getframe and \_current\_frame - get/setdlopenflags - settscdumps -
api\_version - winver - dllhandle - float\_info - \_clear\_type\_cache -
subversion - builtin\_module\_names - callstats - intern

The gc module: - getrefcount - \_compact\_freelists

Transition Plan
===============

Once implemented in 3.x, the interpreter module will be back-ported to
2.6. Py3k warnings will be added to the sys functions it replaces.

Open Issues
===========

What should move?
-----------------

dont\_write\_bytecode \^\^\^\^\^\^\^\^\^\^\^\^\^\^\^\^\^\^\^\^

Some believe that the writing of bytecode is an implementation detail
and should be moved \[\#bytecode-issue\]\_. The counterargument is that
all current, complete Python implementations do write some sort of
bytecode, so it is valuable to be able to disable it. Also, if it is
moved, some wish to put it in the imp module.

Move to some to imp?
--------------------

It was noted that dont\_write\_bytecode or maybe builtin\_module\_names
might fit nicely in the imp module.

Naming
------

The author proposes the name "interpreter" for the new module. "pyvm"
has also been suggested \[\#pyvm-name\]*. The name "cpython" was well
liked \[\#cpython-name\]*.

References
==========

.. \[\#bug-1522\]

http://bugs.python.org/issue1522

.. \[\#types-removal\]

https://mail.python.org/pipermail/stdlib-sig/2008-April/000172.html

.. \[\#bytecode-issue\]

https://mail.python.org/pipermail/stdlib-sig/2008-April/000217.html

.. \[\#pyvm-name\]

https://mail.python.org/pipermail/python-3000/2007-November/011351.html

.. \[\#cpython-name\]

https://mail.python.org/pipermail/stdlib-sig/2008-April/000223.html

Copyright
=========

    This document has been placed in the public domain.

 Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
