PEP: 3111 Title: Simple input built-in in Python 3000 Version:
$Revision$ Last-Modified: $Date$ Author: Andre Roberge \<andre.roberge
at gmail.com \> Status: Final Type: Standards Track Content-Type:
text/x-rst Created: 13-Sep-2006 Python-Version: 3.0 Post-History:
22-Dec-2006

Abstract
========

Input and output are core features of computer programs. Currently,
Python provides a simple means of output through the print keyword and
two simple means of interactive input through the input() and
raw\_input() built-in functions.

Python 3.0 will introduce various incompatible changes with previous
Python versions \[1\]\_. Among the proposed changes, print will become a
built-in function, print(), while input() and raw\_input() would be
removed completely from the built-in namespace, requiring importing some
module to provide even the most basic input capability.

This PEP proposes that Python 3.0 retains some simple interactive user
input capability, equivalent to raw\_input(), within the built-in
namespace.

It was accepted by the BDFL in December 2006 \[5\]\_.

Motivation
==========

With its easy readability and its support for many programming styles
(e.g. procedural, object-oriented, etc.) among others, Python is perhaps
the best computer language to use in introductory programming classes.
Simple programs often need to provide information to the user (output)
and to obtain information from the user (interactive input). Any
computer language intended to be used in an educational setting should
provide straightforward methods for both output and interactive input.

The current proposals for Python 3.0 \[1\]\_ include a simple output
pathway via a built-in function named print(), but a more complicated
method for input \[e.g. via sys.stdin.readline()\], one that requires
importing an external module. Current versions of Python (pre-3.0)
include raw\_input() as a built-in function. With the availability of
such a function, programs that require simple input/output can be
written from day one, without requiring discussions of importing
modules, streams, etc.

Rationale
=========

Current built-in functions, like input() and raw\_input(), are found to
be extremely useful in traditional teaching settings. (For more details,
see \[2\]\_ and the discussion that followed.) While the BDFL has
clearly stated \[3\]\_ that input() was not to be kept in Python 3000,
he has also stated that he was not against revising the decision of
killing raw\_input().

raw\_input() provides a simple mean to ask a question and obtain a
response from a user. The proposed plans for Python 3.0 would require
the replacement of the single statement::

name = raw\_input("What is your name?")

by the more complicated::

import sys print("What is your name?") same = sys.stdin.readline()

However, from the point of view of many Python beginners and educators,
the use of sys.stdin.readline() presents the following problems:

1.  Compared to the name "raw\_input", the name "sys.stdin.readline()"
    is clunky and inelegant.

2.  The names "sys" and "stdin" have no meaning for most beginners, who
    are mainly interested in *what* the function does, and not *where*
    in the package structure it is located. The lack of meaning also
    makes it difficult to remember: is it "sys.stdin.readline()", or \"
    stdin.sys.readline()\"? To a programming novice, there is not any
    obvious reason to prefer one over the other. In contrast, functions
    simple and direct names like print, input, and raw\_input, and open
    are easier to remember.

3.  The use of "." notation is unmotivated and confusing to many
    beginners. For example, it may lead some beginners to think "." is a
    standard character that could be used in any identifier.

4.  There is an asymmetry with the print function: why is print not
    called sys.stdout.print()?

Specification
=============

The existing `raw_input()` function will be renamed to `input()`.

The Python 2 to 3 conversion tool will replace calls to `input()` with
`eval(input())` and `raw_input()` with `input()`.

Naming Discussion
=================

With `input()` effectively removed from the language, the name
`raw_input()` makes much less sense and alternatives should be
considered. The various possibilities mentioned in various forums
include::

ask() ask\_user() get\_string() input() \# initially rejected by BDFL,
later accepted prompt() read() user\_input() get\_response()

While it was initially rejected by the BDFL, it has been suggested that
the most direct solution would be to rename "raw\_input" to "input" in
Python 3000. The main objection is that Python 2.x already has a
function named "input", and, even though it is not going to be included
in Python 3000, having a built-in function with the same name but
different semantics may confuse programmers migrating from 2.x to 3000.
Certainly, this is no problem for beginners, and the scope of the
problem is unclear for more experienced programmers, since raw\_input(),
while popular with many, is not in universal use. In this instance, the
good it does for beginners could be seen to outweigh the harm it does to
experienced programmers - although it could cause confusion for people
reading older books or tutorials.

The rationale for accepting the renaming can be found here \[4\]\_.

References
==========

.. \[1\] PEP 3100, Miscellaneous Python 3.0 Plans, Kuchling, Cannon
http://www.python.org/dev/peps/pep-3100/

.. \[2\] The fate of raw\_input() in Python 3000
https://mail.python.org/pipermail/edu-sig/2006-September/006967.html

.. \[3\] Educational aspects of Python 3000
https://mail.python.org/pipermail/python-3000/2006-September/003589.html

.. \[4\] Rationale for going with the straight renaming
https://mail.python.org/pipermail/python-3000/2006-December/005249.html

.. \[5\] BDFL acceptance of the PEP
https://mail.python.org/pipermail/python-3000/2006-December/005257.html

Copyright
=========

This document has been placed in the public domain.
