PEP: 581 Title: Using GitHub Issues for CPython Version: \$Revision\$
Last-Modified: \$Date\$ Author: Mariatta \<<mariatta@python.org>\>
BDFL-Delegate: Barry Warsaw \<<barry@python.org>\> Discussions-To:
Core-Workflow Category on Discourse Status: Accepted Type: Process
Content-Type: text/x-rst Created: 20-Jun-2018 Post-History: 7-Mar-2019
Resolution:
<https://mail.python.org/pipermail/python-dev/2019-May/157399.html>

Abstract
========

This PEP outlines the rationale for migration from Python\'s issue
tracker on Roundup to GitHub issues. See PEP 588 for the detailed
migration plan.

Rationale
=========

CPython\'s development moved to GitHub in February 2017. All other
projects within the PSF\'s organization are hosted on GitHub and are
using GitHub issues. CPython is still using Roundup as the issue tracker
on bugs.python.org (bpo)[^1].

Why GitHub?
-----------

GitHub has a lot of nice features, readily available out of the box.
Some of these aren\'t readily available on Roundup / bpo.

-   APIs that can be used to build integrations and automations. There
    are various existing integrations and applications available from
    GitHub Marketplace to help with the workflow. New applications are
    easily installed and enabled. In addition, we\'ve had great success
    with building our own GitHub bots, like miss-islington[^2],
    bedevere[^3], and the-knights-who-say-ni[^4].
-   Ability to embed/drag and drop screenshots and debug log files into
    GitHub pull requests and issues.
-   Administrators and core developers can edit issues, comments, and
    pull requests.
-   Ability to reply to issue and pull request conversations via email.
-   Support for two factor authentication.
-   Support for markdown and emoji.
-   Preview tab, showing how a comment will be rendered, prior to
    actually posting.
-   Support for voting via reactions.
-   Support for permalinks[^5], allowing easy quoting and copying &
    pasting of source code. It is possible to automatically embed code
    snippet on GitHub by pasting a permalink.
-   Core developers, volunteers, and the PSF don\'t have to maintain the
    issue infrastructure/site, giving us more time and resources to
    focus on the development of Python.
-   Ability to automatically close issues when a PR has been merged[^6].
    -   Note that this feature exists in bpo too.
-   Lower barrier to contribution. With more than 28 million users, an
    open source contributor is more likely to already have an account
    and be familiar with GitHub\'s interface, making it easier to start
    contributing.
-   Email notifications containing metadata[^7], integrated with Gmail,
    allowing systematic filtering of emails. While Roundup emails
    contain some metadata, they\'re not as extensive.
-   Additional privacy, such as offering the user a choice to hide an
    email address, while still allowing communication with the user
    through @-mentions.

Issues with Roundup / bpo
-------------------------

-   Less than five people maintain bpo. Some of them are core
    developers.
-   The upstream Roundup code is in Mercurial. Without any CI available,
    it puts heavy burden on the few existing maintainers in terms of
    reviewing, testing, and applying patches. While there is an
    unofficial mirror of Roundup on GitHub[^8], Mercurial patches are
    still the main way to contribute to it.

    There is an open discussion about moving the source code of bpo to
    GitHub[^9]. If the source code of bpo does move to GitHub, it will
    become difficult to update patches from upstream. But as long as it
    is in Mercurial, it is difficult to maintain and onboard new
    contributors.

-   In its current state, the project is not equipped to accept lots of
    contributions from people who aren\'t already familiar with the code
    base.
-   The user interface needs an update and redesign. It will require
    UX/UI research to keep it up to date with current web standards,
    including accessibility.
-   Users email addresses were exposed.
    -   Note: Exposing email address to registered and logged in users
        was a decision taken when bpo instance was setup. This behavior
        has been recently modified after PEP 581\'s acceptance.
-   REST API is not currently available in bpo. There was an open issue
    in Roundup for adding REST API[^10]. At the time PEP 581 was
    proposed, the ticket received no activity since 2016. REST API has
    been integrated in Roundup in February 2019, however it is not yet
    integrated to bpo.
-   It sends a number of unnecessary emails and notifications. An
    example is the nosy email, where email notifications are sent
    whenever someone adds themselves as \"nosy\". An issue has been
    filed in upstream Roundup about this since 2012 with little
    traction[^11]. While it can be configured, the request to configure
    it was not addressed/ignored.
-   Creating an account has been a hassle. There have been reports of
    people having trouble creating accounts or logging in. Some examples
    of open tickets: \"Commas in username causes error in nosy
    list\"[^12], \"An error has occurred ..\"[^13], \"It is not sending
    me the confirmation email \...\"[^14].

Why not GitLab?
===============

Had we migrated to GitLab instead of GitHub in 2017, this PEP would have
been titled \"Using GitLab Issues for CPython\".

Why not another issue tracker?
==============================

Using another issue tracker will require yet another learning curve, for
having to learn and get used to a different interface. We\'ll also need
to learn and figure out how to build the integrations with GitHub.

By using GitHub issues, where the CPython source code is currently
hosted and where pull requests are taking place, we\'ll be providing
consistent experience to contributors and maintainers, while not having
to jump from one interface to another.

Why not focus on improving Roundup / bpo?
=========================================

GitHub has many features we like that are already available. We still
need to build out additional integrations and update our bots, but this
is something we already know how to do.

In order to really improve Roundup / bpo, it needs to first migrate to
GitHub and add CI and bots. As I understand it, there is hesitation
because upstream Roundup is still in Mercurial. Someone more familiar
with Roundup / bpo needs to champion this effort. (I\'m not
volunteering, I\'m sorry).

I believe the effort of creating and maintaining GitHub integrations and
bots is much less than the effort needed to get Roundup up to speed and
then to continue maintaining it.

Downsides of GitHub
===================

GitHub is not the perfect issue tracker. Several issues we need to be
aware of:

-   Fear of uncertainty and vendor lock in. GitHub is proprietary and
    there is risk of vendor lock-in. However, this is an existing
    problem since CPython\'s codebase is already on GitHub. This is also
    not a unique problem to CPython. As a precautionary step, CPython\'s
    repository on GitHub has been backed up on daily basis since June
    2018.[^15]
-   Bots maintenance costs money, and also takes up volunteer time. We
    would be shifting maintenance burden from Roundup to the bots. At
    the very least, so far we\'ve been able to address any bugs/issues
    related to the bots/GitHub APIs rather quickly, in a matter of days,
    instead of months or years. GitHub APIs are extensive, and used not
    only by CPython\'s bots but also by the wider Python community. It
    makes GitHub APIs more approachable compared to the maintenance of
    Roundup/bpo.
-   Using GitHub could possibly increase the triaging effort. This was
    first raised as a Zulip topic[^16], and also brought up during Core
    Python sprint in September 2018[^17]. A few solutions have been
    proposed and considered, such as creating a special triage
    team[^18]. After PEP 581\'s acceptance, GitHub released a new
    triaging role, currently in beta. The PSF has been in touch with
    GitHub to have this enabled for Python organization. This is pending
    GitHub\'s review[^19].
-   Using GitHub could make it easier for people to post disruptive or
    spammy comments. It is true that there has been incidents where core
    developers have to moderate and lock disruptive discussions on
    GitHub. Thankfully, GitHub interface makes it easy for core
    developers to moderate discussions. In addition, incidents can be
    escalated to GitHub.
-   Manually editing issue templates can be cumbersome and error-prone.
    However, for most people, creating issues on GitHub will be a much
    better experience than creating issue on bpo. The numerous fields
    and textbox to choose from can be confusing and intimidating to a
    newcomer, and it is not possible to \"edit\" a message. On GitHub,
    issue creator can preview their submission, and edit their mistake
    after posting.
-   bpo uses a number of fields to specify several metadata, and these
    might not be easily transferable to GitHub. The intended way to
    handle custom metadata on GitHub is by using labels. The details of
    which labels to create will be further discussed in PEP 588.

Further questions and discussions
=================================

You can post questions on Discourse under the
[Core-Workflow](https://discuss.python.org/c/core-workflow) category.

Acknowledgements
================

Thanks to Guido van Rossum, Brett Cannon, and Nick Coghlan, who were
consulted in the early stage and research of this PEP. Their feedback,
concerns, input, and ideas have been valuable.

References
==========

Copyright
=========

This document has been placed in the public domain.

[^1]: bugs.python.org (<https://bugs.python.org/>)

[^2]: miss-islington (<https://github.com/python/miss-islington>)

[^3]: bedevere (<https://github.com/python/bedevere>)

[^4]: the-knights-who-say-ni
    (<https://github.com/python/the-knights-who-say-ni>)

[^5]: Getting permanent links to files
    (<https://help.github.com/articles/getting-permanent-links-to-files/>)

[^6]: Closing issues using keywords
    (<https://help.github.com/articles/closing-issues-using-keywords/>)

[^7]: About GitHub email notifications
    (<https://help.github.com/articles/about-email-notifications/>)

[^8]: Unofficial GitHub mirror of Roundup
    (<https://github.com/roundup-tracker/roundup>)

[^9]: Consider whether or not to migrate bugs.python.org source code to
    GitHub repo (<https://github.com/python/bugs.python.org/issues/2>)

[^10]: Roundup issue 2550734: Expose roundup via a RESTful interface
    (<http://issues.roundup-tracker.org/issue2550734>)

[^11]: Roundup issue 2550742: Do not send email by default when adding
    or removing oneself from the Nosy list
    (<http://issues.roundup-tracker.org/issue2550742>)

[^12]: Commas in username causes error
    (<https://github.com/python/bugs.python.org/issues/26>)

[^13]: It is not sending me the confirmation email
    (<https://github.com/python/bugs.python.org/issues/27>)

[^14]: An error has occurred
    (<https://github.com/python/bugs.python.org/issues/26>)

[^15]: Backup GitHub information
    (<https://github.com/python/core-workflow/issues/20#issuecomment-396709762>)

[^16]: s/n ratio \-- Python \-- Zulip
    (<https://python.zulipchat.com/#narrow/stream/130206-pep581/topic/s.2Fn.20ratio>)

[^17]: PEP 581 discussion at Python Core Sprint 2018
    (<https://mariatta.ca/core-sprint-2018-part-2.html>)

[^18]: Proposal: Create Bug Triage team on GitHub
    (<https://discuss.python.org/t/proposal-create-bug-triage-team-on-github/992>)

[^19]: Request to enable triage role on GitHub
    (<https://discuss.python.org/t/proposal-create-bug-triage-team-on-github/992/16>)
