PEP: 417 Title: Including mock in the Standard Library Version:
$Revision$ Last-Modified: $Date$ Author: Michael Foord
<michael@python.org> Status: Final Type: Standards Track Content-Type:
text/x-rst Created: 12-Mar-2012 Python-Version: 3.3 Post-History:
12-Mar-2012 Resolution:
https://mail.python.org/pipermail/python-dev/2012-March/117507.html

Abstract
========

This PEP proposes adding the mock \[1\]\_ testing library to the Python
standard library as `unittest.mock`.

Rationale
=========

Creating mock objects for testing is a common need in Python. Many
developers create ad-hoc mocks, as needed, in their test suites. This is
currently what we do in the Python test suite, where a standardised mock
object library would be helpful.

There are many mock object libraries available for Python \[2\]\_. Of
these, mock is overwhelmingly the most popular, with as many downloads
on PyPI as the other mocking libraries combined.

An advantage of mock is that it is a mocking library and not a
framework. It provides a configurable and flexible mock object, without
being opinionated about how you write your tests. The mock api is now
well battle-tested and stable.

mock also handles safely monkeypatching and unmonkeypatching objects
during the scope of a test. This is hard to do safely and many
developers / projects mimic this functionality (often incorrectly). A
standardised way to do this, handling the complexity of patching in the
presence of the descriptor protocol (etc) is useful. People are asking
for a "patch" \[3\]\_ feature to unittest. Doing this via mock.patch is
preferable to re-implementing part of this functionality in unittest.

Background
==========

Addition of mock to the Python standard library was discussed and agreed
to at the Python Language Summit 2012.

Open Issues
===========

As of release 0.8, which is current at the time of writing, mock is
compatible with Python 2.4-3.2. Moving into the Python standard library
will allow for the removal of some Python 2 specific "compatibility
hacks".

mock 0.8 introduced a new feature, "auto-speccing", obsoletes an older
mock feature called "mocksignature". The "mocksignature" functionality
can be removed from mock altogether prior to inclusion.

References
==========

.. \[1\] `mock library on PyPI <http://pypi.python.org/pypi/mock>`\_ ..
\[2\]
http://pypi.python.org/pypi?%3Aaction=search&term=mock&submit=search ..
\[3\] http://bugs.python.org/issue11664

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
