PEP: 365 Title: Adding the pkg\_resources module Version: $Revision$
Last-Modified: $Date$ Author: Phillip J. Eby <pje@telecommunity.com>
Status: Rejected Type: Standards Track Content-Type: text/x-rst Created:
30-Apr-2007 Post-History: 30-Apr-2007

Abstract
========

This PEP proposes adding an enhanced version of the `pkg_resources`
module to the standard library.

`pkg_resources` is a module used to find and manage Python
package/version dependencies and access bundled files and resources,
including those inside of zipped `.egg` files. Currently,
`pkg_resources` is only available through installing the entire
`setuptools` distribution, but it does not depend on any other part of
setuptools; in effect, it comprises the entire runtime support library
for Python Eggs, and is independently useful.

In addition, with one feature addition, this module could support easy
bootstrap installation of several Python package management tools,
including `setuptools`, `workingenv`, and `zc.buildout`.

Proposal
========

Rather than proposing to include `setuptools` in the standard library,
this PEP proposes only that `pkg_resources` be added to the standard
library for Python 2.6 and 3.0. `pkg_resources` is considerably more
stable than the rest of setuptools, with virtually no new features being
added in the last 12 months.

However, this PEP also proposes that a new feature be added to
`pkg_resources`, before being added to the stdlib. Specifically, it
should be possible to do something like::

    python -m pkg_resources SomePackage==1.2

to request downloading and installation of `SomePackage` from PyPI. This
feature would *not* be a replacement for `easy_install`; instead, it
would rely on `SomePackage` having pure-Python `.egg` files listed for
download via the PyPI XML-RPC API, and the eggs would be placed in the
`$PYTHON_EGG_CACHE` directory, where they would **not** be importable by
default. (And no scripts would be installed.) However, if the download
egg contains installation bootstrap code, it will be given a chance to
run.

These restrictions would allow the code to be extremely simple, yet
still powerful enough to support users downloading package management
tools such as `setuptools`, `workingenv` and `zc.buildout`, simply by
supplying the tool's name on the command line.

Rationale
=========

Many users have requested that `setuptools` be included in the standard
library, to save users needing to go through the awkward process of
bootstrapping it. However, most of the bootstrapping complexity comes
from the fact that setuptools-installed code cannot use the
`pkg_resources` runtime module unless setuptools is already installed.
Thus, installing setuptools requires (in a sense) that setuptools
already be installed.

Other Python package management tools, such as `workingenv` and
`zc.buildout`, have similar bootstrapping issues, since they both make
use of setuptools, but also want to provide users with something
approaching a "one-step install". The complexity of creating bootstrap
utilities for these and any other such tools that arise in future, is
greatly reduced if `pkg_resources` is already present, and is also able
to download pre-packaged eggs from PyPI.

(It would also mean that setuptools would not need to be installed in
order to simply *use* eggs, as opposed to building them.)

Finally, in addition to providing access to eggs built via setuptools or
other packaging tools, it should be noted that since Python 2.5, the
distutils install package metadata (aka `PKG-INFO`) files that can be
read by `pkg_resources` to identify what distributions are already on
`sys.path`. In environments where Python packages are installed using
system package tools (like RPM), the `pkg_resources` module provides an
API for detecting what versions of what packages are installed, even if
those packages were installed via the distutils instead of setuptools.

Implementation and Documentation
================================

The `pkg_resources` implementation is maintained in the Python SVN
repository under `/sandbox/trunk/setuptools/`; see `pkg_resources.py`
and `pkg_resources.txt`. Documentation for the egg format(s) supported
by `pkg_resources` can be found in `doc/formats.txt`. HTML versions of
these documents are available at:

-   http://peak.telecommunity.com/DevCenter/PkgResources and

-   http://peak.telecommunity.com/DevCenter/EggFormats

(These HTML versions are for setuptools 0.6; they may not reflect all of
the changes found in the Subversion trunk's `.txt` versions.)

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
