PEP: 283 Title: Python 2.3 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Guido van Rossum Status: Final Type:
Informational Content-Type: text/x-rst Created: 27-Feb-2002
Python-Version: 2.3 Post-History: 27-Feb-2002

Abstract
========

This document describes the development and release schedule for Python
2.3. The schedule primarily concerns itself with PEP-sized items. Small
features may be added up to and including the first beta release. Bugs
may be fixed until the final release.

There will be at least two alpha releases, two beta releases, and one
release candidate. Alpha and beta releases will be spaced at least 4
weeks apart (except if an emergency release must be made to correct a
blunder in the previous release; then the blunder release does not
count). Release candidates will be spaced at least one week apart
(excepting again blunder corrections).

=========== =========== alpha 1 31 Dec 2002 alpha 2 19 Feb 2003 beta 1
25 Apr 2003 beta 2 29 Jun 2003 candidate 1 18 Jul 2003 candidate 2 24
Jul 2003 final 29 Jul 2003 =========== ===========

Release Manager
===============

Barry Warsaw, Jeremy Hylton, Tim Peters

Completed features for 2.3
==========================

This list is not complete. See `Doc/whatsnew/whatsnew23.tex` in CVS for
more, and of course `Misc/NEWS` for the full list.

-   Tk 8.4 update.

-   The `bool` type and its constants, `True` and `False` (PEP 285).

-   `PyMalloc` was greatly enhanced and is enabled by default.

-   Universal newline support (PEP 278).

-   PEP 263 Defining Python Source Code Encodings, Lemburg

    Implemented (at least phase 1, which is all that's planned for 2.3).

-   Extended slice notation for all built-in sequences. The patch by
    Michael Hudson is now all checked in.

-   Speed up list iterations by filling `tp_iter` and other tweaks. See
    https://bugs.python.org/issue560736; also done for `xrange` and
    tuples.

-   Timeout sockets. https://bugs.python.org/issue555085

-   Stage B0 of the `int`/`long` integration (PEP 237). This means
    issuing a `FutureWarning` about situations where `hex` or `oct`
    conversions or left shifts returns a different value for an `int`
    than for a `long` with the same value. The semantics do *not* change
    in Python 2.3; that will happen in Python 2.4.

-   Nuke `SET_LINENO` from all code objects (providing a different way
    to set debugger breakpoints). This can boost `pystone` by \>5%.
    https://bugs.python.org/issue587993, now checked in. (Unfortunately
    the `pystone` boost didn't happen. What happened?)

-   Write a `pymemcompat.h` that people can bundle with their extensions
    and then use the 2.3 memory interface with all Pythons in the range
    1.5.2 to 2.3. (Michael Hudson checked in `Misc/pymemcompat.h`.)

-   Add a new concept, "pending deprecation", with associated warning
    `PendingDeprecationWarning`. This warning is normally suppressed,
    but can be enabled by a suitable `-W` option. Only a few things use
    this at this time.

-   Warn when an extension type's `tp_compare` returns anything except
    -1, 0 or 1. https://bugs.python.org/issue472523

-   Warn for assignment to `None` (in various forms).

-   PEP 218 Adding a Built-In Set Object Type, Wilson

    Alex Martelli contributed a new version of Greg Wilson's prototype,
    and I've reworked that quite a bit. It's in the standard library now
    as the module `sets`, although some details may still change until
    the first beta release. (There are no plans to make this a built-in
    type, for now.)

-   PEP 293 Codec error handling callbacks, Dörwald

    Fully implemented. Error handling in `unicode.encode` or
    `str.decode` can now be customized.

-   PEP 282 A Logging System, Mick

    Vinay Sajip's implementation has been packagized and imported.
    (Documentation and unit tests still pending.)
    https://bugs.python.org/issue578494

-   A modified MRO (Method Resolution Order) algorithm. Consensus is
    that we should adopt C3. Samuele Pedroni has contributed a draft
    implementation in C, see https://bugs.python.org/issue619475 This
    has now been checked in.

-   A new command line option parser. Greg Ward's Optik package
    (http://optik.sf.net) has been adopted, converted to a single module
    named `optparse`. See also http://www.python.org/sigs/getopt-sig/

-   A standard `datetime` type. This started as a wiki:
    http://www.zope.org/Members/fdrake/DateTimeWiki/FrontPage. A
    prototype was coded in `nondist/sandbox/datetime/`. Tim Peters has
    finished the C implementation and checked it in.

-   PEP 273 Import Modules from Zip Archives, Ahlstrom

    Implemented as a part of the PEP 302 implementation work.

-   PEP 302 New Import Hooks, JvR

    Implemented (though the 2.3a1 release contained some bugs that have
    been fixed post-release).

-   A new pickling protocol. See PEP 307.

-   PEP 305 (CSV File API, by Skip Montanaro et al.) is in; this is the
    csv module.

-   Raymond Hettinger's `itertools` module is in.

-   PEP 311 (Simplified GIL Acquisition for Extensions, by Mark Hammond)
    has been included in beta 1.

-   Two new `PyArg_Parse*()` format codes, 'k' returns an unsigned C
    long int that receives the lower `LONG_BIT` bits of the Python
    argument, truncating without range checking. 'K' returns an unsigned
    C long long int that receives the lower `LONG_LONG_BIT` bits,
    truncating without range checking. (SF 595026; Thomas Heller did
    this work.)

-   A new version of IDLE was imported from the IDLEfork project
    (http://idlefork.sf.net). The code now lives in the `idlelib`
    package in the standard library and the `idle` script is installed
    by `setup.py`.

Planned features for 2.3
========================

Too late for anything more to get done here.

Ongoing tasks
=============

The following are ongoing TO-DO items which we should attempt to work on
without hoping for completion by any particular date.

-   Documentation: complete the distribution and installation manuals.

-   Documentation: complete the documentation for new-style classes.

-   Look over the `Demos/` directory and update where required (Andrew
    Kuchling has done a lot of this)

-   New tests.

-   Fix doc bugs on SF.

-   Remove use of deprecated features in the core.

-   Document deprecated features appropriately.

-   Mark deprecated C APIs with `Py_DEPRECATED`.

-   Deprecate modules which are unmaintained, or perhaps make a new
    category for modules 'Unmaintained'

-   In general, lots of cleanup so it is easier to move forward.

Open issues
===========

There are some issues that may need more work and/or thought before the
final release (and preferably before the first beta release): No issues
remaining.

Features that did not make it into Python 2.3
=============================================

-   The import lock could use some redesign. (SF 683658.)

-   Set API issues; is the sets module perfect?

    I expect it's good enough to stop polishing it until we've had more
    widespread user experience.

-   A nicer API to open text files, replacing the ugly (in some people's
    eyes) "U" mode flag. There's a proposal out there to have a new
    built-in type `textfile(filename, mode, encoding)`. (Shouldn't it
    have a *bufsize* argument too?)

    Ditto.

-   New widgets for Tkinter???

    Has anyone gotten the time for this? *Are* there any new widgets in
    Tk 8.4? Note that we've got better Tix support already (though not
    on Windows yet).

-   Fredrik Lundh's basetime proposal:

    http://effbot.org/ideas/time-type.htm

    I believe this is dead now.

-   PEP 304 (Controlling Generation of Bytecode Files by Montanaro)
    seems to have lost steam.

-   For a class defined inside another class, the `__name__` should be
    `"outer.inner"`, and pickling should work. (SF 633930. I'm no longer
    certain this is easy or even right.)

-   reST is going to be used a lot in Zope3. Maybe it could become a
    standard library module? (Since reST's author thinks it's too
    unstable, I'm inclined not to do this.)

-   Decide on a clearer deprecation policy (especially for modules) and
    act on it. For a start, see this message from Neal Norwitz:
    https://mail.python.org/pipermail/python-dev/2002-April/023165.html
    There seems insufficient interest in moving this further in an
    organized fashion, and it's not particularly important.

-   Provide alternatives for common uses of the `types` module;

    Skip Montanaro has posted a proto-PEP for this idea:
    https://mail.python.org/pipermail/python-dev/2002-May/024346.html

    There hasn't been any progress on this, AFAICT.

-   Use pending deprecation for the `types` and `string` modules. This
    requires providing alternatives for the parts that aren't covered
    yet (e.g. `string.whitespace` and `types.TracebackType`). It seems
    we can't get consensus on this.

-   Deprecate the `buffer` object.

    -   https://mail.python.org/pipermail/python-dev/2002-July/026388.html
    -   https://mail.python.org/pipermail/python-dev/2002-July/026408.html

    It seems that this is never going to be resolved.

-   PEP 269 Pgen Module for Python, Riehl

    (Some necessary changes are in; the `pgen` module itself needs to
    mature more.)

-   Add support for the long-awaited Python catalog. Kapil Thangavelu
    has a Zope-based implementation that he demoed at OSCON 2002. Now
    all we need is a place to host it and a person to champion it. (Some
    changes to distutils to support this are in, at least.)

-   PEP 266 Optimizing Global Variable/Attribute Access, Montanaro

    PEP 267 Optimized Access to Module Namespaces, Hylton

    PEP 280 Optimizing access to globals, van Rossum

    These are basically three friendly competing proposals. Jeremy has
    made a little progress with a new compiler, but it's going slow and
    the compiler is only the first step. Maybe we'll be able to refactor
    the compiler in this release. I'm tempted to say we won't hold our
    breath. In the mean time, Oren Tirosh has a much simpler idea that
    may give a serious boost to the performance of accessing globals and
    built-ins, by optimizing and inlining the dict access:
    http://tothink.com/python/fastnames/

-   Lazily tracking tuples?

    -   https://mail.python.org/pipermail/python-dev/2002-May/023926.html
    -   https://bugs.python.org/issue558745

    Not much enthusiasm I believe.

-   PEP 286 Enhanced Argument Tuples, von Loewis

    I haven't had the time to review this thoroughly. It seems a deep
    optimization hack (also makes better correctness guarantees though).

-   Make 'as' a keyword. It has been a pseudo-keyword long enough. Too
    much effort to bother.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
