PEP: 260 Title: Simplify xrange() Version: $Revision$ Last-Modified:
$Date$ Author: guido\@python.org (Guido van Rossum) Status: Final Type:
Standards Track Content-Type: text/x-rst Created: 26-Jun-2001
Python-Version: 2.2 Post-History: 26-Jun-2001

Abstract
========

This PEP proposes to strip the `xrange()` object from some rarely used
behavior like `x[i:j]` and `x*n`.

Problem
=======

The `xrange()` function has one idiomatic use::

    for i in xrange(...): ...

However, the `xrange()` object has a bunch of rarely used behaviors that
attempt to make it more sequence-like. These are so rarely used that
historically they have has serious bugs (e.g. off-by-one errors) that
went undetected for several releases.

I claim that it's better to drop these unused features. This will
simplify the implementation, testing, and documentation, and reduce
maintenance and code size.

Proposed Solution
=================

I propose to strip the `xrange()` object to the bare minimum. The only
retained sequence behaviors are `x[i]`, `len(x)`, and `repr(x)`. In
particular, these behaviors will be dropped:

-   `x[i:j]` (slicing)
-   `x*n`, `n*x` (sequence-repeat)
-   `cmp(x1, x2)` (comparisons)
-   `i in x` (containment test)
-   `x.tolist()` method
-   `x.start`, `x.stop`, `x.step` attributes

I also propose to change the signature of the `PyRange_New()` C API to
remove the 4th argument (the repetition count).

By implementing a custom iterator type, we could speed up the common
use, but this is optional (the default sequence iterator does just
fine).

Scope
=====

This PEP affects the `xrange()` built-in function and the
`PyRange_New()` C API.

Risks
=====

Somebody's code could be relying on the extended code, and this code
would break. However, given that historically bugs in the extended code
have gone undetected for so long, it's unlikely that much code is
affected.

Transition
==========

For backwards compatibility, the existing functionality will still be
present in Python 2.2, but will trigger a warning. A year after Python
2.2 final is released (probably in 2.4) the functionality will be ripped
out.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
