PEP: 233 Title: Python Online Help Version: $Revision$ Last-Modified:
$Date$ Author: paul\@prescod.net (Paul Prescod) Status: Deferred Type:
Standards Track Content-Type: text/x-rst Created: 11-Dec-2000
Python-Version: 2.1 Post-History:

Abstract
========

This PEP describes a command-line driven online help facility for
Python. The facility should be able to build on existing documentation
facilities such as the Python documentation and docstrings. It should
also be extensible for new types and modules.

Interactive use
===============

Simply typing `help` describes the help function (through `repr()`
overloading).

`help` can also be used as a function.

The function takes the following forms of input:

-   `help( "string" )` -- built-in topic or global
-   `help( <ob> )` -- docstring from object or type
-   `help( "doc:filename" )` -- filename from Python documentation

If you ask for a global, it can be a fully-qualified name, such as::

    help("xml.dom")

You can also use the facility from a command-line::

    python --help if

In either situation, the output does paging similar to the `more`
command.

Implementation
==============

The help function is implemented in an `onlinehelp` module which is
demand-loaded.

There should be options for fetching help information from environments
other than the command line through the `onlinehelp` module::

    onlinehelp.gethelp(object_or_string) -> string

It should also be possible to override the help display function by
assigning to `onlinehelp.displayhelp(object_or_string)`.

The module should be able to extract module information from either the
HTML or LaTeX versions of the Python documentation. Links should be
accommodated in a "lynx-like" manner.

Over time, it should also be able to recognize when docstrings are in
"special" syntaxes like structured text, HTML and LaTeX and decode them
appropriately.

A prototype implementation is available with the Python source
distribution as `nondist/sandbox/doctools/onlinehelp.py`.

Built-in Topics
===============

-   `help( "intro" )` -- What is Python? Read this first!

-   `help( "keywords" )` -- What are the keywords?

-   `help( "syntax" )` -- What is the overall syntax?

-   `help( "operators" )` -- What operators are available?

-   `help( "builtins" )` -- What functions, types, etc. are built-in?

-   `help( "modules" )` -- What modules are in the standard library?

-   `help( "copyright" )` -- Who owns Python?

-   `help( "moreinfo" )` -- Where is there more information?

-   `help( "changes" )` -- What changed in Python 2.0?

-   `help( "extensions" )` -- What extensions are installed?

-   `help( "faq" )` -- What questions are frequently asked?

-   `help( "ack" )` -- Who has done work on Python lately?

Security Issues
===============

This module will attempt to import modules with the same names as
requested topics. Don't use the modules if you are not confident that
everything in your `PYTHONPATH` is from a trusted source.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
