PEP: 42 Title: Feature Requests Version: $Revision$ Last-Modified:
$Date$ Author: Jeremy Hylton <jeremy@alum.mit.edu> Status: Rejected
Type: Process Content-Type: text/x-rst Created: 12-Sep-2000
Post-History: Resolution:
https://github.com/python/peps/pull/108\#issuecomment-249603204

.. note:: This PEP has been rejected as obsolete. All new feature
requests should either go to the `Python bug tracker`* for very simple
requests or the `python-ideas`* mailing list for everything else. The
rest of this document is retained for historical purposes only.

Introduction
============

This PEP contains a list of feature requests that may be considered for
future versions of Python. Large feature requests should not be included
here, but should be described in separate PEPs; however a large feature
request that doesn't have its own PEP can be listed here until its own
PEP is created. See PEP 0 for details.

This PEP was created to allow us to close bug reports that are really
feature requests. Marked as Open, they distract from the list of real
bugs (which should ideally be less than a page). Marked as Closed, they
tend to be forgotten. The procedure now is: if a bug report is really a
feature request, add the feature request to this PEP; mark the bug as
"feature request", "later", and "closed"; and add a comment to the bug
saying that this is the case (mentioning the PEP explicitly). It is also
acceptable to move large feature requests directly from the bugs
database to a separate PEP.

This PEP should really be separated into four different categories
(categories due to Laura Creighton):

1.  BDFL rejects as a bad idea. Don't come back with it.

2.  BDFL will put in if somebody writes the code. (Or at any rate, BDFL
    will say 'change this and I will put it in' if you show up with
    code.)

    possibly divided into:

    a)  BDFL would really like to see some code!

    b)  BDFL is never going to be enthusiastic about this, but will work
        it in when it's easy.

3.  If you show up with code, BDFL will make a pronouncement. It might
    be ICK.

4.  This is too vague. This is rejected, but only on the grounds of
    vagueness. If you like this enhancement, make a new PEP.

Core Language / Builtins
========================

-   The parser should handle more deeply nested parse trees.

    The following will fail -- `eval("["*50` + `"]"*50)` -- because the
    parser has a hard-coded limit on stack size. This limit should be
    raised or removed. Removal would be hard because the current
    compiler can overflow the C stack if the nesting is too deep.

    https://bugs.python.org/issue215555

-   Non-accidental IEEE-754 support (Infs, NaNs, settable traps, etc).
    Big project.

-   Windows: Trying to create (or even access) files with certain magic
    names can hang or crash Windows systems. This is really a bug in the
    OSes, but some apps try to shield users from it. When it happens,
    the symptoms are very confusing.

    Hang using files named prn.txt, etc
    https://bugs.python.org/issue481171

-   eval and free variables: It might be useful if there was a way to
    pass bindings for free variables to eval when a code object with
    free variables is passed. https://bugs.python.org/issue443866

Standard Library
================

-   The urllib module should support proxies which require
    authentication. See SourceForge bug \#210619 for information:

    https://bugs.python.org/issue210619

-   os.rename() should be modified to handle EXDEV errors on platforms
    that don't allow rename() to operate across filesystem boundaries by
    copying the file over and removing the original. Linux is one system
    that requires this treatment.

    https://bugs.python.org/issue212317

-   signal handling doesn't always work as expected. E.g. if
    sys.stdin.readline() is interrupted by a (returning) signal handler,
    it returns \"\". It would be better to make it raise an exception
    (corresponding to EINTR) or to restart. But these changes would have
    to applied to all places that can do blocking interruptable I/O. So
    it's a big project.

    https://bugs.python.org/issue210599

-   Extend Windows utime to accept directory paths.

    https://bugs.python.org/issue214245

-   Extend copy.py to module & function types.

    https://bugs.python.org/issue214553

-   Better checking for bad input to `marshal.load*().`

    https://bugs.python.org/issue214754

-   rfc822.py should be more lenient than the spec in the types of
    address fields it parses. Specifically, an invalid address of the
    form "From: Amazon.com <delivers-news2@amazon.com>" should be parsed
    correctly.

    https://bugs.python.org/issue210678

-   cgi.py's FieldStorage class should be more conservative with memory
    in the face of large binary file uploads.

    https://bugs.python.org/issue210674

    There are two issues here: first, because
    read\_lines\_to\_outerboundary() uses readline() it is possible that
    a large amount of data will be read into memory for a binary file
    upload. This should probably look at the Content-Type header of the
    section and do a chunked read if it's a binary type.

    The second issue was related to the self.lines attribute, which was
    removed in revision 1.56 of cgi.py (see also):

    https://bugs.python.org/issue219806

-   urllib should support proxy definitions that contain just the host
    and port

    https://bugs.python.org/issue210849

-   urlparse should be updated to comply with RFC 2396, which defines
    optional parameters for each segment of the path.

    https://bugs.python.org/issue210834

-   The exceptions raised by pickle and cPickle are currently different;
    these should be unified (probably the exceptions should be defined
    in a helper module that's imported by both). \[No bug report; I just
    thought of this.\]

-   More standard library routines should support Unicode. For example,
    urllib.quote() could convert Unicode strings to UTF-8 and then do
    the usual %HH conversion. But this is not the only one!

    https://bugs.python.org/issue216716

-   There should be a way to say that you don't mind if `str()` or
    `__str__()` return a Unicode string object. Or a different function
    -- `ustr()` has been proposed. Or something...

    http://sf.net/patch/?func=detailpatch&patch\_id=101527&group\_id=5470

-   Killing a thread from another thread. Or maybe sending a signal. Or
    maybe raising an asynchronous exception.

    https://bugs.python.org/issue221115

-   The debugger (pdb) should understand packages.

    https://bugs.python.org/issue210631

-   Jim Fulton suggested the following:

    ::

    I wonder if it would be a good idea to have a new kind of temporary
    file that stored data in memory unless:

    -   The data exceeds some size, or

    -   Somebody asks for a fileno.

    Then the cgi module (and other apps) could use this thing in a
    uniform way.

    https://bugs.python.org/issue415692

-   Jim Fulton pointed out that binascii's b2a\_base64() function has
    situations where it makes sense not to append a newline, or to
    append something else than a newline.

    Proposal:

    -   add an optional argument giving the delimiter string to be
        appended, defaulting to "\\n"

    -   possibly special-case None as the delimiter string to avoid
        adding the pad bytes too???

    https://bugs.python.org/issue415694

-   pydoc should be integrated with the HTML docs, or at least be able
    to link to them.

    https://bugs.python.org/issue405554

-   Distutils should deduce dependencies for .c and .h files.

    https://bugs.python.org/issue472881

-   asynchat is buggy in the face of multithreading.

    https://bugs.python.org/issue595217

-   It would be nice if the higher level modules (httplib, smtplib,
    nntplib, etc.) had options for setting socket timeouts.

    https://bugs.python.org/issue723287

-   The curses library is missing two important calls: newterm() and
    delscreen()

    https://bugs.python.org/issue665572, http://bugs.debian.org/175590

-   It would be nice if the built-in SSL socket type could be used for
    non-blocking SSL I/O. Currently packages such as Twisted which
    implement async servers using SSL have to require third-party
    packages such as pyopenssl.

-   reST as a standard library module

-   The import lock could use some redesign.

    https://bugs.python.org/issue683658

-   A nicer API to open text files, replacing the ugly (in some people's
    eyes) "U" mode flag. There's a proposal out there to have a new
    built-in type textfile(filename, mode, encoding). (Shouldn't it have
    a bufsize argument too?)

-   Support new widgets and/or parameters for Tkinter

-   For a class defined inside another class, the **name** should be
    "outer.inner", and pickling should work. (GvR is no longer certain
    this is easy or even right.)

    https://bugs.python.org/issue633930

-   Decide on a clearer deprecation policy (especially for modules) and
    act on it.

    https://mail.python.org/pipermail/python-dev/2002-April/023165.html

-   Provide alternatives for common uses of the types module; Skip
    Montanaro has posted a proto-PEP for this idea:

    https://mail.python.org/pipermail/python-dev/2002-May/024346.html

-   Use pending deprecation for the types and string modules. This
    requires providing alternatives for the parts that aren't covered
    yet (e.g. string.whitespace and types.TracebackType). It seems we
    can't get consensus on this.

-   Lazily tracking tuples?

    https://mail.python.org/pipermail/python-dev/2002-May/023926.html
    https://bugs.python.org/issue558745

-   Make 'as' a keyword. It has been a pseudo-keyword long enough. (It's
    deprecated in 2.5, and will become a keyword in 2.6.)

C API wishes
============

-   Add C API functions to help Windows users who are building embedded
    applications where the FILE \* structure does not match the FILE \*
    the interpreter was compiled with.

    https://bugs.python.org/issue210821

    See this bug report for a specific suggestion that will allow a
    Borland C++ builder application to interact with a python.dll build
    with MSVC.

Tools
=====

-   Python could use a GUI builder.

    https://bugs.python.org/issue210820

Building and Installing
=======================

-   Modules/makesetup should make sure the 'config.c' file it generates
    from the various Setup files, is valid C. It currently accepts
    module names with characters that are not allowable in Python or C
    identifiers.

    https://bugs.python.org/issue216326

-   Building from source should not attempt to overwrite the
    Include/graminit.h and Parser/graminit.c files, at least for people
    downloading a source release rather than working from Subversion or
    snapshots. Some people find this a problem in unusual build
    environments.

    https://bugs.python.org/issue219221

-   The configure script has probably grown a bit crufty with age and
    may not track autoconf's more recent features very well. It should
    be looked at and possibly cleaned up.

    https://mail.python.org/pipermail/python-dev/2004-January/041790.html

-   Make Python compliant to the FHS (the Filesystem Hierarchy Standard)

    http://bugs.python.org/issue588756

.. *`Python bug tracker`: https://bugs.python.org .. *`python-ideas`:
https://mail.python.org/mailman/listinfo/python-ideas

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
