PEP: 12 Title: Sample reStructuredText PEP Template Author: David
Goodger \<<goodger@python.org>\>, Barry Warsaw \<<barry@python.org>\>,
Brett Cannon \<<brett@python.org>\> Status: Active Type: Process
Content-Type: text/x-rst Created: 05-Aug-2002 Post-History: 30-Aug-2002

::: {.note}
::: {.admonition-title}
Note
:::

For those who have written a PEP before, there is a
[template](#template).
:::

Abstract
========

This PEP provides a boilerplate or sample template for creating your own
reStructuredText PEPs. In conjunction with the content guidelines in PEP
1[^1], this should make it easy for you to conform your own PEPs to the
format outlined below.

Note: if you are reading this PEP via the web, you should first grab the
text (reStructuredText) source of this PEP in order to complete the
steps below. **DO NOT USE THE HTML FILE AS YOUR TEMPLATE!**

The source for this (or any) PEP can be found in the PEPs repository,
viewable on the web at <https://github.com/python/peps/> .

Rationale
=========

If you intend to submit a PEP, you MUST use this template, in
conjunction with the format guidelines below, to ensure that your PEP
submission won\'t get automatically rejected because of form.

ReStructuredText provides PEP authors with useful functionality and
expressivity, while maintaining easy readability in the source text. The
processed HTML form makes the functionality accessible to readers: live
hyperlinks, styled text, tables, images, and automatic tables of
contents, among other advantages.

How to Use This Template
========================

To use this template you must first decide whether your PEP is going to
be an Informational or Standards Track PEP. Most PEPs are Standards
Track because they propose a new feature for the Python language or
standard library. When in doubt, read PEP 1 for details or contact the
PEP editors \<<peps@python.org>\>.

Once you\'ve decided which type of PEP yours is going to be, follow the
directions below.

-   Make a copy of this file (`.txt` or `.rst` file, **not** HTML!) and
    perform the following edits. Prefer `.rst` extensions as this will
    allow PEPs to be rendered on GitHub. `.txt` extensions still exists
    for legacy reasons.
-   Replace the \"PEP: 12\" header with \"PEP: 9999\" since you don\'t
    yet have a PEP number assignment.
-   Change the Title header to the title of your PEP.
-   Leave the Version and Last-Modified headers alone; we\'ll take care
    of those when we check your PEP into Python\'s Subversion
    repository. These headers consist of keywords (\"Revision\" and
    \"Date\" enclosed in \"\$\"-signs) which are automatically expanded
    by the repository. Please do not edit the expanded date or revision
    text.
-   Change the Author header to include your name, and optionally your
    email address. Be sure to follow the format carefully: your name
    must appear first, and it must not be contained in parentheses. Your
    email address may appear second (or it can be omitted) and if it
    appears, it must appear in angle brackets. It is okay to obfuscate
    your email address.
-   If none of the authors are Python core developers and this PEP is
    ready to be submitted to the PEP repository, include a Sponsor
    header with the name of the core developer sponsoring your PEP.
-   If there is a mailing list for discussion of your new feature, add a
    Discussions-To header right after the Author header. You should not
    add a Discussions-To header if the mailing list to be used is either
    <python-ideas@python.org> or <python-dev@python.org>, or if
    discussions should be sent to you directly. Most Informational PEPs
    don\'t have a Discussions-To header.
-   Change the Status header to \"Draft\".
-   For Standards Track PEPs, change the Type header to \"Standards
    Track\".
-   For Informational PEPs, change the Type header to \"Informational\".
-   For Standards Track PEPs, if your feature depends on the acceptance
    of some other currently in-development PEP, add a Requires header
    right after the Type header. The value should be the PEP number of
    the PEP yours depends on. Don\'t add this header if your dependent
    feature is described in a Final PEP.
-   Change the Created header to today\'s date. Be sure to follow the
    format carefully: it must be in `dd-mmm-yyyy` format, where the
    `mmm` is the 3 English letter month abbreviation, i.e. one of Jan,
    Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec.
-   For Standards Track PEPs, after the Created header, add a
    Python-Version header and set the value to the next planned version
    of Python, i.e. the one your new feature will hopefully make its
    first appearance in. Do not use an alpha or beta release designation
    here. Thus, if the last version of Python was 2.2 alpha 1 and
    you\'re hoping to get your new feature into Python 2.2, set the
    header to:

        Python-Version: 2.2

-   Leave Post-History alone for now; you\'ll add dates to this header
    each time you post your PEP to <python-ideas@python.org> and/or
    <python-dev@python.org>. If you posted your PEP to the lists on
    August 14, 2001 and September 3, 2001, the Post-History header would
    look like:

        Post-History: 14-Aug-2001, 03-Sept-2001

    You must manually add new dates and check them in. If you don\'t
    have check-in privileges, send your changes to the PEP editors.

-   Add a Replaces header if your PEP obsoletes an earlier PEP. The
    value of this header is the number of the PEP that your new PEP is
    replacing. Only add this header if the older PEP is in \"final\"
    form, i.e. is either Accepted, Final, or Rejected. You aren\'t
    replacing an older open PEP if you\'re submitting a competing idea.
-   Now write your Abstract, Rationale, and other content for your PEP,
    replacing all this gobbledygook with your own text. Be sure to
    adhere to the format guidelines below, specifically on the
    prohibition of tab characters and the indentation requirements. See
    \"Suggested Sections\" below for a template of sections to include.
-   Update your References and Copyright section. Usually you\'ll place
    your PEP into the public domain, in which case just leave the
    Copyright section alone. Alternatively, you can use the [Open
    Publication License]{.title-ref}\_\_, but public domain is still
    strongly preferred.

    \_\_ <http://www.opencontent.org/openpub/>

-   Leave the Emacs stanza at the end of this file alone, including the
    formfeed character (\"\^L\", or `\f`).
-   Send your PEP submission to the PEP editors at <peps@python.org>.

For reference, here are all of the possible header fields (everything in
brackets should either be replaced or have the field removed if it has a
leading `*` marking it as optional and it does not apply to your PEP):

    PEP: [NNN]
    Title: [...]
    Author: [Full Name <email at example.com>]
    Sponsor: *[Full Name <email at example.com>]
    BDFL-Delegate:
    Discussions-To: *[...]
    Status: Draft
    Type: [Standards Track | Informational | Process]
    Content-Type: text/x-rst
    Requires: *[NNN]
    Created: [YYYY-MM-DD]
    Python-Version: [M.N]
    Post-History: [YYYY-MM-DD]
    Replaces: *[NNN]
    Superceded-By: *[NNN]
    Resolution:

ReStructuredText PEP Formatting Requirements
============================================

The following is a PEP-specific summary of reStructuredText syntax. For
the sake of simplicity and brevity, much detail is omitted. For more
detail, see [Resources](#resources) below. [Literal
blocks](#literal-blocks) (in which no markup processing is done) are
used for examples throughout, to illustrate the plaintext markup.

General
-------

You must adhere to the Emacs convention of adding two spaces at the end
of every sentence. You should fill your paragraphs to column 70, but
under no circumstances should your lines extend past column 79. If your
code samples spill over column 79, you should rewrite them.

Tab characters must never appear in the document at all. A PEP should
include the standard Emacs stanza included by example at the bottom of
this PEP.

Section Headings
----------------

PEP headings must begin in column zero and the initial letter of each
word must be capitalized as in book titles. Acronyms should be in all
capitals. Section titles must be adorned with an underline, a single
repeated punctuation character, which begins in column zero and must
extend at least as far as the right edge of the title text (4 characters
minimum). First-level section titles are underlined with \"=\" (equals
signs), second-level section titles with \"-\" (hyphens), and
third-level section titles with \"\'\" (single quotes or apostrophes).
For example:

    First-Level Title
    =================

    Second-Level Title
    ------------------

    Third-Level Title
    '''''''''''''''''

If there are more than three levels of sections in your PEP, you may
insert overline/underline-adorned titles for the first and second levels
as follows:

    ============================
    First-Level Title (optional)
    ============================

    -----------------------------
    Second-Level Title (optional)
    -----------------------------

    Third-Level Title
    =================

    Fourth-Level Title
    ------------------

    Fifth-Level Title
    '''''''''''''''''

You shouldn\'t have more than five levels of sections in your PEP. If
you do, you should consider rewriting it.

You must use two blank lines between the last line of a section\'s body
and the next section heading. If a subsection heading immediately
follows a section heading, a single blank line in-between is sufficient.

The body of each section is not normally indented, although some
constructs do use indentation, as described below. Blank lines are used
to separate constructs.

Paragraphs
----------

Paragraphs are left-aligned text blocks separated by blank lines.
Paragraphs are not indented unless they are part of an indented
construct (such as a block quote or a list item).

Inline Markup
-------------

Portions of text within paragraphs and other text blocks may be styled.
For example:

    Text may be marked as *emphasized* (single asterisk markup,
    typically shown in italics) or **strongly emphasized** (double
    asterisks, typically boldface).  ``Inline literals`` (using double
    backquotes) are typically rendered in a monospaced typeface.  No
    further markup recognition is done within the double backquotes,
    so they're safe for any kind of code snippets.

Block Quotes
------------

Block quotes consist of indented body elements. For example:

    This is a paragraph.

        This is a block quote.

        A block quote may contain many paragraphs.

Block quotes are used to quote extended passages from other sources.
Block quotes may be nested inside other body elements. Use 4 spaces per
indent level.

Literal Blocks
--------------

Literal blocks are used for code samples or preformatted ASCII art. To
indicate a literal block, preface the indented text block with \"`::`\"
(two colons). The literal block continues until the end of the
indentation. Indent the text block by 4 spaces. For example:

    This is a typical paragraph.  A literal block follows.

    ::

        for a in [5,4,3,2,1]:   # this is program code, shown as-is
            print a
        print "it's..."
        # a literal block continues until the indentation ends

The paragraph containing only \"`::`\" will be completely removed from
the output; no empty paragraph will remain. \"`::`\" is also recognized
at the end of any paragraph. If immediately preceded by whitespace, both
colons will be removed from the output. When text immediately precedes
the \"`::`\", *one* colon will be removed from the output, leaving only
one colon visible (i.e., \"`::`\" will be replaced by \"`:`\"). For
example, one colon will remain visible here:

    Paragraph::

        Literal block

Lists
-----

Bullet list items begin with one of \"-\", \"\*\", or \"+\" (hyphen,
asterisk, or plus sign), followed by whitespace and the list item body.
List item bodies must be left-aligned and indented relative to the
bullet; the text immediately after the bullet determines the
indentation. For example:

    This paragraph is followed by a list.

    * This is the first bullet list item.  The blank line above the
      first list item is required; blank lines between list items
      (such as below this paragraph) are optional.

    * This is the first paragraph in the second item in the list.

      This is the second paragraph in the second item in the list.
      The blank line above this paragraph is required.  The left edge
      of this paragraph lines up with the paragraph above, both
      indented relative to the bullet.

      - This is a sublist.  The bullet lines up with the left edge of
        the text blocks above.  A sublist is a new list so requires a
        blank line above and below.

    * This is the third item of the main list.

    This paragraph is not part of the list.

Enumerated (numbered) list items are similar, but use an enumerator
instead of a bullet. Enumerators are numbers (1, 2, 3, \...), letters
(A, B, C, \...; uppercase or lowercase), or Roman numerals (i, ii, iii,
iv, \...; uppercase or lowercase), formatted with a period suffix
(\"1.\", \"2.\"), parentheses (\"(1)\", \"(2)\"), or a right-parenthesis
suffix (\"1)\", \"2)\"). For example:

    1. As with bullet list items, the left edge of paragraphs must
       align.

    2. Each list item may contain multiple paragraphs, sublists, etc.

       This is the second paragraph of the second list item.

       a) Enumerated lists may be nested.
       b) Blank lines may be omitted between list items.

Definition lists are written like this:

    what
        Definition lists associate a term with a definition.

    how
        The term is a one-line phrase, and the definition is one
        or more paragraphs or body elements, indented relative to
        the term.

Tables
------

Simple tables are easy and compact:

    =====  =====  =======
      A      B    A and B
    =====  =====  =======
    False  False  False
    True   False  False
    False  True   False
    True   True   True
    =====  =====  =======

There must be at least two columns in a table (to differentiate from
section titles). Column spans use underlines of hyphens (\"Inputs\"
spans the first two columns):

    =====  =====  ======
       Inputs     Output
    ------------  ------
      A      B    A or B
    =====  =====  ======
    False  False  False
    True   False  True
    False  True   True
    True   True   True
    =====  =====  ======

Text in a first-column cell starts a new row. No text in the first
column indicates a continuation line; the rest of the cells may consist
of multiple lines. For example:

    =====  =========================
    col 1  col 2
    =====  =========================
    1      Second column of row 1.
    2      Second column of row 2.
           Second line of paragraph.
    3      - Second column of row 3.

           - Second item in bullet
             list (row 3, column 2).
    =====  =========================

Hyperlinks
----------

When referencing an external web page in the body of a PEP, you should
include the title of the page in the text, with either an inline
hyperlink reference to the URL or a footnote reference (see
[Footnotes](#footnotes) below). Do not include the URL in the body text
of the PEP.

Hyperlink references use backquotes and a trailing underscore to mark up
the reference text; backquotes are optional if the reference text is a
single word. For example:

    In this paragraph, we refer to the `Python web site`_.

An explicit target provides the URL. Put targets in a References section
at the end of the PEP, or immediately after the reference. Hyperlink
targets begin with two periods and a space (the \"explicit markup
start\"), followed by a leading underscore, the reference text, a colon,
and the URL (absolute or relative):

    .. _Python web site: http://www.python.org/

The reference text and the target text must match (although the match is
case-insensitive and ignores differences in whitespace). Note that the
underscore trails the reference text but precedes the target text. If
you think of the underscore as a right-pointing arrow, it points *away*
from the reference and *toward* the target.

The same mechanism can be used for internal references. Every unique
section title implicitly defines an internal hyperlink target. We can
make a link to the Abstract section like this:

    Here is a hyperlink reference to the `Abstract`_ section.  The
    backquotes are optional since the reference text is a single word;
    we can also just write: Abstract_.

Footnotes containing the URLs from external targets will be generated
automatically at the end of the References section of the PEP, along
with footnote references linking the reference text to the footnotes.

Text of the form \"PEP x\" or \"RFC x\" (where \"x\" is a number) will
be linked automatically to the appropriate URLs.

Footnotes
---------

Footnote references consist of a left square bracket, a number, a right
square bracket, and a trailing underscore:

    This sentence ends with a footnote reference [1]_.

Whitespace must precede the footnote reference. Leave a space between
the footnote reference and the preceding word.

When referring to another PEP, include the PEP number in the body text,
such as \"PEP 1\". The title may optionally appear. Add a footnote
reference following the title. For example:

    Refer to PEP 1 [2]_ for more information.

Add a footnote that includes the PEP\'s title and author. It may
optionally include the explicit URL on a separate line, but only in the
References section. Footnotes begin with \".. \" (the explicit markup
start), followed by the footnote marker (no underscores), followed by
the footnote body. For example:

    References
    ==========

    .. [2] PEP 1, "PEP Purpose and Guidelines", Warsaw, Hylton
       (http://www.python.org/dev/peps/pep-0001)

If you decide to provide an explicit URL for a PEP, please use this as
the URL template:

    http://www.python.org/dev/peps/pep-xxxx

PEP numbers in URLs must be padded with zeros from the left, so as to be
exactly 4 characters wide, however PEP numbers in the text are never
padded.

During the course of developing your PEP, you may have to add, remove,
and rearrange footnote references, possibly resulting in mismatched
references, obsolete footnotes, and confusion. Auto-numbered footnotes
allow more freedom. Instead of a number, use a label of the form
\"\#word\", where \"word\" is a mnemonic consisting of alphanumerics
plus internal hyphens, underscores, and periods (no whitespace or other
characters are allowed). For example:

    Refer to PEP 1 [#PEP-1]_ for more information.

    References
    ==========

    .. [#PEP-1] PEP 1, "PEP Purpose and Guidelines", Warsaw, Hylton

       http://www.python.org/dev/peps/pep-0001

Footnotes and footnote references will be numbered automatically, and
the numbers will always match. Once a PEP is finalized, auto-numbered
labels should be replaced by numbers for simplicity.

Images
------

If your PEP contains a diagram, you may include it in the processed
output using the \"image\" directive:

    .. image:: diagram.png

Any browser-friendly graphics format is possible: .png, .jpeg, .gif,
.tiff, etc.

Since this image will not be visible to readers of the PEP in source
text form, you should consider including a description or ASCII art
alternative, using a comment (below).

Comments
--------

A comment block is an indented block of arbitrary text immediately
following an explicit markup start: two periods and whitespace. Leave
the \"..\" on a line by itself to ensure that the comment is not
misinterpreted as another explicit markup construct. Comments are not
visible in the processed document. For the benefit of those reading your
PEP in source form, please consider including a descriptions of or ASCII
art alternatives to any images you include. For example:

    .. image:: dataflow.png

    ..
       Data flows from the input module, through the "black box"
       module, and finally into (and through) the output module.

The Emacs stanza at the bottom of this document is inside a comment.

Escaping Mechanism
------------------

reStructuredText uses backslashes (\"`\`\") to override the special
meaning given to markup characters and get the literal characters
themselves. To get a literal backslash, use an escaped backslash
(\"`\\`\"). There are two contexts in which backslashes have no special
meaning: [literal blocks](#literal-blocks) and inline literals (see
[Inline Markup](#inline-markup) above). In these contexts, no markup
recognition is done, and a single backslash represents a literal
backslash, without having to double up.

If you find that you need to use a backslash in your text, consider
using inline literals or a literal block instead.

Habits to Avoid
===============

Many programmers who are familiar with TeX often write quotation marks
like this:

    `single-quoted' or ``double-quoted''

Backquotes are significant in reStructuredText, so this practice should
be avoided. For ordinary text, use ordinary \'single-quotes\' or
\"double-quotes\". For inline literal text (see [Inline
Markup](#inline-markup) above), use double-backquotes:

    ``literal text: in here, anything goes!``

Suggested Sections
==================

Various sections are found to be common across PEPs and are outlined in
PEP 1[^2]. Those sections are provided here for convenience.

::: {#template}
    Abstract
    ========

    [A short (~200 word) description of the technical issue being addressed.]


    Motivation
    ==========

    [Clearly explain why the existing language specification is inadequate to address the problem that the PEP solves.]


    Rationale
    =========

    [Describe why particular design decisions were made.]


    Specification
    =============

    [Describe the syntax and semantics of any new language feature.]


    Backwards Compatibility
    =======================

    [Describe potential impact and severity on pre-existing code.]


    Security Implications
    =====================

    [How could a malicious user take advantage of this new feature?]


    How to Teach This
    =================

    [How to teach users, new and experienced, how to apply the PEP to their work.]


    Reference Implementation
    ========================

    [Link to any existing implementation and details about its state, e.g. proof-of-concept.]


    Rejected Ideas
    ==============

    [Why certain ideas that were brought while discussing this PEP were not ultimately pursued.]


    Open Issues
    ===========

    [Any points that are still being decided/discussed.]


    References
    ==========

    [A collection of URLs used as references through the PEP.]


    Copyright
    =========

    This document is placed in the public domain or under the
    CC0-1.0-Universal license, whichever is more permissive.


    
    ..
       Local Variables:
       mode: indented-text
       indent-tabs-mode: nil
       sentence-end-double-space: t
       fill-column: 70
       coding: utf-8
       End:
:::

Resources
=========

Many other constructs and variations are possible. For more details
about the reStructuredText markup, in increasing order of thoroughness,
please see:

-   [A ReStructuredText Primer]{.title-ref}\_\_, a gentle introduction.

    \_\_ <http://docutils.sourceforge.net/docs/rst/quickstart.html>

-   [Quick reStructuredText]{.title-ref}\_\_, a users\' quick reference.

    \_\_ <http://docutils.sourceforge.net/docs/rst/quickref.html>

-   [reStructuredText Markup Specification]{.title-ref}\_\_, the final
    authority.

    \_\_
    <http://docutils.sourceforge.net/spec/rst/reStructuredText.html>

The processing of reStructuredText PEPs is done using
[Docutils](http://docutils.sourceforge.net/). If you have a question or
require assistance with reStructuredText or Docutils, please [post a
message](mailto:docutils-users@lists.sourceforge.net?subject=PEPs) to
the [Docutils-users mailing
list](http://docutils.sf.net/docs/user/mailing-lists.html#docutils-users).
The [Docutils project web site](http://docutils.sourceforge.net/) has
more information.

References
==========

Copyright
=========

This document is placed in the public domain or under the
CC0-1.0-Universal license, whichever is more permissive.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:

[^1]: PEP 1, PEP Purpose and Guidelines, Warsaw, Hylton
    (<http://www.python.org/dev/peps/pep-0001>)

[^2]: PEP 1, PEP Purpose and Guidelines, Warsaw, Hylton
    (<http://www.python.org/dev/peps/pep-0001>)
