PEP: 11 Title: Removing support for little used platforms Version:
$Revision$ Last-Modified: $Date$ Author: Martin von Löwis
<martin@v.loewis.de>, Brett Cannon <brett@python.org> Status: Active
Type: Process Content-Type: text/x-rst Created: 07-Jul-2002
Post-History: 18-Aug-2007 16-May-2014 20-Feb-2015

Abstract
--------

This PEP documents how an operating system (platform) becomes supported
in CPython and documents past support.

Rationale
---------

Over time, the CPython source code has collected various pieces of
platform-specific code, which, at some point in time, was considered
necessary to use Python on a specific platform. Without access to this
platform, it is not possible to determine whether this code is still
needed. As a result, this code may either break during Python's
evolution, or it may become unnecessary as the platforms evolve as well.

The growing amount of these fragments poses the risk of
unmaintainability: without having experts for a large number of
platforms, it is not possible to determine whether a certain change to
the CPython source code will work on all supported platforms.

To reduce this risk, this PEP specifies what is required for a platform
to be considered supported by Python as well as providing a procedure to
remove code for platforms with few or no Python users.

Supporting platforms
--------------------

Gaining official platform support requires two things. First, a core
developer needs to volunteer to maintain platform-specific code. This
core developer can either already be a member of the Python development
team or be given contributor rights on the basis of maintaining platform
support (it is at the discretion of the Python development team to
decide if a person is ready to have such rights even if it is just for
supporting a specific platform).

Second, a stable buildbot must be provided \[2\]\_. This guarantees that
platform support will not be accidentally broken by a Python core
developer who does not have personal access to the platform. For a
buildbot to be considered stable it requires that the machine be
reliably up and functioning (but it is up to the Python core developers
to decide whether to promote a buildbot to being considered stable).

This policy does not disqualify supporting other platforms indirectly.
Patches which are not platform-specific but still done to add platform
support will be considered for inclusion. For example, if
platform-independent changes were necessary in the configure script
which were motivated to support a specific platform that could be
accepted. Patches which add platform-specific code such as the name of a
specific platform to the configure script will generally not be accepted
without the platform having official support.

CPU architecture and compiler support are viewed in a similar manner as
platforms. For example, to consider the ARM architecture supported a
buildbot running on ARM would be required along with support from the
Python development team. In general it is not required to have a CPU
architecture run under every possible platform in order to be considered
supported.

Unsupporting platforms
----------------------

If a certain platform that currently has special code in CPython is
deemed to be without enough Python users or lacks proper support from
the Python development team and/or a buildbot, a note must be posted in
this PEP that this platform is no longer actively supported. This note
must include:

-   the name of the system
-   the first release number that does not support this platform
    anymore, and
-   the first release where the historical support code is actively
    removed

In some cases, it is not possible to identify the specific list of
systems for which some code is used (e.g. when autoconf tests for
absence of some feature which is considered present on all supported
systems). In this case, the name will give the precise condition
(usually a preprocessor symbol) that will become unsupported.

At the same time, the CPython source code must be changed to produce a
build-time error if somebody tries to install Python on this platform.
On platforms using autoconf, configure must fail. This gives potential
users of the platform a chance to step forward and offer maintenance.

Re-supporting platforms
-----------------------

If a user of a platform wants to see this platform supported again, he
may volunteer to maintain the platform support. Such an offer must be
recorded in the PEP, and the user can submit patches to remove the
build-time errors, and perform any other maintenance work for the
platform.

Microsoft Windows
-----------------

Microsoft has established a policy called product support lifecycle
\[1\]\_. Each product's lifecycle has a mainstream support phase, where
the product is generally commercially available, and an extended support
phase, where paid support is still available, and certain bug fixes are
released (in particular security fixes).

CPython's Windows support now follows this lifecycle. A new feature
release X.Y.0 will support all Windows releases whose extended support
phase is not yet expired. Subsequent bug fix releases will support the
same Windows releases as the original feature release (even if the
extended support phase has ended).

Because of this policy, no further Windows releases need to be listed in
this PEP.

Each feature release is built by a specific version of Microsoft Visual
Studio. That version should have mainstream support when the release is
made. Developers of extension modules will generally need to use the
same Visual Studio release; they are concerned both with the
availability of the versions they need to use, and with keeping the zoo
of versions small. The CPython source tree will keep unmaintained build
files for older Visual Studio releases, for which patches will be
accepted. Such build files will be removed from the source tree 3 years
after the extended support for the compiler has ended (but continue to
remain available in revision control).

Legacy C Locale
---------------

Starting with CPython 3.7.0, \*nix platforms are expected to provide at
least one of `C.UTF-8` (full locale), `C.utf8` (full locale) or `UTF-8`
(`LC_CTYPE`-only locale) as an alternative to the legacy `C` locale.

Any Unicode-related integration problems that occur only in the legacy
`C` locale and cannot be reproduced in an appropriately configured
non-ASCII locale will be closed as "won't fix".

No-longer-supported platforms
-----------------------------

-   | Name: MS-DOS, MS-Windows 3.x
    | Unsupported in: Python 2.0
    | Code removed in: Python 2.1

-   | Name: SunOS 4
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: DYNIX
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: dgux
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Minix
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Irix 4 and --with-sgi-dl
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Linux 1
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Systems defining \_\_d6\_pthread\_create (configure.in)
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Systems defining PY\_PTHREAD\_D4, PY\_PTHREAD\_D6, or
      PY\_PTHREAD\_D7 in thread\_pthread.h
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Systems using --with-dl-dld
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: Systems using --without-universal-newlines,
    | Unsupported in: Python 2.3
    | Code removed in: Python 2.4

-   | Name: MacOS 9
    | Unsupported in: Python 2.4
    | Code removed in: Python 2.4

-   | Name: Systems using --with-wctype-functions
    | Unsupported in: Python 2.6
    | Code removed in: Python 2.6

-   | Name: Win9x, WinME, NT4
    | Unsupported in: Python 2.6 (warning in 2.5 installer)
    | Code removed in: Python 2.6

-   | Name: AtheOS
    | Unsupported in: Python 2.6 (with "AtheOS" changed to "Syllable")
    | Build broken in: Python 2.7 (edit configure to reenable)
    | Code removed in: Python 3.0
    | Details: http://www.syllable.org/discussion.php?id=2320

-   | Name: BeOS
    | Unsupported in: Python 2.6 (warning in configure)
    | Build broken in: Python 2.7 (edit configure to reenable)
    | Code removed in: Python 3.0

-   | Name: Systems using Mach C Threads
    | Unsupported in: Python 3.2
    | Code removed in: Python 3.3

-   | Name: SunOS lightweight processes (LWP)
    | Unsupported in: Python 3.2
    | Code removed in: Python 3.3

-   | Name: Systems using --with-pth (GNU pth threads)
    | Unsupported in: Python 3.2
    | Code removed in: Python 3.3

-   | Name: Systems using Irix threads
    | Unsupported in: Python 3.2
    | Code removed in: Python 3.3

-   | Name: OSF\* systems (issue 8606)
    | Unsupported in: Python 3.2
    | Code removed in: Python 3.3

-   | Name: OS/2 (issue 16135)
    | Unsupported in: Python 3.3
    | Code removed in: Python 3.4

-   | Name: VMS (issue 16136)
    | Unsupported in: Python 3.3
    | Code removed in: Python 3.4

-   | Name: Windows 2000
    | Unsupported in: Python 3.3
    | Code removed in: Python 3.4

-   | Name: Windows systems where COMSPEC points to command.com
    | Unsupported in: Python 3.3
    | Code removed in: Python 3.4

-   | Name: RISC OS
    | Unsupported in: Python 3.0 (some code actually removed)
    | Code removed in: Python 3.4

-   | Name: IRIX
    | Unsupported in: Python 3.7
    | Code removed in: Python 3.7

-   | Name: Systems without multithreading support
    | Unsupported in: Python 3.7
    | Code removed in: Python 3.7

References
----------

.. \[1\] http://support.microsoft.com/lifecycle/ .. \[2\]
http://buildbot.python.org/3.x.stable/

Copyright
---------

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
