PEP: 4 Title: Deprecation of Standard Modules Version: $Revision$
Last-Modified: $Date$ Author: Brett Cannon <brett@python.org>, Martin
von Löwis <martin@v.loewis.de> Status: Active Type: Process
Content-Type: text/x-rst Created: 1-Oct-2000 Post-History:

Introduction
============

When new modules were added to the standard Python library in the past,
it was not possible to foresee whether they would still be useful in the
future. Even though Python "Comes With Batteries Included", batteries
may discharge over time. Carrying old modules around is a burden on the
maintainer, especially when there is no interest in the module anymore.

At the same time, removing a module from the distribution is difficult,
as it is not known in general whether anybody is still using it. This
PEP defines a procedure for removing modules from the standard Python
library. Usage of a module may be 'deprecated', which means that it may
be removed from a future Python release. The rationale for deprecating a
module is also collected in this PEP. If the rationale turns out faulty,
the module may become 'undeprecated'.

Procedure for declaring a module deprecated
===========================================

Since the status of module deprecation is recorded in this PEP,
proposals for deprecating modules MUST be made by providing a change to
the text of this PEP.

A proposal for deprecation of the module MUST include the date of the
proposed deprecation and a rationale for deprecating it. In addition,
the proposal MUST include a change to the documentation of the module;
deprecation is indicated by saying that the module is "obsolete" or
"deprecated". The proposal SHOULD include a patch for the module's
source code to indicate deprecation there as well, by raising a
DeprecationWarning. The proposal MUST include patches to remove any use
of the deprecated module from the standard library.

It is expected that deprecated modules are included in the Python
release that immediately follows the deprecation; later releases may
ship without the deprecated modules.

For modules existing in both Python 2.7 and Python 3.5
------------------------------------------------------

In order to facilitate writing code that works in both Python 2 & 3
simultaneously, any module that exists in both Python 3.5 and Python 2.7
will not be removed from the standard library until Python 2.7 is no
longer supported as specified by PEP 373. Exempted from this rule is any
module in the idlelib package as well as any exceptions granted by the
Python development team.

Procedure for declaring a module undeprecated
=============================================

When a module becomes deprecated, a rationale is given for its
deprecation. In some cases, an alternative interface for the same
functionality is provided, so the old interface is deprecated. In other
cases, the need for having the functionality of the module may not exist
anymore.

If the rationale is faulty, again a change to this PEP's text MUST be
submitted. This change MUST include the date of undeprecation and a
rationale for undeprecation. Modules that are undeprecated under this
procedure MUST be listed in this PEP for at least one major release of
Python.

Obsolete modules
================

A number of modules are already listed as obsolete in the library
documentation. These are listed here for completeness.

    cl, sv, timing

All these modules have been declared as obsolete in Python 2.0, some
even earlier.

The following obsolete modules were removed in Python 2.5:

    addpack, cmp, cmpcache, codehack, dircmp, dump, find, fmt,
    grep, lockfile, newdir, ni, packmail, Para, poly,
    rand, reconvert, regex, regsub, statcache, tb, tzparse,
    util, whatsound, whrandom, zmod

The following modules were removed in Python 2.6:

    gopherlib, rgbimg, macfs

The following modules currently lack a DeprecationWarning:

    rfc822, mimetools, multifile

Deprecated modules
==================

::

    Module name:   posixfile
    Rationale:     Locking is better done by fcntl.lockf().
    Date:          Before 1-Oct-2000.
    Documentation: Already documented as obsolete.  Deprecation
                   warning added in Python 2.6.

    Module name:   gopherlib
    Rationale:     The gopher protocol is not in active use anymore.
    Date:          1-Oct-2000.
    Documentation: Documented as deprecated since Python 2.5.  Removed
                   in Python 2.6.

    Module name:   rgbimgmodule
    Rationale:     In a 2001-04-24 c.l.py post, Jason Petrone mentions
                   that he occasionally uses it; no other references to
                   its use can be found as of 2003-11-19.
    Date:          1-Oct-2000
    Documentation: Documented as deprecated since Python 2.5.  Removed
                   in Python 2.6.

    Module name:   pre
    Rationale:     The underlying PCRE engine doesn't support Unicode, and
                   has been unmaintained since Python 1.5.2.
    Date:          10-Apr-2002
    Documentation: It was only mentioned as an implementation detail,
                   and never had a section of its own.   This mention
                   has now been removed.

    Module name:   whrandom
    Rationale:     The module's default seed computation was
                   inherently insecure; the random module should be
                   used instead.
    Date:          11-Apr-2002
    Documentation: This module has been documented as obsolete since
                   Python 2.1, but listing in this PEP was neglected.
                   The deprecation warning will be added to the module
                   one year after Python 2.3 is released, and the
                   module will be removed one year after that.

    Module name:   rfc822
    Rationale:     Supplanted by Python 2.2's email package.
    Date:          18-Mar-2002
    Documentation: Documented as "deprecated since release 2.3" since
                   Python 2.2.2.

    Module name:   mimetools
    Rationale:     Supplanted by Python 2.2's email package.
    Date:          18-Mar-2002
    Documentation: Documented as "deprecated since release 2.3" since
                   Python 2.2.2.

    Module name:   MimeWriter
    Rationale:     Supplanted by Python 2.2's email package.
    Date:          18-Mar-2002
    Documentation: Documented as "deprecated since release 2.3" since
                   Python 2.2.2.  Raises a DeprecationWarning as of
                   Python 2.6.

    Module name:   mimify
    Rationale:     Supplanted by Python 2.2's email package.
    Date:          18-Mar-2002
    Documentation: Documented as "deprecated since release 2.3" since
                   Python 2.2.2.  Raises a DeprecationWarning as of
                   Python 2.6.

    Module name:   rotor
    Rationale:     Uses insecure algorithm.
    Date:          24-Apr-2003
    Documentation: The documentation has been removed from the library
                   reference in Python 2.4.

    Module name:   TERMIOS.py
    Rationale:     The constants in this file are now in the 'termios' module.
    Date:          10-Aug-2004
    Documentation: This module has been documented as obsolete since
                   Python 2.1, but listing in this PEP was neglected.
                   Removed from the library reference in Python 2.4.

    Module name:   statcache
    Rationale:     Using the cache can be fragile and error-prone;
                   applications should just use os.stat() directly.
    Date:          10-Aug-2004
    Documentation: This module has been documented as obsolete since
                   Python 2.2, but listing in this PEP was neglected.
                   Removed from the library reference in Python 2.5.

    Module name:   mpz
    Rationale:     Third-party packages provide similar features
                   and wrap more of GMP's API.
    Date:          10-Aug-2004
    Documentation: This module has been documented as obsolete since
                   Python 2.2, but listing in this PEP was neglected.
                   Removed from the library reference in Python 2.4.

    Module name:   xreadlines
    Rationale:     Using 'for line in file', introduced in 2.3, is preferable.
    Date:          10-Aug-2004
    Documentation: This module has been documented as obsolete since
                   Python 2.3, but listing in this PEP was neglected.
                   Removed from the library reference in Python 2.4.

    Module name:   multifile
    Rationale:     Supplanted by the email package.
    Date:          21-Feb-2006
    Documentation: Documented as deprecated as of Python 2.5.

    Module name:   sets
    Rationale:     The built-in set/frozenset types, introduced in
                   Python 2.4, supplant the module.
    Date:          12-Jan-2007
    Documentation: Documented as deprecated as of Python 2.6.

    Module name:   buildtools
    Rationale:     Unknown.
    Date:          15-May-2007
    Documentation: Documented as deprecated as of Python 2.3, but
                   listing in this PEP was neglected.  Raised a
                   DeprecationWarning as of Python 2.6.

    Module name:   cfmfile
    Rationale:     Unknown.
    Date:          15-May-2007
    Documentation: Documented as deprecated as of Python 2.4, but
                   listing in this PEP was neglected.  A
                   DeprecationWarning was added in Python 2.6.

    Module name:   macfs
    Rationale:     Unknown.
    Date:          15-May-2007
    Documentation: Documented as deprecated as of Python 2.3, but
                   listing in this PEP was neglected.  Removed in
                   Python 2.6.

    Module name:   md5
    Rationale:     Replaced by the 'hashlib' module.
    Date:          15-May-2007
    Documentation: Documented as deprecated as of Python 2.5, but
                   listing in this PEP was neglected.
                   DeprecationWarning raised as of Python 2.6.

    Module name:   sha
    Rationale:     Replaced by the 'hashlib' module.
    Date:          15-May-2007
    Documentation: Documented as deprecated as of Python 2.5, but
                   listing in this PEP was neglected.
                   DeprecationWarning added in Python 2.6.

    Module name:   plat-freebsd2/IN and plat-freebsd3/IN
    Rationale:     Platforms are obsolete (last released in 2000)
                   Removed from 2.6
    Date:          15-May-2007
    Documentation: None

    Module name:   plat-freebsd4/IN and possibly plat-freebsd5/IN
    Rationale:     Platforms are obsolete/unsupported
    Date:          15-May-2007
                   Remove from 2.7
    Documentation: None

    Module name:   imp
    Rationale:     Replaced by the importlib module.
    Date:          2013-02-10
    Documentation: Deprecated as of Python 3.4.

    Module name:   formatter
    Rationale:     Lack of use in the community, no tests to keep
                   code working.
    Date:          2013-08-12
    Documentation: Deprecated as of Python 3.4.

    Module name:   macpath
    Rationale:     Obsolete macpath module dangerously broken
                   and should be removed.
    Date:          2017-05-15
    Documentation: Platform is obsolete/unsupported.

    Module name:   xml.etree.cElementTree
    Rationale:     Obsolete, use xml.etree.ElementTree
    Date:          2019-04-06
    Documentation: Documented as deprecated since 3.3

Deprecation of modules removed in Python 3.0
============================================

PEP 3108 lists all modules that have been removed from Python 3.0. They
all are documented as deprecated in Python 2.6, and raise a
DeprecationWarning if the -3 flag is activated.

Undeprecated modules
====================

None.

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
