PEP: 2 Title: Procedure for Adding New Modules Version: $Revision$
Last-Modified: $Date$ Author: Martijn Faassen <faassen@infrae.com>
Status: Final Type: Process Content-Type: text/x-rst Created:
07-Jul-2001 Post-History: 07-Jul-2001, 09-Mar-2002

PEP Replacement
===============

This PEP has been superseded by the updated material in the Python
Developer's Guide \[1\]\_.

Introduction
============

The Python Standard Library contributes significantly to Python's
success. The language comes with "batteries included", so it is easy for
people to become productive with just the standard library alone. It is
therefore important that this library grows with the language, and that
such growth is supported and encouraged.

Many contributions to the library are not created by core developers but
by people from the Python community who are experts in their particular
field. Furthermore, community members are also the users of the standard
library, applying it in a great diversity of settings. This makes the
community well equipped to detect and report gaps in the library; things
that are missing but should be added.

New functionality is commonly added to the library in the form of new
modules. This PEP will describe the procedure for the *addition* of new
modules. PEP 4 deals with procedures for deprecation of modules; the
*removal* of old and unused modules from the standard library. Finally
there is also the issue of *changing* existing modules to make the
picture of library evolution complete. PEP 3 and PEP 5 give some
guidelines on this. The continued maintenance of existing modules is an
integral part of the decision on whether to add a new module to the
standard library. Therefore, this PEP also introduces concepts
(integrators, maintainers) relevant to the maintenance issue.

Integrators
===========

The integrators are a group of people with the following
responsibilities:

-   They determine if a proposed contribution should become part of the
    standard library.

-   They integrate accepted contributions into the standard library.

-   They produce standard library releases.

This group of people shall be PythonLabs, led by Guido.

Maintainer(s)
=============

All contributions to the standard library need one or more maintainers.
This can be an individual, but it is frequently a group of people such
as the XML- SIG. Groups may subdivide maintenance tasks among
themselves. One ore more maintainers shall be the *head maintainer*
(usually this is also the main developer). Head maintainers are
convenient people the integrators can address if they want to resolve
specific issues, such as the ones detailed later in this document.

Developers(s)
=============

Contributions to the standard library have been developed by one or more
developers. The initial maintainers are the original developers unless
there are special circumstances (which should be detailed in the PEP
proposing the contribution).

Acceptance Procedure
====================

When developers wish to have a contribution accepted into the standard
library, they will first form a group of maintainers (normally initially
consisting of themselves).

Then, this group shall produce a PEP called a library PEP. A library PEP
is a special form of standards track PEP. The library PEP gives an
overview of the proposed contribution, along with the proposed
contribution as the reference implementation. This PEP should also
contain a motivation on why this contribution should be part of the
standard library.

One or more maintainers shall step forward as PEP champion (the people
listed in the Author field are the champions). The PEP champion(s) shall
be the initial head maintainer(s).

As described in PEP 1, a standards track PEP should consist of a design
document and a reference implementation. The library PEP differs from a
normal standard track PEP in that the reference implementation should in
this case always already have been written before the PEP is to be
reviewed for inclusion by the integrators and to be commented upon by
the community; the reference implementation *is* the proposed
contribution.

This different requirement exists for the following reasons:

-   The integrators can only properly evaluate a contribution to the
    standard library when there is source code and documentation to look
    at; i.e. the reference implementation is always necessary to aid
    people in studying the PEP.

-   Even rejected contributions will be useful outside the standard
    library, so there will a lower risk of waste of effort by the
    developers.

-   It will impress the integrators of the seriousness of contribution
    and will help guard them against having to evaluate too many
    frivolous proposals.

Once the library PEP has been submitted for review, the integrators will
then evaluate it. The PEP will follow the normal PEP work flow as
described in PEP 1. If the PEP is accepted, they will work through the
head maintainers to make the contribution ready for integration.

Maintenance Procedure
=====================

After a contribution has been accepted, the job is not over for both
integrators and maintainers. The integrators will forward any bug
reports in the standard library to the appropriate head maintainers.

Before the feature freeze preparing for a release of the standard
library, the integrators will check with the head maintainers for all
contributions, to see if there are any updates to be included in the
next release. The integrators will evaluate any such updates for issues
like backwards compatibility and may require PEPs if the changes are
deemed to be large.

The head maintainers should take an active role in keeping up to date
with the Python development process. If a head maintainer is unable to
function in this way, he or she should announce the intention to step
down to the integrators and the rest of the maintainers, so that a
replacement can step forward. The integrators should at all times be
capable of reaching the head maintainers by email.

In the case where no head maintainer can be found (possibly because
there are no maintainers left), the integrators will issue a call to the
community at large asking for new maintainers to step forward. If no one
does, the integrators can decide to declare the contribution deprecated
as described in PEP 4.

Open issues
===========

There needs to be some procedure so that the integrators can always
reach the maintainers (or at least the head maintainers). This could be
accomplished by a mailing list to which all head maintainers should be
subscribed (this could be python-dev). Another possibility, which may be
useful in any case, is the maintenance of a list similar to that of the
list of PEPs which lists all the contributions and their head
maintainers with contact info. This could in fact be part of the list of
the PEPs, as a new contribution requires a PEP. But since the
authors/owners of a PEP introducing a new module may eventually be
different from those who maintain it, this wouldn't resolve all issues
yet.

Should there be a list of what criteria integrators use for evaluating
contributions? (Source code but also things like documentation and a
test suite, as well as such vague things like 'dependability of the
maintainers'.)

This relates to all the technical issues; check-in privileges, coding
style requirements, documentation requirements, test suite requirements.
These are preferably part of another PEP.

Should the current standard library be subdivided among maintainers?
Many parts already have (informal) maintainers; it may be good to make
this more explicit.

Perhaps there is a better word for 'contribution'; the word
'contribution' may not imply enough that the process (of development and
maintenance) does not stop after the contribution is accepted and
integrated into the library.

Relationship to the mythical Catalog?

References
==========

.. \[1\] Adding to the Stdlib
(http://docs.python.org/devguide/stdlibchanges.html)

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
fill-column: 70 coding: utf-8 End:
