# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class WeatherConditionsMessage(DataMessage):
    ID = 128
    NAME = 'weather_conditions'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=WeatherConditionsMessage.NAME,
                         global_id=WeatherConditionsMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsWeatherReportField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsWeatherReportField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsTemperatureField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsTemperatureField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsConditionField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsConditionField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsWindDirectionField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsWindDirectionField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsWindSpeedField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsWindSpeedField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsPrecipitationProbabilityField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsPrecipitationProbabilityField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsTemperatureFeelsLikeField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsTemperatureFeelsLikeField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsRelativeHumidityField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsRelativeHumidityField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsLocationField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsLocationField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsObservedAtTimeField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsObservedAtTimeField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsObservedLocationLatField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsObservedLocationLatField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsObservedLocationLongField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsObservedLocationLongField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsDayOfWeekField(
                                 size=self.__get_field_size(definition_message, WeatherConditionsDayOfWeekField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsHighTemperatureField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsHighTemperatureField.ID),
                                 growable=definition_message is None),
                             WeatherConditionsLowTemperatureField(
                                 size=self.__get_field_size(definition_message,
                                                            WeatherConditionsLowTemperatureField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def weather_report(self) -> Optional[WeatherReport]:
        field = self.get_field(WeatherConditionsWeatherReportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @weather_report.setter
    def weather_report(self, value: WeatherReport):
        field = self.get_field(WeatherConditionsWeatherReportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature.setter
    def temperature(self, value: int):
        field = self.get_field(WeatherConditionsTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def condition(self) -> Optional[WeatherStatus]:
        field = self.get_field(WeatherConditionsConditionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @condition.setter
    def condition(self, value: WeatherStatus):
        field = self.get_field(WeatherConditionsConditionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def wind_direction(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsWindDirectionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @wind_direction.setter
    def wind_direction(self, value: int):
        field = self.get_field(WeatherConditionsWindDirectionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def wind_speed(self) -> Optional[float]:
        field = self.get_field(WeatherConditionsWindSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @wind_speed.setter
    def wind_speed(self, value: float):
        field = self.get_field(WeatherConditionsWindSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def precipitation_probability(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsPrecipitationProbabilityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @precipitation_probability.setter
    def precipitation_probability(self, value: int):
        field = self.get_field(WeatherConditionsPrecipitationProbabilityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature_feels_like(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsTemperatureFeelsLikeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature_feels_like.setter
    def temperature_feels_like(self, value: int):
        field = self.get_field(WeatherConditionsTemperatureFeelsLikeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def relative_humidity(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsRelativeHumidityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @relative_humidity.setter
    def relative_humidity(self, value: int):
        field = self.get_field(WeatherConditionsRelativeHumidityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def location(self) -> Optional[str]:
        field = self.get_field(WeatherConditionsLocationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @location.setter
    def location(self, value: str):
        field = self.get_field(WeatherConditionsLocationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def observed_at_time(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsObservedAtTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @observed_at_time.setter
    def observed_at_time(self, value: int):
        field = self.get_field(WeatherConditionsObservedAtTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def observed_location_lat(self) -> Optional[float]:
        field = self.get_field(WeatherConditionsObservedLocationLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @observed_location_lat.setter
    def observed_location_lat(self, value: float):
        field = self.get_field(WeatherConditionsObservedLocationLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def observed_location_long(self) -> Optional[float]:
        field = self.get_field(WeatherConditionsObservedLocationLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @observed_location_long.setter
    def observed_location_long(self, value: float):
        field = self.get_field(WeatherConditionsObservedLocationLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def day_of_week(self) -> Optional[DayOfWeek]:
        field = self.get_field(WeatherConditionsDayOfWeekField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @day_of_week.setter
    def day_of_week(self, value: DayOfWeek):
        field = self.get_field(WeatherConditionsDayOfWeekField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def high_temperature(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsHighTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @high_temperature.setter
    def high_temperature(self, value: int):
        field = self.get_field(WeatherConditionsHighTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def low_temperature(self) -> Optional[int]:
        field = self.get_field(WeatherConditionsLowTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @low_temperature.setter
    def low_temperature(self, value: int):
        field = self.get_field(WeatherConditionsLowTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsWeatherReportField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='weather_report',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsTemperatureField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsConditionField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='condition',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsWindDirectionField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wind_direction',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsWindSpeedField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wind_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsPrecipitationProbabilityField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='precipitation_probability',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsTemperatureFeelsLikeField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature_feels_like',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsRelativeHumidityField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='relative_humidity',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsLocationField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='location',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsObservedAtTimeField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='observed_at_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsObservedLocationLatField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='observed_location_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsObservedLocationLongField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='observed_location_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsDayOfWeekField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='day_of_week',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsHighTemperatureField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='high_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WeatherConditionsLowTemperatureField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='low_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
