# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *
from fit_tool.sub_field import SubField


class MonitoringMessage(DataMessage):
    ID = 55
    NAME = 'monitoring'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=MonitoringMessage.NAME,
                         global_id=MonitoringMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             MonitoringDeviceIndexField(
                                 size=self.__get_field_size(definition_message, MonitoringDeviceIndexField.ID),
                                 growable=definition_message is None),
                             MonitoringCaloriesField(
                                 size=self.__get_field_size(definition_message, MonitoringCaloriesField.ID),
                                 growable=definition_message is None),
                             MonitoringDistanceField(
                                 size=self.__get_field_size(definition_message, MonitoringDistanceField.ID),
                                 growable=definition_message is None),
                             MonitoringCyclesField(
                                 size=self.__get_field_size(definition_message, MonitoringCyclesField.ID),
                                 growable=definition_message is None),
                             MonitoringActiveTimeField(
                                 size=self.__get_field_size(definition_message, MonitoringActiveTimeField.ID),
                                 growable=definition_message is None),
                             MonitoringActivityTypeField(
                                 size=self.__get_field_size(definition_message, MonitoringActivityTypeField.ID),
                                 growable=definition_message is None),
                             MonitoringActivitySubtypeField(
                                 size=self.__get_field_size(definition_message, MonitoringActivitySubtypeField.ID),
                                 growable=definition_message is None),
                             MonitoringActivityLevelField(
                                 size=self.__get_field_size(definition_message, MonitoringActivityLevelField.ID),
                                 growable=definition_message is None),
                             MonitoringDistance16Field(
                                 size=self.__get_field_size(definition_message, MonitoringDistance16Field.ID),
                                 growable=definition_message is None),
                             MonitoringCycles16Field(
                                 size=self.__get_field_size(definition_message, MonitoringCycles16Field.ID),
                                 growable=definition_message is None),
                             MonitoringActiveTime16Field(
                                 size=self.__get_field_size(definition_message, MonitoringActiveTime16Field.ID),
                                 growable=definition_message is None),
                             MonitoringLocalTimestampField(
                                 size=self.__get_field_size(definition_message, MonitoringLocalTimestampField.ID),
                                 growable=definition_message is None),
                             MonitoringTemperatureField(
                                 size=self.__get_field_size(definition_message, MonitoringTemperatureField.ID),
                                 growable=definition_message is None),
                             MonitoringTemperatureMinField(
                                 size=self.__get_field_size(definition_message, MonitoringTemperatureMinField.ID),
                                 growable=definition_message is None),
                             MonitoringTemperatureMaxField(
                                 size=self.__get_field_size(definition_message, MonitoringTemperatureMaxField.ID),
                                 growable=definition_message is None),
                             MonitoringActivityTimeField(
                                 size=self.__get_field_size(definition_message, MonitoringActivityTimeField.ID),
                                 growable=definition_message is None),
                             MonitoringActiveCaloriesField(
                                 size=self.__get_field_size(definition_message, MonitoringActiveCaloriesField.ID),
                                 growable=definition_message is None),
                             MonitoringCurrentActivityTypeIntensityField(
                                 size=self.__get_field_size(definition_message,
                                                            MonitoringCurrentActivityTypeIntensityField.ID),
                                 growable=definition_message is None),
                             MonitoringTimestampMin8Field(
                                 size=self.__get_field_size(definition_message, MonitoringTimestampMin8Field.ID),
                                 growable=definition_message is None),
                             MonitoringTimestamp16Field(
                                 size=self.__get_field_size(definition_message, MonitoringTimestamp16Field.ID),
                                 growable=definition_message is None),
                             MonitoringHeartRateField(
                                 size=self.__get_field_size(definition_message, MonitoringHeartRateField.ID),
                                 growable=definition_message is None),
                             MonitoringIntensityField(
                                 size=self.__get_field_size(definition_message, MonitoringIntensityField.ID),
                                 growable=definition_message is None),
                             MonitoringDurationMinField(
                                 size=self.__get_field_size(definition_message, MonitoringDurationMinField.ID),
                                 growable=definition_message is None),
                             MonitoringDurationField(
                                 size=self.__get_field_size(definition_message, MonitoringDurationField.ID),
                                 growable=definition_message is None),
                             MonitoringAscentField(
                                 size=self.__get_field_size(definition_message, MonitoringAscentField.ID),
                                 growable=definition_message is None),
                             MonitoringDescentField(
                                 size=self.__get_field_size(definition_message, MonitoringDescentField.ID),
                                 growable=definition_message is None),
                             MonitoringModerateActivityMinutesField(
                                 size=self.__get_field_size(definition_message,
                                                            MonitoringModerateActivityMinutesField.ID),
                                 growable=definition_message is None),
                             MonitoringVigorousActivityMinutesField(
                                 size=self.__get_field_size(definition_message,
                                                            MonitoringVigorousActivityMinutesField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def device_index(self) -> Optional[int]:
        field = self.get_field(MonitoringDeviceIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @device_index.setter
    def device_index(self, value: int):
        field = self.get_field(MonitoringDeviceIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def calories(self) -> Optional[int]:
        field = self.get_field(MonitoringCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @calories.setter
    def calories(self, value: int):
        field = self.get_field(MonitoringCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def distance(self) -> Optional[float]:
        field = self.get_field(MonitoringDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @distance.setter
    def distance(self, value: float):
        field = self.get_field(MonitoringDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cycles(self) -> Optional[float]:
        field = self.get_field(MonitoringCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cycles.setter
    def cycles(self, value: float):
        field = self.get_field(MonitoringCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def steps(self) -> Optional[int]:
        field = self.get_field(MonitoringCyclesField.ID)
        type_field = self.get_field(MonitoringActivityTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [6, 1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @steps.setter
    def steps(self, value: int):
        field = self.get_field(MonitoringCyclesField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def strokes(self) -> Optional[float]:
        field = self.get_field(MonitoringCyclesField.ID)
        type_field = self.get_field(MonitoringActivityTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [2, 5]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @strokes.setter
    def strokes(self, value: float):
        field = self.get_field(MonitoringCyclesField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def active_time(self) -> Optional[float]:
        field = self.get_field(MonitoringActiveTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @active_time.setter
    def active_time(self, value: float):
        field = self.get_field(MonitoringActiveTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_type(self) -> Optional[ActivityType]:
        field = self.get_field(MonitoringActivityTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_type.setter
    def activity_type(self, value: ActivityType):
        field = self.get_field(MonitoringActivityTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_subtype(self) -> Optional[ActivitySubtype]:
        field = self.get_field(MonitoringActivitySubtypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_subtype.setter
    def activity_subtype(self, value: ActivitySubtype):
        field = self.get_field(MonitoringActivitySubtypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_level(self) -> Optional[ActivityLevel]:
        field = self.get_field(MonitoringActivityLevelField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_level.setter
    def activity_level(self, value: ActivityLevel):
        field = self.get_field(MonitoringActivityLevelField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def distance_16(self) -> Optional[int]:
        field = self.get_field(MonitoringDistance16Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @distance_16.setter
    def distance_16(self, value: int):
        field = self.get_field(MonitoringDistance16Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cycles_16(self) -> Optional[int]:
        field = self.get_field(MonitoringCycles16Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cycles_16.setter
    def cycles_16(self, value: int):
        field = self.get_field(MonitoringCycles16Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def active_time_16(self) -> Optional[int]:
        field = self.get_field(MonitoringActiveTime16Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @active_time_16.setter
    def active_time_16(self, value: int):
        field = self.get_field(MonitoringActiveTime16Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def local_timestamp(self) -> Optional[int]:
        field = self.get_field(MonitoringLocalTimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @local_timestamp.setter
    def local_timestamp(self, value: int):
        field = self.get_field(MonitoringLocalTimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature(self) -> Optional[float]:
        field = self.get_field(MonitoringTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature.setter
    def temperature(self, value: float):
        field = self.get_field(MonitoringTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature_min(self) -> Optional[float]:
        field = self.get_field(MonitoringTemperatureMinField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature_min.setter
    def temperature_min(self, value: float):
        field = self.get_field(MonitoringTemperatureMinField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature_max(self) -> Optional[float]:
        field = self.get_field(MonitoringTemperatureMaxField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature_max.setter
    def temperature_max(self, value: float):
        field = self.get_field(MonitoringTemperatureMaxField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_time(self) -> Optional[int]:
        field = self.get_field(MonitoringActivityTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_time.setter
    def activity_time(self, value: int):
        field = self.get_field(MonitoringActivityTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def active_calories(self) -> Optional[int]:
        field = self.get_field(MonitoringActiveCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @active_calories.setter
    def active_calories(self, value: int):
        field = self.get_field(MonitoringActiveCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def current_activity_type_intensity(self) -> Optional[int]:
        field = self.get_field(MonitoringCurrentActivityTypeIntensityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @current_activity_type_intensity.setter
    def current_activity_type_intensity(self, value: int):
        field = self.get_field(MonitoringCurrentActivityTypeIntensityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def timestamp_min_8(self) -> Optional[int]:
        field = self.get_field(MonitoringTimestampMin8Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @timestamp_min_8.setter
    def timestamp_min_8(self, value: int):
        field = self.get_field(MonitoringTimestampMin8Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def timestamp_16(self) -> Optional[int]:
        field = self.get_field(MonitoringTimestamp16Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @timestamp_16.setter
    def timestamp_16(self, value: int):
        field = self.get_field(MonitoringTimestamp16Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def heart_rate(self) -> Optional[int]:
        field = self.get_field(MonitoringHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @heart_rate.setter
    def heart_rate(self, value: int):
        field = self.get_field(MonitoringHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def intensity(self) -> Optional[float]:
        field = self.get_field(MonitoringIntensityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @intensity.setter
    def intensity(self, value: float):
        field = self.get_field(MonitoringIntensityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_min(self) -> Optional[int]:
        field = self.get_field(MonitoringDurationMinField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_min.setter
    def duration_min(self, value: int):
        field = self.get_field(MonitoringDurationMinField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration(self) -> Optional[int]:
        field = self.get_field(MonitoringDurationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration.setter
    def duration(self, value: int):
        field = self.get_field(MonitoringDurationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ascent(self) -> Optional[float]:
        field = self.get_field(MonitoringAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ascent.setter
    def ascent(self, value: float):
        field = self.get_field(MonitoringAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def descent(self) -> Optional[float]:
        field = self.get_field(MonitoringDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @descent.setter
    def descent(self, value: float):
        field = self.get_field(MonitoringDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def moderate_activity_minutes(self) -> Optional[int]:
        field = self.get_field(MonitoringModerateActivityMinutesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @moderate_activity_minutes.setter
    def moderate_activity_minutes(self, value: int):
        field = self.get_field(MonitoringModerateActivityMinutesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def vigorous_activity_minutes(self) -> Optional[int]:
        field = self.get_field(MonitoringVigorousActivityMinutesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @vigorous_activity_minutes.setter
    def vigorous_activity_minutes(self, value: int):
        field = self.get_field(MonitoringVigorousActivityMinutesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringDeviceIndexField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='device_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringCaloriesField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringDistanceField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='distance',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringCyclesField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cycles',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=2,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='steps',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='steps',
                    reference_map={
                        MonitoringActivityTypeField.ID: [6, 1]
                    }),
                SubField(
                    name='strokes',
                    base_type=BaseType.UINT32,
                    scale=2,
                    offset=0,
                    units='strokes',
                    reference_map={
                        MonitoringActivityTypeField.ID: [2, 5]
                    })
            ]
        )


class MonitoringActiveTimeField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='active_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringActivityTypeField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringActivitySubtypeField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_subtype',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringActivityLevelField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_level',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringDistance16Field(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='distance_16',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='100 * m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringCycles16Field(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='cycles_16',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='2 * cycles (steps)',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringActiveTime16Field(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='active_time_16',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringLocalTimestampField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='local_timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringTemperatureField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringTemperatureMinField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature_min',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringTemperatureMaxField(Field):
    ID = 15

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature_max',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringActivityTimeField(Field):
    ID = 16

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_time',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='minutes',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringActiveCaloriesField(Field):
    ID = 19

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='active_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringCurrentActivityTypeIntensityField(Field):
    ID = 24

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='current_activity_type_intensity',
            field_id=self.ID,
            base_type=BaseType.BYTE,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringTimestampMin8Field(Field):
    ID = 25

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp_min_8',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='min',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringTimestamp16Field(Field):
    ID = 26

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp_16',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringHeartRateField(Field):
    ID = 27

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringIntensityField(Field):
    ID = 28

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='intensity',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=10,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringDurationMinField(Field):
    ID = 29

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='duration_min',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='min',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringDurationField(Field):
    ID = 30

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='duration',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringAscentField(Field):
    ID = 31

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ascent',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringDescentField(Field):
    ID = 32

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='descent',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringModerateActivityMinutesField(Field):
    ID = 33

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='moderate_activity_minutes',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='minutes',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class MonitoringVigorousActivityMinutesField(Field):
    ID = 34

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='vigorous_activity_minutes',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='minutes',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
