Accurate outputs are reliant on the data being provided in the correct format, particularly when dealing with units of measurement.

!!! important "Developer Note"
	If you are interested in contributing to neptoon an important note: units in and out to functions should always match the defined units for the data type outlined below. This maintains a consistent code base. For example, if you have a function which requires you to convert Celcius to Kelvin internally before doing your calculations, make sure outputs in temperature units are converted back to Celcius. 

## The Units

These are the units expected inside neptoon. You should ensure data being used is converted into these units prior to use in neptoon.

!!! note "Work in Progress"
	Whilst we continue to push towards a version 1.0 release, this table will expand. It is unlikely we will alter the decided units however there may be missing definitions which will be added.

| Data Type             | Examples                     | Units                          | Notes                                                                                                                                                                                                                                                                                                  |
| --------------------- | ---------------------------- | ------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Temperature           | External Temperature Sensors | Celcius                        |                                                                                                                                                                                                                                                                                                        |
| Relative Humidity     | Relative Humidity Sensors    | %                              | From 0 to 100, not 0 to 1                                                                                                                                                                                                                                                                              |
| Pressure              | Atmospheric Pressure         | Hectopascals/Millibar          |                                                                                                                                                                                                                                                                                                        |
| Neutron Counts        | Epithermal Neutron Counts    | Counts per Hour (cph)          | Neptoon can handle conversion of this. When using a YAML file for import state the time resolution of the data and whether the count rates are given in absolute or counts per (time) and neptoon will create a cph column. NOTE: statistical uncertainty is still calculated from the raw count rate. |
| Absolute Humidity     |                              | grams per cubic meter (g/cm^3) |                                                                                                                                                                                                                                                                                                        |
| Elevation             |                              | meters (m)                     |                                                                                                                                                                                                                                                                                                        |
| Cut-off Ridgity       |                              | GV                             |                                                                                                                                                                                                                                                                                                        |
| Dry Soil Bulk Density |                              | grams per cubic meter (g/cm^3) |                                                                                                                                                                                                                                                                                                        |
