#
# MIT License
#
# Copyright (c) PhotonVision
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

###############################################################################
## THIS FILE WAS AUTO-GENERATED BY ./photon-serde/generate_messages.py.
##                        --> DO NOT MODIFY <--
###############################################################################

from typing import TYPE_CHECKING

from ..packet import Packet
from ..targeting import *  # noqa

if TYPE_CHECKING:
    from ..targeting import PnpResult  # noqa


class PnpResultSerde:
    # Message definition md5sum. See photon_packet.adoc for details
    MESSAGE_VERSION = "ae4d655c0a3104d88df4f5db144c1e86"
    MESSAGE_FORMAT = "Transform3d best;Transform3d alt;float64 bestReprojErr;float64 altReprojErr;float64 ambiguity;"

    @staticmethod
    def pack(value: "PnpResult") -> "Packet":
        ret = Packet()

        ret.encodeTransform(value.best)

        ret.encodeTransform(value.alt)

        # bestReprojErr is of intrinsic type float64
        ret.encodeDouble(value.bestReprojErr)

        # altReprojErr is of intrinsic type float64
        ret.encodeDouble(value.altReprojErr)

        # ambiguity is of intrinsic type float64
        ret.encodeDouble(value.ambiguity)
        return ret

    @staticmethod
    def unpack(packet: "Packet") -> "PnpResult":
        ret = PnpResult()

        ret.best = packet.decodeTransform()

        ret.alt = packet.decodeTransform()

        # bestReprojErr is of intrinsic type float64
        ret.bestReprojErr = packet.decodeDouble()

        # altReprojErr is of intrinsic type float64
        ret.altReprojErr = packet.decodeDouble()

        # ambiguity is of intrinsic type float64
        ret.ambiguity = packet.decodeDouble()

        return ret


# Hack ourselves into the base class
PnpResult.photonStruct = PnpResultSerde()
