#
# MIT License
#
# Copyright (c) PhotonVision
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

###############################################################################
## THIS FILE WAS AUTO-GENERATED BY ./photon-serde/generate_messages.py.
##                        --> DO NOT MODIFY <--
###############################################################################

from typing import TYPE_CHECKING

from ..packet import Packet
from ..targeting import *  # noqa

if TYPE_CHECKING:
    from ..targeting import PhotonTrackedTarget  # noqa
    from ..targeting import TargetCorner  # noqa


class PhotonTrackedTargetSerde:
    # Message definition md5sum. See photon_packet.adoc for details
    MESSAGE_VERSION = "cc6dbb5c5c1e0fa808108019b20863f1"
    MESSAGE_FORMAT = "float64 yaw;float64 pitch;float64 area;float64 skew;int32 fiducialId;int32 objDetectId;float32 objDetectConf;Transform3d bestCameraToTarget;Transform3d altCameraToTarget;float64 poseAmbiguity;TargetCorner:16f6ac0dedc8eaccb951f4895d9e18b6 minAreaRectCorners[?];TargetCorner:16f6ac0dedc8eaccb951f4895d9e18b6 detectedCorners[?];"

    @staticmethod
    def pack(value: "PhotonTrackedTarget") -> "Packet":
        ret = Packet()

        # yaw is of intrinsic type float64
        ret.encodeDouble(value.yaw)

        # pitch is of intrinsic type float64
        ret.encodeDouble(value.pitch)

        # area is of intrinsic type float64
        ret.encodeDouble(value.area)

        # skew is of intrinsic type float64
        ret.encodeDouble(value.skew)

        # fiducialId is of intrinsic type int32
        ret.encodeInt(value.fiducialId)

        # objDetectId is of intrinsic type int32
        ret.encodeInt(value.objDetectId)

        # objDetectConf is of intrinsic type float32
        ret.encodeFloat(value.objDetectConf)

        ret.encodeTransform(value.bestCameraToTarget)

        ret.encodeTransform(value.altCameraToTarget)

        # poseAmbiguity is of intrinsic type float64
        ret.encodeDouble(value.poseAmbiguity)

        # minAreaRectCorners is a custom VLA!
        ret.encodeList(value.minAreaRectCorners, TargetCorner.photonStruct)

        # detectedCorners is a custom VLA!
        ret.encodeList(value.detectedCorners, TargetCorner.photonStruct)
        return ret

    @staticmethod
    def unpack(packet: "Packet") -> "PhotonTrackedTarget":
        ret = PhotonTrackedTarget()

        # yaw is of intrinsic type float64
        ret.yaw = packet.decodeDouble()

        # pitch is of intrinsic type float64
        ret.pitch = packet.decodeDouble()

        # area is of intrinsic type float64
        ret.area = packet.decodeDouble()

        # skew is of intrinsic type float64
        ret.skew = packet.decodeDouble()

        # fiducialId is of intrinsic type int32
        ret.fiducialId = packet.decodeInt()

        # objDetectId is of intrinsic type int32
        ret.objDetectId = packet.decodeInt()

        # objDetectConf is of intrinsic type float32
        ret.objDetectConf = packet.decodeFloat()

        ret.bestCameraToTarget = packet.decodeTransform()

        ret.altCameraToTarget = packet.decodeTransform()

        # poseAmbiguity is of intrinsic type float64
        ret.poseAmbiguity = packet.decodeDouble()

        # minAreaRectCorners is a custom VLA!
        ret.minAreaRectCorners = packet.decodeList(TargetCorner.photonStruct)

        # detectedCorners is a custom VLA!
        ret.detectedCorners = packet.decodeList(TargetCorner.photonStruct)

        return ret


# Hack ourselves into the base class
PhotonTrackedTarget.photonStruct = PhotonTrackedTargetSerde()
