#
# MIT License
#
# Copyright (c) PhotonVision
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

###############################################################################
## THIS FILE WAS AUTO-GENERATED BY ./photon-serde/generate_messages.py.
##                        --> DO NOT MODIFY <--
###############################################################################

from typing import TYPE_CHECKING

from ..packet import Packet
from ..targeting import *  # noqa

if TYPE_CHECKING:
    from ..targeting import MultiTargetPNPResult  # noqa
    from ..targeting import PhotonPipelineMetadata  # noqa
    from ..targeting import PhotonPipelineResult  # noqa
    from ..targeting import PhotonTrackedTarget  # noqa


class PhotonPipelineResultSerde:
    # Message definition md5sum. See photon_packet.adoc for details
    MESSAGE_VERSION = "4b2ff16a964b5e2bf04be0c1454d91c4"
    MESSAGE_FORMAT = "PhotonPipelineMetadata:ac0a45f686457856fb30af77699ea356 metadata;PhotonTrackedTarget:cc6dbb5c5c1e0fa808108019b20863f1 targets[?];optional MultiTargetPNPResult:541096947e9f3ca2d3f425ff7b04aa7b multitagResult;"

    @staticmethod
    def pack(value: "PhotonPipelineResult") -> "Packet":
        ret = Packet()

        # metadata is of non-intrinsic type PhotonPipelineMetadata
        ret.encodeBytes(PhotonPipelineMetadata.photonStruct.pack(value.metadata).getData())

        # targets is a custom VLA!
        ret.encodeList(value.targets, PhotonTrackedTarget.photonStruct)

        # multitagResult is optional! it better not be a VLA too
        ret.encodeOptional(value.multitagResult, MultiTargetPNPResult.photonStruct)
        return ret

    @staticmethod
    def unpack(packet: "Packet") -> "PhotonPipelineResult":
        ret = PhotonPipelineResult()

        # metadata is of non-intrinsic type PhotonPipelineMetadata
        ret.metadata = PhotonPipelineMetadata.photonStruct.unpack(packet)

        # targets is a custom VLA!
        ret.targets = packet.decodeList(PhotonTrackedTarget.photonStruct)

        # multitagResult is optional! it better not be a VLA too
        ret.multitagResult = packet.decodeOptional(MultiTargetPNPResult.photonStruct)

        return ret


# Hack ourselves into the base class
PhotonPipelineResult.photonStruct = PhotonPipelineResultSerde()
