#
# MIT License
#
# Copyright (c) PhotonVision
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

###############################################################################
## THIS FILE WAS AUTO-GENERATED BY ./photon-serde/generate_messages.py.
##                        --> DO NOT MODIFY <--
###############################################################################

from typing import TYPE_CHECKING

from ..packet import Packet
from ..targeting import *  # noqa

if TYPE_CHECKING:
    from ..targeting import PhotonPipelineMetadata  # noqa


class PhotonPipelineMetadataSerde:
    # Message definition md5sum. See photon_packet.adoc for details
    MESSAGE_VERSION = "ac0a45f686457856fb30af77699ea356"
    MESSAGE_FORMAT = "int64 sequenceID;int64 captureTimestampMicros;int64 publishTimestampMicros;int64 timeSinceLastPong;"

    @staticmethod
    def pack(value: "PhotonPipelineMetadata") -> "Packet":
        ret = Packet()

        # sequenceID is of intrinsic type int64
        ret.encodeLong(value.sequenceID)

        # captureTimestampMicros is of intrinsic type int64
        ret.encodeLong(value.captureTimestampMicros)

        # publishTimestampMicros is of intrinsic type int64
        ret.encodeLong(value.publishTimestampMicros)

        # timeSinceLastPong is of intrinsic type int64
        ret.encodeLong(value.timeSinceLastPong)
        return ret

    @staticmethod
    def unpack(packet: "Packet") -> "PhotonPipelineMetadata":
        ret = PhotonPipelineMetadata()

        # sequenceID is of intrinsic type int64
        ret.sequenceID = packet.decodeLong()

        # captureTimestampMicros is of intrinsic type int64
        ret.captureTimestampMicros = packet.decodeLong()

        # publishTimestampMicros is of intrinsic type int64
        ret.publishTimestampMicros = packet.decodeLong()

        # timeSinceLastPong is of intrinsic type int64
        ret.timeSinceLastPong = packet.decodeLong()

        return ret


# Hack ourselves into the base class
PhotonPipelineMetadata.photonStruct = PhotonPipelineMetadataSerde()
