# ChargeSim: Charging Infrastructure Simulation Suite

[![PyPI Version](https://img.shields.io/badge/PyPI-0.1.0-orange)](https://pypi.org/project/chargesim/)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://github.com/Ajax23/ChargeSim/blob/master/LICENSE)
[![DOI](https://zenodo.org/badge/393620742.svg)](https://zenodo.org/badge/latestdoi/393620742)
[![Build Status](https://github.com/Ajax23/ChargeSim/actions/workflows/workflow.yml/badge.svg)](https://github.com/Ajax23/ChargeSim/actions/workflows/workflow.yml)
[![codecov](https://codecov.io/gh/Ajax23/ChargeSim/branch/master/graph/badge.svg?token=AXx3JTujap)](https://codecov.io/gh/Ajax23/ChargeSim)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/Ajax23/ChargeSim.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/Ajax23/ChargeSim/context:python)

## Documentation

Online documentation is available at [ajax23.github.io/ChargeSim](https://ajax23.github.io/ChargeSim/).

The docs include an [API reference](https://ajax23.github.io/ChargeSim/api.html).

## Dependencies

ChargeSim supports Python 3.5+.

Installation requires [osmnx](https://osmnx.readthedocs.io/en/stable/), [scikit-learn](https://scikit-learn.org/stable/index.html), [pandas](https://pandas.pydata.org/) and [seaborn](https://seaborn.pydata.org/).


## Installation

The latest stable release (and older versions) can be installed from PyPI:

    pip install chargesim

You may instead want to use the development version from Github:

    pip install git+https://github.com/ajax23/chargesim.git#egg=chargesim

    pip install git+https://github.com/ajax23/chargesim.git@develop#egg=chargesim

Or download the repository and install in the top directory via:

    pip install .


## Testing

To test ChargeSim, run the test in the test directory.


## Development

ChargeSim development takes place on Github: [www.github.com/Ajax23/ChargeSim](https://github.com/Ajax23/ChargeSim)

Please submit any reproducible bugs you encounter to the [issue tracker](https://github.com/Ajax23/ChargeSim/issues).


## How to Cite ChargeSim

When citing ChargeSim please use the current **Zenodo DOI** corresponding to the used ChargeSim version. (Current DOI is listed in the badges.)
