"""
    Apideck

    The Apideck OpenAPI Spec: SDK Optimized  # noqa: E501

    The version of the OpenAPI document: 8.85.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from apideck.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from apideck.exceptions import ApiAttributeError


def lazy_import():
    from apideck.model.error import Error
    from apideck.model.price import Price
    globals()['Error'] = Error
    globals()['Price'] = Price


class Message(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type',): {
            'SMS': "sms",
            'MMS': "mms",
        },
        ('direction',): {
            'INBOUND': "inbound",
            'OUTBOUND-API': "outbound-api",
            'OUTBOUND-CALL': "outbound-call",
            'OUTBOUND-REPLY': "outbound-reply",
            'UNKNOWN': "unknown",
        },
        ('status',): {
            'ACCEPTED': "accepted",
            'SCHEDULED': "scheduled",
            'CANCELED': "canceled",
            'QUEUED': "queued",
            'SENDING': "sending",
            'SENT': "sent",
            'FAILED': "failed",
            'DELIVERED': "delivered",
            'UNDELIVERED': "undelivered",
            'RECEIVING': "receiving",
            'RECEIVED': "received",
            'READ': "read",
        },
    }

    validations = {
        ('body',): {
            'max_length': 1600,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            '_from': (str,),  # noqa: E501
            'to': (str,),  # noqa: E501
            'body': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'subject': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'number_of_units': (int,),  # noqa: E501
            'number_of_media_files': (int,),  # noqa: E501
            'direction': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'scheduled_at': (datetime,),  # noqa: E501
            'sent_at': (datetime,),  # noqa: E501
            'webhook_url': (str,),  # noqa: E501
            'reference': (str,),  # noqa: E501
            'price': (Price,),  # noqa: E501
            'error': (Error,),  # noqa: E501
            'messaging_service_id': (str,),  # noqa: E501
            'updated_by': (str, none_type,),  # noqa: E501
            'created_by': (str, none_type,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        '_from': 'from',  # noqa: E501
        'to': 'to',  # noqa: E501
        'body': 'body',  # noqa: E501
        'id': 'id',  # noqa: E501
        'subject': 'subject',  # noqa: E501
        'type': 'type',  # noqa: E501
        'number_of_units': 'number_of_units',  # noqa: E501
        'number_of_media_files': 'number_of_media_files',  # noqa: E501
        'direction': 'direction',  # noqa: E501
        'status': 'status',  # noqa: E501
        'scheduled_at': 'scheduled_at',  # noqa: E501
        'sent_at': 'sent_at',  # noqa: E501
        'webhook_url': 'webhook_url',  # noqa: E501
        'reference': 'reference',  # noqa: E501
        'price': 'price',  # noqa: E501
        'error': 'error',  # noqa: E501
        'messaging_service_id': 'messaging_service_id',  # noqa: E501
        'updated_by': 'updated_by',  # noqa: E501
        'created_by': 'created_by',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
        'number_of_units',  # noqa: E501
        'number_of_media_files',  # noqa: E501
        'direction',  # noqa: E501
        'status',  # noqa: E501
        'sent_at',  # noqa: E501
        'updated_by',  # noqa: E501
        'created_by',  # noqa: E501
        'updated_at',  # noqa: E501
        'created_at',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, _from, to, body, *args, **kwargs):  # noqa: E501
        """Message - a model defined in OpenAPI

        Args:
            _from (str): The phone number that initiated the message.
            to (str): The phone number that received the message.
            body (str): The message text.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): [optional]  # noqa: E501
            subject (str): [optional]  # noqa: E501
            type (str): Set to sms for SMS messages and mms for MMS messages.. [optional]  # noqa: E501
            number_of_units (int): The number of units that make up the complete message. Messages can be split up due to the constraints of the message size.. [optional]  # noqa: E501
            number_of_media_files (int): The number of media files associated with the message.. [optional]  # noqa: E501
            direction (str): The direction of the message.. [optional]  # noqa: E501
            status (str): Status of the delivery of the message.. [optional]  # noqa: E501
            scheduled_at (datetime): The scheduled date and time of the message.. [optional]  # noqa: E501
            sent_at (datetime): The date and time that the message was sent. [optional]  # noqa: E501
            webhook_url (str): Define a webhook to receive delivery notifications.. [optional]  # noqa: E501
            reference (str): A client reference.. [optional]  # noqa: E501
            price (Price): [optional]  # noqa: E501
            error (Error): [optional]  # noqa: E501
            messaging_service_id (str): The ID of the Messaging Service used with the message. In case of Plivo this links to the Powerpack ID.. [optional]  # noqa: E501
            updated_by (str, none_type): [optional]  # noqa: E501
            created_by (str, none_type): [optional]  # noqa: E501
            updated_at (datetime): [optional]  # noqa: E501
            created_at (datetime): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self._from = _from
        self.to = to
        self.body = body
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, _from, to, body, *args, **kwargs):  # noqa: E501
        """Message - a model defined in OpenAPI

        Args:
            _from (str): The phone number that initiated the message.
            to (str): The phone number that received the message.
            body (str): The message text.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): [optional]  # noqa: E501
            subject (str): [optional]  # noqa: E501
            type (str): Set to sms for SMS messages and mms for MMS messages.. [optional]  # noqa: E501
            number_of_units (int): The number of units that make up the complete message. Messages can be split up due to the constraints of the message size.. [optional]  # noqa: E501
            number_of_media_files (int): The number of media files associated with the message.. [optional]  # noqa: E501
            direction (str): The direction of the message.. [optional]  # noqa: E501
            status (str): Status of the delivery of the message.. [optional]  # noqa: E501
            scheduled_at (datetime): The scheduled date and time of the message.. [optional]  # noqa: E501
            sent_at (datetime): The date and time that the message was sent. [optional]  # noqa: E501
            webhook_url (str): Define a webhook to receive delivery notifications.. [optional]  # noqa: E501
            reference (str): A client reference.. [optional]  # noqa: E501
            price (Price): [optional]  # noqa: E501
            error (Error): [optional]  # noqa: E501
            messaging_service_id (str): The ID of the Messaging Service used with the message. In case of Plivo this links to the Powerpack ID.. [optional]  # noqa: E501
            updated_by (str, none_type): [optional]  # noqa: E501
            created_by (str, none_type): [optional]  # noqa: E501
            updated_at (datetime): [optional]  # noqa: E501
            created_at (datetime): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self._from = _from
        self.to = to
        self.body = body
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
