"""
    Apideck

    The Apideck OpenAPI Spec: SDK Optimized  # noqa: E501

    The version of the OpenAPI document: 8.85.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from apideck.api_client import ApiClient, Endpoint as _Endpoint
from apideck.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from apideck.model.bad_request_response import BadRequestResponse
from apideck.model.connection import Connection
from apideck.model.connection_import_data import ConnectionImportData
from apideck.model.consumer_request_counts_in_date_range_response import ConsumerRequestCountsInDateRangeResponse
from apideck.model.create_connection_response import CreateConnectionResponse
from apideck.model.create_session_response import CreateSessionResponse
from apideck.model.get_connection_response import GetConnectionResponse
from apideck.model.get_connections_response import GetConnectionsResponse
from apideck.model.get_consumer_response import GetConsumerResponse
from apideck.model.get_consumers_response import GetConsumersResponse
from apideck.model.get_logs_response import GetLogsResponse
from apideck.model.logs_filter import LogsFilter
from apideck.model.not_found_response import NotFoundResponse
from apideck.model.payment_required_response import PaymentRequiredResponse
from apideck.model.session import Session
from apideck.model.unauthorized_response import UnauthorizedResponse
from apideck.model.unexpected_error_response import UnexpectedErrorResponse
from apideck.model.unprocessable_response import UnprocessableResponse
from apideck.model.update_connection_response import UpdateConnectionResponse


class VaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.connection_settings_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetConnectionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections/{unified_api}/{service_id}/{resource}/config',
                'operation_id': 'connection_settings_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'unified_api',
                    'service_id',
                    'resource',
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'unified_api',
                    'service_id',
                    'resource',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'unified_api':
                        (str,),
                    'service_id':
                        (str,),
                    'resource':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'unified_api': 'unified_api',
                    'service_id': 'service_id',
                    'resource': 'resource',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'unified_api': 'path',
                    'service_id': 'path',
                    'resource': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.connection_settings_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateConnectionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections/{unified_api}/{service_id}/{resource}/config',
                'operation_id': 'connection_settings_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'unified_api',
                    'resource',
                    'connection',
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'service_id',
                    'unified_api',
                    'resource',
                    'connection',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'unified_api':
                        (str,),
                    'resource':
                        (str,),
                    'connection':
                        (Connection,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'service_id',
                    'unified_api': 'unified_api',
                    'resource': 'resource',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'service_id': 'path',
                    'unified_api': 'path',
                    'resource': 'path',
                    'connection': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.connections_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetConnectionsResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections',
                'operation_id': 'connections_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'consumer_id',
                    'app_id',
                    'api',
                    'configured',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'api':
                        (str,),
                    'configured':
                        (bool,),
                },
                'attribute_map': {
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                    'api': 'api',
                    'configured': 'configured',
                },
                'location_map': {
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'api': 'query',
                    'configured': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.connections_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections/{unified_api}/{service_id}',
                'operation_id': 'connections_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'unified_api',
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'service_id',
                    'unified_api',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'unified_api':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'service_id',
                    'unified_api': 'unified_api',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'service_id': 'path',
                    'unified_api': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.connections_import_endpoint = _Endpoint(
            settings={
                'response_type': (CreateConnectionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections/{unified_api}/{service_id}/import',
                'operation_id': 'connections_import',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'unified_api',
                    'connection_import_data',
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'service_id',
                    'unified_api',
                    'connection_import_data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'unified_api':
                        (str,),
                    'connection_import_data':
                        (ConnectionImportData,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'service_id',
                    'unified_api': 'unified_api',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'service_id': 'path',
                    'unified_api': 'path',
                    'connection_import_data': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.connections_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetConnectionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections/{unified_api}/{service_id}',
                'operation_id': 'connections_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'unified_api',
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'service_id',
                    'unified_api',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'unified_api':
                        (str,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'service_id',
                    'unified_api': 'unified_api',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'service_id': 'path',
                    'unified_api': 'path',
                    'consumer_id': 'header',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.connections_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateConnectionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/connections/{unified_api}/{service_id}',
                'operation_id': 'connections_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'unified_api',
                    'connection',
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'service_id',
                    'unified_api',
                    'connection',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'unified_api':
                        (str,),
                    'connection':
                        (Connection,),
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'service_id',
                    'unified_api': 'unified_api',
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'service_id': 'path',
                    'unified_api': 'path',
                    'connection': 'body',
                    'consumer_id': 'header',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.consumer_request_counts_all_endpoint = _Endpoint(
            settings={
                'response_type': (ConsumerRequestCountsInDateRangeResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/consumers/{consumer_id}/stats',
                'operation_id': 'consumer_request_counts_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'consumer_id',
                    'start_datetime',
                    'end_datetime',
                    'app_id',
                ],
                'required': [
                    'consumer_id',
                    'start_datetime',
                    'end_datetime',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'consumer_id':
                        (str,),
                    'start_datetime':
                        (str,),
                    'end_datetime':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'consumer_id': 'consumer_id',
                    'start_datetime': 'start_datetime',
                    'end_datetime': 'end_datetime',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'consumer_id': 'path',
                    'start_datetime': 'query',
                    'end_datetime': 'query',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.consumers_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetConsumersResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/consumers',
                'operation_id': 'consumers_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'cursor',
                    'limit',
                ],
                'required': [],
                'nullable': [
                    'cursor',
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'cursor':
                        (str, none_type,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'app_id': 'x-apideck-app-id',
                    'cursor': 'cursor',
                    'limit': 'limit',
                },
                'location_map': {
                    'app_id': 'header',
                    'cursor': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.consumers_one_endpoint = _Endpoint(
            settings={
                'response_type': (GetConsumerResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/consumers/{consumer_id}',
                'operation_id': 'consumers_one',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'consumer_id',
                    'app_id',
                ],
                'required': [
                    'consumer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                },
                'attribute_map': {
                    'consumer_id': 'consumer_id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'consumer_id': 'path',
                    'app_id': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.logs_all_endpoint = _Endpoint(
            settings={
                'response_type': (GetLogsResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/logs',
                'operation_id': 'logs_all',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'consumer_id',
                    'filter',
                    'cursor',
                    'limit',
                ],
                'required': [],
                'nullable': [
                    'cursor',
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'consumer_id':
                        (str,),
                    'filter':
                        (LogsFilter,),
                    'cursor':
                        (str, none_type,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'app_id': 'x-apideck-app-id',
                    'consumer_id': 'x-apideck-consumer-id',
                    'filter': 'filter',
                    'cursor': 'cursor',
                    'limit': 'limit',
                },
                'location_map': {
                    'app_id': 'header',
                    'consumer_id': 'header',
                    'filter': 'query',
                    'cursor': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sessions_create_endpoint = _Endpoint(
            settings={
                'response_type': (CreateSessionResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/vault/sessions',
                'operation_id': 'sessions_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'consumer_id',
                    'app_id',
                    'session',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'consumer_id':
                        (str,),
                    'app_id':
                        (str,),
                    'session':
                        (Session,),
                },
                'attribute_map': {
                    'consumer_id': 'x-apideck-consumer-id',
                    'app_id': 'x-apideck-app-id',
                },
                'location_map': {
                    'consumer_id': 'header',
                    'app_id': 'header',
                    'session': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def connection_settings_all(
        self,
        unified_api,
        service_id,
        resource,
        **kwargs
    ):
        """Get resource settings  # noqa: E501

        This endpoint returns custom settings and their defaults required by connection for a given resource.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connection_settings_all(unified_api, service_id, resource, async_req=True)
        >>> result = thread.get()

        Args:
            unified_api (str): Unified API
            service_id (str): Service ID of the resource to return
            resource (str): Resource Name

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetConnectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['unified_api'] = \
            unified_api
        kwargs['service_id'] = \
            service_id
        kwargs['resource'] = \
            resource
        return self.connection_settings_all_endpoint.call_with_http_info(**kwargs)

    def connection_settings_update(
        self,
        service_id,
        unified_api,
        resource,
        connection,
        **kwargs
    ):
        """Update settings  # noqa: E501

        Update default values for a connection's resource settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connection_settings_update(service_id, unified_api, resource, connection, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Service ID of the resource to return
            unified_api (str): Unified API
            resource (str): Resource Name
            connection (Connection): Fields that need to be updated on the resource

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateConnectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['service_id'] = \
            service_id
        kwargs['unified_api'] = \
            unified_api
        kwargs['resource'] = \
            resource
        kwargs['connection'] = \
            connection
        return self.connection_settings_update_endpoint.call_with_http_info(**kwargs)

    def connections_all(
        self,
        **kwargs
    ):
        """Get all connections  # noqa: E501

        This endpoint includes all the configured integrations and contains the required assets to build an integrations page where your users can install integrations. OAuth2 supported integrations will contain authorize and revoke links to handle the authentication flows.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connections_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            api (str): Scope results to Unified API. [optional]
            configured (bool): Scopes results to connections that have been configured or not. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetConnectionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.connections_all_endpoint.call_with_http_info(**kwargs)

    def connections_delete(
        self,
        service_id,
        unified_api,
        **kwargs
    ):
        """Deletes a connection  # noqa: E501

        Deletes a connection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connections_delete(service_id, unified_api, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Service ID of the resource to return
            unified_api (str): Unified API

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['service_id'] = \
            service_id
        kwargs['unified_api'] = \
            unified_api
        return self.connections_delete_endpoint.call_with_http_info(**kwargs)

    def connections_import(
        self,
        service_id,
        unified_api,
        connection_import_data,
        **kwargs
    ):
        """Import connection  # noqa: E501

        Import an authorized connection.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connections_import(service_id, unified_api, connection_import_data, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Service ID of the resource to return
            unified_api (str): Unified API
            connection_import_data (ConnectionImportData): Fields that need to be persisted on the resource

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateConnectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['service_id'] = \
            service_id
        kwargs['unified_api'] = \
            unified_api
        kwargs['connection_import_data'] = \
            connection_import_data
        return self.connections_import_endpoint.call_with_http_info(**kwargs)

    def connections_one(
        self,
        service_id,
        unified_api,
        **kwargs
    ):
        """Get connection  # noqa: E501

        Get a connection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connections_one(service_id, unified_api, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Service ID of the resource to return
            unified_api (str): Unified API

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetConnectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['service_id'] = \
            service_id
        kwargs['unified_api'] = \
            unified_api
        return self.connections_one_endpoint.call_with_http_info(**kwargs)

    def connections_update(
        self,
        service_id,
        unified_api,
        connection,
        **kwargs
    ):
        """Update connection  # noqa: E501

        Update a connection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.connections_update(service_id, unified_api, connection, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Service ID of the resource to return
            unified_api (str): Unified API
            connection (Connection): Fields that need to be updated on the resource

        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateConnectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['service_id'] = \
            service_id
        kwargs['unified_api'] = \
            unified_api
        kwargs['connection'] = \
            connection
        return self.connections_update_endpoint.call_with_http_info(**kwargs)

    def consumer_request_counts_all(
        self,
        consumer_id,
        start_datetime,
        end_datetime,
        **kwargs
    ):
        """Consumer request counts  # noqa: E501

        Get consumer request counts within a given datetime range.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.consumer_request_counts_all(consumer_id, start_datetime, end_datetime, async_req=True)
        >>> result = thread.get()

        Args:
            consumer_id (str): ID of the consumer to return
            start_datetime (str): Scopes results to requests that happened after datetime
            end_datetime (str): Scopes results to requests that happened before datetime

        Keyword Args:
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConsumerRequestCountsInDateRangeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['consumer_id'] = \
            consumer_id
        kwargs['start_datetime'] = \
            start_datetime
        kwargs['end_datetime'] = \
            end_datetime
        return self.consumer_request_counts_all_endpoint.call_with_http_info(**kwargs)

    def consumers_all(
        self,
        **kwargs
    ):
        """Get all consumers  # noqa: E501

        This endpoint includes all application consumers, along with an aggregated count of requests made.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.consumers_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            app_id (str): The ID of your Unify application. [optional]
            cursor (str, none_type): Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.. [optional]
            limit (int): Number of records to return. [optional] if omitted the server will use the default value of 20
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetConsumersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.consumers_all_endpoint.call_with_http_info(**kwargs)

    def consumers_one(
        self,
        consumer_id,
        **kwargs
    ):
        """Get consumer  # noqa: E501

        Consumer detail including their aggregated counts with the connections they have authorized.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.consumers_one(consumer_id, async_req=True)
        >>> result = thread.get()

        Args:
            consumer_id (str): ID of the consumer to return

        Keyword Args:
            app_id (str): The ID of your Unify application. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetConsumerResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['consumer_id'] = \
            consumer_id
        return self.consumers_one_endpoint.call_with_http_info(**kwargs)

    def logs_all(
        self,
        **kwargs
    ):
        """Get all consumer request logs  # noqa: E501

        This endpoint includes all consumer request logs.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.logs_all(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            app_id (str): The ID of your Unify application. [optional]
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            filter (LogsFilter): Filter results. [optional]
            cursor (str, none_type): Cursor to start from. You can find cursors for next/previous pages in the meta.cursors property of the response.. [optional]
            limit (int): Number of records to return. [optional] if omitted the server will use the default value of 20
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetLogsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.logs_all_endpoint.call_with_http_info(**kwargs)

    def sessions_create(
        self,
        **kwargs
    ):
        """Create Session  # noqa: E501

        Making a POST request to this endpoint will initiate a Hosted Vault session. Redirect the consumer to the returned url to allow temporary access to manage their integrations and settings.  Note: This is a short lived token that will expire after 1 hour (TTL: 3600).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sessions_create(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            consumer_id (str): ID of the consumer which you want to get or push data from. [optional]
            app_id (str): The ID of your Unify application. [optional]
            session (Session): Additional redirect uri and/or consumer metadata. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateSessionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.sessions_create_endpoint.call_with_http_info(**kwargs)

