"use strict";
/* eslint-disable powerbi-visuals/no-http-string */
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.
// Your use of the content in the files referenced here is subject to the terms of the license at https://aka.ms/fabric-assets-license
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeIcons = void 0;
var React = require("react");
var styling_1 = require("@uifabric/styling");
// eslint-disable-next-line max-lines-per-function
function initializeIcons(baseUrl, options) {
    if (baseUrl === void 0) { baseUrl = ""; }
    var subset = {
        style: {
            MozOsxFontSmoothing: "grayscale",
            WebkitFontSmoothing: "antialiased",
            fontStyle: "normal",
            fontWeight: "normal",
            speak: "none",
        },
        fontFace: {
            fontFamily: "\"FabricMDL2Icons\"",
            src: "url('" + baseUrl + "fabric-icons-a1ad4051.woff') format('woff')",
        },
        icons: {
            "6PointStar": "\uF504",
            AADLogo: "\uED68",
            Accept: "\uE8FB",
            AcceptMedium: "\uF78C",
            AccessibiltyChecker: "\uF835",
            AccessLogo: "\uED69",
            AccountActivity: "\uEFF4",
            AccountBrowser: "\uF652",
            AccountManagement: "\uF55C",
            Accounts: "\uE910",
            ActionCenter: "\uE91C",
            ActivateOrders: "\uEFE0",
            ActivityFeed: "\uF056",
            Add: "\uE710",
            AddBookmark: "\uF5B7",
            AddConnection: "\uF4E1",
            AddEvent: "\uEEB5",
            AddFavorite: "\uF0C8",
            AddFavoriteFill: "\uF0C9",
            AddField: "\uE4C7",
            AddFriend: "\uE8FA",
            AddGroup: "\uEE3D",
            AddHome: "\uF17B",
            AddIn: "\uF775",
            AddLink: "\uE35E",
            AddMedium: "\uECA1",
            AddMultiple: "\uE9C5",
            AddNotes: "\uEAE3",
            AddOnlineMeeting: "\uED8E",
            AddPhone: "\uED96",
            AddReaction: "\uF85D",
            AddSpaceAfter: "\uE3DF",
            AddSpaceBefore: "\uE3DE",
            AddTable: "\uE4C6",
            AddTo: "\uECC8",
            AddToShoppingList: "\uEA9A",
            AddWork: "\uF17C",
            Admin: "\uE7EF",
            AdminALogo32: "\uF4BA",
            AdminALogoFill32: "\uF4BB",
            AdminALogoInverse32: "\uED6A",
            AdminCLogoInverse32: "\uED6B",
            AdminDLogoInverse32: "\uED6C",
            AdminELogoInverse32: "\uED6D",
            AdminLLogoInverse32: "\uED6E",
            AdminMLogoInverse32: "\uED6F",
            AdminOLogoInverse32: "\uED70",
            AdminPLogoInverse32: "\uED71",
            AdminSLogoInverse32: "\uED72",
            AdminYLogoInverse32: "\uED73",
            Airplane: "\uE709",
            AirplaneSolid: "\uEB4C",
            AirTickets: "\uEF7A",
            AlarmClock: "\uE919",
            Album: "\uE7AB",
            AlbumRemove: "\uEC62",
            AlertSettings: "\uF8B6",
            AlertSolid: "\uF331",
            AlignCenter: "\uE8E3",
            AlignHorizontalCenter: "\uF4F4",
            AlignHorizontalLeft: "\uF4F3",
            AlignHorizontalRight: "\uF4F5",
            AlignJustify: "\uF51E",
            AlignLeft: "\uE8E4",
            AlignRight: "\uE8E2",
            AlignVerticalBottom: "\uF4F8",
            AlignVerticalCenter: "\uF4F7",
            AlignVerticalTop: "\uF4F6",
            AllApps: "\uE71D",
            AllAppsMirrored: "\uEA40",
            AllCurrency: "\uEAE4",
            AltText: "\uE397",
            AmazonWebServicesLogo: "\uF7FE",
            AnalyticsLogo: "\uF1DE",
            AnalyticsQuery: "\uF1DF",
            AnalyticsReport: "\uF1E1",
            AnalyticsView: "\uF5F1",
            AnchorLock: "\uF511",
            AndroidLogo: "\uEF8B",
            Annotation: "\uE924",
            ApacheIvyLogo32: "\uF5D1",
            ApacheMavenLogo: "\uF65F",
            AppIconDefault: "\uECAA",
            AppIconDefaultAdd: "\uEFDA",
            AppIconDefaultEdit: "\uEFDC",
            AppIconDefaultList: "\uEFDE",
            Archive: "\uF03F",
            ArchiveUndo: "\uE3A1",
            AreaChart: "\uE9D2",
            ArrangeBringForward: "\uF509",
            ArrangeBringToFront: "\uF506",
            ArrangeByFrom: "\uF678",
            ArrangeSendBackward: "\uF508",
            ArrangeSendToBack: "\uF507",
            Arrivals: "\uEB34",
            ArrowDownRight8: "\uEED5",
            ArrowDownRightMirrored8: "\uEEF0",
            ArrowTallDownLeft: "\uF2BF",
            ArrowTallDownRight: "\uF2C0",
            ArrowTallUpLeft: "\uF2BD",
            ArrowTallUpRight: "\uF2BE",
            ArrowUpRight: "\uF069",
            ArrowUpRight8: "\uEED4",
            ArrowUpRightMirrored8: "\uEEEF",
            Articles: "\uEAC1",
            Ascending: "\uEDC0",
            AspectRatio: "\uE799",
            AssessmentGroup: "\uF31A",
            AssessmentGroupTemplate: "\uF2B1",
            AssetLibrary: "\uEEB6",
            Assign: "\uE9D3",
            AssignPolicy: "\uE461",
            Asterisk: "\uEA38",
            AsteriskSolid: "\uF34D",
            ATPLogo: "\uEF85",
            Attach: "\uE723",
            AustralianRules: "\uEE70",
            AuthenticatorApp: "\uF6B1",
            AutoDeploySettings: "\uF3FA",
            AutoEnhanceOff: "\uE78E",
            AutoEnhanceOn: "\uE78D",
            AutoFillTemplate: "\uF313",
            AutoFitContents: "\uE3E8",
            AutoFitWindow: "\uE3E9",
            AutoHeight: "\uF512",
            AutomateFlow: "\uE3F5",
            AutoRacing: "\uEB24",
            AwayStatus: "\uEE6A",
            AzureAPIManagement: "\uF37F",
            AzureDataExplorer: "\uE439",
            AzureIcon: "\uEB6A",
            AzureKeyVault: "\uF3B4",
            AzureServiceEndpoint: "\uF380",
            Back: "\uE72B",
            BackgroundColor: "\uF42B",
            Backlog: "\uF2AC",
            BacklogBoard: "\uF444",
            BacklogList: "\uF6BF",
            BackToWindow: "\uE73F",
            Badge: "\uEC1B",
            Balloons: "\uED7E",
            Bank: "\uE825",
            BankSolid: "\uF34F",
            BarChart4: "\uEAE7",
            BarChartHorizontal: "\uE9EB",
            BarChartVertical: "\uE9EC",
            BarChartVerticalEdit: "\uF89D",
            BarChartVerticalFill: "\uF830",
            BarChartVerticalFilter: "\uF77E",
            BarChartVerticalFilterSolid: "\uF77F",
            Baseball: "\uEB20",
            BeerMug: "\uF49E",
            BIDashboard: "\uF543",
            BidiLtr: "\uE9AA",
            BidiRtl: "\uE9AB",
            Bill: "\uE5FA",
            BingLogo: "\uEB6B",
            BirthdayCake: "\uEF8D",
            BitbucketLogo32: "\uF5D2",
            BlobStorage: "\uE436",
            BlockContact: "\uE8F8",
            Blocked: "\uE733",
            Blocked12: "\uF62E",
            Blocked2: "\uECE4",
            Blocked2Solid: "\uF737",
            BlockedSite: "\uE72F",
            BlockedSiteSolid12: "\uF70A",
            BlockedSolid: "\uF531",
            Blog: "\uF22B",
            BlowingSnow: "\uE9C9",
            Blur: "\uF28E",
            Boards: "\uEF68",
            Bold: "\uE8DD",
            BoldBulgarian: "\uE5C5",
            BoldF: "\uE5B5",
            BoldG: "\uE5B3",
            BoldK: "\uE5C6",
            BoldKazakh: "\uE5C9",
            BoldKorean: "\uE5BD",
            BoldN: "\uE5B7",
            BoldP: "\uE5C7",
            BoldRussion: "\uE5B9",
            BoldSerbian: "\uE5CA",
            BoldT: "\uE5C8",
            BookAnswers: "\uF8A4",
            BookingsLogo: "\uEDC7",
            BookmarkReport: "\uF76B",
            Bookmarks: "\uE8A4",
            BookmarksMirrored: "\uEA41",
            BorderAll: "\uE5F4",
            BorderDash: "\uF50A",
            BorderDot: "\uF50B",
            BorderInside: "\uE5F3",
            BorderInsideHorizontal: "\uE5F2",
            BorderInsideVertical: "\uE5F1",
            BorderNone: "\uE5F0",
            BoxAdditionSolid: "\uF2D4",
            BoxCheckmarkSolid: "\uF2D7",
            BoxLogo: "\uED75",
            BoxMultiplySolid: "\uF2D5",
            BoxPlaySolid: "\uF2D6",
            BoxSubtractSolid: "\uF2D3",
            BranchCommit: "\uF293",
            BranchCompare: "\uF294",
            BranchFork: "\uF173",
            BranchFork2: "\uF291",
            BranchLocked: "\uF292",
            BranchMerge: "\uF295",
            BranchPullRequest: "\uF296",
            BranchSearch: "\uF297",
            BranchShelveset: "\uF298",
            Breadcrumb: "\uEF8C",
            Breakfast: "\uF49C",
            Brightness: "\uE706",
            Broom: "\uEA99",
            BrowserScreenShot: "\uEBED",
            BrowserTab: "\uF5D7",
            BrowserTabScreenshot: "\uF5D8",
            Brunch: "\uF49D",
            Brush: "\uECFF",
            BucketColor: "\uF1B6",
            BucketColorFill: "\uF1B7",
            BufferTimeAfter: "\uF0D0",
            BufferTimeBefore: "\uF0CF",
            BufferTimeBoth: "\uF0D1",
            Bug: "\uEBE8",
            BugAction: "\uE358",
            BugBlock: "\uE400",
            BugSolid: "\uF335",
            BugSync: "\uE3FF",
            BugWarning: "\uE357",
            Build: "\uF28F",
            BuildDefinition: "\uF6E9",
            BuildIssue: "\uF319",
            BuildQueue: "\uF24F",
            BuildQueueNew: "\uF250",
            BulkPageBlock: "\uE553",
            BulkUpload: "\uF548",
            BulletedList: "\uE8FD",
            BulletedList2: "\uF2C7",
            BulletedList2Mirrored: "\uF2C8",
            BulletedListBullet: "\uF793",
            BulletedListBulletMirrored: "\uF795",
            BulletedListMirrored: "\uEA42",
            BulletedListText: "\uF792",
            BulletedListTextMirrored: "\uF794",
            BulletedTreeList: "\uF84C",
            Bullseye: "\uF272",
            BullseyeTarget: "\uF5F0",
            BullseyeTargetDelete: "\uF6C1",
            BullseyeTargetEdit: "\uE319",
            Bus: "\uE806",
            BusinessCard: "\uE5FB",
            BusinessCenterLogo: "\uF4B2",
            BusinessHoursSign: "\uF310",
            BusinessRule: "\uE562",
            BusSolid: "\uEB47",
            ButtonControl: "\uF6C0",
            Cafe: "\uEC32",
            Cake: "\uECA4",
            CalculatedTable: "\uE4BE",
            Calculator: "\uE8EF",
            CalculatorAddition: "\uE948",
            CalculatorDelta: "\uE406",
            CalculatorEqualTo: "\uE94E",
            CalculatorGroup: "\uE462",
            CalculatorMultiply: "\uE947",
            CalculatorNotEqualTo: "\uF2D2",
            CalculatorPercentage: "\uE94C",
            CalculatorSubtract: "\uE949",
            Calendar: "\uE787",
            CalendarAgenda: "\uEE9A",
            CalendarDay: "\uE8BF",
            CalendarMirrored: "\uED28",
            CalendarReply: "\uE8F5",
            CalendarSettings: "\uF558",
            CalendarSettingsMirrored: "\uF559",
            CalendarWeek: "\uE8C0",
            CalendarWorkWeek: "\uEF51",
            CalendarYear: "\uE371",
            Calories: "\uECAD",
            CaloriesAdd: "\uF172",
            Camera: "\uE722",
            CampaignTemplate: "\uF811",
            Cancel: "\uE711",
            CannedChat: "\uF0F2",
            CanvasAppTemplate32: "\uE5FE",
            Car: "\uE804",
            CareActivity: "\uE549",
            CarePlan: "\uE54A",
            CarePlanTemplate: "\uE61E",
            CaretBottomLeftCenter8: "\uF365",
            CaretBottomLeftSolid8: "\uF121",
            CaretBottomRightCenter8: "\uF364",
            CaretBottomRightSolid8: "\uF122",
            CaretDown8: "\uEDD8",
            CaretDownSolid8: "\uEDDC",
            CaretHollow: "\uE817",
            CaretHollowMirrored: "\uEA45",
            CaretLeft8: "\uEDD5",
            CaretLeftSolid8: "\uEDD9",
            CaretRight: "\uF06B",
            CaretRight8: "\uEDD6",
            CaretRightSolid8: "\uEDDA",
            CaretSolid: "\uE818",
            CaretSolid16: "\uEE62",
            CaretSolidAlt: "\uE483",
            CaretSolidDown: "\uF08E",
            CaretSolidLeft: "\uF08D",
            CaretSolidMirrored: "\uEA46",
            CaretSolidRight: "\uF08F",
            CaretSolidUp: "\uF090",
            CaretTopLeftCenter8: "\uF367",
            CaretTopLeftSolid8: "\uEF54",
            CaretTopRightCenter8: "\uF366",
            CaretTopRightSolid8: "\uEF55",
            CaretUp8: "\uEDD7",
            CaretUpSolid8: "\uEDDB",
            Cat: "\uED7F",
            CategoryClassification: "\uE48C",
            CC: "\uE7F0",
            CCSolid: "\uE4F4",
            CellPhone: "\uE8EA",
            Certificate: "\uEB95",
            CertifiedDatabase: "\uF5BB",
            ChangeEntitlements: "\uE310",
            Chart: "\uE999",
            CharticulatorArrangePolar: "\uE632",
            CharticulatorArrangePolarAngles: "\uE633",
            CharticulatorBand: "\uE634",
            CharticulatorGuideCoordinator: "\uE635",
            CharticulatorGuideX: "\uE636",
            CharticulatorGuideY: "\uE637",
            CharticulatorLegend: "\uE638",
            CharticulatorLine: "\uE639",
            CharticulatorLineStyleDashed: "\uE63A",
            CharticulatorLineStyleDotted: "\uE63B",
            CharticulatorLinkingData: "\uE63C",
            CharticulatorLinkingSequence: "\uE63D",
            CharticulatorOrderColumn: "\uE63E",
            CharticulatorOrderRow: "\uE63F",
            CharticulatorPlotCartesian: "\uE640",
            CharticulatorPlotCurve: "\uE641",
            CharticulatorPolarCoordinates: "\uE642",
            CharticulatorSpiral: "\uE643",
            CharticulatorStackRadial: "\uE644",
            CharticulatorStackY: "\uE645",
            ChartSeries: "\uF513",
            ChartTemplate: "\uF812",
            ChartXAngle: "\uF514",
            ChartYAngle: "\uF515",
            Chat: "\uE901",
            ChatBot: "\uF08B",
            ChatInviteFriend: "\uECFE",
            ChatSettings: "\uE600",
            ChatSolid: "\uF344",
            Checkbox: "\uE739",
            CheckboxComposite: "\uE73A",
            CheckboxCompositeReversed: "\uE73D",
            CheckboxFill: "\uE73B",
            CheckboxIndeterminate: "\uE73C",
            CheckboxIndeterminateCombo: "\uF16E",
            CheckedOutByOther12: "\uF630",
            CheckedOutByYou12: "\uF631",
            CheckList: "\uE9D5",
            CheckListCheck: "\uF7A9",
            CheckListCheckMirrored: "\uF7AB",
            CheckListText: "\uF7A8",
            CheckListTextMirrored: "\uF7AA",
            CheckMark: "\uE73E",
            ChevronDown: "\uE70D",
            ChevronDownEnd: "\uF5E4",
            ChevronDownEnd6: "\uF36F",
            ChevronDownMed: "\uE972",
            ChevronDownSmall: "\uE96E",
            ChevronFold10: "\uF36A",
            ChevronLeft: "\uE76B",
            ChevronLeftEnd6: "\uF371",
            ChevronLeftMed: "\uE973",
            ChevronLeftSmall: "\uE96F",
            ChevronRight: "\uE76C",
            ChevronRightEnd6: "\uF372",
            ChevronRightMed: "\uE974",
            ChevronRightSmall: "\uE970",
            ChevronUnfold10: "\uF369",
            ChevronUp: "\uE70E",
            ChevronUpEnd: "\uE55B",
            ChevronUpEnd6: "\uF370",
            ChevronUpMed: "\uE971",
            ChevronUpSmall: "\uE96D",
            Childof: "\uF82D",
            ChoiceColumn: "\uE4AE",
            Chopsticks: "\uF4A2",
            ChromeBack: "\uE830",
            ChromeBackMirrored: "\uEA47",
            ChromeClose: "\uE8BB",
            ChromeFullScreen: "\uE92D",
            ChromeMinimize: "\uE921",
            ChromeRestore: "\uE923",
            ChronosLogo: "\uF541",
            CircleAddition: "\uF2E3",
            CircleAdditionSolid: "\uF2E4",
            CircleDollar: "\uEAED",
            CircleFill: "\uEA3B",
            CircleHalfFull: "\uED9E",
            CirclePause: "\uF2D9",
            CirclePauseSolid: "\uF2D8",
            CirclePlus: "\uEAEE",
            CircleRing: "\uEA3A",
            CircleShape: "\uF1A5",
            CircleShapeSolid: "\uF63C",
            CircleStop: "\uF2DC",
            CircleStopSolid: "\uF2DB",
            CityNext: "\uEC06",
            CityNext2: "\uEC07",
            ClassNotebookLogo16: "\uF488",
            ClassNotebookLogo32: "\uF486",
            ClassNotebookLogoFill16: "\uF489",
            ClassNotebookLogoFill32: "\uF487",
            ClassNotebookLogoInverse: "\uEDC8",
            ClassNotebookLogoInverse16: "\uF48B",
            ClassNotebookLogoInverse32: "\uF48A",
            ClassroomLogo: "\uEF75",
            Clear: "\uE894",
            ClearFilter: "\uEF8F",
            ClearFormatting: "\uEDDD",
            ClearFormattingA: "\uF79D",
            ClearFormattingEraser: "\uF79E",
            ClearNight: "\uE9C2",
            ClearSelection: "\uE8E6",
            ClearSelectionMirrored: "\uEA48",
            Clicked: "\uF268",
            ClinicalImpression: "\uE54B",
            ClipboardList: "\uF0E3",
            ClipboardListAdd: "\uE4EF",
            ClipboardListMirrored: "\uF0E4",
            ClipboardListQuestion: "\uE4F0",
            ClipboardListReply: "\uE4F1",
            ClipboardSolid: "\uF5DC",
            Clock: "\uE917",
            CloneToDesktop: "\uF28C",
            ClosedCaption: "\uEF84",
            ClosePane: "\uE89F",
            ClosePaneMirrored: "\uEA49",
            Cloud: "\uE753",
            CloudAdd: "\uECA9",
            CloudDownload: "\uEBD3",
            CloudEdit: "\uE4C8",
            CloudFlow: "\uE5EA",
            CloudImportExport: "\uEE55",
            CloudLink: "\uE4C9",
            CloudNotSynced: "\uEC9C",
            CloudSearch: "\uEDE4",
            CloudSecure: "\uE4D5",
            CloudUpload: "\uEC8E",
            CloudWeather: "\uE9BE",
            Cloudy: "\uE9BF",
            Cocktails: "\uEA9D",
            Code: "\uE943",
            CodeEdit: "\uF544",
            Coffee: "\uEAEF",
            CoffeeScript: "\uF2FA",
            CollapseContent: "\uF165",
            CollapseContentSingle: "\uF166",
            CollapseMenu: "\uEF66",
            CollegeFootball: "\uEB26",
            CollegeHoops: "\uEB25",
            Color: "\uE790",
            ColorSolid: "\uF354",
            Column: "\uE438",
            ColumnFunction: "\uE4C2",
            ColumnLeftTwoThirds: "\uF1D6",
            ColumnLeftTwoThirdsEdit: "\uF324",
            ColumnOptions: "\uF317",
            ColumnQuestion: "\uE4C0",
            ColumnQuestionMirrored: "\uE4C1",
            ColumnRightTwoThirds: "\uF1D7",
            ColumnRightTwoThirdsEdit: "\uF325",
            ColumnSigma: "\uE4BF",
            ColumnVerticalSection: "\uF81E",
            ColumnVerticalSectionEdit: "\uF806",
            Combine: "\uEDBB",
            Combobox: "\uF516",
            CommandPrompt: "\uE756",
            Comment: "\uE90A",
            CommentActive: "\uF804",
            CommentAdd: "\uF2B3",
            CommentNext: "\uF2B4",
            CommentPrevious: "\uF2B5",
            CommentSolid: "\uE30E",
            CommentUrgent: "\uF307",
            Commitments: "\uEC4D",
            CommonDataServiceCDS: "\uE377",
            CommunicationDetails: "\uE4CF",
            CommunicationDetailsMirrored: "\uE4D0",
            Communications: "\uE95A",
            CompanyDirectory: "\uEF0D",
            CompanyDirectoryMirrored: "\uEF2B",
            Compare: "\uF057",
            CompareUneven: "\uE42E",
            CompassNW: "\uE942",
            Completed: "\uE930",
            Completed12: "\uE559",
            CompletedSolid: "\uEC61",
            ComplianceAudit: "\uE369",
            ConfigurationSolid: "\uF334",
            ConnectContacts: "\uEFD4",
            ConnectVirtualMachine: "\uEE9D",
            ConstructionCone: "\uE98F",
            ConstructionConeSolid: "\uF339",
            Contact: "\uE77B",
            ContactCard: "\uEEBD",
            ContactCardSettings: "\uF556",
            ContactCardSettingsMirrored: "\uF557",
            ContactHeart: "\uF862",
            ContactInfo: "\uE779",
            ContactLink: "\uF25F",
            ContactList: "\uF7E5",
            ContactLock: "\uF400",
            ContentFeed: "\uE428",
            ContentSettings: "\uF647",
            ContentUnderstandingApp: "\uE4FB",
            ContextMenu: "\uF37C",
            Contrast: "\uE7A1",
            Copy: "\uE8C8",
            CopyEdit: "\uE464",
            CortanaLogoBeckonInner: "\uF4C6",
            CortanaLogoBeckonOuter: "\uF4C7",
            CortanaLogoInner: "\uE832",
            CortanaLogoOuter: "\uE831",
            CortanaLogoReadyInner: "\uF4C8",
            CortanaLogoReadyOuter: "\uF4C9",
            CostContralLedgerAdmin: "\uF208",
            CostControl: "\uF207",
            Cotton: "\uEAF3",
            Count: "\uE9EE",
            Coupon: "\uF7BC",
            CPlusPlus: "\uF2F4",
            CPlusPlusLanguage: "\uF2F3",
            CreateMailRule: "\uF67A",
            Cricket: "\uEB1E",
            CriticalErrorSolid: "\uF5C9",
            CRMProcesses: "\uEFB1",
            CRMReport: "\uEFFE",
            CRMServices: "\uEFD2",
            Crop: "\uE7A8",
            Crown: "\uED01",
            CrownSolid: "\uF336",
            CSharp: "\uF2F0",
            CSharpLanguage: "\uF2EF",
            CSS: "\uEBEF",
            CtrlButton: "\uE4B8",
            CubeShape: "\uF1AA",
            CubeShapeSolid: "\uE421",
            Currency: "\uEAF5",
            CustomEntity: "\uEFF7",
            CustomerAssets: "\uF426",
            CustomizeToolbar: "\uF828",
            CustomList: "\uEEBE",
            CustomListMirrored: "\uEEBF",
            Cut: "\uE8C6",
            Cycling: "\uEAC7",
            D365BusinessCentral: "\uF833",
            D365CoreHR: "\uF6BD",
            D365CustomerInsights: "\uF3C8",
            D365CustomerVoiceApp: "\uE4F7",
            D365ProjectOperations: "\uE432",
            D365TalentInsight: "\uF6BC",
            D365TalentLearn: "\uF6BB",
            DashboardAdd: "\uF52D",
            Database: "\uEFC7",
            DatabaseBlock: "\uE617",
            DatabaseSource: "\uE30A",
            DatabaseSync: "\uF842",
            DatabaseView: "\uE437",
            DataConnectionLibrary: "\uEEB7",
            DataEnrichment: "\uE4F5",
            DataFlow: "\uE577",
            Dataflows: "\uF7DD",
            DataflowsLink: "\uE366",
            DataManagementSettings: "\uEFC8",
            DateTime: "\uEC92",
            DateTime12: "\uF38F",
            DateTime2: "\uEA17",
            DateTimeMirrored: "\uEE93",
            DeactivateOrders: "\uEFE1",
            Decimals: "\uF218",
            DecisionSolid: "\uF350",
            DeclineCall: "\uF405",
            DecreaseIndent: "\uE39B",
            DecreaseIndentArrow: "\uF7A3",
            DecreaseIndentArrowMirrored: "\uF7A7",
            DecreaseIndentMirrored: "\uE39C",
            DecreaseIndentText: "\uF7A2",
            DecreaseIndentTextMirrored: "\uF7A6",
            DefaultRatio: "\uF529",
            DefectSolid: "\uF449",
            DefenderApp: "\uE83D",
            DefenderBadge12: "\uF0FB",
            DefenderTVM: "\uF6B3",
            Delete: "\uE74D",
            DeleteColumns: "\uF64E",
            DeleteRows: "\uF64F",
            DeleteRowsMirrored: "\uF650",
            DeleteTable: "\uF651",
            DeliveryTruck: "\uEBF4",
            DelveAnalytics: "\uEEEE",
            DelveAnalyticsLogo: "\uEDCA",
            DelveLogo: "\uF280",
            DelveLogoFill: "\uF281",
            DelveLogoInverse: "\uED76",
            DensityComfy: "\uE4BA",
            DensityDefault: "\uE4B9",
            DependencyAdd: "\uE344",
            DependencyRemove: "\uE345",
            Deploy: "\uF29D",
            Descending: "\uEDC1",
            Design: "\uEB3C",
            DesktopFlow: "\uE4F3",
            DesktopScreenshot: "\uF5D9",
            DeveloperTools: "\uEC7A",
            DeviceBug: "\uE424",
            DeviceOff: "\uE402",
            DeviceRun: "\uE401",
            Devices2: "\uE975",
            Devices3: "\uEA6C",
            Devices4: "\uEB66",
            Diagnostic: "\uE9D9",
            DiagnosticDataBarTooltip: "\uF7DF",
            DiagnosticDataViewerApp: "\uF568",
            Dialpad: "\uE75F",
            Diamond: "\uED02",
            DiamondSolid: "\uF34C",
            DiamondUser: "\uE4F9",
            Dictionary: "\uE82D",
            DictionaryRemove: "\uF69A",
            DietPlanNotebook: "\uEAC8",
            DiffInline: "\uF309",
            DiffSideBySide: "\uF30A",
            DisableUpdates: "\uE8D8",
            DisconnectVirtualMachine: "\uF873",
            Dislike: "\uE8E0",
            DislikeSolid: "\uF3C0",
            DistributeDown: "\uF76A",
            DockerLogo: "\uF7F8",
            DockLeft: "\uE90C",
            DockLeftMirrored: "\uEA4C",
            DockRight: "\uE90D",
            DocLibrary: "\uEEB8",
            DocsLogoInverse: "\uEDCB",
            Document: "\uE8A5",
            DocumentApproval: "\uF28B",
            Documentation: "\uEC17",
            DocumentManagement: "\uEFFC",
            DocumentReply: "\uEF57",
            DocumentSearch: "\uEF6C",
            DocumentSet: "\uEED6",
            DOM: "\uEC8D",
            DonutChart: "\uF368",
            Door: "\uEB75",
            DoubleBookmark: "\uEB8F",
            DoubleChevronDown: "\uEE04",
            DoubleChevronDown12: "\uEE97",
            DoubleChevronDown8: "\uF36B",
            DoubleChevronLeft: "\uEDBE",
            DoubleChevronLeft12: "\uEE98",
            DoubleChevronLeft8: "\uF36D",
            DoubleChevronLeftMed: "\uE991",
            DoubleChevronLeftMedMirrored: "\uEA4D",
            DoubleChevronRight: "\uEDBF",
            DoubleChevronRight12: "\uEE99",
            DoubleChevronRight8: "\uF36E",
            DoubleChevronUp: "\uEDBD",
            DoubleChevronUp12: "\uEE96",
            DoubleChevronUp8: "\uF36C",
            DoubleColumn: "\uF1D4",
            DoubleColumnEdit: "\uF322",
            DoubleDownArrow: "\uF769",
            Down: "\uE74B",
            Download: "\uE896",
            DownloadDocument: "\uF549",
            DragObject: "\uF553",
            DrillDown: "\uF532",
            DrillDownSolid: "\uF533",
            DrillExpand: "\uF534",
            DrillShow: "\uF535",
            DrillThrough: "\uF5B9",
            DriverOff: "\uE3FB",
            DRM: "\uECA8",
            Drop: "\uEB42",
            DropboxLogo: "\uED77",
            Dropdown: "\uEDC5",
            DropShape: "\uF1A8",
            DropShapeSolid: "\uF63F",
            DuplicateRow: "\uF82A",
            Duststorm: "\uE9CD",
            DynamicList: "\uE491",
            Dynamics365Logo: "\uEDCC",
            DynamicSMBLogo: "\uEDCD",
            EaseOfAccess: "\uE776",
            EatDrink: "\uE807",
            EdgeLogo: "\uE3AB",
            EdgeLogo16: "\uE3AA",
            EdgeOldLogo: "\uEC60",
            eDiscovery: "\uE370",
            Edit: "\uE70F",
            EditContact: "\uEFD3",
            EditCreate: "\uF3C9",
            EditEvent: "\uF05B",
            EditListPencil: "\uE61B",
            EditMail: "\uEF61",
            EditMirrored: "\uEB7E",
            EditNote: "\uED9D",
            EditPhoto: "\uEF77",
            EditSolid12: "\uF4B5",
            EditSolidMirrored12: "\uF4B6",
            EditStyle: "\uEF60",
            EditTable: "\uE4C4",
            Education: "\uE7BE",
            EgnyteLogo: "\uF373",
            Ellipse: "\uF4FB",
            Embed: "\uECCE",
            EMI: "\uE731",
            Emoji: "\uE899",
            Emoji2: "\uE76E",
            EmojiDisappointed: "\uEA88",
            EmojiNeutral: "\uEA87",
            EmojiTabSymbols: "\uED58",
            EmptyRecycleBin: "\uEF88",
            Encounter: "\uE54C",
            Encryption: "\uF69D",
            EndPointSolid: "\uEB4B",
            EngineeringGroup: "\uF362",
            EntitlementPolicy: "\uE346",
            EntitlementRedemption: "\uE347",
            EntityExtraction: "\uE467",
            EntryDecline: "\uF555",
            EntryView: "\uF554",
            Equalizer: "\uE9E9",
            EraseTool: "\uE75C",
            Error: "\uE783",
            ErrorBadge: "\uEA39",
            ErrorBadge12: "\uE558",
            Event: "\uECA3",
            Event12: "\uF763",
            EventAccepted: "\uF422",
            EventDate: "\uF059",
            EventDateMissed12: "\uF764",
            EventDeclined: "\uF425",
            EventInfo: "\uED8B",
            EventTentative: "\uF423",
            EventTentativeMirrored: "\uF424",
            EventToDoLogo: "\uF869",
            ExcelDocument: "\uEF73",
            ExcelLogo: "\uF1E5",
            ExcelLogo16: "\uF397",
            ExcelLogoInverse: "\uEC28",
            ExcelLogoInverse16: "\uF396",
            ExchangeLogo: "\uF284",
            ExchangeLogoInverse: "\uED78",
            ExerciseTracker: "\uEACC",
            ExpandMenu: "\uEF67",
            ExploreContent: "\uECCD",
            ExploreContentSingle: "\uF164",
            ExploreData: "\uF5B6",
            Export: "\uEDE1",
            ExportMirrored: "\uEDE2",
            ExpressRouteCircuits: "\uE557",
            ExternalBuild: "\uF445",
            ExternalGit: "\uF665",
            ExternalTFVC: "\uF446",
            ExternalUser: "\uE4CA",
            ExternalXAML: "\uF447",
            Eyedropper: "\uEF3C",
            EyeShadow: "\uF7EB",
            F12DevTools: "\uEBEE",
            FabricAssetLibrary: "\uF09C",
            FabricChannelFolder: "\uE4FA",
            FabricDataConnectionLibrary: "\uF09D",
            FabricDocLibrary: "\uF09E",
            FabricFolder: "\uF0A9",
            FabricFolderConfirm: "\uF7FF",
            FabricFolderFill: "\uF0AA",
            FabricFolderLink: "\uE45C",
            FabricFolderSearch: "\uF0A4",
            FabricFolderUpload: "\uE3AC",
            FabricFormLibrary: "\uF09F",
            FabricFormLibraryMirrored: "\uF0A0",
            FabricMovetoFolder: "\uF0A5",
            FabricNetworkFolder: "\uF5E6",
            FabricNewFolder: "\uF0AB",
            FabricOpenFolderHorizontal: "\uF0A8",
            FabricPictureLibrary: "\uF0AC",
            FabricPublicFolder: "\uF0A3",
            FabricReportLibrary: "\uF0A1",
            FabricReportLibraryMirrored: "\uF0A2",
            FabricSyncFolder: "\uF0A7",
            FabricTextHighlight: "\uF79C",
            FabricTextHighlightComposite: "\uF7DA",
            FabricUnsyncFolder: "\uF0A6",
            FabricUserFolder: "\uF5E5",
            FacebookLogo: "\uECB3",
            Factory: "\uE60E",
            Family: "\uEBDA",
            FangBody: "\uECEB",
            FastForward: "\uEB9D",
            FastForwardEightX: "\uE443",
            FastForwardFourX: "\uE442",
            FastForwardOneFiveX: "\uE440",
            FastForwardOneX: "\uE43F",
            FastForwardPointFiveX: "\uE43E",
            FastForwardTwoX: "\uE441",
            FastMode: "\uF19A",
            Favicon: "\uE737",
            FavoriteList: "\uE728",
            FavoriteStar: "\uE734",
            FavoriteStarFill: "\uE735",
            Fax: "\uEF5C",
            Feedback: "\uED15",
            FeedbackRequestMirroredSolid: "\uF35A",
            FeedbackRequestSolid: "\uF359",
            FeedbackResponseSolid: "\uF35B",
            Ferry: "\uE7E3",
            FerrySolid: "\uEB48",
            FieldChanged: "\uF2C3",
            FieldEmpty: "\uF2C1",
            FieldFilled: "\uF2C2",
            FieldNotChanged: "\uF2C4",
            FieldReadOnly: "\uF442",
            FieldRequired: "\uF443",
            FileASPX: "\uF2E9",
            FileBug: "\uF30D",
            FileCode: "\uF30E",
            FileComment: "\uF30F",
            FileCSS: "\uF2EA",
            FileHTML: "\uF2ED",
            FileImage: "\uF311",
            FileJAVA: "\uF2E8",
            FileLess: "\uF2EC",
            FileOff: "\uE3FC",
            FilePDB: "\uF2E5",
            FileRequest: "\uF789",
            FileSass: "\uF2EB",
            FileSQL: "\uF2E7",
            FileSymlink: "\uF312",
            FileSystem: "\uE433",
            FileTemplate: "\uF2E6",
            FileTypeSolution: "\uF387",
            FileYML: "\uF5DA",
            Filter: "\uE71C",
            FilterAscending: "\uF21A",
            FilterDescending: "\uF21B",
            Filters: "\uE795",
            FilterSettings: "\uF76C",
            FilterSolid: "\uF412",
            FiltersSolid: "\uF353",
            Financial: "\uE7BB",
            FinancialMirroredSolid: "\uF347",
            FinancialSolid: "\uF346",
            Fingerprint: "\uE928",
            FitPage: "\uE9A6",
            FitWidth: "\uE9A7",
            FiveTileGrid: "\uF274",
            FixedAssetManagement: "\uEF93",
            FixedColumnWidth: "\uE3EA",
            Flag: "\uE7C1",
            FlameSolid: "\uF1F3",
            FlashAuto: "\uE95C",
            Flashlight: "\uE754",
            FlashOff: "\uEA6E",
            FlickDown: "\uE935",
            FlickLeft: "\uE937",
            FlickRight: "\uE938",
            FlickUp: "\uE936",
            Flow: "\uEF90",
            FlowChart: "\uE9D4",
            Flower: "\uF54E",
            FlowTemplate: "\uE49C",
            FlowTrigger: "\uE60C",
            FluidLogo: "\uE48A",
            FocalPoint: "\uF277",
            Focus: "\uEA6F",
            FocusView: "\uF1A3",
            Fog: "\uE9CB",
            Folder: "\uE8B7",
            FolderFill: "\uE8D5",
            FolderHorizontal: "\uF12B",
            FolderList: "\uF2CE",
            FolderListMirrored: "\uF2CF",
            FolderOpen: "\uE838",
            FolderQuery: "\uF2CD",
            FolderSearch: "\uEF65",
            FollowUser: "\uEE05",
            Font: "\uE8D2",
            FontColor: "\uE8D3",
            FontColorA: "\uF4EC",
            FontColorKorean: "\uE5BE",
            FontColorSwatch: "\uF4ED",
            FontDecrease: "\uE8E7",
            FontIncrease: "\uE8E8",
            FontSize: "\uE8E9",
            FontSize2: "\uE3C0",
            FontStyleKorean: "\uE5BA",
            Footer: "\uF82E",
            FormatPainter: "\uE3DC",
            FormLibrary: "\uEEB9",
            FormLibraryMirrored: "\uEEBA",
            FormProcessing: "\uE48B",
            Forum: "\uE378",
            Forward: "\uE72A",
            ForwardEvent: "\uED8C",
            Freezing: "\uE9EF",
            FreezingRain: "\uE475",
            Frigid: "\uE9CA",
            FrontCamera: "\uE96B",
            FSharp: "\uF2F6",
            FSharpLanguage: "\uF2F5",
            FullCircleMask: "\uE91F",
            FullHistory: "\uF31C",
            FullScreen: "\uE740",
            FullView: "\uF1A2",
            FullWidth: "\uF2FE",
            FullWidthEdit: "\uF2FF",
            FunctionalManagerDashboard: "\uF542",
            FunnelChart: "\uE9F1",
            GallatinLogo: "\uF496",
            Game: "\uE7FC",
            Gather: "\uE460",
            Generate: "\uE9DA",
            GenericScan: "\uEE6F",
            GenericScanFilled: "\uF7E3",
            GIF: "\uF4A9",
            Giftbox: "\uEC1F",
            GiftboxOpen: "\uF133",
            GiftBoxSolid: "\uF341",
            GiftCard: "\uEB8E",
            GitFork: "\uF661",
            GitGraph: "\uF2CA",
            GitHubLogo: "\uF65E",
            GitLogo: "\uF65D",
            Glasses: "\uEA16",
            Glimmer: "\uECF4",
            GlobalNavButton: "\uE700",
            GlobalNavButtonActive: "\uF89F",
            Globe: "\uE774",
            Globe2: "\uF49A",
            GlobeFavorite: "\uEF53",
            Go: "\uE8AD",
            Golf: "\uEB1F",
            GoMirrored: "\uEA4F",
            GoogleDriveLogo: "\uEE0B",
            GoogleDriveLogoBottomBlue: "\uF375",
            GoogleDriveLogoLeftGreen: "\uF374",
            GoogleDriveLogoRightYellow: "\uF376",
            GoToDashboard: "\uEEED",
            GotoToday: "\uE8D1",
            GradleLogo32: "\uF5D4",
            GraphSymbol: "\uE35D",
            GreetingCard: "\uF54B",
            GridViewLarge: "\uF234",
            GridViewMedium: "\uF233",
            GridViewSmall: "\uF232",
            GripperBarHorizontal: "\uE76F",
            GripperBarVertical: "\uE784",
            GripperDotsVertical: "\uF772",
            GripperTool: "\uE75E",
            Group: "\uE902",
            GroupedAscending: "\uEE67",
            GroupedDescending: "\uEE66",
            GroupedList: "\uEF74",
            GroupList: "\uF168",
            GroupObject: "\uF4F1",
            GroupRemove: "\uE495",
            GUID: "\uF52B",
            Guitar: "\uF49B",
            HailDay: "\uEA00",
            HailNight: "\uEA13",
            HalfAlpha: "\uE97E",
            HalfCircle: "\uF501",
            HandsFree: "\uEAD0",
            Handwriting: "\uE929",
            HardDrive: "\uEDA2",
            HardDriveGroup: "\uF18F",
            HardDriveLock: "\uF55A",
            HardDriveUnlock: "\uF55B",
            HazyDay: "\uE46B",
            HazyNight: "\uE479",
            Header: "\uF82F",
            Header1: "\uEA19",
            Header2: "\uEF36",
            Header3: "\uEF37",
            Header4: "\uEF38",
            Headset: "\uE95B",
            HeadsetSolid: "\uF348",
            Health: "\uE95E",
            HealthRefresh: "\uE3BD",
            HealthSolid: "\uF33F",
            Heart: "\uEB51",
            HeartBroken: "\uEA92",
            HeartFill: "\uEB52",
            Help: "\uE897",
            HelpMirrored: "\uEA51",
            HexaditeInvestigation: "\uE3F8",
            HexaditeInvestigationCancel: "\uE3F9",
            HexaditeInvestigationSemiAuto: "\uE3FA",
            Hexagon: "\uF4FE",
            Hide: "\uED1A",
            Hide2: "\uEF89",
            Hide3: "\uF6AC",
            HideVisualFilter: "\uF403",
            Highlight: "\uE7E6",
            HighlightMappedShapes: "\uF2A1",
            HintText: "\uF50F",
            HistoricalWeather: "\uEB43",
            History: "\uE81C",
            Home: "\uE80F",
            HomeDropdown: "\uE427",
            HomeGroup: "\uEC26",
            HomeSolid: "\uEA8A",
            HomeVerify: "\uF00E",
            HorizontalDistributeCenter: "\uF4F9",
            HorizontalTabKey: "\uE7FD",
            Hospital: "\uE91D",
            Hot: "\uECE2",
            Hotel: "\uE824",
            HourGlass: "\uEA03",
            Ice: "\uE473",
            IconSetsFlag: "\uF2A4",
            IDBadge: "\uF427",
            IgnoreConversation: "\uE372",
            ImageCrosshair: "\uF2C9",
            ImageDiff: "\uF30B",
            ImageInAR: "\uE420",
            ImagePixel: "\uF30C",
            ImageSearch: "\uF4E8",
            Import: "\uE8B5",
            ImportAllMirrored: "\uEA53",
            Important: "\uE8C9",
            ImportMirrored: "\uEA52",
            Inbox: "\uF41C",
            InboxActive: "\uE497",
            InboxCheck: "\uEF64",
            IncidentTriangle: "\uE814",
            IncomingCall: "\uE77E",
            IncreaseIndent: "\uE399",
            IncreaseIndentArrow: "\uF7A1",
            IncreaseIndentArrowMirrored: "\uF7A5",
            IncreaseIndentHanging: "\uE39D",
            IncreaseIndentHangingMirrored: "\uE39E",
            IncreaseIndentMirrored: "\uE39A",
            IncreaseIndentText: "\uF7A0",
            IncreaseIndentTextMirrored: "\uF7A4",
            IndentFirstLine: "\uE3DD",
            Info: "\uE946",
            Info12: "\uE55A",
            Info2: "\uEA1F",
            InformationBarriers: "\uF803",
            InfoSolid: "\uF167",
            InkingTool: "\uE76D",
            InputAddress: "\uE41E",
            Insert: "\uF278",
            InsertColumnsLeft: "\uF64A",
            InsertColumnsRight: "\uF64B",
            InsertRowsAbove: "\uF64C",
            InsertRowsBelow: "\uF64D",
            InsertSignatureLine: "\uF677",
            InsertTextBox: "\uEC7D",
            InsertTextBoxKorean: "\uE5D3",
            Insights: "\uE3AF",
            Installation: "\uE311",
            InstallToDrive: "\uF28D",
            IntermittentCloudsDay: "\uE46A",
            IntermittentCloudsNight: "\uE478",
            InternalInvestigation: "\uF854",
            InternetSharing: "\uE704",
            IntersectShape: "\uF8FD",
            Invoice: "\uE9DC",
            iOSAppStoreLogo: "\uEF8A",
            IOT: "\uF22C",
            IoTSecure: "\uE4D6",
            IRMForward: "\uF41F",
            IRMForwardMirrored: "\uF420",
            IRMReply: "\uF41D",
            IRMReplyMirrored: "\uF41E",
            IssueSolid: "\uF448",
            IssueTracking: "\uEEC0",
            IssueTrackingMirrored: "\uEEC1",
            Italic: "\uE8DB",
            ItalicC: "\uE5B2",
            ItalicD: "\uE5CE",
            ItalicK: "\uE5B6",
            ItalicKazakh: "\uE5D2",
            ItalicKorean: "\uE5BC",
            ItalicL: "\uE5D1",
            ItalicS: "\uE5CF",
            ItalicT: "\uE5D0",
            JavaLogo: "\uF7F9",
            JavaScriptLanguage: "\uF2EE",
            JenkinsLogo: "\uF663",
            JoinOnlineMeeting: "\uED8F",
            JS: "\uEBF0",
            KaizalaLogo: "\uF492",
            KeubernetesLogo: "\uF7FA",
            KeyboardClassic: "\uE765",
            KeyPhraseExtraction: "\uE395",
            KnowledgeArticle: "\uF000",
            KnowledgeManagementApp: "\uE4FC",
            Label: "\uE932",
            LadybugSolid: "\uF44A",
            Lamp: "\uEB19",
            LandscapeOrientation: "\uEF6B",
            LaptopSecure: "\uF552",
            LaptopSelected: "\uEC76",
            LargeGrid: "\uEECB",
            LearningApp: "\uE5D8",
            LearningTools: "\uF7DB",
            Leave: "\uF627",
            LeaveUser: "\uE3A8",
            Library: "\uE8F1",
            LibraryAddTo: "\uE60D",
            Lifesaver: "\uEF62",
            LifesaverLock: "\uEF63",
            Light: "\uE793",
            Lightbulb: "\uEA80",
            LightningBolt: "\uE945",
            LightningBoltSolid: "\uE45F",
            LightningSecure: "\uE4D3",
            LightSnow: "\uEA02",
            LightWeight: "\uF4EE",
            Like: "\uE8E1",
            LikeSolid: "\uF3BF",
            Line: "\uF4FC",
            LineChart: "\uE9E6",
            LineSpacing: "\uF517",
            LineStyle: "\uF50C",
            LineThickness: "\uF50D",
            Link: "\uE71B",
            Link12: "\uF6E3",
            LinkedDatabase: "\uF779",
            LinkedInLogo: "\uF20A",
            LinuxLogo32: "\uF5D3",
            List: "\uEA37",
            ListMirrored: "\uEA55",
            LiveSite: "\uF6A6",
            LocalAdmin: "\uF1FB",
            LocaleLanguage: "\uF2B7",
            Location: "\uE81D",
            LocationCircle: "\uE80E",
            LocationDot: "\uE827",
            LocationFill: "\uE920",
            LocationOutline: "\uF2D0",
            Lock: "\uE72E",
            Lock12: "\uF6E6",
            LockShare: "\uE455",
            LockSolid: "\uE9A2",
            LogRemove: "\uF316",
            LookupEntities: "\uF5B5",
            LowerBrightness: "\uEC8A",
            LowerCase: "\uE5EE",
            LyncLogo: "\uED79",
            M365InvoicingLogo: "\uF7C1",
            MachineLearning: "\uE3B8",
            Mail: "\uE715",
            MailAlert: "\uED80",
            MailAttached: "\uF774",
            MailCheck: "\uED81",
            MailFill: "\uE8A8",
            MailForward: "\uE89C",
            MailForwardMirrored: "\uEA56",
            MailLink: "\uEFAC",
            MailLowImportance: "\uED82",
            MailOptions: "\uF82C",
            MailPause: "\uED83",
            MailReminder: "\uF418",
            MailRepeat: "\uED84",
            MailReply: "\uE8CA",
            MailReplyAll: "\uE8C2",
            MailReplyAllMirrored: "\uEA58",
            MailReplyMirrored: "\uEA57",
            MailSchedule: "\uF72E",
            MailSecure: "\uE4D4",
            MailSolid: "\uF343",
            MailTentative: "\uF416",
            MailTentativeMirrored: "\uF417",
            MailUndelivered: "\uF415",
            ManagerSelfService: "\uEE23",
            Manufacturing: "\uE99C",
            MapDirections: "\uE816",
            MapLayers: "\uE81E",
            MapPin: "\uE707",
            MapPin12: "\uE3AE",
            MapPinSolid: "\uF52E",
            MarkAsProtected: "\uF6AE",
            MarkDownLanguage: "\uF2FB",
            Market: "\uEAFC",
            MarketDown: "\uEF42",
            MasterDatabase: "\uF5BA",
            MaximumValue: "\uF5BC",
            Medal: "\uEE38",
            MedalSolid: "\uF6B9",
            Media: "\uEA69",
            MediaAdd: "\uF510",
            Medical: "\uEAD4",
            MedicalCare: "\uE54D",
            MedicationAdmin: "\uE54E",
            MedicationRequest: "\uE54F",
            Megaphone: "\uE789",
            MegaphoneSolid: "\uF332",
            Memo: "\uE77C",
            Merge: "\uE7D5",
            MergeCase: "\uEFC9",
            MergeDuplicate: "\uF29A",
            Message: "\uE8BD",
            MessageFill: "\uEC70",
            MessageFriendRequest: "\uF055",
            MetricsFailure: "\uE4CE",
            MetricsInstall: "\uE4CD",
            MetricsUsage: "\uE4CC",
            MicOff: "\uEC54",
            MicOff2: "\uF781",
            Microphone: "\uE720",
            MicrosoftListsLogo48: "\uE4D9",
            MicrosoftStaffhubLogo: "\uF130",
            MicrosoftTranslatorLogo: "\uF782",
            MicrosoftTranslatorLogoBlue: "\uF853",
            MicrosoftTranslatorLogoGreen: "\uF852",
            MiniContract: "\uE93B",
            MiniContractMirrored: "\uEA59",
            MiniExpand: "\uE93A",
            MiniExpandMirrored: "\uEA5A",
            MiniLink: "\uE732",
            MinimumValue: "\uF5BD",
            MiracastLogoLarge: "\uEC16",
            MixerLogo: "\uF18B",
            MobileAngled: "\uE463",
            MobileReport: "\uF18A",
            MobileSelected: "\uEC75",
            ModelAppTemplate32: "\uE5FD",
            ModelingView: "\uF871",
            Money: "\uEAFD",
            More: "\uE712",
            MoreSports: "\uEB22",
            MoreVertical: "\uF2BC",
            MostyClearNight: "\uE476",
            MostyCloudyFlurriesDay: "\uE471",
            MostyCloudyFlurriesNight: "\uE47D",
            MostyCloudyShowersDay: "\uE46D",
            MostyCloudyTStormsDay: "\uE46F",
            MostyCloudyTStormsNight: "\uE47B",
            MostySunnyDay: "\uE468",
            MountainClimbing: "\uF6DB",
            Move: "\uE7C2",
            Movers: "\uEBCD",
            MoveToFolder: "\uE8DE",
            MSListsConnected: "\uE601",
            MSNLogo: "\uEB6C",
            MSNVideos: "\uEB1C",
            MSNVideosSolid: "\uF2DA",
            MSNVolume: "\uEB15",
            MTMLogo: "\uF44B",
            MultiSelect: "\uE762",
            MultiSelectMirrored: "\uEA98",
            MusicInCollection: "\uE940",
            MusicInCollectionFill: "\uEA36",
            MusicNote: "\uEC4F",
            MuteChat: "\uF17A",
            MyMoviesTV: "\uEE6C",
            MyNetwork: "\uEC27",
            Nav2DMapView: "\uE800",
            NavigateBack: "\uF2DD",
            NavigateBackMirrored: "\uF2DE",
            NavigateExternalInline: "\uF35F",
            NavigateForward: "\uF2DF",
            NavigateForwardMirrored: "\uF2E0",
            NavigationFlipper: "\uF51D",
            NetworkDeviceScanning: "\uE4F6",
            NetworkTower: "\uEC05",
            NewAnalyticsQuery: "\uF1E0",
            NewFolder: "\uE8F4",
            NewMail: "\uF7EA",
            News: "\uE900",
            NewsSearch: "\uF4E9",
            NewTeamProject: "\uF2B2",
            Next: "\uE893",
            NonprofitLogo32: "\uF495",
            NormalWeight: "\uF4EF",
            NoteForward: "\uED99",
            NotePinned: "\uED9A",
            NoteReply: "\uED98",
            NotExecuted: "\uF440",
            NotImpactedSolid: "\uF441",
            NPMLogo: "\uF660",
            NugetLogo: "\uF44C",
            NUIFace: "\uEB68",
            Number: "\uF691",
            NumberedList: "\uEA1C",
            NumberedListMirrored: "\uE398",
            NumberedListNumber: "\uF797",
            NumberedListNumberMirrored: "\uF799",
            NumberedListText: "\uF796",
            NumberedListTextMirrored: "\uF798",
            NumberField: "\uEDC4",
            NumberSequence: "\uF52A",
            NumberSymbol: "\uF7AC",
            Oauth: "\uE5C3",
            ObjectRecognition: "\uE4EE",
            Octagon: "\uF4FD",
            ODLink: "\uE4BB",
            ODLink12: "\uE4BC",
            OEM: "\uE74C",
            OfficeAddinsLogo: "\uEEC7",
            OfficeAssistantLogo: "\uEDCE",
            OfficeCatchUp: "\uE490",
            OfficeChat: "\uF70F",
            OfficeChatSolid: "\uF710",
            OfficeFormsLogo: "\uF434",
            OfficeFormsLogo16: "\uF436",
            OfficeFormsLogo24: "\uF43B",
            OfficeFormsLogoInverse: "\uEF86",
            OfficeFormsLogoInverse16: "\uF433",
            OfficeFormsLogoInverse24: "\uF43A",
            OfficeLogo: "\uEB6E",
            OfficeStoreLogo: "\uEDCF",
            OfficeVideoLogo: "\uF282",
            OfficeVideoLogoFill: "\uF283",
            OfficeVideoLogoInverse: "\uED7A",
            OfflineOneDriveParachute: "\uEEC8",
            OfflineOneDriveParachuteDisabled: "\uEEC9",
            OfflineStorage: "\uEC8C",
            OfflineStorageSolid: "\uF34E",
            Onboarding: "\uF3BA",
            OneDriveAdd: "\uEF32",
            OneDriveFileVault: "\uF838",
            OneDriveFolder16: "\uF53B",
            OneDriveLogo: "\uE941",
            OneNoteDocType: "\uF04F",
            OneNoteEduLogoInverse: "\uEDD0",
            OneNoteLogo: "\uF1E7",
            OneNoteLogo16: "\uF39A",
            OneNoteLogoInverse: "\uEC0D",
            OneNoteLogoInverse16: "\uF399",
            OpenEnrollment: "\uEF1C",
            OpenFile: "\uE8E5",
            OpenFolderHorizontal: "\uED25",
            OpenInNewTab: "\uF6AB",
            OpenInNewWindow: "\uE8A7",
            OpenPane: "\uE8A0",
            OpenPaneMirrored: "\uEA5B",
            OpenSource: "\uEBC2",
            OpenWith: "\uE7AC",
            OpenWithMirrored: "\uEA5C",
            OrderLock: "\uE4CB",
            Org: "\uECA6",
            Orientation: "\uE8B4",
            Orientation2: "\uF7E1",
            OutlookLogo: "\uF1E9",
            OutlookLogo16: "\uF39D",
            OutlookLogoInverse: "\uEB6D",
            OutlookLogoInverse16: "\uF39C",
            OutlookSpacesBucket: "\uE481",
            OutOfOffice: "\uED34",
            PAAction: "\uE60B",
            Package: "\uE7B8",
            Packages: "\uF318",
            Padding: "\uF518",
            PaddingBottom: "\uF51A",
            PaddingLeft: "\uF51B",
            PaddingRight: "\uF51C",
            PaddingTop: "\uF519",
            Page: "\uE7C3",
            PageAdd: "\uEA1A",
            PageArrowRight: "\uEFB8",
            PageBlock: "\uEFB5",
            PageCheckedin: "\uF104",
            PageCheckedOut: "\uF02C",
            PageData: "\uE31C",
            PageEdit: "\uEFB6",
            PageHeader: "\uECEE",
            PageHeaderEdit: "\uE31D",
            PageLeft: "\uE760",
            PageLink: "\uE302",
            PageList: "\uF106",
            PageListFilter: "\uF813",
            PageListMirroredSolid: "\uF33B",
            PageListSolid: "\uF33A",
            PageLock: "\uF43F",
            PagePermission: "\uE618",
            PageRemove: "\uEFBA",
            PageRight: "\uE761",
            PageShared: "\uF02D",
            PageSolid: "\uE729",
            PanoIndicator: "\uE7B0",
            Parachute: "\uF351",
            ParachuteSolid: "\uF352",
            Parameter: "\uF306",
            ParatureLogo: "\uED7B",
            ParkingLocation: "\uE811",
            ParkingLocationMirrored: "\uEA5E",
            ParkingMirroredSolid: "\uF34B",
            ParkingSolid: "\uF34A",
            PartlyClearNight: "\uE477",
            PartlyCloudyDay: "\uE9C0",
            PartlyCloudyNight: "\uE9C1",
            PartlySunnyDay: "\uE469",
            PartlySunnyFlurriesDay: "\uE472",
            PartlySunnyShowersDay: "\uE46E",
            PartlySunnyShowersNight: "\uE47A",
            PartlySunnyTStormsDay: "\uE470",
            PartlySunnyTStormsNight: "\uE47C",
            PartyLeader: "\uECA7",
            PassiveAuthentication: "\uF32A",
            PasswordField: "\uF6AA",
            Paste: "\uE77F",
            PasteAsCode: "\uF5D6",
            PasteAsText: "\uF5D5",
            Pause: "\uE769",
            PaymentCard: "\uE8C7",
            PBIAnomaliesMarker: "\uE554",
            PBIAnomaly: "\uE548",
            PBIDirectQuery: "\uE4E9",
            PBIDual: "\uE4EA",
            PBIGoalEntry: "\uE615",
            PBIGoalEntryAdd: "\uE616",
            PBIImport: "\uE4EB",
            PBILiveConnect: "\uE4EC",
            PBIReportTemplate: "\uE5EC",
            PC1: "\uE977",
            PDF: "\uEA90",
            PencilReply: "\uEF7B",
            Pentagon: "\uF4FF",
            PenWorkspace: "\uEDC6",
            People: "\uE716",
            PeopleAdd: "\uEA15",
            PeopleAlert: "\uED93",
            PeopleBlock: "\uED91",
            PeopleExternalShare: "\uE5EF",
            PeoplePause: "\uED94",
            PeopleRepeat: "\uED92",
            Permissions: "\uE8D7",
            PermissionsSolid: "\uF349",
            Personalize: "\uE771",
            Phishing: "\uF679",
            PhishingCampaign: "\uE48D",
            PhishingHook: "\uE48E",
            Phone: "\uE717",
            Photo: "\uE91B",
            Photo2: "\uEB9F",
            Photo2Add: "\uECAB",
            Photo2Fill: "\uF79F",
            Photo2Remove: "\uECAC",
            PhotoBlock: "\uE4C3",
            PhotoCollection: "\uE7AA",
            PhotoError: "\uE3F7",
            PhotoVideoMedia: "\uF0B1",
            Picture: "\uE8B9",
            PictureCenter: "\uF522",
            PictureFill: "\uF523",
            PictureLibrary: "\uEEC2",
            PicturePosition: "\uF524",
            PictureStretch: "\uF525",
            PictureTile: "\uF526",
            PieDouble: "\uEB04",
            PieSingle: "\uEB05",
            PieSingleSolid: "\uF530",
            Pill: "\uEACB",
            Pin: "\uE718",
            Pinned: "\uE840",
            PinnedFill: "\uE842",
            PinnedSolid: "\uF676",
            PinSolid12: "\uE352",
            PinSolidOff12: "\uE353",
            PinToTab: "\uE5E5",
            PivotChart: "\uF24C",
            PlainText: "\uF834",
            PlannerLogo: "\uEDD1",
            PlanView: "\uF360",
            Play: "\uE768",
            PlaybackRate1x: "\uEC57",
            PlayerSettings: "\uEF58",
            PlayResume: "\uF2C6",
            PlayReverse: "\uF3E5",
            PlayReverseResume: "\uF3E4",
            PlaySolid: "\uF5B0",
            Plug: "\uF300",
            PlugConnected: "\uF302",
            PlugDisconnected: "\uF303",
            PlugSolid: "\uF301",
            POI: "\uECAF",
            POISolid: "\uF2D1",
            PollResults: "\uF8A0",
            PopExpand: "\uE49A",
            PortalAppTemplate32: "\uE5FC",
            PostUpdate: "\uE8F3",
            PowerApps: "\uEDD2",
            PowerApps2Logo: "\uF092",
            PowerAppsLogo: "\uF091",
            PowerAppsTemplate: "\uE4AC",
            PowerAutomateLogo: "\uF4B1",
            PowerBILogo: "\uEA1E",
            PowerBILogo16: "\uF790",
            PowerBILogoBackplate16: "\uF791",
            PowerButton: "\uE7E8",
            PowerPointDocument: "\uEF72",
            PowerPointLogo: "\uF1EB",
            PowerPointLogo16: "\uF394",
            PowerPointLogoInverse: "\uEC2A",
            PowerPointLogoInverse16: "\uF393",
            PowerShell: "\uF1FD",
            PowerShell2: "\uF730",
            PowerStandby: "\uE55C",
            PowerVirtualAgentsLogo: "\uE484",
            Precipitation: "\uE9CF",
            PresenceChickletVideo: "\uE979",
            Presentation: "\uF6E4",
            Presentation12: "\uF6E5",
            Preview: "\uE8FF",
            PreviewBelow: "\uE5D5",
            PreviewLink: "\uE8A1",
            PreviewSideBySide: "\uE5D6",
            Previous: "\uE892",
            PrimaryCalendar: "\uF4AE",
            Print: "\uE749",
            PrintfaxPrinterFile: "\uE956",
            Priority: "\uE8D0",
            Process: "\uE9F3",
            ProcessAdvisor: "\uE5E4",
            Processing: "\uE9F5",
            ProcessingCancel: "\uE403",
            ProcessingPause: "\uE405",
            ProcessingRun: "\uE404",
            ProcessMap: "\uE9F6",
            ProcessMetaTask: "\uF290",
            Product: "\uECDC",
            ProductCatalog: "\uEFE8",
            ProductionFloorManagement: "\uEE29",
            ProductList: "\uE31E",
            ProductRelease: "\uEE2E",
            ProductVariant: "\uEE30",
            ProductWarning: "\uE5C0",
            ProfileSearch: "\uEF35",
            ProFootball: "\uEB27",
            ProgressLoopInner: "\uECDE",
            ProgressLoopOuter: "\uECDF",
            ProgressRing5: "\uEDF6",
            ProgressRingDots: "\uF16A",
            ProHockey: "\uEB28",
            Project2019Document: "\uE373",
            ProjectCollection: "\uF363",
            ProjectDocument: "\uF759",
            ProjectLogo16: "\uF480",
            ProjectLogo32: "\uF47E",
            ProjectLogoInverse: "\uEDD4",
            PromotedDatabase: "\uF77D",
            Pronouns: "\uE556",
            ProtectedDocument: "\uE8A6",
            ProtectionCenterLogo32: "\uF494",
            ProtectRestrict: "\uF22A",
            ProvisioningPackage: "\uE835",
            PublicCalendar: "\uEF6D",
            PublicContactCard: "\uEF6E",
            PublicContactCardMirrored: "\uF230",
            PublicEmail: "\uEF6F",
            PublicFolder: "\uEF70",
            PublishContent: "\uF0D4",
            PublishCourse: "\uF699",
            PublisherLogo: "\uF1ED",
            PublisherLogo16: "\uF3A0",
            PublisherLogoInverse16: "\uF39F",
            Puzzle: "\uEA86",
            PY: "\uF2F9",
            PythonLanguage: "\uF2F8",
            PythonLogoBlue: "\uF84D",
            PythonLogoYellow: "\uF84E",
            QandA: "\uF8A2",
            QandAMirror: "\uF8A3",
            QRCode: "\uED14",
            QuadColumn: "\uF66F",
            Quantity: "\uE9F8",
            QuarterCircle: "\uF502",
            QueryList: "\uF2B8",
            Questionnaire: "\uEE19",
            QuestionnaireMirrored: "\uEE4B",
            QueueAdvanced: "\uE62E",
            QuickNote: "\uE70B",
            QuickNoteSolid: "\uF338",
            Quotes: "\uF067",
            R: "\uF4EB",
            RadioBtnOff: "\uECCA",
            RadioBtnOn: "\uECCB",
            RadioBullet: "\uE915",
            Rain: "\uE9C4",
            RainShowersDay: "\uE9C3",
            RainShowersNight: "\uEA0F",
            RainSnow: "\uE9C7",
            Rate: "\uEB07",
            RawSource: "\uF299",
            ReactLogo: "\uF7FB",
            Read: "\uE8C3",
            ReadingMode: "\uE736",
            ReadingModeSolid: "\uF33D",
            ReadOutLoud: "\uF112",
            RealEstate: "\uE758",
            ReceiptCheck: "\uEF5B",
            ReceiptForward: "\uEF59",
            ReceiptProcessing: "\uE496",
            ReceiptReply: "\uEF5A",
            ReceiptTentative: "\uF41A",
            ReceiptTentativeMirrored: "\uF41B",
            ReceiptUndelivered: "\uF419",
            Recent: "\uE823",
            Record2: "\uEA3F",
            RecordRouting: "\uE62D",
            RecruitmentManagement: "\uEE12",
            RectangleShape: "\uF1A9",
            RectangleShapeSolid: "\uF640",
            RectangularClipping: "\uF407",
            RecurringEvent: "\uEF5D",
            RecurringTask: "\uEDB2",
            RecycleBin: "\uEF87",
            Redeploy: "\uF29E",
            RedEye: "\uE7B3",
            RedEye12: "\uE3AD",
            Redo: "\uE7A6",
            Refresh: "\uE72C",
            RegistryEditor: "\uF1FF",
            Relationship: "\uF003",
            ReleaseDefinition: "\uF6EA",
            ReleaseGate: "\uF7BE",
            ReleaseGateCheck: "\uF7BF",
            ReleaseGateError: "\uF7C0",
            ReminderGroup: "\uEBF8",
            ReminderPerson: "\uEBF7",
            ReminderTime: "\uEBF9",
            Remote: "\uE8AF",
            Remove: "\uE738",
            RemoveContent: "\uECC7",
            RemoveEvent: "\uED8A",
            RemoveFilter: "\uEB08",
            RemoveFromShoppingList: "\uF7D5",
            RemoveFromTrash: "\uF82B",
            RemoveLink: "\uED90",
            RemoveLinkChain: "\uF79A",
            RemoveLinkX: "\uF79B",
            RemoveOccurrence: "\uED9B",
            Rename: "\uE8AC",
            RenewalCurrent: "\uF545",
            RenewalFuture: "\uF546",
            ReopenPages: "\uED50",
            Repair: "\uE90F",
            RepeatAll: "\uE8EE",
            RepeatHeaderRows: "\uE3EB",
            RepeatOne: "\uE8ED",
            Reply: "\uE97A",
            ReplyAll: "\uEE0A",
            ReplyAllAlt: "\uEF5F",
            ReplyAllMirrored: "\uEE36",
            ReplyAlt: "\uEF5E",
            ReplyMirrored: "\uEE35",
            Repo: "\uF2CB",
            ReportAdd: "\uF52C",
            ReportAlert: "\uF721",
            ReportAlertMirrored: "\uF722",
            ReportDocument: "\uE9F9",
            ReportHacked: "\uE730",
            ReportLibrary: "\uEEBB",
            ReportLibraryMirrored: "\uEEBC",
            ReportLock: "\uF875",
            ReportTrophy: "\uE614",
            ReportWarning: "\uF569",
            RepoSolid: "\uF2CC",
            Rerun: "\uF8A1",
            ReservationOrders: "\uF845",
            Reset: "\uE423",
            ResetDevice: "\uED10",
            ResponsesMenu: "\uF768",
            ReturnKey: "\uE751",
            ReturnToSession: "\uED24",
            ReviewRequestMirroredSolid: "\uF357",
            ReviewRequestSolid: "\uF356",
            ReviewResponseSolid: "\uF358",
            ReviewSolid: "\uF355",
            RevToggleKey: "\uE845",
            RewardsLogo: "\uED4E",
            RewardsLogoArt64: "\uEEF2",
            RewardsLogoSolid: "\uED4F",
            Rewind: "\uEB9E",
            RewindEightX: "\uE449",
            RewindFourX: "\uE448",
            RewindOneFiveX: "\uE446",
            RewindOneX: "\uE445",
            RewindPointFiveX: "\uE444",
            RewindTwoX: "\uE447",
            Ribbon: "\uE9D1",
            RibbonSolid: "\uF345",
            RightDoubleQuote: "\uE9B1",
            RightTriangle: "\uF500",
            Ringer: "\uEA8F",
            RingerActive: "\uE498",
            RingerOff: "\uF2C5",
            RingerRemove: "\uF279",
            RingerSolid: "\uEF3A",
            Robot: "\uE99A",
            Rocket: "\uF3B3",
            Room: "\uED9F",
            Rotate: "\uE7AD",
            Rotate90Clockwise: "\uF80D",
            Rotate90CounterClockwise: "\uF80E",
            RowsChild: "\uF29C",
            RowsGroup: "\uF29B",
            RubyGemsLogo: "\uF850",
            Rugby: "\uEB2D",
            Running: "\uEADA",
            RustLanguageLogo: "\uF84F",
            Sad: "\uE757",
            SadSolid: "\uF33E",
            SamsungGallery: "\uE4E2",
            Save: "\uE74E",
            SaveAll: "\uF203",
            SaveAndClose: "\uF038",
            SaveAs: "\uE792",
            SavedOffline: "\uE546",
            SaveTemplate: "\uF6EC",
            SaveToMobile: "\uF7E0",
            Savings: "\uEB0B",
            ScaleUp: "\uED09",
            ScaleVolume: "\uF18C",
            ScatterChart: "\uEFEB",
            ScheduleEventAction: "\uF1EF",
            SchoolDataSyncLogo: "\uE34C",
            ScopeTemplate: "\uF2B0",
            Screen: "\uEF39",
            ScreenCast: "\uF7E2",
            ScreenPreviewOn: "\uF11E",
            ScreenTime: "\uF182",
            Script: "\uF03A",
            ScrollUpDown: "\uEC8F",
            SDCard: "\uE7F1",
            Search: "\uE721",
            SearchAndApps: "\uE773",
            SearchArt64: "\uEEF5",
            SearchBookmark: "\uF5B8",
            SearchCalendar: "\uF4AF",
            SearchData: "\uF3F1",
            SearchIssue: "\uF09A",
            SearchIssueMirrored: "\uF09B",
            SearchNearby: "\uE820",
            SecondaryNav: "\uF814",
            Section: "\uEC0C",
            Sections: "\uEF76",
            SecurityCamera: "\uEB35",
            SecurityGroup: "\uED85",
            SecurityTest: "\uE48F",
            SeeDo: "\uE808",
            SelectAll: "\uE8B3",
            Sell: "\uEB0C",
            SemiboldWeight: "\uF4F0",
            Send: "\uE724",
            SendMirrored: "\uEA63",
            SentimentAnalysis: "\uE393",
            Separator: "\uF35E",
            Server: "\uF201",
            ServerEnviroment: "\uF29F",
            ServerProcesses: "\uF1FE",
            ServiceOff: "\uE3FD",
            SetAction: "\uF071",
            Settings: "\uE713",
            SettingsAdd: "\uE35A",
            SettingsSecure: "\uE4D2",
            SettingsSync: "\uE359",
            ShakeDevice: "\uF80A",
            Shapes: "\uEC7C",
            ShapeSolid: "\uE422",
            Share: "\uE72D",
            SharedDatabase: "\uE3D9",
            ShareiOS: "\uEF79",
            Sharepoint2013LogoInverse: "\uE480",
            SharepointAppIcon16: "\uE365",
            SharepointLogo: "\uF27E",
            SharepointLogoInverse: "\uED18",
            Shield: "\uEA18",
            ShieldAlert: "\uF7D7",
            ShieldSolid: "\uF340",
            Shirt: "\uED00",
            Shop: "\uE719",
            ShoppingCart: "\uE7BF",
            ShoppingCartSolid: "\uF342",
            ShopServer: "\uF2B6",
            Showers: "\uE46C",
            ShowGrid: "\uF7DE",
            ShowResults: "\uE8BC",
            ShowResultsMirrored: "\uEA65",
            ShowTimeAs: "\uF787",
            ShowVisualFilter: "\uF4DE",
            SidePanel: "\uEF52",
            SidePanelMirrored: "\uF221",
            Signin: "\uF286",
            SignOut: "\uF3B1",
            SimplifiedView: "\uE5C1",
            SingleBookmark: "\uEDFF",
            SingleBookmarkSolid: "\uEE00",
            SingleColumn: "\uF1D3",
            SingleColumnEdit: "\uF321",
            SIPMove: "\uE759",
            SiteScan: "\uEBEC",
            SizeLegacy: "\uE2B2",
            SkipBack10: "\uED3C",
            SkipForward30: "\uED3D",
            SkiResorts: "\uEB45",
            SkypeArrow: "\uF748",
            SkypeCheck: "\uEF80",
            SkypeCircleArrow: "\uF747",
            SkypeCircleCheck: "\uEF7D",
            SkypeCircleClock: "\uEF7E",
            SkypeCircleMinus: "\uEF7F",
            SkypeCircleSlash: "\uF825",
            SkypeClock: "\uEF81",
            SkypeForBusinessLogo: "\uF0FC",
            SkypeForBusinessLogo16: "\uF40F",
            SkypeForBusinessLogoFill: "\uF27D",
            SkypeForBusinessLogoFill16: "\uF410",
            SkypeLogo: "\uEB6F",
            SkypeLogo16: "\uF40E",
            SkypeMessage: "\uEF83",
            SkypeMinus: "\uEF82",
            SkypeSlash: "\uF826",
            Sleet: "\uE474",
            Slider: "\uF527",
            SliderHandleSize: "\uF528",
            SliderThumb: "\uEC13",
            Slideshow: "\uE786",
            SmartGlassRemote: "\uF80B",
            SnapToGrid: "\uF7E4",
            Snooze: "\uF4BD",
            Snow: "\uE9C8",
            Snowflake: "\uEB46",
            SnowShowerDay: "\uE9FD",
            SnowShowerNight: "\uEA11",
            Soccer: "\uEB21",
            SocialListeningLogo: "\uED7C",
            Sort: "\uE8CB",
            SortDown: "\uEE69",
            SortLines: "\uE9D0",
            SortLinesAscending: "\uE43A",
            SortUp: "\uEE68",
            Source: "\uEB1B",
            Spacer: "\uF40D",
            Speakers: "\uE7F5",
            SpecialEvent: "\uF536",
            Speech: "\uEFA9",
            SpeechOff: "\uF8BA",
            SpeedHigh: "\uEC4A",
            Spelling: "\uF87B",
            Split: "\uEDBC",
            SplitObject: "\uF547",
            Sprint: "\uF3B0",
            SQLAnalyticsPool: "\uE434",
            SQLServerLogo: "\uE61A",
            Squalls: "\uE9CC",
            SquareShape: "\uF1A6",
            SquareShapeSolid: "\uF63D",
            Stack: "\uF26F",
            StackColumnChart: "\uE9FC",
            StackedBarChart: "\uF24D",
            StackedBarChartFull: "\uF668",
            StackedColumnChart2: "\uF666",
            StackedColumnChart2Fill: "\uF831",
            StackedLineChart: "\uF24E",
            StackIndicator: "\uE7FF",
            StaffNotebookLogo16: "\uF48E",
            StaffNotebookLogo32: "\uF48C",
            StaffNotebookLogoFill16: "\uF48F",
            StaffNotebookLogoFill32: "\uF48D",
            StaffNotebookLogoInverted16: "\uF491",
            StaffNotebookLogoInverted32: "\uF490",
            Starburst: "\uEF78",
            StarburstSolid: "\uF33C",
            StatusCircleBlock: "\uF140",
            StatusCircleBlock2: "\uF141",
            StatusCircleCheckmark: "\uF13E",
            StatusCircleErrorX: "\uF13D",
            StatusCircleExclamation: "\uF13C",
            StatusCircleInfo: "\uF13F",
            StatusCircleInner: "\uF137",
            StatusCircleOuter: "\uF136",
            StatusCircleQuestionMark: "\uF142",
            StatusCircleRing: "\uF138",
            StatusCircleSync: "\uF143",
            StatusErrorFull: "\uEB90",
            StatusTriangle: "\uEA82",
            StatusTriangleExclamation: "\uF13B",
            StatusTriangleInner: "\uF13A",
            StatusTriangleOuter: "\uF139",
            Step: "\uF241",
            StepInsert: "\uF242",
            StepShared: "\uF243",
            StepSharedAdd: "\uF244",
            StepSharedInsert: "\uF245",
            StickyNotesOutlineAppIcon: "\uE36A",
            StickyNotesSolidAppIcon: "\uE36B",
            StockDown: "\uEB0F",
            StockUp: "\uEB11",
            Stop: "\uE71A",
            StopSolid: "\uEE95",
            Stopwatch: "\uE916",
            StorageAcount: "\uE435",
            StorageOptical: "\uE958",
            StoreLogo16: "\uEA96",
            StoreLogoMed20: "\uEA04",
            Storyboard: "\uF308",
            StreamDiscover: "\uF7D9",
            Streaming: "\uE93E",
            StreamingOff: "\uF2BB",
            StreamLogo: "\uF329",
            Street: "\uE913",
            StreetsideSplitMinimize: "\uE802",
            Strikethrough: "\uEDE0",
            StrikethroughKorean: "\uE5D4",
            Subscribe: "\uEDA1",
            Subscript: "\uEDDF",
            SubstitutionsIn: "\uEB31",
            SubtractShape: "\uF8FC",
            Suitcase: "\uEDD3",
            SunAdd: "\uEF69",
            Sunny: "\uE9BD",
            SunQuestionMark: "\uEF6A",
            Superscript: "\uEDDE",
            SurveyQuestionResponse: "\uE4F2",
            SurveyQuestions: "\uF01B",
            SVNLogo: "\uF662",
            SwayLogo16: "\uF484",
            SwayLogo32: "\uF482",
            SwayLogoFill16: "\uF485",
            SwayLogoFill32: "\uF483",
            SwayLogoInverse: "\uED29",
            SwiftLogo: "\uF7FC",
            Switch: "\uE8AB",
            SwitcherStartEnd: "\uE810",
            SwitchUser: "\uE748",
            Sync: "\uE895",
            SyncError: "\uEA6A",
            SyncFolder: "\uE8F7",
            SyncOccurence: "\uF4A3",
            SyncOccurenceCancel: "\uF7E7",
            SyncStatus: "\uF751",
            SyncStatusSolid: "\uF752",
            SyncToPC: "\uEE6E",
            System: "\uE770",
            Tab: "\uE7E9",
            TabCenter: "\uF100",
            Table: "\uED86",
            TableBrandedColumn: "\uE3F1",
            TableBrandedRow: "\uE3EE",
            TableColumn: "\uE4BD",
            TableComputed: "\uF8F5",
            TableFirstColumn: "\uE3EF",
            TableGroup: "\uF6D9",
            TableHeaderRow: "\uE3EC",
            TableLastColumn: "\uE3F0",
            TableLink: "\uF77A",
            TablePermission: "\uE619",
            Tablet: "\uE70A",
            TabletMode: "\uEBFC",
            TableTotalRow: "\uE3ED",
            TabletSelected: "\uEC74",
            TabOneColumn: "\uF849",
            TabThreeColumn: "\uF84B",
            TabTwoColumn: "\uF84A",
            Tag: "\uE8EC",
            TagGroup: "\uE3F6",
            TagSolid: "\uF70E",
            TagUnknown: "\uF6DF",
            TagUnknown12: "\uF6E1",
            TagUnknown12Mirror: "\uF6E2",
            TagUnknownMirror: "\uF6E0",
            TaskAdd: "\uE4FD",
            Taskboard: "\uF1C2",
            TaskGroup: "\uF2AE",
            TaskGroupMirrored: "\uF2AF",
            TaskList: "\uE3B6",
            TaskLogo: "\uF493",
            TaskManager: "\uEDB7",
            TaskManagerMirrored: "\uEDB8",
            TaskSolid: "\uF333",
            Taxi: "\uF4A1",
            TeamFavorite: "\uF2AD",
            TeamsLogo: "\uF27B",
            TeamsLogo16: "\uF40A",
            TeamsLogoInverse: "\uF27A",
            Teamwork: "\uEA12",
            Teeth: "\uF4A0",
            Telemarketer: "\uE7B9",
            TemporaryAccessPass: "\uE4AD",
            TemporaryUser: "\uEE58",
            Tennis: "\uEB33",
            TestAdd: "\uE4DC",
            TestAutoSolid: "\uF3A8",
            TestBeaker: "\uF3A5",
            TestBeakerSolid: "\uF3A6",
            TestCase: "\uF3AF",
            TestExploreSolid: "\uF3A7",
            TestImpactSolid: "\uF3AA",
            TestParameter: "\uF3AD",
            TestPlan: "\uF3AB",
            TestRemove: "\uE4E1",
            TestStep: "\uF3AC",
            TestSuite: "\uF3AE",
            TestUserSolid: "\uF3A9",
            TextAlignBottom: "\uE3E2",
            TextAlignMiddle: "\uE3E1",
            TextAlignTop: "\uE3E0",
            TextBox: "\uEDC2",
            TextCallout: "\uF2A2",
            TextDocument: "\uF029",
            TextDocumentEdit: "\uE43B",
            TextDocumentSettings: "\uE4AA",
            TextDocumentShared: "\uF02B",
            TextField: "\uEDC3",
            TextOverflow: "\uF51F",
            TextParagraphOption: "\uE3E3",
            TextRecognition: "\uE394",
            TextRotate270Degrees: "\uE3E7",
            TextRotate90Degrees: "\uE3E6",
            TextRotateHorizontal: "\uE3E5",
            TextRotation: "\uE3E4",
            TFVCLogo: "\uF44D",
            ThisPC: "\uEC4E",
            ThreeQuarterCircle: "\uF503",
            ThumbnailView: "\uE7B6",
            ThumbnailViewMirrored: "\uEA67",
            Thunderstorms: "\uE9C6",
            Ticket: "\uEB54",
            Tiles: "\uECA5",
            Tiles2: "\uEF7C",
            TimeEntry: "\uEF95",
            Timeline: "\uED9C",
            TimelineDelivery: "\uF2AB",
            TimelineMatrixView: "\uF361",
            TimelineProgress: "\uF2AA",
            TimePicker: "\uE367",
            Timer: "\uE91E",
            TimeSheet: "\uEA05",
            ToDoLogoBottom: "\uF4B3",
            ToDoLogoInverse: "\uF4BC",
            ToDoLogoOutline: "\uF75B",
            ToDoLogoTop: "\uF4B4",
            ToggleBorder: "\uEC12",
            ToggleFilled: "\uEC11",
            ToggleLeft: "\uF19E",
            ToggleRight: "\uF19F",
            ToggleThumb: "\uEC14",
            Toll: "\uF160",
            Toolbox: "\uECED",
            Total: "\uE9DF",
            Touch: "\uE815",
            TouchPointer: "\uE7C9",
            Trackers: "\uEADF",
            TrackersMirrored: "\uEE92",
            Train: "\uE7C0",
            TrainSolid: "\uEB4D",
            TransferCall: "\uED95",
            Transition: "\uF3BC",
            TransitionEffect: "\uF5B4",
            TransitionPop: "\uF5B2",
            TransitionPush: "\uF5B3",
            Translate: "\uE7B2",
            Trending12: "\uF62D",
            TriangleDown12: "\uEED1",
            TriangleLeft12: "\uEED2",
            TriangleRight12: "\uEED3",
            TriangleShape: "\uF1A7",
            TriangleShapeSolid: "\uF63E",
            TriangleSolid: "\uEA08",
            TriangleSolidDown12: "\uEECD",
            TriangleSolidLeft12: "\uEECE",
            TriangleSolidRight12: "\uEECF",
            TriangleSolidUp12: "\uEECC",
            TriangleUp12: "\uEED0",
            TriggerApproval: "\uF3B2",
            TriggerAuto: "\uF24A",
            TriggerPhrase: "\uE5FF",
            TriggerUser: "\uF24B",
            Trim: "\uE78A",
            TrimEnd: "\uF8BC",
            TrimStart: "\uF8BB",
            TripleColumn: "\uF1D5",
            TripleColumnEdit: "\uF323",
            TripleColumnWide: "\uF66E",
            Trophy: "\uED3F",
            Trophy2: "\uF1AE",
            Trophy2Solid: "\uF337",
            TurnRight: "\uE7DB",
            TVMonitor: "\uE7F4",
            TVMonitorSelected: "\uEC77",
            TwitterLogo: "\uECB5",
            TypeScriptLanguage: "\uF2F7",
            Umbrella: "\uEC04",
            UnavailableOffline: "\uE545",
            Underline: "\uE8DC",
            UnderlineA: "\uE5CC",
            UnderlineKorean: "\uE5BB",
            UnderlineP: "\uE5CD",
            UnderlineRussian: "\uE5B8",
            UnderlineS: "\uE5B4",
            UnderlineSerbian: "\uE5CB",
            Undo: "\uE7A7",
            Uneditable: "\uED1D",
            Uneditable2: "\uF876",
            Uneditable2Mirrored: "\uF877",
            UneditableMirrored: "\uF4B9",
            UneditableSolid12: "\uF4B7",
            UneditableSolidMirrored12: "\uF4B8",
            Unfavorite: "\uE8D9",
            UngroupObject: "\uF4F2",
            UniteShape: "\uF8FB",
            Unknown: "\uE9CE",
            UnknownCall: "\uED97",
            UnknownMirrored: "\uF22E",
            UnknownMirroredSolid: "\uF2E2",
            UnknownSolid: "\uF2E1",
            Unlock: "\uE785",
            UnlockSolid: "\uF304",
            Unpin: "\uE77A",
            UnpublishContent: "\uE31F",
            UnSetColor: "\uF3F9",
            UnstackSelected: "\uE7FE",
            Unsubscribe: "\uEDA0",
            UnsyncFolder: "\uE8F6",
            UnsyncOccurence: "\uF4A4",
            Untag: "\uF60B",
            Up: "\uE74A",
            UpdateRestore: "\uE777",
            UpgradeAnalysis: "\uEA0B",
            Upload: "\uE898",
            UpperCase: "\uE5ED",
            URLBlock: "\uE3FE",
            USB: "\uE88E",
            UserEvent: "\uF69C",
            UserFollowed: "\uF25C",
            UserGauge: "\uF6ED",
            UserOptional: "\uF767",
            UserPause: "\uF2BA",
            UserRemove: "\uF69B",
            UserSync: "\uF2B9",
            UserWarning: "\uE368",
            UserWindow: "\uE4ED",
            Vacation: "\uF49F",
            Vaccination: "\uEAE0",
            VaccinationRecent: "\uE550",
            Variable: "\uF305",
            Variable2: "\uF86D",
            Variable3: "\uE4D1",
            VariableGroup: "\uF31B",
            VB: "\uF2F2",
            VennDiagram: "\uF273",
            VerifiedBrand: "\uF7BD",
            VerifiedBrandSolid: "\uF6AD",
            VersionControlPush: "\uF664",
            VerticalDistributeCenter: "\uF4FA",
            Video: "\uE714",
            Video360Generic: "\uF609",
            VideoLightOff: "\uEA74",
            VideoOff: "\uF4B0",
            VideoOff2: "\uE43C",
            VideoSearch: "\uF4EA",
            VideoSolid: "\uEA0C",
            View: "\uE890",
            ViewAll: "\uE8A9",
            ViewAll2: "\uEF56",
            ViewDashboard: "\uF246",
            ViewInAR: "\uE41F",
            ViewList: "\uF247",
            ViewListGroup: "\uF248",
            ViewListTree: "\uF249",
            ViewOriginal: "\uE7B4",
            VirtualNetwork: "\uF815",
            VisioDiagram: "\uF2A0",
            VisioDiagramSync: "\uF762",
            VisioDocument: "\uF2A9",
            VisioLogo: "\uF2A7",
            VisioLogo16: "\uF3A3",
            VisioLogoInverse: "\uED7D",
            VisioLogoInverse16: "\uF3A2",
            VisualBasicLanguage: "\uF2F1",
            VisuallyImpaired: "\uF866",
            VisualsFolder: "\uF520",
            VisualsStore: "\uF521",
            VisualStudioForWindows: "\uF5D0",
            VisualStudioForWindowsAlt: "\uEC22",
            VoicemailForward: "\uED87",
            VoicemailIRM: "\uF421",
            VoicemailReply: "\uED88",
            Volume0: "\uE992",
            Volume1: "\uE993",
            Volume2: "\uE994",
            Volume3: "\uE995",
            VolumeDisabled: "\uEA85",
            VSTSAltLogo1: "\uF382",
            VSTSAltLogo2: "\uF383",
            VSTSLogo: "\uF381",
            Waffle: "\uED89",
            WaffleOffice365: "\uF4E0",
            WaitlistConfirm: "\uF550",
            WaitlistConfirmMirrored: "\uF551",
            Warning: "\uE7BA",
            Warning12: "\uF62F",
            WarningSolid: "\uF736",
            WavingHand: "\uF807",
            WebAppBuilderFragment: "\uE314",
            WebAppBuilderFragmentCreate: "\uE31B",
            WebAppBuilderFragmentLock: "\uE4DD",
            WebAppBuilderFragmentTest: "\uE4DE",
            WebAppBuilderModule: "\uE313",
            WebAppBuilderModuleLock: "\uE4DF",
            WebAppBuilderModuleTest: "\uE4E0",
            WebAppBuilderSlot: "\uE315",
            Webcam2: "\uE960",
            Webcam2Off: "\uE36D",
            WebComponents: "\uEC8B",
            WebEnvironment: "\uE3DB",
            WebPublish: "\uF52F",
            WebSearch: "\uF6FA",
            Website: "\uEB41",
            WebTemplate: "\uF6B2",
            Weights: "\uEADB",
            Wheelchair: "\uF31F",
            WhiteBoardApp16: "\uF673",
            WhiteBoardApp32: "\uF674",
            WifiEthernet: "\uEE77",
            WifiWarning4: "\uEB63",
            WindDirection: "\uEBE6",
            WindowEdit: "\uF50E",
            WindowsLogo: "\uE782",
            Wines: "\uEABF",
            WipePhone: "\uED8D",
            WordDocument: "\uEF71",
            WordLogo: "\uF1E3",
            WordLogo16: "\uF391",
            WordLogoInverse: "\uEC29",
            WordLogoInverse16: "\uF390",
            Work: "\uE821",
            WorkFlow: "\uEA01",
            WorkforceManagement: "\uEE0F",
            WorkItem: "\uF314",
            WorkItemAlert: "\uF78F",
            WorkItemBar: "\uF35C",
            WorkItemBarSolid: "\uF35D",
            WorkItemBug: "\uF315",
            World: "\uE909",
            WorldClock: "\uE918",
            XamarinLogo: "\uF7FD",
            XboxController: "\uEB65",
            XboxLogo: "\uEB70",
            XboxOneConsole: "\uE990",
            XPowerY: "\uF7CA",
            XRay: "\uE551",
            YammerLogo: "\uED19",
            ZeroDayCalendar: "\uE547",
            ZipFolder: "\uF012",
            Zoom: "\uE71E",
            ZoomIn: "\uE8A3",
            ZoomOut: "\uE71F",
            ZoomToFit: "\uF649",
            "mark/data-axis": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { d: "M1472 0l576 576L576 2048 0 1472 1472 0zM181 1472l395 395L1867 576l-395-395-88 88 115 115-91 91-115-115-165 165 197 198-90 90-198-197-165 165 115 116-90 90-116-115-165 165 197 198-90 90-198-197-165 165 115 115-91 91-115-115-88 88z" }))),
            "guide/x": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { d: "M512 1151v-127h384v127H512zm1024-127h384v127h-384v-127zM0 1151v-127h384v127H0zm1024 0v-127h384v127h-384z" }))),
            "guide/y": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("g", { transform: "translate(2048, 50) rotate(90)" },
                    React.createElement("path", { d: "M512 1151v-127h384v127H512zm1024-127h384v127h-384v-127zM0 1151v-127h384v127H0zm1024 0v-127h384v127h-384z" })))),
            "sublayout/packing": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 32 32", width: "16", height: "16", style: {
                    stroke: "#0078d4",
                } },
                React.createElement("circle", { cx: "9.87143", cy: "22.27563", r: "5.33333", style: {
                        fillOpacity: 0.0,
                        strokeWidth: "2px",
                    } }),
                React.createElement("circle", { cx: "23.11442", cy: "22.27563", r: "5.33333", style: {
                        fillOpacity: 0.0,
                        strokeWidth: "2px",
                    } }),
                React.createElement("circle", { cx: "15.99292", cy: "10.67289", r: "5.33333", style: {
                        fillOpacity: 0.0,
                        strokeWidth: "2px",
                    } }))),
            "sublayout/jitter": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 16 16", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { d: "M5.5,4.5c-1.103,0-2-0.897-2-2s0.897-2,2-2s2,0.897,2,2S6.603,4.5,5.5,4.5z M5.5,1.5c-0.551,0-1,0.449-1,1s0.449,1,1,1\n          s1-0.449,1-1S6.051,1.5,5.5,1.5z M2.5,9.5c-1.103,0-2-0.897-2-2c0-1.103,0.897-2,2-2s2,0.897,2,2C4.5,8.603,3.603,9.5,2.5,9.5z\n           M2.5,6.5c-0.551,0-1,0.449-1,1c0,0.552,0.449,1,1,1s1-0.448,1-1C3.5,6.949,3.051,6.5,2.5,6.5z M13.5,15.5c-1.103,0-2-0.897-2-2\n          s0.897-2,2-2s2,0.897,2,2S14.603,15.5,13.5,15.5z M13.5,12.5c-0.552,0-1,0.448-1,1s0.448,1,1,1s1-0.448,1-1S14.052,12.5,13.5,12.5z\n           M6.5,15.5c-1.103,0-2-0.897-2-2s0.897-2,2-2s2,0.897,2,2S7.603,15.5,6.5,15.5z M6.5,12.5c-0.551,0-1,0.448-1,1s0.449,1,1,1\n          s1-0.448,1-1S7.051,12.5,6.5,12.5z M13.5,9.5c-1.103,0-2-0.897-2-2s0.897-2,2-2s2,0.897,2,2S14.603,9.5,13.5,9.5z M13.5,6.5\n          c-0.552,0-1,0.449-1,1s0.448,1,1,1s1-0.449,1-1S14.052,6.5,13.5,6.5z M8.5,10.5c-1.103,0-2-0.897-2-2c0-1.103,0.897-2,2-2\n          c1.103,0,2,0.897,2,2C10.5,9.603,9.603,10.5,8.5,10.5z M8.5,7.5c-0.551,0-1,0.449-1,1c0,0.552,0.449,1,1,1c0.552,0,1-0.448,1-1\n          C9.5,7.949,9.052,7.5,8.5,7.5z M12.5,4.5c-1.103,0-2-0.897-2-2s0.897-2,2-2s2,0.897,2,2S13.603,4.5,12.5,4.5z M12.5,1.5\n          c-0.552,0-1,0.449-1,1s0.448,1,1,1s1-0.449,1-1S13.052,1.5,12.5,1.5z" }))),
            "scaffold/cartesian-x": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { transform: "translate(2048, 000) rotate(90)", d: "M 1920 0 v 2048 h -128 V 0 h 128 z M 512 384 h 1152 v 512 H 0 V 384 z m 128 384 h 896 V 512 H 128v 256 z M 0 1152 h 1664 v 512 H 0 v -512 z m 128 384 h 1408 v -256 H 128 v 256 z" }))),
            "scaffold/cartesian-y": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { transform: "translate(-125, 0) rotate(180, 1024, 1024)", d: "M 1920 0 v 2048 h -128 V 0 h 128 z M 512 384 h 1152 v 512 H 0 V 384 z m 128 384 h 896 V 512 H 128v 256 z M 0 1152 h 1664 v 512 H 0 v -512 z m 128 384 h 1408 v -256 H 128 v 256 z" }))),
            "scaffold/circle": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("title", null, "icons"),
                React.createElement("g", { transform: "translate(0, 0) scale(70)" },
                    React.createElement("circle", { cx: "16.01657", cy: "16.00686", r: "4.56188", style: { fill: "none", strokeMiterlimit: 10 } }),
                    React.createElement("path", { d: "M3.938,16.98954,9.9971,16.5012a5.99766,5.99766,0,0,1,2.86265-5.64127L9.6943,5.67251A12.03247,12.03247,0,0,0,3.938,16.98954Z" }),
                    React.createElement("path", { d: "M13.682,10.43443a6.041,6.041,0,0,1,6.26431.98889L23.90143,6.81A12.122,12.122,0,0,0,11.344,4.82017Z" }),
                    React.createElement("path", { d: "M20.60012,12.07717a6.041,6.041,0,0,1,.98889,6.2643l5.61426,2.33794A12.122,12.122,0,0,0,25.21345,8.122Z" }),
                    React.createElement("path", { d: "M14.61108,21.878a6.002,6.002,0,0,1-4.4656-4.4656l-5.9111,1.40735a12.04371,12.04371,0,0,0,8.96935,8.96935Z" }),
                    React.createElement("path", { d: "M21.16351,19.16368a5.99778,5.99778,0,0,1-5.64132,2.8627l-.48829,6.05909a12.03243,12.03243,0,0,0,11.317-5.75634Z" })))),
            "scaffold/curve": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { d: "M1984 1792q26 0 45 18t19 46q0 24-17 44-30 35-69 62t-83 47-91 29-92 10q-99 0-183-38t-152-110q-49-51-109-79t-132-29q-70 0-131 28t-110 80l-9 9q-9 9-23 22t-30 30-30 30-25 25-13 13q-19 19-45 19t-45-19-19-45q0-26 19-45 54-54 102-104t100-88 114-60 145-23q99 0 183 38t152 110q49 51 109 79t132 29q76 0 132-28t109-80q11-10 21-15t26-5zM1235 290q14 8 23 23t9 32q0 8-2 15t-5 14L553 1789q-9 19-28 28l-173 87q-32 16-69 16h-9q-4 0-10-1l-47 94q-8 16-23 25t-34 10q-26 0-45-19t-19-45q0-12 7-30t16-37 20-37 15-28q-26-40-26-87v-165q0-16 7-29L711 419l-65-32-237 474q-8 16-23 25t-34 10q-26 0-45-19t-19-45q0-13 7-29l239-478q16-32 43-50t63-19q35 0 66 17t62 32l71-142q8-17 23-26t34-9q13 0 22 4 12-24 23-47t26-43 36-30 53-12q32 0 61 15l94 47q32 16 50 42t19 64q0 34-15 63t-30 59zm-202-101l87 43 29-58-87-43-29 58zm84 185l-192-96-669 1337v150q0 11 8 19t19 8q4 0 16-5t29-13 35-17 36-19 30-16 19-10l669-1338z" }))),
            "scaffold/spiral": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                } },
                React.createElement("path", { d: "M9.5,1.5C5.916,1.5,3,4.416,3,8c0,2.895,2.355,5.25,5.25,5.25c2.895,0,5.25-2.355,5.25-5.25c0-2.206-1.794-4-4-4\n          c-2.206,0-4,1.794-4,4c0,1.517,1.233,2.75,2.75,2.75S11,9.517,11,8c0-0.827-0.673-1.5-1.5-1.5S8,7.173,8,8\n          c0,0.276,0.224,0.5,0.5,0.5S9,8.276,9,8c0-0.276,0.225-0.5,0.5-0.5S10,7.724,10,8c0,0.965-0.785,1.75-1.75,1.75S6.5,8.965,6.5,8\n          c0-1.654,1.346-3,3-3s3,1.346,3,3c0,2.344-1.906,4.25-4.25,4.25C5.907,12.25,4,10.344,4,8c0-3.033,2.467-5.5,5.5-5.5\n          C12.532,2.5,15,4.967,15,8c0,3.794-3.091,7-6.75,7C4.456,15,1,11.663,1,8c0-2.615,1.282-5.069,3.43-6.567\n          c0.227-0.158,0.282-0.47,0.124-0.696C4.397,0.511,4.086,0.456,3.858,0.613C1.442,2.297,0,5.059,0,8c0,4.187,3.932,8,8.25,8\n          C12.451,16,16,12.337,16,8C16,4.416,13.084,1.5,9.5,1.5z" }))),
            "sublayout/polar-grid": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 16 16", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("g", null,
                    React.createElement("path", { d: "M10.766,1.558c0.242,0.038,0.483,0.082,0.723,0.13C11.249,1.64,11.008,1.596,10.766,1.558L10.766,1.558z M11.489,1.688\n              c0.317,0.064,0.632,0.137,0.945,0.218C12.121,1.825,11.806,1.752,11.489,1.688L11.489,1.688z" }),
                    React.createElement("path", { d: "M14.353,2.521c0.524,0.202,1.042,0.422,1.548,0.676C15.395,2.943,14.877,2.722,14.353,2.521L14.353,2.521z" }),
                    React.createElement("path", { d: "M5.234,1.558C4.992,1.596,4.751,1.64,4.511,1.688C4.751,1.64,4.992,1.596,5.234,1.558L5.234,1.558z M4.511,1.688\n              C4.194,1.752,3.879,1.825,3.566,1.906C3.879,1.825,4.194,1.752,4.511,1.688L4.511,1.688z" }),
                    React.createElement("path", { d: "M1.647,2.521C1.123,2.722,0.605,2.943,0.098,3.197C0.605,2.943,1.123,2.723,1.647,2.521L1.647,2.521z" }),
                    React.createElement("path", { d: "M3.398,1.95c-0.321,0.086-0.639,0.18-0.956,0.284C2.759,2.131,3.078,2.037,3.398,1.95L3.398,1.95z M2.443,2.235\n              C2.238,2.302,2.034,2.373,1.831,2.448C2.034,2.373,2.238,2.302,2.443,2.235L2.443,2.235z" }),
                    React.createElement("path", { d: "M12.602,1.95c0.321,0.086,0.639,0.181,0.956,0.284C13.241,2.131,12.922,2.036,12.602,1.95L12.602,1.95z M13.557,2.235\n              c0.205,0.067,0.409,0.138,0.611,0.214C13.966,2.373,13.762,2.302,13.557,2.235L13.557,2.235z" }),
                    React.createElement("path", { d: "M7.299,13.415c-0.04,0.005-0.08,0.011-0.12,0.017C7.218,13.425,7.259,13.42,7.299,13.415L7.299,13.415z M7.179,13.431\n              c-0.125,0.019-0.25,0.042-0.373,0.069C6.929,13.474,7.053,13.45,7.179,13.431L7.179,13.431z" }),
                    React.createElement("path", { d: "M9.937,13.713c0.197,0.073,0.391,0.154,0.581,0.249C10.329,13.868,10.134,13.786,9.937,13.713L9.937,13.713z" }),
                    React.createElement("path", { d: "M6.063,13.713c-0.197,0.072-0.391,0.154-0.581,0.249C5.672,13.868,5.866,13.786,6.063,13.713L6.063,13.713z" }),
                    React.createElement("path", { d: "M6.673,13.529c-0.079,0.019-0.158,0.041-0.236,0.064C6.516,13.57,6.594,13.548,6.673,13.529L6.673,13.529z M6.438,13.593\n              c-0.082,0.024-0.163,0.05-0.244,0.078C6.275,13.644,6.356,13.617,6.438,13.593L6.438,13.593z" }),
                    React.createElement("path", { d: "M9.327,13.529c0.079,0.019,0.158,0.041,0.236,0.064C9.484,13.57,9.406,13.548,9.327,13.529L9.327,13.529z M9.562,13.593\n              c0.082,0.024,0.163,0.051,0.244,0.078C9.725,13.643,9.644,13.617,9.562,13.593L9.562,13.593z" }),
                    React.createElement("path", { d: "M8.701,13.415c0.04,0.005,0.08,0.011,0.12,0.017C8.781,13.425,8.741,13.42,8.701,13.415L8.701,13.415z M8.821,13.431\n              c0.125,0.019,0.249,0.043,0.373,0.069C9.071,13.474,8.947,13.45,8.821,13.431L8.821,13.431z" }),
                    React.createElement("path", { d: "M10.748,1.556c0.006,0.001,0.012,0.002,0.018,0.003C10.76,1.557,10.754,1.556,10.748,1.556L10.748,1.556z" }),
                    React.createElement("path", { d: "M9.806,13.671c0.023,0.008,0.047,0.015,0.07,0.022C9.853,13.686,9.83,13.679,9.806,13.671L9.806,13.671z M9.877,13.693\n              c0.02,0.006,0.041,0.013,0.061,0.02C9.917,13.706,9.897,13.7,9.877,13.693L9.877,13.693z" }),
                    React.createElement("path", { d: "M14.169,2.448c0.026,0.01,0.053,0.02,0.079,0.031C14.221,2.469,14.195,2.458,14.169,2.448L14.169,2.448z M14.248,2.479\n              c0.035,0.014,0.07,0.028,0.106,0.042C14.318,2.507,14.283,2.493,14.248,2.479L14.248,2.479z" }),
                    React.createElement("path", { d: "M8.571,13.401c0.044,0.004,0.087,0.008,0.131,0.014C8.658,13.409,8.614,13.405,8.571,13.401L8.571,13.401z" }),
                    React.createElement("path", { d: "M9.195,13.501c0.023,0.005,0.046,0.01,0.069,0.014C9.241,13.51,9.218,13.506,9.195,13.501L9.195,13.501z M9.264,13.515\n              c0.021,0.004,0.042,0.009,0.063,0.014C9.306,13.524,9.285,13.519,9.264,13.515L9.264,13.515z" }),
                    React.createElement("path", { d: "M12.434,1.906c0.034,0.009,0.068,0.018,0.102,0.027C12.502,1.924,12.468,1.915,12.434,1.906L12.434,1.906z M12.536,1.933\n              c0.022,0.006,0.044,0.012,0.065,0.018C12.58,1.944,12.558,1.939,12.536,1.933L12.536,1.933z" }),
                    React.createElement("path", { d: "M9.921,2.453c0.229,0.026,0.459,0.057,0.69,0.093c0.504,0.079,1.033,0.189,1.572,0.328l0.159,0.042\n              c0.506,0.135,1.003,0.293,1.477,0.469l0.081,0.032l0.094,0.037c0.191,0.073,0.374,0.147,0.55,0.22l-1.319,2.639\n              c-1.099-0.449-2.26-0.751-3.469-0.901L9.921,2.453 M8.979,1.369L8.704,6.322c1.714,0.095,3.414,0.514,4.985,1.3l2.212-4.425\n              c-0.507-0.253-1.025-0.475-1.548-0.676c-0.062-0.024-0.123-0.05-0.185-0.073c-0.516-0.191-1.039-0.357-1.567-0.498\n              c-0.056-0.015-0.112-0.03-0.167-0.044c-0.551-0.142-1.108-0.26-1.668-0.348c-0.006-0.001-0.012-0.002-0.018-0.003\n              C10.162,1.464,9.571,1.402,8.979,1.369L8.979,1.369z" }),
                    React.createElement("path", { d: "M9.527,9.537c0.639,0.099,1.256,0.258,1.848,0.477l-1.34,2.679c-0.156-0.051-0.313-0.097-0.473-0.136l-0.153-0.033\n              c-0.016-0.003-0.032-0.007-0.047-0.01L9.527,9.537 M8.587,8.435l-0.274,4.938c0.087,0.005,0.172,0.019,0.258,0.028\n              c0.044,0.004,0.087,0.008,0.131,0.014c0.166,0.021,0.33,0.05,0.494,0.086c0.044,0.01,0.088,0.017,0.132,0.028\n              c0.162,0.04,0.321,0.088,0.48,0.142c0.044,0.015,0.088,0.026,0.131,0.042c0.197,0.073,0.391,0.154,0.581,0.249l2.222-4.445\n              C11.432,8.863,10.015,8.514,8.587,8.435L8.587,8.435z" }),
                    React.createElement("path", { d: "M6.805,13.501c-0.023,0.005-0.046,0.01-0.069,0.014C6.759,13.51,6.782,13.506,6.805,13.501L6.805,13.501z M6.736,13.515\n              c-0.021,0.004-0.042,0.009-0.063,0.014C6.694,13.524,6.715,13.519,6.736,13.515L6.736,13.515z" }),
                    React.createElement("path", { d: "M7.429,13.401c-0.044,0.004-0.087,0.008-0.131,0.014C7.342,13.409,7.386,13.405,7.429,13.401L7.429,13.401z" }),
                    React.createElement("path", { d: "M6.194,13.671c-0.023,0.008-0.047,0.015-0.07,0.022C6.147,13.686,6.17,13.679,6.194,13.671L6.194,13.671z M6.123,13.693\n              c-0.02,0.006-0.041,0.013-0.061,0.02C6.083,13.706,6.103,13.7,6.123,13.693L6.123,13.693z" }),
                    React.createElement("path", { d: "M5.252,1.556C5.246,1.556,5.24,1.557,5.234,1.558C5.24,1.557,5.246,1.556,5.252,1.556L5.252,1.556z" }),
                    React.createElement("path", { d: "M3.566,1.906C3.532,1.915,3.498,1.924,3.464,1.933C3.498,1.924,3.532,1.915,3.566,1.906L3.566,1.906z M3.464,1.933\n              C3.442,1.939,3.42,1.944,3.398,1.95C3.42,1.944,3.442,1.939,3.464,1.933L3.464,1.933z" }),
                    React.createElement("path", { d: "M1.831,2.448c-0.026,0.01-0.053,0.02-0.079,0.031C1.779,2.469,1.805,2.458,1.831,2.448L1.831,2.448z M1.752,2.479\n              c-0.035,0.014-0.07,0.028-0.106,0.042C1.682,2.507,1.717,2.493,1.752,2.479L1.752,2.479z" }),
                    React.createElement("path", { d: "M6.079,2.453l0.164,2.96c-1.209,0.151-2.37,0.452-3.469,0.901L1.456,3.675c0.176-0.074,0.359-0.147,0.55-0.221l0.093-0.037\n              l0.08-0.031c0.475-0.176,0.972-0.334,1.479-0.47l0.157-0.042c0.541-0.139,1.07-0.249,1.591-0.331\n              C5.629,2.509,5.854,2.478,6.079,2.453 M7.021,1.369C6.429,1.402,5.838,1.464,5.252,1.556C5.246,1.556,5.24,1.557,5.234,1.558\n              c-0.56,0.088-1.117,0.206-1.668,0.348C3.51,1.92,3.454,1.935,3.398,1.95C2.87,2.092,2.347,2.257,1.831,2.448\n              C1.769,2.471,1.708,2.497,1.647,2.521C1.123,2.722,0.605,2.943,0.098,3.197l2.212,4.425c1.571-0.786,3.271-1.205,4.985-1.3\n              L7.021,1.369L7.021,1.369z" }),
                    React.createElement("path", { d: "M6.473,9.537l0.165,2.977c-0.027,0.006-0.054,0.011-0.082,0.018l-0.12,0.026c-0.154,0.038-0.306,0.082-0.471,0.135\n              l-1.339-2.679C5.217,9.795,5.834,9.636,6.473,9.537 M7.413,8.435C5.985,8.514,4.568,8.863,3.259,9.518l2.222,4.445\n              c0.19-0.095,0.385-0.177,0.581-0.249c0.043-0.016,0.088-0.028,0.131-0.042c0.158-0.054,0.318-0.103,0.48-0.142\n              c0.044-0.011,0.088-0.018,0.132-0.028c0.163-0.036,0.328-0.065,0.494-0.086c0.044-0.005,0.087-0.01,0.131-0.014\n              c0.086-0.009,0.172-0.023,0.258-0.028L7.413,8.435L7.413,8.435z" })))),
            FlipVertical: (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("path", { d: "M1664 0L960 704 256 0h1408zM256 1920l704-704 704 704H256zm309-128h790l-395-395-395 395zm75-768H512V896h128v128zm-256 0H256V896h128v128zm512 0H768V896h128v128zm256 0h-128V896h128v128zm256 0h-128V896h128v128zm128-128h128v128h-128V896z" }))),
            FlipHorizontal: (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("path", { d: "M0 1664V256l704 704L0 1664zm1216-704l704-704v1408l-704-704zm576 395V565l-395 395 395 395zM896 640V512h128v128H896zm0-256V256h128v128H896zm0 512V768h128v128H896zm0 256v-128h128v128H896zm0 256v-128h128v128H896zm0 256v-128h128v128H896z" }))),
            ArrowRight12: (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("path", { d: "M1084 110l829 829-829 828-120-121 622-622H0V853h1586L964 231l120-121z" }))),
            ArrowUp12: (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("path", { d: "M1767 964l-121 120-622-622v1586H853V462l-622 622-121-120 829-829 828 829z" }))),
            ArrowDown12: (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("path", { d: "M1646 964l121 120-828 829-829-829 121-120 622 622V0h171v1586l622-622z" }))),
            ArrowLeft12: (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 2048 2048", width: "16", height: "16", style: {
                    fill: "#0078d4",
                    strokeWidth: 0.1,
                } },
                React.createElement("path", { d: "M2048 853v171H462l622 622-120 121-829-828 829-829 120 121-622 622h1586z" }))),
            "general/replace": (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 32 32", width: "16", height: "16" },
                React.createElement("title", null, "icons"),
                React.createElement("path", { d: "M9.11449,15.75411v4.99441a2.86179,2.86179,0,0,0,2.8534,2.85339h3.04864", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeMiterlimit: 10,
                        strokeWidth: "1.20px",
                    } }),
                React.createElement("line", { x1: "9.11449", y1: "15.75411", x2: "11.79822", y2: "18.43784", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeMiterlimit: 10,
                        strokeWidth: "1.20px",
                    } }),
                React.createElement("line", { x1: "9.11449", y1: "15.75411", x2: "6.43076", y2: "18.43784", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeMiterlimit: 10,
                        strokeWidth: "1.20px",
                    } }),
                React.createElement("rect", { x: "4.91958", y: "4.20318", width: "8.38982", height: "8.38982", transform: "translate(17.51258 -0.7164) rotate(90)", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.5px",
                    } }),
                React.createElement("path", { d: "M22.88551,16.24589V11.25148a2.86179,2.86179,0,0,0-2.8534-2.85339H16.98347", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeMiterlimit: 10,
                        strokeWidth: "1.20px",
                    } }),
                React.createElement("line", { x1: "22.88551", y1: "16.24589", x2: "20.20178", y2: "13.56216", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeMiterlimit: 10,
                        strokeWidth: "1.20px",
                    } }),
                React.createElement("line", { x1: "22.88551", y1: "16.24589", x2: "25.56924", y2: "13.56216", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeMiterlimit: 10,
                        strokeWidth: "1.20px",
                    } }),
                React.createElement("polyline", { points: "19.878 19.407 18.691 19.407 18.691 20.595", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                    } }),
                React.createElement("line", { x1: "18.69061", y1: "22.85014", x2: "18.69061", y2: "25.48134", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                        strokeDasharray: "1.5035455226898193,2.2553179264068604",
                    } }),
                React.createElement("polyline", { points: "18.691 26.609 18.691 27.797 19.878 27.797", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                    } }),
                React.createElement("line", { x1: "22.13373", y1: "27.79683", x2: "24.76495", y2: "27.79683", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                        strokeDasharray: "1.5035455226898193,2.2553179264068604",
                    } }),
                React.createElement("polyline", { points: "25.893 27.797 27.08 27.797 27.08 26.609", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                    } }),
                React.createElement("line", { x1: "27.08044", y1: "24.35368", x2: "27.08044", y2: "21.72249", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                        strokeDasharray: "1.5035455226898193,2.2553179264068604",
                    } }),
                React.createElement("polyline", { points: "27.08 20.595 27.08 19.407 25.893 19.407", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                    } }),
                React.createElement("line", { x1: "23.63727", y1: "19.407", x2: "21.0061", y2: "19.407", style: {
                        fill: "none",
                        stroke: "#000",
                        strokeLinecap: "round",
                        strokeLinejoin: "round",
                        strokeWidth: "1.2000000000000002px",
                        strokeDasharray: "1.5035455226898193,2.2553179264068604",
                    } }))),
        },
    };
    styling_1.registerIcons(subset, options);
}
exports.initializeIcons = initializeIcons;
//# sourceMappingURL=fabric-icons.js.map