// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../react
//   ../../d3-format
//   ../../@fluentui/react
//   ../../lscg-solver

declare module 'CharticulatorContainer' {
    /**
      * Chart container module responsible to draw chart on the DOM.
      *
      * {@link ChartComponent} responsible to draw the chart on the DOM. The method {@link renderGraphicalElementSVG} uses it to render the main element of the chart
      *
      * {@link ChartContainer} uses to draw the chart outside of charticulator editor. This class uses {@link ChartComponent} inside for rendering the chart.
      * It's main part of Power BI extension and export as HTML (See {@link "app/actions/actions".Export} for details about export to HTML)
      *
      * {@link "container/chart_template".ChartTemplate} describes the chart itself. Responsible to instantiate the template on loading (in editor, in container of Power BI Visual or in HTML)
      * The interface {@link "core/specification/template".ChartTemplate} describes main parts of template structure.
      *
      * @packageDocumentation
      * @preferred
      */
    export { ChartComponent } from "CharticulatorContainer/container/chart_component";
    export { ChartTemplate, TemplateInstance } from "CharticulatorContainer/container/chart_template";
    export { ChartContainer } from "CharticulatorContainer/container/container";
    export * from "CharticulatorContainer/core";
}

declare module 'CharticulatorContainer/container/chart_component' {
    import * as React from "react";
    import { Specification, Dataset, Prototypes, Graphics } from "CharticulatorContainer/core";
    import { RenderGraphicalElementSVGOptions, DataSelection, GraphicalElementEventHandler } from "CharticulatorContainer/app/renderer";
    import { RenderEvents } from "CharticulatorContainer/core/graphics";
    export { DataSelection };
    export type GlyphEventHandler = (data: {
            table: string;
            rowIndices: number[];
    }, modifiers: {
            ctrlKey: boolean;
            shiftKey: boolean;
            metaKey: boolean;
    }) => void;
    export interface ChartComponentProps {
            chart: Specification.Chart;
            dataset: Dataset.Dataset;
            width: number;
            height: number;
            rootElement: "svg" | "g";
            className?: string;
            defaultAttributes?: Prototypes.DefaultAttributes;
            /** Additional options for the SVG renderer */
            rendererOptions?: RenderGraphicalElementSVGOptions;
            /** Render the chart synchronously */
            sync?: boolean;
            selection?: DataSelection;
            onGlyphClick?: GlyphEventHandler;
            onGlyphMouseEnter?: GlyphEventHandler;
            onGlyphMouseLeave?: GlyphEventHandler;
            onGlyphContextMenuClick?: GlyphEventHandler;
            renderEvents?: RenderEvents;
    }
    export interface ChartComponentState {
            working: boolean;
            graphics: Graphics.Element;
    }
    /** A React component that manages a sub-chart */
    export class ChartComponent extends React.Component<ChartComponentProps, ChartComponentState> {
            protected manager: Prototypes.ChartStateManager;
            protected renderer: Graphics.ChartRenderer;
            constructor(props: ChartComponentProps);
            applySelection(selection: DataSelection): void;
            /**
                * TODO rework the method https://reactjs.org/blog/2018/03/27/update-on-async-rendering.html
                * @param newProps React component properties
                */
            componentWillReceiveProps(newProps: ChartComponentProps): void;
            isEqual<T>(a: T, b: T): boolean;
            updateWithNewProps(newProps: ChartComponentProps): boolean;
            protected recreateManager(props: ChartComponentProps): void;
            protected timer: any;
            protected scheduleUpdate(): void;
            getProperty(objectID: string, property: Specification.Template.PropertyField): Specification.AttributeValue;
            setProperty(objectID: string, property: Specification.Template.PropertyField, value: Specification.AttributeValue): void;
            getAttributeMapping(objectID: string, attribute: string): Specification.Mapping;
            setAttributeMapping(objectID: string, attribute: string, mapping: Specification.Mapping): void;
            convertGlyphEventHandler(handler: GlyphEventHandler): GraphicalElementEventHandler;
            render(): JSX.Element;
    }
}

declare module 'CharticulatorContainer/container/chart_template' {
    import { Dataset, Specification } from "CharticulatorContainer/core";
    import { DefaultAttributes } from "CharticulatorContainer/core/prototypes";
    export interface TemplateInstance {
            chart: Specification.Chart;
            defaultAttributes: DefaultAttributes;
    }
    /** Represents a chart template */
    export class ChartTemplate {
            /** Create a chart template */
            constructor(template: Specification.Template.ChartTemplate);
            getDatasetSchema(): Specification.Template.Table[];
            /** Reset slot assignments */
            reset(): void;
            /** Assign a table */
            assignTable(tableName: string, table: string): void;
            /** Assign an expression to a data mapping slot */
            assignColumn(tableName: string, columnName: string, column: string): void;
            /** Get variable map for a given table */
            getVariableMap(table: string): {};
            transformExpression(expr: string, table?: string): string;
            transformTextExpression(expr: string, table?: string): string;
            transformGroupBy(groupBy: Specification.Types.GroupBy, table: string): Specification.Types.GroupBy;
            /**
                * Creates instance of chart object from template. Chart objecty can be loaded into container to display it in canvas
                * On editing this method ensure that you made correspond changes in template builder ({@link ChartTemplateBuilder}).
                * Any exposed into template objects should be initialized here
                */
            instantiate(dataset: Dataset.Dataset, inference?: boolean): TemplateInstance;
            static SetChartProperty(chart: Specification.Chart, objectID: string, property: Specification.Template.PropertyField, value: Specification.AttributeValue): void;
            static GetChartProperty(chart: Specification.Chart, objectID: string, property: Specification.Template.PropertyField): Specification.AttributeValue;
            static SetChartAttributeMapping(chart: Specification.Chart, objectID: string, attribute: string, value: Specification.Mapping): void;
            static GetChartAttributeMapping(chart: Specification.Chart, objectID: string, attribute: string): any;
    }
}

declare module 'CharticulatorContainer/container/container' {
    import { FormatLocaleDefinition } from "d3-format";
    import * as React from "react";
    import { Dataset, EventEmitter, Specification, EventSubscription, Prototypes } from "CharticulatorContainer/core";
    import { RenderEvents } from "CharticulatorContainer/core/graphics";
    import { ChartComponent, DataSelection, GlyphEventHandler } from "CharticulatorContainer/container/chart_component";
    import { TemplateInstance } from "CharticulatorContainer/container/chart_template";
    export interface ChartContainerComponentProps {
            chart: Specification.Chart;
            dataset: Dataset.Dataset;
            defaultAttributes?: Prototypes.DefaultAttributes;
            defaultWidth: number;
            defaultHeight: number;
            onSelectionChange?: (data: {
                    table: string;
                    rowIndices: number[];
            }) => void;
            onMouseEnterGlyph?: (data: {
                    table: string;
                    rowIndices: number[];
            }) => void;
            onMouseLeaveGlyph?: (data: {
                    table: string;
                    rowIndices: number[];
            }) => void;
            onMouseContextMenuClickGlyph?: (data: {
                    table: string;
                    rowIndices: number[];
            }, modifiers: any) => void;
            renderEvents?: RenderEvents;
    }
    export interface LocalizationConfig {
            currency: string;
            thousandsDelimiter: string;
            decemalDelimiter: string;
    }
    export interface ChartContainerComponentState {
            width: number;
            height: number;
            selection: {
                    table: string;
                    indices: Set<number>;
            } & DataSelection;
            localization: LocalizationConfig;
    }
    export class ChartContainerComponent extends React.Component<ChartContainerComponentProps, ChartContainerComponentState> {
            state: ChartContainerComponentState;
            constructor(props: ChartContainerComponentProps);
            component: ChartComponent;
            setSelection(table: string, rowIndices: number[], union?: boolean, emit?: boolean): void;
            clearSelection(emit?: boolean): void;
            resize(width: number, height: number): void;
            getProperty(objectID: string, property: Specification.Template.PropertyField): any;
            setProperty(objectID: string, property: Specification.Template.PropertyField, value: any): void;
            getAttributeMapping(objectID: string, attribute: string): Specification.Mapping;
            setAttributeMapping(objectID: string, attribute: string, mapping: Specification.Mapping): void;
            protected handleGlyphClick: GlyphEventHandler;
            protected handleGlyphContextMenuClick: GlyphEventHandler;
            protected handleGlyphMouseEnter: GlyphEventHandler;
            protected handleGlyphMouseLeave: GlyphEventHandler;
            render(): JSX.Element;
    }
    export enum ChartContainerEvent {
            Selection = "selection",
            MouseEnter = "mouseenter",
            MouseLeave = "mouseleave",
            ContextMenu = "contextmenu"
    }
    export class ChartContainer extends EventEmitter {
            readonly instance: TemplateInstance;
            readonly dataset: Dataset.Dataset;
            renderEvents?: RenderEvents;
            localizaiton?: LocalizationConfig;
            utcTimeZone?: boolean;
            constructor(instance: TemplateInstance, dataset: Dataset.Dataset, renderEvents?: RenderEvents, localizaiton?: LocalizationConfig, utcTimeZone?: boolean);
            /** Resize the chart */
            resize(width: number, height: number): void;
            /** Listen to selection change */
            addSelectionListener(listener: (table: string, rowIndices: number[]) => void): EventSubscription;
            addContextMenuListener(listener: (table: string, rowIndices: number[], modifiers: any) => void): EventSubscription;
            addMouseEnterListener(listener: (table: string, rowIndices: number[]) => void): EventSubscription;
            addMouseLeaveListener(listener: (table: string, rowIndices: number[], modifiers: any) => void): EventSubscription;
            /** Set data selection and update the chart */
            setSelection(table: string, rowIndices: number[]): void;
            /** Clear data selection and update the chart */
            clearSelection(): void;
            /** Get a property from the chart */
            getProperty(objectID: string, property: Specification.Template.PropertyField): any;
            /** Set a property to the chart */
            setProperty(objectID: string, property: Specification.Template.PropertyField, value: any): void;
            /**
                * Get a attribute mapping
                */
            getAttributeMapping(objectID: string, attribute: string): Specification.Mapping;
            /** Set a attribute mapping */
            setAttributeMapping(objectID: string, attribute: string, mapping: Specification.Mapping): void;
            setChart(chart: Specification.Chart): void;
            static setFormatOptions(options: FormatLocaleDefinition): void;
            static setUtcTimeZone(utcTimeZone: boolean): void;
            reactMount(width?: number, height?: number): JSX.Element;
            /** Mount the chart to a container element */
            mount(container: string | Element, width?: number, height?: number): void;
            /** Unmount the chart */
            unmount(): void;
    }
}

declare module 'CharticulatorContainer/core' {
    /**
      * # Core documentation
      *
      * ## Actions {@link "core/actions/index"}
      * The module contains all actions available in the charticulator.
      *
      * ## Common {@link "core/common/index"}
      *
      * Contains several modules such as
      *
      * * {@link "core/common/color"} to work with colors
      * * {@link "core/common/events"} event bus uses for notifying different parts of UI about updates.
      * * {@link "core/common/fetch"}
      * * {@link "core/common/math"} contains math operations for geometry
      * * {@link "core/common/scales"} scales for map data values to properties of graphic elements
      * * {@link "core/common/unique_id"} id generator for all objects used in charticulator
      * * {@link "core/common/utils"} contains different helper functions
      *
      * ## Dataset {@link "core/dataset/index"}
      *
      * The module is responsible for loading data from *.csv/*.tsv files and parse them
      *
      * ## Expression {@link "core/expression/index"}
      *
      * Describes all supported expressions in the charticulator and helper functions for process date on binding to elements
      *
      * ## Graphics {@link "core/graphics/index"}
      *
      * Contains logic responsible  for rendering elements and coordinate systems
      *
      * ## Prototypes {@link "core/prototypes/index"}
      *
      * Contains bricks of the chart: *Marks*({@link "core/prototypes/marks/index"}) (rect, image, symbol, text e.t.c.), Legends, Links, Plot Segments e.t.c
      *
      * * Declares the properties and attributes of a class of object (chart, chart element, glyph, mark) in the spec
      *
      * * Including default attribute values and property values
      *
      * * Generate graphical elements (if any) for ChartRenderer
      *
      * * Generate constraints (if any) for the constraint solver
      *
      * * Declare widgets (if any) for the attribute panel
      *
      * ### Difference between “attribute” and “property”
      *
      * Attribute (e.g., height on a rect mark):
      *
      * * Defined on the object state (an object can have multiple instances, each instance has its own state)
      * * Variable among the instances of the object
      * * Can involve in constraint solving
      * * Can be bound to data
      *
      * Property (e.g., anchor on a text mark):
      *
      * * Defined directly on the object specification
      * * Same across all instances of the object
      * * Does not involve in constraint solving
      * * Cannot be bound to data
      *
      * ## Solver {@link "core/solver/index"}
      *
      * Wrapping over lscg-solver package to convert chart co constrains.
      *
      * ## Specification {@link "core/specification/index"}
      *
      * It contains interfaces for the chart template. The template describes the internal structure of the chart.
      *
      * ## Store {@link "core/store/base"}
      *
      * @packageDocumentation
      * @preferred
      */
    export * from "CharticulatorContainer/core/common";
    export { CharticulatorCoreConfig, getConfig } from "CharticulatorContainer/core/config";
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import * as Prototypes from "CharticulatorContainer/core/prototypes";
    import * as Solver from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import * as Utils from "CharticulatorContainer/core/common/utils";
    import * as ColorUtils from "CharticulatorContainer/core/common/color";
    export * from "CharticulatorContainer/core/actions";
    export { Expression, Specification, Prototypes, Solver, Graphics, Dataset, Utils, ColorUtils, };
    import { CharticulatorCoreConfig } from "CharticulatorContainer/core/config";
    export function initialize(config?: CharticulatorCoreConfig): Promise<void>;
}

declare module 'CharticulatorContainer/app/renderer' {
    import * as React from "react";
    import { Color, Graphics } from "CharticulatorContainer/core";
    import { ColorFilter } from "CharticulatorContainer/core/graphics";
    export function applyColorFilter(color: Color, colorFilter: ColorFilter): {
        r: number;
        g: number;
        b: number;
    };
    /**
      * Coverts {@Color} to `rgb(r,g,b)` string. Or coverts `#RRGGBB` fromat to `rgb(r,g,b)`}
      * @param color {@Color} object or color string in HEX format (`#RRGGBB`)
      */
    export function renderColor(color: Color | string, colorFilter?: ColorFilter): string;
    export function renderStyle(style: Graphics.Style): React.CSSProperties;
    export function renderSVGPath(cmds: {
        cmd: string;
        args: number[];
    }[]): string;
    export function renderTransform(transform: Graphics.RigidTransform): string;
    export interface DataSelection {
        isSelected(table: string, rowIndices: number[]): boolean;
    }
    export type GraphicalElementEventHandler = (element: Graphics.Element["selectable"], event: {
        shiftKey: boolean;
        ctrlKey: boolean;
        metaKey: boolean;
    }) => any;
    export interface RenderGraphicalElementSVGOptions {
        noStyle?: boolean;
        styleOverride?: Graphics.Style;
        className?: string;
        key?: string;
        chartComponentSync?: boolean;
        externalResourceResolver?: (url: string) => string;
        /** Called when a glyph is clicked */
        onClick?: GraphicalElementEventHandler;
        /** Called when the mouse enters a glyph */
        onMouseEnter?: GraphicalElementEventHandler;
        /** Called when the mouse leaves a glyph */
        onMouseLeave?: GraphicalElementEventHandler;
        /** Called when a glyph context menu is clicked */
        onContextMenu?: GraphicalElementEventHandler;
        selection?: DataSelection;
    }
    export function renderSVGDefs(element: Graphics.Element): JSX.Element;
    /** The method renders all chart elements in SVG document */
    export function renderGraphicalElementSVG(element: Graphics.Element, options?: RenderGraphicalElementSVGOptions): JSX.Element;
    export class GraphicalElementDisplay extends React.PureComponent<{
        element: Graphics.Element;
    }, Record<string, never>> {
        render(): JSX.Element;
    }
}

declare module 'CharticulatorContainer/core/graphics' {
    /**
      * The module contains coordinate systems and classes for rendering elements(See {@link ChartRenderer} for details)
      *
      * @packageDocumentation
      * @preferred
      */
    export * from "CharticulatorContainer/core/graphics/elements";
    export * from "CharticulatorContainer/core/graphics/renderer";
    export { CoordinateSystem, CartesianCoordinates, PolarCoordinates, BezierCurveCoordinates, CoordinateSystemHelper, } from "CharticulatorContainer/core/graphics/coordinate_system";
    export { BezierCurveParameterization, MultiCurveParametrization, LineSegmentParametrization, } from "CharticulatorContainer/core/graphics/bezier_curve";
}

declare module 'CharticulatorContainer/core/prototypes' {
    /**
      * Module contains basic elements of charts:
      *
      * * Marks elements {@link "core/prototypes/marks/index"} are "bricks" of charticulator. Module contains descriptions of rectangle, image, symbol, text, e.t.c
      *
      * * Plot segments  {@link "core/prototypes/plot_segments/index"} container of glyphs to arrange them on the chart
      *
      * * Chart {@link "core/prototypes/charts/index"} highest level element, contains all other elements like plot segments, marks, legends e.t.c
      *
      * * Scales {@link "core/prototypes/plot_segments/index"} map data valus into pixels and sizes of elements(marks)
      *
      * * Links {@link "core/prototypes/links/index"}
      *
      * * Legends {@link "core/prototypes/legends/index"}
      *
      * * Guides {@link "core/prototypes/guides/index"} helper non visual elements to allign other elements
      *
      * * Glyphs {@link "core/prototypes/glyphs/index"} is container of other elements on plot segmets
      *
      * * Dataflow {@link "core/prototypes/dataflow/index"} uses for connecting elements to dataset
      *
      * @packageDocumentation
      * @preferred
      */
    import * as Charts from "CharticulatorContainer/core/prototypes/charts";
    import * as Constraints from "CharticulatorContainer/core/prototypes/constraints";
    import * as Dataflow from "CharticulatorContainer/core/prototypes/dataflow";
    import * as Glyphs from "CharticulatorContainer/core/prototypes/glyphs";
    import * as Guides from "CharticulatorContainer/core/prototypes/guides";
    import * as Legends from "CharticulatorContainer/core/prototypes/legends";
    import * as Links from "CharticulatorContainer/core/prototypes/links";
    import * as Marks from "CharticulatorContainer/core/prototypes/marks";
    import * as PlotSegments from "CharticulatorContainer/core/prototypes/plot_segments";
    import * as Scales from "CharticulatorContainer/core/prototypes/scales";
    export { ObjectClassCache } from "CharticulatorContainer/core/prototypes/cache";
    export * from "CharticulatorContainer/core/prototypes/common";
    export * from "CharticulatorContainer/core/prototypes/state";
    export { Marks, Scales, Constraints, Glyphs, Charts, PlotSegments, Links, Guides, Legends, Dataflow, };
}

declare module 'CharticulatorContainer/core/common' {
    export * from "CharticulatorContainer/core/common/math";
    export * from "CharticulatorContainer/core/common/color";
    export * from "CharticulatorContainer/core/common/unique_id";
    export * from "CharticulatorContainer/core/common/utils";
    export * from "CharticulatorContainer/core/common/scales";
    export * from "CharticulatorContainer/core/common/events";
    export * from "CharticulatorContainer/core/common/constants";
    export { loadDataFromURL } from "CharticulatorContainer/core/common/fetch";
}

declare module 'CharticulatorContainer/core/config' {
    /**
      * @ignore
      * @packageDocumentation
      * @preferred
      */
    export interface CharticulatorCoreConfig {
        MapService?: {
            provider: string;
            apiKey: string;
        };
    }
    export function setConfig(_?: CharticulatorCoreConfig): void;
    export function getConfig(): CharticulatorCoreConfig;
}

declare module 'CharticulatorContainer/core/dataset' {
    /**
      * Charticulator uses [d3-dsv](https://github.com/d3/d3-dsv) package to load and parse csv data.
      *
      * The module contains methods to parse and convert data on importing into Charticulator.
      *
      * {@link "core/dataset/data_types"} contains methods for converting strings into correspond data types.
      *
      * {@link "core/dataset/dsv_parser"} wrapper to call methods from {@link "core/dataset/data_types"} for whole dataset. The main method of module is {@link parseDataset}
      *
      * {@link "core/dataset/datetime"} contains methods to parse dates.
      *
      * {@link "core/dataset/context"} provides proxy classes for data and expressions. Expressions module ({@link "core/expression/index"}) classes use data through context.
      *
      * {@link "core/dataset/dataset"} interfaces for describe dataset stuctures of charticulator as Table, Column, Dataset e.t.c.
      *
      * @packageDocumentation
      * @preferred
      */
    export * from "CharticulatorContainer/core/dataset/dataset";
    export { DatasetLoader } from "CharticulatorContainer/core/dataset/loader";
    export { DatasetContext, TableContext, RowContext } from "CharticulatorContainer/core/dataset/context";
    export { convertColumnType, inferColumnType, inferAndConvertColumn, dataTypes } from "CharticulatorContainer/core/dataset/data_types";
}

declare module 'CharticulatorContainer/core/expression' {
    /**
      * Expressions
      *
      * The module of exressions responsible for data binding or data fetching
      * Grammar of expression described in [parser.pegjs file](\src\core\expression\index.ts)
      *
      * @packageDocumentation
      * @preferred
      */
    import { Expression, TextExpression } from "CharticulatorContainer/core/expression/classes";
    export { Expression, TextExpression, TextExpressionPart, Context, ShadowContext, LambdaFunction, SimpleContext, FieldAccess, FunctionCall, Variable, Value, NumberValue, BooleanValue, StringValue, DateValue, variableReplacer, } from "CharticulatorContainer/core/expression/classes";
    /** Shortcut to Expression.Parse */
    export function parse(str: string): Expression;
    /** Shortcut to TextExpression.Parse */
    export function parseTextExpression(str: string): TextExpression;
    export { variable, functionCall, lambda, fields, add, sub, mul, div, number, string, date, boolean, ExpressionCache, getDefaultAggregationFunction, getCompatibleAggregationFunctionsByDataType, getCompatibleAggregationFunctionsByDataKind, aggregationFunctions, AggregationFunctionDescription, verifyUserExpression, VerifyUserExpressionOptions, VerifyUserExpressionReport, } from "CharticulatorContainer/core/expression/helpers";
}

declare module 'CharticulatorContainer/core/solver' {
    import { AttributeOptions, ConstraintPlugin, ConstraintSolver, ConstraintStrength, Variable } from "CharticulatorContainer/core/solver/abstract";
    import { ChartConstraintSolver, GlyphConstraintAnalyzer } from "CharticulatorContainer/core/solver/solver";
    export { ChartConstraintSolver, GlyphConstraintAnalyzer, ConstraintSolver, AttributeOptions, ConstraintStrength, Variable, ConstraintPlugin, };
    import * as ConstraintPlugins from "CharticulatorContainer/core/solver/plugins";
    export { ConstraintPlugins };
}

declare module 'CharticulatorContainer/core/specification' {
    import { Color, Point } from "CharticulatorContainer/core/common";
    import * as Template from "CharticulatorContainer/core/specification/template";
    import * as Types from "CharticulatorContainer/core/specification/types";
    import { Specification } from "CharticulatorContainer/container";
    export { Types, Template };
    /** Objects with an unique ID */
    export interface Identifiable {
            /** Unique ID */
            _id: string;
    }
    /** Supported data value types */
    export type DataValue = number | string | boolean;
    /** Data type in memory */
    export enum DataType {
            /** String data type, stored as string */
            String = "string",
            /** Number data type, stored as number */
            Number = "number",
            /** Boolean data type, stored as boolean */
            Boolean = "boolean",
            /** Date data type, stored as unix timestamps (ms) */
            Date = "date",
            /** Image data as base64 string */
            Image = "image"
    }
    /** Abstract data kind */
    export enum DataKind {
            /** Ordinal data kind */
            Ordinal = "ordinal",
            /** Categorical data kind */
            Categorical = "categorical",
            /** Numerical data kind */
            Numerical = "numerical",
            /** Temporal data kind */
            Temporal = "temporal"
    }
    /** Data row */
    export interface DataRow {
            _id: string;
            [name: string]: DataValue;
    }
    export type Expression = string;
    export enum AttributeType {
            Number = "number",
            Enum = "enum",
            Text = "text",
            Boolean = "boolean",
            FontFamily = "font-family",
            Color = "color",
            Image = "image",
            Point = "point",
            Object = "object"
    }
    /** Attribute value types */
    export type AttributeValue = number | string | boolean | Color | Point | AttributeList | AttributeMap | Specification.Chart;
    /** Attribute value list */
    export interface AttributeList extends ArrayLike<AttributeValue> {
    }
    /** Attribute value map */
    export interface AttributeMap {
            [name: string]: AttributeValue;
    }
    /** Attribute mappings */
    export interface Mappings {
            [name: string]: Mapping;
    }
    export enum MappingType {
            _element = "_element",
            parent = "parent",
            scale = "scale",
            expressionScale = "expressionScale",
            text = "text",
            value = "value"
    }
    /** Attribute mapping */
    export interface Mapping {
            /** Mapping type */
            type: MappingType;
    }
    export type baselineH = "left" | "center" | "right";
    export type baselineV = "top" | "middle" | "bottom";
    export type baseline = baselineH | baselineV;
    /** Scale mapping: use a scale */
    export interface ScaleMapping extends Mapping {
            type: MappingType.scale;
            /** The table to draw data from */
            table: string;
            /** The data column */
            expression: Expression;
            /** Attribute of the mark */
            attribute?: string;
            /** Value type returned by the expression */
            valueType: DataType;
            /** The id of the scale to use. If null, use the expression directly */
            scale?: string;
            /** Index of value in mapping */
            valueIndex?: number;
    }
    /** Scale mapping: map id column data to image */
    export interface ScaleValueExpressionMapping {
            type: MappingType.expressionScale;
            /** The table to draw data from */
            table: string;
            /** The id column */
            expression: Expression;
            /** The data column */
            valueExpression: Expression;
            /** Attribute of the mark */
            attribute?: string;
            /** Value type returned by the expression */
            valueType: DataType;
            /** The id of the scale to use. If null, use the expression directly */
            scale?: string;
    }
    /** Text mapping: map data to text */
    export interface TextMapping extends Mapping {
            type: MappingType.text;
            /** The table to draw data from */
            table: string;
            /** The text expression */
            textExpression: string;
    }
    /** Value mapping: a constant value */
    export interface ValueMapping extends Mapping {
            type: MappingType.value;
            /** The constant value */
            value: AttributeValue;
    }
    /** Parent mapping: use an attribute of the item's parent item */
    export interface ParentMapping extends Mapping {
            type: MappingType.parent;
            /** The attribute of the parent item */
            parentAttribute: string;
    }
    /** Snapping element mapping: use an attribute of another element */
    export interface SnappingElementMapping extends Mapping {
            type: MappingType._element;
            element: string;
            attribute: string;
    }
    export interface ConstraintAttributes {
            gap?: number;
            element: string;
            attribute: string;
            targetElement: string;
            targetAttribute: string;
    }
    /** Constraint */
    export interface Constraint {
            /** Constraint type */
            type: string;
            attributes: ConstraintAttributes;
    }
    /** Object attributes */
    export interface ObjectProperties extends AttributeMap {
            /** The name of the object, used in UI */
            name?: string;
            visible?: boolean;
            emphasisMethod?: EmphasisMethod;
    }
    /** General object */
    export interface Object<PropertiesType extends ObjectProperties = ObjectProperties> extends Identifiable {
            /** The class ID for the Object */
            classID: string;
            /** Attributes  */
            properties: PropertiesType;
            /** Scale attribute mappings */
            mappings: Mappings;
    }
    export interface ExposableObject extends Object {
            exposed: boolean;
    }
    /** Element: a single graphical mark, such as rect, circle, wedge; an element is driven by a group of data rows */
    export interface Element<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** Glyph: a compound of elements, with constraints between them; a glyph is driven by a group of data rows */
    export interface Glyph<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            /** The data table this mark correspond to */
            table: string;
            /** Elements within the mark */
            marks: Element[];
            /** Layout constraints for this mark */
            constraints: Constraint[];
    }
    /** Scale */
    export interface Scale<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            inputType: DataType;
            outputType: AttributeType;
    }
    /** MarkLayout: the "PlotSegment" */
    export interface PlotSegment<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            /** The mark to use */
            glyph: string;
            /** The data table to get data rows from */
            table: string;
            /** Filter applied to the data table */
            filter?: Types.Filter;
            /** Group the data by a specified categorical column (filter is applied before grouping) */
            groupBy?: Types.GroupBy;
            /** Order the data (filter & groupBy is applied before order */
            order?: Types.SortBy;
    }
    /** Guide */
    export interface Guide<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** Guide Coordinator */
    export interface GuideCoordinator<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** Links */
    export interface Links<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** ChartElement is a PlotSegment or a Guide */
    export type ChartElement<PropertiesType extends ObjectProperties = ObjectProperties> = PlotSegment<PropertiesType> | Guide<PropertiesType> | GuideCoordinator<PropertiesType>;
    /** Resource item */
    export interface Resource {
            /** Resource item ID */
            id: string;
            /** Resource type: image */
            type: string;
            /** Resource data */
            data: any;
    }
    /** A chart is a set of chart elements and constraints between them, with guides and scales */
    export interface Chart<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            /** Marks */
            glyphs: Glyph[];
            /** Scales */
            scales: Scale[];
            /**
                * Temporary structure to save created scales for reusing instead creating new.
                * Unused scales will be removed on save
                */
            scaleMappings: ScaleMapping[];
            /** Chart elements */
            elements: ChartElement[];
            /** Chart-level constraints */
            constraints: Constraint[];
            /** Resources */
            resources: Resource[];
    }
    /** General object state */
    export interface ObjectState<AttributesType extends AttributeMap = AttributeMap> {
            attributes: AttributesType;
    }
    /** Element state */
    export interface MarkState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
    }
    /** Scale state */
    export interface ScaleState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
    }
    /** Glyph state */
    export interface GlyphState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
            marks: MarkState[];
            /** Should this specific glyph instance be emphasized */
            emphasized?: boolean;
    }
    /** PlotSegment state */
    export interface PlotSegmentState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
            glyphs: GlyphState[];
            dataRowIndices: number[][];
    }
    /** Guide state */
    export interface GuideState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
    }
    /** Chart element state, one of PlotSegmentState or GuideState */
    export type ChartElementState<AttributesType extends AttributeMap = AttributeMap> = PlotSegmentState<AttributesType> | GuideState<AttributesType> | MarkState<AttributesType>;
    /** Chart state */
    export interface ChartState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
            /** Mark binding states corresponding to Chart.marks */
            elements: ChartElementState[];
            /** Scale states corresponding to Chart.scales */
            scales: ScaleState[];
            scaleMappings: ScaleMapping[];
    }
    /**
        * Represents the type of method to use when emphasizing an element
        */
    export enum EmphasisMethod {
            Saturation = "saturation",
            Outline = "outline"
    }
}

declare module 'CharticulatorContainer/core/common/utils' {
    import { Color } from "CharticulatorContainer/core/common/color";
    import { FormatLocaleDefinition } from "d3-format";
    /** zip two arrays, return an iterator */
    export function zip<T1, T2>(a: T1[], b: T2[]): IterableIterator<[T1, T2]>;
    /** zip two arrays, return a new array */
    export function zipArray<T1, T2>(a: T1[], b: T2[]): [T1, T2][];
    /** Transpose a matrix r[i][j] = matrix[j][i] */
    export function transpose<T>(matrix: T[][]): T[][];
    /** Generate a range of integers: [start, end) */
    export function makeRange(start: number, end: number): number[];
    /** Deep clone an object. The object must be JSON-serializable */
    export function deepClone<T>(obj: T): T;
    export function shallowClone<T>(obj: T): T;
    export function max<T>(array: T[], accessor: (val: T, index: number, array: T[]) => number): number;
    export function argMax<T>(array: T[], accessor: (val: T, index: number, array: T[]) => number): number;
    export function min<T>(array: T[], accessor: (val: T, index: number, array: T[]) => number): number;
    export function argMin<T>(array: T[], accessor: (val: T, index: number, array: T[]) => number): number;
    export type FieldType = string | number | (string | number)[];
    export function setField<ObjectType, ValueType>(obj: ObjectType, field: FieldType, value: ValueType): ObjectType;
    export function getField<ObjectType>(obj: ObjectType, field: FieldType): ObjectType;
    /** Fill default values into an object */
    export function fillDefaults<T extends Record<string, unknown>>(obj: Partial<T>, defaults: T): T;
    /** Find the index of the first element that satisfies the predicate, return -1 if not found */
    export function indexOf<T>(array: T[], predicate: (item: T, idx: number) => boolean): number;
    /** Get the first element with element._id == id, return null if not found */
    export function getById<T extends {
            _id: string;
    }>(array: T[], id: string): T;
    /** Get the index of the first element with element._id == id, return -1 if not found */
    export function getIndexById<T extends {
            _id: string;
    }>(array: T[], id: string): number;
    /** Get the first element with element.name == name, return null if not found */
    export function getByName<T extends {
            name: string;
    }>(array: T[], name: string): T;
    /** Get the index of the first element with element.name == name, return -1 if not found */
    export function getIndexByName<T extends {
            name: string;
    }>(array: T[], name: string): number;
    export function gather<T>(array: T[], keyFunction: (item: T, index: number) => string): T[][];
    /**
        * Sort an array with compare function, make sure when compare(a, b) == 0,
        * a and b are still in the original order (i.e., stable)
        */
    export function stableSort<T>(array: T[], compare: (a: T, b: T) => number): T[];
    /** Sort an array by key given by keyFunction */
    export function sortBy<T>(array: T[], keyFunction: (a: T) => number | string, reverse?: boolean): T[];
    /** Stable sort an array by key given by keyFunction */
    export function stableSortBy<T>(array: T[], keyFunction: (a: T) => number | string, reverse?: boolean): T[];
    /** Map object that maps (Object, string) into ValueType */
    export class KeyNameMap<KeyType, ValueType> {
            /** Add a new entry to the map */
            add(key: KeyType, name: string, value: ValueType): void;
            /** Delete an entry (do nothing if not exist) */
            delete(key: KeyType, name: string): void;
            /** Determine if the map has an entry */
            has(key: KeyType, name: string): any;
            /** Get the value corresponding to an entry, return null if not found */
            get(key: KeyType, name: string): ValueType;
            forEach(callback: (value: ValueType, key: KeyType, name: string) => void): void;
    }
    export abstract class HashMap<KeyType, ValueType> {
            /** Implement this hash function in your map */
            protected abstract hash(key: KeyType): string;
            set(key: KeyType, value: ValueType): void;
            get(key: KeyType): ValueType;
            has(key: KeyType): boolean;
            delete(key: KeyType): void;
            clear(): void;
            values(): IterableIterator<ValueType>;
    }
    export class MultistringHashMap<ValueType> extends HashMap<string[], ValueType> {
            protected separator: string;
            protected hash(key: string[]): string;
    }
    /** Parsed semver version number */
    export interface ParsedVersion {
            major: number;
            minor: number;
            patch: number;
    }
    /** Parse semver version string into a ParsedVersion */
    export function parseVersion(version: string): {
            major: number;
            minor: number;
            patch: number;
    };
    /**
        * Compare two version strings
        * @param version1 version number 1
        * @param version2 version number 2
        * @returns negative if version1 < version2, zero if version1 == version2, positive if version1 > version2
        */
    export function compareVersion(version1: string, version2: string): number;
    /**
        * Converts Color object to Hex
        * @param color Color object
        * @returns Hex representation of color
        */
    export function rgbToHex(color: Color): string;
    /**
        * Converts Hex to Color object
        * @param color Color object
        * @returns Hex representation of color
        */
    export function hexToRgb(hex: string): Color;
    /**
        * Return common comparator for two values or sope specific comparator for specific data type
        * testToRange function compares properly, strings with numbers: number-number, number-, number+
        * to sort value ranges list properly
        */
    export function getSortFunctionByData(values: string[]): (a: any, b: any) => 1 | -1;
    /**
        * Retunrs sort direction by comparing the first and the last values of string array
        */
    export function getSortDirection(values: string[]): string;
    /**
        * Applies timeFormat function of d3 to value
        * @param value date value
        * @param format date format of d3
        */
    export function applyDateFormat(value: Date, format: string): string;
    export const colorAttributes: string[];
    /**
        * Compares attribute names
        */
    export function compareMarkAttributeNames(a: string, b: string): boolean;
    export function refineColumnName(name: string): string;
    export function getTimeZoneOffset(date: number): number;
    export function replaceNewLineBySymbol(str: string): string;
    export function splitStringByNewLine(str: string): string[];
    export function replaceTabBySymbol(str: string): string;
    export function replaceSymbolByNewLine(str: string): string;
    export function replaceSymbolByTab(str: string): string;
    export function getFormatOptions(): FormatLocaleDefinition;
    export function setFormatOptions(options: FormatLocaleDefinition): void;
    export function setTimeZone(utcTimeZone: boolean): void;
    export function isUtcTimeZone(): boolean;
    export function getTimeFormatFunction(): (specifier: string) => (date: Date) => string;
    export const tickFormatParserExpression: () => RegExp;
    export function getFormat(): (specifier: string) => (n: number | {
            valueOf(): number;
    }) => string;
    export function parseSafe(value: string, defaultValue?: any): any;
    export function getRandom(startRange: number, endRange: number): number;
    export function defineCategories(vector: any[]): string[];
}

declare module 'CharticulatorContainer/core/common/color' {
    import { Colorspace } from "CharticulatorContainer/app/components/fluent_ui_gradient_picker";
    /** Color in RGB */
    export interface Color {
        r: number;
        g: number;
        b: number;
    }
    /** Color gradient */
    export interface ColorGradient {
        colorspace: Colorspace;
        colors: Color[];
    }
    /** Get Color from HTML color string */
    export function colorFromHTMLColor(html: string): Color;
    export function parseColorOrThrowException(html: string): Color;
    export function colorToHTMLColor(color: Color): string;
    export function colorToHTMLColorHEX(color: Color): string;
    export type ColorConverter = (a: number, b: number, c: number) => [number, number, number] | [number, number, number, boolean];
    export function getColorConverter(from: string, to: string): ColorConverter;
    export type ColorInterpolation = (t: number) => Color;
    export function interpolateColor(from: Color, to: Color, colorspace?: string): ColorInterpolation;
    export function interpolateColors(colors: Color[], colorspace?: string): ColorInterpolation;
    export function setDefaultColorPaletteGenerator(generatorFunction: (key: string) => Color): void;
    export function getDefaultColorPaletteGenerator(): (key: string) => Color;
    export function setDefaultColorGeneratorResetFunction(resetFunction: () => void): void;
    export function getDefaultColorGeneratorResetFunction(): () => void;
    export function getDefaultColorPaletteByValue(value: string): Color;
    export function getDefaultColorPalette(count: number): Color[];
}

declare module 'CharticulatorContainer/core/actions' {
    /**
      * Contains few actions used by core part of charticulator. See {@link "core/actions/actions"} for details
      * @packageDocumentation
      * @preferred
      */
    export * from "CharticulatorContainer/core/actions/actions";
}

declare module 'CharticulatorContainer/core/graphics/elements' {
    /**
      * Internal graphics representation
      * Bridge the core components with the rendering system
      *
      * Coordinate System:
      *        y
      *        ^
      *        |
      *   -----o-----> x
      *        |
      *        |
      *
      * Rigid Transform:
      *
      *  (theta is counter clockwise in above diagram)
      *  x' = x cos(theta) - y sin(theta) + tx
      *  y' = x sin(theta) + y cos(theta) + ty
      *
      *  concatTransform(a, b)(p) = a(b(p))
      *
      * @packageDocumentation
      * @preferred
      */
    import * as React from "react";
    import { Color, Point } from "CharticulatorContainer/core/common";
    import * as Specification from "CharticulatorContainer/core/specification";
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import { ArrowType } from "CharticulatorContainer/core/prototypes/links";
    export interface PointDirection extends Point {
        direction: Point;
    }
    export interface RigidTransform {
        x: number;
        y: number;
        angle: number;
    }
    /** Specify a modification to a numeric value: (v' = set) or (v' = (v * multiply + add) ^ pow) */
    export interface NumberModifier {
        /** Set to a specific value */
        set?: number;
        /** Multiply a scaler to */
        multiply?: number;
        /** Add the amount to */
        add?: number;
        /** Apply a pow function to */
        pow?: number;
    }
    export interface ColorFilter {
        saturation?: NumberModifier;
        lightness?: NumberModifier;
    }
    export interface Style {
        strokeColor?: Color;
        strokeOpacity?: number;
        strokeWidth?: number;
        strokeDasharray?: string;
        strokeLinejoin?: "round" | "miter" | "bevel";
        strokeLinecap?: "round" | "butt" | "square";
        colorFilter?: ColorFilter;
        fillColor?: Color;
        backgroundColor?: Color;
        backgroundColorId?: string;
        fillOpacity?: number;
        /** The opacity of this element */
        opacity?: number;
        /** Text anchor position */
        textAnchor?: "start" | "middle" | "end";
        startArrowColorId?: string;
        endArrowColorId?: string;
    }
    export interface Interactable {
        onClick?: (event: React.MouseEvent<globalThis.Element>) => void;
        onMousedown?: (event: React.MouseEvent<globalThis.Element>) => void;
        onMouseup?: (event: React.MouseEvent<globalThis.Element>) => void;
        onMousewheel?: (event: React.MouseEvent<globalThis.Element>) => void;
        onMousemove?: (event: React.MouseEvent<globalThis.Element>) => void;
    }
    export interface Selectable {
        plotSegment: Specification.PlotSegment;
        glyphIndex: number;
        rowIndices: number[];
        enableTooltips?: boolean;
        enableSelection?: boolean;
        enableContextMenu?: boolean;
    }
    export interface Element {
        type: string;
        style?: Style;
        selectable?: Selectable;
        interactable?: Interactable;
    }
    export interface ChartContainerElement {
        type: "chart-container";
        chart: Specification.Chart;
        selectable: Selectable;
        dataset: Dataset.Dataset;
        x: number;
        y: number;
        width: number;
        height: number;
    }
    export interface Rect extends Element {
        type: "rect";
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        rx?: number;
        ry?: number;
        rotation?: number;
    }
    export interface Line extends Element {
        type: "line";
        x1: number;
        y1: number;
        x2: number;
        y2: number;
    }
    export interface Polygon extends Element {
        type: "polygon";
        points: Point[];
    }
    export interface Path extends Element {
        type: "path";
        cmds: {
            cmd: string;
            args: number[];
        }[];
        transform: string;
        beginArrowType?: ArrowType;
        endArrowType?: ArrowType;
    }
    export interface Circle extends Element {
        type: "circle";
        cx: number;
        cy: number;
        r: number;
    }
    export interface Ellipse extends Element {
        type: "ellipse";
        x1: number;
        y1: number;
        x2: number;
        y2: number;
    }
    export interface Text extends Element {
        type: "text";
        cx: number;
        cy: number;
        text: string;
        fontFamily: string;
        fontSize: number;
    }
    export enum PathTextAlignment {
        Start = "start",
        Middle = "middle",
        End = "end"
    }
    export interface TextOnPath extends Element {
        type: "text-on-path";
        pathCmds: Path["cmds"];
        align: PathTextAlignment;
        text: string;
        fontFamily: string;
        fontSize: number;
    }
    export interface Image extends Element {
        type: "image";
        src: string;
        x: number;
        y: number;
        width: number;
        height: number;
        /** Size mode, default to letterbox */
        mode?: "letterbox" | "stretch";
    }
    export interface Group extends Element {
        type: "group";
        key?: string;
        transform: RigidTransform;
        elements: Element[];
    }
    export function makeRect(x1: number, y1: number, x2: number, y2: number, style?: Style, rx?: number, ry?: number): Rect;
    export function makeCircle(cx: number, cy: number, r: number, style?: Style): Circle;
    export function makeEllipse(x1: number, y1: number, x2: number, y2: number, style?: Style): Ellipse;
    export function makeGroup(elements: Element[]): Group;
    export function makeLine(x1: number, y1: number, x2: number, y2: number, style?: Style): Line;
    export function makePolygon(points: Point[], style?: Style): Polygon;
    export function makeText(cx: number, cy: number, text: string, fontFamily: string, fontSize: number, style?: Style, selectable?: Selectable): Text;
    export class PathMaker {
        path: Path;
        currentX: number;
        currentY: number;
        moveTo(x: number, y: number): void;
        lineTo(x: number, y: number): void;
        transformRotation(angle: number, x?: number, y?: number): void;
        setBeginArrowType(arrowType: ArrowType): void;
        setEndArrowType(arrowType: ArrowType): void;
        cubicBezierCurveTo(c1x: number, c1y: number, c2x: number, c2y: number, x: number, y: number): void;
        quadraticBezierCurveTo(cx: number, cy: number, x: number, y: number): void;
        arcTo(rx: number, ry: number, xAxisRotation: number, largeArcFlag: number, sweepFlag: number, x: number, y: number): void;
        /** Compose a Archimedean spiral with r = a + b theta, theta from thetaMin to thetaMax */
        archimedeanSpiral(cx: number, cy: number, a: number, b: number, thetaMin: number, thetaMax: number, moveTo?: boolean): void;
        polarLineTo(cx: number, cy: number, angle1: number, r1: number, angle2: number, r2: number, moveTo?: boolean): void;
        closePath(): void;
    }
    export function makePath(style?: Style): PathMaker;
    export function translation(x?: number, y?: number): RigidTransform;
    export function rotation(angle: number): RigidTransform;
    /** Concat two transforms, f(p) := a(b(p))  */
    export function concatTransform(a: RigidTransform, b: RigidTransform): {
        x: number;
        y: number;
        angle: number;
    };
    export function transform(transform: RigidTransform, a: Point): Point;
    export function transformDirection(transform: RigidTransform, a: Point): Point;
}

declare module 'CharticulatorContainer/core/graphics/renderer' {
    /**
        * See {@link ChartRenderer} for details
        *
        * @packageDocumentation
        * @preferred
        */
    import { ReactElement } from "react";
    import { ZoomInfo } from "CharticulatorContainer/core/common";
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import * as Prototypes from "CharticulatorContainer/core/prototypes";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { Group } from "CharticulatorContainer/core/graphics/elements";
    export function facetRows(rows: Dataset.Row[], indices: number[], columns?: string[]): number[][];
    export interface RenderEvents {
            afterRendered: () => void;
    }
    /**
        * The class is responsible for rendering the visual part of the chart (coordinates, elements such as glyph marks e.t.c).
        * The module calls methods {@link MarkClass.getGraphics} implemented in each marks (rect, image, text, symbol e.t.c)
        *
        */
    export class ChartRenderer {
            constructor(manager: Prototypes.ChartStateManager, renderEvents?: RenderEvents);
            renderControls(chart: Specification.Chart, chartState: Specification.ChartState, zoom: ZoomInfo): ReactElement<any, string | ((props: any) => ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>[];
            render(): Group;
    }
    export * from "CharticulatorContainer/core/graphics/renderer/text_measurer";
}

declare module 'CharticulatorContainer/core/graphics/coordinate_system' {
    /**
      * @packageDocumentation
      * @preferred
      */
    import { Element, MultiCurveParametrization, PathMaker } from "CharticulatorContainer/core/graphics";
    import { Point } from "CharticulatorContainer/core/common";
    import { RigidTransform, Style } from "CharticulatorContainer/core/graphics/elements";
    export abstract class CoordinateSystem {
        /** Get the transform of the whole coordinate system (in the final Cartesian system) */
        abstract getBaseTransform(): RigidTransform;
        /** Transform the point (x, y) to Cartesian system */
        abstract transformPoint(x: number, y: number): Point;
        abstract transformDirectionAtPoint(x: number, y: number, dx: number, dy: number): Point;
        /** Get the local affine transform at point (x, y) */
        abstract getLocalTransform(x: number, y: number): RigidTransform;
        abstract transformPointWithBase(x: number, y: number): Point;
        abstract transformDirectionAtPointWithBase(x: number, y: number, dx: number, dy: number): Point;
    }
    /** Normal cartesian coordinate system */
    export class CartesianCoordinates extends CoordinateSystem {
        origin: Point;
        constructor(origin?: Point);
        getBaseTransform(): RigidTransform;
        transformPoint(x: number, y: number): Point;
        transformDirectionAtPoint(x: number, y: number, dx: number, dy: number): Point;
        transformPointWithBase(x: number, y: number): Point;
        transformDirectionAtPointWithBase(x: number, y: number, dx: number, dy: number): Point;
        getLocalTransform(x: number, y: number): RigidTransform;
    }
    /** Polar coordinates. Angle is in degrees, clockwise, top is 0  */
    export class PolarCoordinates extends CoordinateSystem {
        origin: Point;
        radial1: number;
        radial2: number;
        distortY: boolean;
        constructor(origin?: Point, radial1?: number, radial2?: number, distortY?: boolean);
        getBaseTransform(): RigidTransform;
        transformRadial(radial: number): number;
        inverseTransformRadial(distance: number): number;
        transformPoint(angle: number, radial: number): Point;
        transformDirectionAtPoint(angle: number, radial: number, dx: number, dy: number): Point;
        getLocalTransform(angle: number, radial: number): RigidTransform;
        transformPointWithBase(angle: number, radial: number): Point;
        transformDirectionAtPointWithBase(angle: number, radial: number, dx: number, dy: number): Point;
    }
    /** Bezier curve coordinate system. */
    export class BezierCurveCoordinates extends CoordinateSystem {
        origin: Point;
        constructor(origin: Point, curve: MultiCurveParametrization);
        getBaseTransform(): RigidTransform;
        transformPoint(x: number, y: number): Point;
        transformDirectionAtPoint(x: number, y: number, dx: number, dy: number): Point;
        getLocalTransform(x: number, y: number): RigidTransform;
        transformPointWithBase(x: number, y: number): Point;
        transformDirectionAtPointWithBase(x: number, y: number, dx: number, dy: number): Point;
        getLength(): number;
        getCurve(): MultiCurveParametrization;
    }
    export class CoordinateSystemHelper {
        coordinateSystem: CoordinateSystem;
        constructor(coordinateSystem: CoordinateSystem);
        rect(x1: number, y1: number, x2: number, y2: number, style?: Style, rx?: number, ry?: number): Element;
        ellipse(x1: number, y1: number, x2: number, y2: number, style?: Style): Element;
        line(x1: number, y1: number, x2: number, y2: number, style?: Style): Element;
        lineTo(path: PathMaker, x1: number, y1: number, x2: number, y2: number, newPath: boolean): void;
        arcTo(path: PathMaker, rx: number, ry: number, x1: number, y1: number, x2: number, y2: number, sweepFlag?: number): import("./elements").Path;
    }
}

declare module 'CharticulatorContainer/core/graphics/bezier_curve' {
    import { Point } from "CharticulatorContainer/core/common";
    /**
      * Compute numerical integral y' = f(t, y), y(t0) = y0,
      *  start from t0, step size h, with specified number of steps,
      *  with Runge-Kutta Method order 4
      */
    export function RK4(f: (t: number, y: number) => number, y0: number, t0: number, h: number, steps: number, result?: number[]): number[];
    export function linearApproximation(points: ArrayLike<number>, t: number): number;
    export function findSegment(bounds: number[], k: number): [number, number];
    export function linearInvert(points: ArrayLike<number>, result?: number[]): number[];
    export abstract class CurveParameterization {
        abstract getPointAtT(t: number): Point;
        abstract getTangentAtT(t: number): Point;
        abstract getSFromT(t: number): number;
        abstract getTFromS(s: number): number;
        abstract getLength(): number;
        getNormalAtT(t: number): {
            x: number;
            y: number;
        };
    }
    /** Parametrize a given bezier curve */
    export class BezierCurveParameterization extends CurveParameterization {
        /** Construct the cubic bezier curve with four control points */
        constructor(p1: Point, p2: Point, p3: Point, p4: Point);
        getPointAtT(t: number): {
            x: number;
            y: number;
        };
        /** Get the tangent direction at t */
        getTangentAtT(t: number): {
            x: number;
            y: number;
        };
        /** Get ds/dt at t */
        getDsDtAtT(t: number): number;
        getSFromT(t: number): number;
        getTFromS(s: number): number;
        getLength(): number;
    }
    export class LineSegmentParametrization extends CurveParameterization {
        p1: Point;
        p2: Point;
        length: number;
        tangent: Point;
        constructor(p1: Point, p2: Point);
        getTangentAtT(t: number): Point;
        getPointAtT(t: number): {
            x: number;
            y: number;
        };
        getSFromT(t: number): number;
        getTFromS(s: number): number;
        getLength(): number;
    }
    export class MultiCurveParametrization {
        constructor(segments: CurveParameterization[]);
        getPointAtS(s: number): Point;
        getTangentAtS(s: number): Point;
        getNormalAtS(s: number): Point;
        getFrameAtS(s: number): {
            p: Point;
            t: Point;
            n: Point;
        };
        getLength(): number;
        getSegments(): CurveParameterization[];
    }
}

declare module 'CharticulatorContainer/core/prototypes/charts' {
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { DataflowManager } from "CharticulatorContainer/core/prototypes/dataflow";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { AttributeDescription, Controls, Handles, ObjectClass, ObjectClassMetadata, SnappingGuides, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { Color } from "CharticulatorContainer/core/common";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    export abstract class ChartClass extends ObjectClass {
        readonly object: Specification.Chart;
        readonly state: Specification.ChartState;
        dataflow: DataflowManager;
        manager: ChartStateManager;
        static metadata: ObjectClassMetadata;
        setDataflow(dataflow: DataflowManager): void;
        setManager(manager: ChartStateManager): void;
        getBackgroundGraphics(): Graphics.Element;
        resolveMapping<ValueType>(mapping: Specification.Mapping, defaultValue: Specification.AttributeValue): (row: Expression.Context) => Specification.AttributeValue;
        abstract initializeState(): void;
        abstract buildIntrinsicConstraints(solver: ConstraintSolver): void;
        abstract getSnappingGuides(): SnappingGuides.Description[];
        abstract getHandles(): Handles.Description[];
    }
    interface RectangleChartAttributes extends Specification.AttributeMap {
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        cx: number;
        cy: number;
        ox1: number;
        oy1: number;
        ox2: number;
        oy2: number;
        width: number;
        height: number;
        marginLeft: number;
        marginRight: number;
        marginTop: number;
        marginBottom: number;
        backgroundColor: Color;
    }
    interface RectangleChartState extends Specification.ChartState {
        attributes: RectangleChartAttributes;
    }
    export class RectangleChart extends ChartClass {
        static classID: string;
        static type: string;
        static defaultMappingValues: Specification.AttributeMap;
        static defaultProperties: Specification.AttributeMap;
        readonly object: Specification.Chart & {
            properties: {
                backgroundColor: Color;
                backgroundOpacity: number;
            };
        };
        readonly state: RectangleChartState;
        attributeNames: string[];
        attributes: {
            [name: string]: AttributeDescription;
        };
        initializeState(): void;
        getBackgroundGraphics(): Graphics.Rect;
        buildIntrinsicConstraints(solver: ConstraintSolver): void;
        getSnappingGuides(): SnappingGuides.Description[];
        getHandles(): Handles.Description[];
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
        getTemplateParameters(): TemplateParameters;
    }
    export function registerClasses(): void;
    export {};
}

declare module 'CharticulatorContainer/core/prototypes/constraints' {
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    export abstract class ConstraintTypeClass {
        abstract type: string;
        abstract buildConstraints(constraint: Specification.Constraint, elements: Specification.Object[], states: Specification.ObjectState[], solver: ConstraintSolver): void;
        static register(entry: ConstraintTypeClass): void;
        static getClass(type: string): ConstraintTypeClass;
    }
    export class SnapConstraintClass {
        type: string;
        buildConstraints(constraint: Specification.Constraint, elements: Specification.Object[], states: Specification.ObjectState[], solver: ConstraintSolver): void;
    }
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/dataflow' {
    /**
      * Expressions context providers.
      *
      * {@link DataflowTable} provides data context for charticulator's expressions, solver, plotsegments.
      *
      * {@link DataflowManager} is a proxy between dateset and other parts of charticualtor.
      *
      * @packageDocumentation
      * @preferred
      */
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Specification from "CharticulatorContainer/core/specification";
    export class DataflowTableGroupedContext implements Expression.Context {
        protected table: DataflowTable;
        protected indices: number[];
        constructor(table: DataflowTable, indices: number[]);
        getTable(): DataflowTable;
        getVariable(name: string): DataflowTable | Specification.DataRow[] | (string | number | boolean)[] | Specification.Template.Column[];
    }
    export class DataflowTable implements Expression.Context {
        parent: DataflowManager;
        name: string;
        rows: Specification.DataRow[];
        columns: Specification.Template.Column[];
        options?: {
            displayName: string;
        };
        constructor(parent: DataflowManager, name: string, rows: Specification.DataRow[], columns: Specification.Template.Column[], options?: {
            displayName: string;
        });
        /** Implements Expression.Context */
        getVariable(name: string): DataflowTable | Specification.DataRow[] | Specification.Template.Column[];
        /** Get a row with index */
        getRow(index: number): Specification.DataRow;
        /** Get a row context with index */
        getRowContext(index: number): Expression.Context;
        getGroupedContext(rowIndices: number[]): Expression.Context;
    }
    export class DataflowManager implements Expression.Context {
        readonly context: Dataset.DatasetContext;
        readonly cache: Expression.ExpressionCache;
        constructor(dataset: Dataset.Dataset);
        /** Get a table by name (either original table or derived table) */
        getTable(name: string): DataflowTable;
        /** Implements Expression.Context */
        getVariable(name: string): DataflowTable;
    }
}

declare module 'CharticulatorContainer/core/prototypes/glyphs' {
    /**
      * ![Chart levels](media://glyph-levels.png)
      *
      * The Chart-level specification includes chart elements, layout constraints between them, and scales. The most important chart element is
      * a plot segment, which lays out glyphs according to its scaffolds and/or
      * axes, and transforms them according to its coordinate system, scales specify how data is mapped to attributes
      * such as width, height, and color, and they can be shared among several
      * marks. Legends visualize the scales used in the chart.
      *
      * @packageDocumentation
      * @preferred
      */
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import { AttributeDescription, Controls, Handles, ObjectClass, ObjectClassMetadata, SnappingGuides } from "CharticulatorContainer/core/prototypes/common";
    export abstract class GlyphClass extends ObjectClass {
        readonly object: Specification.Glyph;
        readonly state: Specification.GlyphState;
        static metadata: ObjectClassMetadata;
        abstract initializeState(): void;
        abstract buildIntrinsicConstraints(solver: ConstraintSolver): void;
        abstract getAlignmentGuides(): SnappingGuides.Description[];
        abstract getHandles(): Handles.Description[];
        static createDefault(table: string): Specification.Glyph;
    }
    export interface RectangleGlyphAttributes extends Specification.AttributeMap {
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        x: number;
        y: number;
        width: number;
        height: number;
        ix1: number;
        iy1: number;
        ix2: number;
        iy2: number;
        icx: number;
        icy: number;
    }
    export interface RectangleGlyphState extends Specification.GlyphState {
        attributes: RectangleGlyphAttributes;
    }
    export class RectangleGlyph extends GlyphClass {
        static classID: string;
        static type: string;
        readonly state: RectangleGlyphState;
        attributeNames: string[];
        attributes: {
            [name: string]: AttributeDescription;
        };
        initializeState(): void;
        buildIntrinsicConstraints(solver: ConstraintSolver): void;
        getAlignmentGuides(): SnappingGuides.Description[];
        getHandles(): Handles.Description[];
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
    }
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/guides' {
    export { GuideClass, GuideAxis, GuideProperties, GuideAttributeNames, GuideAttributes, GuidePropertyNames, } from "CharticulatorContainer/core/prototypes/guides/guide";
    export { GuideCoordinatorAttributes, GuideCoordinatorClass, GuideCoordinatorProperties, } from "CharticulatorContainer/core/prototypes/guides/guide_coordinator";
    export { PolarGuideCoordinatorAttributes, PolarGuideCoordinatorProperties, GuidePolarCoordinatorClass, GuidePolarCoordinatorProperties, PolarGuideObject, PolarGuideState, } from "CharticulatorContainer/core/prototypes/guides/polar_coordinator";
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/legends' {
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/links' {
    import { Color, Point } from "CharticulatorContainer/core/common";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { Controls, ObjectClassMetadata, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { DataflowTable } from "CharticulatorContainer/core/prototypes/dataflow";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    import { AttributeDescription } from "CharticulatorContainer/core/prototypes/object";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments";
    export type LinkType = "line" | "band";
    export type InterpolationType = "line" | "bezier" | "circle";
    export type LinkMarkType = "" | "4" | "1 4";
    export const linkMarkTypes: string[];
    export interface LinksProperties extends Specification.AttributeMap {
        linkType: LinkType;
        linkMarkType?: LinkMarkType;
        interpolationType: InterpolationType;
        /** Start anchor */
        anchor1: Specification.Types.LinkAnchorPoint[];
        /** End anchor */
        anchor2: Specification.Types.LinkAnchorPoint[];
        /** Filter the data before linking */
        filter?: Specification.Expression;
        /** Order the data before linking */
        order?: Specification.Expression;
        /** Link through a data series on a single plot segment */
        linkThrough?: {
            /** The MarkLayout to draw marks from */
            plotSegment: string;
            /** Facet the data by a set of expressions */
            facetExpressions?: string[];
        };
        /** Link between (2) plot segments */
        linkBetween?: {
            /** The MarkLayouts to draw marks from */
            plotSegments: string[];
        };
        /** Link using a link table, from one plot segment to another */
        linkTable?: {
            table: string;
            plotSegments: string[];
        };
        curveness: number;
        closeLink?: boolean;
        beginArrowType?: ArrowType;
        endArrowType?: ArrowType;
    }
    export enum ArrowType {
        NO_ARROW = "NO_ARROW",
        ARROW = "ARROW",
        DIAMOND_ARROW = "DIAMOND_ARROW",
        OVAL_ARROW = "OVAL_ARROW"
    }
    export interface LinksObject extends Specification.Links {
        properties: LinksProperties;
    }
    export function facetRows(table: DataflowTable, indices: number[][], columns?: Expression.Expression[]): number[][][];
    export interface ResolvedLinkAnchorPoint {
        anchorIndex: number;
        x: {
            element: number;
            attribute: string;
        };
        y: {
            element: number;
            attribute: string;
        };
        direction: Point;
    }
    export interface AnchorCoordinates {
        points: Graphics.PointDirection[];
        curveness: number;
        coordinateSystem: Graphics.CoordinateSystem;
    }
    export interface AnchorAttributes extends AnchorCoordinates {
        color: Color;
        opacity: number;
        strokeWidth: number;
    }
    export interface RenderState {
        colorFunction: (row: Expression.Context) => Specification.AttributeValue;
        opacityFunction: (row: Expression.Context) => Specification.AttributeValue;
        strokeWidthFunction: (row: Expression.Context) => Specification.AttributeValue;
    }
    export abstract class LinksClass extends ChartElementClass {
        readonly object: LinksObject;
        readonly state: Specification.ObjectState;
        static metadata: ObjectClassMetadata;
        attributeNames: string[];
        attributes: {
            [name: string]: AttributeDescription;
        };
        protected resolveLinkAnchorPoints(anchorPoints: Specification.Types.LinkAnchorPoint[], glyph: Specification.Glyph): ResolvedLinkAnchorPoint[];
        protected getAnchorPoints(renderState: RenderState, anchorPoints: ResolvedLinkAnchorPoint[], plotSegmentClass: PlotSegmentClass, glyphState: Specification.GlyphState, row: Expression.Context): AnchorAttributes;
        static BandPath(path: Graphics.PathMaker, anchor: AnchorCoordinates, reversed?: boolean, newPath?: boolean): void;
        static ConnectionPath(path: Graphics.PathMaker, interpType: InterpolationType, p1: Point, d1: Point, curveness1: number, p2: Point, d2: Point, curveness2: number, newPath?: boolean): void;
        static LinkPath(path: Graphics.PathMaker, linkType: LinkType, interpType: InterpolationType, anchor1: AnchorCoordinates, anchor2: AnchorCoordinates): void;
        protected renderLinks(linkGraphics: LinkType, lineType: InterpolationType, anchorGroups: AnchorAttributes[][][], strokeDashArray?: LinkMarkType): Graphics.Group;
        /** Get the graphics that represent this layout */
        getGraphics(manager: ChartStateManager): Graphics.Element;
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
        getTemplateParameters(): TemplateParameters;
    }
    export class SeriesLinksClass extends LinksClass {
        static classID: string;
        static type: string;
        static defaultProperties: Specification.AttributeMap;
        /** Get the graphics that represent this layout */
        getGraphics(manager: ChartStateManager): Graphics.Element;
    }
    export class LayoutsLinksClass extends LinksClass {
        static classID: string;
        static type: string;
        static defaultProperties: Specification.AttributeMap;
        /** Get the graphics that represent this layout */
        getGraphics(manager: ChartStateManager): Graphics.Element;
    }
    export class TableLinksClass extends LinksClass {
        static classID: string;
        static type: string;
        static defaultProperties: Specification.AttributeMap;
        /** Get the graphics that represent this layout */
        getGraphics(manager: ChartStateManager): Graphics.Element;
    }
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/marks' {
    import { CreationParameters, MarkClass } from "CharticulatorContainer/core/prototypes/marks/mark";
    import { symbolTypesList } from "CharticulatorContainer/core/prototypes/marks/symbol";
    export function registerClasses(): void;
    export { CreationParameters, MarkClass, symbolTypesList };
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments' {
    export { defaultAxisStyle } from "CharticulatorContainer/core/prototypes/plot_segments/axis";
    export { LineGuideAttributes } from "CharticulatorContainer/core/prototypes/plot_segments/line";
    export { CartesianPlotSegment, CurvePlotSegment, PolarPlotSegment, Region2DAttributes, Region2DProperties, } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d";
    export { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments/plot_segment";
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/scales' {
    import { ScaleClass } from "CharticulatorContainer/core/prototypes/scales/scale";
    import { AttributeType, DataKind, DataType } from "CharticulatorContainer/core/specification";
    export { ScaleClass };
    export function inferScaleType(dataType: DataType, dataKind: DataKind, attrType: AttributeType): string;
    export function registerClasses(): void;
}

declare module 'CharticulatorContainer/core/prototypes/cache' {
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { ObjectClass } from "CharticulatorContainer/core/prototypes/object";
    import * as Charts from "CharticulatorContainer/core/prototypes/charts";
    import * as Glyphs from "CharticulatorContainer/core/prototypes/glyphs";
    import * as Marks from "CharticulatorContainer/core/prototypes/marks/mark";
    import * as PlotSegments from "CharticulatorContainer/core/prototypes/plot_segments";
    import * as Scales from "CharticulatorContainer/core/prototypes/scales";
    export class ObjectClassCache {
        /** Clear the cache */
        clear(): void;
        hasClass(state: Specification.ObjectState): boolean;
        getMarkClass(state: Specification.MarkState): Marks.MarkClass;
        getGlyphClass(state: Specification.GlyphState): Glyphs.GlyphClass;
        getPlotSegmentClass(state: Specification.PlotSegmentState): PlotSegments.PlotSegmentClass;
        getChartElementClass(state: Specification.ChartElementState): ChartElementClass;
        getScaleClass(state: Specification.ScaleState): Scales.ScaleClass;
        getChartClass(state: Specification.ChartState): Charts.ChartClass;
        getClass(state: Specification.ObjectState): ObjectClass;
        createMarkClass(parent: Glyphs.GlyphClass, object: Specification.Element, state: Specification.MarkState): Marks.MarkClass;
        createGlyphClass(parent: PlotSegments.PlotSegmentClass, object: Specification.Glyph, state: Specification.GlyphState): Glyphs.GlyphClass;
        createPlotSegmentClass(parent: Charts.ChartClass, object: Specification.PlotSegment, state: Specification.PlotSegmentState): PlotSegments.PlotSegmentClass;
        createChartElementClass(parent: Charts.ChartClass, object: Specification.ChartElement, state: Specification.ChartElementState): ChartElementClass;
        createScaleClass(parent: Charts.ChartClass, object: Specification.Scale, state: Specification.ScaleState): Scales.ScaleClass;
        createChartClass(parent: ObjectClass, object: Specification.Chart, state: Specification.ChartState): Charts.ChartClass;
        createClass(parent: ObjectClass, object: Specification.Object, state: Specification.ObjectState): ObjectClass;
    }
}

declare module 'CharticulatorContainer/core/prototypes/common' {
    import { Point } from "CharticulatorContainer/core/common";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import * as Specification from "CharticulatorContainer/core/specification";
    import * as Controls from "CharticulatorContainer/core/prototypes/controls";
    export * from "CharticulatorContainer/core/prototypes/chart_element";
    export * from "CharticulatorContainer/core/prototypes/object";
    export { Controls };
    export interface OrderDescriptionItem extends Specification.AttributeMap {
        column: string;
        order: "ascending" | "descending";
    }
    export type OrderDescription = OrderDescriptionItem[];
    export interface DataMappingHints {
        rangeNumber?: [number, number];
        startWithZero?: "default" | "never" | "always";
        autoRange?: boolean;
        rangeEnum?: string[];
        rangeImage?: string[];
        newScale?: boolean;
        scaleID?: string;
        /** Enables value selector from mapping */
        allowSelectValue?: boolean;
    }
    export interface TemplateParameters {
        properties?: Specification.Template.Property[];
        inferences?: Specification.Template.Inference[];
    }
    export namespace DropZones {
        interface Description {
            type: string;
            /** If set, restrict the data that can be dropped */
            accept?: DropFilter;
            /** Action to perform after drop */
            dropAction: DropAction;
        }
        interface DropFilter {
            /** Only accept data from a certain table */
            table?: string;
            /** Only accept data with a certain kind */
            kind?: Specification.DataKind;
            /** Only accept certain scaffolds */
            scaffolds?: string[];
        }
        interface DropAction {
            /** Map data using inferred scale */
            scaleInference?: {
                attribute: string;
                attributeType: Specification.AttributeType;
                hints?: DataMappingHints;
            };
            /** Set AxisDataBinding to property */
            axisInference?: {
                property: string;
                /** If set, extend instead of replace the axis */
                appendToProperty?: string;
            };
            /** Extend a plot segment */
            extendPlotSegment?: Record<string, unknown>;
        }
        interface Line extends Description {
            type: "line";
            p1: Point;
            p2: Point;
            title: string;
        }
        interface Arc extends Description {
            type: "arc";
            center: Point;
            radius: number;
            angleStart: number;
            angleEnd: number;
            title: string;
        }
        interface Region extends Description {
            type: "region";
            p1: Point;
            p2: Point;
            title: string;
        }
        interface Rectangle extends Description {
            type: "rectangle";
            cx: number;
            cy: number;
            width: number;
            height: number;
            rotation: number;
            title: string;
        }
    }
    export namespace Handles {
        interface Description {
            type: string;
            visible?: boolean;
            actions: HandleAction[];
            options?: HandleOptions;
        }
        interface HandleOptions {
            snapToClosestPoint: boolean;
        }
        enum HandleActionType {
            Property = "property",
            Attribute = "attribute",
            AttributeValueMapping = "attribute-value-mapping"
        }
        interface HandleAction {
            type: "property" | "attribute" | "attribute-value-mapping";
            source?: string;
            property?: string;
            field?: string | string[];
            attribute?: string;
            minimum?: number;
            maximum?: number;
        }
        /** A point with x, y coordinates */
        interface Point extends Description {
            type: "point";
            x: number;
            y: number;
        }
        /** A line with a x or y coordiante, and a span on the other */
        interface Line extends Description {
            type: "line";
            axis: "x" | "y";
            value: number;
            span: [number, number];
        }
        interface RelativeLine extends Description {
            type: "relative-line";
            axis: "x" | "y";
            reference: number;
            value: number;
            sign: number;
            span: [number, number];
        }
        /** A x or y gap */
        interface GapRatio extends Description {
            type: "gap-ratio";
            axis: "x" | "y";
            reference: number;
            value: number;
            scale: number;
            span: [number, number];
            range: [number, number];
            coordinateSystem: Graphics.CoordinateSystem;
        }
        /** A x or y margin */
        interface Margin extends Description {
            type: "margin";
            axis: "x" | "y";
            value: number;
            total?: number;
            range?: [number, number];
            sign: number;
            x: number;
            y: number;
        }
        interface Angle extends Description {
            type: "angle";
            cx: number;
            cy: number;
            radius: number;
            value: number;
            clipAngles: [number, number];
            icon: ">" | "<" | "o";
        }
        interface DistanceRatio extends Description {
            type: "distance-ratio";
            cx: number;
            cy: number;
            startAngle: number;
            endAngle: number;
            value: number;
            startDistance: number;
            endDistance: number;
            clipRange: [number, number];
        }
        interface InputCurve extends Description {
            type: "input-curve";
            x1: number;
            y1: number;
            x2: number;
            y2: number;
        }
        interface TextAlignment extends Description {
            type: "text-alignment";
            text: string;
            alignment: Specification.Types.TextAlignment;
            rotation: number;
            anchorX: number;
            anchorY: number;
            textWidth: number;
            textHeight: number;
        }
    }
    export namespace BoundingBox {
        interface Description {
            type: string;
            visible?: boolean;
        }
        interface Rectangle extends Description {
            type: "rectangle";
            cx: number;
            cy: number;
            width: number;
            height: number;
        }
        interface AnchoredRectangle extends Description {
            type: "anchored-rectangle";
            cx: number;
            cy: number;
            width: number;
            height: number;
            rotation: number;
            anchorX: number;
            anchorY: number;
        }
        interface Circle extends Description {
            type: "circle";
            cx: number;
            cy: number;
            radius: number;
        }
        interface Line extends Description {
            type: "line";
            x1: number;
            y1: number;
            x2: number;
            y2: number;
            morphing?: boolean;
        }
    }
    export enum SnappingGuidesVisualTypes {
        Guide = 0,
        Coordinator = 1,
        Point = 2
    }
    export namespace SnappingGuides {
        interface Description {
            type: string;
            visible: boolean;
            visualType?: SnappingGuidesVisualTypes;
            priority?: number;
        }
        interface Axis extends Description {
            type: "x" | "y";
            value: number;
            attribute: string;
        }
        interface PolarAxis extends Description {
            type: "point";
            angle: number;
            radius: number;
            angleAttribute: string;
            radiusAttribute: string;
            cx: number;
            cy: number;
            visibleAngle: number;
            visibleRadius: number;
        }
        interface Label extends Description {
            type: "label";
            x: number;
            y: number;
            text: string;
        }
    }
    export namespace LinkAnchor {
        interface Description {
            element: string;
            points: {
                x: number;
                y: number;
                xAttribute: string;
                yAttribute: string;
                direction?: {
                    x: number;
                    y: number;
                };
            }[];
        }
    }
    export namespace CreatingInteraction {
        interface Description {
            type: string;
            mapping: {
                [name: string]: string;
            };
            valueMappings?: {
                [name: string]: Specification.AttributeValue;
            };
            attributes?: {
                [name: string]: Specification.AttributeValue;
            };
        }
        interface Point extends Description {
            type: "point";
        }
        interface Rectangle extends Description {
            type: "rectangle";
        }
        interface LineSegment extends Description {
            type: "line-segment";
        }
        interface HLine extends Description {
            type: "hline";
        }
        interface HLineSegment extends Description {
            type: "hline-segment";
        }
        interface VLine extends Description {
            type: "vline";
        }
        interface VLineSegment extends Description {
            type: "vline-segment";
        }
    }
    export namespace TemplateMetadata {
        interface ChartMetadata {
            dataSlots: DataSlot[];
            inference: {
                id: string;
                infer: Inference;
            }[];
            mappings: {
                id: string;
                attribute: string;
                slot: string;
            }[];
        }
        interface DataSlot {
            name: string;
            kind: "numerical" | "categorical";
        }
        interface Inference {
            type: string;
            defaultLabel: string;
        }
        /** Infer axis parameter, set to axis property */
        interface Axis extends Inference {
            type: "axis";
            property: string;
            field?: string[];
            dataExpression: string;
            kind: "numerical" | "categorical";
        }
        /** Infer scale parameter, set to scale's domain property */
        interface Scale extends Inference {
            type: "scale";
            kind: "numerical" | "categorical";
            target: "number" | "color";
            properties: {
                min?: string;
                max?: string;
                mapping?: string;
            };
        }
        /** Infer order parameter, set to orderBy */
        interface Order extends Inference {
            type: "order";
            property: string;
            field?: string[];
            dataExpression: string;
        }
    }
    export function findObjectById(spec: Specification.Chart, id: string): Specification.Object;
    export enum ObjectItemKind {
        Chart = "chart",
        ChartElement = "chart-element",
        Glyph = "glyph",
        Mark = "mark",
        Scale = "scale"
    }
    export interface ObjectItem {
        object: Specification.Object;
        kind: ObjectItemKind;
        chartElement?: Specification.ChartElement;
        glyph?: Specification.Glyph;
        mark?: Specification.Element;
        scale?: Specification.Scale;
    }
    export function forEachObject(chart: Specification.Chart): Iterable<ObjectItem>;
    export function forEachMapping(mappings: Specification.Mappings): Iterable<[string, Specification.Mapping]>;
    export function setProperty(object: Specification.Object, property: Specification.Template.PropertyField, value: any): void;
    export function getProperty(object: Specification.Object, property: Specification.Template.PropertyField): any;
    export type StrokeStyle = "solid" | "dashed" | "dotted" | "none";
    export function strokeStyleToDashArray(strokeStyle: StrokeStyle): "" | "8" | "1 10";
}

declare module 'CharticulatorContainer/core/prototypes/state' {
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Specification from "CharticulatorContainer/core/specification";
    import * as Charts from "CharticulatorContainer/core/prototypes/charts";
    import * as Glyphs from "CharticulatorContainer/core/prototypes/glyphs";
    import * as Prototypes from "CharticulatorContainer/core/prototypes/index";
    import * as Marks from "CharticulatorContainer/core/prototypes/marks";
    import * as PlotSegments from "CharticulatorContainer/core/prototypes/plot_segments";
    import * as Scales from "CharticulatorContainer/core/prototypes/scales";
    import { ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { DataflowManager, DataflowTable } from "CharticulatorContainer/core/prototypes/dataflow";
    import { ObjectClass } from "CharticulatorContainer/core/prototypes/object";
    import { ChartConstraintSolver } from "CharticulatorContainer/core/solver";
    import { ValueType } from "CharticulatorContainer/core/expression/classes";
    /**
        * Represents a set of default attributes
        */
    export interface DefaultAttributes {
            [objectId: string]: {
                    [attribute: string]: any;
            };
    }
    export type ClassEnumerationCallback = (cls: ObjectClass, state: Specification.ObjectState) => void;
    export const defaultDifferenceApproximation = 0.01;
    /** Handles the life cycle of states and the dataflow */
    export class ChartStateManager {
            chart: Specification.Chart;
            dataset: Dataset.Dataset;
            chartState: Specification.ChartState;
            dataflow: DataflowManager;
            classCache: Prototypes.ObjectClassCache;
            idIndex: Map<string, [Specification.Object<Specification.ObjectProperties>, Specification.ObjectState<Specification.AttributeMap>]>;
            options: {
                    [key: string]: any;
            };
            constructor(chart: Specification.Chart, dataset: Dataset.Dataset, state?: Specification.ChartState, defaultAttributes?: DefaultAttributes, options?: {
                    [key: string]: any;
            }, chartOrigin?: Specification.Chart);
            getOriginChart(): Specification.Chart<Specification.ObjectProperties>;
            updateState(chart: Specification.Chart, dataset: Dataset.Dataset, state: Specification.ChartState): void;
            resetDifference(): void;
            onUpdate(callback: (chart: Specification.Chart) => void): void;
            clearOnUpdateListener(callback: (chart: Specification.Chart) => void): void;
            hasUnsavedChanges(): boolean;
            /** Set an existing state */
            setState(state: Specification.ChartState): void;
            /** Set a new dataset, this will reset the state */
            setDataset(dataset: Dataset.Dataset): void;
            /** Get data table by name */
            getTable(name: string): DataflowTable;
            /** Get an object by its unique ID */
            getObjectById(id: string): Specification.Object;
            /** Get a chart-level element or scale by its id */
            getClassById(id: string): ObjectClass;
            /** Get classes for chart elements */
            getElements(): ObjectClass[];
            /** Initialize the object class cache */
            initializeCache(): void;
            /** Enumerate all object classes */
            enumerateClasses(callback: ClassEnumerationCallback): void;
            /** Enumerate classes, only return a specific type */
            enumerateClassesByType(type: string, callback: ClassEnumerationCallback): void;
            enumeratePlotSegments(callback: (cls: PlotSegments.PlotSegmentClass) => void): void;
            /** Initialize the chart state with default parameters */
            initializeState(defaultAttributes?: DefaultAttributes): void;
            /** Test if a name is already used */
            isNameUsed(candidate: string): boolean;
            /** Find an unused name given a prefix, will try prefix1, prefix2, and so on. */
            findUnusedName(prefix: string): string;
            /** Create a new object */
            createObject(classID: string, ...args: any[]): Specification.Object;
            /** Add a new glyph */
            addGlyph(classID: string, table: string): Specification.Glyph;
            /** Remove a glyph */
            removeGlyph(glyph: Specification.Glyph): void;
            /** Add a new element to a glyph */
            addMarkToGlyph(mark: Specification.Element, glyph: Specification.Glyph): void;
            /** Remove an element from a glyph */
            removeMarkFromGlyph(mark: Specification.Element, glyph: Specification.Glyph): void;
            /** Add a chart element */
            addChartElement(element: Specification.ChartElement, index?: number): void;
            reorderArray<T>(array: T[], fromIndex: number, toIndex: number): void;
            reorderChartElement(fromIndex: number, toIndex: number): void;
            reorderGlyphElement(glyph: Specification.Glyph, fromIndex: number, toIndex: number): void;
            /** Remove a chart element */
            removeChartElement(element: Specification.ChartElement): void;
            remapPlotSegmentGlyphs(plotSegment: Specification.PlotSegment): void;
            /** Add a new scale */
            addScale(scale: Specification.Scale): void;
            /** Remove a scale */
            removeScale(scale: Specification.Scale): void;
            getMarkClass(state: Specification.MarkState): Marks.MarkClass;
            getGlyphClass(state: Specification.GlyphState): Glyphs.GlyphClass;
            getChartElementClass(state: Specification.ChartElementState): ChartElementClass;
            getPlotSegmentClass(state: Specification.PlotSegmentState): PlotSegments.PlotSegmentClass;
            getScaleClass(state: Specification.ScaleState): Scales.ScaleClass;
            getChartClass(state: Specification.ChartState): Charts.ChartClass;
            getClass(state: Specification.ObjectState): ObjectClass;
            findGlyphState(plotSegment: Specification.PlotSegment, glyph: Specification.Glyph, glyphIndex?: number): Specification.GlyphState;
            findMarkState(plotSegment: Specification.PlotSegment, glyph: Specification.Glyph, mark: Specification.Element, glyphIndex?: number): Specification.MarkState;
            /** Remove constraints that relate to non-existant element */
            validateConstraints(constraints: Specification.Constraint[], elements: Specification.Object[]): Specification.Constraint[];
            resolveResource(description: string): any;
            /** Get chart-level data context for a given table */
            getChartDataContext(tableName: string): Expression.Context;
            /** Get glyph-level data context for the glyphIndex-th glyph */
            getGlpyhDataContext(plotSegment: Specification.PlotSegment, glyphIndex: number): Expression.Context;
            /** Get all glyph-level data contexts for a given plot segment */
            getGlpyhDataContexts(plotSegment: Specification.PlotSegment, glyphIndex: number): Expression.Context[];
            getGroupedExpressionVector(tableName: string, groupBy: Specification.Types.GroupBy, expression: string): ValueType[];
            solveConstraints(additional?: (solver: ChartConstraintSolver) => void, mappingOnly?: boolean): void;
    }
}

declare module 'CharticulatorContainer/core/common/math' {
    /** 2D point */
    export interface Point {
        x: number;
        y: number;
    }
    /** 2D vector */
    export type Vector = Point;
    /** 2D line with two points */
    export interface Line {
        p1: Point;
        p2: Point;
    }
    /** Rectangle */
    export interface Rect {
        x1: number;
        y1: number;
        x2: number;
        y2: number;
    }
    /** Zooming information */
    export interface ZoomInfo {
        /** The pixel location of the origin of the canvas, unit: px */
        centerX: number;
        centerY: number;
        /** The scale factor between pixel and canvas unit, unit: px / canvas unit */
        scale: number;
    }
    /** General geometry functions */
    export namespace Geometry {
        /** Return the length of a vector */
        function vectorLength(p: Vector): number;
        /** Return the distance between two points */
        function pointDistance(p1: Point, p2: Point): number;
        /** Return the normalized version of a vector */
        function vectorNormalize(p: Vector): Vector;
        /** Rotate a vector 90 degrees (counter-clock-wise, but clock-wise in screen coordiantes) */
        function vectorRotate90(p: Vector): Vector;
        /** Rotate a vector by a angle in radians (counter-clock-wise, but clock-wise in screen coordiantes) */
        function vectorRotate(p: Vector, radians: number): Vector;
        /** Add two vectors */
        function vectorAdd(p1: Vector, p2: Vector): Vector;
        /** Subtract two vectors */
        function vectorSub(p1: Vector, p2: Vector): Vector;
        /** Multiply two vectors element-wise */
        function vectorMul(p1: Vector, p2: Vector): Vector;
        /** Divide two vectors element-wise */
        function vectorDiv(p1: Vector, p2: Vector): Vector;
        /** Scale a vector by a constant factor */
        function vectorScale(p: Point, s: number): {
            x: number;
            y: number;
        };
        /** Compute the inner product between two vectors */
        function vectorDot(p1: Vector, p2: Vector): number;
        /** Compute the cross product between two vectors */
        function vectorCross(p1: Vector, p2: Vector): number;
        /** Determine if two intervals overlap */
        function intervalOverlap(xMin: number, xMax: number, yMin: number, yMax: number): boolean;
        /** Determine if two rects overlap */
        function rectOverlap(a1: Rect, a2: Rect): boolean;
        /** Apply zoom to a point (point to pixel) */
        function applyZoom(zoom: ZoomInfo, pt: Point): Point;
        /** Unapply zoom to a point (pixel to point) */
        function unapplyZoom(zoom: ZoomInfo, pt: Point): Point;
        function degreesToRadians(degrees: number): number;
    }
    export function prettyNumber(x: number, digits?: number): string;
    export function getRandomNumber(): number;
}

declare module 'CharticulatorContainer/core/common/unique_id' {
    export function uuid(): string;
    /** Generate a unique ID in uuid format */
    export function uniqueID(): string;
    export function objectHash(o: Record<string, never>): string;
}

declare module 'CharticulatorContainer/core/common/scales' {
    import { OrderMode } from "CharticulatorContainer/core/specification/types";
    export namespace Scale {
        /** Base scale class */
        abstract class BaseScale<InputType, OutputType> {
            /** Infer scale parameters given a list of values */
            abstract inferParameters(values: InputType[]): void;
            /** Get mapped value */
            abstract get(value: InputType): OutputType;
            /** Get mapped values */
            map(values: InputType[]): OutputType[];
        }
        class LinearScale extends BaseScale<number, number> {
            domainMin: number;
            domainMax: number;
            inferParameters(values: number[]): void;
            adjustDomain(options: {
                startWithZero?: "default" | "always" | "never";
            }): void;
            get(v: number): number;
            ticks(n?: number): number[];
            tickFormat(n?: number, specifier?: string): (d: number | {
                valueOf(): number;
            }) => string;
        }
        class LogarithmicScale extends BaseScale<number, number> {
            domainMin: number;
            domainMax: number;
            inferParameters(values: number[]): void;
            get(v: number): number;
            ticks(n?: number): number[];
            tickFormat(n?: number, specifier?: string): (d: number | {
                valueOf(): number;
            }) => string;
        }
        class DateScale extends LinearScale {
            inferParameters(values: number[], nice?: boolean): void;
            ticks(n?: number): number[];
            tickFormat(_n?: number, specifier?: string): (t: number) => string;
        }
        class CategoricalScale extends BaseScale<string, number> {
            domain: Map<string, number>;
            length: number;
            inferParameters(values: string[], order?: OrderMode): void;
            get(v: string): number;
        }
    }
}

declare module 'CharticulatorContainer/core/common/events' {
    export class EventSubscription {
        emitter: EventEmitter;
        event: string;
        listener: Function;
        next: EventSubscription;
        prev: EventSubscription;
        constructor(emitter: EventEmitter, event: string, listener: Function);
        remove(): void;
    }
    export class EventEmitter {
        addListener(event: string, listener: Function): EventSubscription;
        emit(event: string, ...parameters: any[]): void;
        removeSubscription(subscription: EventSubscription): void;
    }
    export class Dispatcher<ActionType> {
        static PRIORITY_LOW: number;
        static PRIORITY_DEFAULT: number;
        static PRIORITY_HIGH: number;
        dispatch(action: ActionType): void;
        register(callback: (action: ActionType) => void, priority?: number): string;
        unregister(id: string): void;
        waitFor(ids: string[]): void;
    }
}

declare module 'CharticulatorContainer/core/common/constants' {
    export enum MessageType {
        GeneralError = 0,
        ParsingDataError = 1,
        ConstraintSolvingError = 2,
        LinkGuideCreatingError = 3,
        InvalidLinksData = 4,
        NoID = 5,
        NoSourceOrTargetID = 6
    }
    export const messageTypes: (string | MessageType)[];
    export const LinkSourceKeyColumn = "source_id";
    export const LinkTargetKeyColumn = "target_id";
    export const isReservedColumnName: (name: string) => boolean;
    export const KeyColumn = "id";
    export const ImageKeyColumn = "imageId";
    export const defaultDelimiter = ",";
    export const defaultNumberFormat: Readonly<{
        remove: string;
        decimal: string;
    }>;
    export const defaultCurrency: [string, string];
    export const defaultCurrencySymbol: string;
    export const defaultDigitsGroup: number[];
    export const primaryButtonStyles: {
        root: {
            backgroundColor: string;
            color: string;
            borderRadius: number;
            borderColor: string;
            height: number;
        };
        rootHovered: {
            backgroundColor: string;
            color: string;
        };
        rootChecked: {
            backgroundColor: string;
            color: string;
        };
        rootPressed: {
            backgroundColor: string;
            color: string;
        };
    };
    export const fontList: string[];
}

declare module 'CharticulatorContainer/core/common/fetch' {
    export function loadDataFromURL(url: string, contentType: "text", timeout?: number): Promise<string>;
    export function loadDataFromURL(url: string, contentType: "json", timeout?: number): Promise<Record<string, unknown>>;
    export function loadDataFromURL(url: string, contentType: "arraybuffer", timeout?: number): Promise<ArrayBuffer>;
    export function loadDataFromURL(url: string, contentType: "blob", timeout?: number): Promise<Blob>;
}

declare module 'CharticulatorContainer/core/dataset/dataset' {
    import { DataValue, DataType, DataKind } from "CharticulatorContainer/core/specification";
    import { OrderMode } from "CharticulatorContainer/core/specification/types";
    import { LocaleNumberFormat } from "CharticulatorContainer/core/dataset/data_types";
    export { DataValue, DataType, DataKind };
    export interface Dataset {
        /** Name of the dataset */
        name: string;
        /** Tables in the dataset */
        tables: Table[];
    }
    export interface ColumnMetadata {
        /** Abstract data kind */
        kind?: DataKind;
        /** The unit of the data type, used in scale inference when mapping multiple columns */
        unit?: string;
        /** Order of categories for categorical type */
        order?: string[];
        orderMode?: OrderMode;
        /** Formatting for other data types */
        format?: string;
        rawColumnName?: string;
        isRaw?: boolean;
        examples?: string;
        /** Order by another column*/
        orderByExpression?: string;
        columnName?: string;
    }
    export interface Column {
        /** Name, used to address the entry from row */
        name: string;
        /** Name, used to display row name */
        displayName: string;
        /** Data type in memory (number, string, Date, boolean, etc) */
        type: DataType;
        /** Metadata */
        metadata: ColumnMetadata;
    }
    export interface Row {
        /** Internal row ID, automatically assigned to be unique */
        _id: string;
        /** Row attributes */
        [name: string]: DataValue;
    }
    export interface Table {
        /** Table name */
        name: string;
        /** The name to be shown to the user */
        displayName: string;
        /** Columns in the table */
        columns: Column[];
        /** Rows in the table */
        rows: Row[];
        /** Type of the table */
        type: TableType;
        /** Optional locale format of the table */
        localeNumberFormat?: LocaleNumberFormat;
    }
    export enum TableType {
        /** The main table with data for the chart */
        Main = "Main",
        /** Table with source_id and target_id columns for links, can contain additional columns with data */
        Links = "Links",
        /** TelLs to nested chart that table is parent chart table with all data */
        ParentMain = "ParentMain",
        /** TelLs to nested chart that table is parent links table of the chart with all data */
        ParentLinks = "ParentLinks",
        /** The main table with data for images */
        Image = "Image"
    }
    export const tableTypeName: {
        [key in TableType]: string;
    };
    export const rawColumnPostFix = "_raw";
}

declare module 'CharticulatorContainer/core/dataset/loader' {
    import { Table, Dataset } from "CharticulatorContainer/core/dataset/dataset";
    import { LocaleFileFormat } from "CharticulatorContainer/core/dataset/dsv_parser";
    export interface TableSourceSpecification {
        /** Name of the table, if empty, use the basename of the url without extension */
        name?: string;
        /** Locale-based delimiter and number format */
        localeFileFormat: LocaleFileFormat;
        /** Option 1: Specify the url to load the table from */
        url?: string;
        /** Option 2: Specify the table content, in this case format and name must be specified */
        content?: string;
    }
    export interface DatasetSourceSpecification {
        name?: string;
        tables: TableSourceSpecification[];
    }
    export class DatasetLoader {
        loadTextData(url: string): Promise<string>;
        loadDSVFromURL(url: string, localeFileFormat: LocaleFileFormat): Promise<Table>;
        loadDSVFromContents(filename: string, contents: string, localeFileFormat: LocaleFileFormat): Table;
        loadTableFromSourceSpecification(spec: TableSourceSpecification): Promise<Table>;
        loadDatasetFromSourceSpecification(spec: DatasetSourceSpecification): Promise<Dataset>;
    }
}

declare module 'CharticulatorContainer/core/dataset/context' {
    /**
      * Context provideres for expressions ({@link "core/expression/index"})
      *
      * @packageDocumentation
      * @preferred
      */
    import { Context } from "CharticulatorContainer/core/expression";
    import { Dataset, Row, Table } from "CharticulatorContainer/core/dataset/dataset";
    export class DatasetContext implements Context {
        dataset: Dataset;
        fields: {
            [name: string]: Row[];
        };
        constructor(dataset: Dataset);
        getTableContext(table: Table): TableContext;
        getVariable(name: string): Row[];
    }
    export class TableContext {
        parent: DatasetContext;
        table: Table;
        fields: {
            [name: string]: Row[];
        };
        constructor(parent: DatasetContext, table: Table);
        getRowContext(row: Row): RowContext;
        getVariable(name: string): Row[];
    }
    export class RowContext {
        parent: TableContext;
        row: Row;
        constructor(parent: TableContext, row: Row);
        getVariable(name: string): string | number | boolean | Row[];
    }
}

declare module 'CharticulatorContainer/core/dataset/data_types' {
    import { DataValue, DataType, ColumnMetadata } from "CharticulatorContainer/core/dataset/dataset";
    import { LocaleFileFormat } from "CharticulatorContainer/core/dataset/dsv_parser";
    export interface LocaleNumberFormat {
        remove: string;
        decimal: string;
    }
    export interface DataTypeDescription {
        test: (v: string, localeNumberFormat?: LocaleNumberFormat) => boolean;
        convert: (v: string, localeNumberFormat?: LocaleNumberFormat | number) => DataValue;
    }
    export const dataTypes: {
        [name in DataType]: DataTypeDescription;
    };
    /** Infer column type from a set of strings (not null) */
    export function inferColumnType(values: string[], localeNumberFormat: LocaleNumberFormat): DataType;
    /** Convert strings to value type, null & non-convertibles are set as null */
    export function convertColumn(type: DataType, values: string[], localeNumberFormat?: LocaleNumberFormat, timeZone?: number): DataValue[];
    /** Get distinct values from a non-null array of basic types */
    export function getDistinctValues(values: DataValue[]): DataValue[];
    /** Infer column metadata and update type if necessary */
    export function inferAndConvertColumn(values: string[], localeFileFormat: LocaleFileFormat, hints?: {
        [name: string]: string;
    }): {
        values: DataValue[];
        rawValues?: string[] | DataValue[];
        type: DataType;
        metadata: ColumnMetadata;
    };
    export function convertColumnType(values: any[], type: DataType): DataValue[];
    export function isBase64Image(string: string): boolean;
}

declare module 'CharticulatorContainer/core/expression/classes' {
    export type ValueType = number | boolean | string | Date | Object;
    export interface Context {
        getVariable(name: string): ValueType;
    }
    export class ShadowContext implements Context {
        upstream: Context;
        shadows: {
            [name: string]: ValueType;
        };
        constructor(upstream?: Context, shadows?: {
            [name: string]: ValueType;
        });
        getVariable(name: string): ValueType;
    }
    export class SimpleContext implements Context {
        variables: {
            [name: string]: ValueType;
        };
        getVariable(name: string): ValueType;
    }
    export type PatternReplacer = (expr: Expression) => Expression | void;
    export function variableReplacer(map: {
        [name: string]: string;
    }): (expr: Expression) => Variable;
    export abstract class Expression {
        abstract getValue(context: Context): ValueType;
        abstract toString(): string;
        protected abstract getPrecedence(): number;
        protected abstract replaceChildren(r: PatternReplacer): Expression;
        toStringPrecedence(parent: number): string;
        getNumberValue(c: Context): number;
        getStringValue(c: Context): string;
        static Parse(expr: string): Expression;
        replace(replacer: PatternReplacer): Expression;
    }
    export interface TextExpressionPart {
        string?: string;
        expression?: Expression;
        format?: string;
    }
    /** Text expression is a special class, it cannot be used inside other expression */
    export class TextExpression {
        parts: TextExpressionPart[];
        constructor(parts?: TextExpressionPart[]);
        getValue(context: Context): string;
        isTrivialString(): boolean;
        toString(): string;
        static Parse(expr: string): TextExpression;
        replace(r: PatternReplacer): TextExpression;
    }
    export class Value<T> extends Expression {
        value: T;
        constructor(value: T);
        getValue(): T;
        toString(): string;
        protected getPrecedence(): number;
        protected replaceChildren(r: PatternReplacer): Expression;
    }
    export class StringValue extends Value<string> {
    }
    export class NumberValue extends Value<number> {
    }
    export class BooleanValue extends Value<boolean> {
    }
    export class DateValue extends Value<Date> {
    }
    export class FieldAccess extends Expression {
        expr: Expression;
        fields: string[];
        constructor(expr: Expression, fields: string[]);
        getValue(c: Context): any;
        toString(): string;
        protected getPrecedence(): number;
        protected replaceChildren(r: PatternReplacer): Expression;
    }
    export class FunctionCall extends Expression {
        name: string;
        function: Function;
        args: Expression[];
        constructor(parts: string[], args: Expression[]);
        getValue(c: Context): any;
        toString(): string;
        protected getPrecedence(): number;
        protected replaceChildren(r: PatternReplacer): Expression;
    }
    export class Operator extends Expression {
        name: string;
        lhs: Expression;
        rhs?: Expression;
        constructor(name: string, lhs: Expression, rhs?: Expression);
        getValue(c: Context): any;
        toString(): string;
        protected getMyPrecedence(): number[];
        protected getPrecedence(): number;
        protected replaceChildren(r: PatternReplacer): Expression;
    }
    export class LambdaFunction extends Expression {
        readonly expr: Expression;
        readonly argNames: string[];
        constructor(expr: Expression, argNames: string[]);
        getValue(c: Context): (...args: ValueType[]) => ValueType;
        toString(): string;
        protected getPrecedence(): number;
        protected replaceChildren(r: PatternReplacer): Expression;
    }
    export class Variable extends Expression {
        readonly name: string;
        constructor(name: string);
        getValue(c: Context): ValueType;
        toString(): string;
        protected getPrecedence(): number;
        static isNonEnglishVariableName(name: string): boolean;
        static VariableNameToString(name: string): string;
        protected replaceChildren(r: PatternReplacer): Expression;
    }
}

declare module 'CharticulatorContainer/core/expression/helpers' {
    import { BooleanValue, DateValue, Expression, FieldAccess, FunctionCall, LambdaFunction, NumberValue, Operator, StringValue, Variable, TextExpression, Context } from "CharticulatorContainer/core/expression/classes";
    import { DataflowTable } from "CharticulatorContainer/core/prototypes/dataflow";
    import { DataKind, DataType } from "CharticulatorContainer/core/specification";
    export function variable(name: string): Variable;
    export function functionCall(functionName: string, ...args: Expression[]): FunctionCall;
    export function lambda(names: string[], expression: Expression): LambdaFunction;
    export function fields(expr: Expression, ...fields: string[]): FieldAccess;
    export function add(lhs: Expression, rhs: Expression): Operator;
    export function sub(lhs: Expression, rhs: Expression): Operator;
    export function mul(lhs: Expression, rhs: Expression): Operator;
    export function div(lhs: Expression, rhs: Expression): Operator;
    export function number(v: number): NumberValue;
    export function string(v: string): StringValue;
    export function boolean(v: boolean): BooleanValue;
    export function date(v: Date): DateValue;
    export interface AggregationFunctionDescription {
            name: string;
            displayName: string;
            /** Supported input types, if unspecified, any */
            inputTypes?: DataType[];
            inputKind?: DataKind[];
    }
    export const aggregationFunctions: AggregationFunctionDescription[];
    export function getCompatibleAggregationFunctionsByDataType(inputType: DataType): AggregationFunctionDescription[];
    export function getCompatibleAggregationFunctionsByDataKind(inputKind: DataKind): AggregationFunctionDescription[];
    export function getDefaultAggregationFunction(inputType: DataType, kind: DataKind): "first" | "avg";
    export class ExpressionCache {
            clear(): void;
            parse(expr: string): Expression;
            parseTextExpression(expr: string): TextExpression;
    }
    export interface VerifyUserExpressionOptions {
            /** Specify this to verify expression against data */
            data?: Iterable<Context>;
            /** Specify this to verify expression against table */
            table?: DataflowTable;
            /** Specify this to verify return types */
            expectedTypes?: string[];
            textExpression?: boolean;
    }
    export interface VerifyUserExpressionReport {
            /** Verification is passed */
            pass: boolean;
            /** Re-formatted expression if passed */
            formatted?: string;
            /** Error message if not passed */
            error?: string;
    }
    /**
        * Verify user input expression
        * @param inputString The expression from user input
        * @param options Verification options
        */
    export function verifyUserExpression(inputString: string, options: VerifyUserExpressionOptions): VerifyUserExpressionReport;
}

declare module 'CharticulatorContainer/core/solver/abstract' {
    import { AttributeMap } from "CharticulatorContainer/core/specification";
    export enum ConstraintStrength {
            HARD = 1,
            STRONG = 2,
            MEDIUM = 3,
            WEAK = 4,
            WEAKER = 5
    }
    export interface AttributeOptions {
            /** Attribute is editable, default: true */
            edit: boolean;
    }
    export interface Variable {
    }
    export abstract class ConstraintPlugin {
            abstract apply(): boolean;
    }
    export abstract class ConstraintSolver {
            /** Make an attribute constant */
            abstract makeConstant(map: AttributeMap, name: string): void;
            /** Get the variable of an attribute */
            abstract attr(map: AttributeMap, name: string, options?: AttributeOptions): Variable;
            /** Get the value of a variable */
            abstract getValue(attr: Variable): number;
            /** Set the value of a variable */
            abstract setValue(attr: Variable, value: number): void;
            /**
                * Add a linear constraint: bias + linear(lhs) == linear(rhs)
                */
            abstract addLinear(strength: ConstraintStrength, bias: number, lhs: [number, Variable][], rhs?: [number, Variable][]): void;
            /**
                * Add a soft inequality constraint: bias + linear(lhs) >= linear(rhs)
                */
            abstract addSoftInequality(strength: ConstraintStrength, bias: number, lhs: [number, Variable][], rhs?: [number, Variable][]): void;
            /** Solve the constraints */
            abstract solve(): [number, number];
            abstract destroy(): void;
            /** Get attributes */
            attrs(map: AttributeMap, name: string[]): Variable[];
            /** Get a linear value */
            getLinear(...items: [number, Variable][]): number;
            /** Add a constraint that enfoces a = b */
            addEquals(strength: ConstraintStrength, a: Variable, b: Variable): void;
            /** Add a constraint that enfoces a = value */
            addEqualToConstant(strength: ConstraintStrength, a: Variable, value: number): void;
            plugins: ConstraintPlugin[];
            addPlugin(plugin: ConstraintPlugin): void;
            applyPlugins(): void;
    }
}

declare module 'CharticulatorContainer/core/solver/solver' {
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Prototypes from "CharticulatorContainer/core/prototypes";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ConstraintSolver, ConstraintStrength, Variable } from "CharticulatorContainer/core/solver/abstract";
    import { WASMSolver } from "CharticulatorContainer/core/solver/wasm_solver";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    /** Solves constraints in the scope of a chart */
    export class ChartConstraintSolver {
            solver: WASMSolver;
            stage: "chart" | "glyphs";
            chart: Specification.Chart;
            chartState: Specification.ChartState;
            manager: Prototypes.ChartStateManager;
            dataset: Dataset.Dataset;
            datasetContext: Dataset.DatasetContext;
            expressionCache: Expression.ExpressionCache;
            /**
                * Create a ChartConstraintSolver
                * - stage == "chart": disregard glyphs, solve chart-level constraints
                * - stage == "glyphs": fix chart-level attributes, solve only glyphs
                * @param stage determines the scope of the variables to solve
                */
            constructor(stage: "chart" | "glyphs");
            setManager(manager: Prototypes.ChartStateManager): void;
            setDataset(dataset: Dataset.Dataset): void;
            solve(): {
                    softLoss: number;
                    hardLoss: number;
            };
            destroy(): void;
            addMapping(attrs: Specification.AttributeMap, parentAttrs: Specification.AttributeMap, attr: string, info: Prototypes.AttributeDescription, mapping: Specification.Mapping, rowContext: Expression.Context, rowIndex?: number[]): void;
            addObject(object: Specification.Object, objectState: Specification.ObjectState, parentState: Specification.ObjectState, rowContext: Expression.Context, solve: boolean, rowIndex?: number[]): void;
            addScales(allowScaleParameterChange?: boolean): void;
            getSupportVariable(key: Record<string, unknown>, name: string, defaultValue: number): Variable;
            addMark(layout: Specification.PlotSegment, mark: Specification.Glyph, rowContext: Expression.Context, markState: Specification.GlyphState, element: Specification.Element, elementState: Specification.MarkState, rowIndex: number[]): void;
            getAttachedAttributes(mark: Specification.Glyph): Set<string>;
            getGlyphAnalyzeResult(glyph: Specification.Glyph): GlyphConstraintAnalyzer;
            addGlyph(layout: Specification.PlotSegment, rowContext: Expression.Context, glyph: Specification.Glyph, glyphState: Specification.GlyphState, rowIndex: number[]): void;
            addAttribute(attrs: Specification.AttributeMap, attr: string, edit: boolean): void;
            addChart(): void;
            setup(manager: Prototypes.ChartStateManager): void;
    }
    /**
        * Closed-form solution for single marks
        *
        * Closed-form solution is: MarkAttributes = F(DataValues, ScaleAttributes, FreeVariables)
        */
    export interface GlyphConstraintAnalyzerAttribute {
            index: number;
            type: "object" | "input";
            id: string;
            attribute: string;
    }
    export class GlyphConstraintAnalyzer extends ConstraintSolver {
            glyphState: Specification.GlyphState;
            manager: ChartStateManager;
            addAttribute(attrs: Specification.AttributeMap, attr: string, id: string): GlyphConstraintAnalyzerAttribute;
            attr(attrs: Specification.AttributeMap, attr: string): GlyphConstraintAnalyzerAttribute;
            addLinear(strength: ConstraintStrength, bias: number, lhs: [number, {
                    index: number;
            }][], rhs?: [number, {
                    index: number;
            }][]): void;
            addSoftInequality(strength: ConstraintStrength, bias: number, lhs: [number, {
                    index: number;
            }][], rhs?: [number, {
                    index: number;
            }][]): void;
            addInputAttribute(name: string, attr: {
                    index: number;
            }): void;
            addDataInput(name: string, expression: string): void;
            addMapping(attrs: Specification.AttributeMap, attr: string, mapping: Specification.Mapping, parentAttrs: Specification.AttributeMap): void;
            constructor(glyph: Specification.Glyph, manager: ChartStateManager);
            setValue(): void;
            getValue(): number;
            makeConstant(attr: {
                    index: number;
            }): void;
            destroy(): void;
            solve(): [number, number];
            isAttributeFree(attr: GlyphConstraintAnalyzerAttribute): boolean;
            get widthFree(): boolean;
            get heightFree(): boolean;
            computeAttribute(attr: GlyphConstraintAnalyzerAttribute, rowContext: Expression.Context): number;
            computeAttributes(rowContext: Expression.Context): {
                    [name: string]: number;
            };
    }
}

declare module 'CharticulatorContainer/core/solver/plugins' {
    export { PackingPlugin } from "CharticulatorContainer/core/solver/plugins/packing";
    export { PolarCoordinatorPlugin } from "CharticulatorContainer/core/solver/plugins/polar_coordinator";
    export { PolarPlotSegmentPlugin } from "CharticulatorContainer/core/solver/plugins/polar_plotsegment";
    export { JitterPlugin } from "CharticulatorContainer/core/solver/plugins/jitter";
}

declare module 'CharticulatorContainer/core/specification/template' {
    import { FieldType } from "CharticulatorContainer/core/common";
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import { TableType } from "CharticulatorContainer/core/dataset";
    import { DefaultAttributes } from "CharticulatorContainer/core/prototypes";
    import { Chart, DataType, AttributeType } from "CharticulatorContainer/core/specification/index";
    import * as Types from "CharticulatorContainer/core/specification/types";
    import { AxisRenderingStyle } from "CharticulatorContainer/core/specification/types";
    export type PropertyField = string | {
            property: string;
            field: FieldType;
            subfield?: FieldType;
    };
    export interface ChartTemplate {
            /** The original chart specification */
            specification: Chart;
            /** A set of default attributes to apply to the objects in the chart */
            defaultAttributes: DefaultAttributes;
            /** Data tables */
            tables: Table[];
            /** Infer attribute or property from data */
            inference: Inference[];
            /** Expose property editor */
            properties: Property[];
            /**Template version */
            version: string;
    }
    export interface Column {
            displayName: string;
            name: string;
            type: DataType;
            metadata: Dataset.ColumnMetadata;
    }
    export interface Table {
            name: string;
            columns: Column[];
            type?: TableType;
    }
    export interface Property {
            objectID: string;
            displayName?: string;
            target: {
                    property?: PropertyField;
                    attribute?: string;
            };
            type: AttributeType;
            default?: string | number | boolean | Record<string, unknown>;
    }
    /** Infer values from data */
    export interface Inference {
            objectID: string;
            dataSource?: {
                    table: string;
                    groupBy?: Types.GroupBy;
            };
            description?: string;
            /** Disable any automatic domain/range/axis behavior */
            disableAuto?: boolean;
            /** Disable any automatic domain/range/axis behavior for min of range */
            autoDomainMin?: boolean;
            /** Disable any automatic domain/range/axis behavior for max of range */
            autoDomainMax?: boolean;
            /**
                * @deprecated Use autoDomainMin
                */
            disableAutoMin?: boolean;
            /**
                * @deprecated Use autoDomainMax
                */
            disableAutoMax?: boolean;
            axis?: AxisInference;
            scale?: ScaleInference;
            expression?: ExpressionInference;
            nestedChart?: NestedChartInference;
    }
    /** Infer axis parameter, set to axis property */
    export interface AxisInference {
            /** Data expression for the axis */
            expression: string;
            additionalExpressions?: string[];
            /** Type */
            type: "default" | "categorical" | "numerical";
            style?: AxisRenderingStyle;
            /** Infer axis data and assign to this property */
            property: PropertyField;
            orderMode?: Types.OrderMode;
            order?: string[];
            rawExpression?: string;
            defineCategories?: boolean;
    }
    /** Infer scale parameter, set to scale's domain property */
    export interface ScaleInference {
            classID: string;
            expressions: string[];
            properties: {
                    min?: PropertyField;
                    max?: PropertyField;
                    mapping?: PropertyField;
            };
    }
    /** Fix expression */
    export interface ExpressionInference {
            expression: string;
            property: PropertyField;
    }
    /** Nested chart */
    export interface NestedChartInference {
            columnNameMap: {
                    [name: string]: string;
            };
    }
}

declare module 'CharticulatorContainer/core/specification/types' {
    import { Color } from "CharticulatorContainer/core/common";
    import { DataKind } from "CharticulatorContainer/core/dataset";
    import { StrokeStyle } from "CharticulatorContainer/core/prototypes";
    import { AttributeMap, Expression, DataType } from "CharticulatorContainer/core/specification/index";
    export enum OrderMode {
        alphabetically = "alphabetically",
        occurrence = "occurrence",
        order = "order"
    }
    export type AxisSide = "default" | "opposite";
    export enum AxisDataBindingType {
        Default = "default",
        Numerical = "numerical",
        Categorical = "categorical"
    }
    export enum NumericalMode {
        Linear = "linear",
        Logarithmic = "logarithmic",
        Temporal = "temporal"
    }
    export enum TickFormatType {
        None = "none",
        Date = "date",
        Number = "number"
    }
    /** Common parameter and mapping types */
    export interface AxisDataBinding extends AttributeMap {
        type: AxisDataBindingType;
        visible: boolean;
        side: AxisSide;
        /** Data mapping expression */
        expression?: Expression;
        rawExpression?: Expression;
        valueType?: DataType;
        /** Domain for linear/logarithm types */
        numericalMode?: NumericalMode;
        domainMin?: number;
        domainMax?: number;
        dataDomainMin?: number;
        dataDomainMax?: number;
        /** Export properties of axis for auto scale ranges */
        autoDomainMin?: boolean;
        autoDomainMax?: boolean;
        /** Categories for categorical type */
        categories?: string[];
        gapRatio?: number;
        /** Pre/post gap, will override the default with OR operation */
        enablePrePostGap?: boolean;
        tickDataExpression?: Expression;
        tickFormat?: string;
        tickFormatType?: TickFormatType;
        style?: AxisRenderingStyle;
        dataKind?: DataKind;
        order?: string[];
        orderMode?: OrderMode;
        /** scrolling options */
        allowScrolling?: boolean;
        allCategories?: string[];
        scrollPosition?: number;
        windowSize?: number;
        barOffset?: number;
        /** Offset options */
        offset?: number;
        /** render axis on top */
        onTop?: boolean;
        /** Order by another column */
        orderByExpression?: string;
        orderByCategories?: string[];
        enableSelection?: boolean;
        numberOfTicks?: number;
        autoNumberOfTicks?: boolean;
    }
    export interface AxisRenderingStyle extends AttributeMap {
        lineColor: Color;
        tickColor: Color;
        fontFamily: string;
        fontSize: number;
        tickSize: number;
        tickTextBackgroudColor: Color;
        tickTextBackgroudColorId: string;
        wordWrap: boolean;
        gridlineStyle: StrokeStyle;
        gridlineColor: Color;
        gridlineWidth: number;
        verticalText: boolean;
        showTicks: boolean;
        showBaseline: boolean;
    }
    export enum TextAlignmentHorizontal {
        Left = "left",
        Middle = "middle",
        Right = "right"
    }
    export enum TextAlignmentVertical {
        Top = "top",
        Middle = "middle",
        Bottom = "bottom"
    }
    export interface TextAlignment extends AttributeMap {
        x: TextAlignmentHorizontal;
        y: TextAlignmentVertical;
        xMargin: number;
        yMargin: number;
    }
    export enum Colorspace {
        Hcl = "hcl",
        Lab = "lab"
    }
    export interface ColorGradient extends AttributeMap {
        colorspace: Colorspace;
        colors: Color[];
    }
    export interface Image extends AttributeMap {
        src: string;
        width: number;
        height: number;
        name?: string;
    }
    /** LinkAnchor: specifies an anchor in a link */
    export interface LinkAnchorPoint extends AttributeMap {
        /** X attribute reference */
        x: {
            element: string;
            attribute: string;
        };
        /** Y attribute reference */
        y: {
            element: string;
            attribute: string;
        };
        /** Link direction for curves */
        direction: {
            x: number;
            y: number;
        };
    }
    /** Filter specification, specify one of categories or expression */
    export interface Filter extends AttributeMap {
        /** Filter by a categorical variable */
        categories?: {
            /** The expression to draw values from */
            expression: string;
            /** The accepted values */
            values: {
                [value: string]: boolean;
            };
        };
        /** Filter by an arbitrary expression */
        expression?: Expression;
    }
    /** GroupBy specification */
    export interface GroupBy extends AttributeMap {
        /** Group by a string expression */
        expression?: Expression;
    }
    /** Order expression */
    export interface SortBy extends AttributeMap {
        expression?: Expression;
    }
    export enum CollapseOrExpandPanels {
        Collapse = "collapse",
        Expand = "expand",
        Custom = "custom"
    }
}

declare module 'CharticulatorContainer/container' {
    /**
      * Chart container module responsible to draw chart on the DOM.
      *
      * {@link ChartComponent} responsible to draw the chart on the DOM. The method {@link renderGraphicalElementSVG} uses it to render the main element of the chart
      *
      * {@link ChartContainer} uses to draw the chart outside of charticulator editor. This class uses {@link ChartComponent} inside for rendering the chart.
      * It's main part of Power BI extension and export as HTML (See {@link "app/actions/actions".Export} for details about export to HTML)
      *
      * {@link "container/chart_template".ChartTemplate} describes the chart itself. Responsible to instantiate the template on loading (in editor, in container of Power BI Visual or in HTML)
      * The interface {@link "core/specification/template".ChartTemplate} describes main parts of template structure.
      *
      * @packageDocumentation
      * @preferred
      */
    export { ChartComponent } from "CharticulatorContainer/container/chart_component";
    export { ChartTemplate, TemplateInstance } from "CharticulatorContainer/container/chart_template";
    export { ChartContainer } from "CharticulatorContainer/container/container";
    export * from "CharticulatorContainer/core";
}

declare module 'CharticulatorContainer/app/components/fluent_ui_gradient_picker' {
    import * as React from "react";
    import { ColorGradient } from "CharticulatorContainer/core";
    export interface GradientPickerProps {
        defaultValue?: ColorGradient;
        onPick?: (gradient: ColorGradient) => void;
    }
    export interface GradientPickerState {
        currentTab: string;
        currentGradient: ColorGradient;
    }
    export enum Colorspace {
        LAB = "lab",
        HCL = "hcl"
    }
    export class FluentUIGradientPicker extends React.Component<GradientPickerProps, GradientPickerState> {
        constructor(props: GradientPickerProps);
        selectGradient(gradient: ColorGradient, emit?: boolean): void;
        render(): JSX.Element;
    }
}

declare module 'CharticulatorContainer/core/actions/actions' {
    /**
        * Core part has two actions {@link SelectMark} and {@link ClearSelection}.
        *
        * {@link SelectMark} dispatches on selection
        *
        * {@link ClearSelection} dispatches on reset selection
        *
        * {@link Action} is base class for actions
        *
        * @packageDocumentation
        * @preferred
        */
    import { Dispatcher } from "CharticulatorContainer/core/common";
    import { Glyph, Element, PlotSegment } from "CharticulatorContainer/core/specification";
    import * as Specification from "CharticulatorContainer/core/specification";
    export function objectDigest(obj?: Specification.Object): string[];
    /**
        * Base class for all actions to describe all user interactions with charticulators objects
        * Actions dispatches by {@link BaseStore.dispatcher} method of the store.
        * List of charticulator app actions can be found in {@link "app/actions/actions"} module
        */
    export class Action {
            dispatch(dispatcher: Dispatcher<Action>): void;
            digest(): {
                    name: string;
            };
    }
    /** Dispatches when user selects the mark on the chart */
    export class SelectMark extends Action {
            plotSegment: PlotSegment;
            glyph: Glyph;
            mark: Element;
            glyphIndex: number;
            /**
                * @param plotSegment plot segment where mark was selected
                * @param glyph glyph where mark was selected (on a glyph editor or on a chart)
                * @param mark selected mark
                * @param glyphIndex index of glyph
                */
            constructor(plotSegment: PlotSegment, glyph: Glyph, mark: Element, glyphIndex?: number);
            digest(): {
                    name: string;
                    plotSegment: string[];
                    glyph: string[];
                    mark: string[];
                    glyphIndex: number;
            };
    }
    /** Dispatches when user reset selection of the mark on the chart */
    export class ClearSelection extends Action {
            digest(): {
                    name: string;
            };
    }
}

declare module 'CharticulatorContainer/core/graphics/renderer/text_measurer' {
    import { Graphics } from "CharticulatorContainer/core";
    export interface TextMeasurement {
        width: number;
        fontSize: number;
        ideographicBaseline: number;
        hangingBaseline: number;
        alphabeticBaseline: number;
        middle: number;
    }
    export class TextMeasurer {
        canvas: HTMLCanvasElement;
        context: CanvasRenderingContext2D;
        fontFamily: string;
        fontSize: number;
        static parameters: {
            hangingBaseline: number[];
            ideographicBaseline: number[];
            alphabeticBaseline: number[];
            middle: number[];
        };
        constructor();
        setFontFamily(family: string): void;
        setFontSize(size: number): void;
        measure(text: string): TextMeasurement;
        static GetGlobalInstance(): Graphics.TextMeasurer;
        static Measure(text: string, family: string, size: number): Graphics.TextMeasurement;
        static ComputeTextPosition(x: number, y: number, metrics: TextMeasurement, alignX?: "left" | "middle" | "right", alignY?: "top" | "middle" | "bottom", xMargin?: number, yMargin?: number): [number, number];
    }
    export const SPACE = " ";
    export const BREAKERS_REGEX: RegExp;
    export function split(str: string): string[];
    /**
      * Splits text to fragments do display text with word wrap
      * Source code taken from https://github.com/microsoft/powerbi-visuals-utils-formattingutils/blob/master/src/wordBreaker.ts#L130
      * @param content source of text
      * @param maxWidth max available with for text
      * @param maxNumLines limit lines count, rest of words will be drew in the last line
      * @param fontFamily font family
      * @param fontSize font size in px
      */
    export function splitByWidth(content: string, maxWidth: number, maxNumLines: number, fontFamily: string, fontSize: number): string[];
}

declare module 'CharticulatorContainer/core/prototypes/guides/guide' {
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { AttributeDescription, Controls, Handles, LinkAnchor, SnappingGuides, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { ObjectClassMetadata } from "CharticulatorContainer/core/prototypes/index";
    export type GuideAxis = "x" | "y";
    export enum GuideAttributeNames {
        value = "value",
        computedBaselineValue = "computedBaselineValue"
    }
    export interface GuideAttributes extends Specification.AttributeMap {
        value: number;
        computedBaselineValue: number;
    }
    interface GuideAttributeDescription extends AttributeDescription {
        name: GuideAttributeNames;
    }
    export enum GuidePropertyNames {
        axis = "axis",
        baseline = "baseline"
    }
    export interface GuideProperties extends Specification.AttributeMap {
        axis: GuideAxis;
        baseline: Specification.baselineH | Specification.baselineV;
    }
    export class GuideClass extends ChartElementClass<GuideProperties, GuideAttributes> {
        static classID: string;
        static type: string;
        static metadata: ObjectClassMetadata;
        static defaultProperties: Partial<GuideProperties>;
        attributeNames: GuideAttributeNames[];
        attributes: {
            [name in GuideAttributeNames]: GuideAttributeDescription;
        };
        initializeState(): void;
        buildConstraints(solver: ConstraintSolver): void;
        getLinkAnchors(): LinkAnchor.Description[];
        /** Get handles given current state */
        getHandles(): Handles.Description[];
        getSnappingGuides(): SnappingGuides.Description[];
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
        getTemplateParameters(): TemplateParameters;
    }
    export {};
}

declare module 'CharticulatorContainer/core/prototypes/guides/guide_coordinator' {
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { AttributeDescription, BoundingBox, Controls, Handles, SnappingGuides } from "CharticulatorContainer/core/prototypes/common";
    import { ObjectClassMetadata } from "CharticulatorContainer/core/prototypes/index";
    export interface GuideCoordinatorAttributes extends Specification.AttributeMap {
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        angle1: number;
        angle2: number;
        radial1: number;
        radial2: number;
        count: number;
    }
    export interface GuideCoordinatorProperties extends Specification.AttributeMap {
        axis: "x" | "y";
    }
    export class GuideCoordinatorClass extends ChartElementClass<GuideCoordinatorProperties, GuideCoordinatorAttributes> {
        static classID: string;
        static type: string;
        static metadata: ObjectClassMetadata;
        static defaultAttributes: Partial<GuideCoordinatorAttributes>;
        buildConstraints(solver: ConstraintSolver): void;
        getValueNames(): string[];
        get attributeNames(): string[];
        get attributes(): {
            [name: string]: AttributeDescription;
        };
        initializeState(): void;
        /** Get handles given current state */
        getHandles(): Handles.Description[];
        getBoundingBox(): BoundingBox.Description;
        getSnappingGuides(): SnappingGuides.Description[];
        /** Get controls given current state */
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
    }
}

declare module 'CharticulatorContainer/core/prototypes/guides/polar_coordinator' {
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ObjectState } from "CharticulatorContainer/core/specification";
    import { ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { AttributeDescription, Handles, SnappingGuides, BoundingBox, Controls } from "CharticulatorContainer/core/prototypes/common";
    import { ObjectClassMetadata } from "CharticulatorContainer/core/prototypes/index";
    import { Region2DAttributes } from "CharticulatorContainer/core/prototypes/plot_segments";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    export interface PolarGuideCoordinatorAttributesExtend extends Region2DAttributes {
        x: number;
        y: number;
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        cx: number;
        cy: number;
        angle1: number;
        angle2: number;
        radial1: number;
        radial2: number;
    }
    export interface PolarGuideCoordinatorAttributes extends PolarGuideCoordinatorAttributesExtend, Specification.AttributeMap {
    }
    export interface PolarGuideState extends ObjectState<PolarGuideCoordinatorAttributes> {
        attributes: PolarGuideCoordinatorAttributes;
    }
    interface PolarGuideCoordinatorPropertiesExtend {
        startAngle: number;
        endAngle: number;
        innerRatio: number;
        outerRatio: number;
        angularGuidesCount: number;
        radialGuidesCount: number;
    }
    export interface PolarGuideCoordinatorProperties extends PolarGuideCoordinatorPropertiesExtend, Specification.AttributeMap {
    }
    export const PolarGuidePropertyNames: Extract<keyof PolarGuideCoordinatorPropertiesExtend, string>[];
    export interface GuidePolarCoordinatorProperties extends Specification.AttributeMap {
        properties: PolarGuideCoordinatorProperties;
    }
    export interface PolarGuideObject extends Specification.Object<PolarGuideCoordinatorProperties> {
        properties: PolarGuideCoordinatorProperties;
    }
    export const PolarGuideBaseAttributeNames: Extract<keyof PolarGuideCoordinatorAttributes, string>[];
    export const getAngularValueName: (index: number) => string;
    export const getRadialValueName: (index: number) => string;
    export const getPointValueName: (angularIndex: number, radialIndex: number, axis: "X" | "Y") => string;
    export class GuidePolarCoordinatorClass extends ChartElementClass<PolarGuideCoordinatorProperties, PolarGuideCoordinatorAttributes> {
        static classID: string;
        static type: string;
        static metadata: ObjectClassMetadata;
        readonly state: PolarGuideState;
        static defaultAttributes: Partial<PolarGuideCoordinatorAttributes>;
        buildConstraints(solver: ConstraintSolver, constr: any, manager: ChartStateManager): void;
        getValueNamesForAngular(): string[];
        getValueNamesForRadial(): string[];
        getValueNamesForPoints(): string[];
        get attributeNames(): string[];
        get attributes(): {
            [name: string]: AttributeDescription;
        };
        initializeState(): void;
        /** Get handles given current state */
        getHandles(): Handles.Description[];
        getBoundingBox(): BoundingBox.Circle;
        getSnappingGuides(): SnappingGuides.PolarAxis[];
        /** Get controls given current state */
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
    }
    export {};
}

declare module 'CharticulatorContainer/core/prototypes/chart_element' {
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ChartClass } from "CharticulatorContainer/core/prototypes/charts";
    import { BoundingBox, Controls, DropZones, Handles, SnappingGuides } from "CharticulatorContainer/core/prototypes/common";
    import { ObjectClass } from "CharticulatorContainer/core/prototypes/object";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    export interface BuildConstraintsContext {
        rowContext?: Expression.Context;
        getExpressionValue?(expr: string, context: Expression.Context): Specification.AttributeValue;
        getGlyphAttributes?(glyph: string, table: string, rowIndices: number[]): {
            [name: string]: number;
        };
    }
    export abstract class ChartElementClass<PropertiesType extends Specification.AttributeMap = Specification.AttributeMap, AttributesType extends Specification.AttributeMap = Specification.AttributeMap> extends ObjectClass<PropertiesType, AttributesType> {
        readonly object: Specification.ChartElement<PropertiesType>;
        readonly state: Specification.ChartElementState<AttributesType>;
        readonly parent: ChartClass;
        /** Get intrinsic constraints between attributes (e.g., x2 - x1 = width for rectangles) */
        buildConstraints(solver: ConstraintSolver, context: BuildConstraintsContext, manager: ChartStateManager): void;
        /** Get the graphics that represent this layout */
        getGraphics(manager: ChartStateManager): Graphics.Element;
        /** Get handles given current state */
        getHandles(): Handles.Description[];
        getBoundingBox(): BoundingBox.Description;
        getSnappingGuides(): SnappingGuides.Description[];
        getDropZones(): DropZones.Description[];
        /** Get controls given current state */
        getPopupEditor(manager: Controls.WidgetManager): Controls.PopupEditor;
        static createDefault(...args: any[]): Specification.ChartElement;
    }
}

declare module 'CharticulatorContainer/core/prototypes/object' {
    import * as Specification from "CharticulatorContainer/core/specification";
    import { TemplateParameters } from "CharticulatorContainer/core/prototypes";
    import { Controls, CreatingInteraction } from "CharticulatorContainer/core/prototypes/common";
    export interface AttributeDescription {
            name: string;
            type: Specification.AttributeType;
            /** Exclude this from the constraint solver */
            solverExclude?: boolean;
            stateExclude?: boolean;
            editableInGlyphStage?: boolean;
            /** Default value: used when nothing is specified for this attribute */
            defaultValue?: Specification.AttributeValue;
            /** Default range: hint for scale inference */
            defaultRange?: Specification.AttributeValue[];
    }
    export interface AttributeDescriptions {
            [name: string]: AttributeDescription;
    }
    export interface ObjectClassMetadata {
            /** Display name of the object */
            displayName?: string;
            /** Object icon resource */
            iconPath?: string;
            /** Create by mouse interaction */
            creatingInteraction?: CreatingInteraction.Description;
    }
    /** A ObjectClass contains the runtime info for a chart object */
    export abstract class ObjectClass<PropertiesType extends Specification.AttributeMap = Specification.AttributeMap, AttributesType extends Specification.AttributeMap = Specification.AttributeMap> {
            /** The static classID */
            static classID: string;
            /** The static type */
            static type: string;
            /** The metadata associated with the class */
            static metadata: ObjectClassMetadata;
            /** Default attributes */
            static defaultProperties: Specification.AttributeMap;
            /** Default mapping values */
            static defaultMappingValues: Specification.AttributeMap;
            /** The stored object */
            readonly object: Specification.Object<PropertiesType>;
            /** The stored object state */
            readonly state: Specification.ObjectState<AttributesType>;
            /** The parent object class */
            readonly parent: ObjectClass;
            /** Attribute names, this can be a normal field or a dynamic property with a get method */
            abstract attributeNames: string[];
            /** Attribute descriptions, this can be a normal field or a dynamic property with a get method */
            abstract attributes: AttributeDescriptions;
            constructor(parent: ObjectClass, object: Specification.Object<PropertiesType>, state: Specification.ObjectState<AttributesType>);
            /** Initialize the state of the object */
            initializeState(): void;
            /** Get the UI spec for property panel */
            getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
            getTemplateParameters(): TemplateParameters;
            /** Create a default object */
            static createDefault(...args: any[]): Specification.Object;
    }
    /** ObjectClass constructor */
    export interface ObjectClassConstructor {
            new (parent: ObjectClass, object: Specification.Object, state: Specification.ObjectState): ObjectClass;
            classID: string;
            type: string;
            metadata: ObjectClassMetadata;
            defaultProperties: Specification.AttributeMap;
            defaultMappingValues: Specification.AttributeMap;
            createDefault: (...args: any[]) => Specification.Object;
    }
    /** Store the registered object classes */
    export class ObjectClasses {
            /** Create a ObjectClass for a object and its state */
            static Create(parent: ObjectClass, object: Specification.Object, state: Specification.ObjectState): ObjectClass;
            static CreateDefault(classID: string, ...args: any[]): Specification.Object<Specification.ObjectProperties>;
            static GetMetadata(classID: string): ObjectClassMetadata;
            static Register(constructor: ObjectClassConstructor): void;
            static RegisterType(name: string, ...parents: string[]): void;
            static isType(type: string, parentType: string): boolean;
            /**
                * Gets an interator of registered classes.
                */
            static RegisteredClasses(): IterableIterator<ObjectClassConstructor>;
    }
    export const isType: typeof ObjectClasses.isType;
}

declare module 'CharticulatorContainer/core/prototypes/marks/mark' {
    import { Point } from "CharticulatorContainer/core/common";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { ChartClass } from "CharticulatorContainer/core/prototypes/charts";
    import { BoundingBox, BuildConstraintsContext, DropZones, Handles, LinkAnchor, ObjectClass, SnappingGuides } from "CharticulatorContainer/core/prototypes/common";
    import { GlyphClass } from "CharticulatorContainer/core/prototypes/glyphs";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    export interface CreationParameters {
        dropPoint: Point;
    }
    export abstract class MarkClass<PropertiesType extends Specification.AttributeMap = Specification.AttributeMap, AttributesType extends Specification.AttributeMap = Specification.AttributeMap> extends ObjectClass<PropertiesType, AttributesType> {
        readonly object: Specification.Element<PropertiesType>;
        readonly state: Specification.MarkState<AttributesType>;
        /** Fill the default state */
        initializeState(): void;
        /** Get intrinsic constraints between attributes (e.g., x2 - x1 = width for rectangles) */
        buildConstraints(solver: ConstraintSolver, context: BuildConstraintsContext, manager: ChartStateManager): void;
        /** Get the graphical element from the element */
        getGraphics(coordinateSystem: Graphics.CoordinateSystem, offset: Point, glyphIndex: number, manager: ChartStateManager, emphasized?: boolean): Graphics.Element;
        /** Get DropZones given current state */
        getDropZones(): DropZones.Description[];
        /** Get link anchors for this mark */
        getLinkAnchors(mode: "begin" | "end"): LinkAnchor.Description[];
        /** Get handles given current state */
        getHandles(): Handles.Description[];
        /** Get bounding box */
        getBoundingBox(): BoundingBox.Description;
        /** Get alignment guides */
        getSnappingGuides(): SnappingGuides.Description[];
        getGlyphClass(): GlyphClass;
        getPlotSegmentClass(): PlotSegmentClass<Specification.AttributeMap, Specification.AttributeMap>;
        getChartClass(): ChartClass;
    }
}

declare module 'CharticulatorContainer/core/prototypes/marks/symbol' {
    import { Point } from "CharticulatorContainer/core/common";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { AttributeDescriptions, BoundingBox, Controls, DropZones, Handles, LinkAnchor, ObjectClassMetadata, SnappingGuides, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    import { EmphasizableMarkClass } from "CharticulatorContainer/core/prototypes/marks/emphasis";
    import { SymbolElementAttributes, SymbolElementProperties } from "CharticulatorContainer/core/prototypes/marks/symbol.attrs";
    export const symbolTypesList: string[];
    export { SymbolElementAttributes, SymbolElementProperties };
    export class SymbolElementClass extends EmphasizableMarkClass<SymbolElementProperties, SymbolElementAttributes> {
        static classID: string;
        static type: string;
        static metadata: ObjectClassMetadata;
        static defaultProperties: Partial<SymbolElementProperties>;
        static defaultMappingValues: Partial<SymbolElementAttributes>;
        attributes: AttributeDescriptions;
        attributeNames: string[];
        initializeState(): void;
        /** Get link anchors for this mark */
        getLinkAnchors(mode: "begin" | "end"): LinkAnchor.Description[];
        getGraphics(cs: Graphics.CoordinateSystem, offset: Point, glyphIndex: number, manager: ChartStateManager, emphasize?: boolean): Graphics.Element;
        getDropZones(): DropZones.Description[];
        getHandles(): Handles.Description[];
        getBoundingBox(): BoundingBox.Description;
        getSnappingGuides(): SnappingGuides.Description[];
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
        getTemplateParameters(): TemplateParameters;
    }
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/axis' {
    import { ZoomInfo } from "CharticulatorContainer/core/common";
    import { CoordinateSystem, Group } from "CharticulatorContainer/core/graphics";
    import { Specification } from "CharticulatorContainer/core/index";
    import { Controls } from "CharticulatorContainer/core/prototypes/common";
    import { DataflowManager } from "CharticulatorContainer/core/prototypes/dataflow";
    import { CartesianPlotSegment } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d";
    import React = require("react");
    export const defaultAxisStyle: Specification.Types.AxisRenderingStyle;
    export interface TickDescription {
        position: number;
        label: string;
    }
    export enum AxisMode {
        X = "x",
        Y = "y"
    }
    export class AxisRenderer {
        ticks: TickDescription[];
        style: Specification.Types.AxisRenderingStyle;
        rangeMin: number;
        rangeMax: number;
        valueToPosition: (value: any) => number;
        oppositeSide: boolean;
        static SCROLL_BAR_SIZE: number;
        static DEFAULT_TICKS_NUMBER: number;
        static DEFAULT_Y_LABEL_GAP: number;
        setStyle(style?: Partial<Specification.Types.AxisRenderingStyle>): this;
        setAxisDataBinding(data: Specification.Types.AxisDataBinding, rangeMin: number, rangeMax: number, enablePrePostGap: boolean, reverse: boolean, getTickFormat?: (value: any) => string, plotSegment?: Specification.PlotSegment, dataflow?: DataflowManager): this;
        ticksData: {
            tick: any;
            value: any;
        }[];
        setTicksByData(ticks: {
            tick: any;
            value: any;
        }[], tickFormatString: string): void;
        static getTickFormat(tickFormat: string, defaultFormat: (d: number) => string): (d: number) => string;
        setCartesianChartMargin(plotSegment: CartesianPlotSegment): void;
        setLinearScale(domainMin: number, domainMax: number, rangeMin: number, rangeMax: number, tickFormat: string, numberOfTicks?: number, autoTickNumber?: boolean): this;
        setLogarithmicScale(domainMin: number, domainMax: number, rangeMin: number, rangeMax: number, tickFormat: string, numberOfTicks?: number, autoTickNumber?: boolean): this;
        setTemporalScale(domainMin: number, domainMax: number, rangeMin: number, rangeMax: number, tickFormatString: string, numberOfTicks?: number, autoTickNumber?: boolean): this;
        setCategoricalScale(domain: string[], range: [number, number][], rangeMin: number, rangeMax: number, tickFormat?: (value: any) => string): this;
        renderGridLine(x: number, y: number, angle: number, side: number, size: number): Group;
        renderGridlinesForAxes(x: number, y: number, axis: AxisMode, size: number): Group;
        renderLine(x: number, y: number, angle: number, side: number, axisOffset?: number): Group;
        renderCartesian(x: number, y: number, axis: AxisMode, offset?: number): Group;
        renderPolarRadialGridLine(x: number, y: number, innerRadius: number, outerRadius: number): Group;
        renderPolarArcGridLine(x: number, y: number, innerRadius: number, outerRadius: number, startAngle: number, endAngle: number): Group;
        renderPolar(cx: number, cy: number, radius: number, side: number): Group;
        renderCurve(coordinateSystem: CoordinateSystem, y: number, side: number): Group;
        renderVirtualScrollBar(x: number, y: number, axis: AxisMode, scrollPosition: number, onScroll: (position: number) => void, zoom: ZoomInfo): React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)>) | (new (props: any) => React.Component<any, any, any>)>;
    }
    export function getCategoricalAxis(data: Specification.Types.AxisDataBinding, enablePrePostGap: boolean, reverse: boolean): {
        gap: number;
        preGap: number;
        postGap: number;
        gapScale: number;
        ranges: [number, number][];
    };
    export function getNumericalInterpolate(data: Specification.Types.AxisDataBinding): (x: number) => number;
    interface AxisAppearanceWidgets {
        isVisible: boolean;
        wordWrap: boolean;
        isOffset: boolean;
        isOnTop: boolean;
        mainCollapsePanelHeader?: string;
    }
    export function buildAxisAppearanceWidgets(axisProperty: string, manager: Controls.WidgetManager, options: AxisAppearanceWidgets): any;
    interface AxisWidgetsConfig {
        showOffset: boolean;
        showScrolling: boolean;
        showOnTop: boolean;
    }
    export function buildAxisWidgets(data: Specification.Types.AxisDataBinding, axisProperty: string, manager: Controls.WidgetManager, axisName: string, axisWidgetsConfig?: AxisWidgetsConfig, onChange?: () => void): Controls.Widget[];
    export function buildAxisInference(plotSegment: Specification.PlotSegment, property: string): Specification.Template.Inference;
    export function buildAxisProperties(plotSegment: Specification.PlotSegment, property: string): Specification.Template.Property[];
    export {};
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/line' {
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { AttributeDescription, BoundingBox, Controls, DropZones, Handles, ObjectClassMetadata, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments/plot_segment";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    /**
        * Line plot segment distributes the elements on the line
        *
        *  (y1 and y2 can have diferent values, so line cna have some angle between line and axis lines)
        *  y1 *------#------#------* y2
        *    x1                    x2
        *
        * # - some element on line
        */
    export interface LineGuideAttributes extends Specification.AttributeMap {
            /** x value of left point of line */
            x1?: number;
            /** y value of left point of line */
            y1?: number;
            /** x value of right point of line */
            x2?: number;
            /** y value of right point of line */
            y2?: number;
            /** free variable ? TODO figure out */
            x?: number;
            /** free variable ? TODO figure out */
            y?: number;
    }
    export interface LineGuideState extends Specification.PlotSegmentState {
            attributes: LineGuideAttributes;
    }
    export interface LineGuideProperties extends Specification.AttributeMap {
            axis?: Specification.Types.AxisDataBinding;
    }
    export interface LineGuideObject extends Specification.PlotSegment {
            properties: LineGuideProperties;
    }
    export class LineGuide extends PlotSegmentClass {
            static classID: string;
            static type: string;
            static metadata: ObjectClassMetadata;
            static defaultProperties: Specification.AttributeMap;
            readonly state: LineGuideState;
            readonly object: LineGuideObject;
            attributeNames: string[];
            attributes: {
                    [name: string]: AttributeDescription;
            };
            initializeState(): void;
            /**
                * Creates constraints for elements on the line plot segment
                * Line plot segment distributes the elements on the line
                *  (y1 and y2 can have different values, so line can have some angle between line and axis lines)
                *  *
                *  y1 *------#------#------* y2
                *    x1      t      t      x2
                *
                * # - some element on line
                * t - position of the element on line
                */
            buildGlyphConstraints(solver: ConstraintSolver): void;
            getDropZones(): DropZones.Description[];
            getHandles(): Handles.Description[];
            getBoundingBox(): BoundingBox.Description;
            getGraphics(manager: ChartStateManager): Graphics.Element;
            getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
            /**
                * Renders gridlines for axis. Returns empty array to diable widgets for line plot segment.
                * Not implemented yet
                * @param data axis data binding
                * @param manager widgets manager
                * @param axisProperty property name of plotsegment with axis properties (xData, yData, axis)
                */
            buildGridLineWidgets(): Controls.Widget[];
            getTemplateParameters(): TemplateParameters;
    }
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/region_2d' {
    export { Region2DAttributes, Region2DProperties } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/base";
    export { CartesianPlotSegment } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/cartesian";
    export { PolarPlotSegment } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/polar";
    export { CurvePlotSegment } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/curve";
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/plot_segment' {
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { BuildConstraintsContext, ChartElementClass } from "CharticulatorContainer/core/prototypes/chart_element";
    import { BoundingBox, Controls, DropZones, Handles } from "CharticulatorContainer/core/prototypes/common";
    import { ZoomInfo } from "CharticulatorContainer/core";
    import { ReactElement } from "react";
    export abstract class PlotSegmentClass<PropertiesType extends Specification.AttributeMap = Specification.AttributeMap, AttributesType extends Specification.AttributeMap = Specification.AttributeMap> extends ChartElementClass<PropertiesType, AttributesType> {
            readonly object: Specification.PlotSegment<PropertiesType>;
            readonly state: Specification.PlotSegmentState<AttributesType>;
            /** Fill the layout's default state */
            initializeState(): void;
            /** Build intrinsic constraints between attributes (e.g., x2 - x1 = width for rectangles) */
            buildConstraints(solver: ConstraintSolver, context: BuildConstraintsContext, manager: ChartStateManager): void;
            /** Build constraints for glyphs within */
            buildGlyphConstraints(solver: ConstraintSolver, context: BuildConstraintsContext): void;
            /** Get the graphics that represent this layout */
            getPlotSegmentGraphics(glyphGraphics: Graphics.Element, manager: ChartStateManager): Graphics.Element;
            /** Get the graphics that represent this layout of elements in background*/
            getPlotSegmentBackgroundGraphics(manager: ChartStateManager): Graphics.Element;
            renderControls(_manager: ChartStateManager, _zoom: ZoomInfo): ReactElement<any>[];
            getCoordinateSystem(): Graphics.CoordinateSystem;
            /** Get DropZones given current state */
            getDropZones(): DropZones.Description[];
            /** Get handles given current state */
            getHandles(): Handles.Description[];
            getBoundingBox(): BoundingBox.Description;
            /**
                * Renders gridlines for axis
                * @param data axis data binding
                * @param manager widgets manager
                * @param axisProperty property name of plotsegment with axis properties (xData, yData, axis)
                */
            buildGridLineWidgets(data: Specification.Types.AxisDataBinding, manager: Controls.WidgetManager, axisProperty: string, mainCollapsePanelHeader: string): any[];
            static getGridLineAttributePanelWidgets(manager: Controls.WidgetManager, axisProperty: string, mainCollapsePanelHeader?: string): any[];
            getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
            static createDefault(glyph: Specification.Glyph): Specification.PlotSegment;
            getDisplayRawFormat(binding: Specification.Types.AxisDataBinding, manager: ChartStateManager): (value: any) => any;
            getDisplayFormat: (binding: Specification.Types.AxisDataBinding, tickFormat?: string, manager?: ChartStateManager) => (value: any) => any;
            protected buildGlyphOrderedList(): number[];
            /**
                * Return the index of the first glyph after sorting glyphs according sublayout order parameter
                */
            getFirstGlyphIndex(): number;
            /**
                * Return the index of the last glyph after sorting glyphs according sublayout order parameter
                */
            getLastGlyphIndex(): number;
    }
}

declare module 'CharticulatorContainer/core/prototypes/scales/scale' {
    import { ConstraintSolver, Variable } from "CharticulatorContainer/core/solver";
    import { DataValue, Scale, ScaleState, AttributeValue, AttributeMap } from "CharticulatorContainer/core/specification";
    import { DataMappingHints, ObjectClass, TemplateParameters, ObjectClassMetadata } from "CharticulatorContainer/core/prototypes/common";
    export interface InferParametersOptions extends DataMappingHints {
        /** Whether to extend the scale min domain with new data */
        extendScaleMin?: boolean;
        /** Whether to extend the scale max domain with new data */
        extendScaleMax?: boolean;
        /** Whether to reuse the existing range of the scale, applies to color and image */
        reuseRange?: boolean;
        /** Whether to ensure the domainMin == 0 (for numeric scales) */
        startWithZero?: "default" | "always" | "never";
    }
    export abstract class ScaleClass<PropertiesType extends AttributeMap = AttributeMap, AttributesType extends AttributeMap = AttributeMap> extends ObjectClass<PropertiesType, AttributesType> {
        readonly object: Scale<PropertiesType>;
        readonly state: ScaleState<AttributesType>;
        static metadata: ObjectClassMetadata;
        abstract mapDataToAttribute(data: DataValue): AttributeValue;
        buildConstraint(data: DataValue, target: Variable, solver: ConstraintSolver): void;
        abstract inferParameters(column: DataValue[], options?: InferParametersOptions): void;
        getTemplateParameters(): TemplateParameters;
    }
}

declare module 'CharticulatorContainer/core/prototypes/controls' {
    import { DataMappingHints } from "CharticulatorContainer/core/prototypes";
    import { Point } from "CharticulatorContainer/core/common";
    import * as Specification from "CharticulatorContainer/core/specification";
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import { CSSProperties } from "react";
    import { ICheckboxStyles, IDropdownOption } from "@fluentui/react";
    import { DataType } from "CharticulatorContainer/core/specification";
    export type Widget = any;
    export interface Property {
        property: string;
        field?: string | number | (string | number)[];
        noUpdateState?: boolean;
        noComputeLayout?: boolean;
    }
    export interface InputComboboxOptions extends SearchSection {
        defaultRange: string[];
        valuesOnly?: boolean;
        label?: string;
    }
    export const enum LabelPosition {
        Right = 0,
        Bottom = 1,
        Left = 2,
        Top = 3
    }
    export interface InputSelectOptions extends SearchSection {
        type: "radio" | "dropdown";
        showLabel?: boolean;
        labelPosition?: LabelPosition;
        options: string[];
        icons?: string[];
        isLocalIcons?: boolean;
        labels?: string[];
        tooltip?: string;
        label?: string;
        hideBorder?: boolean;
        shiftCallout?: number;
        observerConfig?: ObserverConfig;
        onChange?: (value: IDropdownOption) => void;
    }
    export interface InputFontComboboxOptions extends SearchSection {
        label?: string;
    }
    export interface InputTextOptions extends SearchSection {
        label?: string;
        placeholder?: string;
        tooltip?: string;
        updateProperty?: boolean;
        value?: string;
        underline?: boolean;
        borderless?: boolean;
        styles?: CSSProperties;
        emitMappingAction?: boolean;
        disabled?: boolean;
    }
    export interface InputBooleanOptions extends SearchSection {
        type: "checkbox" | "highlight" | "checkbox-fill-width";
        icon?: string;
        headerLabel?: string;
        label?: string;
        observerConfig?: ObserverConfig;
        checkBoxStyles?: ICheckboxStyles;
        onChange?: (value: boolean) => void;
        styles?: CSSProperties;
    }
    export interface RowOptions extends SearchSection {
        dropzone?: {
            type: "axis-data-binding";
            prompt?: string;
            property?: string;
            defineCategories?: boolean;
        };
        noLineHeight?: boolean;
        acceptLinksTable?: boolean;
    }
    export interface DropTargetOptions {
        type: "order";
        property: Property;
        label: string;
    }
    export interface OrderWidgetOptions {
        table: string;
        displayLabel?: boolean;
        labelPosition?: LabelPosition;
        tooltip?: string;
        shiftCallout?: number;
    }
    export interface MappingEditorOptions extends SearchSection {
        /** Hints for creating data mapping */
        hints?: DataMappingHints;
        /** When no mapping is specified, show the default value */
        defaultValue?: Specification.AttributeValue;
        /** When no mapping is specified, and no default value, show auto (true) or none (false). */
        defaultAuto?: boolean;
        /** Only allow mapping from one table */
        table?: string;
        acceptKinds?: Specification.DataKind[];
        numberOptions?: InputNumberOptions;
        /** Open mapping editor after rendering */
        openMapping?: boolean;
        /** Enables value selector from mapping */
        allowSelectValue?: boolean;
        /** Text lael of input */
        label?: string;
        stopPropagation?: boolean;
        acceptLinksTable?: boolean;
    }
    export interface ObserverConfig {
        isObserver: boolean;
        properties: Property | Property[];
        value: Specification.AttributeValue;
    }
    export interface InputNumberOptions extends SearchSection {
        digits?: number;
        minimum?: number;
        maximum?: number;
        step?: number;
        percentage?: boolean;
        showSlider?: boolean;
        sliderRange?: [number, number];
        sliderFunction?: "linear" | "sqrt";
        showUpdown?: boolean;
        updownTick?: number;
        updownRange?: [number, number];
        updownStyle?: "normal" | "font";
        label?: string;
        stopPropagation?: boolean;
        observerConfig?: ObserverConfig;
        styles?: CSSProperties;
        placeholder?: string;
    }
    export interface InputDateOptions extends SearchSection {
        defaultValue?: number | Date;
        placeholder?: string;
        label?: string;
        onEnter?: (value: number) => boolean;
    }
    export interface InputColorOptions extends SearchSection {
        allowNull?: boolean;
        label?: string;
        noDefaultMargin?: boolean;
        stopPropagation?: boolean;
        labelKey: string;
        width?: number;
        underline?: boolean;
        pickerBeforeTextField?: boolean;
        styles?: {
            marginTop?: string;
        };
    }
    export interface TableOptions {
    }
    export interface VerticalGroupOptions extends SearchSection {
        isCollapsed?: boolean;
        header: string;
        alignVertically?: boolean;
    }
    export const enum PanelMode {
        Button = "button",
        Panel = "panel"
    }
    export interface FilterEditorOptions extends SearchSection {
        table: string;
        target: {
            plotSegment?: Specification.PlotSegment;
            property?: Property;
        };
        value: Specification.Types.Filter;
        mode: PanelMode;
        key?: string;
    }
    export interface GroupByEditorOptions extends SearchSection {
        table: string;
        target: {
            plotSegment?: Specification.PlotSegment;
            property?: Property;
        };
        value: Specification.Types.GroupBy;
        mode: PanelMode;
        key: string;
    }
    export interface NestedChartEditorOptions extends SearchSection {
        specification: Specification.Chart;
        dataset: Dataset.Dataset;
        filterCondition?: {
            column: string;
            value: any;
        };
        width: number;
        height: number;
    }
    export interface ArrayWidgetOptions {
        allowReorder?: boolean;
        allowDelete?: boolean;
    }
    export interface ScrollListOptions {
        height?: number;
        maxHeight?: number;
        styles?: CSSProperties;
    }
    export interface InputExpressionOptions extends SearchSection {
        table?: string;
        label?: string;
        allowNull?: boolean;
        placeholder?: string;
        noLineHeight?: boolean;
        dropzone?: {
            type: "axis-data-binding" | "tick-data-binding";
            prompt?: string;
            property?: string;
            defineCategories?: boolean;
        };
    }
    export interface InputFormatOptions extends SearchSection {
        blank?: string;
        allowNull?: boolean;
    }
    export interface InputFormatOptions {
        blank?: string;
        label?: string;
        allowNull?: boolean;
    }
    export interface InputFormatOptions {
        blank?: string;
        isDateField?: boolean;
        label?: string;
        allowNull?: boolean;
    }
    export interface ReOrderWidgetOptions {
        allowReset?: boolean;
        onConfirm?: (items: string[]) => void;
        onReset?: () => string[];
        items?: string[];
        onConfirmClick?: (items: string[]) => void;
        onResetCategories?: string[];
        sortedCategories?: string[];
        itemsDataType?: DataType.Number | DataType.String;
        allowDragItems?: boolean;
        onReorderHandler?: () => void;
        onButtonHandler?: () => void;
    }
    export interface InputFormatOptions {
        blank?: string;
        isDateField?: boolean;
    }
    export interface InputFormatOptions {
        blank?: string;
        isDateField?: boolean;
    }
    export interface InputFormatOptions {
        blank?: string;
        isDateField?: boolean;
    }
    export interface CustomCollapsiblePanelOptions {
        header?: string;
        styles?: CSSProperties;
    }
    export interface WidgetManager {
        mappingEditor(name: string, attribute: string, options: MappingEditorOptions): Widget;
        inputNumber(property: Property, options?: InputNumberOptions): Widget;
        inputDate(property: Property, options?: InputDateOptions): Widget;
        inputText(property: Property, options: InputTextOptions): Widget;
        inputComboBox(property: Property, options: InputComboboxOptions): Widget;
        inputFontFamily(property: Property, options: InputFontComboboxOptions): Widget;
        inputSelect(property: Property, options: InputSelectOptions): Widget;
        inputBoolean(property: Property | Property[], options: InputBooleanOptions): Widget;
        inputExpression(property: Property, options?: InputExpressionOptions): Widget;
        inputFormat(property: Property, options?: InputFormatOptions): Widget;
        inputImage(property: Property): Widget;
        inputImageProperty(property: Property): Widget;
        inputColor(property: Property, options?: InputColorOptions): Widget;
        inputColorGradient(property: Property, inline?: boolean): Widget;
        clearButton(property: Property, icon?: string, isHeader?: boolean, styles?: CSSProperties): Widget;
        setButton(property: Property, value: Specification.AttributeValue, icon?: string, text?: string): Widget;
        scaleEditor(attribute: string, text: string): Widget;
        orderByWidget(property: Property, options: OrderWidgetOptions): Widget;
        reorderWidget(property: Property, options: ReOrderWidgetOptions): Widget;
        reorderByAnotherColumnWidget(property: Property, options: ReOrderWidgetOptions): Widget;
        arrayWidget(property: Property, item: (item: Property, index?: number) => Widget, options?: ArrayWidgetOptions): Widget;
        dropTarget(options: DropTargetOptions, widget: Widget): Widget;
        icon(icon: string): Widget;
        label(title: string, options?: LabelOptions): Widget;
        text(text: string, align?: "left" | "center" | "right"): Widget;
        sep(): Widget;
        sectionHeader(title: string, widget?: Widget, options?: RowOptions): Widget;
        row(title?: string, widget?: Widget, options?: RowOptions): Widget;
        horizontal(cols: number[], ...widgets: Widget[]): Widget;
        styledHorizontal(styles: CSSProperties, cols: number[], ...widgets: Widget[]): Widget;
        verticalGroup(options: VerticalGroupOptions, ...widgets: Widget[]): Widget;
        vertical(...widgets: Widget[]): Widget;
        styledVertical(styles: CSSProperties, ...widgets: Widget[]): Widget;
        table(rows: Widget[][], options?: TableOptions): Widget;
        scrollList(widgets: Widget[], options?: ScrollListOptions): Widget;
        tooltip(widget: Widget, tooltipContent: Widget): Widget;
        filterEditor(options: FilterEditorOptions): Widget;
        groupByEditor(options: GroupByEditorOptions): Widget;
        nestedChartEditor(property: Property, options: NestedChartEditorOptions): Widget;
        customCollapsiblePanel(widgets: Widget[], options: CustomCollapsiblePanelOptions): Widget;
        searchInput(options: InputTextOptions): Widget;
        searchWrapper(options: SearchWrapperOptions, ...widgets: Widget[]): Widget;
    }
    export interface PopupEditor {
        anchor: Point;
        widgets: Widget[];
    }
    export interface LabelOptions extends SearchSection {
        addMargins?: boolean;
        key?: string;
    }
    export interface SearchWrapperOptions {
        searchPattern: string[];
    }
    export interface SearchSection {
        searchSection?: string | string[];
        ignoreSearch?: boolean;
    }
}

declare module 'CharticulatorContainer/core/prototypes/index' {
    /**
      * Module contains basic elements of charts:
      *
      * * Marks elements {@link "core/prototypes/marks/index"} are "bricks" of charticulator. Module contains descriptions of rectangle, image, symbol, text, e.t.c
      *
      * * Plot segments  {@link "core/prototypes/plot_segments/index"} container of glyphs to arrange them on the chart
      *
      * * Chart {@link "core/prototypes/charts/index"} highest level element, contains all other elements like plot segments, marks, legends e.t.c
      *
      * * Scales {@link "core/prototypes/plot_segments/index"} map data valus into pixels and sizes of elements(marks)
      *
      * * Links {@link "core/prototypes/links/index"}
      *
      * * Legends {@link "core/prototypes/legends/index"}
      *
      * * Guides {@link "core/prototypes/guides/index"} helper non visual elements to allign other elements
      *
      * * Glyphs {@link "core/prototypes/glyphs/index"} is container of other elements on plot segmets
      *
      * * Dataflow {@link "core/prototypes/dataflow/index"} uses for connecting elements to dataset
      *
      * @packageDocumentation
      * @preferred
      */
    import * as Charts from "CharticulatorContainer/core/prototypes/charts";
    import * as Constraints from "CharticulatorContainer/core/prototypes/constraints";
    import * as Dataflow from "CharticulatorContainer/core/prototypes/dataflow";
    import * as Glyphs from "CharticulatorContainer/core/prototypes/glyphs";
    import * as Guides from "CharticulatorContainer/core/prototypes/guides";
    import * as Legends from "CharticulatorContainer/core/prototypes/legends";
    import * as Links from "CharticulatorContainer/core/prototypes/links";
    import * as Marks from "CharticulatorContainer/core/prototypes/marks";
    import * as PlotSegments from "CharticulatorContainer/core/prototypes/plot_segments";
    import * as Scales from "CharticulatorContainer/core/prototypes/scales";
    export { ObjectClassCache } from "CharticulatorContainer/core/prototypes/cache";
    export * from "CharticulatorContainer/core/prototypes/common";
    export * from "CharticulatorContainer/core/prototypes/state";
    export { Marks, Scales, Constraints, Glyphs, Charts, PlotSegments, Links, Guides, Legends, Dataflow, };
}

declare module 'CharticulatorContainer/core/dataset/dsv_parser' {
    import { LocaleNumberFormat } from "CharticulatorContainer/core/dataset/data_types";
    import { Table } from "CharticulatorContainer/core/dataset/dataset";
    export function parseHints(hints: string): {
        [name: string]: string;
    };
    export interface LocaleFileFormat {
        delimiter: string;
        numberFormat: LocaleNumberFormat;
        currency: string;
        group: string;
        utcTimeZone: boolean;
    }
    /**
      * Parses data from file. Returns converted rows and list of colum names with types.
      * Calls {@link inferAndConvertColumn} method from {@link "core/dataset/data_types"} for convert types.
      * @param fileName input file name for parsing
      * @param content data of file
      * @param type type of file. *.csv - text with coma delimeter. *.tsv - tab separated text files
      */
    export function parseDataset(fileName: string, content: string, localeFileFormat: LocaleFileFormat): Table;
}

declare module 'CharticulatorContainer/core/solver/wasm_solver' {
    import * as LSCGSolver from "lscg-solver";
    import { KeyNameMap } from "CharticulatorContainer/core/common";
    import { AttributeMap } from "CharticulatorContainer/core/specification";
    import { AttributeOptions, ConstraintSolver, ConstraintStrength, Variable } from "CharticulatorContainer/core/solver/abstract";
    export function initialize(): Promise<void>;
    export const Matrix: typeof LSCGSolver.Matrix;
    export interface WASMSolverVariable extends Variable {
            map: AttributeMap;
            name: string;
            index: number;
    }
    export class WASMSolver extends ConstraintSolver {
            solver: LSCGSolver.ConstraintSolver;
            variables: KeyNameMap<AttributeMap, WASMSolverVariable>;
            currentIndex: number;
            softInequalities: {
                    id: number;
                    bias: number;
                    variable_names: number[];
                    weights: number[];
            }[];
            constructor();
            makeConstant(map: AttributeMap, name: string): void;
            /** Get the variable of an attribute */
            attr(map: AttributeMap, name: string, options?: AttributeOptions): WASMSolverVariable;
            /** Get the value of a variable */
            getValue(attr: WASMSolverVariable): number;
            /** Set the value of a variable */
            setValue(attr: WASMSolverVariable, value: number): void;
            /**
                * Add a linear constraint
                * @param lhs - left-hand side of equation
                * @param rhs - left-hand side of equation
                */
            addLinear(strength: ConstraintStrength, bias: number, lhs: [number, WASMSolverVariable][], rhs?: [number, WASMSolverVariable][]): void;
            /** Add a soft inequality constraint: bias + linear(lhs) >= linear(rhs) */
            addSoftInequality(strength: ConstraintStrength, bias: number, lhs: [number, WASMSolverVariable][], rhs?: [number, WASMSolverVariable][]): void;
            /** Solve the constraints */
            solve(): [number, number];
            destroy(): void;
    }
}

declare module 'CharticulatorContainer/core/solver/plugins/packing' {
    import { Rect } from "CharticulatorContainer/container";
    import { AxisMode } from "CharticulatorContainer/core/prototypes/plot_segments/axis";
    import { ConstraintPlugin, ConstraintSolver, Variable } from "CharticulatorContainer/core/solver/abstract";
    export interface PackingPluginOptions {
        gravityX: number;
        gravityY: number;
        boxed?: Rect;
    }
    export class PackingPlugin extends ConstraintPlugin {
        solver: ConstraintSolver;
        cx: Variable;
        cy: Variable;
        points: [Variable, Variable, number][];
        xEnable: boolean;
        yEnable: boolean;
        getXYScale: () => {
            x: number;
            y: number;
        };
        gravityX?: number;
        gravityY?: number;
        boxed?: Rect;
        constructor(solver: ConstraintSolver, cx: Variable, cy: Variable, points: [Variable, Variable, number][], axisOnly?: AxisMode, getXYScale?: () => {
            x: number;
            y: number;
        }, options?: PackingPluginOptions);
        apply(): boolean;
    }
}

declare module 'CharticulatorContainer/core/solver/plugins/polar_coordinator' {
    import { Specification } from "CharticulatorContainer/core";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    import { PolarGuideCoordinatorAttributesExtend } from "CharticulatorContainer/core/prototypes/guides/polar_coordinator";
    import { ConstraintPlugin, ConstraintSolver, Variable } from "CharticulatorContainer/core/solver/abstract";
    export interface PolarCoordinatorPluginOptions {
    }
    export class PolarCoordinatorPlugin extends ConstraintPlugin {
        solver: ConstraintSolver;
        cx: Variable;
        cy: Variable;
        an: Variable[];
        attrs: PolarGuideCoordinatorAttributesExtend;
        radialVarable: Variable[];
        angleVarable: Variable[];
        chartConstraints: Specification.Constraint[];
        coordinatoObjectID: string;
        chartMananger: ChartStateManager;
        constructor(solver: ConstraintSolver, cx: Variable, cy: Variable, radialVarable: Variable[], angleVarable: Variable[], attrs: PolarGuideCoordinatorAttributesExtend, chartConstraints: Specification.Constraint[], coordinatoObjectID: string, chartMananger: ChartStateManager);
        apply(): boolean;
    }
}

declare module 'CharticulatorContainer/core/solver/plugins/polar_plotsegment' {
    import { ConstraintPlugin } from "CharticulatorContainer/core/solver/abstract";
    import { PolarAttributes, PolarProperties } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/polar";
    import { Constraint } from "CharticulatorContainer/core/specification";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    export class PolarPlotSegmentPlugin extends ConstraintPlugin {
        constructor(attrs: PolarAttributes, chartConstraints: Constraint[], objectID: string, manager: ChartStateManager, properties: PolarProperties);
        apply(): boolean;
    }
}

declare module 'CharticulatorContainer/core/solver/plugins/jitter' {
    import { AxisMode } from "CharticulatorContainer/core/prototypes/plot_segments/axis";
    import { ConstraintPlugin, ConstraintSolver, Variable } from "CharticulatorContainer/core/solver/abstract";
    export interface JitterPluginOptions {
        vertical: boolean;
        horizontal: boolean;
    }
    export class JitterPlugin extends ConstraintPlugin {
        solver: ConstraintSolver;
        x1: Variable;
        y1: Variable;
        x2: Variable;
        y2: Variable;
        points: [Variable, Variable, number][];
        xEnable: boolean;
        yEnable: boolean;
        getXYScale: () => {
            x: number;
            y: number;
        };
        options?: JitterPluginOptions;
        constructor(solver: ConstraintSolver, x1: Variable, y1: Variable, x2: Variable, y2: Variable, points: [Variable, Variable, number][], axisOnly?: AxisMode, options?: JitterPluginOptions);
        apply(): boolean;
    }
}

declare module 'CharticulatorContainer/core/specification/index' {
    import { Color, Point } from "CharticulatorContainer/core/common";
    import * as Template from "CharticulatorContainer/core/specification/template";
    import * as Types from "CharticulatorContainer/core/specification/types";
    import { Specification } from "CharticulatorContainer/container";
    export { Types, Template };
    /** Objects with an unique ID */
    export interface Identifiable {
            /** Unique ID */
            _id: string;
    }
    /** Supported data value types */
    export type DataValue = number | string | boolean;
    /** Data type in memory */
    export enum DataType {
            /** String data type, stored as string */
            String = "string",
            /** Number data type, stored as number */
            Number = "number",
            /** Boolean data type, stored as boolean */
            Boolean = "boolean",
            /** Date data type, stored as unix timestamps (ms) */
            Date = "date",
            /** Image data as base64 string */
            Image = "image"
    }
    /** Abstract data kind */
    export enum DataKind {
            /** Ordinal data kind */
            Ordinal = "ordinal",
            /** Categorical data kind */
            Categorical = "categorical",
            /** Numerical data kind */
            Numerical = "numerical",
            /** Temporal data kind */
            Temporal = "temporal"
    }
    /** Data row */
    export interface DataRow {
            _id: string;
            [name: string]: DataValue;
    }
    export type Expression = string;
    export enum AttributeType {
            Number = "number",
            Enum = "enum",
            Text = "text",
            Boolean = "boolean",
            FontFamily = "font-family",
            Color = "color",
            Image = "image",
            Point = "point",
            Object = "object"
    }
    /** Attribute value types */
    export type AttributeValue = number | string | boolean | Color | Point | AttributeList | AttributeMap | Specification.Chart;
    /** Attribute value list */
    export interface AttributeList extends ArrayLike<AttributeValue> {
    }
    /** Attribute value map */
    export interface AttributeMap {
            [name: string]: AttributeValue;
    }
    /** Attribute mappings */
    export interface Mappings {
            [name: string]: Mapping;
    }
    export enum MappingType {
            _element = "_element",
            parent = "parent",
            scale = "scale",
            expressionScale = "expressionScale",
            text = "text",
            value = "value"
    }
    /** Attribute mapping */
    export interface Mapping {
            /** Mapping type */
            type: MappingType;
    }
    export type baselineH = "left" | "center" | "right";
    export type baselineV = "top" | "middle" | "bottom";
    export type baseline = baselineH | baselineV;
    /** Scale mapping: use a scale */
    export interface ScaleMapping extends Mapping {
            type: MappingType.scale;
            /** The table to draw data from */
            table: string;
            /** The data column */
            expression: Expression;
            /** Attribute of the mark */
            attribute?: string;
            /** Value type returned by the expression */
            valueType: DataType;
            /** The id of the scale to use. If null, use the expression directly */
            scale?: string;
            /** Index of value in mapping */
            valueIndex?: number;
    }
    /** Scale mapping: map id column data to image */
    export interface ScaleValueExpressionMapping {
            type: MappingType.expressionScale;
            /** The table to draw data from */
            table: string;
            /** The id column */
            expression: Expression;
            /** The data column */
            valueExpression: Expression;
            /** Attribute of the mark */
            attribute?: string;
            /** Value type returned by the expression */
            valueType: DataType;
            /** The id of the scale to use. If null, use the expression directly */
            scale?: string;
    }
    /** Text mapping: map data to text */
    export interface TextMapping extends Mapping {
            type: MappingType.text;
            /** The table to draw data from */
            table: string;
            /** The text expression */
            textExpression: string;
    }
    /** Value mapping: a constant value */
    export interface ValueMapping extends Mapping {
            type: MappingType.value;
            /** The constant value */
            value: AttributeValue;
    }
    /** Parent mapping: use an attribute of the item's parent item */
    export interface ParentMapping extends Mapping {
            type: MappingType.parent;
            /** The attribute of the parent item */
            parentAttribute: string;
    }
    /** Snapping element mapping: use an attribute of another element */
    export interface SnappingElementMapping extends Mapping {
            type: MappingType._element;
            element: string;
            attribute: string;
    }
    export interface ConstraintAttributes {
            gap?: number;
            element: string;
            attribute: string;
            targetElement: string;
            targetAttribute: string;
    }
    /** Constraint */
    export interface Constraint {
            /** Constraint type */
            type: string;
            attributes: ConstraintAttributes;
    }
    /** Object attributes */
    export interface ObjectProperties extends AttributeMap {
            /** The name of the object, used in UI */
            name?: string;
            visible?: boolean;
            emphasisMethod?: EmphasisMethod;
    }
    /** General object */
    export interface Object<PropertiesType extends ObjectProperties = ObjectProperties> extends Identifiable {
            /** The class ID for the Object */
            classID: string;
            /** Attributes  */
            properties: PropertiesType;
            /** Scale attribute mappings */
            mappings: Mappings;
    }
    export interface ExposableObject extends Object {
            exposed: boolean;
    }
    /** Element: a single graphical mark, such as rect, circle, wedge; an element is driven by a group of data rows */
    export interface Element<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** Glyph: a compound of elements, with constraints between them; a glyph is driven by a group of data rows */
    export interface Glyph<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            /** The data table this mark correspond to */
            table: string;
            /** Elements within the mark */
            marks: Element[];
            /** Layout constraints for this mark */
            constraints: Constraint[];
    }
    /** Scale */
    export interface Scale<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            inputType: DataType;
            outputType: AttributeType;
    }
    /** MarkLayout: the "PlotSegment" */
    export interface PlotSegment<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            /** The mark to use */
            glyph: string;
            /** The data table to get data rows from */
            table: string;
            /** Filter applied to the data table */
            filter?: Types.Filter;
            /** Group the data by a specified categorical column (filter is applied before grouping) */
            groupBy?: Types.GroupBy;
            /** Order the data (filter & groupBy is applied before order */
            order?: Types.SortBy;
    }
    /** Guide */
    export interface Guide<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** Guide Coordinator */
    export interface GuideCoordinator<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** Links */
    export interface Links<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
    }
    /** ChartElement is a PlotSegment or a Guide */
    export type ChartElement<PropertiesType extends ObjectProperties = ObjectProperties> = PlotSegment<PropertiesType> | Guide<PropertiesType> | GuideCoordinator<PropertiesType>;
    /** Resource item */
    export interface Resource {
            /** Resource item ID */
            id: string;
            /** Resource type: image */
            type: string;
            /** Resource data */
            data: any;
    }
    /** A chart is a set of chart elements and constraints between them, with guides and scales */
    export interface Chart<PropertiesType extends ObjectProperties = ObjectProperties> extends Object<PropertiesType> {
            /** Marks */
            glyphs: Glyph[];
            /** Scales */
            scales: Scale[];
            /**
                * Temporary structure to save created scales for reusing instead creating new.
                * Unused scales will be removed on save
                */
            scaleMappings: ScaleMapping[];
            /** Chart elements */
            elements: ChartElement[];
            /** Chart-level constraints */
            constraints: Constraint[];
            /** Resources */
            resources: Resource[];
    }
    /** General object state */
    export interface ObjectState<AttributesType extends AttributeMap = AttributeMap> {
            attributes: AttributesType;
    }
    /** Element state */
    export interface MarkState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
    }
    /** Scale state */
    export interface ScaleState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
    }
    /** Glyph state */
    export interface GlyphState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
            marks: MarkState[];
            /** Should this specific glyph instance be emphasized */
            emphasized?: boolean;
    }
    /** PlotSegment state */
    export interface PlotSegmentState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
            glyphs: GlyphState[];
            dataRowIndices: number[][];
    }
    /** Guide state */
    export interface GuideState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
    }
    /** Chart element state, one of PlotSegmentState or GuideState */
    export type ChartElementState<AttributesType extends AttributeMap = AttributeMap> = PlotSegmentState<AttributesType> | GuideState<AttributesType> | MarkState<AttributesType>;
    /** Chart state */
    export interface ChartState<AttributesType extends AttributeMap = AttributeMap> extends ObjectState<AttributesType> {
            /** Mark binding states corresponding to Chart.marks */
            elements: ChartElementState[];
            /** Scale states corresponding to Chart.scales */
            scales: ScaleState[];
            scaleMappings: ScaleMapping[];
    }
    /**
        * Represents the type of method to use when emphasizing an element
        */
    export enum EmphasisMethod {
            Saturation = "saturation",
            Outline = "outline"
    }
}

declare module 'CharticulatorContainer/core/prototypes/marks/emphasis' {
    import { Style } from "CharticulatorContainer/core/graphics";
    import { MarkClass } from "CharticulatorContainer/core/prototypes/marks/mark";
    import { ObjectClass } from "CharticulatorContainer/core/prototypes/object";
    import { ObjectState, EmphasisMethod, AttributeMap } from "CharticulatorContainer/core/specification";
    import { Specification } from "CharticulatorContainer/container";
    export const DEFAULT_EMPHASIS_STROKE_COLOR: {
            r: number;
            g: number;
            b: number;
    };
    export const DEFAULT_EMPHASIS_STROKE_WIDTH = 1;
    export const DEFAULT_POWER_BI_OPACITY = 0.4;
    /**
        * Represents a mark class that is emphasizable
        */
    export abstract class EmphasizableMarkClass<PropertiesType extends AttributeMap = AttributeMap, AttributesType extends AttributeMap = AttributeMap> extends MarkClass<PropertiesType, AttributesType> {
            constructor(parent: ObjectClass, object: Specification.Object<PropertiesType>, state: ObjectState<AttributesType>, defaultMethod?: EmphasisMethod);
            /**
                * Generates styling info for styling emphasized marks
                * @param emphasize If true, emphasis will be applied.
                */
            protected generateEmphasisStyle(emphasize?: boolean): Style;
    }
}

declare module 'CharticulatorContainer/core/prototypes/marks/symbol.attrs' {
    import { AttributeDescriptions } from "CharticulatorContainer/core/prototypes/object";
    import { Color } from "CharticulatorContainer/core/common";
    import { AttributeMap } from "CharticulatorContainer/core/specification/index";
    export const symbolTypes: string[];
    export const symbolAttributes: AttributeDescriptions;
    export interface SymbolElementAttributes extends AttributeMap {
        x: number;
        y: number;
        size: number;
        fill: Color;
        stroke: Color;
        strokeWidth: number;
        opacity: number;
        visible: boolean;
        symbol: string;
    }
    export interface SymbolElementProperties extends AttributeMap {
        visible: boolean;
        rotation: number;
    }
}

declare module 'CharticulatorContainer/core/index' {
    /**
      * # Core documentation
      *
      * ## Actions {@link "core/actions/index"}
      * The module contains all actions available in the charticulator.
      *
      * ## Common {@link "core/common/index"}
      *
      * Contains several modules such as
      *
      * * {@link "core/common/color"} to work with colors
      * * {@link "core/common/events"} event bus uses for notifying different parts of UI about updates.
      * * {@link "core/common/fetch"}
      * * {@link "core/common/math"} contains math operations for geometry
      * * {@link "core/common/scales"} scales for map data values to properties of graphic elements
      * * {@link "core/common/unique_id"} id generator for all objects used in charticulator
      * * {@link "core/common/utils"} contains different helper functions
      *
      * ## Dataset {@link "core/dataset/index"}
      *
      * The module is responsible for loading data from *.csv/*.tsv files and parse them
      *
      * ## Expression {@link "core/expression/index"}
      *
      * Describes all supported expressions in the charticulator and helper functions for process date on binding to elements
      *
      * ## Graphics {@link "core/graphics/index"}
      *
      * Contains logic responsible  for rendering elements and coordinate systems
      *
      * ## Prototypes {@link "core/prototypes/index"}
      *
      * Contains bricks of the chart: *Marks*({@link "core/prototypes/marks/index"}) (rect, image, symbol, text e.t.c.), Legends, Links, Plot Segments e.t.c
      *
      * * Declares the properties and attributes of a class of object (chart, chart element, glyph, mark) in the spec
      *
      * * Including default attribute values and property values
      *
      * * Generate graphical elements (if any) for ChartRenderer
      *
      * * Generate constraints (if any) for the constraint solver
      *
      * * Declare widgets (if any) for the attribute panel
      *
      * ### Difference between “attribute” and “property”
      *
      * Attribute (e.g., height on a rect mark):
      *
      * * Defined on the object state (an object can have multiple instances, each instance has its own state)
      * * Variable among the instances of the object
      * * Can involve in constraint solving
      * * Can be bound to data
      *
      * Property (e.g., anchor on a text mark):
      *
      * * Defined directly on the object specification
      * * Same across all instances of the object
      * * Does not involve in constraint solving
      * * Cannot be bound to data
      *
      * ## Solver {@link "core/solver/index"}
      *
      * Wrapping over lscg-solver package to convert chart co constrains.
      *
      * ## Specification {@link "core/specification/index"}
      *
      * It contains interfaces for the chart template. The template describes the internal structure of the chart.
      *
      * ## Store {@link "core/store/base"}
      *
      * @packageDocumentation
      * @preferred
      */
    export * from "CharticulatorContainer/core/common";
    export { CharticulatorCoreConfig, getConfig } from "CharticulatorContainer/core/config";
    import * as Dataset from "CharticulatorContainer/core/dataset";
    import * as Expression from "CharticulatorContainer/core/expression";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import * as Prototypes from "CharticulatorContainer/core/prototypes";
    import * as Solver from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import * as Utils from "CharticulatorContainer/core/common/utils";
    import * as ColorUtils from "CharticulatorContainer/core/common/color";
    export * from "CharticulatorContainer/core/actions";
    export { Expression, Specification, Prototypes, Solver, Graphics, Dataset, Utils, ColorUtils, };
    import { CharticulatorCoreConfig } from "CharticulatorContainer/core/config";
    export function initialize(config?: CharticulatorCoreConfig): Promise<void>;
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/region_2d/base' {
    import * as Expression from "CharticulatorContainer/core/expression";
    import { ConstraintSolver, ConstraintStrength, Variable } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { BuildConstraintsContext, Controls } from "CharticulatorContainer/core/prototypes/common";
    import { DataflowTable } from "CharticulatorContainer/core/prototypes/dataflow";
    import { AxisMode } from "CharticulatorContainer/core/prototypes/plot_segments/axis";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments/plot_segment";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes/state";
    export enum Region2DSublayoutType {
            Overlap = "overlap",
            DodgeX = "dodge-x",
            DodgeY = "dodge-y",
            Grid = "grid",
            Packing = "packing",
            Jitter = "jitter"
    }
    export enum SublayoutAlignment {
            Start = "start",
            Middle = "middle",
            End = "end"
    }
    export enum GridDirection {
            X = "x",
            Y = "y"
    }
    export enum GridStartPosition {
            LeftTop = "LT",
            RightTop = "RT",
            LeftBottom = "LB",
            RigtBottom = "RB"
    }
    export interface Region2DSublayoutOptions extends Specification.AttributeMap {
            type: Region2DSublayoutType;
            /** Sublayout alignment (for dodge and grid) */
            align: {
                    x: SublayoutAlignment;
                    y: SublayoutAlignment;
            };
            ratioX: number;
            ratioY: number;
            /** Grid options */
            grid?: {
                    /** Grid direction */
                    direction: GridDirection;
                    /** Number of glyphs in X direction (direction == "x") */
                    xCount?: number;
                    /** Number of glyphs in Y direction (direction == "x") */
                    yCount?: number;
                    /** Position of the first glyph in grid */
                    gridStartPosition: GridStartPosition;
            };
            /** Order in sublayout objects */
            order: Specification.Types.SortBy;
            orderReversed: boolean;
            /** packing options */
            packing: {
                    gravityX: number;
                    gravityY: number;
                    boxedX: boolean;
                    boxedY: boolean;
            };
            jitter: {
                    vertical: boolean;
                    horizontal: boolean;
            };
    }
    export interface Region2DAttributes extends Specification.AttributeMap {
            /** Horizontal/vertical line guide line position */
            x?: number;
            y?: number;
            gapX?: number;
            gapY?: number;
    }
    export interface Region2DHandleDescription {
            type: "gap";
            gap?: {
                    property: Controls.Property;
                    axis: AxisMode;
                    reference: number;
                    value: number;
                    span: [number, number];
                    scale: number;
            };
    }
    export enum PlotSegmentAxisPropertyNames {
            xData = "xData",
            yData = "yData",
            axis = "axis"
    }
    export interface Region2DProperties extends Specification.AttributeMap {
            /** X axis data binding, set to null to remove the axis, set to { type: "none" } to keep the axis but don't bind data */
            xData?: Specification.Types.AxisDataBinding;
            /** Y axis data binding, set to null to remove the axis, set to { type: "none" } to keep the axis but don't bind data */
            yData?: Specification.Types.AxisDataBinding;
            sublayout: Region2DSublayoutOptions;
            marginX1?: number;
            marginX2?: number;
            marginY1?: number;
            marginY2?: number;
    }
    export interface Region2DConfigurationTerminology {
            xAxis: string;
            yAxis: string;
            /** Items alignments */
            xMin: string;
            xMiddle: string;
            xMax: string;
            yMin: string;
            yMiddle: string;
            yMax: string;
            /** Stack X */
            dodgeX: string;
            /** Stack Y */
            dodgeY: string;
            /** Grid */
            grid: string;
            gridDirectionX: string;
            gridDirectionY: string;
            /** Packing force layout */
            packing: string;
            overlap: string;
            jitter: string;
    }
    export interface Region2DConfigurationIcons {
            xMinIcon: string;
            xMiddleIcon: string;
            xMaxIcon: string;
            yMinIcon: string;
            yMiddleIcon: string;
            yMaxIcon: string;
            dodgeXIcon: string;
            dodgeYIcon: string;
            gridIcon: string;
            packingIcon: string;
            jitterIcon: string;
            overlapIcon: string;
    }
    export interface Region2DConfiguration {
            terminology: Region2DConfigurationTerminology;
            icons: Region2DConfigurationIcons;
            xAxisPrePostGap: boolean;
            yAxisPrePostGap: boolean;
            getXYScale?(): {
                    x: number;
                    y: number;
            };
    }
    export class CrossFitter {
            constructor(solver: ConstraintSolver, mode: "min" | "max");
            add(src: Variable, dst: Variable): void;
            addComplex(src: Variable, dst: [number, Variable][], dstBias?: number): void;
            addConstraint(w: ConstraintStrength): void;
    }
    export class DodgingFitters {
            xMin: CrossFitter;
            xMax: CrossFitter;
            yMin: CrossFitter;
            yMax: CrossFitter;
            constructor(solver: ConstraintSolver);
            addConstraint(w: ConstraintStrength): void;
    }
    /**
        * Describes variables for constraints group. Count of group matches with data cound
        */
    export class SublayoutGroup {
            group: number[];
            x1: Variable;
            y1: Variable;
            x2: Variable;
            y2: Variable;
    }
    export interface SublayoutContext {
            mode: "default" | "x-only" | "y-only" | "disabled";
            xAxisPrePostGap?: boolean;
            yAxisPrePostGap?: boolean;
    }
    /**
        * Class builds constrains for plot segments
        * The builder creates constraints depends on sublayout
        */
    export class Region2DConstraintBuilder {
            plotSegment: PlotSegmentClass<Region2DProperties, Region2DAttributes>;
            config: Region2DConfiguration;
            x1Name: string;
            x2Name: string;
            y1Name: string;
            y2Name: string;
            solver?: ConstraintSolver;
            solverContext?: BuildConstraintsContext;
            chartStateManager?: ChartStateManager;
            constructor(plotSegment: PlotSegmentClass<Region2DProperties, Region2DAttributes>, config: Region2DConfiguration, x1Name: string, x2Name: string, y1Name: string, y2Name: string, solver?: ConstraintSolver, solverContext?: BuildConstraintsContext, chartStateManager?: ChartStateManager);
            static defaultJitterPackingRadius: number;
            getTableContext(): DataflowTable;
            getExpression(expr: string): Expression.Expression;
            groupMarksByCategories(categories: {
                    expression: string;
                    categories: string[];
            }[]): number[][];
            orderMarkGroups(groups: SublayoutGroup[]): SublayoutGroup[];
            /** Make sure gapX correctly correspond to gapXRatio */
            gapX(length: number, ratio: number): void;
            /** Make sure gapY correctly correspond to gapYRatio */
            gapY(length: number, ratio: number): void;
            /**
                * Map elements according to numerical/categorical mapping
                */
            numericalMapping(axis: AxisMode): void;
            groupMarksByCategoricalMapping(axis: "x" | "y" | "xy"): number[][];
            categoricalMapping(axis: "x" | "y" | "xy", sublayoutContext: SublayoutContext): void;
            categoricalHandles(axis: "x" | "y" | "xy", sublayout: boolean): Region2DHandleDescription[];
            stacking(axis: AxisMode): void;
            fitGroups(groups: SublayoutGroup[], axis: "x" | "y" | "xy"): void;
            applySublayout(groups: SublayoutGroup[], axis: "x" | "y" | "xy", context: SublayoutContext): void;
            sublayoutDodging(groups: SublayoutGroup[], direction: GridDirection, enablePrePostGap: boolean): void;
            getGlyphPreSolveAttributes(rowIndices: number[]): {
                    [name: string]: number;
            };
            sublayoutGrid(groups: SublayoutGroup[], directionOverride?: string): void;
            sublayoutHandles(groups: {
                    group: number[];
                    x1: number;
                    y1: number;
                    x2: number;
                    y2: number;
            }[], enablePrePostGapX: boolean, enablePrePostGapY: boolean): Region2DHandleDescription[];
            sublayoutPacking(groups: SublayoutGroup[], axisOnly?: AxisMode): void;
            sublayoutJitter(groups: SublayoutGroup[], axisOnly?: AxisMode): void;
            getHandles(): Region2DHandleDescription[];
            build(): void;
            applicableSublayoutOptions(): {
                    value: Region2DSublayoutType;
                    label: string;
                    icon: string;
            }[];
            isSublayoutApplicable(): boolean;
            buildSublayoutWidgets(m: Controls.WidgetManager): any[];
            buildAxisWidgets(manager: Controls.WidgetManager, axisName: string, axis: "x" | "y"): Controls.Widget[];
            updatePlotSegment(): void;
            buildPanelWidgets(m: Controls.WidgetManager): Controls.Widget[];
            buildPopupWidgets(m: Controls.WidgetManager): Controls.Widget[];
    }
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/region_2d/cartesian' {
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { BuildConstraintsContext } from "CharticulatorContainer/core/prototypes/chart_element";
    import { AttributeDescription, BoundingBox, Controls, DropZones, Handles, ObjectClassMetadata, SnappingGuides, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { Region2DAttributes, Region2DConfiguration, Region2DConstraintBuilder, Region2DProperties } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/base";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments/plot_segment";
    import { ZoomInfo } from "CharticulatorContainer/core";
    export type CartesianAxisMode = "null" | "default" | "numerical" | "categorical";
    export type CartesianProperties = Region2DProperties;
    export interface CartesianAttributes extends Region2DAttributes {
        /** Cartesian plot segment region */
        x1: number;
        y1: number;
        x2: number;
        y2: number;
    }
    export interface CartesianState extends Specification.PlotSegmentState {
        attributes: CartesianAttributes;
    }
    export const config: Region2DConfiguration;
    export class CartesianPlotSegment extends PlotSegmentClass<CartesianProperties, CartesianAttributes> {
        static classID: string;
        static type: string;
        static metadata: ObjectClassMetadata;
        static defaultMappingValues: Specification.AttributeMap;
        static defaultProperties: CartesianProperties;
        readonly state: CartesianState;
        chartManager: ChartStateManager;
        attributeNames: string[];
        attributes: {
            [name: string]: AttributeDescription;
        };
        initializeState(): void;
        createBuilder(solver?: ConstraintSolver, context?: BuildConstraintsContext): Region2DConstraintBuilder;
        buildGlyphConstraints(solver: ConstraintSolver, context: BuildConstraintsContext): void;
        getBoundingBox(): BoundingBox.Description;
        getSnappingGuides(): SnappingGuides.Description[];
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
        getPopupEditor(manager: Controls.WidgetManager): Controls.PopupEditor;
        getGraphics(manager: ChartStateManager): Graphics.Group;
        getPlotSegmentBackgroundGraphics(manager: ChartStateManager): Graphics.Group;
        renderControls(manager: ChartStateManager, zoom: ZoomInfo): React.ReactElement<any>[];
        getDropZones(): DropZones.Description[];
        getAxisModes(): [CartesianAxisMode, CartesianAxisMode];
        getHandles(): Handles.Description[];
        getTemplateParameters(): TemplateParameters;
    }
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/region_2d/polar' {
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { AttributeDescription, BoundingBox, BuildConstraintsContext, Controls, DropZones, Handles, ObjectClassMetadata, SnappingGuides, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { Region2DAttributes, Region2DConfigurationIcons, Region2DConstraintBuilder, Region2DProperties } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/base";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments/plot_segment";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    export type PolarAxisMode = "null" | "default" | "numerical" | "categorical";
    export interface PolarAttributes extends Region2DAttributes {
        /** Cartesian plot segment region */
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        cx: number;
        cy: number;
        angle1: number;
        angle2: number;
        radial1: number;
        radial2: number;
        a1r1x: number;
        a1r1y: number;
        a1r2x: number;
        a1r2y: number;
        a2r1x: number;
        a2r1y: number;
        a2r2x: number;
        a2r2y: number;
    }
    export interface PolarState extends Specification.PlotSegmentState {
        attributes: PolarAttributes;
    }
    export interface PolarProperties extends Region2DProperties {
        startAngle: number;
        endAngle: number;
        innerRatio: number;
        outerRatio: number;
        equalizeArea: boolean;
        autoAlignment: boolean;
    }
    export interface PolarObject extends Specification.PlotSegment {
        properties: PolarProperties;
    }
    export const icons: Region2DConfigurationIcons;
    export class PolarPlotSegment extends PlotSegmentClass<PolarProperties, PolarAttributes> {
        static classID: string;
        static type: string;
        static metadata: ObjectClassMetadata;
        static defaultProperties: Specification.AttributeMap;
        readonly state: PolarState;
        readonly object: PolarObject;
        attributeNames: string[];
        attributes: {
            [name: string]: AttributeDescription;
        };
        initializeState(): void;
        createBuilder(solver?: ConstraintSolver, context?: BuildConstraintsContext): Region2DConstraintBuilder;
        buildConstraints(solver: ConstraintSolver, context: BuildConstraintsContext, manager: ChartStateManager): void;
        buildGlyphConstraints(solver: ConstraintSolver, context: BuildConstraintsContext): void;
        getBoundingBox(): BoundingBox.Description;
        getSnappingGuides(): SnappingGuides.Description[];
        getGraphics(manager: ChartStateManager): Graphics.Group;
        getPlotSegmentBackgroundGraphics(manager: ChartStateManager): Graphics.Group;
        getCoordinateSystem(): Graphics.CoordinateSystem;
        getDropZones(): DropZones.Description[];
        getAxisModes(): [PolarAxisMode, PolarAxisMode];
        getHandles(): Handles.Description[];
        getPopupEditor(manager: Controls.WidgetManager): Controls.PopupEditor;
        getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
        getTemplateParameters(): TemplateParameters;
    }
}

declare module 'CharticulatorContainer/core/prototypes/plot_segments/region_2d/curve' {
    import { Point } from "CharticulatorContainer/core/common";
    import * as Graphics from "CharticulatorContainer/core/graphics";
    import { ConstraintSolver } from "CharticulatorContainer/core/solver";
    import * as Specification from "CharticulatorContainer/core/specification";
    import { AttributeDescription, BoundingBox, BuildConstraintsContext, Controls, DropZones, Handles, ObjectClassMetadata, SnappingGuides, TemplateParameters } from "CharticulatorContainer/core/prototypes/common";
    import { Region2DAttributes, Region2DConfigurationIcons, Region2DConstraintBuilder, Region2DProperties } from "CharticulatorContainer/core/prototypes/plot_segments/region_2d/base";
    import { PlotSegmentClass } from "CharticulatorContainer/core/prototypes/plot_segments/plot_segment";
    import { ChartStateManager } from "CharticulatorContainer/core/prototypes";
    export type CurveAxisMode = "null" | "default" | "numerical" | "categorical";
    export interface CurveAttributes extends Region2DAttributes {
            /** Cartesian plot segment region */
            x1: number;
            y1: number;
            x2: number;
            y2: number;
            /**
                * The region in the curve coordinate system
                * tangent1, tangent2: the axis along the curve direction
                * normal1, normal2: the axis perpendicular to the curve direction (these won't be parallel to each other!)
                */
            tangent1: number;
            tangent2: number;
            normal1: number;
            normal2: number;
    }
    export interface CurveState extends Specification.PlotSegmentState {
            attributes: CurveAttributes;
    }
    export interface CurveProperties extends Region2DProperties {
            /** The bezier curve specification in relative proportions (-1, +1) => (x1, x2) */
            curve: [Point, Point, Point, Point][];
            normalStart: number;
            normalEnd: number;
    }
    export interface CurveObject extends Specification.PlotSegment {
            properties: CurveProperties;
    }
    export const icons: Region2DConfigurationIcons;
    export class CurvePlotSegment extends PlotSegmentClass<CurveProperties, CurveAttributes> {
            static classID: string;
            static type: string;
            static metadata: ObjectClassMetadata;
            static defaultProperties: Specification.AttributeMap;
            readonly state: CurveState;
            readonly object: CurveObject;
            attributeNames: string[];
            attributes: {
                    [name: string]: AttributeDescription;
            };
            initializeState(): void;
            createBuilder(solver?: ConstraintSolver, context?: BuildConstraintsContext): Region2DConstraintBuilder;
            getCurveArcLength(): number;
            buildConstraints(solver: ConstraintSolver, context: BuildConstraintsContext): void;
            buildGlyphConstraints(solver: ConstraintSolver, context: BuildConstraintsContext): void;
            getBoundingBox(): BoundingBox.Description;
            getSnappingGuides(): SnappingGuides.Description[];
            getGraphics(manager: ChartStateManager): Graphics.Group;
            getCoordinateSystem(): Graphics.CoordinateSystem;
            getDropZones(): DropZones.Description[];
            getAxisModes(): [CurveAxisMode, CurveAxisMode];
            getHandles(): Handles.Description[];
            getPopupEditor(manager: Controls.WidgetManager): Controls.PopupEditor;
            /**
                * Renders gridlines for axis. Returns empty array to diable widgets for curve plot segment.
                * Not implemented yet
                * @param data axis data binding
                * @param manager widgets manager
                * @param axisProperty property name of plotsegment with axis properties (xData, yData, axis)
                */
            buildGridLineWidgets(): Controls.Widget[];
            getAttributePanelWidgets(manager: Controls.WidgetManager): Controls.Widget[];
            getTemplateParameters(): TemplateParameters;
    }
}

