"""
Constants containing info about languages and countries.
"""

from typing import Set


LANGUAGE_CODES: Set[str] = {
    "aa",
    "ab",
    "ae",
    "af",
    "ak",
    "am",
    "an",
    "ar",
    "as",
    "av",
    "ay",
    "az",
    "ba",
    "be",
    "bg",
    "bh",
    "bi",
    "bm",
    "bn",
    "bo",
    "br",
    "bs",
    "ca",
    "ce",
    "ch",
    "co",
    "cr",
    "cs",
    "cu",
    "cv",
    "cy",
    "da",
    "de",
    "dv",
    "dz",
    "ee",
    "el",
    "en",
    "eo",
    "es",
    "et",
    "eu",
    "fa",
    "ff",
    "fi",
    "fj",
    "fo",
    "fr",
    "fy",
    "ga",
    "gd",
    "gl",
    "gn",
    "gu",
    "gv",
    "ha",
    "he",
    "hi",
    "ho",
    "hr",
    "ht",
    "hu",
    "hy",
    "hz",
    "ia",
    "id",
    "ie",
    "ig",
    "ii",
    "ik",
    "io",
    "is",
    "it",
    "iu",
    "ja",
    "jv",
    "ka",
    "kg",
    "ki",
    "kj",
    "kk",
    "kl",
    "km",
    "kn",
    "ko",
    "kr",
    "ks",
    "ku",
    "kv",
    "kw",
    "ky",
    "la",
    "lb",
    "lg",
    "li",
    "ln",
    "lo",
    "lt",
    "lu",
    "lv",
    "mg",
    "mh",
    "mi",
    "mk",
    "ml",
    "mn",
    "mr",
    "ms",
    "mt",
    "my",
    "na",
    "nb",
    "nd",
    "ne",
    "ng",
    "nl",
    "nn",
    "no",
    "nr",
    "nv",
    "ny",
    "oc",
    "oj",
    "om",
    "or",
    "os",
    "pa",
    "pi",
    "pl",
    "ps",
    "pt",
    "qu",
    "rm",
    "rn",
    "ro",
    "ru",
    "rw",
    "sa",
    "sc",
    "sd",
    "se",
    "sg",
    "si",
    "sk",
    "sl",
    "sm",
    "sn",
    "so",
    "sq",
    "sr",
    "ss",
    "st",
    "su",
    "sv",
    "sw",
    "ta",
    "te",
    "tg",
    "th",
    "ti",
    "tk",
    "tl",
    "tn",
    "to",
    "tr",
    "ts",
    "tt",
    "tw",
    "ty",
    "ug",
    "uk",
    "ur",
    "uz",
    "ve",
    "vi",
    "vo",
    "wa",
    "wo",
    "xh",
    "yi",
    "yo",
    "za",
    "zh",
    "zu",
}


COUNTRY_CODES: Set[str] = {
    "aw",
    "af",
    "ao",
    "ai",
    "ax",
    "al",
    "ad",
    "ae",
    "ar",
    "am",
    "as",
    "aq",
    "tf",
    "ag",
    "au",
    "at",
    "az",
    "bi",
    "be",
    "bj",
    "bq",
    "bf",
    "bd",
    "bg",
    "bh",
    "bs",
    "ba",
    "bl",
    "by",
    "bz",
    "bm",
    "bo",
    "br",
    "bb",
    "bn",
    "bt",
    "bv",
    "bw",
    "cf",
    "ca",
    "cc",
    "ch",
    "cl",
    "cn",
    "ci",
    "cm",
    "cd",
    "cg",
    "ck",
    "co",
    "km",
    "cv",
    "cr",
    "cu",
    "cw",
    "cx",
    "ky",
    "cy",
    "cz",
    "de",
    "dj",
    "dm",
    "dk",
    "do",
    "dz",
    "ec",
    "eg",
    "er",
    "eh",
    "es",
    "ee",
    "et",
    "fi",
    "fj",
    "fk",
    "fr",
    "fo",
    "fm",
    "ga",
    "gb",
    "ge",
    "gg",
    "gh",
    "gi",
    "gn",
    "gp",
    "gm",
    "gw",
    "gq",
    "gr",
    "gd",
    "gl",
    "gt",
    "gf",
    "gu",
    "gy",
    "hk",
    "hm",
    "hn",
    "hr",
    "ht",
    "hu",
    "id",
    "im",
    "in",
    "io",
    "ie",
    "ir",
    "iq",
    "is",
    "il",
    "it",
    "jm",
    "je",
    "jo",
    "jp",
    "kz",
    "ke",
    "kg",
    "kh",
    "ki",
    "kn",
    "kr",
    "kw",
    "la",
    "lb",
    "lr",
    "ly",
    "lc",
    "li",
    "lk",
    "ls",
    "lt",
    "lu",
    "lv",
    "mo",
    "mf",
    "ma",
    "mc",
    "md",
    "mg",
    "mv",
    "mx",
    "mh",
    "mk",
    "ml",
    "mt",
    "mm",
    "me",
    "mn",
    "mp",
    "mz",
    "mr",
    "ms",
    "mq",
    "mu",
    "mw",
    "my",
    "yt",
    "na",
    "nc",
    "ne",
    "nf",
    "ng",
    "ni",
    "nu",
    "nl",
    "no",
    "np",
    "nr",
    "nz",
    "om",
    "pk",
    "pa",
    "pn",
    "pe",
    "ph",
    "pw",
    "pg",
    "pl",
    "pr",
    "kp",
    "pt",
    "py",
    "ps",
    "pf",
    "qa",
    "re",
    "ro",
    "ru",
    "rw",
    "sa",
    "sd",
    "sn",
    "sg",
    "gs",
    "sh",
    "sj",
    "sb",
    "sl",
    "sv",
    "sm",
    "so",
    "pm",
    "rs",
    "ss",
    "st",
    "sr",
    "sk",
    "si",
    "se",
    "sz",
    "sx",
    "sc",
    "sy",
    "tc",
    "td",
    "tg",
    "th",
    "tj",
    "tk",
    "tm",
    "tl",
    "to",
    "tt",
    "tn",
    "tr",
    "tv",
    "tw",
    "tz",
    "ug",
    "ua",
    "um",
    "uy",
    "us",
    "uz",
    "va",
    "vc",
    "ve",
    "vg",
    "vi",
    "vn",
    "vu",
    "wf",
    "ws",
    "ye",
    "za",
    "zm",
    "zw",
    "abw",
    "afg",
    "ago",
    "aia",
    "ala",
    "alb",
    "and",
    "are",
    "arg",
    "arm",
    "asm",
    "ata",
    "atf",
    "atg",
    "aus",
    "aut",
    "aze",
    "bdi",
    "bel",
    "ben",
    "bes",
    "bfa",
    "bgd",
    "bgr",
    "bhr",
    "bhs",
    "bih",
    "blm",
    "blr",
    "blz",
    "bmu",
    "bol",
    "bra",
    "brb",
    "brn",
    "btn",
    "bvt",
    "bwa",
    "caf",
    "can",
    "cck",
    "che",
    "chl",
    "chn",
    "civ",
    "cmr",
    "cod",
    "cog",
    "cok",
    "col",
    "com",
    "cpv",
    "cri",
    "cub",
    "cuw",
    "cxr",
    "cym",
    "cyp",
    "cze",
    "deu",
    "dji",
    "dma",
    "dnk",
    "dom",
    "dza",
    "ecu",
    "egy",
    "eri",
    "esh",
    "esp",
    "est",
    "eth",
    "fin",
    "fji",
    "flk",
    "fra",
    "fro",
    "fsm",
    "gab",
    "gbr",
    "geo",
    "ggy",
    "gha",
    "gib",
    "gin",
    "glp",
    "gmb",
    "gnb",
    "gnq",
    "grc",
    "grd",
    "grl",
    "gtm",
    "guf",
    "gum",
    "guy",
    "hkg",
    "hmd",
    "hnd",
    "hrv",
    "hti",
    "hun",
    "idn",
    "imn",
    "ind",
    "iot",
    "irl",
    "irn",
    "irq",
    "isl",
    "isr",
    "ita",
    "jam",
    "jey",
    "jor",
    "jpn",
    "kaz",
    "ken",
    "kgz",
    "khm",
    "kir",
    "kna",
    "kor",
    "kwt",
    "lao",
    "lbn",
    "lbr",
    "lby",
    "lca",
    "lie",
    "lka",
    "lso",
    "ltu",
    "lux",
    "lva",
    "mac",
    "maf",
    "mar",
    "mco",
    "mda",
    "mdg",
    "mdv",
    "mex",
    "mhl",
    "mkd",
    "mli",
    "mlt",
    "mmr",
    "mne",
    "mng",
    "mnp",
    "moz",
    "mrt",
    "msr",
    "mtq",
    "mus",
    "mwi",
    "mys",
    "myt",
    "nam",
    "ncl",
    "ner",
    "nfk",
    "nga",
    "nic",
    "niu",
    "nld",
    "nor",
    "npl",
    "nru",
    "nzl",
    "omn",
    "pak",
    "pan",
    "pcn",
    "per",
    "phl",
    "plw",
    "png",
    "pol",
    "pri",
    "prk",
    "prt",
    "pry",
    "pse",
    "pyf",
    "qat",
    "reu",
    "rou",
    "rus",
    "rwa",
    "sau",
    "sdn",
    "sen",
    "sgp",
    "sgs",
    "shn",
    "sjm",
    "slb",
    "sle",
    "slv",
    "smr",
    "som",
    "spm",
    "srb",
    "ssd",
    "stp",
    "sur",
    "svk",
    "svn",
    "swe",
    "swz",
    "sxm",
    "syc",
    "syr",
    "tca",
    "tcd",
    "tgo",
    "tha",
    "tjk",
    "tkl",
    "tkm",
    "tls",
    "ton",
    "tto",
    "tun",
    "tur",
    "tuv",
    "twn",
    "tza",
    "uga",
    "ukr",
    "umi",
    "ury",
    "usa",
    "uzb",
    "vat",
    "vct",
    "ven",
    "vgb",
    "vir",
    "vnm",
    "vut",
    "wlf",
    "wsm",
    "yem",
    "zaf",
    "zmb",
    "zwe",
}
