# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TaskDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'id_number': 'str',
        'project_id': 'int',
        'quote_id': 'int',
        'name': 'str',
        'client_task_po_number': 'str',
        'language_combination': 'CommonLanguageCombinationDTO',
        'dates': 'ProjectDatesDTO',
        'people': 'ClassicPeopleDTO',
        'instructions': 'InstructionsDTO',
        'custom_fields': 'list[CustomFieldDTO]',
        'finance': 'TaskFinanceDTO'
    }

    attribute_map = {
        'id': 'id',
        'id_number': 'idNumber',
        'project_id': 'projectId',
        'quote_id': 'quoteId',
        'name': 'name',
        'client_task_po_number': 'clientTaskPONumber',
        'language_combination': 'languageCombination',
        'dates': 'dates',
        'people': 'people',
        'instructions': 'instructions',
        'custom_fields': 'customFields',
        'finance': 'finance'
    }

    def __init__(self, id=None, id_number=None, project_id=None, quote_id=None, name=None, client_task_po_number=None, language_combination=None, dates=None, people=None, instructions=None, custom_fields=None, finance=None):  # noqa: E501
        """TaskDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._id_number = None
        self._project_id = None
        self._quote_id = None
        self._name = None
        self._client_task_po_number = None
        self._language_combination = None
        self._dates = None
        self._people = None
        self._instructions = None
        self._custom_fields = None
        self._finance = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if id_number is not None:
            self.id_number = id_number
        if project_id is not None:
            self.project_id = project_id
        if quote_id is not None:
            self.quote_id = quote_id
        if name is not None:
            self.name = name
        if client_task_po_number is not None:
            self.client_task_po_number = client_task_po_number
        if language_combination is not None:
            self.language_combination = language_combination
        if dates is not None:
            self.dates = dates
        if people is not None:
            self.people = people
        if instructions is not None:
            self.instructions = instructions
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if finance is not None:
            self.finance = finance

    @property
    def id(self):
        """Gets the id of this TaskDTO.  # noqa: E501

        internal identifier  # noqa: E501

        :return: The id of this TaskDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TaskDTO.

        internal identifier  # noqa: E501

        :param id: The id of this TaskDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def id_number(self):
        """Gets the id_number of this TaskDTO.  # noqa: E501

        identifier  # noqa: E501

        :return: The id_number of this TaskDTO.  # noqa: E501
        :rtype: str
        """
        return self._id_number

    @id_number.setter
    def id_number(self, id_number):
        """Sets the id_number of this TaskDTO.

        identifier  # noqa: E501

        :param id_number: The id_number of this TaskDTO.  # noqa: E501
        :type: str
        """

        self._id_number = id_number

    @property
    def project_id(self):
        """Gets the project_id of this TaskDTO.  # noqa: E501

        project's internal identifier  # noqa: E501

        :return: The project_id of this TaskDTO.  # noqa: E501
        :rtype: int
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this TaskDTO.

        project's internal identifier  # noqa: E501

        :param project_id: The project_id of this TaskDTO.  # noqa: E501
        :type: int
        """

        self._project_id = project_id

    @property
    def quote_id(self):
        """Gets the quote_id of this TaskDTO.  # noqa: E501

        quote's internal identifier  # noqa: E501

        :return: The quote_id of this TaskDTO.  # noqa: E501
        :rtype: int
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """Sets the quote_id of this TaskDTO.

        quote's internal identifier  # noqa: E501

        :param quote_id: The quote_id of this TaskDTO.  # noqa: E501
        :type: int
        """

        self._quote_id = quote_id

    @property
    def name(self):
        """Gets the name of this TaskDTO.  # noqa: E501

        name  # noqa: E501

        :return: The name of this TaskDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TaskDTO.

        name  # noqa: E501

        :param name: The name of this TaskDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def client_task_po_number(self):
        """Gets the client_task_po_number of this TaskDTO.  # noqa: E501

        client task PO number  # noqa: E501

        :return: The client_task_po_number of this TaskDTO.  # noqa: E501
        :rtype: str
        """
        return self._client_task_po_number

    @client_task_po_number.setter
    def client_task_po_number(self, client_task_po_number):
        """Sets the client_task_po_number of this TaskDTO.

        client task PO number  # noqa: E501

        :param client_task_po_number: The client_task_po_number of this TaskDTO.  # noqa: E501
        :type: str
        """

        self._client_task_po_number = client_task_po_number

    @property
    def language_combination(self):
        """Gets the language_combination of this TaskDTO.  # noqa: E501


        :return: The language_combination of this TaskDTO.  # noqa: E501
        :rtype: CommonLanguageCombinationDTO
        """
        return self._language_combination

    @language_combination.setter
    def language_combination(self, language_combination):
        """Sets the language_combination of this TaskDTO.


        :param language_combination: The language_combination of this TaskDTO.  # noqa: E501
        :type: CommonLanguageCombinationDTO
        """

        self._language_combination = language_combination

    @property
    def dates(self):
        """Gets the dates of this TaskDTO.  # noqa: E501


        :return: The dates of this TaskDTO.  # noqa: E501
        :rtype: ProjectDatesDTO
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this TaskDTO.


        :param dates: The dates of this TaskDTO.  # noqa: E501
        :type: ProjectDatesDTO
        """

        self._dates = dates

    @property
    def people(self):
        """Gets the people of this TaskDTO.  # noqa: E501


        :return: The people of this TaskDTO.  # noqa: E501
        :rtype: ClassicPeopleDTO
        """
        return self._people

    @people.setter
    def people(self, people):
        """Sets the people of this TaskDTO.


        :param people: The people of this TaskDTO.  # noqa: E501
        :type: ClassicPeopleDTO
        """

        self._people = people

    @property
    def instructions(self):
        """Gets the instructions of this TaskDTO.  # noqa: E501


        :return: The instructions of this TaskDTO.  # noqa: E501
        :rtype: InstructionsDTO
        """
        return self._instructions

    @instructions.setter
    def instructions(self, instructions):
        """Sets the instructions of this TaskDTO.


        :param instructions: The instructions of this TaskDTO.  # noqa: E501
        :type: InstructionsDTO
        """

        self._instructions = instructions

    @property
    def custom_fields(self):
        """Gets the custom_fields of this TaskDTO.  # noqa: E501


        :return: The custom_fields of this TaskDTO.  # noqa: E501
        :rtype: list[CustomFieldDTO]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this TaskDTO.


        :param custom_fields: The custom_fields of this TaskDTO.  # noqa: E501
        :type: list[CustomFieldDTO]
        """

        self._custom_fields = custom_fields

    @property
    def finance(self):
        """Gets the finance of this TaskDTO.  # noqa: E501


        :return: The finance of this TaskDTO.  # noqa: E501
        :rtype: TaskFinanceDTO
        """
        return self._finance

    @finance.setter
    def finance(self, finance):
        """Sets the finance of this TaskDTO.


        :param finance: The finance of this TaskDTO.  # noqa: E501
        :type: TaskFinanceDTO
        """

        self._finance = finance

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
