# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProviderDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'id_number': 'str',
        'name': 'str',
        'full_name': 'str',
        'notes': 'str',
        'billing_address': 'AddressDTO',
        'correspondence_address': 'AddressDTO',
        'contact': 'ContactDTO',
        'branch_id': 'int',
        'lead_source_id': 'int',
        'custom_fields': 'list[CustomFieldDTO]',
        'status': 'str',
        'competencies': 'CompetenciesDTO',
        'persons': 'list[ProviderPersonDTO]'
    }

    attribute_map = {
        'id': 'id',
        'id_number': 'idNumber',
        'name': 'name',
        'full_name': 'fullName',
        'notes': 'notes',
        'billing_address': 'billingAddress',
        'correspondence_address': 'correspondenceAddress',
        'contact': 'contact',
        'branch_id': 'branchId',
        'lead_source_id': 'leadSourceId',
        'custom_fields': 'customFields',
        'status': 'status',
        'competencies': 'competencies',
        'persons': 'persons'
    }

    def __init__(self, id=None, id_number=None, name=None, full_name=None, notes=None, billing_address=None, correspondence_address=None, contact=None, branch_id=None, lead_source_id=None, custom_fields=None, status=None, competencies=None, persons=None):  # noqa: E501
        """ProviderDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._id_number = None
        self._name = None
        self._full_name = None
        self._notes = None
        self._billing_address = None
        self._correspondence_address = None
        self._contact = None
        self._branch_id = None
        self._lead_source_id = None
        self._custom_fields = None
        self._status = None
        self._competencies = None
        self._persons = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if id_number is not None:
            self.id_number = id_number
        if name is not None:
            self.name = name
        if full_name is not None:
            self.full_name = full_name
        if notes is not None:
            self.notes = notes
        if billing_address is not None:
            self.billing_address = billing_address
        if correspondence_address is not None:
            self.correspondence_address = correspondence_address
        if contact is not None:
            self.contact = contact
        if branch_id is not None:
            self.branch_id = branch_id
        if lead_source_id is not None:
            self.lead_source_id = lead_source_id
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if status is not None:
            self.status = status
        if competencies is not None:
            self.competencies = competencies
        if persons is not None:
            self.persons = persons

    @property
    def id(self):
        """Gets the id of this ProviderDTO.  # noqa: E501


        :return: The id of this ProviderDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProviderDTO.


        :param id: The id of this ProviderDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def id_number(self):
        """Gets the id_number of this ProviderDTO.  # noqa: E501


        :return: The id_number of this ProviderDTO.  # noqa: E501
        :rtype: str
        """
        return self._id_number

    @id_number.setter
    def id_number(self, id_number):
        """Sets the id_number of this ProviderDTO.


        :param id_number: The id_number of this ProviderDTO.  # noqa: E501
        :type: str
        """

        self._id_number = id_number

    @property
    def name(self):
        """Gets the name of this ProviderDTO.  # noqa: E501


        :return: The name of this ProviderDTO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProviderDTO.


        :param name: The name of this ProviderDTO.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def full_name(self):
        """Gets the full_name of this ProviderDTO.  # noqa: E501


        :return: The full_name of this ProviderDTO.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this ProviderDTO.


        :param full_name: The full_name of this ProviderDTO.  # noqa: E501
        :type: str
        """

        self._full_name = full_name

    @property
    def notes(self):
        """Gets the notes of this ProviderDTO.  # noqa: E501


        :return: The notes of this ProviderDTO.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this ProviderDTO.


        :param notes: The notes of this ProviderDTO.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def billing_address(self):
        """Gets the billing_address of this ProviderDTO.  # noqa: E501


        :return: The billing_address of this ProviderDTO.  # noqa: E501
        :rtype: AddressDTO
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """Sets the billing_address of this ProviderDTO.


        :param billing_address: The billing_address of this ProviderDTO.  # noqa: E501
        :type: AddressDTO
        """

        self._billing_address = billing_address

    @property
    def correspondence_address(self):
        """Gets the correspondence_address of this ProviderDTO.  # noqa: E501


        :return: The correspondence_address of this ProviderDTO.  # noqa: E501
        :rtype: AddressDTO
        """
        return self._correspondence_address

    @correspondence_address.setter
    def correspondence_address(self, correspondence_address):
        """Sets the correspondence_address of this ProviderDTO.


        :param correspondence_address: The correspondence_address of this ProviderDTO.  # noqa: E501
        :type: AddressDTO
        """

        self._correspondence_address = correspondence_address

    @property
    def contact(self):
        """Gets the contact of this ProviderDTO.  # noqa: E501


        :return: The contact of this ProviderDTO.  # noqa: E501
        :rtype: ContactDTO
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this ProviderDTO.


        :param contact: The contact of this ProviderDTO.  # noqa: E501
        :type: ContactDTO
        """

        self._contact = contact

    @property
    def branch_id(self):
        """Gets the branch_id of this ProviderDTO.  # noqa: E501


        :return: The branch_id of this ProviderDTO.  # noqa: E501
        :rtype: int
        """
        return self._branch_id

    @branch_id.setter
    def branch_id(self, branch_id):
        """Sets the branch_id of this ProviderDTO.


        :param branch_id: The branch_id of this ProviderDTO.  # noqa: E501
        :type: int
        """

        self._branch_id = branch_id

    @property
    def lead_source_id(self):
        """Gets the lead_source_id of this ProviderDTO.  # noqa: E501


        :return: The lead_source_id of this ProviderDTO.  # noqa: E501
        :rtype: int
        """
        return self._lead_source_id

    @lead_source_id.setter
    def lead_source_id(self, lead_source_id):
        """Sets the lead_source_id of this ProviderDTO.


        :param lead_source_id: The lead_source_id of this ProviderDTO.  # noqa: E501
        :type: int
        """

        self._lead_source_id = lead_source_id

    @property
    def custom_fields(self):
        """Gets the custom_fields of this ProviderDTO.  # noqa: E501


        :return: The custom_fields of this ProviderDTO.  # noqa: E501
        :rtype: list[CustomFieldDTO]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this ProviderDTO.


        :param custom_fields: The custom_fields of this ProviderDTO.  # noqa: E501
        :type: list[CustomFieldDTO]
        """

        self._custom_fields = custom_fields

    @property
    def status(self):
        """Gets the status of this ProviderDTO.  # noqa: E501


        :return: The status of this ProviderDTO.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ProviderDTO.


        :param status: The status of this ProviderDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "WAITING_FOR_APPROVAL", "REJECTED", "TOO_EXPENSIVE", "INCOMPLETE_DATA", "POTENTIAL", "NOT_CONFIRMED"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def competencies(self):
        """Gets the competencies of this ProviderDTO.  # noqa: E501


        :return: The competencies of this ProviderDTO.  # noqa: E501
        :rtype: CompetenciesDTO
        """
        return self._competencies

    @competencies.setter
    def competencies(self, competencies):
        """Sets the competencies of this ProviderDTO.


        :param competencies: The competencies of this ProviderDTO.  # noqa: E501
        :type: CompetenciesDTO
        """

        self._competencies = competencies

    @property
    def persons(self):
        """Gets the persons of this ProviderDTO.  # noqa: E501


        :return: The persons of this ProviderDTO.  # noqa: E501
        :rtype: list[ProviderPersonDTO]
        """
        return self._persons

    @persons.setter
    def persons(self, persons):
        """Sets the persons of this ProviderDTO.


        :param persons: The persons of this ProviderDTO.  # noqa: E501
        :type: list[ProviderPersonDTO]
        """

        self._persons = persons

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProviderDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
