# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetKubernetesClusterResult',
    'AwaitableGetKubernetesClusterResult',
    'get_kubernetes_cluster',
    'get_kubernetes_cluster_output',
]

@pulumi.output_type
class GetKubernetesClusterResult:
    """
    A collection of values returned by getKubernetesCluster.
    """
    def __init__(__self__, admission_plugins=None, apiserver_cert_sans=None, apiserver_url=None, auto_upgrades=None, autoscaler_configs=None, cluster_id=None, cni=None, created_at=None, description=None, feature_gates=None, id=None, kubeconfigs=None, name=None, open_id_connect_configs=None, organization_id=None, project_id=None, region=None, status=None, tags=None, type=None, updated_at=None, upgrade_available=None, version=None, wildcard_dns=None):
        if admission_plugins and not isinstance(admission_plugins, list):
            raise TypeError("Expected argument 'admission_plugins' to be a list")
        pulumi.set(__self__, "admission_plugins", admission_plugins)
        if apiserver_cert_sans and not isinstance(apiserver_cert_sans, list):
            raise TypeError("Expected argument 'apiserver_cert_sans' to be a list")
        pulumi.set(__self__, "apiserver_cert_sans", apiserver_cert_sans)
        if apiserver_url and not isinstance(apiserver_url, str):
            raise TypeError("Expected argument 'apiserver_url' to be a str")
        pulumi.set(__self__, "apiserver_url", apiserver_url)
        if auto_upgrades and not isinstance(auto_upgrades, list):
            raise TypeError("Expected argument 'auto_upgrades' to be a list")
        pulumi.set(__self__, "auto_upgrades", auto_upgrades)
        if autoscaler_configs and not isinstance(autoscaler_configs, list):
            raise TypeError("Expected argument 'autoscaler_configs' to be a list")
        pulumi.set(__self__, "autoscaler_configs", autoscaler_configs)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cni and not isinstance(cni, str):
            raise TypeError("Expected argument 'cni' to be a str")
        pulumi.set(__self__, "cni", cni)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_gates and not isinstance(feature_gates, list):
            raise TypeError("Expected argument 'feature_gates' to be a list")
        pulumi.set(__self__, "feature_gates", feature_gates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubeconfigs and not isinstance(kubeconfigs, list):
            raise TypeError("Expected argument 'kubeconfigs' to be a list")
        pulumi.set(__self__, "kubeconfigs", kubeconfigs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if open_id_connect_configs and not isinstance(open_id_connect_configs, list):
            raise TypeError("Expected argument 'open_id_connect_configs' to be a list")
        pulumi.set(__self__, "open_id_connect_configs", open_id_connect_configs)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if upgrade_available and not isinstance(upgrade_available, bool):
            raise TypeError("Expected argument 'upgrade_available' to be a bool")
        pulumi.set(__self__, "upgrade_available", upgrade_available)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if wildcard_dns and not isinstance(wildcard_dns, str):
            raise TypeError("Expected argument 'wildcard_dns' to be a str")
        pulumi.set(__self__, "wildcard_dns", wildcard_dns)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> Sequence[str]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) enabled on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> Sequence[str]:
        return pulumi.get(self, "apiserver_cert_sans")

    @property
    @pulumi.getter(name="apiserverUrl")
    def apiserver_url(self) -> str:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "apiserver_url")

    @property
    @pulumi.getter(name="autoUpgrades")
    def auto_upgrades(self) -> Sequence['outputs.GetKubernetesClusterAutoUpgradeResult']:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrades")

    @property
    @pulumi.getter(name="autoscalerConfigs")
    def autoscaler_configs(self) -> Sequence['outputs.GetKubernetesClusterAutoscalerConfigResult']:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_configs")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def cni(self) -> str:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        """
        return pulumi.get(self, "cni")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The creation date of the cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Sequence[str]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) enabled on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kubeconfigs(self) -> Sequence['outputs.GetKubernetesClusterKubeconfigResult']:
        return pulumi.get(self, "kubeconfigs")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openIdConnectConfigs")
    def open_id_connect_configs(self) -> Sequence['outputs.GetKubernetesClusterOpenIdConnectConfigResult']:
        return pulumi.get(self, "open_id_connect_configs")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The ID of the organization the cluster is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region in which the cluster is.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the Kubernetes cluster.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The last update date of the cluster.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> bool:
        """
        True if a newer Kubernetes version is available.
        """
        return pulumi.get(self, "upgrade_available")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="wildcardDns")
    def wildcard_dns(self) -> str:
        """
        The DNS wildcard that points to all ready nodes.
        """
        return pulumi.get(self, "wildcard_dns")


class AwaitableGetKubernetesClusterResult(GetKubernetesClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesClusterResult(
            admission_plugins=self.admission_plugins,
            apiserver_cert_sans=self.apiserver_cert_sans,
            apiserver_url=self.apiserver_url,
            auto_upgrades=self.auto_upgrades,
            autoscaler_configs=self.autoscaler_configs,
            cluster_id=self.cluster_id,
            cni=self.cni,
            created_at=self.created_at,
            description=self.description,
            feature_gates=self.feature_gates,
            id=self.id,
            kubeconfigs=self.kubeconfigs,
            name=self.name,
            open_id_connect_configs=self.open_id_connect_configs,
            organization_id=self.organization_id,
            project_id=self.project_id,
            region=self.region,
            status=self.status,
            tags=self.tags,
            type=self.type,
            updated_at=self.updated_at,
            upgrade_available=self.upgrade_available,
            version=self.version,
            wildcard_dns=self.wildcard_dns)


def get_kubernetes_cluster(cluster_id: Optional[str] = None,
                           name: Optional[str] = None,
                           region: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesClusterResult:
    """
    Gets information about a Kubernetes Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_key = scaleway.get_kubernetes_cluster(cluster_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str cluster_id: The cluster ID. Only one of `name` and `cluster_id` should be specified.
    :param str name: The cluster name. Only one of `name` and `cluster_id` should be specified.
    :param str region: `region`) The region in which the cluster exists.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult).value

    return AwaitableGetKubernetesClusterResult(
        admission_plugins=__ret__.admission_plugins,
        apiserver_cert_sans=__ret__.apiserver_cert_sans,
        apiserver_url=__ret__.apiserver_url,
        auto_upgrades=__ret__.auto_upgrades,
        autoscaler_configs=__ret__.autoscaler_configs,
        cluster_id=__ret__.cluster_id,
        cni=__ret__.cni,
        created_at=__ret__.created_at,
        description=__ret__.description,
        feature_gates=__ret__.feature_gates,
        id=__ret__.id,
        kubeconfigs=__ret__.kubeconfigs,
        name=__ret__.name,
        open_id_connect_configs=__ret__.open_id_connect_configs,
        organization_id=__ret__.organization_id,
        project_id=__ret__.project_id,
        region=__ret__.region,
        status=__ret__.status,
        tags=__ret__.tags,
        type=__ret__.type,
        updated_at=__ret__.updated_at,
        upgrade_available=__ret__.upgrade_available,
        version=__ret__.version,
        wildcard_dns=__ret__.wildcard_dns)


@_utilities.lift_output_func(get_kubernetes_cluster)
def get_kubernetes_cluster_output(cluster_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKubernetesClusterResult]:
    """
    Gets information about a Kubernetes Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_key = scaleway.get_kubernetes_cluster(cluster_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str cluster_id: The cluster ID. Only one of `name` and `cluster_id` should be specified.
    :param str name: The cluster name. Only one of `name` and `cluster_id` should be specified.
    :param str region: `region`) The region in which the cluster exists.
    """
    ...
