# 要件定義作成プロンプト集
## ゴール
`{prompt}`
上記を満たす要件定義書を作成してください。
以下の0〜8までで選択すること

### 0. クラス&関数 - 宣言型 - 要件定義書
- **目的と範囲**
- **機能要件**
  - 必要なクラスとそのクラスの責務
  - 各クラスのメソッド（関数）とその役割
  - クラス間の関係（継承、コンポジション等）
- **非機能要件**
  - ツールは最新のものを利用し、第２案、第３案も記述。メインで利用するものに関しては表で機能、利用パッケージ、特徴、理由などの列を記載して欲しい
- **制約事項**
- **テスト項目**
  - 単体テスト（各クラス、メソッドの動作確認）
  - 結合テスト（クラス間の連携動作確認）

### 1. 単機能 - 宣言型 - 要件定義書
- **目的と範囲**
- **機能要件**
- **非機能要件**
  - ツールは最新のものを利用し、第２案、第３案も記述。メインで利用するものに関しては表で機能、利用パッケージ、特徴、理由などの列を記載して欲しい
- **制約事項**
- **テスト項目**

### 2. 単機能 - 手続き型 - 要件定義書から手順書への変換
- **手順の概要**
- **必要な準備物やリソース**
- **手順の詳細な説明**
- **注意点や留意事項**
- **トラブルシューティングガイド**

### 3. プロジェクト - 宣言型 - 要件定義
- **プロジェクトの背景と目的**
- **範囲と制約事項**
- **機能要件と非機能要件**
- **ステークホルダーとその役割**
- **成功基準とプロジェクトの評価方法**
- **スケジュールとマイルストーン**

### 4. プロジェクト - 手続き型 - 要件定義書から設計書への変換
- **システムアーキテクチャ**
- **モジュール構成とインターフェース**
- **データモデルとデータフロー**
- **ユーザーインターフェース設計**
- **セキュリティ設計**
- **パフォーマンス設計**
- **テスト計画**

### 5. 業界 - 宣言型 - IT業界
- **コーディング規約と設計原則**
- **アジャイル開発手法の適用**
- **クラウドネイティブアーキテクチャの採用**
- **DevOps文化の醸成**
- **セキュリティとコンプライアンス**
- **パフォーマンスとスケーラビリティ**

### 6. 業界 - 手続き型 - IT業界
- **ソフトウェア開発ライフサイクルの各フェーズにおける手順**
- **マイクロサービスアーキテクチャの設計と実装**
- **CI/CDパイプラインの構築と運用**
- **アジャイルプロジェクト管理の実践**
- **セキュリティ対策の実装と監視**
- **パフォーマンスチューニングとスケーリング**

### 7. 世界 - 宣言型
- **社会の基本的な価値観と原則**
- **人権と自由の尊重**
- **平等と公正の実現**
- **持続可能な発展と環境保護**
- **平和と安全の維持**
- **教育と文化の振興**

### 8. 世界 - 手続き型
- **法律と規則の整備**
- **国家予算と財政計画の策定**
- **外交政策と安全保障戦略の立案**
- **教育制度と社会保障制度の改革**
- **市民参加と民主主義の強化**
- **国際協力とグローバルな課題への対応**

これらのプロンプトテンプレートを使用することで、様々な規模や抽象度に応じた宣言型と手続き型のドキュメント作成を支援できます。プロンプトの内容を適宜変更し、具体的な要件に合わせてカスタマイズしてください。
プロンプトから要件定義書（マークダウンファイル）を生成してください。