# Streamlit 簡易アプリの要件定義書
## ゴール: {prompt} Streamlit の簡易アプリをローカルに作る

## 1. 目的
{prompt}上記のゴールを満たすStreamlitアプリケーションの要件定義を記述してください:
    - ペルソナ
    - ユーザーストーリー

## 2. ファイル・フォルダ構成
    - Markdown形式で省略なしのファイル・フォルダ構成を記述してください
    - Streamlitアプリケーションのディレクトリ構成を記述
        ├── app.py: 全体を統合するpythonファイル
        ├── utils.py: 
        ├── templates/
        │   ├── header.py
        │   ├── sidebar.py
        │   └── footer.py
        ├── data/
        │   └── sample_data.csv
        └── requirements.txt


## 4. Streamlitコンポーネント
    - アプリケーションを構成する主要なStreamlitコンポーネントを列挙
    - 各コンポーネントの役割、入力と出力を記述してください

## 5. データの流れ
    - ユーザー入力からデータ処理、結果表示までのデータの流れを説明
    - 必要に応じてデータフローダイアグラムを作成

## 6. ユーザーインターフェース
    - アプリケーションの画面遷移図を作成
    - 各画面のワイヤーフレームまたはモックアップを用意
    - ユーザーインタラクションとイベントハンドリングについて説明

## 7. 開発環境
    - 使用するPythonのバージョン
    - 必要なライブラリとそのバージョン
    - venv仮想環境を構築

## 8. テスト
    - ユニットテストの方針を決定
    - 主要な機能についてテストケースを作成
    - テストデータの準備方法を説明

