# React + FastAPI アプリケーションの要件定義書
## ゴール: {prompt}
上記のゴールを満たすReact + FastAPIアプリケーションの要件を記述する

オブジェクト指向の原則に従って、以下の要件を含めて要件定義書を作成してください。

## 1. 目的
システムの全体的な目的を簡潔に説明してください。

## 2. ファイル・フォルダ構成
- Markdown形式で省略なしのファイル・フォルダ構成を記述
- フロントエンド(React)とバックエンド(FastAPI)のディレクトリ構成を分けて記述
- それぞれのDockerとdocker-compose.ymlを作成
- ダイアグラムを記載
├── diagrams/
│   ├── app_architecture.png
│   ├── sequence.png

![シーケンス図](diagrams/sequence.png)

## 3. アーキテクチャ図
![アーキテクチャ](diagrams/app_architecture.png)

## 3. APIエンドポイント
- FastAPIで実装するAPIエンドポイントを列挙
- 各エンドポイントのHTTPメソッド、パス、説明を記載

## 4. データモデル
- FastAPIで使用するデータモデル(SQLAlchemyモデル)を定義
- 各モデルの属性、リレーションシップを記述

## 5. Reactコンポーネント
- アプリケーションを構成する主要なReactコンポーネントを列挙
- 各コンポーネントの役割、propsとstateを記述

## 6. ユーザーインターフェース
- アプリケーションの画面遷移図を作成
- 各画面のワイヤーフレームまたはモックアップを用意
