# [システム名]の要件定義書
## ゴール: {prompt}
上記を満たす要件定義書を作成してください。

オブジェクト指向の原則に従って、以下の要件を含めて要件定義書を作成してください。

## 1. 目的
システムの全体的な目的を簡潔に説明してください。

## 2. ファイル・フォルダ構成
- Markdown形式で省略なしのディレクトリ、ファイル構成
- ルートディレクトリから下層のディレクトリの中の複数ファイル名まで網羅的に記載（内容は必要なし）
- 空のディレクトリを作らない

## 3. クラス図
システムを構成するクラスとそれらの関係を図示してください。各クラスには、以下の情報を含めてください:
クラス図は、関係性も含めてASCII文字で描いてください。
- **クラス名**
- **属性（フィールド）**
- **操作（メソッド）**
- **関連するクラスとの関係**（継承、コンポジション、集約など）

## 4. クラスの詳細
各クラスについて、以下の情報を提供してください:
- **クラス名**
- **説明**
- **属性（フィールド）の詳細**（名前、型、アクセス修飾子）
- **操作（メソッド）の詳細**（名前、引数、戻り値、アクセス修飾子、説明）
- **関連するクラスとの関係の詳細**

## 4. ユースケース
システムの主要なユースケースを列挙し、各ユースケースに関連するクラスとメソッドを指定してください。
## 5. シーケンス図
システムの主要な機能について、オブジェクト間の相互作用をシーケンス図で表現してください。各シーケンス図には、以下の情報を含めてください:
ユースケースごとに図をASCII文字で描いてください。
- **関連するオブジェクト**
- **オブジェクト間のメッセージ（メソッド呼び出し）**
- **メッセージの順序**
- **条件分岐やループなどの制御構造**

オブジェクト指向の原則（カプセル化、継承、ポリモーフィズムなど）を適切に使用し、クラス間の責務を明確に分離してください。また、設計パターンを適用することで、柔軟性と拡張性を高めるようにしてください。

システムの詳細な仕様については、[追加の情報]を参照してください。
