# [システム名]のAWSアーキテクチャ設計書
## ゴール: {prompt}
上記を満たすAWSアーキテクチャ設計書を作成してください。

AWSのベストプラクティスに従って、以下の要件を含めてAWSアーキテクチャ設計書を作成してください。

## 1. 目的
システムの全体的な目的と、AWSを使用する理由を簡潔に説明してください。

## 2. ファイル・フォルダ構成
- Markdown形式で省略なしのディレクトリ、ファイル構成
- ルートディレクトリから下層のディレクトリの中の複数ファイル名まで網羅的に記載（内容は必要なし）
- 空のディレクトリを作らない
- frontend/
- backend/
- infra/
- tests/
- assets/images/

## 2. AWSアーキテクチャ概要図
![](./assets/images/aws_architecture.png)

## 3. AWSサービスの選択
使用するAWSサービスとその理由を説明してください。以下の情報を含めてください:
- **サービス名**
- **用途**
- **選択理由**

## 4. 各AWSサービスの設定
使用するAWSサービスごとに、以下の情報を提供してください:
- **サービス名**
- **主要な設定項目とその値**
- **設定理由**

## 5. ネットワーク構成
VPC、サブネット、セキュリティグループ、NACLなどのネットワーク構成について説明してください。
- **VPCのCIDRブロック**
- **サブネットの種類とCIDRブロック**
- **セキュリティグループのインバウンド/アウトバウンドルール**
- **NACLのインバウンド/アウトバウンドルール**

## 6. 可用性と耐障害性
マルチAZ構成、オートスケーリング、ロードバランシングなどを活用し、システムの可用性と耐障害性を向上させる方法を説明してください。

## 7. セキュリティ対策
IAMによるアクセス制御、暗号化、WAFなどを活用し、システムのセキュリティを確保する方法を説明してください。

## 8. 運用・保守
CloudWatch、CloudTrail、AWS Configなどを活用し、システムの監視、ログ管理、構成管理を行う方法を説明してください。

AWSのベストプラクティスに基づき、スケーラビリティ、可用性、セキュリティ、運用効率を考慮したアーキテクチャを設計してください。
また、コスト最適化の観点から、適切なインスタンスタイプの選択、リザーブドインスタンスの活用、不要なリソースの削除などについても検討してください。

システムの詳細な要件については、[追加の情報]を参照してください。
