"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CloudFrontToMediaStore extends constructs_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: aws_cdk_lib_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${aws_cdk_lib_1.Aws.PARTITION}:mediastore:${aws_cdk_lib_1.Aws.REGION}:${aws_cdk_lib_1.Aws.ACCOUNT_ID}:container/${aws_cdk_lib_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    StringEquals: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                                    },
                                    Bool: {
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        [this.cloudFrontWebDistribution, this.cloudFrontLoggingBucket, this.cloudFrontOriginRequestPolicy, this.cloudFrontFunction]
            = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.cloudFrontLoggingBucketProps);
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "2.0.0-rc.2" };
//# sourceMappingURL=data:application/json;base64,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