"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserVpcAuthorization = exports.UserVpcAuthorizationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pvtz_generated_1 = require("./pvtz.generated");
Object.defineProperty(exports, "UserVpcAuthorizationProperty", { enumerable: true, get: function () { return pvtz_generated_1.RosUserVpcAuthorization; } });
/**
 * A ROS resource type:  `ALIYUN::PVTZ::UserVpcAuthorization`
 */
class UserVpcAuthorization extends ros.Resource {
    /**
     * Create a new `ALIYUN::PVTZ::UserVpcAuthorization`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUserVpcAuthorization = new pvtz_generated_1.RosUserVpcAuthorization(this, id, {
            authCode: props.authCode,
            authChannel: props.authChannel,
            authorizedUserId: props.authorizedUserId,
            authType: props.authType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUserVpcAuthorization;
        this.attrAuthType = rosUserVpcAuthorization.attrAuthType;
        this.attrAuthorizedUserId = rosUserVpcAuthorization.attrAuthorizedUserId;
    }
}
exports.UserVpcAuthorization = UserVpcAuthorization;
//# sourceMappingURL=data:application/json;base64,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