/*
 * Decompiled with CFR 0.152.
 */
package zingg.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.storage.StorageLevel;
import zingg.client.ZinggClientException;
import zingg.model.Model;

public class ModelUtil {
    public static final Log LOG = LogFactory.getLog(ModelUtil.class);

    public static Model createModel(Dataset<Row> positives, Dataset<Row> negatives, Model model, SparkSession spark) throws Exception, ZinggClientException {
        LOG.info("Learning similarity rules");
        Dataset posLabeledPointsWithLabel = positives.withColumn("z_isMatch", functions.lit((Object)1));
        posLabeledPointsWithLabel = posLabeledPointsWithLabel.persist(StorageLevel.MEMORY_ONLY());
        posLabeledPointsWithLabel = posLabeledPointsWithLabel.drop("z_prediction");
        Dataset negLabeledPointsWithLabel = negatives.withColumn("z_isMatch", functions.lit((Object)0));
        negLabeledPointsWithLabel = negLabeledPointsWithLabel.persist(StorageLevel.MEMORY_ONLY());
        negLabeledPointsWithLabel = negLabeledPointsWithLabel.drop("z_prediction");
        if (LOG.isDebugEnabled()) {
            LOG.debug(" +,-,Total labeled data " + posLabeledPointsWithLabel.count() + ", " + negLabeledPointsWithLabel.count());
        }
        model.register(spark);
        model.fit((Dataset<Row>)posLabeledPointsWithLabel, (Dataset<Row>)negLabeledPointsWithLabel);
        return model;
    }
}

