/*
 * Decompiled with CFR 0.152.
 */
package zingg.util;

import java.util.List;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.types.DataType;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import zingg.ZinggBase;
import zingg.client.util.ListMap;
import zingg.hash.HashFnFromConf;
import zingg.hash.HashFunction;
import zingg.hash.HashFunctionRegistry;

public class HashUtil {
    public static ListMap<DataType, HashFunction> getHashFunctionList(String fileName, SparkSession spark) throws Exception {
        ListMap<DataType, HashFunction> functions2 = new ListMap<DataType, HashFunction>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        List scriptArgs = (List)mapper.readValue(ZinggBase.class.getResourceAsStream("/" + fileName), (TypeReference)new TypeReference<List<HashFnFromConf>>(){});
        for (HashFnFromConf scriptArg : scriptArgs) {
            HashFunction fn = HashFunctionRegistry.getFunction(scriptArg.getName());
            spark.udf().register(fn.getName(), (UDF1)fn, fn.getReturnType());
            functions2.add(fn.getDataType(), fn);
        }
        return functions2;
    }
}

