/*
 * Decompiled with CFR 0.152.
 */
package zingg.util;

import java.util.ArrayList;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.graphframes.GraphFrame;
import scala.collection.Iterator;
import scala.collection.JavaConverters;

public class GraphUtil {
    public static Dataset<Row> buildGraph(Dataset<Row> vertices, Dataset<Row> edges) {
        vertices = vertices.withColumnRenamed("id", "z_id");
        Dataset v1 = vertices.withColumnRenamed("z_zid", "id");
        Dataset v = v1.select("id", new String[0]).cache();
        ArrayList<Column> cols = new ArrayList<Column>();
        cols.add(edges.col("z_zid"));
        cols.add(edges.col("z_z_zid"));
        Dataset e = edges.select(((Iterator)JavaConverters.asScalaIteratorConverter(cols.iterator()).asScala()).toSeq());
        e = e.toDF(new String[]{"src", "dst"}).cache();
        GraphFrame gf = new GraphFrame((Dataset<Row>)v, (Dataset<Row>)e);
        Dataset returnGraph = gf.connectedComponents().run().cache();
        returnGraph = returnGraph.join(vertices, returnGraph.col("id").equalTo((Object)vertices.col("z_zid")));
        returnGraph = returnGraph.drop("z_zid").withColumnRenamed("id", "z_zid");
        returnGraph = returnGraph.withColumnRenamed("component", "z_cluster");
        returnGraph = returnGraph.withColumnRenamed("z_id", "id");
        return returnGraph;
    }
}

